"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import sip


class QDBusVariant(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qdbusvariant.html

    **Detailed Description**

    A D-Bus function that takes an integer, a D-Bus variant and a string as
    parameters can be called with the following argument list (see
    **QDBusMessage::setArguments** ()):

    **QList** <**QVariant** > arguments;
            arguments << **QVariant** (42)
    << **QVariant** ::fromValue(**QDBusVariant** (43)) << **QVariant**
    ("hello");
            myDBusMessage.setArguments(arguments);

    When a D-Bus function returns a D-Bus variant, it can be retrieved as
    follows:

    // call a D-Bus function that returns a D-Bus variant
            **QVariant**
    v = callMyDBusFunction();
            // retrieve the D-Bus variant
    **QDBusVariant**  dbusVariant = qvariant_cast<**QDBusVariant** >(v);
    // retrieve the actual value stored in the D-Bus variant
    **QVariant**  result = dbusVariant.variant();

    The **QVariant**  within a QDBusVariant is required to distinguish between a
    normal D-Bus value and a value within a D-Bus variant.

    **See also** **The Qt D-Bus Type System** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qdbusvariant.html#QDBusVariant

        **QDBusVariant::QDBusVariant()**

        Constructs a new D-Bus variant.
        """
        ...

    @typing.overload
    def __init__(self, dBusVariant: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qdbusvariant.html#QDBusVariant-1

        **QDBusVariant::QDBusVariant(const QVariant & variant )**

        Constructs a new D-Bus variant from the given Qt **variant**.

        **See also** **setVariant** ().
        """
        ...

    @typing.overload
    def __init__(self, a0: "QDBusVariant") -> None:
        """
        https://doc.qt.io/qt-5/qdbusvariant.html#QDBusVariant

        **QDBusVariant::QDBusVariant()**

        Constructs a new D-Bus variant.
        """
        ...

    def swap(self, other: "QDBusVariant") -> None:
        """
        https://doc.qt.io/qt-5/qdbusvariant.html#swap

        **void QDBusVariant::swap(QDBusVariant & other )**

        Swaps this **QDBusVariant**  instance with **other**.
        """
        ...

    def setVariant(self, dBusVariant: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qdbusvariant.html#setVariant

        **void QDBusVariant::setVariant(const QVariant & variant )**

        Assigns the value of the given Qt **variant** to this D-Bus variant.

        **See also** **variant** ().
        """
        ...

    def variant(self) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qdbusvariant.html#variant

        **QVariant QDBusVariant::variant() const**

        Returns this D-Bus variant as a **QVariant**  object.

        **See also** **setVariant** ().
        """
        ...
