"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtDBus import *
from PyQt5 import sip


class QDBusReply(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qdbusreply.html

    **Detailed Description**

    A QDBusReply object is a subset of the **QDBusMessage**  object that
    represents a method call's reply. It contains only the first output argument
    or the error code and is used by **QDBusInterface** -derived classes to
    allow returning the error code as the function's return argument.

    It can be used in the following manner:

    **QDBusReply** <**QString** > reply = interface->call("RemoteMethod");
    if (reply.isValid())
            // use the returned value
    useValue(reply.value());
        else
            // call failed. Show an error
    condition.
            showError(reply.error());

    If the remote method call cannot fail, you can skip the error checking:

    **QString**  reply = interface->call("RemoteMethod");

    However, if it does fail under those conditions, the value returned by
    QDBusReply<T>::value() is a default-constructed value. It may be
    indistinguishable from a valid return value.

    QDBusReply objects are used for remote calls that have no output arguments
    or return values (i.e., they have a "void" return type). Use the **isValid**
    () function to test if the reply succeeded.

    **See also** **QDBusMessage**  and **QDBusInterface** .
    """

    @typing.overload
    def __init__(self, reply: QDBusMessage) -> None:
        """
        https://doc.qt.io/qt-5/qdbusreply.html#QDBusReply

        **QDBusReply::QDBusReply(const QDBusMessage & reply )**

        Automatically construct a QDBusReply object from the reply message
        **reply** , extracting the first return value from it if it is a success
        reply.
        """
        ...

    @typing.overload
    def __init__(self, call: QDBusPendingCall) -> None:
        """
        https://doc.qt.io/qt-5/qdbusreply.html#QDBusReply-1

        **QDBusReply::QDBusReply(const QDBusReply<T> & other )**

        Constructs a copy of **other**.

        This function was introduced in Qt 5.15.
        """
        ...

    @typing.overload
    def __init__(self, error: QDBusError) -> None:
        """
        https://doc.qt.io/qt-5/qdbusreply.html#QDBusReply-2

        **QDBusReply::QDBusReply(const QDBusPendingCall & pcall )**

        Automatically construct a QDBusReply object from the asynchronous
        pending call **pcall**. If the call isn't finished yet, QDBusReply will
        call QDBusPendingCall::waitForFinished(), which is a blocking operation.

        If the return types patch, QDBusReply will extract the first return
        argument from the reply.
        """
        ...

    @typing.overload
    def __init__(self, other: "QDBusReply") -> None:
        """
        https://doc.qt.io/qt-5/qdbusreply.html#QDBusReply-3

        **QDBusReply::QDBusReply(const QDBusPendingReply<T> & reply )**

        Constructs a QDBusReply object from the pending reply message,
        **reply**.
        """
        ...

    def value(self, type: typing.Any = ...) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qdbusreply.html#value

        **QDBusReply::Type QDBusReply::value() const**

        Returns the remote function's calls return value. If the remote call
        returned with an error, the return value of this function is undefined
        and may be undistinguishable from a valid return value.

        This function is not available if the remote call returns `void`.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdbusreply.html#isValid

        **bool QDBusReply::isValid() const**

        Returns `true` if no error occurred; otherwise, returns `false`.

        **See also** **error** ().
        """
        ...

    def error(self) -> QDBusError:
        """
        https://doc.qt.io/qt-5/qdbusreply.html#error

        **const QDBusError &QDBusReply::error() const**

        Returns the error code that was returned from the remote function call.
        If the remote call did not return an error (i.e., if it succeeded), then
        the **QDBusError**  object that is returned will not be a valid error
        code (**QDBusError::isValid** () will return false).

        **See also** **isValid** ().
        """
        ...
