"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtDBus import *


class QDBusInterface(QDBusAbstractInterface):
    """
    https://doc.qt.io/qt-5/qdbusinterface.html

    **Detailed Description**

    QDBusInterface is a generic accessor class that is used to place calls to
    remote objects, connect to signals exported by remote objects and get/set
    the value of remote properties. This class is useful for dynamic access to
    remote objects: that is, when you do not have a generated code that
    represents the remote interface.

    Calls are usually placed by using the **call** () function, which constructs
    the message, sends it over the bus, waits for the reply and decodes the
    reply. Signals are connected to by using the normal **QObject::connect** ()
    function. Finally, properties are accessed using the **QObject::property**
    () and **QObject::setProperty** () functions.

    The following code snippet demonstrates how to perform a mathematical
    operation of `"2 + 2"` in a remote application called
    `com.example.Calculator`, accessed via the session bus.

    QDBusInterface remoteApp( "com.example.Calculator",
    "/Calculator/Operations",
    "org.mathematics.RPNCalculator" );
        remoteApp.call( "PushOperand", 2 );
    remoteApp.call( "PushOperand", 2 );
        remoteApp.call( "ExecuteOperation",
    "+" );
        **QDBusReply** <int> reply = remoteApp.call( "PopOperand" );
    if ( reply.isValid() )
            printf( "%d", reply.value() );          //
    prints 4

    **See also** **Qt D-Bus XML compiler (qdbusxml2cpp)** .
    """

    def __init__(
        self,
        service: str,
        path: str,
        interface: str = ...,
        connection: QDBusConnection = ...,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qdbusinterface.html#QDBusInterface-1

        **QDBusInterface::QDBusInterface(const QString & service , const QString
        & path , const QString & interface = QString(), const QDBusConnection &
        connection = QDBusConnection::sessionBus(), QObject * parent =
        nullptr)**

        Creates a dynamic QDBusInterface object associated with the interface
        **interface** on object at path **path** on service **service** , using
        the given **connection**. If **interface** is an empty string, the
        object created will refer to the merging of all interfaces found by
        introspecting that object. Otherwise if **interface** is not empty, the
        QDBusInterface object will be cached to speedup further creations of the
        same interface.

        **parent** is passed to the base class constructor.

        If the remote service **service** is not present or if an error occurs
        trying to obtain the description of the remote interface **interface** ,
        the object created will not be valid (see **isValid** ()).
        """
        ...
