"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5.QtCore import *
from PyQt5 import sip


class QXmlStreamAttributes(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qxmlstreamattributes.html

    **Detailed Description**

    Attributes are returned by a **QXmlStreamReader**  in **attributes()**  when
    the reader reports a **start element** . The class can also be used with a
    **QXmlStreamWriter**  as an argument to **writeAttributes()** .

    The convenience function **value** () loops over the vector and returns an
    attribute value for a given namespaceUri and an attribute's name.

    New attributes can be added with **append** ().
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qxmlstreamattributes.html#QXmlStreamAttributes

        **QXmlStreamAttributes::QXmlStreamAttributes()**

        A constructor for QXmlStreamAttributes.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QXmlStreamAttributes") -> None:
        """
        https://doc.qt.io/qt-5/qxmlstreamattributes.html#QXmlStreamAttributes

        **QXmlStreamAttributes::QXmlStreamAttributes()**

        A constructor for QXmlStreamAttributes.
        """
        ...

    def __contains__(self, value: QXmlStreamAttribute) -> int:
        ...

    @typing.overload
    def __delitem__(self, i: int) -> None:
        ...

    @typing.overload
    def __delitem__(self, slice: slice) -> None:
        ...

    @typing.overload
    def __setitem__(self, i: int, value: QXmlStreamAttribute) -> None:
        ...

    @typing.overload
    def __setitem__(self, slice: slice, list: "QXmlStreamAttributes") -> None:
        ...

    @typing.overload
    def __getitem__(self, i: int) -> QXmlStreamAttribute:
        ...

    @typing.overload
    def __getitem__(self, slice: slice) -> "QXmlStreamAttributes":
        ...

    def size(self) -> int:
        ...

    def replace(self, i: int, value: QXmlStreamAttribute) -> None:
        ...

    @typing.overload
    def remove(self, i: int) -> None:
        ...

    @typing.overload
    def remove(self, i: int, count: int) -> None:
        ...

    def prepend(self, value: QXmlStreamAttribute) -> None:
        ...

    def lastIndexOf(self, value: QXmlStreamAttribute, from_: int = ...) -> int:
        ...

    def last(self) -> QXmlStreamAttribute:
        ...

    def isEmpty(self) -> bool:
        ...

    def insert(self, i: int, value: QXmlStreamAttribute) -> None:
        ...

    def indexOf(self, value: QXmlStreamAttribute, from_: int = ...) -> int:
        ...

    def first(self) -> QXmlStreamAttribute:
        ...

    def fill(self, value: QXmlStreamAttribute, size: int = ...) -> None:
        ...

    def data(self) -> PyQt5.sip.voidptr:
        ...

    def __len__(self) -> int:
        ...

    @typing.overload
    def count(self, value: QXmlStreamAttribute) -> int:
        ...

    @typing.overload
    def count(self) -> int:
        ...

    def contains(self, value: QXmlStreamAttribute) -> bool:
        ...

    def clear(self) -> None:
        ...

    def at(self, i: int) -> QXmlStreamAttribute:
        ...

    @typing.overload
    def hasAttribute(self, qualifiedName: str) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlstreamattributes.html#hasAttribute

        **bool QXmlStreamAttributes::hasAttribute(const QString & qualifiedName
        ) const**

        Returns `true` if this **QXmlStreamAttributes**  has an attribute whose
        qualified name is **qualifiedName** ; otherwise returns `false`.

        Note that this is not namespace aware. For instance, if this
        **QXmlStreamAttributes**  contains an attribute whose lexical name is
        "xlink:href" this doesn't tell that an attribute named `href` in the
        XLink namespace is present, since the `xlink` prefix can be bound to any
        namespace. Use the overload that takes a namespace URI and a local name
        as parameter, for namespace aware code.

        This function was introduced in Qt 4.5.
        """
        ...

    @typing.overload
    def hasAttribute(self, namespaceUri: str, name: str) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlstreamattributes.html#hasAttribute-1

        **bool QXmlStreamAttributes::hasAttribute(QLatin1String qualifiedName )
        const**

        This is an overloaded function.

        This function was introduced in Qt 4.5.
        """
        ...

    @typing.overload
    def append(self, namespaceUri: str, name: str, value: str) -> None:
        """
        https://doc.qt.io/qt-5/qxmlstreamattributes.html#append

        **void QXmlStreamAttributes::append(const QString & namespaceUri , const
        QString & name , const QString & value )**

        Appends a new attribute with **name** in the namespace described with
        **namespaceUri** , and value **value**. The **namespaceUri** can be
        empty.
        """
        ...

    @typing.overload
    def append(self, qualifiedName: str, value: str) -> None:
        """
        https://doc.qt.io/qt-5/qxmlstreamattributes.html#append-1

        **void QXmlStreamAttributes::append(const QString & qualifiedName ,
        const QString & value )**

        This is an overloaded function.

        Appends a new attribute with qualified name **qualifiedName** and value
        **value**.
        """
        ...

    @typing.overload
    def append(self, attribute: QXmlStreamAttribute) -> None:
        """
        https://doc.qt.io/qt-5/qxmlstreamattributes.html#append

        **void QXmlStreamAttributes::append(const QString & namespaceUri , const
        QString & name , const QString & value )**

        Appends a new attribute with **name** in the namespace described with
        **namespaceUri** , and value **value**. The **namespaceUri** can be
        empty.
        """
        ...

    @typing.overload
    def value(self, namespaceUri: str, name: str) -> str:
        """
        https://doc.qt.io/qt-5/qxmlstreamattributes.html#value

        **QStringRef QXmlStreamAttributes::value(const QString & namespaceUri ,
        const QString & name ) const**

        Returns the value of the attribute **name** in the namespace described
        with **namespaceUri** , or an empty string reference if the attribute is
        not defined. The **namespaceUri** can be empty.
        """
        ...

    @typing.overload
    def value(self, qualifiedName: str) -> str:
        """
        https://doc.qt.io/qt-5/qxmlstreamattributes.html#value-1

        **QStringRef QXmlStreamAttributes::value(const QString & namespaceUri ,
        QLatin1String name ) const**

        This is an overloaded function.

        Returns the value of the attribute **name** in the namespace described
        with **namespaceUri** , or an empty string reference if the attribute is
        not defined. The **namespaceUri** can be empty.
        """
        ...
