"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QWaitCondition(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qwaitcondition.html

    **Detailed Description**

    QWaitCondition allows a thread to tell other threads that some sort of
    condition has been met. One or many threads can block waiting for a
    QWaitCondition to set a condition with **wakeOne** () or **wakeAll** (). Use
    **wakeOne** () to wake one randomly selected thread or **wakeAll** () to
    wake them all.

    For example, let's suppose that we have three tasks that should be performed
    whenever the user presses a key. Each task could be split into a thread,
    each of which would have a **run()**  body like this:

    forever {
            mutex.lock();
            keyPressed.wait(&mutex);
    do_something();
            mutex.unlock();
        }

    Here, the `keyPressed` variable is a global variable of type QWaitCondition.

    A fourth thread would read key presses and wake the other three threads up
    every time it receives one, like this:

    forever {
            getchar();
            keyPressed.wakeAll();
        }

    The order in which the three threads are woken up is undefined. Also, if
    some of the threads are still in `do_something()` when the key is pressed,
    they won't be woken up (since they're not waiting on the condition variable)
    and so the task will not be performed for that key press. This issue can be
    solved using a counter and a **QMutex**  to guard it. For example, here's
    the new code for the worker threads:

    forever {
            mutex.lock();
            keyPressed.wait(&mutex);
    ++count;
            mutex.unlock();

            do_something();
    mutex.lock();
            --count;
            mutex.unlock();
        }

    Here's the code for the fourth thread:

    forever {
            getchar();

            mutex.lock();
            // Sleep
    until there are no busy worker threads
            while (count > 0) {
    mutex.unlock();
                sleep(1);
                mutex.lock();
            }
    keyPressed.wakeAll();
            mutex.unlock();
        }

    The mutex is necessary because the results of two threads attempting to
    change the value of the same variable simultaneously are unpredictable.

    Wait conditions are a powerful thread synchronization primitive. The **Wait
    Conditions Example**  example shows how to use QWaitCondition as an
    alternative to **QSemaphore**  for controlling access to a circular buffer
    shared by a producer thread and a consumer thread.

    **See also** **QMutex** , **QSemaphore** , **QThread** , and **Wait
    Conditions Example** .
    """

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qwaitcondition.html#QWaitCondition

        **QWaitCondition::QWaitCondition()**

        Constructs a new wait condition object.
        """
        ...

    def wakeAll(self) -> None:
        """
        https://doc.qt.io/qt-5/qwaitcondition.html#wakeAll

        **void QWaitCondition::wakeAll()**

        Wakes all threads waiting on the wait condition. The order in which the
        threads are woken up depends on the operating system's scheduling
        policies and cannot be controlled or predicted.

        **See also** **wakeOne** ().
        """
        ...

    def wakeOne(self) -> None:
        """
        https://doc.qt.io/qt-5/qwaitcondition.html#wakeOne

        **void QWaitCondition::wakeOne()**

        Wakes one thread waiting on the wait condition. The thread that is woken
        up depends on the operating system's scheduling policies, and cannot be
        controlled or predicted.

        If you want to wake up a specific thread, the solution is typically to
        use different wait conditions and have different threads wait on
        different conditions.

        **See also** **wakeAll** ().
        """
        ...

    @typing.overload
    def wait(self, mutex: QMutex, msecs: int = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qwaitcondition.html#wait

        **bool QWaitCondition::wait(QMutex * lockedMutex , QDeadlineTimer
        deadline = QDeadlineTimer(QDeadlineTimer::Forever))**

        Releases the **lockedMutex** and waits on the wait condition. The
        **lockedMutex** must be initially locked by the calling thread. If
        **lockedMutex** is not in a locked state, the behavior is undefined. If
        **lockedMutex** is a recursive mutex, this function returns immediately.
        The **lockedMutex** will be unlocked, and the calling thread will block
        until either of these conditions is met:

        * Another thread signals it using **wakeOne** () or **wakeAll** (). This
        function will return true in this case.
          * the deadline given by
        **deadline** is reached. If **deadline** is `QDeadlineTimer::Forever`
        (the default), then the wait will never timeout (the event must be
        signalled). This function will return false if the wait timed out.

        The **lockedMutex** will be returned to the same locked state. This
        function is provided to allow the atomic transition from the locked
        state to the wait state.

        This function was introduced in Qt 5.12.

        **See also** **wakeOne** () and **wakeAll** ().
        """
        ...

    @typing.overload
    def wait(self, lockedMutex: QMutex, deadline: QDeadlineTimer) -> bool:
        """
        https://doc.qt.io/qt-5/qwaitcondition.html#wait-1

        **bool QWaitCondition::wait(QMutex * lockedMutex , unsigned long time
        )**

        This is an overloaded function.
        """
        ...

    @typing.overload
    def wait(self, readWriteLock: QReadWriteLock, msecs: int = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qwaitcondition.html#wait-2

        **bool QWaitCondition::wait(QReadWriteLock * lockedReadWriteLock ,
        QDeadlineTimer deadline = QDeadlineTimer(QDeadlineTimer::Forever))**

        Releases the **lockedReadWriteLock** and waits on the wait condition.
        The **lockedReadWriteLock** must be initially locked by the calling
        thread. If **lockedReadWriteLock** is not in a locked state, this
        function returns immediately. The **lockedReadWriteLock** must not be
        locked recursively, otherwise this function will not release the lock
        properly. The **lockedReadWriteLock** will be unlocked, and the calling
        thread will block until either of these conditions is met:

        * Another thread signals it using **wakeOne** () or **wakeAll** (). This
        function will return true in this case.
          * the deadline given by
        **deadline** is reached. If **deadline** is `QDeadlineTimer::Forever`
        (the default), then the wait will never timeout (the event must be
        signalled). This function will return false if the wait timed out.

        The **lockedReadWriteLock** will be returned to the same locked state.
        This function is provided to allow the atomic transition from the locked
        state to the wait state.

        This function was introduced in Qt 5.12.

        **See also** **wakeOne** () and **wakeAll** ().
        """
        ...

    @typing.overload
    def wait(
        self, lockedReadWriteLock: QReadWriteLock, deadline: QDeadlineTimer
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qwaitcondition.html#wait-3

        **bool QWaitCondition::wait(QReadWriteLock * lockedReadWriteLock ,
        unsigned long time )**

        This is an overloaded function.
        """
        ...
