"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QVariant(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qvariant.html

    **Detailed Description**

    Because C++ forbids unions from including types that have non-default
    constructors or destructors, most interesting Qt classes cannot be used in
    unions. Without QVariant, this would be a problem for **QObject::property**
    () and for database work, etc.

    A QVariant object holds a single value of a single **type** () at a time.
    (Some **type** ()s are multi-valued, for example a string list.) You can
    find out what type, T, the variant holds, convert it to a different type
    using **convert** (), get its value using one of the toT() functions (e.g.,
    **toSize** ()) and check whether the type can be converted to a particular
    type using **canConvert** ().

    The methods named toT() (e.g., **toInt** (), **toString** ()) are const. If
    you ask for the stored type, they return a copy of the stored object. If you
    ask for a type that can be generated from the stored type, toT() copies and
    converts and leaves the object itself unchanged. If you ask for a type that
    cannot be generated from the stored type, the result depends on the type;
    see the function documentation for details.

    Here is some example code to demonstrate the use of QVariant:

    **QDataStream**  out(...);
        **QVariant**  v(123);                // The
    variant now contains an int
        int x = v.toInt();              // x = 123
    out << v;                       // Writes a type tag and an int to out
        v
    = **QVariant** ("hello");          // The variant now contains a QByteArray
    v = **QVariant** (tr("hello"));      // The variant now contains a QString
    int y = v.toInt();              // y = 0 since v cannot be converted to an
    int
        **QString**  s = v.toString();       // s = tr("hello")  (see
    QObject::tr())
        out << v;                       // Writes a type tag and
    a QString to out
        ...
        **QDataStream**  in(...);            //
    (opening the previously written stream)
        in >> v;
    // Reads an Int variant
        int z = v.toInt();              // z = 123
    **qDebug** ("Type is %s",            // prints "Type is int"
    v.typeName());
        v = v.toInt() + 100;            // The variant now hold
    the value 223
        v = **QVariant** (**QStringList** ());

    You can even store **QList** <QVariant> and **QMap** <**QString** ,
    QVariant> values in a variant, so you can easily construct arbitrarily
    complex data structures of arbitrary types. This is very powerful and
    versatile, but may prove less memory and speed efficient than storing
    specific types in standard data structures.

    QVariant also supports the notion of null values, where you can have a
    defined type with no value set. However, note that QVariant types can only
    be cast when they have had a value set.

    **QVariant**  x, y(**QString** ()), z(**QString** (""));
    x.convert(**QVariant** ::Int);
        // x.isNull() == true
        // y.isNull()
    == true, z.isNull() == false

    QVariant can be extended to support other types than those mentioned in the
    **Type**  enum. See **Creating Custom Qt Types**  for details.

    **A Note on GUI Types**

    Because QVariant is part of the Qt Core module, it cannot provide conversion
    functions to data types defined in Qt GUI, such as **QColor** , **QImage** ,
    and **QPixmap** . In other words, there is no `toColor()` function. Instead,
    you can use the **QVariant::value** () or the **qvariant_cast** () template
    function. For example:

    **QVariant**  variant;
        ...
        **QColor**  color =
    variant.value<**QColor** >();

    The inverse conversion (e.g., from **QColor**  to QVariant) is automatic for
    all data types supported by QVariant, including GUI-related types:

    **QColor**  color = palette().background().color();
        **QVariant**
    variant = color;

    **Using canConvert() and convert() Consecutively**

    When using **canConvert** () and **convert** () consecutively, it is
    possible for **canConvert** () to return true, but **convert** () to return
    false. This is typically because **canConvert** () only reports the general
    ability of QVariant to convert between types given suitable data; it is
    still possible to supply data which cannot actually be converted.

    For example, **canConvert** (Int) would return true when called on a variant
    containing a string because, in principle, QVariant is able to convert
    strings of numbers to integers. However, if the string contains non-numeric
    characters, it cannot be converted to an integer, and any attempt to convert
    it will fail. Hence, it is important to have both functions return true for
    a successful conversion.

    **See also** **QMetaType** .
    """

    class Type(int):
        Invalid: QVariant = ...
        Bool: QVariant = ...
        Int: QVariant = ...
        UInt: QVariant = ...
        LongLong: QVariant = ...
        ULongLong: QVariant = ...
        Double: QVariant = ...
        Char: QVariant = ...
        Map: QVariant = ...
        List: QVariant = ...
        String: QVariant = ...
        StringList: QVariant = ...
        ByteArray: QVariant = ...
        BitArray: QVariant = ...
        Date: QVariant = ...
        Time: QVariant = ...
        DateTime: QVariant = ...
        Url: QVariant = ...
        Locale: QVariant = ...
        Rect: QVariant = ...
        RectF: QVariant = ...
        Size: QVariant = ...
        SizeF: QVariant = ...
        Line: QVariant = ...
        LineF: QVariant = ...
        Point: QVariant = ...
        PointF: QVariant = ...
        RegExp: QVariant = ...
        Font: QVariant = ...
        Pixmap: QVariant = ...
        Brush: QVariant = ...
        Color: QVariant = ...
        Palette: QVariant = ...
        Icon: QVariant = ...
        Image: QVariant = ...
        Polygon: QVariant = ...
        Region: QVariant = ...
        Bitmap: QVariant = ...
        Cursor: QVariant = ...
        SizePolicy: QVariant = ...
        KeySequence: QVariant = ...
        Pen: QVariant = ...
        TextLength: QVariant = ...
        TextFormat: QVariant = ...
        Matrix: QVariant = ...
        Transform: QVariant = ...
        Hash: QVariant = ...
        Matrix4x4: QVariant = ...
        Vector2D: QVariant = ...
        Vector3D: QVariant = ...
        Vector4D: QVariant = ...
        Quaternion: QVariant = ...
        EasingCurve: QVariant = ...
        Uuid: QVariant = ...
        ModelIndex: QVariant = ...
        PolygonF: QVariant = ...
        RegularExpression: QVariant = ...
        PersistentModelIndex: QVariant = ...
        UserType: QVariant = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qvariant.html#QVariant

        **QVariant::QVariant()**

        Constructs an invalid variant.
        """
        ...

    @typing.overload
    def __init__(self, type: "QVariant.Type") -> None:
        """
        https://doc.qt.io/qt-5/qvariant.html#QVariant-1

        **QVariant::QVariant(QVariant::Type type )**

        Constructs an uninitialized variant of type **type**. This will create a
        variant in a special null state that if accessed will return a default
        constructed value of the **type**.

        **See also** **isNull** ().
        """
        ...

    @typing.overload
    def __init__(self, obj: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qvariant.html#QVariant-2

        **QVariant::QVariant(int typeId , const void * copy )**

        Constructs variant of type **typeId** , and initializes with **copy** if
        **copy** is not `nullptr`.

        Note that you have to pass the address of the variable you want stored.

        Usually, you never have to use this constructor, use
        **QVariant::fromValue** () instead to construct variants from the
        pointer types represented by `QMetaType::VoidStar`, and
        `QMetaType::QObjectStar`.

        **See also** **QVariant::fromValue** () and **QMetaType::Type** .
        """
        ...

    @typing.overload
    def __init__(self, a0: "QVariant") -> None:
        """
        https://doc.qt.io/qt-5/qvariant.html#QVariant-3

        **QVariant::QVariant(QDataStream & s )**

        Reads the variant from the data stream, **s**.
        """
        ...

    def swap(self, other: "QVariant") -> None:
        """
        https://doc.qt.io/qt-5/qvariant.html#swap

        **void QVariant::swap(QVariant & other )**

        Swaps variant **other** with this variant. This operation is very fast
        and never fails.

        This function was introduced in Qt 4.8.
        """
        ...

    @staticmethod
    def nameToType(name: str) -> "QVariant.Type":
        """
        https://doc.qt.io/qt-5/qvariant.html#nameToType

        **[static] QVariant::Type QVariant::nameToType(const char * name )**

        Converts the string representation of the storage type given in **name**
        , to its enum representation.

        If the string representation cannot be converted to any enum
        representation, the variant is set to `Invalid`.
        """
        ...

    @staticmethod
    def typeToName(typeId: int) -> str:
        """
        https://doc.qt.io/qt-5/qvariant.html#typeToName

        **[static] const char *QVariant::typeToName(int typeId )**

        Converts the int representation of the storage type, **typeId** , to its
        string representation.

        Returns `nullptr` if the type is **QMetaType::UnknownType**  or doesn't
        exist.
        """
        ...

    def save(self, ds: QDataStream) -> None:
        ...

    def load(self, ds: QDataStream) -> None:
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qvariant.html#clear

        **void QVariant::clear()**

        Convert this variant to type **QMetaType::UnknownType**  and free up any
        resources used.
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qvariant.html#isNull

        **bool QVariant::isNull() const**

        Returns `true` if this is a null variant, false otherwise. A variant is
        considered null if it contains no initialized value, or the contained
        value is `nullptr` or is an instance of a built-in type that has an
        isNull method, in which case the result would be the same as calling
        isNull on the wrapped object.

        **Warning:** Null variants is not a single state and two null variants
        may easily return `false` on the == operator if they do not contain
        similar null values.

        **See also** **convert** (int).
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qvariant.html#isValid

        **bool QVariant::isValid() const**

        Returns `true` if the storage type of this variant is not
        **QMetaType::UnknownType** ; otherwise returns `false`.
        """
        ...

    def convert(self, targetTypeId: int) -> bool:
        """
        https://doc.qt.io/qt-5/qvariant.html#convert

        **bool QVariant::convert(int targetTypeId )**

        Casts the variant to the requested type, **targetTypeId**. If the cast
        cannot be done, the variant is still changed to the requested type, but
        is left in a cleared null state similar to that constructed by
        **QVariant** (Type).

        Returns `true` if the current type of the variant was successfully cast;
        otherwise returns `false`.

        A **QVariant**  containing a pointer to a type derived from **QObject**
        will also convert and return true for this function if a
        **qobject_cast**  to the type described by **targetTypeId** would
        succeed. Note that this only works for **QObject**  subclasses which use
        the **Q_OBJECT**  macro.

        **Note:** converting QVariants that are null due to not being
        initialized or having failed a previous conversion will always fail,
        changing the type, remaining null, and returning `false`.

        **See also** **canConvert** (int targetTypeId) and **clear** ().
        """
        ...

    def canConvert(self, targetTypeId: int) -> bool:
        """
        https://doc.qt.io/qt-5/qvariant.html#canConvert

        **bool QVariant::canConvert(int targetTypeId ) const**

        Returns `true` if the variant's type can be cast to the requested type,
        **targetTypeId**. Such casting is done automatically when calling the
        **toInt** (), **toBool** (), ... methods.

        The following casts are done automatically:

        TypeAutomatically Cast To
        **QMetaType::Bool** **QMetaType::QChar** ,
        **QMetaType::Double** , **QMetaType::Int** , **QMetaType::LongLong** ,
        **QMetaType::QString** , **QMetaType::UInt** , **QMetaType::ULongLong**
        **QMetaType::QByteArray** **QMetaType::Double** , **QMetaType::Int** ,
        **QMetaType::LongLong** , **QMetaType::QString** , **QMetaType::UInt** ,
        **QMetaType::ULongLong** , **QMetaType::QUuid**
        **QMetaType::QChar**
        **QMetaType::Bool** , **QMetaType::Int** , **QMetaType::UInt** ,
        **QMetaType::LongLong** , **QMetaType::ULongLong**
        **QMetaType::QColor** **QMetaType::QString**
        **QMetaType::QDate**
        **QMetaType::QDateTime** , **QMetaType::QString**
        **QMetaType::QDateTime** **QMetaType::QDate** , **QMetaType::QString** ,
        **QMetaType::QTime**
        **QMetaType::Double** **QMetaType::Bool** ,
        **QMetaType::Int** , **QMetaType::LongLong** , **QMetaType::QString** ,
        **QMetaType::UInt** , **QMetaType::ULongLong**
        **QMetaType::QFont**
        **QMetaType::QString**
        **QMetaType::Int** **QMetaType::Bool** ,
        **QMetaType::QChar** , **QMetaType::Double** , **QMetaType::LongLong** ,
        **QMetaType::QString** , **QMetaType::UInt** , **QMetaType::ULongLong**
        **QMetaType::QKeySequence** **QMetaType::Int** , **QMetaType::QString**
        **QMetaType::QVariantList** **QMetaType::QStringList**  (if the list's
        items can be converted to QStrings)
        **QMetaType::LongLong**
        **QMetaType::Bool** , **QMetaType::QByteArray** , **QMetaType::QChar** ,
        **QMetaType::Double** , **QMetaType::Int** , **QMetaType::QString** ,
        **QMetaType::UInt** , **QMetaType::ULongLong**
        **QMetaType::QPoint**
        **QMetaType::QPointF**
        **QMetaType::QRect** **QMetaType::QRectF**
        **QMetaType::QString** **QMetaType::Bool** , **QMetaType::QByteArray** ,
        **QMetaType::QChar** , **QMetaType::QColor** , **QMetaType::QDate** ,
        **QMetaType::QDateTime** , **QMetaType::Double** , **QMetaType::QFont**
        , **QMetaType::Int** , **QMetaType::QKeySequence** ,
        **QMetaType::LongLong** , **QMetaType::QStringList** ,
        **QMetaType::QTime** , **QMetaType::UInt** , **QMetaType::ULongLong** ,
        **QMetaType::QUuid**
        **QMetaType::QStringList**
        **QMetaType::QVariantList** , **QMetaType::QString**  (if the list
        contains exactly one item)
        **QMetaType::QTime** **QMetaType::QString**
        **QMetaType::UInt** **QMetaType::Bool** , **QMetaType::QChar** ,
        **QMetaType::Double** , **QMetaType::Int** , **QMetaType::LongLong** ,
        **QMetaType::QString** , **QMetaType::ULongLong**
        **QMetaType::ULongLong** **QMetaType::Bool** , **QMetaType::QChar** ,
        **QMetaType::Double** , **QMetaType::Int** , **QMetaType::LongLong** ,
        **QMetaType::QString** , **QMetaType::UInt**
        **QMetaType::QUuid**
        **QMetaType::QByteArray** , **QMetaType::QString**

        A **QVariant**  containing a pointer to a type derived from **QObject**
        will also return true for this function if a **qobject_cast**  to the
        type described by **targetTypeId** would succeed. Note that this only
        works for **QObject**  subclasses which use the **Q_OBJECT**  macro.

        A **QVariant**  containing a sequential container will also return true
        for this function if the **targetTypeId** is **QVariantList** . It is
        possible to iterate over the contents of the container without
        extracting it as a (copied) **QVariantList** :

        **QList** <int> intList = {7, 11, 42};

            **QVariant**  variant =
        **QVariant** ::fromValue(intList);
            if
        (variant.canConvert<**QVariantList** >()) {
        **QSequentialIterable**  iterable =
        variant.value<**QSequentialIterable** >();
                // Can use foreach:
        foreach (const **QVariant**  &v, iterable) {
                    **qDebug** ()
        << v;
                }
                // Can use C++11 range-for:
                for (const
        **QVariant**  &v : iterable) {
                    **qDebug** () << v;
                }
        // Can use iterators:
                **QSequentialIterable** ::const_iterator
        it = iterable.begin();
                const **QSequentialIterable**
        ::const_iterator end = iterable.end();
                for ( ; it != end; ++it)
        {
                    **qDebug** () << *it;
                }
            }

        This requires that the value_type of the container is itself a metatype.

        Similarly, a **QVariant**  containing a sequential container will also
        return true for this function the **targetTypeId** is **QVariantHash**
        or **QVariantMap** . It is possible to iterate over the contents of the
        container without extracting it as a (copied) **QVariantHash**  or
        **QVariantMap** :

        **QHash** <int, **QString** > mapping;
            mapping.insert(7, "Seven");
        mapping.insert(11, "Eleven");
            mapping.insert(42, "Forty-two");
        **QVariant**  variant = **QVariant** ::fromValue(mapping);
            if
        (variant.canConvert<**QVariantHash** >()) {
        **QAssociativeIterable**  iterable =
        variant.value<**QAssociativeIterable** >();
                // Can use foreach
        over the values:
                foreach (const **QVariant**  &v, iterable) {
        **qDebug** () << v;
                }
                // Can use C++11 range-for over
        the values:
                for (const **QVariant**  &v : iterable) {
        **qDebug** () << v;
                }
                // Can use iterators:
        **QAssociativeIterable** ::const_iterator it = iterable.begin();
        const **QAssociativeIterable** ::const_iterator end = iterable.end();
        for ( ; it != end; ++it) {
                    **qDebug** () << *it; // The
        current value
                    **qDebug** () << it.key();
        **qDebug** () << it.value();
                }
            }

        **See also** **convert** (), **QSequentialIterable** ,
        **Q_DECLARE_SEQUENTIAL_CONTAINER_METATYPE** (), **QAssociativeIterable**
        , and **Q_DECLARE_ASSOCIATIVE_CONTAINER_METATYPE** ().
        """
        ...

    def typeName(self) -> str:
        """
        https://doc.qt.io/qt-5/qvariant.html#typeName

        **const char *QVariant::typeName() const**

        Returns the name of the type stored in the variant. The returned strings
        describe the C++ datatype used to store the data: for example,
        "**QFont** ", "**QString** ", or "**QVariantList** ". An Invalid variant
        returns 0.
        """
        ...

    def userType(self) -> int:
        """
        https://doc.qt.io/qt-5/qvariant.html#userType

        **int QVariant::userType() const**

        Returns the storage type of the value stored in the variant. For non-
        user types, this is the same as **type** ().

        **See also** **type** ().
        """
        ...

    def type(self) -> "QVariant.Type":
        """
        https://doc.qt.io/qt-5/qvariant.html#type

        **QVariant::Type QVariant::type() const**

        Returns the storage type of the value stored in the variant. Although
        this function is declared as returning QVariant::Type, the return value
        should be interpreted as **QMetaType::Type** . In particular,
        QVariant::UserType is returned here only if the value is equal or
        greater than **QMetaType::User** .

        Note that return values in the ranges QVariant::Char through
        QVariant::RegExp and QVariant::Font through QVariant::Transform
        correspond to the values in the ranges **QMetaType::QChar**  through
        **QMetaType::QRegExp**  and **QMetaType::QFont**  through
        **QMetaType::QQuaternion** .

        Pay particular attention when working with char and **QChar**  variants.
        Note that there is no **QVariant**  constructor specifically for type
        char, but there is one for **QChar** . For a variant of type **QChar** ,
        this function returns QVariant::Char, which is the same as
        **QMetaType::QChar** , but for a variant of type `char`, this function
        returns **QMetaType::Char** , which is **not** the same as
        QVariant::Char.

        Also note that the types `void*`, `long`, `short`, `unsigned` `long`,
        `unsigned` `short`, `unsigned` `char`, `float`, `QObject*`, and
        `QWidget*` are represented in **QMetaType::Type**  but not in
        QVariant::Type, and they can be returned by this function. However, they
        are considered to be user defined types when tested against
        QVariant::Type.

        To test whether an instance of **QVariant**  contains a data type that
        is compatible with the data type you are interested in, use
        **canConvert** ().
        """
        ...

    def value(self) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qvariant.html#value

        **template <typename T> T QVariant::value() const**

        Returns the stored value converted to the template type `T`. Call
        **canConvert** () to find out whether a type can be converted. If the
        value cannot be converted, a **default-constructed value**  will be
        returned.

        If the type `T` is supported by **QVariant** , this function behaves
        exactly as **toString** (), **toInt** () etc.

        Example:

        **QVariant**  v;

            MyCustomStruct c;
            if
        (v.canConvert<MyCustomStruct>())
                c = v.value<MyCustomStruct>();
        v = 7;
            int i = v.value<int>();                        // same as
        v.toInt()
            **QString**  s = v.value<**QString** >();
        // same as v.toString(), s is now "7"
            MyCustomStruct c2 =
        v.value<MyCustomStruct>(); // conversion failed, c2 is empty

        If the **QVariant**  contains a pointer to a type derived from
        **QObject**  then `T` may be any **QObject**  type. If the pointer
        stored in the **QVariant**  can be **qobject_cast**  to T, then that
        result is returned. Otherwise `nullptr` is returned. Note that this only
        works for **QObject**  subclasses which use the **Q_OBJECT**  macro.

        If the **QVariant**  contains a sequential container and `T` is
        **QVariantList** , the elements of the container will be converted into
        **QVariant** s and returned as a **QVariantList** .

        **QList** <int> intList = {7, 11, 42};

            **QVariant**  variant =
        **QVariant** ::fromValue(intList);
            if
        (variant.canConvert<**QVariantList** >()) {
        **QSequentialIterable**  iterable =
        variant.value<**QSequentialIterable** >();
                // Can use foreach:
        foreach (const **QVariant**  &v, iterable) {
                    **qDebug** ()
        << v;
                }
                // Can use C++11 range-for:
                for (const
        **QVariant**  &v : iterable) {
                    **qDebug** () << v;
                }
        // Can use iterators:
                **QSequentialIterable** ::const_iterator
        it = iterable.begin();
                const **QSequentialIterable**
        ::const_iterator end = iterable.end();
                for ( ; it != end; ++it)
        {
                    **qDebug** () << *it;
                }
            }

        **See also** **setValue** (), **fromValue** (), **canConvert** (), and
        **Q_DECLARE_SEQUENTIAL_CONTAINER_METATYPE** ().
        """
        ...
