"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import datetime
from PyQt5.QtCore import *
from PyQt5 import sip


class QTimeZone(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qtimezone.html

    **Detailed Description**

    This class provides a stateless calculator for time zone conversions between
    UTC and the local time in a specific time zone. By default it uses the host
    system time zone data to perform these conversions.

    This class is primarily designed for use in **QDateTime** ; most
    applications will not need to access this class directly and should instead
    use **QDateTime**  with a **Qt::TimeSpec**  of **Qt::TimeZone** .

    **Note:** For consistency with **QDateTime** , QTimeZone does not account
    for leap seconds.

    **Remarks**

    **IANA Time Zone IDs**

    QTimeZone uses the IANA time zone IDs as defined in the IANA Time Zone
    Database (http://www.iana.org/time-zones). This is to ensure a standard ID
    across all supported platforms. Most platforms support the IANA IDs and the
    IANA Database natively, but for Windows a mapping is required to the native
    IDs. See below for more details.

    The IANA IDs can and do change on a regular basis, and can vary depending on
    how recently the host system data was updated. As such you cannot rely on
    any given ID existing on any host system. You must use
    **availableTimeZoneIds** () to determine what IANA IDs are available.

    The IANA IDs and database are also know as the Olson IDs and database, named
    after their creator.

    **UTC Offset Time Zones**

    A default UTC time zone backend is provided which is always guaranteed to be
    available. This provides a set of generic Offset From UTC time zones in the
    range UTC-14:00 to UTC+14:00. These time zones can be created using either
    the standard ISO format names "UTC+00:00" as listed by
    **availableTimeZoneIds** (), or using the number of offset seconds.

    **Windows Time Zones**

    Windows native time zone support is severely limited compared to the
    standard IANA TZ Database. Windows time zones cover larger geographic areas
    and are thus less accurate in their conversions. They also do not support as
    much historic conversion data and so may only be accurate for the current
    year.

    QTimeZone uses a conversion table derived form the Unicode CLDR data to map
    between IANA IDs and Windows IDs. Depending on your version of Windows and
    Qt, this table may not be able to provide a valid conversion, in which "UTC"
    will be returned.

    QTimeZone provides a public API to use this conversion table. The Windows ID
    used is the Windows Registry Key for the time zone which is also the MS
    Exchange EWS ID as well, but is different to the Time Zone Name (TZID) and
    COD code used by MS Exchange in versions before 2007.

    **System Time Zone**

    QTimeZone does not support any concept of a system or default time zone. If
    you require a **QDateTime**  that uses the current system time zone at any
    given moment then you should use a **Qt::TimeSpec**  of **Qt::LocalTime** .

    The method **systemTimeZoneId** () returns the current system IANA time zone
    ID which on Unix-like systems will always be correct. On Windows this ID is
    translated from the Windows system ID using an internal translation table
    and the user's selected country. As a consequence there is a small chance
    any Windows install may have IDs not known by Qt, in which case "UTC" will
    be returned.

    Creating a new QTimeZone instance using the system time zone ID will only
    produce a fixed named copy of the time zone, it will not change if the
    system time zone changes.

    **Time Zone Offsets**

    The difference between UTC and the local time in a time zone is expressed as
    an offset in seconds from UTC, i.e. the number of seconds to add to UTC to
    obtain the local time. The total offset is comprised of two component parts,
    the standard time offset and the daylight-saving time offset. The standard
    time offset is the number of seconds to add to UTC to obtain standard time
    in the time zone. The daylight-saving time offset is the number of seconds
    to add to the standard time offset to obtain daylight-saving time
    (abbreviated DST and sometimes called "daylight time" or "summer time") in
    the time zone.

    Note that the standard and DST offsets for a time zone may change over time
    as countries have changed DST laws or even their standard time offset.

    **License**

    This class includes data obtained from the CLDR data files under the terms
    of the Unicode Data Files and Software License. See **Unicode Common Locale
    Data Repository (CLDR)**  for details.

    **See also** **QDateTime** .
    """

    class NameType(int):
        DefaultName: QTimeZone = ...
        LongName: QTimeZone = ...
        ShortName: QTimeZone = ...
        OffsetName: QTimeZone = ...

    class TimeType(int):
        StandardTime: QTimeZone = ...
        DaylightTime: QTimeZone = ...
        GenericTime: QTimeZone = ...

    class OffsetData(sip.simplewrapper):
        abbreviation: str = ...
        atUtc: typing = ...
        daylightTimeOffset: int = ...
        offsetFromUtc: int = ...
        standardTimeOffset: int = ...

        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QTimeZone.OffsetData") -> None:
            ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qtimezone.html#QTimeZone

        **QTimeZone::QTimeZone()**

        Create a null/invalid time zone instance.
        """
        ...

    @typing.overload
    def __init__(self, ianaId: typing.Union[QByteArray, bytes, bytearray]) -> None:
        """
        https://doc.qt.io/qt-5/qtimezone.html#QTimeZone-1

        **QTimeZone::QTimeZone(const QByteArray & ianaId )**

        Creates an instance of the requested time zone **ianaId**.

        The ID must be one of the available system IDs or a valid UTC-with-
        offset ID, otherwise an invalid time zone will be returned.

        **See also** **availableTimeZoneIds** ().
        """
        ...

    @typing.overload
    def __init__(self, offsetSeconds: int) -> None:
        """
        https://doc.qt.io/qt-5/qtimezone.html#QTimeZone-2

        **QTimeZone::QTimeZone(int offsetSeconds )**

        Creates an instance of a time zone with the requested Offset from UTC of
        **offsetSeconds**.

        The **offsetSeconds** from UTC must be in the range -14 hours to +14
        hours otherwise an invalid time zone will be returned.
        """
        ...

    @typing.overload
    def __init__(
        self,
        zoneId: typing.Union[QByteArray, bytes, bytearray],
        offsetSeconds: int,
        name: str,
        abbreviation: str,
        country: QLocale.Country = ...,
        comment: str = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtimezone.html#QTimeZone-3

        **QTimeZone::QTimeZone(const QByteArray & ianaId , int offsetSeconds ,
        const QString & name , const QString & abbreviation , QLocale::Country
        country = QLocale::AnyCountry, const QString & comment = QString())**

        Creates a custom time zone with an ID of **ianaId** and an offset from
        UTC of **offsetSeconds**. The **name** will be the name used by
        **displayName** () for the **LongName** , the **abbreviation** will be
        used by **displayName** () for the **ShortName**  and by
        **abbreviation** (), and the optional **country** will be used by
        **country** (). The **comment** is an optional note that may be
        displayed in a GUI to assist users in selecting a time zone.

        The **ianaId** must not be one of the available system IDs returned by
        **availableTimeZoneIds** (). The **offsetSeconds** from UTC must be in
        the range -14 hours to +14 hours.

        If the custom time zone does not have a specific country then set it to
        the default value of **QLocale::AnyCountry** .
        """
        ...

    @typing.overload
    def __init__(self, other: "QTimeZone") -> None:
        """
        https://doc.qt.io/qt-5/qtimezone.html#QTimeZone-4

        **QTimeZone::QTimeZone(const QTimeZone & other )**

        Copy constructor, copy **other** to this.
        """
        ...

    @staticmethod
    def utc() -> "QTimeZone":
        """
        https://doc.qt.io/qt-5/qtimezone.html#utc

        **[static] QTimeZone QTimeZone::utc()**

        Returns a **QTimeZone**  object that refers to UTC (Universal Time
        Coordinated).

        This function was introduced in Qt 5.5.

        **See also** **systemTimeZone** ().
        """
        ...

    @staticmethod
    def systemTimeZone() -> "QTimeZone":
        """
        https://doc.qt.io/qt-5/qtimezone.html#systemTimeZone

        **[static] QTimeZone QTimeZone::systemTimeZone()**

        Returns a **QTimeZone**  object that refers to the local system time, as
        specified by **systemTimeZoneId** ().

        This function was introduced in Qt 5.5.

        **See also** **utc** ().
        """
        ...

    @typing.overload
    @staticmethod
    def windowsIdToIanaIds(
        windowsId: typing.Union[QByteArray, bytes, bytearray]
    ) -> typing.List[QByteArray]:
        """
        https://doc.qt.io/qt-5/qtimezone.html#windowsIdToIanaIds

        **[static] QList<QByteArray> QTimeZone::windowsIdToIanaIds(const
        QByteArray & windowsId )**

        Returns all the IANA IDs for a given **windowsId**.

        The returned list is sorted alphabetically.

        **See also** **ianaIdToWindowsId** () and **windowsIdToDefaultIanaId**
        ().
        """
        ...

    @typing.overload
    @staticmethod
    def windowsIdToIanaIds(
        windowsId: typing.Union[QByteArray, bytes, bytearray], country: QLocale.Country
    ) -> typing.List[QByteArray]:
        """
        https://doc.qt.io/qt-5/qtimezone.html#windowsIdToIanaIds-1

        **[static] QList<QByteArray> QTimeZone::windowsIdToIanaIds(const
        QByteArray & windowsId , QLocale::Country country )**

        Returns all the IANA IDs for a given **windowsId** and **country**.

        As a special case **QLocale::AnyCountry**  returns those IANA IDs that
        do not have any specific country.

        The returned list is in order of frequency of usage, i.e. larger zones
        within a country are listed first.

        **See also** **ianaIdToWindowsId** () and **windowsIdToDefaultIanaId**
        ().
        """
        ...

    @typing.overload
    @staticmethod
    def windowsIdToDefaultIanaId(
        windowsId: typing.Union[QByteArray, bytes, bytearray]
    ) -> QByteArray:
        """
        https://doc.qt.io/qt-5/qtimezone.html#windowsIdToDefaultIanaId

        **[static] QByteArray QTimeZone::windowsIdToDefaultIanaId(const
        QByteArray & windowsId )**

        Returns the default IANA ID for a given **windowsId**.

        Because a Windows ID can cover several IANA IDs in several different
        countries, this function returns the most frequently used IANA ID with
        no regard for the country and should thus be used with care. It is
        usually best to request the default for a specific country.

        **See also** **ianaIdToWindowsId** () and **windowsIdToIanaIds** ().
        """
        ...

    @typing.overload
    @staticmethod
    def windowsIdToDefaultIanaId(
        windowsId: typing.Union[QByteArray, bytes, bytearray], country: QLocale.Country
    ) -> QByteArray:
        """
        https://doc.qt.io/qt-5/qtimezone.html#windowsIdToDefaultIanaId-1

        **[static] QByteArray QTimeZone::windowsIdToDefaultIanaId(const
        QByteArray & windowsId , QLocale::Country country )**

        Returns the default IANA ID for a given **windowsId** and **country**.

        Because a Windows ID can cover several IANA IDs within a given country,
        the most frequently used IANA ID in that country is returned.

        As a special case, **QLocale::AnyCountry**  returns the default of those
        IANA IDs that do not have any specific country.

        **See also** **ianaIdToWindowsId** () and **windowsIdToIanaIds** ().
        """
        ...

    @staticmethod
    def ianaIdToWindowsId(
        ianaId: typing.Union[QByteArray, bytes, bytearray]
    ) -> QByteArray:
        """
        https://doc.qt.io/qt-5/qtimezone.html#ianaIdToWindowsId

        **[static] QByteArray QTimeZone::ianaIdToWindowsId(const QByteArray &
        ianaId )**

        Returns the Windows ID equivalent to the given **ianaId**.

        **See also** **windowsIdToDefaultIanaId** () and **windowsIdToIanaIds**
        ().
        """
        ...

    @typing.overload
    @staticmethod
    def availableTimeZoneIds() -> typing.List[QByteArray]:
        """
        https://doc.qt.io/qt-5/qtimezone.html#availableTimeZoneIds

        **[static] QList<QByteArray> QTimeZone::availableTimeZoneIds()**

        Returns a list of all available IANA time zone IDs on this system.

        **See also** **isTimeZoneIdAvailable** ().
        """
        ...

    @typing.overload
    @staticmethod
    def availableTimeZoneIds(country: QLocale.Country) -> typing.List[QByteArray]:
        """
        https://doc.qt.io/qt-5/qtimezone.html#availableTimeZoneIds-1

        **[static] QList<QByteArray>
        QTimeZone::availableTimeZoneIds(QLocale::Country country )**

        Returns a list of all available IANA time zone IDs for a given
        **country**.

        As a special case, a **country** of Qt::AnyCountry returns those time
        zones that do not have any country related to them, such as UTC. If you
        require a list of all time zone IDs for all countries then use the
        standard availableTimeZoneIds() method.

        **See also** **isTimeZoneIdAvailable** ().
        """
        ...

    @typing.overload
    @staticmethod
    def availableTimeZoneIds(offsetSeconds: int) -> typing.List[QByteArray]:
        """
        https://doc.qt.io/qt-5/qtimezone.html#availableTimeZoneIds-2

        **[static] QList<QByteArray> QTimeZone::availableTimeZoneIds(int
        offsetSeconds )**

        Returns a list of all available IANA time zone IDs with a given standard
        time offset of **offsetSeconds**.

        **See also** **isTimeZoneIdAvailable** ().
        """
        ...

    @staticmethod
    def isTimeZoneIdAvailable(
        ianaId: typing.Union[QByteArray, bytes, bytearray]
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qtimezone.html#isTimeZoneIdAvailable

        **[static] bool QTimeZone::isTimeZoneIdAvailable(const QByteArray &
        ianaId )**

        Returns `true` if a given time zone **ianaId** is available on this
        system.

        **See also** **availableTimeZoneIds** ().
        """
        ...

    @staticmethod
    def systemTimeZoneId() -> QByteArray:
        """
        https://doc.qt.io/qt-5/qtimezone.html#systemTimeZoneId

        **[static] QByteArray QTimeZone::systemTimeZoneId()**

        Returns the current system time zone IANA ID.

        On Windows this ID is translated from the Windows ID using an internal
        translation table and the user's selected country. As a consequence
        there is a small chance any Windows install may have IDs not known by
        Qt, in which case "UTC" will be returned.
        """
        ...

    def transitions(
        self,
        fromDateTime: typing.Union[QDateTime, datetime.datetime],
        toDateTime: typing.Union[QDateTime, datetime.datetime],
    ) -> typing.List["QTimeZone.OffsetData"]:
        """
        https://doc.qt.io/qt-5/qtimezone.html#transitions

        **QTimeZone::OffsetDataList QTimeZone::transitions(const QDateTime &
        fromDateTime , const QDateTime & toDateTime ) const**

        Returns a list of all time zone transitions between the given datetimes.

        The given **fromDateTime** and **toDateTime** are inclusive.

        **See also** **hasTransitions** (), **nextTransition** (), and
        **previousTransition** ().
        """
        ...

    def previousTransition(
        self, beforeDateTime: typing.Union[QDateTime, datetime.datetime]
    ) -> "QTimeZone.OffsetData":
        """
        https://doc.qt.io/qt-5/qtimezone.html#previousTransition

        **QTimeZone::OffsetData QTimeZone::previousTransition(const QDateTime &
        beforeDateTime ) const**

        Returns the first time zone Transition before the given
        **beforeDateTime**. This is most useful when you have a Transition time
        and wish to find the Transition before it.

        If there is no transition before the given **beforeDateTime** then an
        invalid **OffsetData**  will be returned with an invalid **QDateTime** .

        The given **beforeDateTime** is exclusive.

        **See also** **hasTransitions** (), **nextTransition** (), and
        **transitions** ().
        """
        ...

    def nextTransition(
        self, afterDateTime: typing.Union[QDateTime, datetime.datetime]
    ) -> "QTimeZone.OffsetData":
        """
        https://doc.qt.io/qt-5/qtimezone.html#nextTransition

        **QTimeZone::OffsetData QTimeZone::nextTransition(const QDateTime &
        afterDateTime ) const**

        Returns the first time zone Transition after the given
        **afterDateTime**. This is most useful when you have a Transition time
        and wish to find the Transition after it.

        If there is no transition after the given **afterDateTime** then an
        invalid **OffsetData**  will be returned with an invalid **QDateTime** .

        The given **afterDateTime** is exclusive.

        **See also** **hasTransitions** (), **previousTransition** (), and
        **transitions** ().
        """
        ...

    def hasTransitions(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtimezone.html#hasTransitions

        **bool QTimeZone::hasTransitions() const**

        Returns `true` if the system backend supports obtaining transitions.

        Transitions are changes in the time-zone: these happen when DST turns on
        or off and when authorities alter the offsets for the time-zone.

        **See also** **nextTransition** (), **previousTransition** (), and
        **transitions** ().
        """
        ...

    def offsetData(
        self, forDateTime: typing.Union[QDateTime, datetime.datetime]
    ) -> "QTimeZone.OffsetData":
        """
        https://doc.qt.io/qt-5/qtimezone.html#offsetData

        **QTimeZone::OffsetData QTimeZone::offsetData(const QDateTime &
        forDateTime ) const**

        Returns the effective offset details at the given **forDateTime**. This
        is the equivalent of calling **offsetFromUtc** (), **abbreviation** (),
        etc individually but is more efficient.

        **See also** **offsetFromUtc** (), **standardTimeOffset** (),
        **daylightTimeOffset** (), and **abbreviation** ().
        """
        ...

    def isDaylightTime(
        self, atDateTime: typing.Union[QDateTime, datetime.datetime]
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qtimezone.html#isDaylightTime

        **bool QTimeZone::isDaylightTime(const QDateTime & atDateTime ) const**

        Returns `true` if daylight-saving was in effect at the given
        **atDateTime**.

        **See also** **hasDaylightTime** () and **daylightTimeOffset** ().
        """
        ...

    def hasDaylightTime(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtimezone.html#hasDaylightTime

        **bool QTimeZone::hasDaylightTime() const**

        Returns `true` if the time zone has practiced daylight-saving at any
        time.

        **See also** **isDaylightTime** () and **daylightTimeOffset** ().
        """
        ...

    def daylightTimeOffset(
        self, atDateTime: typing.Union[QDateTime, datetime.datetime]
    ) -> int:
        """
        https://doc.qt.io/qt-5/qtimezone.html#daylightTimeOffset

        **int QTimeZone::daylightTimeOffset(const QDateTime & atDateTime )
        const**

        Returns the daylight-saving time offset at the given **atDateTime** ,
        i.e. the number of seconds to add to the standard time offset to obtain
        the local daylight-saving time.

        For example, for the time zone "Europe/Berlin" the DST offset is +3600
        seconds. During standard time daylightTimeOffset() will return 0, and
        when daylight-saving is in effect it will return +3600.

        **See also** **offsetFromUtc** () and **standardTimeOffset** ().
        """
        ...

    def standardTimeOffset(
        self, atDateTime: typing.Union[QDateTime, datetime.datetime]
    ) -> int:
        """
        https://doc.qt.io/qt-5/qtimezone.html#standardTimeOffset

        **int QTimeZone::standardTimeOffset(const QDateTime & atDateTime )
        const**

        Returns the standard time offset at the given **atDateTime** , i.e. the
        number of seconds to add to UTC to obtain the local Standard Time. This
        excludes any DST offset that may be in effect.

        For example, for the time zone "Europe/Berlin" the standard time offset
        is +3600 seconds. During both standard and DST **offsetFromUtc** () will
        return +3600 (UTC+01:00).

        **See also** **offsetFromUtc** () and **daylightTimeOffset** ().
        """
        ...

    def offsetFromUtc(
        self, atDateTime: typing.Union[QDateTime, datetime.datetime]
    ) -> int:
        """
        https://doc.qt.io/qt-5/qtimezone.html#offsetFromUtc

        **int QTimeZone::offsetFromUtc(const QDateTime & atDateTime ) const**

        Returns the total effective offset at the given **atDateTime** , i.e.
        the number of seconds to add to UTC to obtain the local time. This
        includes any DST offset that may be in effect, i.e. it is the sum of
        **standardTimeOffset** () and **daylightTimeOffset** () for the given
        datetime.

        For example, for the time zone "Europe/Berlin" the standard time offset
        is +3600 seconds and the DST offset is +3600 seconds. During standard
        time offsetFromUtc() will return +3600 (UTC+01:00), and during DST it
        will return +7200 (UTC+02:00).

        **See also** **standardTimeOffset** () and **daylightTimeOffset** ().
        """
        ...

    def abbreviation(
        self, atDateTime: typing.Union[QDateTime, datetime.datetime]
    ) -> str:
        """
        https://doc.qt.io/qt-5/qtimezone.html#abbreviation

        **QString QTimeZone::abbreviation(const QDateTime & atDateTime ) const**

        Returns the time zone abbreviation at the given **atDateTime**. The
        abbreviation may change depending on DST or even historical events.

        Note that the abbreviation is not guaranteed to be unique to this time
        zone and should not be used in place of the ID or display name.

        **See also** **displayName** ().
        """
        ...

    @typing.overload
    def displayName(
        self,
        atDateTime: typing.Union[QDateTime, datetime.datetime],
        nameType: "QTimeZone.NameType" = ...,
        locale: QLocale = ...,
    ) -> str:
        """
        https://doc.qt.io/qt-5/qtimezone.html#displayName

        **QString QTimeZone::displayName(const QDateTime & atDateTime ,
        QTimeZone::NameType nameType = QTimeZone::DefaultName, const QLocale &
        locale = QLocale()) const**

        Returns the localized time zone display name at the given **atDateTime**
        for the given **nameType** in the given **locale**. The **nameType** and
        **locale** requested may not be supported on all platforms, in which
        case the best available option will be returned.

        If the **locale** is not provided then the application default locale
        will be used.

        The display name may change depending on DST or historical events.

        **See also** **abbreviation** ().
        """
        ...

    @typing.overload
    def displayName(
        self,
        timeType: "QTimeZone.TimeType",
        nameType: "QTimeZone.NameType" = ...,
        locale: QLocale = ...,
    ) -> str:
        """
        https://doc.qt.io/qt-5/qtimezone.html#displayName-1

        **QString QTimeZone::displayName(QTimeZone::TimeType timeType ,
        QTimeZone::NameType nameType = QTimeZone::DefaultName, const QLocale &
        locale = QLocale()) const**

        Returns the localized time zone display name for the given **timeType**
        and **nameType** in the given **locale**. The **nameType** and
        **locale** requested may not be supported on all platforms, in which
        case the best available option will be returned.

        If the **locale** is not provided then the application default locale
        will be used.

        Where the time zone display names have changed over time then the most
        recent names will be used.

        **See also** **abbreviation** ().
        """
        ...

    def comment(self) -> str:
        """
        https://doc.qt.io/qt-5/qtimezone.html#comment

        **QString QTimeZone::comment() const**

        Returns any comment for the time zone.

        A comment may be provided by the host platform to assist users in
        choosing the correct time zone. Depending on the platform this may not
        be localized.
        """
        ...

    def country(self) -> QLocale.Country:
        """
        https://doc.qt.io/qt-5/qtimezone.html#country

        **QLocale::Country QTimeZone::country() const**

        Returns the country for the time zone.
        """
        ...

    def id(self) -> QByteArray:
        """
        https://doc.qt.io/qt-5/qtimezone.html#id

        **QByteArray QTimeZone::id() const**

        Returns the IANA ID for the time zone.

        IANA IDs are used on all platforms. On Windows these are translated from
        the Windows ID into the closest IANA ID for the time zone and country.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtimezone.html#isValid

        **bool QTimeZone::isValid() const**

        Returns `true` if this time zone is valid.
        """
        ...

    def swap(self, other: "QTimeZone") -> None:
        """
        https://doc.qt.io/qt-5/qtimezone.html#swap

        **void QTimeZone::swap(QTimeZone & other )**

        Swaps this time zone instance with **other**. This function is very fast
        and never fails.
        """
        ...
