"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import datetime
from PyQt5.QtCore import *
from PyQt5 import sip


class QTime(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qtime.html

    **Detailed Description**

    A QTime object contains a clock time, which it can express as the numbers of
    hours, minutes, seconds, and milliseconds since midnight. It provides
    functions for comparing times and for manipulating a time by adding a number
    of milliseconds.

    QTime uses the 24-hour clock format; it has no concept of AM/PM. Unlike
    **QDateTime** , QTime knows nothing about time zones or daylight-saving time
    (DST).

    A QTime object is typically created either by giving the number of hours,
    minutes, seconds, and milliseconds explicitly, or by using the static
    function **currentTime** (), which creates a QTime object that represents
    the system's local time.

    The **hour** (), **minute** (), **second** (), and **msec** () functions
    provide access to the number of hours, minutes, seconds, and milliseconds of
    the time. The same information is provided in textual format by the
    **toString** () function.

    The **addSecs** () and **addMSecs** () functions provide the time a given
    number of seconds or milliseconds later than a given time. Correspondingly,
    the number of seconds or milliseconds between two times can be found using
    **secsTo** () or **msecsTo** ().

    QTime provides a full set of operators to compare two QTime objects; an
    earlier time is considered smaller than a later one; if A.**msecsTo** (B) is
    positive, then A < B.

    **See also** **QDate**  and **QDateTime** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qtime.html#QTime-1

        **QTime::QTime()**

        Constructs a null time object. For a null time, **isNull** () returns
        `true` and **isValid** () returns `false`. If you need a zero time, use
        QTime(0, 0). For the start of a day, see **QDate::startOfDay** ().

        **See also** **isNull** () and **isValid** ().
        """
        ...

    @typing.overload
    def __init__(self, h: int, m: int, second: int = ..., msec: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qtime.html#QTime-2

        **QTime::QTime(int h , int m , int s = 0, int ms = 0)**

        Constructs a time with hour **h** , minute **m** , seconds **s** and
        milliseconds **ms**.

        **h** must be in the range 0 to 23, **m** and **s** must be in the range
        0 to 59, and **ms** must be in the range 0 to 999.

        **See also** **isValid** ().
        """
        ...

    @typing.overload
    def __init__(self, a0: "QTime") -> None:
        """
        https://doc.qt.io/qt-5/qtime.html#QTime-1

        **QTime::QTime()**

        Constructs a null time object. For a null time, **isNull** () returns
        `true` and **isValid** () returns `false`. If you need a zero time, use
        QTime(0, 0). For the start of a day, see **QDate::startOfDay** ().

        **See also** **isNull** () and **isValid** ().
        """
        ...

    def msecsSinceStartOfDay(self) -> int:
        """
        https://doc.qt.io/qt-5/qtime.html#msecsSinceStartOfDay

        **int QTime::msecsSinceStartOfDay() const**

        Returns the number of msecs since the start of the day, i.e. since
        00:00:00.

        **See also** **fromMSecsSinceStartOfDay** ().
        """
        ...

    @staticmethod
    def fromMSecsSinceStartOfDay(msecs: int) -> "QTime":
        """
        https://doc.qt.io/qt-5/qtime.html#fromMSecsSinceStartOfDay

        **[static] QTime QTime::fromMSecsSinceStartOfDay(int msecs )**

        Returns a new **QTime**  instance with the time set to the number of
        **msecs** since the start of the day, i.e. since 00:00:00.

        If **msecs** falls outside the valid range an invalid **QTime**  will be
        returned.

        **See also** **msecsSinceStartOfDay** ().
        """
        ...

    def elapsed(self) -> int:
        """
        https://doc.qt.io/qt-5/qtime.html#elapsed

        **int QTime::elapsed() const**

        Returns the number of milliseconds that have elapsed since the last time
        **start** () or **restart** () was called.

        Note that the counter wraps to zero 24 hours after the last call to
        **start** () or restart.

        Note that the accuracy depends on the accuracy of the underlying
        operating system; not all systems provide 1-millisecond accuracy.

        **Warning:** If the system's clock setting has been changed since the
        last time **start** () or **restart** () was called, the result is
        undefined. This can happen when daylight-saving time is turned on or
        off.

        **See also** **start** () and **restart** ().
        """
        ...

    def restart(self) -> int:
        """
        https://doc.qt.io/qt-5/qtime.html#restart

        **int QTime::restart()**

        Sets this time to the current time and returns the number of
        milliseconds that have elapsed since the last time **start** () or
        restart() was called.

        This function is guaranteed to be atomic and is thus very handy for
        repeated measurements. Call **start** () to start the first measurement,
        and restart() for each later measurement.

        Note that the counter wraps to zero 24 hours after the last call to
        **start** () or restart().

        **Warning:** If the system's clock setting has been changed since the
        last time **start** () or restart() was called, the result is undefined.
        This can happen when daylight-saving time is turned on or off.

        **See also** **start** (), **elapsed** (), and **currentTime** ().
        """
        ...

    def start(self) -> None:
        """
        https://doc.qt.io/qt-5/qtime.html#start

        **void QTime::start()**

        Sets this time to the current time. This is practical for timing:

        QTime t;
            t.start();
            some_lengthy_task();
            **qDebug** ("Time
        elapsed: %d ms", t.elapsed());

        **See also** **restart** (), **elapsed** (), and **currentTime** ().
        """
        ...

    @typing.overload
    @staticmethod
    def fromString(string: str, format: Qt.DateFormat = ...) -> "QTime":
        """
        https://doc.qt.io/qt-5/qtime.html#fromString

        **[static] QTime QTime::fromString(const QString & string ,
        Qt::DateFormat format = Qt::TextDate)**

        Returns the time represented in the **string** as a **QTime**  using the
        **format** given, or an invalid time if this is not possible.

        Note that fromString() uses a "C" locale encoded string to convert
        milliseconds to a float value. If the default locale is not "C", this
        may result in two conversion attempts (if the conversion fails for the
        default locale). This should be considered an implementation detail.

        **Note:** Support for localized dates, including the format options
        **Qt::SystemLocaleDate** , **Qt::SystemLocaleShortDate** ,
        **Qt::SystemLocaleLongDate** , **Qt::LocaleDate** ,
        **Qt::DefaultLocaleShortDate** , and **Qt::DefaultLocaleLongDate** ,
        shall be removed in Qt 6. Use **QLocale::toTime** () instead.

        **See also** **toString** () and **QLocale::toTime** ().
        """
        ...

    @typing.overload
    @staticmethod
    def fromString(s: str, format: str) -> "QTime":
        """
        https://doc.qt.io/qt-5/qtime.html#fromString-1

        **[static] QTime QTime::fromString(const QString & string , const
        QString & format )**

        Returns the **QTime**  represented by the **string** , using the
        **format** given, or an invalid time if the string cannot be parsed.

        These expressions may be used for the format:

        ExpressionOutput
        hThe hour without a leading zero (0 to 23 or 1 to 12
        if AM/PM display)
        hhThe hour with a leading zero (00 to 23 or 01 to 12
        if AM/PM display)
        HThe hour without a leading zero (0 to 23, even with
        AM/PM display)
        HHThe hour with a leading zero (00 to 23, even with
        AM/PM display)
        mThe minute without a leading zero (0 to 59)
        mmThe
        minute with a leading zero (00 to 59)
        sThe whole second, without any
        leading zero (0 to 59)
        ssThe whole second, with a leading zero where
        applicable (00 to 59)
        zThe fractional part of the second, to go after
        a decimal point, without trailing zeroes (0 to 999). Thus "`s.z`"
        reports the seconds to full available (millisecond) precision without
        trailing zeroes.
        zzzThe fractional part of the second, to millisecond
        precision, including trailing zeroes where applicable (000 to 999).
        AP
        or AInterpret as an AM/PM time. **A/AP** will match an upper-case
        version of either **QLocale::amText** () or **QLocale::pmText** ().
        ap
        or aInterpret as an am/pm time. **a/ap** will match a lower-case version
        of either **QLocale::amText** () or **QLocale::pmText** ().

        All other input characters will be treated as text. Any non-empty
        sequence of characters enclosed in single quotes will also be treated
        (stripped of the quotes) as text and not be interpreted as expressions.

        QTime time = QTime::fromString("1mm12car00", "m'mm'hcarss");
            // time
        is 12:01.00

        If the format is not satisfied, an invalid **QTime**  is returned.
        Expressions that do not expect leading zeroes to be given (h, m, s and
        z) are greedy. This means that they will use two digits even if this
        puts them outside the range of accepted values and leaves too few digits
        for other sections. For example, the following string could have meant
        00:07:10, but the m will grab two digits, resulting in an invalid time:

        QTime time = QTime::fromString("00:710", "hh:ms"); // invalid

        Any field that is not represented in the format will be set to zero. For
        example:

        QTime time = QTime::fromString("1.30", "m.s");
            // time is
        00:01:30.000

        **Note:** If localized forms of am or pm (the AP, ap, A or a formats)
        are used, please switch to using **QLocale::system** ().toTime() as
        **QTime**  methods shall change to only recognize English (C locale) at
        Qt 6.

        **See also** **toString** (), **QDateTime::fromString** (),
        **QDate::fromString** (), and **QLocale::toTime** ().
        """
        ...

    @staticmethod
    def currentTime() -> "QTime":
        """
        https://doc.qt.io/qt-5/qtime.html#currentTime

        **[static] QTime QTime::currentTime()**

        Returns the current time as reported by the system clock.

        Note that the accuracy depends on the accuracy of the underlying
        operating system; not all systems provide 1-millisecond accuracy.

        Furthermore, currentTime() only increases within each day; it shall drop
        by 24 hours each time midnight passes; and, beside this, changes in it
        may not correspond to elapsed time, if a daylight-saving transition
        intervenes.

        **See also** **QDateTime::currentDateTime** () and
        **QDateTime::currentDateTimeUtc** ().
        """
        ...

    def msecsTo(self, a0: typing.Union["QTime", datetime.time]) -> int:
        """
        https://doc.qt.io/qt-5/qtime.html#msecsTo

        **int QTime::msecsTo(const QTime & t ) const**

        Returns the number of milliseconds from this time to **t**. If **t** is
        earlier than this time, the number of milliseconds returned is negative.

        Because **QTime**  measures time within a day and there are 86400
        seconds in a day, the result is always between -86400000 and 86400000
        ms.

        Returns 0 if either time is invalid.

        **See also** **secsTo** (), **addMSecs** (), and **QDateTime::msecsTo**
        ().
        """
        ...

    def addMSecs(self, ms: int) -> "QTime":
        """
        https://doc.qt.io/qt-5/qtime.html#addMSecs

        **QTime QTime::addMSecs(int ms ) const**

        Returns a **QTime**  object containing a time **ms** milliseconds later
        than the time of this object (or earlier if **ms** is negative).

        Note that the time will wrap if it passes midnight. See **addSecs** ()
        for an example.

        Returns a null time if this time is invalid.

        **See also** **addSecs** (), **msecsTo** (), and **QDateTime::addMSecs**
        ().
        """
        ...

    def secsTo(self, a0: typing.Union["QTime", datetime.time]) -> int:
        """
        https://doc.qt.io/qt-5/qtime.html#secsTo

        **int QTime::secsTo(const QTime & t ) const**

        Returns the number of seconds from this time to **t**. If **t** is
        earlier than this time, the number of seconds returned is negative.

        Because **QTime**  measures time within a day and there are 86400
        seconds in a day, the result is always between -86400 and 86400.

        secsTo() does not take into account any milliseconds.

        Returns 0 if either time is invalid.

        **See also** **addSecs** () and **QDateTime::secsTo** ().
        """
        ...

    def addSecs(self, secs: int) -> "QTime":
        """
        https://doc.qt.io/qt-5/qtime.html#addSecs

        **QTime QTime::addSecs(int s ) const**

        Returns a **QTime**  object containing a time **s** seconds later than
        the time of this object (or earlier if **s** is negative).

        Note that the time will wrap if it passes midnight.

        Returns a null time if this time is invalid.

        Example:

        QTime n(14, 0, 0);                // n == 14:00:00
            QTime t;
            t =
        n.addSecs(70);                // t == 14:01:10
            t = n.addSecs(-70);
        // t == 13:58:50
            t = n.addSecs(10 * 60 * 60 + 5);  // t == 00:00:05
        t = n.addSecs(-15 * 60 * 60);     // t == 23:00:00

        **See also** **addMSecs** (), **secsTo** (), and **QDateTime::addSecs**
        ().
        """
        ...

    def setHMS(self, h: int, m: int, s: int, msec: int = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qtime.html#setHMS

        **bool QTime::setHMS(int h , int m , int s , int ms = 0)**

        Sets the time to hour **h** , minute **m** , seconds **s** and
        milliseconds **ms**.

        **h** must be in the range 0 to 23, **m** and **s** must be in the range
        0 to 59, and **ms** must be in the range 0 to 999. Returns `true` if the
        set time is valid; otherwise returns `false`.

        **See also** **isValid** ().
        """
        ...

    @typing.overload
    def toString(self, format: Qt.DateFormat = ...) -> str:
        """
        https://doc.qt.io/qt-5/qtime.html#toString-1

        **QString QTime::toString(Qt::DateFormat format = Qt::TextDate) const**

        This is an overloaded function.

        Returns the time as a string. The **format** parameter determines the
        format of the string.

        If **format** is **Qt::TextDate** , the string format is HH:mm:ss; e.g.
        1 second before midnight would be "23:59:59".

        If **format** is **Qt::ISODate** , the string format corresponds to the
        ISO 8601 extended specification for representations of dates,
        represented by HH:mm:ss. To include milliseconds in the ISO 8601 date,
        use the **format** **Qt::ISODateWithMs** , which corresponds to
        HH:mm:ss.zzz.

        The **format** options **Qt::SystemLocaleDate** :,
        **Qt::SystemLocaleShortDate**  and **Qt::SystemLocaleLongDate**  shall
        be removed in Qt 6. Their use should be replaced with:
        **QLocale::system().toString(time, QLocale::ShortFormat)**  or
        **QLocale::system().toString(time, QLocale::LongFormat)** .

        The **format** options **Qt::LocaleDate** ,
        **Qt::DefaultLocaleShortDate**  and **Qt::DefaultLocaleLongDate**  shall
        be removed in Qt 6. Their use should be replaced with:
        **QLocale().toString(time, QLocale::ShortFormat)**  or
        **QLocale().toString(time, QLocale::LongFormat)** .

        If the **format** is **Qt::RFC2822Date** , the string is formatted in an
        **RFC 2822**  compatible way. An example of this formatting is
        "23:59:20".

        If the time is invalid, an empty string will be returned.

        **See also** **fromString** (), **QDate::toString** (),
        **QDateTime::toString** (), and **QLocale::toString** ().
        """
        ...

    @typing.overload
    def toString(self, format: str) -> str:
        """
        https://doc.qt.io/qt-5/qtime.html#toString-1

        **QString QTime::toString(Qt::DateFormat format = Qt::TextDate) const**

        This is an overloaded function.

        Returns the time as a string. The **format** parameter determines the
        format of the string.

        If **format** is **Qt::TextDate** , the string format is HH:mm:ss; e.g.
        1 second before midnight would be "23:59:59".

        If **format** is **Qt::ISODate** , the string format corresponds to the
        ISO 8601 extended specification for representations of dates,
        represented by HH:mm:ss. To include milliseconds in the ISO 8601 date,
        use the **format** **Qt::ISODateWithMs** , which corresponds to
        HH:mm:ss.zzz.

        The **format** options **Qt::SystemLocaleDate** :,
        **Qt::SystemLocaleShortDate**  and **Qt::SystemLocaleLongDate**  shall
        be removed in Qt 6. Their use should be replaced with:
        **QLocale::system().toString(time, QLocale::ShortFormat)**  or
        **QLocale::system().toString(time, QLocale::LongFormat)** .

        The **format** options **Qt::LocaleDate** ,
        **Qt::DefaultLocaleShortDate**  and **Qt::DefaultLocaleLongDate**  shall
        be removed in Qt 6. Their use should be replaced with:
        **QLocale().toString(time, QLocale::ShortFormat)**  or
        **QLocale().toString(time, QLocale::LongFormat)** .

        If the **format** is **Qt::RFC2822Date** , the string is formatted in an
        **RFC 2822**  compatible way. An example of this formatting is
        "23:59:20".

        If the time is invalid, an empty string will be returned.

        **See also** **fromString** (), **QDate::toString** (),
        **QDateTime::toString** (), and **QLocale::toString** ().
        """
        ...

    def msec(self) -> int:
        """
        https://doc.qt.io/qt-5/qtime.html#msec

        **int QTime::msec() const**

        Returns the millisecond part (0 to 999) of the time.

        Returns -1 if the time is invalid.

        **See also** **hour** (), **minute** (), and **second** ().
        """
        ...

    def second(self) -> int:
        """
        https://doc.qt.io/qt-5/qtime.html#second

        **int QTime::second() const**

        Returns the second part (0 to 59) of the time.

        Returns -1 if the time is invalid.

        **See also** **hour** (), **minute** (), and **msec** ().
        """
        ...

    def minute(self) -> int:
        """
        https://doc.qt.io/qt-5/qtime.html#minute

        **int QTime::minute() const**

        Returns the minute part (0 to 59) of the time.

        Returns -1 if the time is invalid.

        **See also** **hour** (), **second** (), and **msec** ().
        """
        ...

    def hour(self) -> int:
        """
        https://doc.qt.io/qt-5/qtime.html#hour

        **int QTime::hour() const**

        Returns the hour part (0 to 23) of the time.

        Returns -1 if the time is invalid.

        **See also** **minute** (), **second** (), and **msec** ().
        """
        ...

    @typing.overload
    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtime.html#isValid

        **bool QTime::isValid() const**

        Returns `true` if the time is valid; otherwise returns `false`. For
        example, the time 23:30:55.746 is valid, but 24:12:30 is invalid.

        **See also** **isNull** ().
        """
        ...

    @typing.overload
    @staticmethod
    def isValid(h: int, m: int, s: int, msec: int = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qtime.html#isValid-1

        **[static] bool QTime::isValid(int h , int m , int s , int ms = 0)**

        This is an overloaded function.

        Returns `true` if the specified time is valid; otherwise returns false.

        The time is valid if **h** is in the range 0 to 23, **m** and **s** are
        in the range 0 to 59, and **ms** is in the range 0 to 999.

        Example:

        QTime::isValid(21, 10, 30); // returns true
            QTime::isValid(22, 5,
        62); // returns false
        """
        ...

    def __bool__(self) -> int:
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtime.html#isNull

        **bool QTime::isNull() const**

        Returns `true` if the time is null (i.e., the **QTime**  object was
        constructed using the default constructor); otherwise returns false. A
        null time is also an invalid time.

        **See also** **isValid** ().
        """
        ...

    def toPyTime(self) -> datetime.time:
        ...

    def __hash__(self) -> int:
        ...

    def __repr__(self) -> str:
        ...
