"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5.QtCore import *


class QTextDecoder(PyQt5.sip.wrapper):
    """
    https://doc.qt.io/qt-5/qtextdecoder.html

    **Detailed Description**

    A text decoder converts text from an encoded text format into Unicode using
    a specific codec.

    The decoder converts text in this format into Unicode, remembering any state
    that is required between calls.

    **See also** **QTextCodec::makeDecoder** () and **QTextEncoder** .
    """

    @typing.overload
    def __init__(self, codec: QTextCodec) -> None:
        """
        https://doc.qt.io/qt-5/qtextdecoder.html#QTextDecoder-1

        **QTextDecoder::QTextDecoder(const QTextCodec * codec )**

        Constructs a text decoder for the given **codec**.
        """
        ...

    @typing.overload
    def __init__(
        self,
        codec: QTextCodec,
        flags: typing.Union[QTextCodec.ConversionFlags, QTextCodec.ConversionFlag],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtextdecoder.html#QTextDecoder-2

        **QTextDecoder::QTextDecoder(const QTextCodec * codec ,
        QTextCodec::ConversionFlags flags )**

        Constructs a text decoder for the given **codec** and conversion
        **flags**.

        This function was introduced in Qt 4.7.
        """
        ...

    @typing.overload
    def toUnicode(self, chars: bytes) -> str:
        """
        https://doc.qt.io/qt-5/qtextdecoder.html#toUnicode

        **QString QTextDecoder::toUnicode(const char * chars , int len )**

        Converts the first **len** bytes in **chars** to Unicode, returning the
        result.

        If not all characters are used (e.g. if only part of a multi-byte
        encoding is at the end of the characters), the decoder remembers enough
        state to continue with the next call to this function.
        """
        ...

    @typing.overload
    def toUnicode(self, ba: typing.Union[QByteArray, bytes, bytearray]) -> str:
        """
        https://doc.qt.io/qt-5/qtextdecoder.html#toUnicode-1

        **QString QTextDecoder::toUnicode(const QByteArray & ba )**

        This is an overloaded function.

        Converts the bytes in the byte array specified by **ba** to Unicode and
        returns the result.
        """
        ...
