"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtCore import *


class QTemporaryFile(QFile):
    """
    https://doc.qt.io/qt-5/qtemporaryfile.html

    **Detailed Description**

    QTemporaryFile is used to create unique temporary files safely. The file
    itself is created by calling **open** (). The name of the temporary file is
    guaranteed to be unique (i.e., you are guaranteed to not overwrite an
    existing file), and the file will subsequently be removed upon destruction
    of the QTemporaryFile object. This is an important technique that avoids
    data corruption for applications that store data in temporary files. The
    file name is either auto-generated, or created based on a template, which is
    passed to QTemporaryFile's constructor.

    Example:

    // Within a function/method...

            **QTemporaryFile**  file;
    if (file.open()) {
                // file.fileName() returns the unique file
    name
            }

            // The QTemporaryFile destructor removes the
    temporary file
            // as it goes out of scope.

    Reopening a QTemporaryFile after calling **close** () is safe. For as long
    as the QTemporaryFile object itself is not destroyed, the unique temporary
    file will exist and be kept open internally by QTemporaryFile.

    The file name of the temporary file can be found by calling **fileName** ().
    Note that this is only defined after the file is first opened; the function
    returns an empty string before this.

    A temporary file will have some static part of the name and some part that
    is calculated to be unique. The default filename will be determined from
    **QCoreApplication::applicationName** () (otherwise `qt_temp`) and will be
    placed into the temporary path as returned by **QDir::tempPath** (). If you
    specify your own filename, a relative file path will not be placed in the
    temporary directory by default, but be relative to the current working
    directory.

    Specified filenames can contain the following template `XXXXXX` (six upper
    case "X" characters), which will be replaced by the auto-generated portion
    of the filename. Note that the template is case sensitive. If the template
    is not present in the filename, QTemporaryFile appends the generated part to
    the filename given.

    **Note:** On Linux, QTemporaryFile will attempt to create unnamed temporary
    files. If that succeeds, **open** () will return true but **exists** () will
    be false. If you call **fileName** () or any function that calls it,
    QTemporaryFile will give the file a name, so most applications will not see
    a difference.

    **See also** **QDir::tempPath** () and **QFile** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qtemporaryfile.html#QTemporaryFile

        **QTemporaryFile::QTemporaryFile()**

        Constructs a QTemporaryFile using as file template the application name
        returned by **QCoreApplication::applicationName** () (otherwise
        `qt_temp`) followed by ".XXXXXX". The file is stored in the system's
        temporary directory, **QDir::tempPath** ().

        **See also** **setFileTemplate** () and **QDir::tempPath** ().
        """
        ...

    @typing.overload
    def __init__(self, templateName: str) -> None:
        """
        https://doc.qt.io/qt-5/qtemporaryfile.html#QTemporaryFile-1

        **QTemporaryFile::QTemporaryFile(const QString & templateName )**

        Constructs a QTemporaryFile with a template filename of
        **templateName**. Upon opening the temporary file this will be used to
        create a unique filename.

        If the **templateName** does not contain XXXXXX it will automatically be
        appended and used as the dynamic portion of the filename.

        If **templateName** is a relative path, the path will be relative to the
        current working directory. You can use **QDir::tempPath** () to
        construct **templateName** if you want use the system's temporary
        directory.

        **See also** **open** () and **fileTemplate** ().
        """
        ...

    @typing.overload
    def __init__(self, parent: QObject) -> None:
        """
        https://doc.qt.io/qt-5/qtemporaryfile.html#QTemporaryFile-2

        **QTemporaryFile::QTemporaryFile(QObject * parent )**

        Constructs a QTemporaryFile (with the given **parent** ) using as file
        template the application name returned by
        **QCoreApplication::applicationName** () (otherwise `qt_temp`) followed
        by ".XXXXXX". The file is stored in the system's temporary directory,
        **QDir::tempPath** ().

        **See also** **setFileTemplate** ().
        """
        ...

    @typing.overload
    def __init__(self, templateName: str, parent: QObject) -> None:
        """
        https://doc.qt.io/qt-5/qtemporaryfile.html#QTemporaryFile-3

        **QTemporaryFile::QTemporaryFile(const QString & templateName , QObject
        * parent )**

        Constructs a QTemporaryFile with a template filename of **templateName**
        and the specified **parent**. Upon opening the temporary file this will
        be used to create a unique filename.

        If the **templateName** does not contain XXXXXX it will automatically be
        appended and used as the dynamic portion of the filename.

        If **templateName** is a relative path, the path will be relative to the
        current working directory. You can use **QDir::tempPath** () to
        construct **templateName** if you want use the system's temporary
        directory.

        **See also** **open** () and **fileTemplate** ().
        """
        ...

    def rename(self, newName: str) -> bool:
        ...

    @typing.overload
    @staticmethod
    def createNativeFile(fileName: str) -> "QTemporaryFile":
        """
        https://doc.qt.io/qt-5/qtemporaryfile.html#createNativeFile

        **[static] QTemporaryFile *QTemporaryFile::createNativeFile(QFile & file
        )**

        If **file** is not already a native file, then a **QTemporaryFile**  is
        created in **QDir::tempPath** (), the contents of **file** is copied
        into it, and a pointer to the temporary file is returned. Does nothing
        and returns `0` if **file** is already a native file.

        For example:

        **QFile**  f(":/resources/file.txt");
              **QTemporaryFile**
        ::createNativeFile(f); // Returns a pointer to a temporary file
        **QFile**  f("/users/qt/file.txt");
              **QTemporaryFile**
        ::createNativeFile(f); // Returns 0

        **See also** **QFileInfo::isNativePath** ().
        """
        ...

    @typing.overload
    @staticmethod
    def createNativeFile(file: QFile) -> "QTemporaryFile":
        """
        https://doc.qt.io/qt-5/qtemporaryfile.html#createNativeFile-1

        **[static] QTemporaryFile *QTemporaryFile::createNativeFile(const
        QString & fileName )**

        This is an overloaded function.

        Works on the given **fileName** rather than an existing **QFile**
        object.
        """
        ...

    def setFileTemplate(self, name: str) -> None:
        """
        https://doc.qt.io/qt-5/qtemporaryfile.html#setFileTemplate

        **void QTemporaryFile::setFileTemplate(const QString & name )**

        Sets the static portion of the file name to **name**. If the file
        template contains XXXXXX that will automatically be replaced with the
        unique part of the filename, otherwise a filename will be determined
        automatically based on the static portion specified.

        If **name** contains a relative file path, the path will be relative to
        the current working directory. You can use **QDir::tempPath** () to
        construct **name** if you want use the system's temporary directory.

        **See also** **fileTemplate** ().
        """
        ...

    def fileTemplate(self) -> str:
        """
        https://doc.qt.io/qt-5/qtemporaryfile.html#fileTemplate

        **QString QTemporaryFile::fileTemplate() const**

        Returns the set file template. The default file template will be called
        qcoreappname.XXXXXX and be placed in **QDir::tempPath** ().

        **See also** **setFileTemplate** ().
        """
        ...

    def fileName(self) -> str:
        """
        https://doc.qt.io/qt-5/qtemporaryfile.html#fileName

        **[override virtual] QString QTemporaryFile::fileName() const**

        Reimplements: **QFile::fileName** () const.

        Returns the complete unique filename backing the **QTemporaryFile**
        object. This string is null before the **QTemporaryFile**  is opened,
        afterwards it will contain the **fileTemplate** () plus additional
        characters to make it unique.

        **See also** **fileTemplate** ().
        """
        ...

    @typing.overload
    def open(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtemporaryfile.html#open

        **bool QTemporaryFile::open()**

        A **QTemporaryFile**  will always be opened in **QIODevice::ReadWrite**
        mode, this allows easy access to the data in the file. This function
        will return true upon success and will set the **fileName** () to the
        unique filename used.

        **See also** **fileName** ().
        """
        ...

    @typing.overload
    def open(
        self, flags: typing.Union[QIODevice.OpenMode, QIODevice.OpenModeFlag]
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qtemporaryfile.html#open-1

        **[override virtual protected] bool
        QTemporaryFile::open(QIODevice::OpenMode flags )**

        Reimplements: **QFile::open** (QIODevice::OpenMode mode).

        Creates a unique file name for the temporary file, and opens it. You can
        get the unique name later by calling **fileName** (). The file is
        guaranteed to have been created by this function (i.e., it has never
        existed before).
        """
        ...

    def setAutoRemove(self, b: bool) -> None:
        """
        https://doc.qt.io/qt-5/qtemporaryfile.html#setAutoRemove

        **void QTemporaryFile::setAutoRemove(bool b )**

        Sets the **QTemporaryFile**  into auto-remove mode if **b** is `true`.

        Auto-remove is on by default.

        If you set this property to `false`, ensure the application provides a
        way to remove the file once it is no longer needed, including passing
        the responsibility on to another process. Always use the **fileName** ()
        function to obtain the name and never try to guess the name that
        **QTemporaryFile**  has generated.

        On some systems, if **fileName** () is not called before closing the
        file, the temporary file may be removed regardless of the state of this
        property. This behavior should not be relied upon, so application code
        should either call **fileName** () or leave the auto removal
        functionality enabled.

        **See also** **autoRemove** () and **remove** ().
        """
        ...

    def autoRemove(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtemporaryfile.html#autoRemove

        **bool QTemporaryFile::autoRemove() const**

        Returns `true` if the **QTemporaryFile**  is in auto remove mode. Auto-
        remove mode will automatically delete the filename from disk upon
        destruction. This makes it very easy to create your **QTemporaryFile**
        object on the stack, fill it with data, read from it, and finally on
        function return it will automatically clean up after itself.

        Auto-remove is on by default.

        **See also** **setAutoRemove** () and **remove** ().
        """
        ...
