"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import sip


class QTemporaryDir(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qtemporarydir.html

    **Detailed Description**

    QTemporaryDir is used to create unique temporary directories safely. The
    directory itself is created by the constructor. The name of the temporary
    directory is guaranteed to be unique (i.e., you are guaranteed to not
    overwrite an existing directory), and the directory will subsequently be
    removed upon destruction of the QTemporaryDir object. The directory name is
    either auto-generated, or created based on a template, which is passed to
    QTemporaryDir's constructor.

    Example:

    // Within a function/method...

            **QTemporaryDir**  dir;
    if (dir.isValid()) {
                // dir.path() returns the unique directory
    path
            }

            // The QTemporaryDir destructor removes the
    temporary directory
            // as it goes out of scope.

    It is very important to test that the temporary directory could be created,
    using **isValid** (). Do not use **exists()** , since a default-constructed
    **QDir**  represents the current directory, which exists.

    The path to the temporary directory can be found by calling **path** ().

    A temporary directory will have some static part of the name and some part
    that is calculated to be unique. The default path will be determined from
    **QCoreApplication::applicationName** () (otherwise `qt_temp`) and will be
    placed into the temporary path as returned by **QDir::tempPath** (). If you
    specify your own path, a relative path will not be placed in the temporary
    directory by default, but be relative to the current working directory. In
    all cases, a random string will be appended to the path in order to make it
    unique.

    **See also** **QDir::tempPath** (), **QDir** , and **QTemporaryFile** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qtemporarydir.html#QTemporaryDir

        **QTemporaryDir::QTemporaryDir()**

        Constructs a QTemporaryDir using as template the application name
        returned by **QCoreApplication::applicationName** () (otherwise
        `qt_temp`). The directory is stored in the system's temporary directory,
        **QDir::tempPath** ().

        **See also** **QDir::tempPath** ().
        """
        ...

    @typing.overload
    def __init__(self, templateName: str) -> None:
        """
        https://doc.qt.io/qt-5/qtemporarydir.html#QTemporaryDir-1

        **QTemporaryDir::QTemporaryDir(const QString & templatePath )**

        Constructs a QTemporaryDir with a template of **templatePath**.

        If **templatePath** is a relative path, the path will be relative to the
        current working directory. You can use **QDir::tempPath** () to
        construct **templatePath** if you want use the system's temporary
        directory.

        If the **templatePath** ends with XXXXXX it will be used as the dynamic
        portion of the directory name, otherwise it will be appended. Unlike
        **QTemporaryFile** , XXXXXX in the middle of the template string is not
        supported.

        **See also** **QDir::tempPath** ().
        """
        ...

    def filePath(self, fileName: str) -> str:
        """
        https://doc.qt.io/qt-5/qtemporarydir.html#filePath

        **QString QTemporaryDir::filePath(const QString & fileName ) const**

        Returns the path name of a file in the temporary directory. Does **not**
        check if the file actually exists in the directory. Redundant multiple
        separators or "." and ".." directories in **fileName** are not removed
        (see **QDir::cleanPath** ()). Absolute paths are not allowed.

        This function was introduced in Qt 5.9.
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qtemporarydir.html#errorString

        **QString QTemporaryDir::errorString() const**

        If **isValid** () returns `false`, this function returns the error
        string that explains why the creation of the temporary directory failed.
        Otherwise, this function return an empty string.

        This function was introduced in Qt 5.6.
        """
        ...

    def path(self) -> str:
        """
        https://doc.qt.io/qt-5/qtemporarydir.html#path

        **QString QTemporaryDir::path() const**

        Returns the path to the temporary directory. Empty if the
        **QTemporaryDir**  could not be created.
        """
        ...

    def remove(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtemporarydir.html#remove

        **bool QTemporaryDir::remove()**

        Removes the temporary directory, including all its contents.

        Returns `true` if removing was successful.
        """
        ...

    def setAutoRemove(self, b: bool) -> None:
        """
        https://doc.qt.io/qt-5/qtemporarydir.html#setAutoRemove

        **void QTemporaryDir::setAutoRemove(bool b )**

        Sets the **QTemporaryDir**  into auto-remove mode if **b** is true.

        Auto-remove is on by default.

        **See also** **autoRemove** () and **remove** ().
        """
        ...

    def autoRemove(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtemporarydir.html#autoRemove

        **bool QTemporaryDir::autoRemove() const**

        Returns `true` if the **QTemporaryDir**  is in auto remove mode. Auto-
        remove mode will automatically delete the directory from disk upon
        destruction. This makes it very easy to create your **QTemporaryDir**
        object on the stack, fill it with files, do something with the files,
        and finally on function return it will automatically clean up after
        itself.

        Auto-remove is on by default.

        **See also** **setAutoRemove** () and **remove** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtemporarydir.html#isValid

        **bool QTemporaryDir::isValid() const**

        Returns `true` if the **QTemporaryDir**  was created successfully.
        """
        ...
