"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5.QtCore import *


class QSocketNotifier(QObject):
    """
    https://doc.qt.io/qt-5/qsocketnotifier.html

    **Detailed Description**

    The QSocketNotifier makes it possible to integrate Qt's event loop with
    other event loops based on file descriptors. File descriptor action is
    detected in Qt's main event loop (**QCoreApplication::exec** ()).

    Once you have opened a device using a low-level (usually platform-specific)
    API, you can create a socket notifier to monitor the file descriptor. The
    socket notifier is enabled by default, i.e. it emits the **activated** ()
    signal whenever a socket event corresponding to its type occurs. Connect the
    **activated** () signal to the slot you want to be called when an event
    corresponding to your socket notifier's type occurs.

    There are three types of socket notifiers: read, write, and exception. The
    type is described by the **Type**  enum, and must be specified when
    constructing the socket notifier. After construction it can be determined
    using the **type** () function. Note that if you need to monitor both reads
    and writes for the same file descriptor, you must create two socket
    notifiers. Note also that it is not possible to install two socket notifiers
    of the same type (**Read** , **Write** , **Exception** ) on the same socket.

    The **setEnabled** () function allows you to disable as well as enable the
    socket notifier. It is generally advisable to explicitly enable or disable
    the socket notifier, especially for write notifiers. A disabled notifier
    ignores socket events (the same effect as not creating the socket notifier).
    Use the **isEnabled** () function to determine the notifier's current
    status.

    Finally, you can use the **socket** () function to retrieve the socket
    identifier. Although the class is called QSocketNotifier, it is normally
    used for other types of devices than sockets. **QTcpSocket**  and
    **QUdpSocket**  provide notification through signals, so there is normally
    no need to use a QSocketNotifier on them.

    **See also** **QFile** , **QProcess** , **QTcpSocket** , and **QUdpSocket**
    .
    """

    class Type(int):
        Read: QSocketNotifier = ...
        Write: QSocketNotifier = ...
        Exception: QSocketNotifier = ...

    def __init__(
        self,
        socket: PyQt5.sip.voidptr,
        a1: "QSocketNotifier.Type",
        parent: typing.Optional[QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsocketnotifier.html#QSocketNotifier

        **QSocketNotifier::QSocketNotifier(qintptr socket ,
        QSocketNotifier::Type type , QObject * parent = nullptr)**

        Constructs a socket notifier with the given **parent**. It enables the
        **socket** , and watches for events of the given **type**.

        It is generally advisable to explicitly enable or disable the socket
        notifier, especially for write notifiers.

        **Note for Windows users:** The socket passed to QSocketNotifier will
        become non-blocking, even if it was created as a blocking socket.

        **See also** **setEnabled** () and **isEnabled** ().
        """
        ...

    def event(self, a0: QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qsocketnotifier.html#event

        **[override virtual protected] bool QSocketNotifier::event(QEvent * e
        )**

        Reimplements: **QObject::event** (QEvent *e).
        """
        ...

    def setEnabled(self, a0: bool) -> None:
        """
        https://doc.qt.io/qt-5/qsocketnotifier.html#setEnabled

        **[slot] void QSocketNotifier::setEnabled(bool enable )**

        If **enable** is true, the notifier is enabled; otherwise the notifier
        is disabled.

        The notifier is enabled by default, i.e. it emits the **activated** ()
        signal whenever a socket event corresponding to its **type**  occurs. If
        it is disabled, it ignores socket events (the same effect as not
        creating the socket notifier).

        Write notifiers should normally be disabled immediately after the
        **activated** () signal has been emitted

        **See also** **isEnabled** () and **activated** ().
        """
        ...

    def isEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsocketnotifier.html#isEnabled

        **bool QSocketNotifier::isEnabled() const**

        Returns `true` if the notifier is enabled; otherwise returns `false`.

        **See also** **setEnabled** ().
        """
        ...

    def type(self) -> "QSocketNotifier.Type":
        """
        https://doc.qt.io/qt-5/qsocketnotifier.html#type

        **QSocketNotifier::Type QSocketNotifier::type() const**

        Returns the socket event type specified to the constructor.

        **See also** **socket** ().
        """
        ...

    def socket(self) -> PyQt5.sip.voidptr:
        """
        https://doc.qt.io/qt-5/qsocketnotifier.html#socket

        **qintptr QSocketNotifier::socket() const**

        Returns the socket identifier specified to the constructor.

        **See also** **type** ().
        """
        ...

    @property
    def activated(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qsocketnotifier.html#activated

        **[signal] void QSocketNotifier::activated(QSocketDescriptor socket ,
        QSocketNotifier::Type type )**

        This signal is emitted whenever the socket notifier is enabled and a
        socket event corresponding to its **type** occurs.

        The socket identifier is passed in the **socket** parameter.

        **Note:** This is a private signal. It can be used in signal connections
        but cannot be emitted by the user.

        **Note:** Signal **activated** is overloaded in this class. To connect
        to this signal by using the function pointer syntax, Qt provides a
        convenient helper for obtaining the function pointer as shown in this
        example:

        connect(socketNotifier, QOverload<QSocketDescriptor, **QSocketNotifier**
        ::Type>::of(&**QSocketNotifier** ::activated),
        [=](QSocketDescriptor socket, **QSocketNotifier** ::Type type){ /* ...
        */ });

        This function was introduced in Qt 5.15.

        **See also** **type** () and **socket** ().
        """
        ...
