"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QSizeF(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qsizef.html

    **Detailed Description**

    A size is specified by a **width** () and a **height** (). It can be set in
    the constructor and changed using the **setWidth** (), **setHeight** (), or
    **scale** () functions, or using arithmetic operators. A size can also be
    manipulated directly by retrieving references to the width and height using
    the **rwidth** () and **rheight** () functions. Finally, the width and
    height can be swapped using the **transpose** () function.

    The **isValid** () function determines if a size is valid. A valid size has
    both width and height greater than or equal to zero. The **isEmpty** ()
    function returns `true` if either of the width and height is **less** than
    (or equal to) zero, while the **isNull** () function returns `true` only if
    both the width and the height is zero.

    Use the **expandedTo** () function to retrieve a size which holds the
    maximum height and width of this size and a given size. Similarly, the
    **boundedTo** () function returns a size which holds the minimum height and
    width of this size and a given size.

    The QSizeF class also provides the **toSize** () function returning a
    **QSize**  copy of this size, constructed by rounding the width and height
    to the nearest integers.

    QSizeF objects can be streamed as well as compared.

    **See also** **QSize** , **QPointF** , and **QRectF** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qsizef.html#QSizeF

        **QSizeF::QSizeF()**

        Constructs an invalid size.

        **See also** **isValid** ().
        """
        ...

    @typing.overload
    def __init__(self, sz: QSize) -> None:
        """
        https://doc.qt.io/qt-5/qsizef.html#QSizeF-1

        **QSizeF::QSizeF(const QSize & size )**

        Constructs a size with floating point accuracy from the given **size**.

        **See also** **toSize** ().
        """
        ...

    @typing.overload
    def __init__(self, w: float, h: float) -> None:
        """
        https://doc.qt.io/qt-5/qsizef.html#QSizeF-2

        **QSizeF::QSizeF(qreal width , qreal height )**

        Constructs a size with the given **width** and **height**.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QSizeF") -> None:
        """
        https://doc.qt.io/qt-5/qsizef.html#QSizeF

        **QSizeF::QSizeF()**

        Constructs an invalid size.

        **See also** **isValid** ().
        """
        ...

    def shrunkBy(self, m: QMarginsF) -> "QSizeF":
        """
        https://doc.qt.io/qt-5/qsizef.html#shrunkBy

        **QSizeF QSizeF::shrunkBy(QMarginsF margins ) const**

        Returns the size that results from shrinking this size by **margins**.

        This function was introduced in Qt 5.14.

        **See also** **grownBy** ().
        """
        ...

    def grownBy(self, m: QMarginsF) -> "QSizeF":
        """
        https://doc.qt.io/qt-5/qsizef.html#grownBy

        **QSizeF QSizeF::grownBy(QMarginsF margins ) const**

        Returns the size that results from growing this size by **margins**.

        This function was introduced in Qt 5.14.

        **See also** **shrunkBy** ().
        """
        ...

    def transposed(self) -> "QSizeF":
        """
        https://doc.qt.io/qt-5/qsizef.html#transposed

        **QSizeF QSizeF::transposed() const**

        Returns the size with width and height values swapped.

        This function was introduced in Qt 5.0.

        **See also** **transpose** ().
        """
        ...

    @typing.overload
    def scaled(self, s: "QSizeF", mode: Qt.AspectRatioMode) -> "QSizeF":
        """
        https://doc.qt.io/qt-5/qsizef.html#scaled

        **QSizeF QSizeF::scaled(qreal width , qreal height , Qt::AspectRatioMode
        mode ) const**

        Returns a size scaled to a rectangle with the given **width** and
        **height** , according to the specified **mode**.

        This function was introduced in Qt 5.0.

        **See also** **scale** ().
        """
        ...

    @typing.overload
    def scaled(self, w: float, h: float, mode: Qt.AspectRatioMode) -> "QSizeF":
        """
        https://doc.qt.io/qt-5/qsizef.html#scaled-1

        **QSizeF QSizeF::scaled(const QSizeF & s , Qt::AspectRatioMode mode )
        const**

        This is an overloaded function.

        Returns a size scaled to a rectangle with the given size **s** ,
        according to the specified **mode**.

        This function was introduced in Qt 5.0.
        """
        ...

    def toSize(self) -> QSize:
        """
        https://doc.qt.io/qt-5/qsizef.html#toSize

        **QSize QSizeF::toSize() const**

        Returns an integer based copy of this size.

        Note that the coordinates in the returned size will be rounded to the
        nearest integer.

        **See also** **QSizeF** ().
        """
        ...

    def boundedTo(self, otherSize: "QSizeF") -> "QSizeF":
        """
        https://doc.qt.io/qt-5/qsizef.html#boundedTo

        **QSizeF QSizeF::boundedTo(const QSizeF & otherSize ) const**

        Returns a size holding the minimum width and height of this size and the
        given **otherSize**.

        **See also** **expandedTo** () and **scale** ().
        """
        ...

    def expandedTo(self, otherSize: "QSizeF") -> "QSizeF":
        """
        https://doc.qt.io/qt-5/qsizef.html#expandedTo

        **QSizeF QSizeF::expandedTo(const QSizeF & otherSize ) const**

        Returns a size holding the maximum width and height of this size and the
        given **otherSize**.

        **See also** **boundedTo** () and **scale** ().
        """
        ...

    def setHeight(self, h: float) -> None:
        """
        https://doc.qt.io/qt-5/qsizef.html#setHeight

        **void QSizeF::setHeight(qreal height )**

        Sets the height to the given **height**.

        **See also** **height** (), **rheight** (), and **setWidth** ().
        """
        ...

    def setWidth(self, w: float) -> None:
        """
        https://doc.qt.io/qt-5/qsizef.html#setWidth

        **void QSizeF::setWidth(qreal width )**

        Sets the width to the given **width**.

        **See also** **width** (), **rwidth** (), and **setHeight** ().
        """
        ...

    def height(self) -> float:
        """
        https://doc.qt.io/qt-5/qsizef.html#height

        **qreal QSizeF::height() const**

        Returns the height.

        **See also** **width** () and **setHeight** ().
        """
        ...

    def width(self) -> float:
        """
        https://doc.qt.io/qt-5/qsizef.html#width

        **qreal QSizeF::width() const**

        Returns the width.

        **See also** **height** () and **setWidth** ().
        """
        ...

    def __bool__(self) -> int:
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsizef.html#isValid

        **bool QSizeF::isValid() const**

        Returns `true` if both the width and height is equal to or greater than
        0; otherwise returns `false`.

        **See also** **isNull** () and **isEmpty** ().
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsizef.html#isEmpty

        **bool QSizeF::isEmpty() const**

        Returns `true` if either of the width and height is less than or equal
        to 0; otherwise returns `false`.

        **See also** **isNull** () and **isValid** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsizef.html#isNull

        **bool QSizeF::isNull() const**

        Returns `true` if both the width and height are 0.0 (ignoring the sign);
        otherwise returns `false`.

        **See also** **isValid** () and **isEmpty** ().
        """
        ...

    def __repr__(self) -> str:
        ...

    @typing.overload
    def scale(self, s: "QSizeF", mode: Qt.AspectRatioMode) -> None:
        """
        https://doc.qt.io/qt-5/qsizef.html#scale

        **void QSizeF::scale(qreal width , qreal height , Qt::AspectRatioMode
        mode )**

        Scales the size to a rectangle with the given **width** and **height** ,
        according to the specified **mode**.

        * If **mode** is **Qt::IgnoreAspectRatio** , the size is set to (
        **width** , **height** ).
          * If **mode** is **Qt::KeepAspectRatio** ,
        the current size is scaled to a rectangle as large as possible inside (
        **width** , **height** ), preserving the aspect ratio.
          * If **mode**
        is **Qt::KeepAspectRatioByExpanding** , the current size is scaled to a
        rectangle as small as possible outside ( **width** , **height** ),
        preserving the aspect ratio.

        Example:

        **QSizeF**  t1(10, 12);
            t1.scale(60, 60, Qt::IgnoreAspectRatio);
        // t1 is (60, 60)

            **QSizeF**  t2(10, 12);
            t2.scale(60, 60,
        Qt::KeepAspectRatio);
            // t2 is (50, 60)

            **QSizeF**  t3(10,
        12);
            t3.scale(60, 60, Qt::KeepAspectRatioByExpanding);
            // t3 is
        (60, 72)

        **See also** **setWidth** (), **setHeight** (), and **scaled** ().
        """
        ...

    @typing.overload
    def scale(self, w: float, h: float, mode: Qt.AspectRatioMode) -> None:
        """
        https://doc.qt.io/qt-5/qsizef.html#scale-1

        **void QSizeF::scale(const QSizeF & size , Qt::AspectRatioMode mode )**

        This is an overloaded function.

        Scales the size to a rectangle with the given **size** , according to
        the specified **mode**.
        """
        ...

    def transpose(self) -> None:
        """
        https://doc.qt.io/qt-5/qsizef.html#transpose

        **void QSizeF::transpose()**

        Swaps the width and height values.

        **See also** **setWidth** (), **setHeight** (), and **transposed** ().
        """
        ...
