"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QRegularExpression(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qregularexpression.html

    **Detailed Description**

    Regular expressions, or **regexps** , are a very powerful tool to handle
    strings and texts. This is useful in many contexts, e.g.,

    ValidationA regexp can test whether a substring meets some criteria, e.g. is
    an integer or contains no whitespace.
    SearchingA regexp provides more
    powerful pattern matching than simple substring matching, e.g., match one of
    the words **mail** , **letter** or **correspondence** , but none of the
    words **email** , **mailman** , **mailer** , **letterbox** , etc.
    Search
    and ReplaceA regexp can replace all occurrences of a substring with a
    different substring, e.g., replace all occurrences of **&** with **& amp;**
    except where the **&** is already followed by an **amp;**.
    String
    SplittingA regexp can be used to identify where a string should be split
    apart, e.g. splitting tab-delimited strings.

    This document is by no means a complete reference to pattern matching using
    regular expressions, and the following parts will require the reader to have
    some basic knowledge about Perl-like regular expressions and their pattern
    syntax.

    Good references about regular expressions include:

    * **Mastering Regular Expressions** (Third Edition) by Jeffrey E. F. Friedl,
    ISBN 0-596-52812-4;
      * the **pcrepattern** (3) man page, describing the
    pattern syntax supported by PCRE (the reference implementation of Perl-
    compatible regular expressions);
      * the **Perl's regular expression
    documentation**  and the **Perl's regular expression tutorial** .

    **Introduction**

    QRegularExpression implements Perl-compatible regular expressions. It fully
    supports Unicode. For an overview of the regular expression syntax supported
    by QRegularExpression, please refer to the aforementioned pcrepattern(3) man
    page. A regular expression is made up of two things: a **pattern string**
    and a set of **pattern options** that change the meaning of the pattern
    string.

    You can set the pattern string by passing a string to the QRegularExpression
    constructor:

    **QRegularExpression**  re("a pattern");

    This sets the pattern string to `a pattern`. You can also use the
    **setPattern** () function to set a pattern on an existing
    QRegularExpression object:

    **QRegularExpression**  re;
        re.setPattern("another pattern");

    Note that due to C++ literal strings rules, you must escape all backslashes
    inside the pattern string with another backslash:

    // matches two digits followed by a space and a word
    **QRegularExpression**  re("\\\\d\\\\d \\\\w+");

        // matches a backslash
    **QRegularExpression**  re2("\\\\\\\\");

    The **pattern** () function returns the pattern that is currently set for a
    QRegularExpression object:

    **QRegularExpression**  re("a third pattern");
        **QString**  pattern =
    re.pattern(); // pattern == "a third pattern"

    **Pattern Options**

    The meaning of the pattern string can be modified by setting one or more
    **pattern options**. For instance, it is possible to set a pattern to match
    case insensitively by setting the
    **QRegularExpression::CaseInsensitiveOption** .

    You can set the options by passing them to the QRegularExpression
    constructor, as in:

    // matches "Qt rocks", but also "QT rocks", "QT ROCKS", "qT rOcKs", etc.
    **QRegularExpression**  re("Qt rocks", **QRegularExpression**
    ::CaseInsensitiveOption);

    Alternatively, you can use the **setPatternOptions** () function on an
    existing QRegularExpressionObject:

    **QRegularExpression**  re("^\\\\d+$");
    re.setPatternOptions(**QRegularExpression** ::MultilineOption);
        // re
    matches any line in the subject string that contains only digits (but at
    least one)

    It is possible to get the pattern options currently set on a
    QRegularExpression object by using the **patternOptions** () function:

    **QRegularExpression**  re = **QRegularExpression** ("^two.*words$",
    **QRegularExpression** ::MultilineOption
    | **QRegularExpression** ::DotMatchesEverythingOption);
    **QRegularExpression** ::PatternOptions options = re.patternOptions();
    // options == QRegularExpression::MultilineOption |
    QRegularExpression::DotMatchesEverythingOption

    Please refer to the **QRegularExpression::PatternOption**  enum
    documentation for more information about each pattern option.

    **Match Type and Match Options**

    The last two arguments of the **match** () and the **globalMatch** ()
    functions set the match type and the match options. The match type is a
    value of the **QRegularExpression::MatchType**  enum; the "traditional"
    matching algorithm is chosen by using the **NormalMatch**  match type (the
    default). It is also possible to enable partial matching of the regular
    expression against a subject string: see the **partial matching**  section
    for more details.

    The match options are a set of one or more
    **QRegularExpression::MatchOption**  values. They change the way a specific
    match of a regular expression against a subject string is done. Please refer
    to the **QRegularExpression::MatchOption**  enum documentation for more
    details.

    **Normal Matching**

    In order to perform a match you can simply invoke the **match** () function
    passing a string to match against. We refer to this string as the **subject
    string**. The result of the **match** () function is a
    **QRegularExpressionMatch**  object that can be used to inspect the results
    of the match. For instance:

    // match two digits followed by a space and a word
    **QRegularExpression**  re("\\\\d\\\\d \\\\w+");
        **QRegularExpressionMatch**
    match = re.match("abc123 def");
        bool hasMatch = match.hasMatch(); //
    true

    If a match is successful, the (implicit) capturing group number 0 can be
    used to retrieve the substring matched by the entire pattern (see also the
    section about **extracting captured substrings** ):

    **QRegularExpression**  re("\\\\d\\\\d \\\\w+");
        **QRegularExpressionMatch**
    match = re.match("abc123 def");
        if (match.hasMatch()) {
    **QString**  matched = match.captured(0); // matched == "23 def"
            //
    ...
        }

    It's also possible to start a match at an arbitrary offset inside the
    subject string by passing the offset as an argument of the **match** ()
    function. In the following example `"12 abc"` is not matched because the
    match is started at offset 1:

    **QRegularExpression**  re("\\\\d\\\\d \\\\w+");
        **QRegularExpressionMatch**
    match = re.match("12 abc 45 def", 1);
        if (match.hasMatch()) {
    **QString**  matched = match.captured(0); // matched == "45 def"
            //
    ...
        }

    **Extracting captured substrings**

    The **QRegularExpressionMatch**  object contains also information about the
    substrings captured by the capturing groups in the pattern string. The
    **captured()**  function will return the string captured by the n-th
    capturing group:

    **QRegularExpression**  re("^(\\\\d\\\\d)/(\\\\d\\\\d)/(\\\\d\\\\d\\\\d\\\\d)$");
    **QRegularExpressionMatch**  match = re.match("08/12/1985");
        if
    (match.hasMatch()) {
            **QString**  day = match.captured(1); // day ==
    "08"
            **QString**  month = match.captured(2); // month == "12"
    **QString**  year = match.captured(3); // year == "1985"
            // ...
    }

    Capturing groups in the pattern are numbered starting from 1, and the
    implicit capturing group 0 is used to capture the substring that matched the
    entire pattern.

    It's also possible to retrieve the starting and the ending offsets (inside
    the subject string) of each captured substring, by using the
    **capturedStart()**  and the **capturedEnd()**  functions:

    **QRegularExpression**  re("abc(\\\\d+)def");
        **QRegularExpressionMatch**
    match = re.match("XYZabc123defXYZ");
        if (match.hasMatch()) {
            int
    startOffset = match.capturedStart(1); // startOffset == 6
            int
    endOffset = match.capturedEnd(1); // endOffset == 9
            // ...
        }

    All of these functions have an overload taking a **QString**  as a parameter
    in order to extract **named** captured substrings. For instance:

    **QRegularExpression**
    re("^(?<date>\\\\d\\\\d)/(?<month>\\\\d\\\\d)/(?<year>\\\\d\\\\d\\\\d\\\\d)$");
    **QRegularExpressionMatch**  match = re.match("08/12/1985");
        if
    (match.hasMatch()) {
            **QString**  date = match.captured("date"); //
    date == "08"
            **QString**  month = match.captured("month"); // month
    == "12"
            **QString**  year = match.captured("year"); // year == 1985
    }

    **Global Matching**

    **Global matching** is useful to find all the occurrences of a given regular
    expression inside a subject string. Suppose that we want to extract all the
    words from a given string, where a word is a substring matching the pattern
    `\\w+`.

    **QRegularExpression::globalMatch**  returns a
    **QRegularExpressionMatchIterator** , which is a Java-like forward iterator
    that can be used to iterate over the results. For instance:

    **QRegularExpression**  re("(\\\\w+)");
    **QRegularExpressionMatchIterator**  i = re.globalMatch("the quick fox");

    Since it's a Java-like iterator, the **QRegularExpressionMatchIterator**
    will point immediately before the first result. Every result is returned as
    a **QRegularExpressionMatch**  object. The **hasNext()**  function will
    return true if there's at least one more result, and **next()**  will return
    the next result and advance the iterator. Continuing from the previous
    example:

    **QStringList**  words;
        while (i.hasNext()) {
    **QRegularExpressionMatch**  match = i.next();
            **QString**  word =
    match.captured(1);
            words << word;
        }
        // words contains "the",
    "quick", "fox"

    You can also use **peekNext()**  to get the next result without advancing
    the iterator.

    It is possible to pass a starting offset and one or more match options to
    the **globalMatch** () function, exactly like normal matching with **match**
    ().

    **Partial Matching**

    A **partial match** is obtained when the end of the subject string is
    reached, but more characters are needed to successfully complete the match.
    Note that a partial match is usually much more inefficient than a normal
    match because many optimizations of the matching algorithm cannot be
    employed.

    A partial match must be explicitly requested by specifying a match type of
    **PartialPreferCompleteMatch**  or **PartialPreferFirstMatch**  when calling
    **QRegularExpression::match**  or **QRegularExpression::globalMatch** . If a
    partial match is found, then calling the **hasMatch()**  function on the
    **QRegularExpressionMatch**  object returned by **match** () will return
    `false`, but **hasPartialMatch()**  will return `true`.

    When a partial match is found, no captured substrings are returned, and the
    (implicit) capturing group 0 corresponding to the whole match captures the
    partially matched substring of the subject string.

    Note that asking for a partial match can still lead to a complete match, if
    one is found; in this case, **hasMatch()**  will return `true` and
    **hasPartialMatch()**  `false`. It never happens that a
    **QRegularExpressionMatch**  reports both a partial and a complete match.

    Partial matching is mainly useful in two scenarios: validating user input in
    real time and incremental/multi-segment matching.

    **Validating user input**

    Suppose that we would like the user to input a date in a specific format,
    for instance "MMM dd, yyyy". We can check the input validity with a pattern
    like:

    `^(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) \\d\\d?, \\d\\d\\d\\d$`

    (This pattern doesn't catch invalid days, but let's keep it for the
    example's purposes).

    We would like to validate the input with this regular expression **while**
    the user is typing it, so that we can report an error in the input as soon
    as it is committed (for instance, the user typed the wrong key). In order to
    do so we must distinguish three cases:

    * the input cannot possibly match the regular expression;
      * the input does
    match the regular expression;
      * the input does not match the regular
    expression right now, but it will if more characters will be added to it.

    Note that these three cases represent exactly the possible states of a
    **QValidator**  (see the **QValidator::State**  enum).

    In particular, in the last case we want the regular expression engine to
    report a partial match: we are successfully matching the pattern against the
    subject string but the matching cannot continue because the end of the
    subject is encountered. Notice, however, that the matching algorithm should
    continue and try all possibilities, and in case a complete (non-partial)
    match is found, then this one should be reported, and the input string
    accepted as fully valid.

    This behavior is implemented by the **PartialPreferCompleteMatch**  match
    type. For instance:

    **QString**  pattern("^(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)
    \\\\d\\\\d?, \\\\d\\\\d\\\\d\\\\d$");
        **QRegularExpression**  re(pattern);
    **QString**  input("Jan 21,");
        **QRegularExpressionMatch**  match =
    re.match(input, 0, **QRegularExpression** ::PartialPreferCompleteMatch);
    bool hasMatch = match.hasMatch(); // false
        bool hasPartialMatch =
    match.hasPartialMatch(); // true

    If matching the same regular expression against the subject string leads to
    a complete match, it is reported as usual:

    **QString**  input("Dec 8, 1985");
        **QRegularExpressionMatch**  match =
    re.match(input, 0, **QRegularExpression** ::PartialPreferCompleteMatch);
    bool hasMatch = match.hasMatch(); // true
        bool hasPartialMatch =
    match.hasPartialMatch(); // false

    Another example with a different pattern, showing the behavior of preferring
    a complete match over a partial one:

    **QRegularExpression**  re("abc\\\\w+X|def");
        **QRegularExpressionMatch**
    match = re.match("abcdef", 0, **QRegularExpression**
    ::PartialPreferCompleteMatch);
        bool hasMatch = match.hasMatch(); // true
    bool hasPartialMatch = match.hasPartialMatch(); // false
        **QString**
    captured = match.captured(0); // captured == "def"

    In this case, the subpattern `abc\\\\w+X` partially matches the subject
    string; however, the subpattern `def` matches the subject string completely,
    and therefore a complete match is reported.

    If multiple partial matches are found when matching (but no complete match),
    then the **QRegularExpressionMatch**  object will report the first one that
    is found. For instance:

    **QRegularExpression**  re("abc\\\\w+X|defY");
        **QRegularExpressionMatch**
    match = re.match("abcdef", 0, **QRegularExpression**
    ::PartialPreferCompleteMatch);
        bool hasMatch = match.hasMatch(); //
    false
        bool hasPartialMatch = match.hasPartialMatch(); // true
    **QString**  captured = match.captured(0); // captured == "abcdef"

    **Incremental/multi-segment matching**

    Incremental matching is another use case of partial matching. Suppose that
    we want to find the occurrences of a regular expression inside a large text
    (that is, substrings matching the regular expression). In order to do so we
    would like to "feed" the large text to the regular expression engines in
    smaller chunks. The obvious problem is what happens if the substring that
    matches the regular expression spans across two or more chunks.

    In this case, the regular expression engine should report a partial match,
    so that we can match again adding new data and (eventually) get a complete
    match. This implies that the regular expression engine may assume that there
    are other characters **beyond the end** of the subject string. This is not
    to be taken literally -- the engine will never try to access any character
    after the last one in the subject.

    QRegularExpression implements this behavior when using the
    **PartialPreferFirstMatch**  match type. This match type reports a partial
    match as soon as it is found, and other match alternatives are not tried
    (even if they could lead to a complete match). For instance:

    **QRegularExpression**  re("abc|ab");
        **QRegularExpressionMatch**  match
    = re.match("ab", 0, **QRegularExpression** ::PartialPreferFirstMatch);
    bool hasMatch = match.hasMatch(); // false
        bool hasPartialMatch =
    match.hasPartialMatch(); // true

    This happens because when matching the first branch of the alternation
    operator a partial match is found, and therefore matching stops, without
    trying the second branch. Another example:

    **QRegularExpression**  re("abc(def)?");
        **QRegularExpressionMatch**
    match = re.match("abc", 0, **QRegularExpression**
    ::PartialPreferFirstMatch);
        bool hasMatch = match.hasMatch(); // false
    bool hasPartialMatch = match.hasPartialMatch(); // true

    This shows what could seem a counterintuitive behavior of quantifiers: since
    `?` is greedy, then the engine tries first to continue the match after
    having matched `"abc"`; but then the matching reaches the end of the subject
    string, and therefore a partial match is reported. This is even more
    surprising in the following example:

    **QRegularExpression**  re("(abc)*");
        **QRegularExpressionMatch**  match
    = re.match("abc", 0, **QRegularExpression** ::PartialPreferFirstMatch);
    bool hasMatch = match.hasMatch(); // false
        bool hasPartialMatch =
    match.hasPartialMatch(); // true

    It's easy to understand this behavior if we remember that the engine expects
    the subject string to be only a substring of the whole text we're looking
    for a match into (that is, how we said before, that the engine assumes that
    there are other characters beyond the end of the subject string).

    Since the `*` quantifier is greedy, then reporting a complete match could be
    an error, because after the current subject `"abc"` there may be other
    occurrences of `"abc"`. For instance, the complete text could have been
    "abcabcX", and therefore the **right** match to report (in the complete
    text) would have been `"abcabc"`; by matching only against the leading
    `"abc"` we instead get a partial match.

    **Error Handling**

    It is possible for a QRegularExpression object to be invalid because of
    syntax errors in the pattern string. The **isValid** () function will return
    true if the regular expression is valid, or false otherwise:

    **QRegularExpression**  invalidRe("(unmatched|parenthesis");
        bool
    isValid = invalidRe.isValid(); // false

    You can get more information about the specific error by calling the
    **errorString** () function; moreover, the **patternErrorOffset** ()
    function will return the offset inside the pattern string

    **QRegularExpression**  invalidRe("(unmatched|parenthesis");
        if
    (!invalidRe.isValid()) {
            **QString**  errorString =
    invalidRe.errorString(); // errorString == "missing )"
            int
    errorOffset = invalidRe.patternErrorOffset(); // errorOffset == 22
    // ...
        }

    If a match is attempted with an invalid QRegularExpression, then the
    returned **QRegularExpressionMatch**  object will be invalid as well (that
    is, its **isValid()**  function will return false). The same applies for
    attempting a global match.

    **Unsupported Perl-compatible Regular Expressions Features**

    QRegularExpression does not support all the features available in Perl-
    compatible regular expressions. The most notable one is the fact that
    duplicated names for capturing groups are not supported, and using them can
    lead to undefined behavior.

    This may change in a future version of Qt.

    **Notes for QRegExp Users**

    The QRegularExpression class introduced in Qt 5 is a big improvement upon
    **QRegExp** , in terms of APIs offered, supported pattern syntax and speed
    of execution. The biggest difference is that QRegularExpression simply holds
    a regular expression, and it's **not** modified when a match is requested.
    Instead, a **QRegularExpressionMatch**  object is returned, in order to
    check the result of a match and extract the captured substring. The same
    applies with global matching and **QRegularExpressionMatchIterator** .

    Other differences are outlined below.

    **Different pattern syntax**

    Porting a regular expression from **QRegExp**  to QRegularExpression may
    require changes to the pattern itself.

    In certain scenarios, **QRegExp**  was too lenient and accepted patterns
    that are simply invalid when using QRegularExpression. These are somehow
    easy to detect, because the QRegularExpression objects built with these
    patterns are not valid (cf. **isValid** ()).

    In other cases, a pattern ported from **QRegExp**  to QRegularExpression may
    silently change semantics. Therefore, it is necessary to review the patterns
    used. The most notable cases of silent incompatibility are:

    * Curly braces are needed in order to use a hexadecimal escape like `\\xHHHH`
    with more than 2 digits. A pattern like `\\x2022` neeeds to be ported to
    `\\x{2022}`, or it will match a space (`0x20`) followed by the string `"22"`.
    In general, it is highly recommended to always use curly braces with the
    `\\x` escape, no matter the amount of digits specified.
      * A 0-to-n
    quantification like `{,n}` needs to be ported to `{0,n}` to preserve
    semantics. Otherwise, a pattern such as `\\d{,3}` would actually match a
    digit followed by the exact string `"{,3}"`.
      * **QRegExp**  by default
    does Unicode-aware matching, while QRegularExpression requires a separate
    option; see below for more details.

    **Porting from QRegExp::exactMatch()**

    **QRegExp::exactMatch** () in Qt 4 served two purposes: it exactly matched a
    regular expression against a subject string, and it implemented partial
    matching.

    **Porting from QRegExp's Exact Matching**

    Exact matching indicates whether the regular expression matches the entire
    subject string. For example, the classes yield on the subject string
    `"abc123"`:

    **QRegExp::exactMatch** ()**QRegularExpressionMatch::hasMatch** ()
    `"\\\\d+"` **false** **true**
    `"[a-z]+\\\\d+"` **true** **true**

    Exact matching is not reflected in QRegularExpression. If you want to be
    sure that the subject string matches the regular expression exactly, you can
    wrap the pattern using the **anchoredPattern** () function:

    **QString**  p("a .*|pattern");

        // re matches exactly the pattern
    string p
        **QRegularExpression**  re(**QRegularExpression**
    ::anchoredPattern(p));

    **Porting from QRegExp's Partial Matching**

    When using **QRegExp::exactMatch** (), if an exact match was not found, one
    could still find out how much of the subject string was matched by the
    regular expression by calling **QRegExp::matchedLength** (). If the returned
    length was equal to the subject string's length, then one could conclude
    that a partial match was found.

    QRegularExpression supports partial matching explicitly by means of the
    appropriate **MatchType** .

    **Global matching**

    Due to limitations of the **QRegExp**  API it was impossible to implement
    global matching correctly (that is, like Perl does). In particular, patterns
    that can match 0 characters (like `"a*"`) are problematic.

    **QRegularExpression::globalMatch** () implements Perl global match
    correctly, and the returned iterator can be used to examine each result.

    **Unicode properties support**

    When using **QRegExp** , character classes such as `\\w`, `\\d`, etc. match
    characters with the corresponding Unicode property: for instance, `\\d`
    matches any character with the Unicode Nd (decimal digit) property.

    Those character classes only match ASCII characters by default when using
    QRegularExpression: for instance, `\\d` matches exactly a character in the
    `0-9` ASCII range. It is possible to change this behaviour by using the
    **UseUnicodePropertiesOption**  pattern option.

    **Wildcard matching**

    There is no direct way to do wildcard matching in QRegularExpression.
    However, the **wildcardToRegularExpression**  method is provided to
    translate glob patterns into a Perl-compatible regular expression that can
    be used for that purpose.

    **Other pattern syntaxes**

    QRegularExpression supports only Perl-compatible regular expressions.

    **Minimal matching**

    **QRegExp::setMinimal** () implemented minimal matching by simply reversing
    the greediness of the quantifiers (**QRegExp**  did not support lazy
    quantifiers, like `*?`, `+?`, etc.). QRegularExpression instead does support
    greedy, lazy and possessive quantifiers. The **InvertedGreedinessOption**
    pattern option can be useful to emulate the effects of
    **QRegExp::setMinimal** (): if enabled, it inverts the greediness of
    quantifiers (greedy ones become lazy and vice versa).

    **Caret modes**

    The **AnchoredMatchOption**  match option can be used to emulate the
    **QRegExp::CaretAtOffset**  behaviour. There is no equivalent for the other
    **QRegExp::CaretMode**  modes.

    **Debugging Code that Uses QRegularExpression**

    QRegularExpression internally uses a just in time compiler (JIT) to optimize
    the execution of the matching algorithm. The JIT makes extensive usage of
    self-modifying code, which can lead debugging tools such as Valgrind to
    crash. You must enable all checks for self-modifying code if you want to
    debug programs using QRegularExpression (for instance, Valgrind's `--smc-
    check` command line option). The downside of enabling such checks is that
    your program will run considerably slower.

    To avoid that, the JIT is disabled by default if you compile Qt in debug
    mode. It is possible to override the default and enable or disable the JIT
    usage (both in debug or release mode) by setting the `QT_ENABLE_REGEXP_JIT`
    environment variable to a non-zero or zero value respectively.

    **See also** **QRegularExpressionMatch**  and
    **QRegularExpressionMatchIterator** .
    """

    class MatchOption(int):
        NoMatchOption: QRegularExpression = ...
        AnchoredMatchOption: QRegularExpression = ...
        DontCheckSubjectStringMatchOption: QRegularExpression = ...

    class MatchType(int):
        NormalMatch: QRegularExpression = ...
        PartialPreferCompleteMatch: QRegularExpression = ...
        PartialPreferFirstMatch: QRegularExpression = ...
        NoMatch: QRegularExpression = ...

    class PatternOption(int):
        NoPatternOption: QRegularExpression = ...
        CaseInsensitiveOption: QRegularExpression = ...
        DotMatchesEverythingOption: QRegularExpression = ...
        MultilineOption: QRegularExpression = ...
        ExtendedPatternSyntaxOption: QRegularExpression = ...
        InvertedGreedinessOption: QRegularExpression = ...
        DontCaptureOption: QRegularExpression = ...
        UseUnicodePropertiesOption: QRegularExpression = ...
        OptimizeOnFirstUsageOption: QRegularExpression = ...
        DontAutomaticallyOptimizeOption: QRegularExpression = ...

    class PatternOptions(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QRegularExpression.PatternOptions", "QRegularExpression.PatternOption"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QRegularExpression.PatternOptions") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QRegularExpression.PatternOptions":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class MatchOptions(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QRegularExpression.MatchOptions", "QRegularExpression.MatchOption"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QRegularExpression.MatchOptions") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QRegularExpression.MatchOptions":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qregularexpression.html#QRegularExpression

        **QRegularExpression::QRegularExpression()**

        Constructs a QRegularExpression object with an empty pattern and no
        pattern options.

        **See also** **setPattern** () and **setPatternOptions** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        pattern: str,
        options: typing.Union[
            "QRegularExpression.PatternOptions", "QRegularExpression.PatternOption"
        ] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qregularexpression.html#QRegularExpression-1

        **QRegularExpression::QRegularExpression(const QString & pattern ,
        QRegularExpression::PatternOptions options = NoPatternOption)**

        Constructs a QRegularExpression object using the given **pattern** as
        pattern and the **options** as the pattern options.

        **See also** **setPattern** () and **setPatternOptions** ().
        """
        ...

    @typing.overload
    def __init__(self, re: "QRegularExpression") -> None:
        """
        https://doc.qt.io/qt-5/qregularexpression.html#QRegularExpression-2

        **QRegularExpression::QRegularExpression(const QRegularExpression & re
        )**

        Constructs a QRegularExpression object as a copy of **re**.

        **See also** **operator=** ().
        """
        ...

    @staticmethod
    def anchoredPattern(expression: str) -> str:
        """
        https://doc.qt.io/qt-5/qregularexpression.html#anchoredPattern

        **[static] QString QRegularExpression::anchoredPattern(QStringView
        expression )**

        Returns the **expression** wrapped between the `\\A` and `\\z` anchors to
        be used for exact matching.

        This function was introduced in Qt 5.15.

        **See also** **Porting from QRegExp's Exact Matching** .
        """
        ...

    @staticmethod
    def wildcardToRegularExpression(str: str) -> str:
        """
        https://doc.qt.io/qt-5/qregularexpression.html#wildcardToRegularExpressi
        on

        **[static] QString
        QRegularExpression::wildcardToRegularExpression(QStringView pattern )**

        Returns a regular expression representation of the given glob
        **pattern**. The transformation is targeting file path globbing, which
        means in particular that path separators receive special treatment. This
        implies that it is not just a basic translation from "*" to ".*".

        **QString**  wildcard = **QRegularExpression**
        ::wildcardToRegularExpression("*.jpeg");
            // Will match files with
        names like:
            //    foo.jpeg
            //    f_o_o.jpeg
            //    föö.jpeg

        The returned regular expression is already fully anchored. In other
        words, there is no need of calling **anchoredPattern** () again on the
        result.

        **Warning:** Unlike **QRegExp** , this implementation follows closely
        the definition of wildcard for glob patterns:

        **c** Any character represents itself apart from those mentioned below.
        Thus **c** matches the character **c**.
        **?** Matches any single
        character. It is the same as **.** in full regexps.
        ***** Matches zero
        or more of any characters. It is the same as **.*** in full regexps.
        **[abc]** Matches one character given in the bracket.
        **[a-c]**
        Matches one character from the range given in the bracket.
        **[!abc]**
        Matches one character that is not given in the bracket. It is the same
        as **[^abc]** in full regexp.
        **[!a-c]** Matches one character that is
        not from the range given in the bracket. It is the same as **[^a-c]** in
        full regexp.

        **Note:** The backslash (\\\\) character is **not** an escape char in this
        context. In order to match one of the special characters, place it in
        square brackets (for example, `[?]`).

        More information about the implementation can be found in:

        * **The Wikipedia Glob article**
          * `man 7 glob`

        This function was introduced in Qt 5.15.

        **See also** **escape** ().
        """
        ...

    def __hash__(self) -> int:
        ...

    def optimize(self) -> None:
        """
        https://doc.qt.io/qt-5/qregularexpression.html#optimize

        **void QRegularExpression::optimize() const**

        Compiles the pattern immediately, including JIT compiling it (if the JIT
        is enabled) for optimization.

        This function was introduced in Qt 5.4.

        **See also** **isValid** () and **Debugging Code that Uses
        QRegularExpression** .
        """
        ...

    def namedCaptureGroups(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qregularexpression.html#namedCaptureGroups

        **QStringList QRegularExpression::namedCaptureGroups() const**

        Returns a list of **captureCount** () + 1 elements, containing the names
        of the named capturing groups in the pattern string. The list is sorted
        such that the element of the list at position `i` is the name of the
        `i`-th capturing group, if it has a name, or an empty string if that
        capturing group is unnamed.

        For instance, given the regular expression

        (?<day>\\d\\d)-(?<month>\\d\\d)-(?<year>\\d\\d\\d\\d) (\\w+) (?<name>\\w+)

        namedCaptureGroups() will return the following list:

        ("", "day", "month", "year", "", "name")

        which corresponds to the fact that the capturing group #0 (corresponding
        to the whole match) has no name, the capturing group #1 has name "day",
        the capturing group #2 has name "month", etc.

        If the regular expression is not valid, returns an empty list.

        This function was introduced in Qt 5.1.

        **See also** **isValid** (), **QRegularExpressionMatch::captured** (),
        and **QString::isEmpty** ().
        """
        ...

    @staticmethod
    def escape(str: str) -> str:
        """
        https://doc.qt.io/qt-5/qregularexpression.html#escape

        **[static] QString QRegularExpression::escape(QStringView str )**

        Escapes all characters of **str** so that they no longer have any
        special meaning when used as a regular expression pattern string, and
        returns the escaped string. For instance:

        **QString**  escaped = **QRegularExpression** ::escape("a(x) = f(x) +
        g(x)");
            // escaped == "a\\\\(x\\\\)\\\\ \\\\=\\\\ f\\\\(x\\\\)\\\\ \\\\+\\\\ g\\\\(x\\\\)"

        This is very convenient in order to build patterns from arbitrary
        strings:

        **QString**  pattern = "(" + **QRegularExpression** ::escape(name) +
        "|" + **QRegularExpression** ::escape(nickname) + ")";
        **QRegularExpression**  re(pattern);

        **Note:** This function implements Perl's quotemeta algorithm and
        escapes with a backslash all characters in **str** , except for the
        characters in the `[A-Z]`, `[a-z]` and `[0-9]` ranges, as well as the
        underscore (`_`) character. The only difference with Perl is that a
        literal NUL inside **str** is escaped with the sequence `"\\\\0"`
        (backslash + `'0'`), instead of `"\\\\\\0"` (backslash + `NUL`).

        This function was introduced in Qt 5.15.
        """
        ...

    def globalMatch(
        self,
        subject: str,
        offset: int = ...,
        matchType: "QRegularExpression.MatchType" = ...,
        matchOptions: typing.Union[
            "QRegularExpression.MatchOptions", "QRegularExpression.MatchOption"
        ] = ...,
    ) -> "QRegularExpressionMatchIterator":
        """
        https://doc.qt.io/qt-5/qregularexpression.html#globalMatch

        **QRegularExpressionMatchIterator QRegularExpression::globalMatch(const
        QString & subject , int offset = 0, QRegularExpression::MatchType
        matchType = NormalMatch, QRegularExpression::MatchOptions matchOptions =
        NoMatchOption) const**

        Attempts to perform a global match of the regular expression against the
        given **subject** string, starting at the position **offset** inside the
        subject, using a match of type **matchType** and honoring the given
        **matchOptions**.

        The returned **QRegularExpressionMatchIterator**  is positioned before
        the first match result (if any).

        **See also** **QRegularExpressionMatchIterator**  and **global
        matching** .
        """
        ...

    def match(
        self,
        subject: str,
        offset: int = ...,
        matchType: "QRegularExpression.MatchType" = ...,
        matchOptions: typing.Union[
            "QRegularExpression.MatchOptions", "QRegularExpression.MatchOption"
        ] = ...,
    ) -> "QRegularExpressionMatch":
        """
        https://doc.qt.io/qt-5/qregularexpression.html#match

        **QRegularExpressionMatch QRegularExpression::match(const QString &
        subject , int offset = 0, QRegularExpression::MatchType matchType =
        NormalMatch, QRegularExpression::MatchOptions matchOptions =
        NoMatchOption) const**

        Attempts to match the regular expression against the given **subject**
        string, starting at the position **offset** inside the subject, using a
        match of type **matchType** and honoring the given **matchOptions**.

        The returned **QRegularExpressionMatch**  object contains the results of
        the match.

        **See also** **QRegularExpressionMatch**  and **normal matching** .
        """
        ...

    def captureCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qregularexpression.html#captureCount

        **int QRegularExpression::captureCount() const**

        Returns the number of capturing groups inside the pattern string, or -1
        if the regular expression is not valid.

        **Note:** The implicit capturing group 0 is **not** included in the
        returned number.

        **See also** **isValid** ().
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qregularexpression.html#errorString

        **QString QRegularExpression::errorString() const**

        Returns a textual description of the error found when checking the
        validity of the regular expression, or "no error" if no error was found.

        **See also** **isValid** () and **patternErrorOffset** ().
        """
        ...

    def patternErrorOffset(self) -> int:
        """
        https://doc.qt.io/qt-5/qregularexpression.html#patternErrorOffset

        **int QRegularExpression::patternErrorOffset() const**

        Returns the offset, inside the pattern string, at which an error was
        found when checking the validity of the regular expression. If no error
        was found, then -1 is returned.

        **See also** **pattern** (), **isValid** (), and **errorString** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qregularexpression.html#isValid

        **bool QRegularExpression::isValid() const**

        Returns `true` if the regular expression is a valid regular expression
        (that is, it contains no syntax errors, etc.), or false otherwise. Use
        **errorString** () to obtain a textual description of the error.

        **See also** **errorString** () and **patternErrorOffset** ().
        """
        ...

    def setPattern(self, pattern: str) -> None:
        """
        https://doc.qt.io/qt-5/qregularexpression.html#setPattern

        **void QRegularExpression::setPattern(const QString & pattern )**

        Sets the pattern string of the regular expression to **pattern**. The
        pattern options are left unchanged.

        **See also** **pattern** () and **setPatternOptions** ().
        """
        ...

    def pattern(self) -> str:
        """
        https://doc.qt.io/qt-5/qregularexpression.html#pattern

        **QString QRegularExpression::pattern() const**

        Returns the pattern string of the regular expression.

        **See also** **setPattern** () and **patternOptions** ().
        """
        ...

    def swap(self, re: "QRegularExpression") -> None:
        """
        https://doc.qt.io/qt-5/qregularexpression.html#swap

        **void QRegularExpression::swap(QRegularExpression & other )**

        Swaps the regular expression **other** with this regular expression.
        This operation is very fast and never fails.
        """
        ...

    def __repr__(self) -> str:
        ...

    def setPatternOptions(
        self,
        options: typing.Union[
            "QRegularExpression.PatternOptions", "QRegularExpression.PatternOption"
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qregularexpression.html#setPatternOptions

        **void
        QRegularExpression::setPatternOptions(QRegularExpression::PatternOptions
        options )**

        Sets the given **options** as the pattern options of the regular
        expression. The pattern string is left unchanged.

        **See also** **patternOptions** () and **setPattern** ().
        """
        ...

    def patternOptions(self) -> "QRegularExpression.PatternOptions":
        """
        https://doc.qt.io/qt-5/qregularexpression.html#patternOptions

        **QRegularExpression::PatternOptions
        QRegularExpression::patternOptions() const**

        Returns the pattern options for the regular expression.

        **See also** **setPatternOptions** () and **pattern** ().
        """
        ...
