"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QRectF(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qrectf.html

    **Detailed Description**

    A rectangle is normally expressed as a top-left corner and a size. The size
    (width and height) of a QRectF is always equivalent to the mathematical
    rectangle that forms the basis for its rendering.

    A QRectF can be constructed with a set of left, top, width and height
    coordinates, or from a **QPointF**  and a **QSizeF** . The following code
    creates two identical rectangles.

    **QRectF**  r1(100.0, 200.1, 11.2, 16.3);
        **QRectF**  r2(**QPointF**
    (100.0, 200.1), **QSizeF** (11.2, 16.3));

    There is also a third constructor creating a QRectF from a **QRect** , and a
    corresponding **toRect** () function that returns a **QRect**  object based
    on the values of this rectangle (note that the coordinates in the returned
    rectangle are rounded to the nearest integer).

    The QRectF class provides a collection of functions that return the various
    rectangle coordinates, and enable manipulation of these. QRectF also
    provides functions to move the rectangle relative to the various
    coordinates. In addition there is a **moveTo** () function that moves the
    rectangle, leaving its top left corner at the given coordinates.
    Alternatively, the **translate** () function moves the rectangle the given
    offset relative to the current position, and the **translated** () function
    returns a translated copy of this rectangle.

    The **size** () function returns the rectangle's dimensions as a **QSizeF**
    . The dimensions can also be retrieved separately using the **width** () and
    **height** () functions. To manipulate the dimensions use the **setSize**
    (), **setWidth** () or **setHeight** () functions. Alternatively, the size
    can be changed by applying either of the functions setting the rectangle
    coordinates, for example, **setBottom** () or **setRight** ().

    The **contains** () function tells whether a given point is inside the
    rectangle or not, and the **intersects** () function returns `true` if this
    rectangle intersects with a given rectangle (otherwise false). The QRectF
    class also provides the **intersected** () function which returns the
    intersection rectangle, and the **united** () function which returns the
    rectangle that encloses the given rectangle and this:

    ![](images/qrect-intersect.png)![](images/qrect-unite.png)
    **intersected**
    ()**united** ()

    The **isEmpty** () function returns `true` if the rectangle's width or
    height is less than, or equal to, 0. Note that an empty rectangle is not
    valid: The **isValid** () function returns `true` if both width and height
    is larger than 0. A null rectangle (**isNull** () == true) on the other
    hand, has both width and height set to 0.

    Note that due to the way **QRect**  and QRectF are defined, an empty QRectF
    is defined in essentially the same way as **QRect** .

    Finally, QRectF objects can be streamed as well as compared.

    **Rendering**

    When using an **anti-aliased**  painter, the boundary line of a QRectF will
    be rendered symmetrically on both sides of the mathematical rectangle's
    boundary line. But when using an aliased painter (the default) other rules
    apply.

    Then, when rendering with a one pixel wide pen the QRectF's boundary line
    will be rendered to the right and below the mathematical rectangle's
    boundary line.

    When rendering with a two pixels wide pen the boundary line will be split in
    the middle by the mathematical rectangle. This will be the case whenever the
    pen is set to an even number of pixels, while rendering with a pen with an
    odd number of pixels, the spare pixel will be rendered to the right and
    below the mathematical rectangle as in the one pixel case.

    ![](images/qrect-diagram-zero.png)![](images/qrectf-diagram-one.png)
    Logical representationOne pixel wide pen
    ![](images/qrectf-diagram-
    two.png)![](images/qrectf-diagram-three.png)
    Two pixel wide penThree pixel
    wide pen

    **Coordinates**

    The QRectF class provides a collection of functions that return the various
    rectangle coordinates, and enable manipulation of these. QRectF also
    provides functions to move the rectangle relative to the various
    coordinates.

    For example: the **bottom** (), **setBottom** () and **moveBottom** ()
    functions: **bottom** () returns the y-coordinate of the rectangle's bottom
    edge, **setBottom** () sets the bottom edge of the rectangle to the given y
    coordinate (it may change the height, but will never change the rectangle's
    top edge) and **moveBottom** () moves the entire rectangle vertically,
    leaving the rectangle's bottom edge at the given y coordinate and its size
    unchanged.

    ![](images/qrectf-coordinates.png)

    It is also possible to add offsets to this rectangle's coordinates using the
    **adjust** () function, as well as retrieve a new rectangle based on
    adjustments of the original one using the **adjusted** () function. If
    either of the width and height is negative, use the **normalized** ()
    function to retrieve a rectangle where the corners are swapped.

    In addition, QRectF provides the **getCoords** () function which extracts
    the position of the rectangle's top-left and bottom-right corner, and the
    **getRect** () function which extracts the rectangle's top-left corner,
    width and height. Use the **setCoords** () and **setRect** () function to
    manipulate the rectangle's coordinates and dimensions in one go.

    **See also** **QRect**  and **QRegion** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#QRectF

        **QRectF::QRectF()**

        Constructs a null rectangle.

        **See also** **isNull** ().
        """
        ...

    @typing.overload
    def __init__(
        self, atopLeft: typing.Union[QPointF, QPoint], asize: "QSizeF"
    ) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#QRectF-1

        **QRectF::QRectF(const QPointF & topLeft , const QSizeF & size )**

        Constructs a rectangle with the given **topLeft** corner and the given
        **size**.

        **See also** **setTopLeft** () and **setSize** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        atopLeft: typing.Union[QPointF, QPoint],
        abottomRight: typing.Union[QPointF, QPoint],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#QRectF-2

        **QRectF::QRectF(const QPointF & topLeft , const QPointF & bottomRight
        )**

        Constructs a rectangle with the given **topLeft** and **bottomRight**
        corners.

        This function was introduced in Qt 4.3.

        **See also** **setTopLeft** () and **setBottomRight** ().
        """
        ...

    @typing.overload
    def __init__(
        self, aleft: float, atop: float, awidth: float, aheight: float
    ) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#QRectF-3

        **QRectF::QRectF(qreal x , qreal y , qreal width , qreal height )**

        Constructs a rectangle with ( **x** , **y** ) as its top-left corner and
        the given **width** and **height**.

        **See also** **setRect** ().
        """
        ...

    @typing.overload
    def __init__(self, r: QRect) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#QRectF-4

        **QRectF::QRectF(const QRect & rectangle )**

        Constructs a QRectF rectangle from the given **QRect**  **rectangle**.

        **See also** **toRect** ().
        """
        ...

    @typing.overload
    def __init__(self, a0: "QRectF") -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#QRectF

        **QRectF::QRectF()**

        Constructs a null rectangle.

        **See also** **isNull** ().
        """
        ...

    def transposed(self) -> "QRectF":
        """
        https://doc.qt.io/qt-5/qrectf.html#transposed

        **QRectF QRectF::transposed() const**

        Returns a copy of the rectangle that has its width and height exchanged:

        **QRectF**  r = {1.5, 5.1, 4.2, 2.4};
            r = r.transposed(); // r ==
        {1.5, 5.1, 2.4, 4.2}

        This function was introduced in Qt 5.7.

        **See also** **QSizeF::transposed** ().
        """
        ...

    def marginsRemoved(self, margins: QMarginsF) -> "QRectF":
        """
        https://doc.qt.io/qt-5/qrectf.html#marginsRemoved

        **QRectF QRectF::marginsRemoved(const QMarginsF & margins ) const**

        Removes the **margins** from the rectangle, shrinking it.

        This function was introduced in Qt 5.3.

        **See also** **marginsAdded** (), **operator+=** (), and **operator-=**
        ().
        """
        ...

    def marginsAdded(self, margins: QMarginsF) -> "QRectF":
        """
        https://doc.qt.io/qt-5/qrectf.html#marginsAdded

        **QRectF QRectF::marginsAdded(const QMarginsF & margins ) const**

        Returns a rectangle grown by the **margins**.

        This function was introduced in Qt 5.3.

        **See also** **operator+=** (), **marginsRemoved** (), and
        **operator-=** ().
        """
        ...

    def toRect(self) -> QRect:
        """
        https://doc.qt.io/qt-5/qrectf.html#toRect

        **QRect QRectF::toRect() const**

        Returns a **QRect**  based on the values of this rectangle. Note that
        the coordinates in the returned rectangle are rounded to the nearest
        integer.

        **See also** **QRectF** () and **toAlignedRect** ().
        """
        ...

    def toAlignedRect(self) -> QRect:
        """
        https://doc.qt.io/qt-5/qrectf.html#toAlignedRect

        **QRect QRectF::toAlignedRect() const**

        Returns a **QRect**  based on the values of this rectangle that is the
        smallest possible integer rectangle that completely contains this
        rectangle.

        This function was introduced in Qt 4.3.

        **See also** **toRect** ().
        """
        ...

    def united(self, r: "QRectF") -> "QRectF":
        """
        https://doc.qt.io/qt-5/qrectf.html#united

        **QRectF QRectF::united(const QRectF & rectangle ) const**

        Returns the bounding rectangle of this rectangle and the given
        **rectangle**.

        ![](images/qrect-unite.png)

        This function was introduced in Qt 4.2.

        **See also** **intersected** ().
        """
        ...

    def intersected(self, r: "QRectF") -> "QRectF":
        """
        https://doc.qt.io/qt-5/qrectf.html#intersected

        **QRectF QRectF::intersected(const QRectF & rectangle ) const**

        Returns the intersection of this rectangle and the given **rectangle**.
        Note that `r.intersected(s)` is equivalent to `r & s`.

        ![](images/qrect-intersect.png)

        This function was introduced in Qt 4.2.

        **See also** **intersects** (), **united** (), and **operator&=** ().
        """
        ...

    def setSize(self, s: "QSizeF") -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#setSize

        **void QRectF::setSize(const QSizeF & size )**

        Sets the size of the rectangle to the given **size**. The top-left
        corner is not moved.

        **See also** **size** (), **setWidth** (), and **setHeight** ().
        """
        ...

    def setHeight(self, ah: float) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#setHeight

        **void QRectF::setHeight(qreal height )**

        Sets the height of the rectangle to the given **height**. The bottom
        edge is changed, but not the top one.

        **See also** **height** () and **setSize** ().
        """
        ...

    def setWidth(self, aw: float) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#setWidth

        **void QRectF::setWidth(qreal width )**

        Sets the width of the rectangle to the given **width**. The right edge
        is changed, but not the left one.

        **See also** **width** () and **setSize** ().
        """
        ...

    def adjusted(self, xp1: float, yp1: float, xp2: float, yp2: float) -> "QRectF":
        """
        https://doc.qt.io/qt-5/qrectf.html#adjusted

        **QRectF QRectF::adjusted(qreal dx1 , qreal dy1 , qreal dx2 , qreal dy2
        ) const**

        Returns a new rectangle with **dx1** , **dy1** , **dx2** and **dy2**
        added respectively to the existing coordinates of this rectangle.

        **See also** **adjust** ().
        """
        ...

    def adjust(self, xp1: float, yp1: float, xp2: float, yp2: float) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#adjust

        **void QRectF::adjust(qreal dx1 , qreal dy1 , qreal dx2 , qreal dy2 )**

        Adds **dx1** , **dy1** , **dx2** and **dy2** respectively to the
        existing coordinates of the rectangle.

        **See also** **adjusted** () and **setRect** ().
        """
        ...

    def setCoords(self, xp1: float, yp1: float, xp2: float, yp2: float) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#setCoords

        **void QRectF::setCoords(qreal x1 , qreal y1 , qreal x2 , qreal y2 )**

        Sets the coordinates of the rectangle's top-left corner to ( **x1** ,
        **y1** ), and the coordinates of its bottom-right corner to ( **x2** ,
        **y2** ).

        **See also** **getCoords** () and **setRect** ().
        """
        ...

    def getCoords(self) -> typing.Tuple[float, float, float, float]:
        """
        https://doc.qt.io/qt-5/qrectf.html#getCoords

        **void QRectF::getCoords(qreal * x1 , qreal * y1 , qreal * x2 , qreal *
        y2 ) const**

        Extracts the position of the rectangle's top-left corner to * **x1** and
        * **y1** , and the position of the bottom-right corner to * **x2** and *
        **y2**.

        **See also** **setCoords** () and **getRect** ().
        """
        ...

    def setRect(self, ax: float, ay: float, aaw: float, aah: float) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#setRect

        **void QRectF::setRect(qreal x , qreal y , qreal width , qreal height
        )**

        Sets the coordinates of the rectangle's top-left corner to ( **x** ,
        **y** ), and its size to the given **width** and **height**.

        **See also** **getRect** () and **setCoords** ().
        """
        ...

    def getRect(self) -> typing.Tuple[float, float, float, float]:
        """
        https://doc.qt.io/qt-5/qrectf.html#getRect

        **void QRectF::getRect(qreal * x , qreal * y , qreal * width , qreal *
        height ) const**

        Extracts the position of the rectangle's top-left corner to * **x** and
        * **y** , and its dimensions to * **width** and * **height**.

        **See also** **setRect** () and **getCoords** ().
        """
        ...

    @typing.overload
    def translated(self, dx: float, dy: float) -> "QRectF":
        """
        https://doc.qt.io/qt-5/qrectf.html#translated

        **QRectF QRectF::translated(qreal dx , qreal dy ) const**

        Returns a copy of the rectangle that is translated **dx** along the x
        axis and **dy** along the y axis, relative to the current position.
        Positive values move the rectangle to the right and down.

        **See also** **translate** ().
        """
        ...

    @typing.overload
    def translated(self, p: typing.Union[QPointF, QPoint]) -> "QRectF":
        """
        https://doc.qt.io/qt-5/qrectf.html#translated-1

        **QRectF QRectF::translated(const QPointF & offset ) const**

        This is an overloaded function.

        Returns a copy of the rectangle that is translated **offset**.**x()**
        along the x axis and **offset**.**y()**  along the y axis, relative to
        the current position.
        """
        ...

    @typing.overload
    def moveTo(self, ax: float, ay: float) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#moveTo

        **void QRectF::moveTo(qreal x , qreal y )**

        Moves the rectangle, leaving the top-left corner at the given position (
        **x** , **y** ). The rectangle's size is unchanged.

        **See also** **translate** () and **moveTopLeft** ().
        """
        ...

    @typing.overload
    def moveTo(self, p: typing.Union[QPointF, QPoint]) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#moveTo-1

        **void QRectF::moveTo(const QPointF & position )**

        This is an overloaded function.

        Moves the rectangle, leaving the top-left corner at the given
        **position**.
        """
        ...

    @typing.overload
    def translate(self, dx: float, dy: float) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#translate

        **void QRectF::translate(qreal dx , qreal dy )**

        Moves the rectangle **dx** along the x-axis and **dy** along the y-axis,
        relative to the current position. Positive values move the rectangle to
        the right and downwards.

        **See also** **moveTopLeft** (), **moveTo** (), and **translated** ().
        """
        ...

    @typing.overload
    def translate(self, p: typing.Union[QPointF, QPoint]) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#translate-1

        **void QRectF::translate(const QPointF & offset )**

        This is an overloaded function.

        Moves the rectangle **offset**.**x()**  along the x axis and
        **offset**.**y()**  along the y axis, relative to the current position.
        """
        ...

    def size(self) -> "QSizeF":
        """
        https://doc.qt.io/qt-5/qrectf.html#size

        **QSizeF QRectF::size() const**

        Returns the size of the rectangle.

        **See also** **setSize** (), **width** (), and **height** ().
        """
        ...

    def height(self) -> float:
        """
        https://doc.qt.io/qt-5/qrectf.html#height

        **qreal QRectF::height() const**

        Returns the height of the rectangle.

        **See also** **setHeight** (), **width** (), and **size** ().
        """
        ...

    def width(self) -> float:
        """
        https://doc.qt.io/qt-5/qrectf.html#width

        **qreal QRectF::width() const**

        Returns the width of the rectangle.

        **See also** **setWidth** (), **height** (), and **size** ().
        """
        ...

    def moveCenter(self, p: typing.Union[QPointF, QPoint]) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#moveCenter

        **void QRectF::moveCenter(const QPointF & position )**

        Moves the rectangle, leaving the center point at the given **position**.
        The rectangle's size is unchanged.

        **See also** **center** ().
        """
        ...

    def moveBottomRight(self, p: typing.Union[QPointF, QPoint]) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#moveBottomRight

        **void QRectF::moveBottomRight(const QPointF & position )**

        Moves the rectangle, leaving the bottom-right corner at the given
        **position**. The rectangle's size is unchanged.

        **See also** **setBottomRight** (), **moveBottom** (), and **moveRight**
        ().
        """
        ...

    def moveBottomLeft(self, p: typing.Union[QPointF, QPoint]) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#moveBottomLeft

        **void QRectF::moveBottomLeft(const QPointF & position )**

        Moves the rectangle, leaving the bottom-left corner at the given
        **position**. The rectangle's size is unchanged.

        **See also** **setBottomLeft** (), **moveBottom** (), and **moveLeft**
        ().
        """
        ...

    def moveTopRight(self, p: typing.Union[QPointF, QPoint]) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#moveTopRight

        **void QRectF::moveTopRight(const QPointF & position )**

        Moves the rectangle, leaving the top-right corner at the given
        **position**. The rectangle's size is unchanged.

        **See also** **setTopRight** (), **moveTop** (), and **moveRight** ().
        """
        ...

    def moveTopLeft(self, p: typing.Union[QPointF, QPoint]) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#moveTopLeft

        **void QRectF::moveTopLeft(const QPointF & position )**

        Moves the rectangle, leaving the top-left corner at the given
        **position**. The rectangle's size is unchanged.

        **See also** **setTopLeft** (), **moveTop** (), and **moveLeft** ().
        """
        ...

    def moveBottom(self, pos: float) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#moveBottom

        **void QRectF::moveBottom(qreal y )**

        Moves the rectangle vertically, leaving the rectangle's bottom edge at
        the given **y** coordinate. The rectangle's size is unchanged.

        **See also** **bottom** (), **setBottom** (), and **moveTop** ().
        """
        ...

    def moveRight(self, pos: float) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#moveRight

        **void QRectF::moveRight(qreal x )**

        Moves the rectangle horizontally, leaving the rectangle's right edge at
        the given **x** coordinate. The rectangle's size is unchanged.

        **See also** **right** (), **setRight** (), and **moveLeft** ().
        """
        ...

    def moveTop(self, pos: float) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#moveTop

        **void QRectF::moveTop(qreal y )**

        Moves the rectangle vertically, leaving the rectangle's top line at the
        given **y** coordinate. The rectangle's size is unchanged.

        **See also** **top** (), **setTop** (), and **moveBottom** ().
        """
        ...

    def moveLeft(self, pos: float) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#moveLeft

        **void QRectF::moveLeft(qreal x )**

        Moves the rectangle horizontally, leaving the rectangle's left edge at
        the given **x** coordinate. The rectangle's size is unchanged.

        **See also** **left** (), **setLeft** (), and **moveRight** ().
        """
        ...

    def center(self) -> QPointF:
        """
        https://doc.qt.io/qt-5/qrectf.html#center

        **QPointF QRectF::center() const**

        Returns the center point of the rectangle.

        **See also** **moveCenter** ().
        """
        ...

    def setBottomRight(self, p: typing.Union[QPointF, QPoint]) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#setBottomRight

        **void QRectF::setBottomRight(const QPointF & position )**

        Set the bottom-right corner of the rectangle to the given **position**.
        May change the size, but will never change the top-left corner of the
        rectangle.

        **See also** **bottomRight** () and **moveBottomRight** ().
        """
        ...

    def setBottomLeft(self, p: typing.Union[QPointF, QPoint]) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#setBottomLeft

        **void QRectF::setBottomLeft(const QPointF & position )**

        Set the bottom-left corner of the rectangle to the given **position**.
        May change the size, but will never change the top-right corner of the
        rectangle.

        **See also** **bottomLeft** () and **moveBottomLeft** ().
        """
        ...

    def setTopRight(self, p: typing.Union[QPointF, QPoint]) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#setTopRight

        **void QRectF::setTopRight(const QPointF & position )**

        Set the top-right corner of the rectangle to the given **position**. May
        change the size, but will never change the bottom-left corner of the
        rectangle.

        **See also** **topRight** () and **moveTopRight** ().
        """
        ...

    def setTopLeft(self, p: typing.Union[QPointF, QPoint]) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#setTopLeft

        **void QRectF::setTopLeft(const QPointF & position )**

        Set the top-left corner of the rectangle to the given **position**. May
        change the size, but will never change the bottom-right corner of the
        rectangle.

        **See also** **topLeft** () and **moveTopLeft** ().
        """
        ...

    def setBottom(self, pos: float) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#setBottom

        **void QRectF::setBottom(qreal y )**

        Sets the bottom edge of the rectangle to the given **y** coordinate. May
        change the height, but will never change the top edge of the rectangle.

        **See also** **bottom** () and **moveBottom** ().
        """
        ...

    def setTop(self, pos: float) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#setTop

        **void QRectF::setTop(qreal y )**

        Sets the top edge of the rectangle to the given **y** coordinate. May
        change the height, but will never change the bottom edge of the
        rectangle.

        Equivalent to **setY** ().

        **See also** **top** () and **moveTop** ().
        """
        ...

    def setRight(self, pos: float) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#setRight

        **void QRectF::setRight(qreal x )**

        Sets the right edge of the rectangle to the given **x** coordinate. May
        change the width, but will never change the left edge of the rectangle.

        **See also** **right** () and **moveRight** ().
        """
        ...

    def setLeft(self, pos: float) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#setLeft

        **void QRectF::setLeft(qreal x )**

        Sets the left edge of the rectangle to the given **x** coordinate. May
        change the width, but will never change the right edge of the rectangle.

        Equivalent to **setX** ().

        **See also** **left** () and **moveLeft** ().
        """
        ...

    def y(self) -> float:
        """
        https://doc.qt.io/qt-5/qrectf.html#y

        **qreal QRectF::y() const**

        Returns the y-coordinate of the rectangle's top edge. Equivalent to
        **top** ().

        **See also** **setY** (), **x** (), and **topLeft** ().
        """
        ...

    def x(self) -> float:
        """
        https://doc.qt.io/qt-5/qrectf.html#x

        **qreal QRectF::x() const**

        Returns the x-coordinate of the rectangle's left edge. Equivalent to
        **left** ().

        **See also** **setX** (), **y** (), and **topLeft** ().
        """
        ...

    def __bool__(self) -> int:
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qrectf.html#isValid

        **bool QRectF::isValid() const**

        Returns `true` if the rectangle is valid, otherwise returns `false`.

        A valid rectangle has a **width** () > 0 and **height** () > 0\\. Note
        that non-trivial operations like intersections are not defined for
        invalid rectangles. A valid rectangle is not empty (i.e., isValid() ==
        !**isEmpty** ()).

        **See also** **isNull** (), **isEmpty** (), and **normalized** ().
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-5/qrectf.html#isEmpty

        **bool QRectF::isEmpty() const**

        Returns `true` if the rectangle is empty, otherwise returns `false`.

        An empty rectangle has **width** () <= 0 or **height** () <= 0. An empty
        rectangle is not valid (i.e., isEmpty() == !**isValid** ()).

        Use the **normalized** () function to retrieve a rectangle where the
        corners are swapped.

        **See also** **isNull** (), **isValid** (), and **normalized** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qrectf.html#isNull

        **bool QRectF::isNull() const**

        Returns `true` if the rectangle is a null rectangle, otherwise returns
        `false`.

        A null rectangle has both the width and the height set to 0. A null
        rectangle is also empty, and hence not valid.

        **See also** **isEmpty** () and **isValid** ().
        """
        ...

    def intersects(self, r: "QRectF") -> bool:
        """
        https://doc.qt.io/qt-5/qrectf.html#intersects

        **bool QRectF::intersects(const QRectF & rectangle ) const**

        Returns `true` if this rectangle intersects with the given **rectangle**
        (i.e. there is a non-empty area of overlap between them), otherwise
        returns `false`.

        The intersection rectangle can be retrieved using the **intersected** ()
        function.

        **See also** **contains** ().
        """
        ...

    @typing.overload
    def __contains__(self, p: typing.Union[QPointF, QPoint]) -> int:
        ...

    @typing.overload
    def __contains__(self, r: "QRectF") -> int:
        ...

    @typing.overload
    def contains(self, p: typing.Union[QPointF, QPoint]) -> bool:
        """
        https://doc.qt.io/qt-5/qrectf.html#contains

        **bool QRectF::contains(const QPointF & point ) const**

        Returns `true` if the given **point** is inside or on the edge of the
        rectangle; otherwise returns `false`.

        **See also** **intersects** ().
        """
        ...

    @typing.overload
    def contains(self, r: "QRectF") -> bool:
        """
        https://doc.qt.io/qt-5/qrectf.html#contains-1

        **bool QRectF::contains(const QRectF & rectangle ) const**

        This is an overloaded function.

        Returns `true` if the given **rectangle** is inside this rectangle;
        otherwise returns `false`.
        """
        ...

    @typing.overload
    def contains(self, ax: float, ay: float) -> bool:
        """
        https://doc.qt.io/qt-5/qrectf.html#contains-2

        **bool QRectF::contains(qreal x , qreal y ) const**

        This is an overloaded function.

        Returns `true` if the point ( **x** , **y** ) is inside or on the edge
        of the rectangle; otherwise returns `false`.
        """
        ...

    def bottomLeft(self) -> QPointF:
        """
        https://doc.qt.io/qt-5/qrectf.html#bottomLeft

        **QPointF QRectF::bottomLeft() const**

        Returns the position of the rectangle's bottom-left corner.

        **See also** **setBottomLeft** (), **bottom** (), and **left** ().
        """
        ...

    def topRight(self) -> QPointF:
        """
        https://doc.qt.io/qt-5/qrectf.html#topRight

        **QPointF QRectF::topRight() const**

        Returns the position of the rectangle's top-right corner.

        **See also** **setTopRight** (), **top** (), and **right** ().
        """
        ...

    def bottomRight(self) -> QPointF:
        """
        https://doc.qt.io/qt-5/qrectf.html#bottomRight

        **QPointF QRectF::bottomRight() const**

        Returns the position of the rectangle's bottom-right corner.

        **See also** **setBottomRight** (), **bottom** (), and **right** ().
        """
        ...

    def topLeft(self) -> QPointF:
        """
        https://doc.qt.io/qt-5/qrectf.html#topLeft

        **QPointF QRectF::topLeft() const**

        Returns the position of the rectangle's top-left corner.

        **See also** **setTopLeft** (), **top** (), and **left** ().
        """
        ...

    def setY(self, pos: float) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#setY

        **void QRectF::setY(qreal y )**

        Sets the top edge of the rectangle to the given **y** coordinate. May
        change the height, but will never change the bottom edge of the
        rectangle.

        Equivalent to **setTop** ().

        **See also** **y** (), **setX** (), and **setTopLeft** ().
        """
        ...

    def setX(self, pos: float) -> None:
        """
        https://doc.qt.io/qt-5/qrectf.html#setX

        **void QRectF::setX(qreal x )**

        Sets the left edge of the rectangle to the given **x** coordinate. May
        change the width, but will never change the right edge of the rectangle.

        Equivalent to **setLeft** ().

        **See also** **x** (), **setY** (), and **setTopLeft** ().
        """
        ...

    def bottom(self) -> float:
        """
        https://doc.qt.io/qt-5/qrectf.html#bottom

        **qreal QRectF::bottom() const**

        Returns the y-coordinate of the rectangle's bottom edge.

        **See also** **setBottom** (), **bottomLeft** (), and **bottomRight**
        ().
        """
        ...

    def right(self) -> float:
        """
        https://doc.qt.io/qt-5/qrectf.html#right

        **qreal QRectF::right() const**

        Returns the x-coordinate of the rectangle's right edge.

        **See also** **setRight** (), **topRight** (), and **bottomRight** ().
        """
        ...

    def top(self) -> float:
        """
        https://doc.qt.io/qt-5/qrectf.html#top

        **qreal QRectF::top() const**

        Returns the y-coordinate of the rectangle's top edge. Equivalent to
        **y** ().

        **See also** **setTop** (), **topLeft** (), and **topRight** ().
        """
        ...

    def left(self) -> float:
        """
        https://doc.qt.io/qt-5/qrectf.html#left

        **qreal QRectF::left() const**

        Returns the x-coordinate of the rectangle's left edge. Equivalent to
        **x** ().

        **See also** **setLeft** (), **topLeft** (), and **bottomLeft** ().
        """
        ...

    def normalized(self) -> "QRectF":
        """
        https://doc.qt.io/qt-5/qrectf.html#normalized

        **QRectF QRectF::normalized() const**

        Returns a normalized rectangle; i.e., a rectangle that has a non-
        negative width and height.

        If **width** () < 0 the function swaps the left and right corners, and
        it swaps the top and bottom corners if **height** () < 0.

        **See also** **isValid** () and **isEmpty** ().
        """
        ...

    def __repr__(self) -> str:
        ...
