"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QReadWriteLock(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qreadwritelock.html

    **Detailed Description**

    A read-write lock is a synchronization tool for protecting resources that
    can be accessed for reading and writing. This type of lock is useful if you
    want to allow multiple threads to have simultaneous read-only access, but as
    soon as one thread wants to write to the resource, all other threads must be
    blocked until the writing is complete.

    In many cases, QReadWriteLock is a direct competitor to **QMutex** .
    QReadWriteLock is a good choice if there are many concurrent reads and
    writing occurs infrequently.

    Example:

    **QReadWriteLock**  lock;

        void ReaderThread::run()
        {
    ...
            lock.lockForRead();
            read_file();
            lock.unlock();
    ...
        }

        void WriterThread::run()
        {
            ...
    lock.lockForWrite();
            write_file();
            lock.unlock();
    ...
        }

    To ensure that writers aren't blocked forever by readers, readers attempting
    to obtain a lock will not succeed if there is a blocked writer waiting for
    access, even if the lock is currently only accessed by other readers. Also,
    if the lock is accessed by a writer and another writer comes in, that writer
    will have priority over any readers that might also be waiting.

    Like **QMutex** , a QReadWriteLock can be recursively locked by the same
    thread when constructed with **QReadWriteLock::Recursive**  as
    **QReadWriteLock::RecursionMode** . In such cases, **unlock** () must be
    called the same number of times **lockForWrite** () or **lockForRead** ()
    was called. Note that the lock type cannot be changed when trying to lock
    recursively, i.e. it is not possible to lock for reading in a thread that
    already has locked for writing (and vice versa).

    **See also** **QReadLocker** , **QWriteLocker** , **QMutex** , and
    **QSemaphore** .
    """

    class RecursionMode(int):
        NonRecursive: QReadWriteLock = ...
        Recursive: QReadWriteLock = ...

    def __init__(self, recursionMode: "QReadWriteLock.RecursionMode" = ...) -> None:
        """
        https://doc.qt.io/qt-5/qreadwritelock.html#QReadWriteLock

        **QReadWriteLock::QReadWriteLock(QReadWriteLock::RecursionMode
        recursionMode = NonRecursive)**

        Constructs a QReadWriteLock object in the given **recursionMode**.

        The default recursion mode is **NonRecursive** .

        This function was introduced in Qt 4.4.

        **See also** **lockForRead** (), **lockForWrite** (), and
        **RecursionMode** .
        """
        ...

    def unlock(self) -> None:
        """
        https://doc.qt.io/qt-5/qreadwritelock.html#unlock

        **void QReadWriteLock::unlock()**

        Unlocks the lock.

        Attempting to unlock a lock that is not locked is an error, and will
        result in program termination.

        **See also** **lockForRead** (), **lockForWrite** (), **tryLockForRead**
        (), and **tryLockForWrite** ().
        """
        ...

    @typing.overload
    def tryLockForWrite(self) -> bool:
        """
        https://doc.qt.io/qt-5/qreadwritelock.html#tryLockForWrite

        **bool QReadWriteLock::tryLockForWrite()**

        Attempts to lock for writing. If the lock was obtained, this function
        returns `true`; otherwise, it returns `false` immediately.

        The lock attempt will fail if another thread has locked for reading or
        writing.

        If the lock was obtained, the lock must be unlocked with **unlock** ()
        before another thread can successfully lock it.

        It is not possible to lock for write if the thread already has locked
        for read.

        **See also** **unlock** () and **lockForWrite** ().
        """
        ...

    @typing.overload
    def tryLockForWrite(self, timeout: int) -> bool:
        """
        https://doc.qt.io/qt-5/qreadwritelock.html#tryLockForWrite-1

        **bool QReadWriteLock::tryLockForWrite(int timeout )**

        This is an overloaded function.

        Attempts to lock for writing. This function returns `true` if the lock
        was obtained; otherwise it returns `false`. If another thread has locked
        for reading or writing, this function will wait for at most **timeout**
        milliseconds for the lock to become available.

        Note: Passing a negative number as the **timeout** is equivalent to
        calling **lockForWrite** (), i.e. this function will wait forever until
        lock can be locked for writing when **timeout** is negative.

        If the lock was obtained, the lock must be unlocked with **unlock** ()
        before another thread can successfully lock it.

        It is not possible to lock for write if the thread already has locked
        for read.

        **See also** **unlock** () and **lockForWrite** ().
        """
        ...

    def lockForWrite(self) -> None:
        """
        https://doc.qt.io/qt-5/qreadwritelock.html#lockForWrite

        **void QReadWriteLock::lockForWrite()**

        Locks the lock for writing. This function will block the current thread
        if another thread (including the current) has locked for reading or
        writing (unless the lock has been created using the
        **QReadWriteLock::Recursive**  mode).

        It is not possible to lock for write if the thread already has locked
        for read.

        **See also** **unlock** (), **lockForRead** (), and **tryLockForWrite**
        ().
        """
        ...

    @typing.overload
    def tryLockForRead(self) -> bool:
        """
        https://doc.qt.io/qt-5/qreadwritelock.html#tryLockForRead

        **bool QReadWriteLock::tryLockForRead()**

        Attempts to lock for reading. If the lock was obtained, this function
        returns `true`, otherwise it returns `false` instead of waiting for the
        lock to become available, i.e. it does not block.

        The lock attempt will fail if another thread has locked for writing.

        If the lock was obtained, the lock must be unlocked with **unlock** ()
        before another thread can successfully lock it for writing.

        It is not possible to lock for read if the thread already has locked for
        write.

        **See also** **unlock** () and **lockForRead** ().
        """
        ...

    @typing.overload
    def tryLockForRead(self, timeout: int) -> bool:
        """
        https://doc.qt.io/qt-5/qreadwritelock.html#tryLockForRead-1

        **bool QReadWriteLock::tryLockForRead(int timeout )**

        This is an overloaded function.

        Attempts to lock for reading. This function returns `true` if the lock
        was obtained; otherwise it returns `false`. If another thread has locked
        for writing, this function will wait for at most **timeout**
        milliseconds for the lock to become available.

        Note: Passing a negative number as the **timeout** is equivalent to
        calling **lockForRead** (), i.e. this function will wait forever until
        lock can be locked for reading when **timeout** is negative.

        If the lock was obtained, the lock must be unlocked with **unlock** ()
        before another thread can successfully lock it for writing.

        It is not possible to lock for read if the thread already has locked for
        write.

        **See also** **unlock** () and **lockForRead** ().
        """
        ...

    def lockForRead(self) -> None:
        """
        https://doc.qt.io/qt-5/qreadwritelock.html#lockForRead

        **void QReadWriteLock::lockForRead()**

        Locks the lock for reading. This function will block the current thread
        if another thread has locked for writing.

        It is not possible to lock for read if the thread already has locked for
        write.

        **See also** **unlock** (), **lockForWrite** (), and **tryLockForRead**
        ().
        """
        ...
