"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
from PyQt5.QtCore import *


class QObjectCleanupHandler(QObject):
    """
    https://doc.qt.io/qt-5/qobjectcleanuphandler.html

    **Detailed Description**

    A QObjectCleanupHandler is useful whenever you need to know when a number of
    **QObject** s that are owned by someone else have been deleted. This is
    important, for example, when referencing memory in an application that has
    been allocated in a shared library.

    To keep track of some **QObject** s, create a QObjectCleanupHandler, and
    **add** () the objects you are interested in. If you are no longer
    interested in tracking a particular object, use **remove** () to remove it
    from the cleanup handler. If an object being tracked by the cleanup handler
    gets deleted by someone else it will automatically be removed from the
    cleanup handler. You can delete all the objects in the cleanup handler with
    **clear** (), or by destroying the cleanup handler. **isEmpty** () returns
    `true` if the QObjectCleanupHandler has no objects to keep track of.

    **See also** **QPointer** .
    """

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qobjectcleanuphandler.html#QObjectCleanupHandler

        **QObjectCleanupHandler::QObjectCleanupHandler()**

        Constructs an empty QObjectCleanupHandler.
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qobjectcleanuphandler.html#clear

        **void QObjectCleanupHandler::clear()**

        Deletes all objects in this cleanup handler. The cleanup handler becomes
        empty.

        **See also** **isEmpty** ().
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-5/qobjectcleanuphandler.html#isEmpty

        **bool QObjectCleanupHandler::isEmpty() const**

        Returns `true` if this cleanup handler is empty or if all objects in
        this cleanup handler have been destroyed; otherwise return false.

        **See also** **add** (), **remove** (), and **clear** ().
        """
        ...

    def remove(self, object: QObject) -> None:
        """
        https://doc.qt.io/qt-5/qobjectcleanuphandler.html#remove

        **void QObjectCleanupHandler::remove(QObject * object )**

        Removes the **object** from this cleanup handler. The object will not be
        destroyed.

        **See also** **add** ().
        """
        ...

    def add(self, object: QObject) -> QObject:
        """
        https://doc.qt.io/qt-5/qobjectcleanuphandler.html#add

        **QObject *QObjectCleanupHandler::add(QObject * object )**

        Adds **object** to this cleanup handler and returns the pointer to the
        object.

        **See also** **remove** ().
        """
        ...
