"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QMutexLocker(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qmutexlocker.html

    **Detailed Description**

    Locking and unlocking a **QMutex**  in complex functions and statements or
    in exception handling code is error-prone and difficult to debug.
    QMutexLocker can be used in such situations to ensure that the state of the
    mutex is always well-defined.

    QMutexLocker should be created within a function where a **QMutex**  needs
    to be locked. The mutex is locked when QMutexLocker is created. You can
    unlock and relock the mutex with `unlock()` and `relock()`. If locked, the
    mutex will be unlocked when the QMutexLocker is destroyed.

    For example, this complex function locks a **QMutex**  upon entering the
    function and unlocks the mutex at all the exit points:

    int complexFunction(int flag)
        {
            mutex.lock();

            int
    retVal = 0;

            switch (flag) {
            case 0:
            case 1:
    retVal = moreComplexFunction(flag);
                break;
            case 2:
    {
                    int status = anotherFunction();
                    if (status
    < 0) {
                        mutex.unlock();
                        return -2;
    }
                    retVal = status + flag;
                }
                break;
    default:
                if (flag > 10) {
                    mutex.unlock();
    return -1;
                }
                break;
            }
    mutex.unlock();
            return retVal;
        }

    This example function will get more complicated as it is developed, which
    increases the likelihood that errors will occur.

    Using QMutexLocker greatly simplifies the code, and makes it more readable:

    int complexFunction(int flag)
        {
            **QMutexLocker**
    locker(&mutex);

            int retVal = 0;

            switch (flag) {
    case 0:
            case 1:
                return moreComplexFunction(flag);
    case 2:
                {
                    int status = anotherFunction();
    if (status < 0)
                        return -2;
                    retVal =
    status + flag;
                }
                break;
            default:
    if (flag > 10)
                    return -1;
                break;
            }
    return retVal;
        }

    Now, the mutex will always be unlocked when the QMutexLocker object is
    destroyed (when the function returns since `locker` is an auto variable).

    The same principle applies to code that throws and catches exceptions. An
    exception that is not caught in the function that has locked the mutex has
    no way of unlocking the mutex before the exception is passed up the stack to
    the calling function.

    QMutexLocker also provides a `mutex()` member function that returns the
    mutex on which the QMutexLocker is operating. This is useful for code that
    needs access to the mutex, such as **QWaitCondition::wait** (). For example:

    class SignalWaiter
        {
        private:
            **QMutexLocker**  locker;
    public:
            SignalWaiter(**QMutex**  *mutex)
                : locker(mutex)
    {
            }

            void waitForSignal()
            {
                ...
    while (!signalled)
                    waitCondition.wait(locker.mutex());
    ...
            }
        };

    **See also** **QReadLocker** , **QWriteLocker** , and **QMutex** .
    """

    @typing.overload
    def __init__(self, m: "QMutex") -> None:
        """
        https://doc.qt.io/qt-5/qmutexlocker.html#QMutexLocker

        **QMutexLocker::QMutexLocker(QMutex * mutex )**

        Constructs a QMutexLocker and locks **mutex**. The mutex will be
        unlocked when the QMutexLocker is destroyed. If **mutex** is `nullptr`,
        QMutexLocker does nothing.

        **See also** **QMutex::lock** ().
        """
        ...

    @typing.overload
    def __init__(self, m: "QRecursiveMutex") -> None:
        """
        https://doc.qt.io/qt-5/qmutexlocker.html#QMutexLocker-1

        **QMutexLocker::QMutexLocker(QRecursiveMutex * mutex )**

        Constructs a QMutexLocker and locks **mutex**. The mutex will be
        unlocked (**unlock** () called) when the QMutexLocker is destroyed. If
        **mutex** is `nullptr`, QMutexLocker does nothing.

        This function was introduced in Qt 5.14.

        **See also** **QMutex::lock** ().
        """
        ...

    def __exit__(
        self, type: typing.Any, value: typing.Any, traceback: typing.Any
    ) -> None:
        ...

    def __enter__(self) -> typing.Any:
        ...

    def mutex(self) -> "QMutex":
        """
        https://doc.qt.io/qt-5/qmutexlocker.html#mutex

        **QMutex *QMutexLocker::mutex() const**

        Returns the mutex on which the **QMutexLocker**  is operating.
        """
        ...

    def relock(self) -> None:
        """
        https://doc.qt.io/qt-5/qmutexlocker.html#relock

        **void QMutexLocker::relock()**

        Relocks an unlocked mutex locker.

        **See also** **unlock** ().
        """
        ...

    def unlock(self) -> None:
        """
        https://doc.qt.io/qt-5/qmutexlocker.html#unlock

        **void QMutexLocker::unlock()**

        Unlocks this mutex locker. You can use `relock()` to lock it again. It
        does not need to be locked when destroyed.

        **See also** **relock** ().
        """
        ...
