"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import sip


class QMimeType(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qmimetype.html

    **Detailed Description**

    For instance a file named "readme.txt" has the MIME type "text/plain". The
    MIME type can be determined from the file name, or from the file contents,
    or from both. MIME type determination can also be done on buffers of data
    not coming from files.

    Determining the MIME type of a file can be useful to make sure your
    application supports it. It is also useful in file-manager-like applications
    or widgets, in order to display an appropriate **icon**  for the file, or
    even the descriptive **comment**  in detailed views.

    To check if a file has the expected MIME type, you should use **inherits**
    () rather than a simple string comparison based on the **name** (). This is
    because MIME types can inherit from each other: for instance a C source file
    is a specific type of plain text file, so text/x-csrc inherits text/plain.

    **See also** **QMimeDatabase**  and **MIME Type Browser Example** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qmimetype.html#QMimeType

        **QMimeType::QMimeType()**

        Constructs this QMimeType object initialized with default property
        values that indicate an invalid MIME type.
        """
        ...

    @typing.overload
    def __init__(self, other: "QMimeType") -> None:
        """
        https://doc.qt.io/qt-5/qmimetype.html#QMimeType-1

        **QMimeType::QMimeType(const QMimeType & other )**

        Constructs this QMimeType object as a copy of **other**.
        """
        ...

    def __hash__(self) -> int:
        ...

    def filterString(self) -> str:
        """
        https://doc.qt.io/qt-5/qmimetype.html#filterString-prop

        **filterString : const QString**

        This property holds a filter string usable for a file dialog

        While this property was introduced in 5.10, the corresponding accessor
        method has always been there.

        **Access functions:**

        QString **filterString** () const
        """
        ...

    def inherits(self, mimeTypeName: str) -> bool:
        """
        https://doc.qt.io/qt-5/qmimetype.html#inherits

        **bool QMimeType::inherits(const QString & mimeTypeName ) const**

        Returns `true` if this mimetype is **mimeTypeName** , or inherits
        **mimeTypeName** (see **parentMimeTypes** ()), or **mimeTypeName** is an
        alias for this mimetype.

        This method has been made invokable from QML since 5.10.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def preferredSuffix(self) -> str:
        """
        https://doc.qt.io/qt-5/qmimetype.html#preferredSuffix-prop

        **preferredSuffix : const QString**

        This property holds the preferred suffix for the MIME type

        No leading dot is included, so for instance this would return "pdf" for
        application/pdf. The return value can be empty, for mime types which do
        not have any suffixes associated.

        While this property was introduced in 5.10, the corresponding accessor
        method has always been there.

        **Access functions:**

        QString **preferredSuffix** () const
        """
        ...

    def suffixes(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qmimetype.html#suffixes-prop

        **suffixes : const QStringList**

        This property holds the known suffixes for the MIME type

        No leading dot is included, so for instance this would return "jpg",
        "jpeg" for image/jpeg.

        While this property was introduced in 5.10, the corresponding accessor
        method has always been there.

        **Access functions:**

        QStringList **suffixes** () const
        """
        ...

    def aliases(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qmimetype.html#aliases-prop

        **aliases : const QStringList**

        This property holds the list of aliases of this mimetype

        For instance, for text/csv, the returned list would be: text/x-csv,
        text/x-comma-separated-values.

        Note that all **QMimeType**  instances refer to proper mimetypes, never
        to aliases directly.

        The order of the aliases in the list is undefined.

        While this property was introduced in 5.10, the corresponding accessor
        method has always been there.

        **Access functions:**

        QStringList **aliases** () const
        """
        ...

    def allAncestors(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qmimetype.html#allAncestors-prop

        **allAncestors : const QStringList**

        This property holds the names of direct and indirect parent MIME types

        Return all the parent mimetypes of this mimetype, direct and indirect.
        This includes the parent(s) of its parent(s), etc.

        For instance, for image/svg+xml the list would be: application/xml,
        text/plain, application/octet-stream.

        Note that application/octet-stream is the ultimate parent for all types
        of files (but not directories).

        While this property was introduced in 5.10, the corresponding accessor
        method has always been there.

        **Access functions:**

        QStringList **allAncestors** () const
        """
        ...

    def parentMimeTypes(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qmimetype.html#parentMimeTypes-prop

        **parentMimeTypes : const QStringList**

        This property holds the names of parent MIME types

        A type is a subclass of another type if any instance of the first type
        is also an instance of the second. For example, all image/svg+xml files
        are also text/xml, text/plain and application/octet-stream files.
        Subclassing is about the format, rather than the category of the data
        (for example, there is no 'generic spreadsheet' class that all
        spreadsheets inherit from). Conversely, the parent mimetype of
        image/svg+xml is text/xml.

        A mimetype can have multiple parents. For instance application/x-perl
        has two parents: application/x-executable and text/plain. This makes it
        possible to both execute perl scripts, and to open them in text editors.

        While this property was introduced in 5.10, the corresponding accessor
        method has always been there.

        **Access functions:**

        QStringList **parentMimeTypes** () const
        """
        ...

    def globPatterns(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qmimetype.html#globPatterns-prop

        **globPatterns : const QStringList**

        This property holds the list of glob matching patterns

        While this property was introduced in 5.10, the corresponding accessor
        method has always been there.

        **Access functions:**

        QStringList **globPatterns** () const
        """
        ...

    def iconName(self) -> str:
        """
        https://doc.qt.io/qt-5/qmimetype.html#iconName-prop

        **iconName : const QString**

        This property holds the file name of an icon image that represents the
        MIME type

        The icon name can be given to **QIcon::fromTheme** () in order to load
        the icon.

        While this property was introduced in 5.10, the corresponding accessor
        method has always been there.

        **Access functions:**

        QString **iconName** () const
        """
        ...

    def genericIconName(self) -> str:
        """
        https://doc.qt.io/qt-5/qmimetype.html#genericIconName-prop

        **genericIconName : const QString**

        This property holds the file name of a generic icon that represents the
        MIME type

        This should be used if the icon returned by **iconName** () cannot be
        found on the system. It is used for categories of similar types (like
        spreadsheets or archives) that can use a common icon. The
        freedesktop.org Icon Naming Specification lists a set of such icon
        names.

        The icon name can be given to **QIcon::fromTheme** () in order to load
        the icon.

        While this property was introduced in 5.10, the corresponding accessor
        method has always been there.

        **Access functions:**

        QString **genericIconName** () const
        """
        ...

    def comment(self) -> str:
        """
        https://doc.qt.io/qt-5/qmimetype.html#comment-prop

        **comment : const QString**

        This property holds the description of the MIME type to be displayed on
        user interfaces

        The default language (QLocale().**name** ()) is used to select the
        appropriate translation.

        While this property was introduced in 5.10, the corresponding accessor
        method has always been there.

        **Access functions:**

        QString **comment** () const
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-5/qmimetype.html#name-prop

        **name : const QString**

        This property holds the name of the MIME type

        While this property was introduced in 5.10, the corresponding accessor
        method has always been there.

        **Access functions:**

        QString **name** () const
        """
        ...

    def isDefault(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmimetype.html#isDefault-prop

        **isDefault : const bool**

        `true` if this MIME type is the default MIME type which applies to all
        files: application/octet-stream.

        While this property was introduced in 5.10, the corresponding accessor
        method has always been there.

        **Access functions:**

        bool **isDefault** () const
        """
        ...

    def isValid(self) -> bool:
        ...

    def swap(self, other: "QMimeType") -> None:
        """
        https://doc.qt.io/qt-5/qmimetype.html#swap

        **void QMimeType::swap(QMimeType & other )**

        Swaps **QMimeType**  **other** with this **QMimeType**  object.

        This operation is very fast and never fails.

        The swap() method helps with the implementation of assignment operators
        in an exception-safe way. For more information consult **More C++ Idioms
        - Copy-and-swap** .
        """
        ...
