"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtCore import *


class QMimeData(QObject):
    """
    https://doc.qt.io/qt-5/qmimedata.html

    **Detailed Description**

    QMimeData is used to describe information that can be stored in the
    **clipboard** , and transferred via the **drag and drop**  mechanism.
    QMimeData objects associate the data that they hold with the corresponding
    MIME types to ensure that information can be safely transferred between
    applications, and copied around within the same application.

    QMimeData objects are usually created using `new` and supplied to **QDrag**
    or **QClipboard**  objects. This is to enable Qt to manage the memory that
    they use.

    A single QMimeData object can store the same data using several different
    formats at the same time. The **formats** () function returns a list of the
    available formats in order of preference. The **data** () function returns
    the raw data associated with a MIME type, and **setData** () allows you to
    set the data for a MIME type.

    For the most common MIME types, QMimeData provides convenience functions to
    access the data:

    TesterGetterSetterMIME Types
    **hasText** ()**text** ()**setText**
    ()`text/plain`
    **hasHtml** ()**html** ()**setHtml** ()`text/html`
    **hasUrls** ()**urls** ()**setUrls** ()`text/uri-list`
    **hasImage**
    ()**imageData** ()**setImageData** ()`image/` *
    **hasColor**
    ()**colorData** ()**setColorData** ()`application/x-color`

    For example, if your write a widget that accepts URL drags, you would end up
    writing code like this:

    void MyWidget::dragEnterEvent(**QDragEnterEvent**  *event)
        {
            if
    (event->mimeData()->hasUrls())
                event->acceptProposedAction();
    }

        void MyWidget::dropEvent(**QDropEvent**  *event)
        {
            if
    (event->mimeData()->hasUrls()) {
                foreach (**QUrl**  url,
    event->mimeData()->urls()) {
                    ...
                }
            }
    }

    There are three approaches for storing custom data in a QMimeData object:

    1. Custom data can be stored directly in a QMimeData object as a
    **QByteArray**  using **setData** (). For example:
    **QByteArray**  csvData = ...;

        **QMimeData**  *mimeData = new
    **QMimeData** ;
        mimeData->setData("text/csv", csvData);

      2. We can
    subclass QMimeData and reimplement **hasFormat** (), **formats** (), and
    **retrieveData** ().
      3. If the drag and drop operation occurs within a
    single application, we can subclass QMimeData and add extra data in it, and
    use a **qobject_cast** () in the receiver's drop event handler. For example:
    void MyWidget::dropEvent(**QDropEvent**  *event)
        {
            const
    MyMimeData *myData =
                    qobject_cast<const MyMimeData
    *>(event->mimeData());
            if (myData) {
                // access myData's
    data directly (not through QMimeData's API)
            }
        }

    **Platform-Specific MIME Types**

    On Windows, **formats** () will also return custom formats available in the
    MIME data, using the `x-qt-windows-mime` subtype to indicate that they
    represent data in non-standard formats. The formats will take the following
    form:

    application/x-qt-windows-mime;value="<custom type>"

    The following are examples of custom MIME types:

    application/x-qt-windows-mime;value="FileGroupDescriptor"
    application/x-qt-windows-mime;value="FileContents"

    The `value` declaration of each format describes the way in which the data
    is encoded.

    In some cases (e.g. dropping multiple email attachments), multiple data
    values are available. They can be accessed by adding an `index` value:

    application/x-qt-windows-mime;value="FileContents";index=0
    application/x-qt-windows-mime;value="FileContents";index=1

    On Windows, the MIME format does not always map directly to the clipboard
    formats. Qt provides **QWinMime**  to map clipboard formats to open-standard
    MIME formats. Similarly, the **QMacPasteboardMime**  maps MIME to Mac
    flavors.

    **See also** **QClipboard** , **QDragEnterEvent** , **QDragMoveEvent** ,
    **QDropEvent** , **QDrag** , **QMacPasteboardMime** , and **Drag and Drop**
    .
    """

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qmimedata.html#QMimeData

        **QMimeData::QMimeData()**

        Constructs a new MIME data object with no data in it.
        """
        ...

    def retrieveData(self, mimetype: str, preferredType: "QVariant.Type") -> typing.Any:
        """
        https://doc.qt.io/qt-5/qmimedata.html#retrieveData

        **[virtual protected] QVariant QMimeData::retrieveData(const QString &
        mimeType , QVariant::Type type ) const**

        Returns a variant with the given **type** containing data for the MIME
        type specified by **mimeType**. If the object does not support the MIME
        type or variant type given, a null variant is returned instead.

        This function is called by the general **data** () getter and by the
        convenience getters (**text** (), **html** (), **urls** (),
        **imageData** (), and **colorData** ()). You can reimplement it if you
        want to store your data using a custom data structure (instead of a
        **QByteArray** , which is what **setData** () provides). You would then
        also need to reimplement **hasFormat** () and **formats** ().

        **See also** **data** ().
        """
        ...

    def removeFormat(self, mimetype: str) -> None:
        """
        https://doc.qt.io/qt-5/qmimedata.html#removeFormat

        **void QMimeData::removeFormat(const QString & mimeType )**

        Removes the data entry for **mimeType** in the object.

        This function was introduced in Qt 4.4.
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qmimedata.html#clear

        **void QMimeData::clear()**

        Removes all the MIME type and data entries in the object.
        """
        ...

    def formats(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qmimedata.html#formats

        **[virtual] QStringList QMimeData::formats() const**

        Returns a list of formats supported by the object. This is a list of
        MIME types for which the object can return suitable data. The formats in
        the list are in a priority order.

        For the most common types of data, you can call the higher-level
        functions **hasText** (), **hasHtml** (), **hasUrls** (), **hasImage**
        (), and **hasColor** () instead.

        **See also** **hasFormat** (), **setData** (), and **data** ().
        """
        ...

    def hasFormat(self, mimetype: str) -> bool:
        """
        https://doc.qt.io/qt-5/qmimedata.html#hasFormat

        **[virtual] bool QMimeData::hasFormat(const QString & mimeType ) const**

        Returns `true` if the object can return data for the MIME type specified
        by **mimeType** ; otherwise returns `false`.

        For the most common types of data, you can call the higher-level
        functions **hasText** (), **hasHtml** (), **hasUrls** (), **hasImage**
        (), and **hasColor** () instead.

        **See also** **formats** (), **setData** (), and **data** ().
        """
        ...

    def setData(
        self, mimetype: str, data: typing.Union[QByteArray, bytes, bytearray]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qmimedata.html#setData

        **void QMimeData::setData(const QString & mimeType , const QByteArray &
        data )**

        Sets the data associated with the MIME type given by **mimeType** to the
        specified **data**.

        For the most common types of data, you can call the higher-level
        functions **setText** (), **setHtml** (), **setUrls** (),
        **setImageData** (), and **setColorData** () instead.

        Note that if you want to use a custom data type in an item view drag and
        drop operation, you must register it as a Qt **meta type** , using the
        **Q_DECLARE_METATYPE** () macro, and implement stream operators for it.
        The stream operators must then be registered with the
        **qRegisterMetaTypeStreamOperators** () function.

        **See also** **data** (), **hasFormat** (), **QMetaType** , and
        **qRegisterMetaTypeStreamOperators** ().
        """
        ...

    def data(self, mimetype: str) -> QByteArray:
        """
        https://doc.qt.io/qt-5/qmimedata.html#data

        **QByteArray QMimeData::data(const QString & mimeType ) const**

        Returns the data stored in the object in the format described by the
        MIME type specified by **mimeType**.

        **See also** **setData** ().
        """
        ...

    def hasColor(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmimedata.html#hasColor

        **bool QMimeData::hasColor() const**

        Returns `true` if the object can return a color (MIME type
        `application/x-color`); otherwise returns `false`.

        **See also** **setColorData** (), **colorData** (), and **hasFormat**
        ().
        """
        ...

    def setColorData(self, color: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qmimedata.html#setColorData

        **void QMimeData::setColorData(const QVariant & color )**

        Sets the color data in the object to the given **color**.

        Colors correspond to the MIME type `application/x-color`.

        **See also** **colorData** (), **hasColor** (), and **setData** ().
        """
        ...

    def colorData(self) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qmimedata.html#colorData

        **QVariant QMimeData::colorData() const**

        Returns a color if the data stored in the object represents a color
        (MIME type `application/x-color`); otherwise returns a null variant.

        A **QVariant**  is used because **QMimeData**  belongs to the Qt Core
        module, whereas **QColor**  belongs to Qt GUI. To convert the
        **QVariant**  to a **QColor** , simply use **qvariant_cast** (). For
        example:

        if (event->mimeData()->hasColor()) {
                **QColor**  color =
        qvariant_cast<**QColor** >(event->mimeData()->colorData());
                ...
        }

        **See also** **hasColor** (), **setColorData** (), and **data** ().
        """
        ...

    def hasImage(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmimedata.html#hasImage

        **bool QMimeData::hasImage() const**

        Returns `true` if the object can return an image; otherwise returns
        false.

        **See also** **setImageData** (), **imageData** (), and **hasFormat**
        ().
        """
        ...

    def setImageData(self, image: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qmimedata.html#setImageData

        **void QMimeData::setImageData(const QVariant & image )**

        Sets the data in the object to the given **image**.

        A **QVariant**  is used because **QMimeData**  belongs to the Qt Core
        module, whereas **QImage**  belongs to Qt GUI. The conversion from
        **QImage**  to **QVariant**  is implicit. For example:

        mimeData->setImageData(**QImage** ("beautifulfjord.png"));

        **See also** **imageData** (), **hasImage** (), and **setData** ().
        """
        ...

    def imageData(self) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qmimedata.html#imageData

        **QVariant QMimeData::imageData() const**

        Returns a **QVariant**  storing a **QImage**  if the object can return
        an image; otherwise returns a null variant.

        A **QVariant**  is used because **QMimeData**  belongs to the Qt Core
        module, whereas **QImage**  belongs to Qt GUI. To convert the
        **QVariant**  to a **QImage** , simply use **qvariant_cast** (). For
        example:

        if (event->mimeData()->hasImage()) {
                **QImage**  image =
        qvariant_cast<**QImage** >(event->mimeData()->imageData());
                ...
        }

        **See also** **setImageData** () and **hasImage** ().
        """
        ...

    def hasHtml(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmimedata.html#hasHtml

        **bool QMimeData::hasHtml() const**

        Returns `true` if the object can return HTML (MIME type `text/html`);
        otherwise returns `false`.

        **See also** **setHtml** (), **html** (), and **hasFormat** ().
        """
        ...

    def setHtml(self, html: str) -> None:
        """
        https://doc.qt.io/qt-5/qmimedata.html#setHtml

        **void QMimeData::setHtml(const QString & html )**

        Sets **html** as the HTML (MIME type `text/html`) used to represent the
        data.

        **See also** **html** (), **hasHtml** (), **setText** (), and
        **setData** ().
        """
        ...

    def html(self) -> str:
        """
        https://doc.qt.io/qt-5/qmimedata.html#html

        **QString QMimeData::html() const**

        Returns a string if the data stored in the object is HTML (MIME type
        `text/html`); otherwise returns an empty string.

        **See also** **setHtml** (), **hasHtml** (), and **setData** ().
        """
        ...

    def hasText(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmimedata.html#hasText

        **bool QMimeData::hasText() const**

        Returns `true` if the object can return plain text (MIME type
        `text/plain`); otherwise returns `false`.

        **See also** **setText** (), **text** (), **hasHtml** (), and
        **hasFormat** ().
        """
        ...

    def setText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-5/qmimedata.html#setText

        **void QMimeData::setText(const QString & text )**

        Sets **text** as the plain text (MIME type `text/plain`) used to
        represent the data.

        **See also** **text** (), **hasText** (), **setHtml** (), and
        **setData** ().
        """
        ...

    def text(self) -> str:
        """
        https://doc.qt.io/qt-5/qmimedata.html#text

        **QString QMimeData::text() const**

        Returns a plain text (MIME type `text/plain`) representation of the
        data.

        **See also** **setText** (), **hasText** (), **html** (), and **data**
        ().
        """
        ...

    def hasUrls(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmimedata.html#hasUrls

        **bool QMimeData::hasUrls() const**

        Returns `true` if the object can return a list of urls; otherwise
        returns `false`.

        URLs correspond to the MIME type `text/uri-list`.

        **See also** **setUrls** (), **urls** (), and **hasFormat** ().
        """
        ...

    def setUrls(self, urls: typing.Iterable["QUrl"]) -> None:
        """
        https://doc.qt.io/qt-5/qmimedata.html#setUrls

        **void QMimeData::setUrls(const QList<QUrl> & urls )**

        Sets the URLs stored in the MIME data object to those specified by
        **urls**.

        URLs correspond to the MIME type `text/uri-list`.

        Since Qt 5.0, setUrls also exports the urls as plain text, if
        **setText**  was not called before, to make it possible to drop them
        into any lineedit and text editor.

        **See also** **urls** (), **hasUrls** (), and **setData** ().
        """
        ...

    def urls(self) -> typing.List["QUrl"]:
        """
        https://doc.qt.io/qt-5/qmimedata.html#urls

        **QList<QUrl> QMimeData::urls() const**

        Returns a list of URLs contained within the MIME data object.

        URLs correspond to the MIME type `text/uri-list`.

        **See also** **setUrls** (), **hasUrls** (), and **data** ().
        """
        ...
