"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QMetaObject(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qmetaobject.html

    **Detailed Description**

    The Qt **Meta-Object System**  in Qt is responsible for the signals and
    slots inter-object communication mechanism, runtime type information, and
    the Qt property system. A single QMetaObject instance is created for each
    **QObject**  subclass that is used in an application, and this instance
    stores all the meta-information for the **QObject**  subclass. This object
    is available as **QObject::metaObject** ().

    This class is not normally required for application programming, but it is
    useful if you write meta-applications, such as scripting engines or GUI
    builders.

    The functions you are most likely to find useful are these:

    * **className** () returns the name of a class.
      * **superClass** ()
    returns the superclass's meta-object.
      * **method** () and **methodCount**
    () provide information about a class's meta-methods (signals, slots and
    other **invokable**  member functions).
      * **enumerator** () and
    **enumeratorCount** () and provide information about a class's enumerators.
    * **propertyCount** () and **property** () provide information about a
    class's properties.
      * **constructor** () and **constructorCount** ()
    provide information about a class's meta-constructors.

    The index functions **indexOfConstructor** (), **indexOfMethod** (),
    **indexOfEnumerator** (), and **indexOfProperty** () map names of
    constructors, member functions, enumerators, or properties to indexes in the
    meta-object. For example, Qt uses **indexOfMethod** () internally when you
    connect a signal to a slot.

    Classes can also have a list of **name** \\-- **value** pairs of additional
    class information, stored in **QMetaClassInfo**  objects. The number of
    pairs is returned by **classInfoCount** (), single pairs are returned by
    **classInfo** (), and you can search for pairs with **indexOfClassInfo** ().

    **Note:** Operations that use the meta object system are generally thread-
    safe, as QMetaObjects are typically static read-only instances generated at
    compile time. However, if meta objects are dynamically modified by the
    application (for instance, when using **QQmlPropertyMap** ), then the
    application has to explicitly synchronize access to the respective meta
    object.

    **See also** **QMetaClassInfo** , **QMetaEnum** , **QMetaMethod** ,
    **QMetaProperty** , **QMetaType** , and **Meta-Object System** .
    """

    class Connection(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, other: "QMetaObject.Connection") -> None:
            ...

    @typing.overload
    def __init__(self) -> None:
        ...

    @typing.overload
    def __init__(self, a0: "QMetaObject") -> None:
        ...

    def inherits(self, metaObject: "QMetaObject") -> bool:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#inherits

        **bool QMetaObject::inherits(const QMetaObject * metaObject ) const**

        Returns `true` if the class described by this **QMetaObject**  inherits
        the type described by **metaObject** ; otherwise returns false.

        A type is considered to inherit itself.

        This function was introduced in Qt 5.7.
        """
        ...

    def constructor(self, index: int) -> QMetaMethod:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#constructor

        **QMetaMethod QMetaObject::constructor(int index ) const**

        Returns the meta-data for the constructor with the given **index**.

        This function was introduced in Qt 4.5.

        **See also** **constructorCount** () and **newInstance** ().
        """
        ...

    def indexOfConstructor(self, constructor: str) -> int:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#indexOfConstructor

        **int QMetaObject::indexOfConstructor(const char * constructor ) const**

        Finds **constructor** and returns its index; otherwise returns -1.

        Note that the **constructor** has to be in normalized form, as returned
        by **normalizedSignature** ().

        This function was introduced in Qt 4.5.

        **See also** **constructor** (), **constructorCount** (), and
        **normalizedSignature** ().
        """
        ...

    def constructorCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#constructorCount

        **int QMetaObject::constructorCount() const**

        Returns the number of constructors in this class.

        This function was introduced in Qt 4.5.

        **See also** **constructor** () and **indexOfConstructor** ().
        """
        ...

    @typing.overload
    @staticmethod
    def invokeMethod(
        obj: QObject,
        member: str,
        type: Qt.ConnectionType,
        ret: "QGenericReturnArgument",
        value0: "QGenericArgument" = ...,
        value1: "QGenericArgument" = ...,
        value2: "QGenericArgument" = ...,
        value3: "QGenericArgument" = ...,
        value4: "QGenericArgument" = ...,
        value5: "QGenericArgument" = ...,
        value6: "QGenericArgument" = ...,
        value7: "QGenericArgument" = ...,
        value8: "QGenericArgument" = ...,
        value9: "QGenericArgument" = ...,
    ) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#invokeMethod

        **[static] bool QMetaObject::invokeMethod(QObject * obj , const char *
        member , Qt::ConnectionType type , QGenericReturnArgument ret ,
        QGenericArgument val0 = QGenericArgument(nullptr), QGenericArgument val1
        = QGenericArgument(), QGenericArgument val2 = QGenericArgument(),
        QGenericArgument val3 = QGenericArgument(), QGenericArgument val4 =
        QGenericArgument(), QGenericArgument val5 = QGenericArgument(),
        QGenericArgument val6 = QGenericArgument(), QGenericArgument val7 =
        QGenericArgument(), QGenericArgument val8 = QGenericArgument(),
        QGenericArgument val9 = QGenericArgument())**

        Invokes the **member** (a signal or a slot name) on the object **obj**.
        Returns `true` if the member could be invoked. Returns `false` if there
        is no such member or the parameters did not match.

        The invocation can be either synchronous or asynchronous, depending on
        **type** :

        * If **type** is **Qt::DirectConnection** , the member will be invoked
        immediately.
          * If **type** is **Qt::QueuedConnection** , a **QEvent**
        will be sent and the member is invoked as soon as the application enters
        the main event loop.
          * If **type** is **Qt::BlockingQueuedConnection**
        , the method will be invoked in the same way as for
        **Qt::QueuedConnection** , except that the current thread will block
        until the event is delivered. Using this connection type to communicate
        between objects in the same thread will lead to deadlocks.
          * If
        **type** is **Qt::AutoConnection** , the member is invoked synchronously
        if **obj** lives in the same thread as the caller; otherwise it will
        invoke the member asynchronously.

        The return value of the **member** function call is placed in **ret**.
        If the invocation is asynchronous, the return value cannot be evaluated.
        You can pass up to ten arguments ( **val0** , **val1** , **val2** ,
        **val3** , **val4** , **val5** , **val6** , **val7** , **val8** , and
        **val9** ) to the **member** function.

        **QGenericArgument**  and **QGenericReturnArgument**  are internal
        helper classes. Because signals and slots can be dynamically invoked,
        you must enclose the arguments using the **Q_ARG** () and
        **Q_RETURN_ARG** () macros. **Q_ARG** () takes a type name and a const
        reference of that type; **Q_RETURN_ARG** () takes a type name and a non-
        const reference.

        You only need to pass the name of the signal or slot to this function,
        not the entire signature. For example, to asynchronously invoke the
        **quit()**  slot on a **QThread** , use the following code:

        **QMetaObject** ::invokeMethod(thread, "quit",
        Qt::QueuedConnection);

        With asynchronous method invocations, the parameters must be of types
        that are known to Qt's meta-object system, because Qt needs to copy the
        arguments to store them in an event behind the scenes. If you try to use
        a queued connection and get the error message

        **QMetaObject** ::invokeMethod: Unable to handle unregistered datatype
        'MyType'

        call **qRegisterMetaType** () to register the data type before you call
        invokeMethod().

        To synchronously invoke the `compute(QString, int, double)` slot on some
        arbitrary object `obj` retrieve its return value:

        **QString**  retVal;
            **QMetaObject** ::invokeMethod(obj, "compute",
        Qt::DirectConnection,
        Q_RETURN_ARG(**QString** , retVal),
        Q_ARG(**QString** , "sqrt"),
                                      Q_ARG(int,
        42),
                                      Q_ARG(double, 9.7));

        If the "compute" slot does not take exactly one **QString** , one int
        and one double in the specified order, the call will fail.

        **Note:** This function is **thread-safe** .

        **See also** **Q_ARG** (), **Q_RETURN_ARG** (), **qRegisterMetaType**
        (), and **QMetaMethod::invoke** ().
        """
        ...

    @typing.overload
    @staticmethod
    def invokeMethod(
        obj: QObject,
        member: str,
        ret: "QGenericReturnArgument",
        value0: "QGenericArgument" = ...,
        value1: "QGenericArgument" = ...,
        value2: "QGenericArgument" = ...,
        value3: "QGenericArgument" = ...,
        value4: "QGenericArgument" = ...,
        value5: "QGenericArgument" = ...,
        value6: "QGenericArgument" = ...,
        value7: "QGenericArgument" = ...,
        value8: "QGenericArgument" = ...,
        value9: "QGenericArgument" = ...,
    ) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#invokeMethod-1

        **[static] bool QMetaObject::invokeMethod(QObject * obj , const char *
        member , QGenericReturnArgument ret , QGenericArgument val0 =
        QGenericArgument(0), QGenericArgument val1 = QGenericArgument(),
        QGenericArgument val2 = QGenericArgument(), QGenericArgument val3 =
        QGenericArgument(), QGenericArgument val4 = QGenericArgument(),
        QGenericArgument val5 = QGenericArgument(), QGenericArgument val6 =
        QGenericArgument(), QGenericArgument val7 = QGenericArgument(),
        QGenericArgument val8 = QGenericArgument(), QGenericArgument val9 =
        QGenericArgument())**

        This function overloads invokeMethod().

        This overload always invokes the member using the connection type
        **Qt::AutoConnection** .

        **Note:** This function is **thread-safe** .
        """
        ...

    @typing.overload
    @staticmethod
    def invokeMethod(
        obj: QObject,
        member: str,
        type: Qt.ConnectionType,
        value0: "QGenericArgument" = ...,
        value1: "QGenericArgument" = ...,
        value2: "QGenericArgument" = ...,
        value3: "QGenericArgument" = ...,
        value4: "QGenericArgument" = ...,
        value5: "QGenericArgument" = ...,
        value6: "QGenericArgument" = ...,
        value7: "QGenericArgument" = ...,
        value8: "QGenericArgument" = ...,
        value9: "QGenericArgument" = ...,
    ) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#invokeMethod-2

        **[static] bool QMetaObject::invokeMethod(QObject * obj , const char *
        member , Qt::ConnectionType type , QGenericArgument val0 =
        QGenericArgument(0), QGenericArgument val1 = QGenericArgument(),
        QGenericArgument val2 = QGenericArgument(), QGenericArgument val3 =
        QGenericArgument(), QGenericArgument val4 = QGenericArgument(),
        QGenericArgument val5 = QGenericArgument(), QGenericArgument val6 =
        QGenericArgument(), QGenericArgument val7 = QGenericArgument(),
        QGenericArgument val8 = QGenericArgument(), QGenericArgument val9 =
        QGenericArgument())**

        This function overloads invokeMethod().

        This overload can be used if the return value of the member is of no
        interest.

        **Note:** This function is **thread-safe** .
        """
        ...

    @typing.overload
    @staticmethod
    def invokeMethod(
        obj: QObject,
        member: str,
        value0: "QGenericArgument" = ...,
        value1: "QGenericArgument" = ...,
        value2: "QGenericArgument" = ...,
        value3: "QGenericArgument" = ...,
        value4: "QGenericArgument" = ...,
        value5: "QGenericArgument" = ...,
        value6: "QGenericArgument" = ...,
        value7: "QGenericArgument" = ...,
        value8: "QGenericArgument" = ...,
        value9: "QGenericArgument" = ...,
    ) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#invokeMethod-3

        **[static] bool QMetaObject::invokeMethod(QObject * obj , const char *
        member , QGenericArgument val0 = QGenericArgument(0), QGenericArgument
        val1 = QGenericArgument(), QGenericArgument val2 = QGenericArgument(),
        QGenericArgument val3 = QGenericArgument(), QGenericArgument val4 =
        QGenericArgument(), QGenericArgument val5 = QGenericArgument(),
        QGenericArgument val6 = QGenericArgument(), QGenericArgument val7 =
        QGenericArgument(), QGenericArgument val8 = QGenericArgument(),
        QGenericArgument val9 = QGenericArgument())**

        This function overloads invokeMethod().

        This overload invokes the member using the connection type
        **Qt::AutoConnection**  and ignores return values.

        **Note:** This function is **thread-safe** .
        """
        ...

    @staticmethod
    def normalizedType(type: str) -> QByteArray:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#normalizedType

        **[static] QByteArray QMetaObject::normalizedType(const char * type )**

        Normalizes a **type**.

        See **QMetaObject::normalizedSignature** () for a description on how Qt
        normalizes.

        Example:

        **QByteArray**  normType = **QMetaObject** ::normalizedType(" int
        const  *");
            // normType is now "const int*"

        This function was introduced in Qt 4.2.

        **See also** **normalizedSignature** ().
        """
        ...

    @staticmethod
    def normalizedSignature(method: str) -> QByteArray:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#normalizedSignature

        **[static] QByteArray QMetaObject::normalizedSignature(const char *
        method )**

        Normalizes the signature of the given **method**.

        Qt uses normalized signatures to decide whether two given signals and
        slots are compatible. Normalization reduces whitespace to a minimum,
        moves 'const' to the front where appropriate, removes 'const' from value
        types and replaces const references with values.

        **See also** **checkConnectArgs** () and **normalizedType** ().
        """
        ...

    @staticmethod
    def connectSlotsByName(o: QObject) -> None:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#connectSlotsByName

        **[static] void QMetaObject::connectSlotsByName(QObject * object )**

        Searches recursively for all child objects of the given **object** , and
        connects matching signals from them to slots of **object** that follow
        the following form:

        void on_<object name>_<signal name>(<signal parameters>);

        Let's assume our object has a child object of type `QPushButton` with
        the **object name**  `button1`. The slot to catch the button's
        `clicked()` signal would be:

        void on_button1_clicked();

        If **object** itself has a properly set object name, its own signals are
        also connected to its respective slots.

        **See also** **QObject::setObjectName** ().
        """
        ...

    @typing.overload
    @staticmethod
    def checkConnectArgs(signal: str, method: str) -> bool:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#checkConnectArgs

        **[static] bool QMetaObject::checkConnectArgs(const char * signal ,
        const char * method )**

        Returns `true` if the **signal** and **method** arguments are
        compatible; otherwise returns `false`.

        Both **signal** and **method** are expected to be normalized.

        **See also** **normalizedSignature** ().
        """
        ...

    @typing.overload
    @staticmethod
    def checkConnectArgs(signal: QMetaMethod, method: QMetaMethod) -> bool:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#checkConnectArgs-1

        **[static] bool QMetaObject::checkConnectArgs(const QMetaMethod & signal
        , const QMetaMethod & method )**

        This is an overloaded function.

        Returns `true` if the **signal** and **method** arguments are
        compatible; otherwise returns `false`.

        This function was introduced in Qt 5.0.
        """
        ...

    def classInfo(self, index: int) -> QMetaClassInfo:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#classInfo

        **QMetaClassInfo QMetaObject::classInfo(int index ) const**

        Returns the meta-data for the item of class information with the given
        **index**.

        Example:

        class MyClass : public **QObject**
            {
                Q_OBJECT
        Q_CLASSINFO("author", "Sabrina Schweinsteiger")
        Q_CLASSINFO("url", "http://doc.moosesoft.co.uk/1.0/")

            public:
        ...
            };

        **See also** **classInfoCount** (), **classInfoOffset** (), and
        **indexOfClassInfo** ().
        """
        ...

    def property(self, index: int) -> QMetaProperty:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#property

        **QMetaProperty QMetaObject::property(int index ) const**

        Returns the meta-data for the property with the given **index**. If no
        such property exists, a null **QMetaProperty**  is returned.

        **See also** **propertyCount** (), **propertyOffset** (), and
        **indexOfProperty** ().
        """
        ...

    def enumerator(self, index: int) -> QMetaEnum:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#enumerator

        **QMetaEnum QMetaObject::enumerator(int index ) const**

        Returns the meta-data for the enumerator with the given **index**.

        **See also** **enumeratorCount** (), **enumeratorOffset** (), and
        **indexOfEnumerator** ().
        """
        ...

    def method(self, index: int) -> QMetaMethod:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#method

        **QMetaMethod QMetaObject::method(int index ) const**

        Returns the meta-data for the method with the given **index**.

        **See also** **methodCount** (), **methodOffset** (), and
        **indexOfMethod** ().
        """
        ...

    def indexOfClassInfo(self, name: str) -> int:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#indexOfClassInfo

        **int QMetaObject::indexOfClassInfo(const char * name ) const**

        Finds class information item **name** and returns its index; otherwise
        returns -1.

        **See also** **classInfo** (), **classInfoCount** (), and
        **classInfoOffset** ().
        """
        ...

    def indexOfProperty(self, name: str) -> int:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#indexOfProperty

        **int QMetaObject::indexOfProperty(const char * name ) const**

        Finds property **name** and returns its index; otherwise returns -1.

        **See also** **property** (), **propertyCount** (), and
        **propertyOffset** ().
        """
        ...

    def indexOfEnumerator(self, name: str) -> int:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#indexOfEnumerator

        **int QMetaObject::indexOfEnumerator(const char * name ) const**

        Finds enumerator **name** and returns its index; otherwise returns -1.

        **See also** **enumerator** (), **enumeratorCount** (), and
        **enumeratorOffset** ().
        """
        ...

    def indexOfSlot(self, slot: str) -> int:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#indexOfSlot

        **int QMetaObject::indexOfSlot(const char * slot ) const**

        Finds **slot** and returns its index; otherwise returns -1.

        This is the same as **indexOfMethod** (), except that it will return -1
        if the method exists but isn't a slot.

        **See also** **indexOfMethod** (), **method** (), **methodCount** (),
        and **methodOffset** ().
        """
        ...

    def indexOfSignal(self, signal: str) -> int:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#indexOfSignal

        **int QMetaObject::indexOfSignal(const char * signal ) const**

        Finds **signal** and returns its index; otherwise returns -1.

        This is the same as **indexOfMethod** (), except that it will return -1
        if the method exists but isn't a signal.

        Note that the **signal** has to be in normalized form, as returned by
        **normalizedSignature** ().

        **See also** **indexOfMethod** (), **normalizedSignature** (),
        **method** (), **methodCount** (), and **methodOffset** ().
        """
        ...

    def indexOfMethod(self, method: str) -> int:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#indexOfMethod

        **int QMetaObject::indexOfMethod(const char * method ) const**

        Finds **method** and returns its index; otherwise returns -1.

        Note that the **method** has to be in normalized form, as returned by
        **normalizedSignature** ().

        **See also** **method** (), **methodCount** (), **methodOffset** (), and
        **normalizedSignature** ().
        """
        ...

    def classInfoCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#classInfoCount

        **int QMetaObject::classInfoCount() const**

        Returns the number of items of class information in this class.

        **See also** **classInfo** (), **classInfoOffset** (), and
        **indexOfClassInfo** ().
        """
        ...

    def propertyCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#propertyCount

        **int QMetaObject::propertyCount() const**

        Returns the number of properties in this class, including the number of
        properties provided by each base class.

        Use code like the following to obtain a **QStringList**  containing the
        properties specific to a given class:

        const **QMetaObject** * metaObject = obj->metaObject();
        **QStringList**  properties;
            for(int i =
        metaObject->propertyOffset(); i < metaObject->propertyCount(); ++i)
        properties << **QString** ::fromLatin1(metaObject->property(i).name());

        **See also** **property** (), **propertyOffset** (), and
        **indexOfProperty** ().
        """
        ...

    def enumeratorCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#enumeratorCount

        **int QMetaObject::enumeratorCount() const**

        Returns the number of enumerators in this class.

        **See also** **enumerator** (), **enumeratorOffset** (), and
        **indexOfEnumerator** ().
        """
        ...

    def methodCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#methodCount

        **int QMetaObject::methodCount() const**

        Returns the number of methods in this class, including the number of
        methods provided by each base class. These include signals and slots as
        well as normal member functions.

        Use code like the following to obtain a **QStringList**  containing the
        methods specific to a given class:

        const **QMetaObject** * metaObject = obj->metaObject();
        **QStringList**  methods;
            for(int i = metaObject->methodOffset(); i
        < metaObject->methodCount(); ++i)
                methods << **QString**
        ::fromLatin1(metaObject->method(i).methodSignature());

        **See also** **method** (), **methodOffset** (), and **indexOfMethod**
        ().
        """
        ...

    def classInfoOffset(self) -> int:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#classInfoOffset

        **int QMetaObject::classInfoOffset() const**

        Returns the class information offset for this class; i.e. the index
        position of this class's first class information item.

        If the class has no superclasses with class information, the offset is
        0; otherwise the offset is the sum of all the class information items in
        the class's superclasses.

        **See also** **classInfo** (), **classInfoCount** (), and
        **indexOfClassInfo** ().
        """
        ...

    def propertyOffset(self) -> int:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#propertyOffset

        **int QMetaObject::propertyOffset() const**

        Returns the property offset for this class; i.e. the index position of
        this class's first property.

        The offset is the sum of all the properties in the class's superclasses
        (which is always positive since **QObject**  has the name() property).

        **See also** **property** (), **propertyCount** (), and
        **indexOfProperty** ().
        """
        ...

    def enumeratorOffset(self) -> int:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#enumeratorOffset

        **int QMetaObject::enumeratorOffset() const**

        Returns the enumerator offset for this class; i.e. the index position of
        this class's first enumerator.

        If the class has no superclasses with enumerators, the offset is 0;
        otherwise the offset is the sum of all the enumerators in the class's
        superclasses.

        **See also** **enumerator** (), **enumeratorCount** (), and
        **indexOfEnumerator** ().
        """
        ...

    def methodOffset(self) -> int:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#methodOffset

        **int QMetaObject::methodOffset() const**

        Returns the method offset for this class; i.e. the index position of
        this class's first member function.

        The offset is the sum of all the methods in the class's superclasses
        (which is always positive since **QObject**  has the deleteLater() slot
        and a destroyed() signal).

        **See also** **method** (), **methodCount** (), and **indexOfMethod**
        ().
        """
        ...

    def userProperty(self) -> QMetaProperty:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#userProperty

        **QMetaProperty QMetaObject::userProperty() const**

        Returns the property that has the `USER` flag set to true.

        This function was introduced in Qt 4.2.

        **See also** **QMetaProperty::isUser** ().
        """
        ...

    def superClass(self) -> "QMetaObject":
        """
        https://doc.qt.io/qt-5/qmetaobject.html#superClass

        **const QMetaObject *QMetaObject::superClass() const**

        Returns the meta-object of the superclass, or `nullptr` if there is no
        such object.

        **See also** **className** ().
        """
        ...

    def className(self) -> str:
        """
        https://doc.qt.io/qt-5/qmetaobject.html#className

        **const char *QMetaObject::className() const**

        Returns the class name.

        **See also** **superClass** ().
        """
        ...
