"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QMarginsF(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qmarginsf.html

    **Detailed Description**

    QMarginsF defines a set of four margins; left, top, right and bottom, that
    describe the size of the borders surrounding a rectangle.

    The **isNull** () function returns `true` only if all margins are set to
    zero.

    QMarginsF objects can be streamed as well as compared.
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qmarginsf.html#QMarginsF

        **QMarginsF::QMarginsF()**

        Constructs a margins object with all margins set to 0.

        **See also** **isNull** ().
        """
        ...

    @typing.overload
    def __init__(
        self, aleft: float, atop: float, aright: float, abottom: float
    ) -> None:
        """
        https://doc.qt.io/qt-5/qmarginsf.html#QMarginsF-1

        **QMarginsF::QMarginsF(qreal left , qreal top , qreal right , qreal
        bottom )**

        Constructs margins with the given **left** , **top** , **right** ,
        **bottom**

        **See also** **setLeft** (), **setRight** (), **setTop** (), and
        **setBottom** ().
        """
        ...

    @typing.overload
    def __init__(self, margins: QMargins) -> None:
        """
        https://doc.qt.io/qt-5/qmarginsf.html#QMarginsF-2

        **QMarginsF::QMarginsF(const QMargins & margins )**

        Constructs margins copied from the given **margins**
        """
        ...

    @typing.overload
    def __init__(self, a0: "QMarginsF") -> None:
        """
        https://doc.qt.io/qt-5/qmarginsf.html#QMarginsF

        **QMarginsF::QMarginsF()**

        Constructs a margins object with all margins set to 0.

        **See also** **isNull** ().
        """
        ...

    def __neg__(self) -> "QMarginsF":
        ...

    def __pos__(self) -> "QMarginsF":
        ...

    def toMargins(self) -> QMargins:
        """
        https://doc.qt.io/qt-5/qmarginsf.html#toMargins

        **QMargins QMarginsF::toMargins() const**

        Returns an integer based copy of this margins object.

        Note that the components in the returned margins will be rounded to the
        nearest integer.

        **See also** **QMarginsF** ().
        """
        ...

    def setBottom(self, abottom: float) -> None:
        """
        https://doc.qt.io/qt-5/qmarginsf.html#setBottom

        **void QMarginsF::setBottom(qreal bottom )**

        Sets the bottom margin to **bottom**.

        **See also** **bottom** ().
        """
        ...

    def setRight(self, aright: float) -> None:
        """
        https://doc.qt.io/qt-5/qmarginsf.html#setRight

        **void QMarginsF::setRight(qreal right )**

        Sets the right margin to **right**.

        **See also** **right** ().
        """
        ...

    def setTop(self, atop: float) -> None:
        """
        https://doc.qt.io/qt-5/qmarginsf.html#setTop

        **void QMarginsF::setTop(qreal Top )**

        Sets the Top margin to **Top**.

        **See also** **top** ().
        """
        ...

    def setLeft(self, aleft: float) -> None:
        """
        https://doc.qt.io/qt-5/qmarginsf.html#setLeft

        **void QMarginsF::setLeft(qreal left )**

        Sets the left margin to **left**.

        **See also** **left** ().
        """
        ...

    def bottom(self) -> float:
        """
        https://doc.qt.io/qt-5/qmarginsf.html#bottom

        **qreal QMarginsF::bottom() const**

        Returns the bottom margin.

        **See also** **setBottom** ().
        """
        ...

    def right(self) -> float:
        """
        https://doc.qt.io/qt-5/qmarginsf.html#right

        **qreal QMarginsF::right() const**

        Returns the right margin.

        **See also** **setRight** ().
        """
        ...

    def top(self) -> float:
        """
        https://doc.qt.io/qt-5/qmarginsf.html#top

        **qreal QMarginsF::top() const**

        Returns the top margin.

        **See also** **setTop** ().
        """
        ...

    def left(self) -> float:
        """
        https://doc.qt.io/qt-5/qmarginsf.html#left

        **qreal QMarginsF::left() const**

        Returns the left margin.

        **See also** **setLeft** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmarginsf.html#isNull

        **bool QMarginsF::isNull() const**

        Returns `true` if all margins are 0; otherwise returns false.
        """
        ...
