"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import sip


class QMargins(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qmargins.html

    **Detailed Description**

    QMargin defines a set of four margins; left, top, right and bottom, that
    describe the size of the borders surrounding a rectangle.

    The **isNull** () function returns `true` only if all margins are set to
    zero.

    QMargin objects can be streamed as well as compared.
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qmargins.html#QMargins

        **QMargins::QMargins()**

        Constructs a margins object with all margins set to 0.

        **See also** **isNull** ().
        """
        ...

    @typing.overload
    def __init__(self, aleft: int, atop: int, aright: int, abottom: int) -> None:
        """
        https://doc.qt.io/qt-5/qmargins.html#QMargins-1

        **QMargins::QMargins(int left , int top , int right , int bottom )**

        Constructs margins with the given **left** , **top** , **right** ,
        **bottom**

        **See also** **setLeft** (), **setRight** (), **setTop** (), and
        **setBottom** ().
        """
        ...

    @typing.overload
    def __init__(self, a0: "QMargins") -> None:
        """
        https://doc.qt.io/qt-5/qmargins.html#QMargins

        **QMargins::QMargins()**

        Constructs a margins object with all margins set to 0.

        **See also** **isNull** ().
        """
        ...

    def __neg__(self) -> "QMargins":
        ...

    def __pos__(self) -> "QMargins":
        ...

    def setBottom(self, abottom: int) -> None:
        """
        https://doc.qt.io/qt-5/qmargins.html#setBottom

        **void QMargins::setBottom(int bottom )**

        Sets the bottom margin to **bottom**.

        **See also** **bottom** ().
        """
        ...

    def setRight(self, aright: int) -> None:
        """
        https://doc.qt.io/qt-5/qmargins.html#setRight

        **void QMargins::setRight(int right )**

        Sets the right margin to **right**.

        **See also** **right** ().
        """
        ...

    def setTop(self, atop: int) -> None:
        """
        https://doc.qt.io/qt-5/qmargins.html#setTop

        **void QMargins::setTop(int Top )**

        Sets the Top margin to **Top**.

        **See also** **top** ().
        """
        ...

    def setLeft(self, aleft: int) -> None:
        """
        https://doc.qt.io/qt-5/qmargins.html#setLeft

        **void QMargins::setLeft(int left )**

        Sets the left margin to **left**.

        **See also** **left** ().
        """
        ...

    def bottom(self) -> int:
        """
        https://doc.qt.io/qt-5/qmargins.html#bottom

        **int QMargins::bottom() const**

        Returns the bottom margin.

        **See also** **setBottom** ().
        """
        ...

    def right(self) -> int:
        """
        https://doc.qt.io/qt-5/qmargins.html#right

        **int QMargins::right() const**

        Returns the right margin.

        **See also** **setRight** ().
        """
        ...

    def top(self) -> int:
        """
        https://doc.qt.io/qt-5/qmargins.html#top

        **int QMargins::top() const**

        Returns the top margin.

        **See also** **setTop** ().
        """
        ...

    def left(self) -> int:
        """
        https://doc.qt.io/qt-5/qmargins.html#left

        **int QMargins::left() const**

        Returns the left margin.

        **See also** **setLeft** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmargins.html#isNull

        **bool QMargins::isNull() const**

        Returns `true` if all margins are is 0; otherwise returns false.
        """
        ...
