"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QJsonValue(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qjsonvalue.html

    **Detailed Description**

    A value in JSON can be one of 6 basic types:

    JSON is a format to store structured data. It has 6 basic data types:

    * bool **QJsonValue::Bool**
      * double **QJsonValue::Double**
      * string
    **QJsonValue::String**
      * array **QJsonValue::Array**
      * object
    **QJsonValue::Object**
      * null **QJsonValue::Null**

    A value can represent any of the above data types. In addition, QJsonValue
    has one special flag to represent undefined values. This can be queried with
    **isUndefined** ().

    The type of the value can be queried with **type** () or accessors like
    **isBool** (), **isString** (), and so on. Likewise, the value can be
    converted to the type stored in it using the **toBool** (), **toString** ()
    and so on.

    Values are strictly typed internally and contrary to **QVariant**  will not
    attempt to do any implicit type conversions. This implies that converting to
    a type that is not stored in the value will return a default constructed
    return value.

    **QJsonValueRef**

    **QJsonValueRef**  is a helper class for **QJsonArray**  and **QJsonObject**
    . When you get an object of type **QJsonValueRef** , you can use it as if it
    were a reference to a QJsonValue. If you assign to it, the assignment will
    apply to the element in the **QJsonArray**  or **QJsonObject**  from which
    you got the reference.

    The following methods return **QJsonValueRef** :

    * **QJsonArray** ::operator[](int i)
      * **QJsonObject** ::operator[](const
    **QString**  & key) const

    **See also** **JSON Support in Qt**  and **JSON Save Game Example** .
    """

    class Type(int):
        Null: QJsonValue = ...
        Bool: QJsonValue = ...
        Double: QJsonValue = ...
        String: QJsonValue = ...
        Array: QJsonValue = ...
        Object: QJsonValue = ...
        Undefined: QJsonValue = ...

    @typing.overload
    def __init__(self, type: "QJsonValue.Type" = ...) -> None:
        """
        https://doc.qt.io/qt-5/qjsonvalue.html#QJsonValue

        **QJsonValue::QJsonValue(QJsonValue::Type type = Null)**

        Creates a QJsonValue of type **type**.

        The default is to create a Null value.
        """
        ...

    @typing.overload
    def __init__(
        self,
        other: typing.Union[
            "QJsonValue",
            "QJsonValue.Type",
            typing.Iterable["QJsonValue"],
            bool,
            int,
            float,
            None,
            str,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qjsonvalue.html#QJsonValue-1

        **QJsonValue::QJsonValue(bool b )**

        Creates a value of type Bool, with value **b**.
        """
        ...

    def __hash__(self) -> int:
        ...

    @typing.overload
    def __getitem__(self, key: str) -> "QJsonValue":
        ...

    @typing.overload
    def __getitem__(self, i: int) -> "QJsonValue":
        ...

    def swap(self, other: "QJsonValue") -> None:
        """
        https://doc.qt.io/qt-5/qjsonvalue.html#swap

        **void QJsonValue::swap(QJsonValue & other )**

        Swaps the value **other** with this. This operation is very fast and
        never fails.

        This function was introduced in Qt 5.10.
        """
        ...

    @typing.overload
    def toString(self) -> str:
        """
        https://doc.qt.io/qt-5/qjsonvalue.html#toString

        **QString QJsonValue::toString() const**

        Converts the value to a **QString**  and returns it.

        If **type** () is not String, a null **QString**  will be returned.

        **See also** **QString::isNull** ().
        """
        ...

    @typing.overload
    def toString(self, defaultValue: str) -> str:
        """
        https://doc.qt.io/qt-5/qjsonvalue.html#toString-1

        **QString QJsonValue::toString(const QString & defaultValue ) const**

        Converts the value to a **QString**  and returns it.

        If **type** () is not String, the **defaultValue** will be returned.
        """
        ...

    @typing.overload
    def toObject(
        self,
    ) -> typing.Dict[
        str,
        typing.Union[
            "QJsonValue",
            "QJsonValue.Type",
            typing.Iterable["QJsonValue"],
            bool,
            int,
            float,
            None,
            str,
        ],
    ]:
        """
        https://doc.qt.io/qt-5/qjsonvalue.html#toObject

        **QJsonObject QJsonValue::toObject(const QJsonObject & defaultValue )
        const**

        Converts the value to an object and returns it.

        If **type** () is not Object, the **defaultValue** will be returned.
        """
        ...

    @typing.overload
    def toObject(
        self,
        defaultValue: typing.Dict[
            str,
            typing.Union[
                "QJsonValue",
                "QJsonValue.Type",
                typing.Iterable["QJsonValue"],
                bool,
                int,
                float,
                None,
                str,
            ],
        ],
    ) -> typing.Dict[
        str,
        typing.Union[
            "QJsonValue",
            "QJsonValue.Type",
            typing.Iterable["QJsonValue"],
            bool,
            int,
            float,
            None,
            str,
        ],
    ]:
        """
        https://doc.qt.io/qt-5/qjsonvalue.html#toObject-1

        **QJsonObject QJsonValue::toObject() const**

        This is an overloaded function.

        Converts the value to an object and returns it.

        If **type** () is not Object, the **QJsonObject()**  will be returned.
        """
        ...

    @typing.overload
    def toArray(self) -> typing.List["QJsonValue"]:
        """
        https://doc.qt.io/qt-5/qjsonvalue.html#toArray

        **QJsonArray QJsonValue::toArray(const QJsonArray & defaultValue )
        const**

        Converts the value to an array and returns it.

        If **type** () is not Array, the **defaultValue** will be returned.
        """
        ...

    @typing.overload
    def toArray(
        self, defaultValue: typing.Iterable["QJsonValue"]
    ) -> typing.List["QJsonValue"]:
        """
        https://doc.qt.io/qt-5/qjsonvalue.html#toArray-1

        **QJsonArray QJsonValue::toArray() const**

        This is an overloaded function.

        Converts the value to an array and returns it.

        If **type** () is not Array, a **QJsonArray()**  will be returned.
        """
        ...

    def toDouble(self, defaultValue: float = ...) -> float:
        """
        https://doc.qt.io/qt-5/qjsonvalue.html#toDouble

        **double QJsonValue::toDouble(double defaultValue = 0) const**

        Converts the value to a double and returns it.

        If **type** () is not Double, the **defaultValue** will be returned.
        """
        ...

    def toInt(self, defaultValue: int = ...) -> int:
        """
        https://doc.qt.io/qt-5/qjsonvalue.html#toInt

        **int QJsonValue::toInt(int defaultValue = 0) const**

        Converts the value to an int and returns it.

        If **type** () is not Double or the value is not a whole number, the
        **defaultValue** will be returned.

        This function was introduced in Qt 5.2.
        """
        ...

    def toBool(self, defaultValue: bool = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qjsonvalue.html#toBool

        **bool QJsonValue::toBool(bool defaultValue = false) const**

        Converts the value to a bool and returns it.

        If **type** () is not bool, the **defaultValue** will be returned.
        """
        ...

    def isUndefined(self) -> bool:
        """
        https://doc.qt.io/qt-5/qjsonvalue.html#isUndefined

        **bool QJsonValue::isUndefined() const**

        Returns `true` if the value is undefined. This can happen in certain
        error cases as e.g. accessing a non existing key in a **QJsonObject** .
        """
        ...

    def isObject(self) -> bool:
        """
        https://doc.qt.io/qt-5/qjsonvalue.html#isObject

        **bool QJsonValue::isObject() const**

        Returns `true` if the value contains an object.

        **See also** **toObject** ().
        """
        ...

    def isArray(self) -> bool:
        """
        https://doc.qt.io/qt-5/qjsonvalue.html#isArray

        **bool QJsonValue::isArray() const**

        Returns `true` if the value contains an array.

        **See also** **toArray** ().
        """
        ...

    def isString(self) -> bool:
        """
        https://doc.qt.io/qt-5/qjsonvalue.html#isString

        **bool QJsonValue::isString() const**

        Returns `true` if the value contains a string.

        **See also** **toString** ().
        """
        ...

    def isDouble(self) -> bool:
        """
        https://doc.qt.io/qt-5/qjsonvalue.html#isDouble

        **bool QJsonValue::isDouble() const**

        Returns `true` if the value contains a double.

        **See also** **toDouble** ().
        """
        ...

    def isBool(self) -> bool:
        """
        https://doc.qt.io/qt-5/qjsonvalue.html#isBool

        **bool QJsonValue::isBool() const**

        Returns `true` if the value contains a boolean.

        **See also** **toBool** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qjsonvalue.html#isNull

        **bool QJsonValue::isNull() const**

        Returns `true` if the value is null.
        """
        ...

    def type(self) -> "QJsonValue.Type":
        """
        https://doc.qt.io/qt-5/qjsonvalue.html#type

        **QJsonValue::Type QJsonValue::type() const**

        Returns the type of the value.

        **See also** **QJsonValue::Type** .
        """
        ...

    def toVariant(self) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qjsonvalue.html#toVariant

        **QVariant QJsonValue::toVariant() const**

        Converts the value to a **QVariant()** .

        The **QJsonValue**  types will be converted as follows:

        ConstantDescription
        `Null`**QMetaType::Nullptr**
        `Bool`**QMetaType::Bool**
        `Double`**QMetaType::Double**  or
        **QMetaType::LongLong**
        `String`**QString**
        `Array`**QVariantList**
        `Object`**QVariantMap**
        `Undefined`**QVariant()**

        **See also** **fromVariant** ().
        """
        ...

    @staticmethod
    def fromVariant(variant: typing.Any) -> "QJsonValue":
        """
        https://doc.qt.io/qt-5/qjsonvalue.html#fromVariant

        **[static] QJsonValue QJsonValue::fromVariant(const QVariant & variant
        )**

        Converts **variant** to a **QJsonValue**  and returns it.

        The conversion will convert **QVariant**  types as follows:

        Source typeDestination type

          * **QMetaType::Nullptr**
        **QJsonValue::Null**

          * **QMetaType::Bool**

        **QJsonValue::Bool**
        * **QMetaType::Int**
          * **QMetaType::UInt**
          *
        **QMetaType::LongLong**
          * **QMetaType::ULongLong**
          *
        **QMetaType::Float**
          * **QMetaType::Double**

        **QJsonValue::Double**
        * **QMetaType::QString**

        **QJsonValue::String**

          *
        **QMetaType::QStringList**
          * **QMetaType::QVariantList**
        **QJsonValue::Array**

          * **QMetaType::QVariantMap**
          *
        **QMetaType::QVariantHash**

        **QJsonValue::Object**

          *
        **QMetaType::QUrl**

        **QJsonValue::String** . The conversion will use
        **QUrl::toString** () with flag **QUrl::FullyEncoded** , so as to ensure
        maximum compatibility in parsing the URL

          * **QMetaType::QUuid**
        **QJsonValue::String** . Since Qt 5.11, the resulting string will not
        include braces

          * **QMetaType::QCborValue**

        Whichever type
        **QCborValue::toJsonValue** () returns.

          *
        **QMetaType::QCborArray**

        **QJsonValue::Array** . See
        **QCborValue::toJsonValue** () for conversion restrictions.

          *
        **QMetaType::QCborMap**

        QJsonValue::Map. See
        **QCborValue::toJsonValue** () for conversion restrictions and the
        "stringification" of map keys.

        **Loss of information and other types**

        **QVariant**  can carry more information than is representable in JSON.
        If the **QVariant**  is not one of the types above, the conversion is
        not guaranteed and is subject to change in future versions of Qt, as the
        UUID one did. Code should strive not to use any other types than those
        listed above.

        If **QVariant::isNull** () returns true, a null **QJsonValue**  is
        returned or inserted into the list or object, regardless of the type
        carried by **QVariant** . Note the behavior change in Qt 6.0 affecting
        **QVariant::isNull** () also affects this function.

        A floating point value that is either an infinity or NaN will be
        converted to a null JSON value. Since Qt 6.0, **QJsonValue**  can store
        the full precision of any 64-bit signed integer without loss, but in
        previous versions values outside the range of ±2^53 may lose precision.
        Unsigned 64-bit values greater than or equal to 2^63 will either lose
        precision or alias to negative values, so **QMetaType::ULongLong**
        should be avoided.

        For other types not listed above, a conversion to string will be
        attempted, usually but not always by calling **QVariant::toString** ().
        If the conversion fails the value is replaced by a null JSON value. Note
        that **QVariant::toString** () is also lossy for the majority of types.
        For example, if the passed **QVariant**  is representing raw byte array
        data, it is recommended to pre-encode it to **Base64**  (or another
        lossless encoding), otherwise a lossy conversion using
        **QString::fromUtf8** () will be used.

        Please note that the conversions via **QVariant::toString** () are
        subject to change at any time. Both **QVariant**  and **QJsonValue**
        may be extended in the future to support more types, which will result
        in a change in how this function performs conversions.

        **See also** **toVariant** () and **QCborValue::fromVariant** ().
        """
        ...
