"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QItemSelection(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qitemselection.html

    **Detailed Description**

    A QItemSelection describes the items in a model that have been selected by
    the user. A QItemSelection is basically a list of selection ranges, see
    **QItemSelectionRange** . It provides functions for creating and
    manipulating selections, and selecting a range of items from a model.

    The QItemSelection class is one of the **Model/View Classes**  and is part
    of Qt's **model/view framework** .

    An item selection can be constructed and initialized to contain a range of
    items from an existing model. The following example constructs a selection
    that contains a range of items from the given `model`, beginning at the
    `topLeft`, and ending at the `bottomRight`.

    **QItemSelection**  *selection = new **QItemSelection** (topLeft,
    bottomRight);

    An empty item selection can be constructed, and later populated as required.
    So, if the model is going to be unavailable when we construct the item
    selection, we can rewrite the above code in the following way:

    **QItemSelection**  *selection = new **QItemSelection** ();
        ...
    selection->select(topLeft, bottomRight);

    QItemSelection saves memory, and avoids unnecessary work, by working with
    selection ranges rather than recording the model item index for each item in
    the selection. Generally, an instance of this class will contain a list of
    non-overlapping selection ranges.

    Use **merge** () to merge one item selection into another without making
    overlapping ranges. Use **split** () to split one selection range into
    smaller ranges based on a another selection range.

    **See also** **Model/View Programming**  and **QItemSelectionModel** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qitemselection.html#QItemSelection

        **QItemSelection::QItemSelection()**

        Constructs an empty selection.
        """
        ...

    @typing.overload
    def __init__(self, topLeft: QModelIndex, bottomRight: QModelIndex) -> None:
        """
        https://doc.qt.io/qt-5/qitemselection.html#QItemSelection-1

        **QItemSelection::QItemSelection(const QModelIndex & topLeft , const
        QModelIndex & bottomRight )**

        Constructs an item selection that extends from the top-left model item,
        specified by the **topLeft** index, to the bottom-right item, specified
        by **bottomRight**.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QItemSelection") -> None:
        """
        https://doc.qt.io/qt-5/qitemselection.html#QItemSelection

        **QItemSelection::QItemSelection()**

        Constructs an empty selection.
        """
        ...

    def lastIndexOf(self, value: QItemSelectionRange, from_: int = ...) -> int:
        ...

    def indexOf(self, value: QItemSelectionRange, from_: int = ...) -> int:
        ...

    def last(self) -> QItemSelectionRange:
        ...

    def first(self) -> QItemSelectionRange:
        ...

    def __len__(self) -> int:
        ...

    @typing.overload
    def count(self, range: QItemSelectionRange) -> int:
        ...

    @typing.overload
    def count(self) -> int:
        ...

    def swap(self, i: int, j: int) -> None:
        ...

    def move(self, from_: int, to: int) -> None:
        ...

    def takeLast(self) -> QItemSelectionRange:
        ...

    def takeFirst(self) -> QItemSelectionRange:
        ...

    def takeAt(self, i: int) -> QItemSelectionRange:
        ...

    def removeAll(self, range: QItemSelectionRange) -> int:
        ...

    def removeAt(self, i: int) -> None:
        ...

    def replace(self, i: int, range: QItemSelectionRange) -> None:
        ...

    def insert(self, i: int, range: QItemSelectionRange) -> None:
        ...

    def prepend(self, range: QItemSelectionRange) -> None:
        ...

    def append(self, range: QItemSelectionRange) -> None:
        ...

    def isEmpty(self) -> bool:
        ...

    def clear(self) -> None:
        ...

    @typing.overload
    def __getitem__(self, i: int) -> QItemSelectionRange:
        ...

    @typing.overload
    def __getitem__(self, slice: slice) -> "QItemSelection":
        ...

    @typing.overload
    def __delitem__(self, i: int) -> None:
        ...

    @typing.overload
    def __delitem__(self, slice: slice) -> None:
        ...

    @typing.overload
    def __setitem__(self, i: int, range: QItemSelectionRange) -> None:
        ...

    @typing.overload
    def __setitem__(self, slice: slice, list: "QItemSelection") -> None:
        ...

    @staticmethod
    def split(
        range: QItemSelectionRange, other: QItemSelectionRange, result: "QItemSelection"
    ) -> None:
        """
        https://doc.qt.io/qt-5/qitemselection.html#split

        **[static] void QItemSelection::split(const QItemSelectionRange & range
        , const QItemSelectionRange & other , QItemSelection * result )**

        Splits the selection **range** using the selection **other** range.
        Removes all items in **other** from **range** and puts the result in
        **result**. This can be compared with the semantics of the **subtract**
        operation of a set.

        **See also** **merge** ().
        """
        ...

    def merge(
        self,
        other: "QItemSelection",
        command: typing.Union[
            QItemSelectionModel.SelectionFlags, QItemSelectionModel.SelectionFlag
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qitemselection.html#merge

        **void QItemSelection::merge(const QItemSelection & other ,
        QItemSelectionModel::SelectionFlags command )**

        Merges the **other** selection with this **QItemSelection**  using the
        **command** given. This method guarantees that no ranges are
        overlapping.

        Note that only **QItemSelectionModel::Select** ,
        **QItemSelectionModel::Deselect** , and **QItemSelectionModel::Toggle**
        are supported.

        **See also** **split** ().
        """
        ...

    def indexes(self) -> typing.List[QModelIndex]:
        """
        https://doc.qt.io/qt-5/qitemselection.html#indexes

        **QModelIndexList QItemSelection::indexes() const**

        Returns a list of model indexes that correspond to the selected items.
        """
        ...

    def __contains__(self, index: QModelIndex) -> int:
        ...

    def contains(self, index: QModelIndex) -> bool:
        """
        https://doc.qt.io/qt-5/qitemselection.html#contains

        **bool QItemSelection::contains(const QModelIndex & index ) const**

        Returns `true` if the selection contains the given **index** ; otherwise
        returns `false`.
        """
        ...

    def select(self, topLeft: QModelIndex, bottomRight: QModelIndex) -> None:
        """
        https://doc.qt.io/qt-5/qitemselection.html#select

        **void QItemSelection::select(const QModelIndex & topLeft , const
        QModelIndex & bottomRight )**

        Adds the items in the range that extends from the top-left model item,
        specified by the **topLeft** index, to the bottom-right item, specified
        by **bottomRight** to the list.

        **Note:** **topLeft** and **bottomRight** must have the same parent.
        """
        ...
