"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtCore import *


class QIdentityProxyModel(QAbstractProxyModel):
    """
    https://doc.qt.io/qt-5/qidentityproxymodel.html

    **Detailed Description**

    QIdentityProxyModel can be used to forward the structure of a source model
    exactly, with no sorting, filtering or other transformation. This is similar
    in concept to an identity matrix where A.I = A.

    Because it does no sorting or filtering, this class is most suitable to
    proxy models which transform the **data** () of the source model. For
    example, a proxy model could be created to define the font used, or the
    background colour, or the tooltip etc. This removes the need to implement
    all data handling in the same class that creates the structure of the model,
    and can also be used to create re-usable components.

    This also provides a way to change the data in the case where a source model
    is supplied by a third party which cannot be modified.

    class DateFormatProxyModel : public **QIdentityProxyModel**
        {
          //
    ...

          void setDateFormatString(const **QString**  &formatString)
    {
            m_formatString = formatString;
          }

          **QVariant**
    data(const **QModelIndex**  &index, int role) const override
          {
    if (role != Qt::DisplayRole)
              return **QIdentityProxyModel**
    ::data(index, role);

            const **QDateTime**  dateTime =
    sourceModel()->data(SourceClass::DateRole).toDateTime();

            return
    dateTime.toString(m_formatString);
          }

        private:
    **QString**  m_formatString;
        };

    **See also** **QAbstractProxyModel** , **Model/View Programming** , and
    **QAbstractItemModel** .
    """

    def __init__(self, parent: typing.Optional[QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qidentityproxymodel.html#QIdentityProxyModel

        **QIdentityProxyModel::QIdentityProxyModel(QObject * parent = nullptr)**

        Constructs an identity model with the given **parent**.
        """
        ...

    def moveColumns(
        self,
        sourceParent: QModelIndex,
        sourceColumn: int,
        count: int,
        destinationParent: QModelIndex,
        destinationChild: int,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qidentityproxymodel.html#moveColumns

        **[override virtual] bool QIdentityProxyModel::moveColumns(const
        QModelIndex & sourceParent , int sourceColumn , int count , const
        QModelIndex & destinationParent , int destinationChild )**

        Reimplements: **QAbstractItemModel::moveColumns** (const QModelIndex
        &sourceParent, int sourceColumn, int count, const QModelIndex
        &destinationParent, int destinationChild).

        This function was introduced in Qt 5.15.
        """
        ...

    def moveRows(
        self,
        sourceParent: QModelIndex,
        sourceRow: int,
        count: int,
        destinationParent: QModelIndex,
        destinationChild: int,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qidentityproxymodel.html#moveRows

        **[override virtual] bool QIdentityProxyModel::moveRows(const
        QModelIndex & sourceParent , int sourceRow , int count , const
        QModelIndex & destinationParent , int destinationChild )**

        Reimplements: **QAbstractItemModel::moveRows** (const QModelIndex
        &sourceParent, int sourceRow, int count, const QModelIndex
        &destinationParent, int destinationChild).

        This function was introduced in Qt 5.15.
        """
        ...

    def sibling(self, row: int, column: int, idx: QModelIndex) -> QModelIndex:
        """
        https://doc.qt.io/qt-5/qidentityproxymodel.html#sibling

        **[override virtual] QModelIndex QIdentityProxyModel::sibling(int row ,
        int column , const QModelIndex & idx ) const**

        Reimplements: **QAbstractProxyModel::sibling** (int row, int column,
        const QModelIndex &idx) const.
        """
        ...

    def headerData(
        self, section: int, orientation: Qt.Orientation, role: int = ...
    ) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qidentityproxymodel.html#headerData

        **[override virtual] QVariant QIdentityProxyModel::headerData(int
        section , Qt::Orientation orientation , int role = Qt::DisplayRole)
        const**

        Reimplements: **QAbstractProxyModel::headerData** (int section,
        Qt::Orientation orientation, int role) const.
        """
        ...

    def removeRows(self, row: int, count: int, parent: QModelIndex = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qidentityproxymodel.html#removeRows

        **[override virtual] bool QIdentityProxyModel::removeRows(int row , int
        count , const QModelIndex & parent = QModelIndex())**

        Reimplements: **QAbstractItemModel::removeRows** (int row, int count,
        const QModelIndex &parent).
        """
        ...

    def removeColumns(self, column: int, count: int, parent: QModelIndex = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qidentityproxymodel.html#removeColumns

        **[override virtual] bool QIdentityProxyModel::removeColumns(int column
        , int count , const QModelIndex & parent = QModelIndex())**

        Reimplements: **QAbstractItemModel::removeColumns** (int column, int
        count, const QModelIndex &parent).
        """
        ...

    def insertRows(self, row: int, count: int, parent: QModelIndex = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qidentityproxymodel.html#insertRows

        **[override virtual] bool QIdentityProxyModel::insertRows(int row , int
        count , const QModelIndex & parent = QModelIndex())**

        Reimplements: **QAbstractItemModel::insertRows** (int row, int count,
        const QModelIndex &parent).
        """
        ...

    def insertColumns(self, column: int, count: int, parent: QModelIndex = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qidentityproxymodel.html#insertColumns

        **[override virtual] bool QIdentityProxyModel::insertColumns(int column
        , int count , const QModelIndex & parent = QModelIndex())**

        Reimplements: **QAbstractItemModel::insertColumns** (int column, int
        count, const QModelIndex &parent).
        """
        ...

    def setSourceModel(self, sourceModel: QAbstractItemModel) -> None:
        """
        https://doc.qt.io/qt-5/qidentityproxymodel.html#setSourceModel

        **[override virtual] void
        QIdentityProxyModel::setSourceModel(QAbstractItemModel * newSourceModel
        )**

        Reimplements: **QAbstractProxyModel::setSourceModel**
        (QAbstractItemModel *sourceModel).
        """
        ...

    def match(
        self,
        start: QModelIndex,
        role: int,
        value: typing.Any,
        hits: int = ...,
        flags: typing.Union[Qt.MatchFlags, Qt.MatchFlag] = ...,
    ) -> typing.List[QModelIndex]:
        """
        https://doc.qt.io/qt-5/qidentityproxymodel.html#match

        **[override virtual] QModelIndexList QIdentityProxyModel::match(const
        QModelIndex & start , int role , const QVariant & value , int hits = 1,
        Qt::MatchFlags flags =
        Qt::MatchFlags(Qt::MatchStartsWith|Qt::MatchWrap)) const**

        Reimplements: **QAbstractItemModel::match** (const QModelIndex &start,
        int role, const QVariant &value, int hits, Qt::MatchFlags flags) const.
        """
        ...

    def mapSelectionToSource(self, selection: "QItemSelection") -> "QItemSelection":
        """
        https://doc.qt.io/qt-5/qidentityproxymodel.html#mapSelectionToSource

        **[override virtual] QItemSelection
        QIdentityProxyModel::mapSelectionToSource(const QItemSelection &
        selection ) const**

        Reimplements: **QAbstractProxyModel::mapSelectionToSource** (const
        QItemSelection &proxySelection) const.
        """
        ...

    def mapSelectionFromSource(self, selection: "QItemSelection") -> "QItemSelection":
        """
        https://doc.qt.io/qt-5/qidentityproxymodel.html#mapSelectionFromSource

        **[override virtual] QItemSelection
        QIdentityProxyModel::mapSelectionFromSource(const QItemSelection &
        selection ) const**

        Reimplements: **QAbstractProxyModel::mapSelectionFromSource** (const
        QItemSelection &sourceSelection) const.
        """
        ...

    def dropMimeData(
        self,
        data: "QMimeData",
        action: Qt.DropAction,
        row: int,
        column: int,
        parent: QModelIndex,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qidentityproxymodel.html#dropMimeData

        **[override virtual] bool QIdentityProxyModel::dropMimeData(const
        QMimeData * data , Qt::DropAction action , int row , int column , const
        QModelIndex & parent )**

        Reimplements: **QAbstractProxyModel::dropMimeData** (const QMimeData
        *data, Qt::DropAction action, int row, int column, const QModelIndex
        &parent).
        """
        ...

    def rowCount(self, parent: QModelIndex = ...) -> int:
        """
        https://doc.qt.io/qt-5/qidentityproxymodel.html#rowCount

        **[override virtual] int QIdentityProxyModel::rowCount(const QModelIndex
        & parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::rowCount** (const QModelIndex
        &parent) const.
        """
        ...

    def parent(self, child: QModelIndex) -> QModelIndex:
        """
        https://doc.qt.io/qt-5/qidentityproxymodel.html#parent

        **[override virtual] QModelIndex QIdentityProxyModel::parent(const
        QModelIndex & child ) const**

        Reimplements: **QAbstractItemModel::parent** (const QModelIndex &index)
        const.
        """
        ...

    def mapToSource(self, proxyIndex: QModelIndex) -> QModelIndex:
        """
        https://doc.qt.io/qt-5/qidentityproxymodel.html#mapToSource

        **[override virtual] QModelIndex QIdentityProxyModel::mapToSource(const
        QModelIndex & proxyIndex ) const**

        Reimplements: **QAbstractProxyModel::mapToSource** (const QModelIndex
        &proxyIndex) const.
        """
        ...

    def mapFromSource(self, sourceIndex: QModelIndex) -> QModelIndex:
        """
        https://doc.qt.io/qt-5/qidentityproxymodel.html#mapFromSource

        **[override virtual] QModelIndex
        QIdentityProxyModel::mapFromSource(const QModelIndex & sourceIndex )
        const**

        Reimplements: **QAbstractProxyModel::mapFromSource** (const QModelIndex
        &sourceIndex) const.
        """
        ...

    def index(self, row: int, column: int, parent: QModelIndex = ...) -> QModelIndex:
        """
        https://doc.qt.io/qt-5/qidentityproxymodel.html#index

        **[override virtual] QModelIndex QIdentityProxyModel::index(int row ,
        int column , const QModelIndex & parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::index** (int row, int column, const
        QModelIndex &parent) const.
        """
        ...

    def columnCount(self, parent: QModelIndex = ...) -> int:
        """
        https://doc.qt.io/qt-5/qidentityproxymodel.html#columnCount

        **[override virtual] int QIdentityProxyModel::columnCount(const
        QModelIndex & parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::columnCount** (const QModelIndex
        &parent) const.
        """
        ...
