"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtCore import *


class QFinalState(QAbstractState):
    """
    https://doc.qt.io/qt-5/qfinalstate.html

    **Detailed Description**

    A final state is used to communicate that (part of) a **QStateMachine**  has
    finished its work. When a final top-level state is entered, the state
    machine's **finished** () signal is emitted. In general, when a final
    substate (a child of a **QState** ) is entered, the parent state's
    **finished** () signal is emitted. QFinalState is part of **The State
    Machine Framework** .

    To use a final state, you create a QFinalState object and add a transition
    to it from another state. Example:

    **QPushButton**  button;

        **QStateMachine**  machine;
        **QState**
    *s1 = new **QState** ();
        **QFinalState**  *s2 = new **QFinalState** ();
    s1->addTransition(&button, SIGNAL(clicked()), s2);
        machine.addState(s1);
    machine.addState(s2);

        **QObject** ::connect(&machine,
    SIGNAL(finished()), **QApplication** ::instance(), SLOT(quit()));
    machine.setInitialState(s1);
        machine.start();

    **See also** **QState::finished** ().
    """

    def __init__(self, parent: typing.Optional["QState"] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qfinalstate.html#QFinalState

        **QFinalState::QFinalState(QState * parent = nullptr)**

        Constructs a new QFinalState object with the given **parent** state.
        """
        ...

    def event(self, e: QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qfinalstate.html#event

        **[override virtual protected] bool QFinalState::event(QEvent * e )**

        Reimplements: **QAbstractState::event** (QEvent *e).
        """
        ...

    def onExit(self, event: QEvent) -> None:
        """
        https://doc.qt.io/qt-5/qfinalstate.html#onExit

        **[override virtual protected] void QFinalState::onExit(QEvent * event
        )**

        Reimplements: **QAbstractState::onExit** (QEvent *event).
        """
        ...

    def onEntry(self, event: QEvent) -> None:
        """
        https://doc.qt.io/qt-5/qfinalstate.html#onEntry

        **[override virtual protected] void QFinalState::onEntry(QEvent * event
        )**

        Reimplements: **QAbstractState::onEntry** (QEvent *event).
        """
        ...
