"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5.QtCore import *


class QFileSystemWatcher(QObject):
    """
    https://doc.qt.io/qt-5/qfilesystemwatcher.html

    **Detailed Description**

    QFileSystemWatcher monitors the file system for changes to files and
    directories by watching a list of specified paths.

    Call **addPath** () to watch a particular file or directory. Multiple paths
    can be added using the **addPaths** () function. Existing paths can be
    removed by using the **removePath** () and **removePaths** () functions.

    QFileSystemWatcher examines each path added to it. Files that have been
    added to the QFileSystemWatcher can be accessed using the **files** ()
    function, and directories using the **directories** () function.

    The **fileChanged** () signal is emitted when a file has been modified,
    renamed or removed from disk. Similarly, the **directoryChanged** () signal
    is emitted when a directory or its contents is modified or removed. Note
    that QFileSystemWatcher stops monitoring files once they have been renamed
    or removed from disk, and directories once they have been removed from disk.

    * **Notes** :
        * On systems running a Linux kernel without inotify
    support, file systems that contain watched paths cannot be unmounted.
        *
    The act of monitoring files and directories for modifications consumes
    system resources. This implies there is a limit to the number of files and
    directories your process can monitor simultaneously. On all BSD variants,
    for example, an open file descriptor is required for each monitored file.
    Some system limits the number of open file descriptors to 256 by default.
    This means that **addPath** () and **addPaths** () will fail if your process
    tries to add more than 256 files or directories to the file system monitor.
    Also note that your process may have other file descriptors open in addition
    to the ones for files being monitored, and these other open descriptors also
    count in the total. macOS uses a different backend and does not suffer from
    this issue.

    **See also** **QFile**  and **QDir** .
    """

    @typing.overload
    def __init__(self, parent: typing.Optional[QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qfilesystemwatcher.html#QFileSystemWatcher

        **QFileSystemWatcher::QFileSystemWatcher(QObject * parent = nullptr)**

        Constructs a new file system watcher object with the given **parent**.
        """
        ...

    @typing.overload
    def __init__(
        self, paths: typing.Iterable[str], parent: typing.Optional[QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qfilesystemwatcher.html#QFileSystemWatcher-1

        **QFileSystemWatcher::QFileSystemWatcher(const QStringList & paths ,
        QObject * parent = nullptr)**

        Constructs a new file system watcher object with the given **parent**
        which monitors the specified **paths** list.
        """
        ...

    def removePaths(self, files: typing.Iterable[str]) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qfilesystemwatcher.html#removePaths

        **QStringList QFileSystemWatcher::removePaths(const QStringList & paths
        )**

        Removes the specified **paths** from the file system watcher.

        The return value is a list of paths which were not able to be unwatched
        successfully.

        Reasons for watch removal failing are generally system-dependent, but
        may be due to the path having already been deleted, for example.

        **See also** **removePath** () and **addPaths** ().
        """
        ...

    def removePath(self, file: str) -> bool:
        """
        https://doc.qt.io/qt-5/qfilesystemwatcher.html#removePath

        **bool QFileSystemWatcher::removePath(const QString & path )**

        Removes the specified **path** from the file system watcher.

        If the watch is successfully removed, true is returned.

        Reasons for watch removal failing are generally system-dependent, but
        may be due to the path having already been deleted, for example.

        **See also** **removePaths** () and **addPath** ().
        """
        ...

    def files(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qfilesystemwatcher.html#files

        **QStringList QFileSystemWatcher::files() const**

        Returns a list of paths to files that are being watched.

        **See also** **directories** ().
        """
        ...

    def directories(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qfilesystemwatcher.html#directories

        **QStringList QFileSystemWatcher::directories() const**

        Returns a list of paths to directories that are being watched.

        **See also** **files** ().
        """
        ...

    def addPaths(self, files: typing.Iterable[str]) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qfilesystemwatcher.html#addPaths

        **QStringList QFileSystemWatcher::addPaths(const QStringList & paths )**

        Adds each path in **paths** to the file system watcher. Paths are not
        added if they not exist, or if they are already being monitored by the
        file system watcher.

        If a path specifies a directory, the **directoryChanged** () signal will
        be emitted when the path is modified or removed from disk; otherwise the
        **fileChanged** () signal is emitted when the path is modified, renamed,
        or removed.

        The return value is a list of paths that could not be watched.

        Reasons for a watch failure are generally system-dependent, but may
        include the resource not existing, access failures, or the total watch
        count limit, if the platform has one.

        **Note:** There may be a system dependent limit to the number of files
        and directories that can be monitored simultaneously. If this limit has
        been reached, the excess **paths** will not be monitored, and they will
        be added to the returned **QStringList** .

        **See also** **addPath** () and **removePaths** ().
        """
        ...

    def addPath(self, file: str) -> bool:
        """
        https://doc.qt.io/qt-5/qfilesystemwatcher.html#addPath

        **bool QFileSystemWatcher::addPath(const QString & path )**

        Adds **path** to the file system watcher if **path** exists. The path is
        not added if it does not exist, or if it is already being monitored by
        the file system watcher.

        If **path** specifies a directory, the **directoryChanged** () signal
        will be emitted when **path** is modified or removed from disk;
        otherwise the **fileChanged** () signal is emitted when **path** is
        modified, renamed or removed.

        If the watch was successful, true is returned.

        Reasons for a watch failure are generally system-dependent, but may
        include the resource not existing, access failures, or the total watch
        count limit, if the platform has one.

        **Note:** There may be a system dependent limit to the number of files
        and directories that can be monitored simultaneously. If this limit is
        been reached, **path** will not be monitored, and false is returned.

        **See also** **addPaths** () and **removePath** ().
        """
        ...

    @property
    def directoryChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qfilesystemwatcher.html#directoryChanged

        **[signal] void QFileSystemWatcher::directoryChanged(const QString &
        path )**

        This signal is emitted when the directory at a specified **path** is
        modified (e.g., when a file is added or deleted) or removed from disk.
        Note that if there are several changes during a short period of time,
        some of the changes might not emit this signal. However, the last change
        in the sequence of changes will always generate this signal.

        **Note:** This is a private signal. It can be used in signal connections
        but cannot be emitted by the user.

        **See also** **fileChanged** ().
        """
        ...

    @property
    def fileChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qfilesystemwatcher.html#fileChanged

        **[signal] void QFileSystemWatcher::fileChanged(const QString & path )**

        This signal is emitted when the file at the specified **path** is
        modified, renamed or removed from disk.

        **Note:** As a safety measure, many applications save an open file by
        writing a new file and then deleting the old one. In your slot function,
        you can check `watcher.files().contains(path)`. If it returns `false`,
        check whether the file still exists and then call `addPath()` to
        continue watching it.

        **Note:** This is a private signal. It can be used in signal connections
        but cannot be emitted by the user.

        **See also** **directoryChanged** ().
        """
        ...
