"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QFileInfo(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qfileinfo.html

    **Detailed Description**

    QFileInfo provides information about a file's name and position (path) in
    the file system, its access rights and whether it is a directory or symbolic
    link, etc. The file's size and last modified/read times are also available.
    QFileInfo can also be used to obtain information about a Qt **resource** .

    A QFileInfo can point to a file with either a relative or an absolute file
    path. Absolute file paths begin with the directory separator "/" (or with a
    drive specification on Windows). Relative file names begin with a directory
    name or a file name and specify a path relative to the current working
    directory. An example of an absolute path is the string "/tmp/quartz". A
    relative path might look like "src/fatlib". You can use the function
    **isRelative** () to check whether a QFileInfo is using a relative or an
    absolute file path. You can call the function **makeAbsolute** () to convert
    a relative QFileInfo's path to an absolute path.

    The file that the QFileInfo works on is set in the constructor or later with
    **setFile** (). Use **exists** () to see if the file exists and **size** ()
    to get its size.

    The file's type is obtained with **isFile** (), **isDir** () and
    **isSymLink** (). The **symLinkTarget** () function provides the name of the
    file the symlink points to.

    On Unix (including macOS and iOS), the property getter functions in this
    class return the properties such as times and size of the target file, not
    the symlink, because Unix handles symlinks transparently. Opening a symlink
    using **QFile**  effectively opens the link's target. For example:

    #ifdef Q_OS_UNIX

        QFileInfo info1("/home/bob/bin/untabify");
    info1.isSymLink();          // returns true
        info1.absoluteFilePath();
    // returns "/home/bob/bin/untabify"
        info1.size();               //
    returns 56201
        info1.symLinkTarget();      // returns
    "/opt/pretty++/bin/untabify"

        QFileInfo
    info2(info1.symLinkTarget());
        info2.isSymLink();          // returns
    false
        info2.absoluteFilePath();   // returns
    "/opt/pretty++/bin/untabify"
        info2.size();               // returns
    56201

        #endif

    On Windows, shortcuts (`.lnk` files) are currently treated as symlinks. As
    on Unix systems, the property getters return the size of the targeted file,
    not the `.lnk` file itself. This behavior is deprecated and will likely be
    removed in a future version of Qt, after which `.lnk` files will be treated
    as regular files.

    #ifdef Q_OS_WIN

        QFileInfo info1("C:\\\\Documents and
    Settings\\\\Bob\\\\untabify.lnk");
        info1.isSymLink();          // returns
    true
        info1.absoluteFilePath();   // returns "C:/Documents and
    Settings/Bob/untabify.lnk"
        info1.size();               // returns 743
    info1.symLinkTarget();      // returns "C:/Pretty++/untabify"
    QFileInfo info2(info1.symLinkTarget());
        info2.isSymLink();          //
    returns false
        info2.absoluteFilePath();   // returns
    "C:/Pretty++/untabify"
        info2.size();               // returns 63942
    #endif

    Elements of the file's name can be extracted with **path** () and
    **fileName** (). The **fileName** ()'s parts can be extracted with
    **baseName** (), **suffix** () or **completeSuffix** (). QFileInfo objects
    to directories created by Qt classes will not have a trailing file
    separator. If you wish to use trailing separators in your own file info
    objects, just append one to the file name given to the constructors or
    **setFile** ().

    The file's dates are returned by **birthTime** (), **lastModified** (),
    **lastRead** () and **fileTime** (). Information about the file's access
    permissions is obtained with **isReadable** (), **isWritable** () and
    **isExecutable** (). The file's ownership is available from **owner** (),
    **ownerId** (), **group** () and **groupId** (). You can examine a file's
    permissions and ownership in a single statement using the **permission** ()
    function.

    **Note:** On NTFS file systems, ownership and permissions checking is
    disabled by default for performance reasons. To enable it, include the
    following line:

    extern Q_CORE_EXPORT int qt_ntfs_permission_lookup;

    Permission checking is then turned on and off by incrementing and
    decrementing `qt_ntfs_permission_lookup` by 1.

    qt_ntfs_permission_lookup++; // turn checking on
    qt_ntfs_permission_lookup--; // turn it off again

    **Performance Issues**

    Some of QFileInfo's functions query the file system, but for performance
    reasons, some functions only operate on the file name itself. For example:
    To return the absolute path of a relative file name, **absolutePath** () has
    to query the file system. The **path** () function, however, can work on the
    file name directly, and so it is faster.

    **Note:** To speed up performance, QFileInfo caches information about the
    file.

    Because files can be changed by other users or programs, or even by other
    parts of the same program, there is a function that refreshes the file
    information: **refresh** (). If you want to switch off a QFileInfo's caching
    and force it to access the file system every time you request information
    from it call **setCaching** (false).

    **See also** **QDir**  and **QFile** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#QFileInfo-1

        **QFileInfo::QFileInfo()**

        Constructs an empty QFileInfo object.

        Note that an empty QFileInfo object contain no file reference.

        **See also** **setFile** ().
        """
        ...

    @typing.overload
    def __init__(self, file: str) -> None:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#QFileInfo-2

        **QFileInfo::QFileInfo(const QString & file )**

        Constructs a new QFileInfo that gives information about the given file.
        The **file** can also include an absolute or relative path.

        **See also** **setFile** (), **isRelative** (), **QDir::setCurrent** (),
        and **QDir::isRelativePath** ().
        """
        ...

    @typing.overload
    def __init__(self, file: QFile) -> None:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#QFileInfo-3

        **QFileInfo::QFileInfo(const QFile & file )**

        Constructs a new QFileInfo that gives information about file **file**.

        If the **file** has a relative path, the QFileInfo will also have a
        relative path.

        **See also** **isRelative** ().
        """
        ...

    @typing.overload
    def __init__(self, dir: QDir, file: str) -> None:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#QFileInfo-4

        **QFileInfo::QFileInfo(const QDir & dir , const QString & file )**

        Constructs a new QFileInfo that gives information about the given
        **file** in the directory **dir**.

        If **dir** has a relative path, the QFileInfo will also have a relative
        path.

        If **file** is an absolute path, then the directory specified by **dir**
        will be disregarded.

        **See also** **isRelative** ().
        """
        ...

    @typing.overload
    def __init__(self, fileinfo: "QFileInfo") -> None:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#QFileInfo-5

        **QFileInfo::QFileInfo(const QFileInfo & fileinfo )**

        Constructs a new QFileInfo that is a copy of the given **fileinfo**.
        """
        ...

    def isJunction(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#isJunction

        **bool QFileInfo::isJunction() const**

        Returns `true` if the object points to a junction; otherwise returns
        `false`.

        Junctions only exist on Windows' NTFS file system, and are typically
        created by the `mklink` command. They can be thought of as symlinks for
        directories, and can only be created for absolute paths on the local
        volume.

        This function was introduced in Qt 5.15.
        """
        ...

    def isShortcut(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#isShortcut

        **bool QFileInfo::isShortcut() const**

        Returns `true` if this object points to a shortcut; otherwise returns
        `false`.

        Shortcuts only exist on Windows and are typically `.lnk` files. For
        instance, true will be returned for shortcuts (`*.lnk` files) on
        Windows, but false will be returned on Unix (including macOS and iOS).

        The shortcut (.lnk) files are treated as regular files. Opening those
        will open the `.lnk` file itself. In order to open the file a shortcut
        references to, it must uses **symLinkTarget** () on a shortcut.

        **Note:** Even if a shortcut (broken shortcut) points to a non existing
        file, isShortcut() returns true.

        **See also** **isFile** (), **isDir** (), **isSymbolicLink** (), and
        **symLinkTarget** ().
        """
        ...

    def isSymbolicLink(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#isSymbolicLink

        **bool QFileInfo::isSymbolicLink() const**

        Returns `true` if this object points to a symbolic link; otherwise
        returns `false`.

        Symbolic links exist on Unix (including macOS and iOS) and Windows
        (NTFS-symlink) and are typically created by the `ln -s` or `mklink`
        commands, respectively.

        Unix handles symlinks transparently. Opening a symbolic link effectively
        opens the **link's target** .

        In contrast to **isSymLink** (), false will be returned for shortcuts
        (`*.lnk` files) on Windows. Use **QFileInfo::isShortcut** () instead.

        **Note:** If the symlink points to a non existing file, **exists** ()
        returns false.

        **See also** **isFile** (), **isDir** (), **isShortcut** (), and
        **symLinkTarget** ().
        """
        ...

    def fileTime(self, time: QFileDevice.FileTime) -> QDateTime:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#fileTime

        **QDateTime QFileInfo::fileTime(QFile::FileTime time ) const**

        Returns the file time specified by **time**. If the time cannot be
        determined, an invalid date time is returned.

        If the file is a symlink, the time of the target file is returned (not
        the symlink).

        This function was introduced in Qt 5.10.

        **See also** **QFile::FileTime**  and **QDateTime::isValid** ().
        """
        ...

    def metadataChangeTime(self) -> QDateTime:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#metadataChangeTime

        **QDateTime QFileInfo::metadataChangeTime() const**

        Returns the date and time when the file metadata was changed. A metadata
        change occurs when the file is created, but it also occurs whenever the
        user writes or sets inode information (for example, changing the file
        permissions).

        If the file is a symlink, the time of the target file is returned (not
        the symlink).

        This function was introduced in Qt 5.10.

        **See also** **lastModified** () and **lastRead** ().
        """
        ...

    def birthTime(self) -> QDateTime:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#birthTime

        **QDateTime QFileInfo::birthTime() const**

        Returns the date and time when the file was created / born.

        If the file birth time is not available, this function returns an
        invalid **QDateTime** .

        If the file is a symlink, the time of the target file is returned (not
        the symlink).

        This function was introduced in Qt 5.10.

        **See also** **lastModified** (), **lastRead** (), and
        **metadataChangeTime** ().
        """
        ...

    def swap(self, other: "QFileInfo") -> None:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#swap

        **void QFileInfo::swap(QFileInfo & other )**

        Swaps this file info with **other**. This function is very fast and
        never fails.

        This function was introduced in Qt 5.0.
        """
        ...

    def isNativePath(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#isNativePath

        **bool QFileInfo::isNativePath() const**

        Returns `true` if the file path can be used directly with native APIs.
        Returns `false` if the file is otherwise supported by a virtual file
        system inside Qt, such as **the Qt Resource System** .

        **Note:** Native paths may still require conversion of path separators
        and character encoding, depending on platform and input requirements of
        the native API.

        This function was introduced in Qt 5.0.

        **See also** **QDir::toNativeSeparators** (), **QFile::encodeName** (),
        **filePath** (), **absoluteFilePath** (), and **canonicalFilePath** ().
        """
        ...

    def isBundle(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#isBundle

        **bool QFileInfo::isBundle() const**

        Returns `true` if this object points to a bundle or to a symbolic link
        to a bundle on macOS and iOS; otherwise returns `false`.

        If the file is a symlink, this function returns true if the target is a
        bundle (not the symlink).

        This function was introduced in Qt 4.3.

        **See also** **isDir** (), **isSymLink** (), and **isFile** ().
        """
        ...

    def bundleName(self) -> str:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#bundleName

        **QString QFileInfo::bundleName() const**

        Returns the name of the bundle.

        On macOS and iOS this returns the proper localized name for a bundle if
        the path **isBundle** (). On all other platforms an empty **QString**
        is returned.

        Example:

        QFileInfo fi("/Applications/Safari.app");
            **QString**  bundle =
        fi.bundleName();                // name = "Safari"

        This function was introduced in Qt 4.3.

        **See also** **isBundle** (), **filePath** (), **baseName** (), and
        **suffix** ().
        """
        ...

    def symLinkTarget(self) -> str:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#symLinkTarget

        **QString QFileInfo::symLinkTarget() const**

        Returns the absolute path to the file or directory a symbolic link
        points to, or an empty string if the object isn't a symbolic link.

        This name may not represent an existing file; it is only a string.
        **QFileInfo::exists** () returns `true` if the symlink points to an
        existing file.

        This function was introduced in Qt 4.2.

        **See also** **exists** (), **isSymLink** (), **isDir** (), and
        **isFile** ().
        """
        ...

    def setCaching(self, on: bool) -> None:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#setCaching

        **void QFileInfo::setCaching(bool enable )**

        If **enable** is true, enables caching of file information. If
        **enable** is false caching is disabled.

        When caching is enabled, **QFileInfo**  reads the file information from
        the file system the first time it's needed, but generally not later.

        Caching is enabled by default.

        **See also** **refresh** () and **caching** ().
        """
        ...

    def caching(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#caching

        **bool QFileInfo::caching() const**

        Returns `true` if caching is enabled; otherwise returns `false`.

        **See also** **setCaching** () and **refresh** ().
        """
        ...

    def lastRead(self) -> QDateTime:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#lastRead

        **QDateTime QFileInfo::lastRead() const**

        Returns the date and local time when the file was last read (accessed).

        On platforms where this information is not available, returns the same
        as **lastModified** ().

        If the file is a symlink, the time of the target file is returned (not
        the symlink).

        **See also** **birthTime** (), **lastModified** (),
        **metadataChangeTime** (), and **fileTime** ().
        """
        ...

    def lastModified(self) -> QDateTime:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#lastModified

        **QDateTime QFileInfo::lastModified() const**

        Returns the date and local time when the file was last modified.

        If the file is a symlink, the time of the target file is returned (not
        the symlink).

        **See also** **birthTime** (), **lastRead** (), **metadataChangeTime**
        (), and **fileTime** ().
        """
        ...

    def created(self) -> QDateTime:
        ...

    def size(self) -> int:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#size

        **qint64 QFileInfo::size() const**

        Returns the file size in bytes. If the file does not exist or cannot be
        fetched, 0 is returned.

        If the file is a symlink, the size of the target file is returned (not
        the symlink).

        **See also** **exists** ().
        """
        ...

    def permissions(self) -> QFileDevice.Permissions:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#permissions

        **QFile::Permissions QFileInfo::permissions() const**

        Returns the complete OR-ed together combination of
        **QFile::Permissions**  for the file.

        **Note:** The result might be inaccurate on Windows if the **NTFS
        permissions**  check has not been enabled.

        If the file is a symlink, this function returns the permissions of the
        target (not the symlink).
        """
        ...

    def permission(
        self, permissions: typing.Union[QFileDevice.Permissions, QFileDevice.Permission]
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#permission

        **bool QFileInfo::permission(QFile::Permissions permissions ) const**

        Tests for file permissions. The **permissions** argument can be several
        flags of type **QFile::Permissions**  OR-ed together to check for
        permission combinations.

        On systems where files do not have permissions this function always
        returns `true`.

        **Note:** The result might be inaccurate on Windows if the **NTFS
        permissions**  check has not been enabled.

        Example:

        QFileInfo fi("/tmp/archive.tar.gz");
            if (fi.permission(**QFile**
        ::WriteUser | **QFile** ::ReadGroup))
                **qWarning** ("I can
        change the file; my group can read the file");
            if
        (fi.permission(**QFile** ::WriteGroup | **QFile** ::WriteOther))
        **qWarning** ("The group or others can change the file");

        If the file is a symlink, this function checks the permissions of the
        target (not the symlink).

        **See also** **isReadable** (), **isWritable** (), and **isExecutable**
        ().
        """
        ...

    def groupId(self) -> int:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#groupId

        **uint QFileInfo::groupId() const**

        Returns the id of the group the file belongs to.

        On Windows and on systems where files do not have groups this function
        always returns (uint) -2.

        If the file is a symlink, this function returns the id of the group
        owning the target (not the symlink).

        **See also** **group** (), **owner** (), and **ownerId** ().
        """
        ...

    def group(self) -> str:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#group

        **QString QFileInfo::group() const**

        Returns the group of the file. On Windows, on systems where files do not
        have groups, or if an error occurs, an empty string is returned.

        This function can be time consuming under Unix (in the order of
        milliseconds).

        If the file is a symlink, this function returns the owning group of the
        target (not the symlink).

        **See also** **groupId** (), **owner** (), and **ownerId** ().
        """
        ...

    def ownerId(self) -> int:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#ownerId

        **uint QFileInfo::ownerId() const**

        Returns the id of the owner of the file.

        On Windows and on systems where files do not have owners this function
        returns ((uint) -2).

        If the file is a symlink, this function returns the id of the owner of
        the target (not the symlink).

        **See also** **owner** (), **group** (), and **groupId** ().
        """
        ...

    def owner(self) -> str:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#owner

        **QString QFileInfo::owner() const**

        Returns the owner of the file. On systems where files do not have
        owners, or if an error occurs, an empty string is returned.

        This function can be time consuming under Unix (in the order of
        milliseconds). On Windows, it will return an empty string unless the
        **NTFS permissions**  check has been enabled.

        If the file is a symlink, this function returns the owner of the target
        (not the symlink).

        **See also** **ownerId** (), **group** (), and **groupId** ().
        """
        ...

    def isRoot(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#isRoot

        **bool QFileInfo::isRoot() const**

        Returns `true` if the object points to a directory or to a symbolic link
        to a directory, and that directory is the root directory; otherwise
        returns `false`.
        """
        ...

    def isSymLink(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#isSymLink

        **bool QFileInfo::isSymLink() const**

        Returns `true` if this object points to a symbolic link or shortcut;
        otherwise returns `false`.

        Symbolic links exist on Unix (including macOS and iOS) and Windows and
        are typically created by the `ln -s` or `mklink` commands, respectively.
        Opening a symbolic link effectively opens the **link's target** .

        In addition, true will be returned for shortcuts (`*.lnk` files) on
        Windows. This behavior is deprecated and will likely change in a future
        version of Qt. Opening those will open the `.lnk` file itself.

        Example:

        QFileInfo info(fileName);
            if (info.isSymLink())
                fileName =
        info.symLinkTarget();

        **Note:** If the symlink points to a non existing file, **exists** ()
        returns false.

        **See also** **isFile** (), **isDir** (), and **symLinkTarget** ().
        """
        ...

    def isDir(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#isDir

        **bool QFileInfo::isDir() const**

        Returns `true` if this object points to a directory or to a symbolic
        link to a directory; otherwise returns `false`.

        If the file is a symlink, this function returns true if the target is a
        directory (not the symlink).

        **See also** **isFile** (), **isSymLink** (), and **isBundle** ().
        """
        ...

    def isFile(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#isFile

        **bool QFileInfo::isFile() const**

        Returns `true` if this object points to a file or to a symbolic link to
        a file. Returns `false` if the object points to something which isn't a
        file, such as a directory.

        If the file is a symlink, this function returns true if the target is a
        regular file (not the symlink).

        **See also** **isDir** (), **isSymLink** (), and **isBundle** ().
        """
        ...

    def makeAbsolute(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#makeAbsolute

        **bool QFileInfo::makeAbsolute()**

        Converts the file's path to an absolute path if it is not already in
        that form. Returns `true` to indicate that the path was converted;
        otherwise returns `false` to indicate that the path was already
        absolute.

        **See also** **filePath** () and **isRelative** ().
        """
        ...

    def isAbsolute(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#isAbsolute

        **bool QFileInfo::isAbsolute() const**

        Returns `true` if the file path name is absolute, otherwise returns
        false if the path is relative.

        **See also** **isRelative** ().
        """
        ...

    def isRelative(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#isRelative

        **bool QFileInfo::isRelative() const**

        Returns `true` if the file path name is relative, otherwise returns
        false if the path is absolute (e.g. under Unix a path is absolute if it
        begins with a "/").

        **See also** **isAbsolute** ().
        """
        ...

    def isHidden(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#isHidden

        **bool QFileInfo::isHidden() const**

        Returns `true` if this is a `hidden' file; otherwise returns `false`.

        **Note:** This function returns `true` for the special entries "." and
        ".." on Unix, even though **QDir::entryList**  threats them as shown.
        And note that, since this function inspects the file name, on Unix it
        will inspect the name of the symlink, if this file is a symlink, not the
        target's name.

        On Windows, this function returns `true` if the target file is hidden
        (not the symlink).
        """
        ...

    def isExecutable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#isExecutable

        **bool QFileInfo::isExecutable() const**

        Returns `true` if the file is executable; otherwise returns `false`.

        If the file is a symlink, this function returns true if the target is
        executable (not the symlink).

        **See also** **isReadable** (), **isWritable** (), and **permission**
        ().
        """
        ...

    def isWritable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#isWritable

        **bool QFileInfo::isWritable() const**

        Returns `true` if the user can write to the file; otherwise returns
        `false`.

        If the file is a symlink, this function returns true if the target is
        writeable (not the symlink).

        **Note:** If the **NTFS permissions**  check has not been enabled, the
        result on Windows will merely reflect whether the file is marked as Read
        Only.

        **See also** **isReadable** (), **isExecutable** (), and **permission**
        ().
        """
        ...

    def isReadable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#isReadable

        **bool QFileInfo::isReadable() const**

        Returns `true` if the user can read the file; otherwise returns `false`.

        If the file is a symlink, this function returns true if the target is
        readable (not the symlink).

        **Note:** If the **NTFS permissions**  check has not been enabled, the
        result on Windows will merely reflect whether the file exists.

        **See also** **isWritable** (), **isExecutable** (), and **permission**
        ().
        """
        ...

    def absoluteDir(self) -> QDir:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#absoluteDir

        **QDir QFileInfo::absoluteDir() const**

        Returns the file's absolute path as a **QDir**  object.

        **See also** **dir** (), **filePath** (), **fileName** (), and
        **isRelative** ().
        """
        ...

    def dir(self) -> QDir:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#dir

        **QDir QFileInfo::dir() const**

        Returns the path of the object's parent directory as a **QDir**  object.

        **Note:** The **QDir**  returned always corresponds to the object's
        parent directory, even if the **QFileInfo**  represents a directory.

        For each of the following, dir() returns the **QDir**
        `"~/examples/191697"`.

        QFileInfo fileInfo1("~/examples/191697/.");
                QFileInfo
        fileInfo2("~/examples/191697/..");
                QFileInfo
        fileInfo3("~/examples/191697/main.cpp");

        For each of the following, dir() returns the **QDir**  `"."`.

        QFileInfo fileInfo4(".");
                QFileInfo fileInfo5("..");
        QFileInfo fileInfo6("main.cpp");

        **See also** **absolutePath** (), **filePath** (), **fileName** (),
        **isRelative** (), and **absoluteDir** ().
        """
        ...

    def canonicalPath(self) -> str:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#canonicalPath

        **QString QFileInfo::canonicalPath() const**

        Returns the file's path canonical path (excluding the file name), i.e.
        an absolute path without symbolic links or redundant "." or ".."
        elements.

        If the file does not exist, canonicalPath() returns an empty string.

        **See also** **path** () and **absolutePath** ().
        """
        ...

    def absolutePath(self) -> str:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#absolutePath

        **QString QFileInfo::absolutePath() const**

        Returns a file's path absolute path. This doesn't include the file name.

        On Unix the absolute path will always begin with the root, '/',
        directory. On Windows this will always begin 'D:/' where D is a drive
        letter, except for network shares that are not mapped to a drive letter,
        in which case the path will begin '//sharename/'.

        In contrast to **canonicalPath** () symbolic links or redundant "." or
        ".." elements are not necessarily removed.

        **Warning:** If **filePath** () is empty the behavior of this function
        is undefined.

        **See also** **absoluteFilePath** (), **path** (), **canonicalPath** (),
        **fileName** (), and **isRelative** ().
        """
        ...

    def path(self) -> str:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#path

        **QString QFileInfo::path() const**

        Returns the file's path. This doesn't include the file name.

        Note that, if this **QFileInfo**  object is given a path ending in a
        slash, the name of the file is considered empty and this function will
        return the entire path.

        **See also** **filePath** (), **absolutePath** (), **canonicalPath** (),
        **dir** (), **fileName** (), and **isRelative** ().
        """
        ...

    def completeSuffix(self) -> str:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#completeSuffix

        **QString QFileInfo::completeSuffix() const**

        Returns the complete suffix (extension) of the file.

        The complete suffix consists of all characters in the file after (but
        not including) the first '.'.

        Example:

        QFileInfo fi("/tmp/archive.tar.gz");
            **QString**  ext =
        fi.completeSuffix();  // ext = "tar.gz"

        **See also** **fileName** (), **suffix** (), **baseName** (), and
        **completeBaseName** ().
        """
        ...

    def suffix(self) -> str:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#suffix

        **QString QFileInfo::suffix() const**

        Returns the suffix (extension) of the file.

        The suffix consists of all characters in the file after (but not
        including) the last '.'.

        Example:

        QFileInfo fi("/tmp/archive.tar.gz");
            **QString**  ext = fi.suffix();
        // ext = "gz"

        The suffix of a file is computed equally on all platforms, independent
        of file naming conventions (e.g., ".bashrc" on Unix has an empty base
        name, and the suffix is "bashrc").

        **See also** **fileName** (), **completeSuffix** (), **baseName** (),
        and **completeBaseName** ().
        """
        ...

    def completeBaseName(self) -> str:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#completeBaseName

        **QString QFileInfo::completeBaseName() const**

        Returns the complete base name of the file without the path.

        The complete base name consists of all characters in the file up to (but
        not including) the **last** '.' character.

        Example:

        QFileInfo fi("/tmp/archive.tar.gz");
            **QString**  base =
        fi.completeBaseName();  // base = "archive.tar"

        **See also** **fileName** (), **suffix** (), **completeSuffix** (), and
        **baseName** ().
        """
        ...

    def baseName(self) -> str:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#baseName

        **QString QFileInfo::baseName() const**

        Returns the base name of the file without the path.

        The base name consists of all characters in the file up to (but not
        including) the **first** '.' character.

        Example:

        QFileInfo fi("/tmp/archive.tar.gz");
            **QString**  base =
        fi.baseName();  // base = "archive"

        The base name of a file is computed equally on all platforms,
        independent of file naming conventions (e.g., ".bashrc" on Unix has an
        empty base name, and the suffix is "bashrc").

        **See also** **fileName** (), **suffix** (), **completeSuffix** (), and
        **completeBaseName** ().
        """
        ...

    def fileName(self) -> str:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#fileName

        **QString QFileInfo::fileName() const**

        Returns the name of the file, excluding the path.

        Example:

        QFileInfo fi("/tmp/archive.tar.gz");
            **QString**  name =
        fi.fileName();                // name = "archive.tar.gz"

        Note that, if this **QFileInfo**  object is given a path ending in a
        slash, the name of the file is considered empty.

        **See also** **isRelative** (), **filePath** (), **baseName** (), and
        **suffix** ().
        """
        ...

    def canonicalFilePath(self) -> str:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#canonicalFilePath

        **QString QFileInfo::canonicalFilePath() const**

        Returns the canonical path including the file name, i.e. an absolute
        path without symbolic links or redundant "." or ".." elements.

        If the file does not exist, canonicalFilePath() returns an empty string.

        **See also** **filePath** (), **absoluteFilePath** (), and **dir** ().
        """
        ...

    def absoluteFilePath(self) -> str:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#absoluteFilePath

        **QString QFileInfo::absoluteFilePath() const**

        Returns an absolute path including the file name.

        The absolute path name consists of the full path and the file name. On
        Unix this will always begin with the root, '/', directory. On Windows
        this will always begin 'D:/' where D is a drive letter, except for
        network shares that are not mapped to a drive letter, in which case the
        path will begin '//sharename/'. **QFileInfo**  will uppercase drive
        letters. Note that **QDir**  does not do this. The code snippet below
        shows this.

        QFileInfo fi("c:/temp/foo"); => fi.absoluteFilePath() => "C:/temp/foo"

        This function returns the same as **filePath** (), unless **isRelative**
        () is true. In contrast to **canonicalFilePath** (), symbolic links or
        redundant "." or ".." elements are not necessarily removed.

        **Warning:** If **filePath** () is empty the behavior of this function
        is undefined.

        **See also** **filePath** (), **canonicalFilePath** (), and
        **isRelative** ().
        """
        ...

    def __fspath__(self) -> typing.Any:
        ...

    def filePath(self) -> str:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#filePath

        **QString QFileInfo::filePath() const**

        Returns the file name, including the path (which may be absolute or
        relative).

        **See also** **absoluteFilePath** (), **canonicalFilePath** (), and
        **isRelative** ().
        """
        ...

    def refresh(self) -> None:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#refresh

        **void QFileInfo::refresh()**

        Refreshes the information about the file, i.e. reads in information from
        the file system the next time a cached property is fetched.
        """
        ...

    @typing.overload
    def exists(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#exists

        **bool QFileInfo::exists() const**

        Returns `true` if the file exists; otherwise returns `false`.

        **Note:** If the file is a symlink that points to a non-existing file,
        false is returned.
        """
        ...

    @typing.overload
    @staticmethod
    def exists(file: str) -> bool:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#exists-1

        **[static] bool QFileInfo::exists(const QString & file )**

        Returns `true` if the **file** exists; otherwise returns `false`.

        **Note:** If **file** is a symlink that points to a non-existing file,
        false is returned.

        **Note:** Using this function is faster than using
        `QFileInfo(file).exists()` for file system access.

        This function was introduced in Qt 5.2.
        """
        ...

    @typing.overload
    def setFile(self, file: str) -> None:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#setFile

        **void QFileInfo::setFile(const QString & file )**

        Sets the file that the **QFileInfo**  provides information about to
        **file**.

        The **file** can also include an absolute or relative file path.
        Absolute paths begin with the directory separator (e.g. "/" under Unix)
        or a drive specification (under Windows). Relative file names begin with
        a directory name or a file name and specify a path relative to the
        current directory.

        Example:

        **QString**  absolute = "/local/bin";
            **QString**  relative =
        "local/bin";
            QFileInfo absFile(absolute);
            QFileInfo
        relFile(relative);

            **QDir** ::setCurrent(**QDir**
        ::rootPath());
            // absFile and relFile now point to the same file
        **QDir** ::setCurrent("/tmp");
            // absFile now points to
        "/local/bin",
            // while relFile points to "/tmp/local/bin"

        **See also** **isFile** (), **isRelative** (), **QDir::setCurrent** (),
        and **QDir::isRelativePath** ().
        """
        ...

    @typing.overload
    def setFile(self, file: QFile) -> None:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#setFile-1

        **void QFileInfo::setFile(const QFile & file )**

        This is an overloaded function.

        Sets the file that the **QFileInfo**  provides information about to
        **file**.

        If **file** includes a relative path, the **QFileInfo**  will also have
        a relative path.

        **See also** **isRelative** ().
        """
        ...

    @typing.overload
    def setFile(self, dir: QDir, file: str) -> None:
        """
        https://doc.qt.io/qt-5/qfileinfo.html#setFile-2

        **void QFileInfo::setFile(const QDir & dir , const QString & file )**

        This is an overloaded function.

        Sets the file that the **QFileInfo**  provides information about to
        **file** in directory **dir**.

        If **file** includes a relative path, the **QFileInfo**  will also have
        a relative path.

        **See also** **isRelative** ().
        """
        ...
