"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
import datetime
from PyQt5.QtCore import *
from PyQt5 import sip


class QFileDevice(QIODevice):
    """
    https://doc.qt.io/qt-5/qfiledevice.html

    **Detailed Description**

    QFileDevice is the base class for I/O devices that can read and write text
    and binary files and **resources** . **QFile**  offers the main
    functionality, QFileDevice serves as a base class for sharing functionality
    with other file devices such as **QTemporaryFile** , by providing all the
    operations that can be done on files that have been opened by **QFile**  or
    **QTemporaryFile** .

    **See also** **QFile**  and **QTemporaryFile** .
    """

    class FileTime(int):
        FileAccessTime: QFileDevice = ...
        FileBirthTime: QFileDevice = ...
        FileMetadataChangeTime: QFileDevice = ...
        FileModificationTime: QFileDevice = ...

    class MemoryMapFlags(int):
        NoOptions: QFileDevice = ...
        MapPrivateOption: QFileDevice = ...

    class FileHandleFlag(int):
        AutoCloseHandle: QFileDevice = ...
        DontCloseHandle: QFileDevice = ...

    class Permission(int):
        ReadOwner: QFileDevice = ...
        WriteOwner: QFileDevice = ...
        ExeOwner: QFileDevice = ...
        ReadUser: QFileDevice = ...
        WriteUser: QFileDevice = ...
        ExeUser: QFileDevice = ...
        ReadGroup: QFileDevice = ...
        WriteGroup: QFileDevice = ...
        ExeGroup: QFileDevice = ...
        ReadOther: QFileDevice = ...
        WriteOther: QFileDevice = ...
        ExeOther: QFileDevice = ...

    class FileError(int):
        NoError: QFileDevice = ...
        ReadError: QFileDevice = ...
        WriteError: QFileDevice = ...
        FatalError: QFileDevice = ...
        ResourceError: QFileDevice = ...
        OpenError: QFileDevice = ...
        AbortError: QFileDevice = ...
        TimeOutError: QFileDevice = ...
        UnspecifiedError: QFileDevice = ...
        RemoveError: QFileDevice = ...
        RenameError: QFileDevice = ...
        PositionError: QFileDevice = ...
        ResizeError: QFileDevice = ...
        PermissionsError: QFileDevice = ...
        CopyError: QFileDevice = ...

    class Permissions(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self, f: typing.Union["QFileDevice.Permissions", "QFileDevice.Permission"]
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QFileDevice.Permissions") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QFileDevice.Permissions":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class FileHandleFlags(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QFileDevice.FileHandleFlags", "QFileDevice.FileHandleFlag"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QFileDevice.FileHandleFlags") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QFileDevice.FileHandleFlags":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def setFileTime(
        self,
        newDate: typing.Union[QDateTime, datetime.datetime],
        fileTime: "QFileDevice.FileTime",
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qfiledevice.html#setFileTime

        **bool QFileDevice::setFileTime(const QDateTime & newDate ,
        QFileDevice::FileTime fileTime )**

        Sets the file time specified by **fileTime** to **newDate** , returning
        true if successful; otherwise returns false.

        **Note:** The file must be open to use this function.

        This function was introduced in Qt 5.10.

        **See also** **fileTime** () and **FileTime** .
        """
        ...

    def fileTime(self, time: "QFileDevice.FileTime") -> QDateTime:
        """
        https://doc.qt.io/qt-5/qfiledevice.html#fileTime

        **QDateTime QFileDevice::fileTime(QFileDevice::FileTime time ) const**

        Returns the file time specified by **time**. If the time cannot be
        determined return QDateTime() (an invalid date time).

        This function was introduced in Qt 5.10.

        **See also** **setFileTime** (), **FileTime** , and
        **QDateTime::isValid** ().
        """
        ...

    def readLineData(self, maxlen: int) -> bytes:
        """
        https://doc.qt.io/qt-5/qfiledevice.html#readLineData

        **[override virtual protected] qint64 QFileDevice::readLineData(char *
        data , qint64 maxlen )**

        Reimplements: **QIODevice::readLineData** (char *data, qint64 maxSize).
        """
        ...

    def writeData(self, data: bytes) -> int:
        """
        https://doc.qt.io/qt-5/qfiledevice.html#writeData

        **[override virtual protected] qint64 QFileDevice::writeData(const char
        * data , qint64 len )**

        Reimplements: **QIODevice::writeData** (const char *data, qint64
        maxSize).
        """
        ...

    def readData(self, maxlen: int) -> bytes:
        """
        https://doc.qt.io/qt-5/qfiledevice.html#readData

        **[override virtual protected] qint64 QFileDevice::readData(char * data
        , qint64 len )**

        Reimplements: **QIODevice::readData** (char *data, qint64 maxSize).
        """
        ...

    def unmap(self, address: PyQt5.sip.voidptr) -> bool:
        """
        https://doc.qt.io/qt-5/qfiledevice.html#unmap

        **bool QFileDevice::unmap(uchar * address )**

        Unmaps the memory **address**.

        Returns `true` if the unmap succeeds; false otherwise.

        **See also** **map** ().
        """
        ...

    def map(
        self, offset: int, size: int, flags: "QFileDevice.MemoryMapFlags" = ...
    ) -> PyQt5.sip.voidptr:
        """
        https://doc.qt.io/qt-5/qfiledevice.html#map

        **uchar *QFileDevice::map(qint64 offset , qint64 size ,
        QFileDevice::MemoryMapFlags flags = NoOptions)**

        Maps **size** bytes of the file into memory starting at **offset**. A
        file should be open for a map to succeed but the file does not need to
        stay open after the memory has been mapped. When the **QFile**  is
        destroyed or a new file is opened with this object, any maps that have
        not been unmapped will automatically be unmapped.

        The mapping will have the same open mode as the file (read and/or
        write), except when using **MapPrivateOption** , in which case it is
        always possible to write to the mapped memory.

        Any mapping options can be passed through **flags**.

        Returns a pointer to the memory or `nullptr` if there is an error.

        **See also** **unmap** ().
        """
        ...

    def setPermissions(
        self,
        permissionSpec: typing.Union[
            "QFileDevice.Permissions", "QFileDevice.Permission"
        ],
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qfiledevice.html#setPermissions

        **[virtual] bool QFileDevice::setPermissions(QFileDevice::Permissions
        permissions )**

        Sets the permissions for the file to the **permissions** specified.
        Returns `true` if successful, or `false` if the permissions cannot be
        modified.

        **Warning:** This function does not manipulate ACLs, which may limit its
        effectiveness.

        **See also** **permissions** ().
        """
        ...

    def permissions(self) -> "QFileDevice.Permissions":
        """
        https://doc.qt.io/qt-5/qfiledevice.html#permissions

        **[virtual] QFileDevice::Permissions QFileDevice::permissions() const**

        Returns the complete OR-ed together combination of **QFile::Permission**
        for the file.

        **See also** **setPermissions** ().
        """
        ...

    def resize(self, sz: int) -> bool:
        """
        https://doc.qt.io/qt-5/qfiledevice.html#resize

        **[virtual] bool QFileDevice::resize(qint64 sz )**

        Sets the file size (in bytes) **sz**. Returns `true` if the resize
        succeeds; false otherwise. If **sz** is larger than the file currently
        is, the new bytes will be set to 0; if **sz** is smaller, the file is
        simply truncated.

        **Warning:** This function can fail if the file doesn't exist.

        **See also** **size** ().
        """
        ...

    def size(self) -> int:
        """
        https://doc.qt.io/qt-5/qfiledevice.html#size

        **[override virtual] qint64 QFileDevice::size() const**

        Reimplements: **QIODevice::size** () const.

        Returns the size of the file.

        For regular empty files on Unix (e.g. those in `/proc`), this function
        returns 0; the contents of such a file are generated on demand in
        response to you calling **read** ().
        """
        ...

    def flush(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfiledevice.html#flush

        **bool QFileDevice::flush()**

        Flushes any buffered data to the file. Returns `true` if successful;
        otherwise returns `false`.
        """
        ...

    def atEnd(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfiledevice.html#atEnd

        **[override virtual] bool QFileDevice::atEnd() const**

        Reimplements: **QIODevice::atEnd** () const.

        Returns `true` if the end of the file has been reached; otherwise
        returns false.

        For regular empty files on Unix (e.g. those in `/proc`), this function
        returns `true`, since the file system reports that the size of such a
        file is 0. Therefore, you should not depend on atEnd() when reading data
        from such a file, but rather call **read** () until no more data can be
        read.
        """
        ...

    def seek(self, offset: int) -> bool:
        """
        https://doc.qt.io/qt-5/qfiledevice.html#seek

        **[override virtual] bool QFileDevice::seek(qint64 pos )**

        Reimplements: **QIODevice::seek** (qint64 pos).

        For random-access devices, this function sets the current position to
        **pos** , returning true on success, or false if an error occurred. For
        sequential devices, the default behavior is to do nothing and return
        false.

        Seeking beyond the end of a file: If the position is beyond the end of a
        file, then seek() will not immediately extend the file. If a write is
        performed at this position, then the file will be extended. The content
        of the file between the previous end of file and the newly written data
        is UNDEFINED and varies between platforms and file systems.
        """
        ...

    def pos(self) -> int:
        """
        https://doc.qt.io/qt-5/qfiledevice.html#pos

        **[override virtual] qint64 QFileDevice::pos() const**

        Reimplements: **QIODevice::pos** () const.
        """
        ...

    def fileName(self) -> str:
        """
        https://doc.qt.io/qt-5/qfiledevice.html#fileName

        **[virtual] QString QFileDevice::fileName() const**

        Returns the name of the file. The default implementation in
        **QFileDevice**  returns a null string.
        """
        ...

    def handle(self) -> int:
        """
        https://doc.qt.io/qt-5/qfiledevice.html#handle

        **int QFileDevice::handle() const**

        Returns the file handle of the file.

        This is a small positive integer, suitable for use with C library
        functions such as `fdopen()` and `fcntl()`. On systems that use file
        descriptors for sockets (i.e. Unix systems, but not Windows) the handle
        can be used with **QSocketNotifier**  as well.

        If the file is not open, or there is an error, handle() returns -1.

        **See also** **QSocketNotifier** .
        """
        ...

    def isSequential(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfiledevice.html#isSequential

        **[override virtual] bool QFileDevice::isSequential() const**

        Reimplements: **QIODevice::isSequential** () const.

        Returns `true` if the file can only be manipulated sequentially;
        otherwise returns `false`.

        Most files support random-access, but some special files may not.

        **See also** **QIODevice::isSequential** ().
        """
        ...

    def close(self) -> None:
        """
        https://doc.qt.io/qt-5/qfiledevice.html#close

        **[override virtual] void QFileDevice::close()**

        Reimplements: **QIODevice::close** ().

        Calls **QFileDevice::flush** () and closes the file. Errors from flush
        are ignored.

        **See also** **QIODevice::close** ().
        """
        ...

    def unsetError(self) -> None:
        """
        https://doc.qt.io/qt-5/qfiledevice.html#unsetError

        **void QFileDevice::unsetError()**

        Sets the file's error to **QFileDevice::NoError** .

        **See also** **error** ().
        """
        ...

    def error(self) -> "QFileDevice.FileError":
        """
        https://doc.qt.io/qt-5/qfiledevice.html#error

        **QFileDevice::FileError QFileDevice::error() const**

        Returns the file error status.

        The I/O device status returns an error code. For example, if **open** ()
        returns `false`, or a read/write operation returns -1, this function can
        be called to find out the reason why the operation failed.

        **See also** **unsetError** ().
        """
        ...
