"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QElapsedTimer(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qelapsedtimer.html

    **Detailed Description**

    The QElapsedTimer class is usually used to quickly calculate how much time
    has elapsed between two events. Its API is similar to that of **QTime** , so
    code that was using that can be ported quickly to the new class.

    However, unlike **QTime** , QElapsedTimer tries to use monotonic clocks if
    possible. This means it's not possible to convert QElapsedTimer objects to a
    human-readable time.

    The typical use-case for the class is to determine how much time was spent
    in a slow operation. The simplest example of such a case is for debugging
    purposes, as in the following example:

    **QElapsedTimer**  timer;
            timer.start();
    slowOperation1();

            **qDebug** () << "The slow operation took" <<
    timer.elapsed() << "milliseconds";

    In this example, the timer is started by a call to **start** () and the
    elapsed time is calculated by the **elapsed** () function.

    The time elapsed can also be used to recalculate the time available for
    another operation, after the first one is complete. This is useful when the
    execution must complete within a certain time period, but several steps are
    needed. The `waitFor`-type functions in **QIODevice**  and its subclasses
    are good examples of such need. In that case, the code could be as follows:

    void executeSlowOperations(int timeout)
        {
            **QElapsedTimer**
    timer;
            timer.start();
            slowOperation1();

            int
    remainingTime = timeout - timer.elapsed();
            if (remainingTime > 0)
    slowOperation2(remainingTime);
        }

    Another use-case is to execute a certain operation for a specific timeslice.
    For this, QElapsedTimer provides the **hasExpired** () convenience function,
    which can be used to determine if a certain number of milliseconds has
    already elapsed:

    void executeOperationsForTime(int ms)
        {
            **QElapsedTimer**
    timer;
            timer.start();

            while (!timer.hasExpired(ms))
    slowOperation1();
        }

    It is often more convenient to use **QDeadlineTimer**  in this case, which
    counts towards a timeout in the future instead of tracking elapsed time.

    **Reference Clocks**

    QElapsedTimer will use the platform's monotonic reference clock in all
    platforms that support it (see **QElapsedTimer::isMonotonic** ()). This has
    the added benefit that QElapsedTimer is immune to time adjustments, such as
    the user correcting the time. Also unlike **QTime** , QElapsedTimer is
    immune to changes in the timezone settings, such as daylight-saving periods.

    On the other hand, this means QElapsedTimer values can only be compared with
    other values that use the same reference. This is especially true if the
    time since the reference is extracted from the QElapsedTimer object
    (**QElapsedTimer::msecsSinceReference** ()) and serialised. These values
    should never be exchanged across the network or saved to disk, since there's
    no telling whether the computer node receiving the data is the same as the
    one originating it or if it has rebooted since.

    It is, however, possible to exchange the value with other processes running
    on the same machine, provided that they also use the same reference clock.
    QElapsedTimer will always use the same clock, so it's safe to compare with
    the value coming from another process in the same machine. If comparing to
    values produced by other APIs, you should check that the clock used is the
    same as QElapsedTimer (see **QElapsedTimer::clockType** ()).

    **32-bit overflows**

    Some of the clocks used by QElapsedTimer have a limited range and may
    overflow after hitting the upper limit (usually 32-bit). QElapsedTimer deals
    with this overflow issue and presents a consistent timing. However, when
    extracting the time since reference from QElapsedTimer, two different
    processes in the same machine may have different understanding of how much
    time has actually elapsed.

    The information on which clocks types may overflow and how to remedy that
    issue is documented along with the clock types.

    **See also** **QTime** , **QTimer** , and **QDeadlineTimer** .
    """

    class ClockType(int):
        SystemTime: QElapsedTimer = ...
        MonotonicClock: QElapsedTimer = ...
        TickCounter: QElapsedTimer = ...
        MachAbsoluteTime: QElapsedTimer = ...
        PerformanceCounter: QElapsedTimer = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qelapsedtimer.html#QElapsedTimer

        **QElapsedTimer::QElapsedTimer()**

        Constructs an invalid QElapsedTimer. A timer becomes valid once it has
        been started.

        This function was introduced in Qt 5.4.

        **See also** **isValid** () and **start** ().
        """
        ...

    @typing.overload
    def __init__(self, a0: "QElapsedTimer") -> None:
        """
        https://doc.qt.io/qt-5/qelapsedtimer.html#QElapsedTimer

        **QElapsedTimer::QElapsedTimer()**

        Constructs an invalid QElapsedTimer. A timer becomes valid once it has
        been started.

        This function was introduced in Qt 5.4.

        **See also** **isValid** () and **start** ().
        """
        ...

    def nsecsElapsed(self) -> int:
        """
        https://doc.qt.io/qt-5/qelapsedtimer.html#nsecsElapsed

        **qint64 QElapsedTimer::nsecsElapsed() const**

        Returns the number of nanoseconds since this **QElapsedTimer**  was last
        started.

        Calling this function on a **QElapsedTimer**  that is invalid results in
        undefined behavior.

        On platforms that do not provide nanosecond resolution, the value
        returned will be the best estimate available.

        This function was introduced in Qt 4.8.

        **See also** **start** (), **restart** (), **hasExpired** (), and
        **invalidate** ().
        """
        ...

    def secsTo(self, other: "QElapsedTimer") -> int:
        """
        https://doc.qt.io/qt-5/qelapsedtimer.html#secsTo

        **qint64 QElapsedTimer::secsTo(const QElapsedTimer & other ) const**

        Returns the number of seconds between this **QElapsedTimer**  and
        **other**. If **other** was started before this object, the returned
        value will be negative. If it was started later, the returned value will
        be positive.

        Calling this function on or with a **QElapsedTimer**  that is invalid
        results in undefined behavior.

        **See also** **msecsTo** () and **elapsed** ().
        """
        ...

    def msecsTo(self, other: "QElapsedTimer") -> int:
        """
        https://doc.qt.io/qt-5/qelapsedtimer.html#msecsTo

        **qint64 QElapsedTimer::msecsTo(const QElapsedTimer & other ) const**

        Returns the number of milliseconds between this **QElapsedTimer**  and
        **other**. If **other** was started before this object, the returned
        value will be negative. If it was started later, the returned value will
        be positive.

        The return value is undefined if this object or **other** were
        invalidated.

        **See also** **secsTo** () and **elapsed** ().
        """
        ...

    def msecsSinceReference(self) -> int:
        """
        https://doc.qt.io/qt-5/qelapsedtimer.html#msecsSinceReference

        **qint64 QElapsedTimer::msecsSinceReference() const**

        Returns the number of milliseconds between last time this
        **QElapsedTimer**  object was started and its reference clock's start.

        This number is usually arbitrary for all clocks except the
        **QElapsedTimer::SystemTime**  clock. For that clock type, this number
        is the number of milliseconds since January 1st, 1970 at 0:00 UTC (that
        is, it is the Unix time expressed in milliseconds).

        On Linux, Windows and Apple platforms, this value is usually the time
        since the system boot, though it usually does not include the time the
        system has spent in sleep states.

        **See also** **clockType** () and **elapsed** ().
        """
        ...

    def hasExpired(self, timeout: int) -> bool:
        """
        https://doc.qt.io/qt-5/qelapsedtimer.html#hasExpired

        **bool QElapsedTimer::hasExpired(qint64 timeout ) const**

        Returns `true` if this **QElapsedTimer**  has already expired by
        **timeout** milliseconds (that is, more than **timeout** milliseconds
        have elapsed). The value of **timeout** can be -1 to indicate that this
        timer does not expire, in which case this function will always return
        false.

        **See also** **elapsed** () and **QDeadlineTimer** .
        """
        ...

    def elapsed(self) -> int:
        """
        https://doc.qt.io/qt-5/qelapsedtimer.html#elapsed

        **qint64 QElapsedTimer::elapsed() const**

        Returns the number of milliseconds since this **QElapsedTimer**  was
        last started.

        Calling this function on a **QElapsedTimer**  that is invalid results in
        undefined behavior.

        **See also** **start** (), **restart** (), **hasExpired** (),
        **isValid** (), and **invalidate** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qelapsedtimer.html#isValid

        **bool QElapsedTimer::isValid() const**

        Returns `false` if the timer has never been started or invalidated by a
        call to **invalidate** ().

        **See also** **invalidate** (), **start** (), and **restart** ().
        """
        ...

    def invalidate(self) -> None:
        """
        https://doc.qt.io/qt-5/qelapsedtimer.html#invalidate

        **void QElapsedTimer::invalidate()**

        Marks this **QElapsedTimer**  object as invalid.

        An invalid object can be checked with **isValid** (). Calculations of
        timer elapsed since invalid data are undefined and will likely produce
        bizarre results.

        **See also** **isValid** (), **start** (), and **restart** ().
        """
        ...

    def restart(self) -> int:
        """
        https://doc.qt.io/qt-5/qelapsedtimer.html#restart

        **qint64 QElapsedTimer::restart()**

        Restarts the timer and returns the time elapsed since the previous
        start. This function is equivalent to obtaining the elapsed time with
        **elapsed** () and then starting the timer again with **start** (), but
        it does so in one single operation, avoiding the need to obtain the
        clock value twice.

        Calling this function on a **QElapsedTimer**  that is invalid results in
        undefined behavior.

        The following example illustrates how to use this function to calibrate
        a parameter to a slow operation (for example, an iteration count) so
        that this operation takes at least 250 milliseconds:

        **QElapsedTimer**  timer;

                int count = 1;
        timer.start();
                do {
                    count *= 2;
        slowOperation2(count);
                } while (timer.restart() < 250);
        return count;

        **See also** **start** (), **invalidate** (), **elapsed** (), and
        **isValid** ().
        """
        ...

    def start(self) -> None:
        """
        https://doc.qt.io/qt-5/qelapsedtimer.html#start

        **void QElapsedTimer::start()**

        Starts this timer. Once started, a timer value can be checked with
        **elapsed** () or **msecsSinceReference** ().

        Normally, a timer is started just before a lengthy operation, such as:

        **QElapsedTimer**  timer;
                timer.start();
        slowOperation1();

                **qDebug** () << "The slow operation
        took" << timer.elapsed() << "milliseconds";

        Also, starting a timer makes it valid again.

        **See also** **restart** (), **invalidate** (), and **elapsed** ().
        """
        ...

    @staticmethod
    def isMonotonic() -> bool:
        """
        https://doc.qt.io/qt-5/qelapsedtimer.html#isMonotonic

        **[static] bool QElapsedTimer::isMonotonic()**

        Returns `true` if this is a monotonic clock, false otherwise. See the
        information on the different clock types to understand which ones are
        monotonic.

        **See also** **clockType** () and **QElapsedTimer::ClockType** .
        """
        ...

    @staticmethod
    def clockType() -> "QElapsedTimer.ClockType":
        """
        https://doc.qt.io/qt-5/qelapsedtimer.html#clockType

        **[static] QElapsedTimer::ClockType QElapsedTimer::clockType()**

        Returns the clock type that this **QElapsedTimer**  implementation uses.

        **See also** **isMonotonic** ().
        """
        ...
