"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import datetime
from PyQt5.QtCore import *
from PyQt5 import sip


class QDateTime(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qdatetime.html

    **Detailed Description**

    A QDateTime object encodes a calendar date and a clock time (a "datetime").
    It combines features of the **QDate**  and **QTime**  classes. It can read
    the current datetime from the system clock. It provides functions for
    comparing datetimes and for manipulating a datetime by adding a number of
    seconds, days, months, or years.

    QDateTime can describe datetimes with respect to **local time** , to **UTC**
    , to a specified **offset from UTC**  or to a specified **time zone** , in
    conjunction with the **QTimeZone**  class. For example, a time zone of
    "Europe/Berlin" will apply the daylight-saving rules as used in Germany
    since 1970. In contrast, an offset from UTC of +3600 seconds is one hour
    ahead of UTC (usually written in ISO standard notation as "UTC+01:00"), with
    no daylight-saving offset or changes. When using either local time or a
    specified time zone, time-zone transitions such as the starts and ends of
    daylight-saving time (DST; but see below) are taken into account. The choice
    of system used to represent a datetime is described as its "timespec".

    A QDateTime object is typically created either by giving a date and time
    explicitly in the constructor, or by using a static function such as
    **currentDateTime** () or **fromMSecsSinceEpoch** (). The date and time can
    be changed with **setDate** () and **setTime** (). A datetime can also be
    set using the **setMSecsSinceEpoch** () function that takes the time, in
    milliseconds, since 00:00:00 on January 1, 1970. The **fromString** ()
    function returns a QDateTime, given a string and a date format used to
    interpret the date within the string.

    **QDateTime::currentDateTime** () returns a QDateTime that expresses the
    current time with respect to local time. **QDateTime::currentDateTimeUtc**
    () returns a QDateTime that expresses the current time with respect to UTC.

    The **date** () and **time** () functions provide access to the date and
    time parts of the datetime. The same information is provided in textual
    format by the **toString** () function.

    QDateTime provides a full set of operators to compare two QDateTime objects,
    where smaller means earlier and larger means later.

    You can increment (or decrement) a datetime by a given number of
    milliseconds using **addMSecs** (), seconds using **addSecs** (), or days
    using **addDays** (). Similarly, you can use **addMonths** () and
    **addYears** (). The **daysTo** () function returns the number of days
    between two datetimes, **secsTo** () returns the number of seconds between
    two datetimes, and **msecsTo** () returns the number of milliseconds between
    two datetimes. These operations are aware of daylight-saving time (DST) and
    other time-zone transitions, where applicable.

    Use **toTimeSpec** () to express a datetime in local time or UTC,
    **toOffsetFromUtc** () to express in terms of an offset from UTC, or
    **toTimeZone** () to express it with respect to a general time zone. You can
    use **timeSpec** () to find out what time-spec a QDateTime object stores its
    time relative to. When that is **Qt::TimeZone** , you can use **timeZone**
    () to find out which zone it is using.

    **Note:** QDateTime does not account for leap seconds.

    **Remarks**

    **No Year 0**

    There is no year 0. Dates in that year are considered invalid. The year -1
    is the year "1 before Christ" or "1 before current era." The day before 1
    January 1 CE is 31 December 1 BCE.

    **Range of Valid Dates**

    The range of values that QDateTime can represent is dependent on the
    internal storage implementation. QDateTime is currently stored in a qint64
    as a serial msecs value encoding the date and time. This restricts the date
    range to about +/- 292 million years, compared to the **QDate**  range of
    +/- 2 billion years. Care must be taken when creating a QDateTime with
    extreme values that you do not overflow the storage. The exact range of
    supported values varies depending on the **Qt::TimeSpec**  and time zone.

    **Use of Timezones**

    QDateTime uses the system's time zone information to determine the current
    local time zone and its offset from UTC. If the system is not configured
    correctly or not up-to-date, QDateTime will give wrong results.

    QDateTime likewise uses system-provided information to determine the offsets
    of other timezones from UTC. If this information is incomplete or out of
    date, QDateTime will give wrong results. See the **QTimeZone**
    documentation for more details.

    On modern Unix systems, this means QDateTime usually has accurate
    information about historical transitions (including DST, see below) whenever
    possible. On Windows, where the system doesn't support historical timezone
    data, historical accuracy is not maintained with respect to timezone
    transitions, notably including DST.

    **Daylight-Saving Time (DST)**

    QDateTime takes into account transitions between Standard Time and Daylight-
    Saving Time. For example, if the transition is at 2am and the clock goes
    forward to 3am, then there is a "missing" hour from 02:00:00 to 02:59:59.999
    which QDateTime considers to be invalid. Any date arithmetic performed will
    take this missing hour into account and return a valid result. For example,
    adding one minute to 01:59:59 will get 03:00:00.

    The range of valid dates taking DST into account is 1970-01-01 to the
    present, and rules are in place for handling DST correctly until 2037-12-31,
    but these could change. For dates after 2037, QDateTime makes a **best
    guess** using the rules for year 2037, but we can't guarantee accuracy;
    indeed, for **any** future date, the time-zone may change its rules before
    that date comes around. For dates before 1970, QDateTime doesn't take DST
    changes into account, even if the system's time zone database provides that
    information, although it does take into account changes to the time-zone's
    standard offset, where this information is available.

    **Offsets From UTC**

    There is no explicit size restriction on an offset from UTC, but there is an
    implicit limit imposed when using the **toString** () and **fromString** ()
    methods which use a [+|-]hh:mm format, effectively limiting the range to +/-
    99 hours and 59 minutes and whole minutes only. Note that currently no time
    zone lies outside the range of +/- 14 hours.

    **See also** **QDate** , **QTime** , **QDateTimeEdit** , and **QTimeZone** .
    """

    class YearRange(int):
        First: QDateTime = ...
        Last: QDateTime = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qdatetime.html#QDateTime

        **QDateTime::QDateTime()**

        Constructs a null datetime (i.e. null date and null time). A null
        datetime is invalid, since the date is invalid.

        **See also** **isValid** ().
        """
        ...

    @typing.overload
    def __init__(self, other: typing.Union["QDateTime", datetime.datetime]) -> None:
        """
        https://doc.qt.io/qt-5/qdatetime.html#QDateTime-1

        **QDateTime::QDateTime(const QDate & date )**

        Constructs a datetime with the given **date** , using **Qt::LocalTime**
        as the **timeSpec** () and the time at the start of that date.

        **See also** **QDate::startOfDay** ().
        """
        ...

    @typing.overload
    def __init__(self, a0: typing.Union[QDate, datetime.date]) -> None:
        """
        https://doc.qt.io/qt-5/qdatetime.html#QDateTime-2

        **QDateTime::QDateTime(const QDate & date , const QTime & time ,
        Qt::TimeSpec spec = Qt::LocalTime)**

        Constructs a datetime with the given **date** and **time** , using the
        time specification defined by **spec**.

        If **date** is valid and **time** is not, the time will be set to
        midnight.

        If **spec** is **Qt::OffsetFromUTC**  then it will be set to **Qt::UTC**
        , i.e. an offset of 0 seconds. To create a **Qt::OffsetFromUTC**
        datetime use the correct constructor.

        If **spec** is **Qt::TimeZone**  then the spec will be set to
        **Qt::LocalTime** , i.e. the current system time zone. To create a
        **Qt::TimeZone**  datetime use the correct constructor.
        """
        ...

    @typing.overload
    def __init__(
        self,
        date: typing.Union[QDate, datetime.date],
        time: typing.Union[QTime, datetime.time],
        timeSpec: Qt.TimeSpec = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qdatetime.html#QDateTime-3

        **QDateTime::QDateTime(const QDate & date , const QTime & time ,
        Qt::TimeSpec spec , int offsetSeconds )**

        Constructs a datetime with the given **date** and **time** , using the
        time specification defined by **spec** and **offsetSeconds** seconds.

        If **date** is valid and **time** is not, the time will be set to
        midnight.

        If the **spec** is not **Qt::OffsetFromUTC**  then **offsetSeconds**
        will be ignored.

        If the **spec** is **Qt::OffsetFromUTC**  and **offsetSeconds** is 0
        then the **timeSpec** () will be set to **Qt::UTC** , i.e. an offset of
        0 seconds.

        If **spec** is **Qt::TimeZone**  then the spec will be set to
        **Qt::LocalTime** , i.e. the current system time zone. To create a
        **Qt::TimeZone**  datetime use the correct constructor.

        This function was introduced in Qt 5.2.
        """
        ...

    @typing.overload
    def __init__(
        self,
        year: int,
        month: int,
        day: int,
        hour: int,
        minute: int,
        second: int = ...,
        msec: int = ...,
        timeSpec: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qdatetime.html#QDateTime-4

        **QDateTime::QDateTime(const QDate & date , const QTime & time , const
        QTimeZone & timeZone )**

        Constructs a datetime with the given **date** and **time** , using the
        Time Zone specified by **timeZone**.

        If **date** is valid and **time** is not, the time will be set to
        00:00:00.

        If **timeZone** is invalid then the datetime will be invalid.

        This function was introduced in Qt 5.2.
        """
        ...

    @typing.overload
    def __init__(
        self,
        date: typing.Union[QDate, datetime.date],
        time: typing.Union[QTime, datetime.time],
        spec: Qt.TimeSpec,
        offsetSeconds: int,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qdatetime.html#QDateTime-5

        **QDateTime::QDateTime(const QDateTime & other )**

        Constructs a copy of the **other** datetime.
        """
        ...

    @typing.overload
    def __init__(
        self,
        date: typing.Union[QDate, datetime.date],
        time: typing.Union[QTime, datetime.time],
        timeZone: "QTimeZone",
    ) -> None:
        """
        https://doc.qt.io/qt-5/qdatetime.html#QDateTime-6

        **QDateTime::QDateTime(QDateTime && other )**

        Moves the content of the temporary **other** datetime to this object and
        leaves **other** in an unspecified (but proper) state.

        This function was introduced in Qt 5.8.
        """
        ...

    @staticmethod
    def currentSecsSinceEpoch() -> int:
        """
        https://doc.qt.io/qt-5/qdatetime.html#currentSecsSinceEpoch

        **[static] qint64 QDateTime::currentSecsSinceEpoch()**

        Returns the number of seconds since 1970-01-01T00:00:00 Universal
        Coordinated Time.

        This function was introduced in Qt 5.8.

        **See also** **currentMSecsSinceEpoch** ().
        """
        ...

    @typing.overload
    @staticmethod
    def fromSecsSinceEpoch(
        secs: int, spec: Qt.TimeSpec = ..., offsetSeconds: int = ...
    ) -> "QDateTime":
        """
        https://doc.qt.io/qt-5/qdatetime.html#fromSecsSinceEpoch

        **[static] QDateTime QDateTime::fromSecsSinceEpoch(qint64 secs ,
        Qt::TimeSpec spec = Qt::LocalTime, int offsetSeconds = 0)**

        Returns a datetime whose date and time are the number of seconds
        **secs** that have passed since 1970-01-01T00:00:00.000, Coordinated
        Universal Time (**Qt::UTC** ) and converted to the given **spec**.

        Note that there are possible values for **secs** that lie outside the
        valid range of **QDateTime** , both negative and positive. The behavior
        of this function is undefined for those values.

        If the **spec** is not **Qt::OffsetFromUTC**  then the **offsetSeconds**
        will be ignored. If the **spec** is **Qt::OffsetFromUTC**  and the
        **offsetSeconds** is 0 then the spec will be set to **Qt::UTC** , i.e.
        an offset of 0 seconds.

        If **spec** is **Qt::TimeZone**  then the spec will be set to
        **Qt::LocalTime** , i.e. the current system time zone.

        This function was introduced in Qt 5.8.

        **See also** **toSecsSinceEpoch** () and **setSecsSinceEpoch** ().
        """
        ...

    @typing.overload
    @staticmethod
    def fromSecsSinceEpoch(secs: int, timeZone: "QTimeZone") -> "QDateTime":
        """
        https://doc.qt.io/qt-5/qdatetime.html#fromSecsSinceEpoch-1

        **[static] QDateTime QDateTime::fromSecsSinceEpoch(qint64 secs , const
        QTimeZone & timeZone )**

        Returns a datetime whose date and time are the number of seconds
        **secs** that have passed since 1970-01-01T00:00:00.000, Coordinated
        Universal Time (**Qt::UTC** ) and with the given **timeZone**.

        This function was introduced in Qt 5.8.

        **See also** **fromMSecsSinceEpoch** ().
        """
        ...

    def setSecsSinceEpoch(self, secs: int) -> None:
        """
        https://doc.qt.io/qt-5/qdatetime.html#setSecsSinceEpoch

        **void QDateTime::setSecsSinceEpoch(qint64 secs )**

        Sets the date and time given the number of seconds **secs** that have
        passed since 1970-01-01T00:00:00.000, Coordinated Universal Time
        (**Qt::UTC** ). On systems that do not support time zones this function
        will behave as if local time were **Qt::UTC** .

        This function was introduced in Qt 5.8.

        **See also** **toSecsSinceEpoch** () and **setMSecsSinceEpoch** ().
        """
        ...

    def toSecsSinceEpoch(self) -> int:
        """
        https://doc.qt.io/qt-5/qdatetime.html#toSecsSinceEpoch

        **qint64 QDateTime::toSecsSinceEpoch() const**

        Returns the datetime as the number of seconds that have passed since
        1970-01-01T00:00:00.000, Coordinated Universal Time (**Qt::UTC** ).

        On systems that do not support time zones, this function will behave as
        if local time were **Qt::UTC** .

        The behavior for this function is undefined if the datetime stored in
        this object is not valid. However, for all valid dates, this function
        returns a unique value.

        This function was introduced in Qt 5.8.

        **See also** **toMSecsSinceEpoch** () and **setSecsSinceEpoch** ().
        """
        ...

    def toTimeZone(self, toZone: "QTimeZone") -> "QDateTime":
        """
        https://doc.qt.io/qt-5/qdatetime.html#toTimeZone

        **QDateTime QDateTime::toTimeZone(const QTimeZone & timeZone ) const**

        Returns a copy of this datetime converted to the given **timeZone**

        This function was introduced in Qt 5.2.

        **See also** **timeZone** () and **toTimeSpec** ().
        """
        ...

    def toOffsetFromUtc(self, offsetSeconds: int) -> "QDateTime":
        """
        https://doc.qt.io/qt-5/qdatetime.html#toOffsetFromUtc

        **QDateTime QDateTime::toOffsetFromUtc(int offsetSeconds ) const**

        Returns a copy of this datetime converted to a spec of
        **Qt::OffsetFromUTC**  with the given **offsetSeconds**.

        If the **offsetSeconds** equals 0 then a UTC datetime will be returned

        This function was introduced in Qt 5.2.

        **See also** **setOffsetFromUtc** (), **offsetFromUtc** (), and
        **toTimeSpec** ().
        """
        ...

    def setTimeZone(self, toZone: "QTimeZone") -> None:
        """
        https://doc.qt.io/qt-5/qdatetime.html#setTimeZone

        **void QDateTime::setTimeZone(const QTimeZone & toZone )**

        Sets the time zone used in this datetime to **toZone**. The datetime
        will refer to a different point in time.

        If **toZone** is invalid then the datetime will be invalid.

        This function was introduced in Qt 5.2.

        **See also** **timeZone** () and **Qt::TimeSpec** .
        """
        ...

    def setOffsetFromUtc(self, offsetSeconds: int) -> None:
        """
        https://doc.qt.io/qt-5/qdatetime.html#setOffsetFromUtc

        **void QDateTime::setOffsetFromUtc(int offsetSeconds )**

        Sets the **timeSpec** () to **Qt::OffsetFromUTC**  and the offset to
        **offsetSeconds**. The datetime will refer to a different point in time.

        The maximum and minimum offset is 14 positive or negative hours. If
        **offsetSeconds** is larger or smaller than that, then the result is
        undefined.

        If **offsetSeconds** is 0 then the **timeSpec** () will be set to
        **Qt::UTC** .

        This function was introduced in Qt 5.2.

        **See also** **isValid** () and **offsetFromUtc** ().
        """
        ...

    def isDaylightTime(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdatetime.html#isDaylightTime

        **bool QDateTime::isDaylightTime() const**

        Returns if this datetime falls in Daylight-Saving Time.

        If the **Qt::TimeSpec**  is not **Qt::LocalTime**  or **Qt::TimeZone**
        then will always return false.

        This function was introduced in Qt 5.2.

        **See also** **timeSpec** ().
        """
        ...

    def timeZoneAbbreviation(self) -> str:
        """
        https://doc.qt.io/qt-5/qdatetime.html#timeZoneAbbreviation

        **QString QDateTime::timeZoneAbbreviation() const**

        Returns the Time Zone Abbreviation for the datetime.

        If the **timeSpec** () is **Qt::UTC**  this will be "UTC".

        If the **timeSpec** () is **Qt::OffsetFromUTC**  this will be in the
        format "UTC[+-]00:00".

        If the **timeSpec** () is **Qt::LocalTime**  then the host system is
        queried for the correct abbreviation.

        Note that abbreviations may or may not be localized.

        Note too that the abbreviation is not guaranteed to be a unique value,
        i.e. different time zones may have the same abbreviation.

        This function was introduced in Qt 5.2.

        **See also** **timeSpec** ().
        """
        ...

    def timeZone(self) -> "QTimeZone":
        """
        https://doc.qt.io/qt-5/qdatetime.html#timeZone

        **QTimeZone QDateTime::timeZone() const**

        Returns the time zone of the datetime.

        If the **timeSpec** () is **Qt::LocalTime**  then an instance of the
        current system time zone will be returned. Note however that if you copy
        this time zone the instance will not remain in sync if the system time
        zone changes.

        This function was introduced in Qt 5.2.

        **See also** **setTimeZone** () and **Qt::TimeSpec** .
        """
        ...

    def offsetFromUtc(self) -> int:
        """
        https://doc.qt.io/qt-5/qdatetime.html#offsetFromUtc

        **int QDateTime::offsetFromUtc() const**

        Returns this date-time's Offset From UTC in seconds.

        The result depends on **timeSpec** ():

        * `Qt::UTC` The offset is 0.
          * `Qt::OffsetFromUTC` The offset is the
        value originally set.
          * `Qt::LocalTime` The local time's offset from
        UTC is returned.
          * `Qt::TimeZone` The offset used by the time-zone is
        returned.

        For the last two, the offset at this date and time will be returned,
        taking account of Daylight-Saving Offset unless the date precedes the
        start of 1970. The offset is the difference between the local time or
        time in the given time-zone and UTC time; it is positive in time-zones
        ahead of UTC (East of The Prime Meridian), negative for those behind UTC
        (West of The Prime Meridian).

        This function was introduced in Qt 5.2.

        **See also** **setOffsetFromUtc** ().
        """
        ...

    def swap(self, other: "QDateTime") -> None:
        """
        https://doc.qt.io/qt-5/qdatetime.html#swap

        **void QDateTime::swap(QDateTime & other )**

        Swaps this datetime with **other**. This operation is very fast and
        never fails.

        This function was introduced in Qt 5.0.
        """
        ...

    @staticmethod
    def currentMSecsSinceEpoch() -> int:
        """
        https://doc.qt.io/qt-5/qdatetime.html#currentMSecsSinceEpoch

        **[static] qint64 QDateTime::currentMSecsSinceEpoch()**

        Returns the number of milliseconds since 1970-01-01T00:00:00 Universal
        Coordinated Time. This number is like the POSIX time_t variable, but
        expressed in milliseconds instead.

        This function was introduced in Qt 4.7.

        **See also** **currentDateTime** (), **currentDateTimeUtc** (),
        **toTime_t** (), and **toTimeSpec** ().
        """
        ...

    @typing.overload
    @staticmethod
    def fromMSecsSinceEpoch(msecs: int) -> "QDateTime":
        """
        https://doc.qt.io/qt-5/qdatetime.html#fromMSecsSinceEpoch

        **[static] QDateTime QDateTime::fromMSecsSinceEpoch(qint64 msecs )**

        Returns a datetime whose date and time are the number of milliseconds,
        **msecs** , that have passed since 1970-01-01T00:00:00.000, Coordinated
        Universal Time (**Qt::UTC** ), and converted to **Qt::LocalTime** . On
        systems that do not support time zones, the time will be set as if local
        time were **Qt::UTC** .

        Note that there are possible values for **msecs** that lie outside the
        valid range of **QDateTime** , both negative and positive. The behavior
        of this function is undefined for those values.

        This function was introduced in Qt 4.7.

        **See also** **toMSecsSinceEpoch** () and **setMSecsSinceEpoch** ().
        """
        ...

    @typing.overload
    @staticmethod
    def fromMSecsSinceEpoch(
        msecs: int, spec: Qt.TimeSpec, offsetSeconds: int = ...
    ) -> "QDateTime":
        """
        https://doc.qt.io/qt-5/qdatetime.html#fromMSecsSinceEpoch-1

        **[static] QDateTime QDateTime::fromMSecsSinceEpoch(qint64 msecs ,
        Qt::TimeSpec spec , int offsetSeconds = 0)**

        Returns a datetime whose date and time are the number of milliseconds
        **msecs** that have passed since 1970-01-01T00:00:00.000, Coordinated
        Universal Time (**Qt::UTC** ) and converted to the given **spec**.

        Note that there are possible values for **msecs** that lie outside the
        valid range of **QDateTime** , both negative and positive. The behavior
        of this function is undefined for those values.

        If the **spec** is not **Qt::OffsetFromUTC**  then the **offsetSeconds**
        will be ignored. If the **spec** is **Qt::OffsetFromUTC**  and the
        **offsetSeconds** is 0 then the spec will be set to **Qt::UTC** , i.e.
        an offset of 0 seconds.

        If **spec** is **Qt::TimeZone**  then the spec will be set to
        **Qt::LocalTime** , i.e. the current system time zone.

        This function was introduced in Qt 5.2.

        **See also** **toMSecsSinceEpoch** () and **setMSecsSinceEpoch** ().
        """
        ...

    @typing.overload
    @staticmethod
    def fromMSecsSinceEpoch(msecs: int, timeZone: "QTimeZone") -> "QDateTime":
        """
        https://doc.qt.io/qt-5/qdatetime.html#fromMSecsSinceEpoch-2

        **[static] QDateTime QDateTime::fromMSecsSinceEpoch(qint64 msecs , const
        QTimeZone & timeZone )**

        Returns a datetime whose date and time are the number of milliseconds
        **msecs** that have passed since 1970-01-01T00:00:00.000, Coordinated
        Universal Time (**Qt::UTC** ) and with the given **timeZone**.

        This function was introduced in Qt 5.2.

        **See also** **fromSecsSinceEpoch** ().
        """
        ...

    @staticmethod
    def currentDateTimeUtc() -> "QDateTime":
        """
        https://doc.qt.io/qt-5/qdatetime.html#currentDateTimeUtc

        **[static] QDateTime QDateTime::currentDateTimeUtc()**

        Returns the current datetime, as reported by the system clock, in UTC.

        This function was introduced in Qt 4.7.

        **See also** **currentDateTime** (), **QDate::currentDate** (),
        **QTime::currentTime** (), and **toTimeSpec** ().
        """
        ...

    def msecsTo(self, a0: typing.Union["QDateTime", datetime.datetime]) -> int:
        """
        https://doc.qt.io/qt-5/qdatetime.html#msecsTo

        **qint64 QDateTime::msecsTo(const QDateTime & other ) const**

        Returns the number of milliseconds from this datetime to the **other**
        datetime. If the **other** datetime is earlier than this datetime, the
        value returned is negative.

        Before performing the comparison, the two datetimes are converted to
        **Qt::UTC**  to ensure that the result is correct if daylight-saving
        (DST) applies to one of the two datetimes and but not the other.

        Returns 0 if either datetime is invalid.

        **See also** **addMSecs** (), **daysTo** (), and **QTime::msecsTo** ().
        """
        ...

    def setMSecsSinceEpoch(self, msecs: int) -> None:
        """
        https://doc.qt.io/qt-5/qdatetime.html#setMSecsSinceEpoch

        **void QDateTime::setMSecsSinceEpoch(qint64 msecs )**

        Sets the date and time given the number of milliseconds **msecs** that
        have passed since 1970-01-01T00:00:00.000, Coordinated Universal Time
        (**Qt::UTC** ). On systems that do not support time zones this function
        will behave as if local time were **Qt::UTC** .

        Note that passing the minimum of `qint64`
        (`std::numeric_limits<qint64>::min()`) to **msecs** will result in
        undefined behavior.

        This function was introduced in Qt 4.7.

        **See also** **toMSecsSinceEpoch** () and **setSecsSinceEpoch** ().
        """
        ...

    def toMSecsSinceEpoch(self) -> int:
        """
        https://doc.qt.io/qt-5/qdatetime.html#toMSecsSinceEpoch

        **qint64 QDateTime::toMSecsSinceEpoch() const**

        Returns the datetime as the number of milliseconds that have passed
        since 1970-01-01T00:00:00.000, Coordinated Universal Time (**Qt::UTC**
        ).

        On systems that do not support time zones, this function will behave as
        if local time were **Qt::UTC** .

        The behavior for this function is undefined if the datetime stored in
        this object is not valid. However, for all valid dates, this function
        returns a unique value.

        This function was introduced in Qt 4.7.

        **See also** **toSecsSinceEpoch** () and **setMSecsSinceEpoch** ().
        """
        ...

    @typing.overload
    @staticmethod
    def fromTime_t(secsSince1Jan1970UTC: int) -> "QDateTime":
        ...

    @typing.overload
    @staticmethod
    def fromTime_t(
        secsSince1Jan1970UTC: int, spec: Qt.TimeSpec, offsetSeconds: int = ...
    ) -> "QDateTime":
        ...

    @typing.overload
    @staticmethod
    def fromTime_t(secsSince1Jan1970UTC: int, timeZone: "QTimeZone") -> "QDateTime":
        ...

    @typing.overload
    @staticmethod
    def fromString(string: str, format: Qt.DateFormat = ...) -> "QDateTime":
        """
        https://doc.qt.io/qt-5/qdatetime.html#fromString

        **[static] QDateTime QDateTime::fromString(const QString & string ,
        Qt::DateFormat format = Qt::TextDate)**

        Returns the **QDateTime**  represented by the **string** , using the
        **format** given, or an invalid datetime if this is not possible.

        Note for **Qt::TextDate** : It is recommended that you use the English
        short month names (e.g. "Jan"). Although localized month names can also
        be used in Qt 5, they depend on the user's locale settings.

        **Note:** Support for localized dates, including the format options
        **Qt::SystemLocaleDate** , **Qt::SystemLocaleShortDate** ,
        **Qt::SystemLocaleLongDate** , **Qt::LocaleDate** ,
        **Qt::DefaultLocaleShortDate** , and **Qt::DefaultLocaleLongDate** ,
        shall be removed in Qt 6. Use **QLocale::toDateTime** () instead.

        **See also** **toString** () and **QLocale::toDateTime** ().
        """
        ...

    @typing.overload
    @staticmethod
    def fromString(s: str, format: str) -> "QDateTime":
        """
        https://doc.qt.io/qt-5/qdatetime.html#fromString-2

        **[static] QDateTime QDateTime::fromString(const QString & string ,
        const QString & format , QCalendar cal )**

        Returns the **QDateTime**  represented by the **string** , using the
        **format** given, or an invalid datetime if the string cannot be parsed.

        Uses the calendar **cal** if supplied, else Gregorian.

        In addition to the expressions, recognized in the format string to
        represent parts of the date and time, by **QDate::fromString** () and
        **QTime::fromString** (), this method supports:

        ExpressionOutput
        tthe timezone (for example "CEST")

        All other input characters will be treated as text. Any non-empty
        sequence of characters enclosed in single quotes will also be treated
        (stripped of the quotes) as text and not be interpreted as expressions.

        **QTime**  time1 = **QTime** ::fromString("131", "HHh");
            // time1 is
        13:00:00
            **QTime**  time1 = **QTime** ::fromString("1apA", "1amAM");
        // time1 is 01:00:00

            **QDateTime**  dateTime2 = **QDateTime**
        ::fromString("M1d1y9800:01:02",
        "'M'M'd'd'y'yyhh:mm:ss");
            // dateTime is 1 January 1998 00:01:02

        If the format is not satisfied, an invalid **QDateTime**  is returned.
        The expressions that don't have leading zeroes (d, M, h, m, s, z) will
        be greedy. This means that they will use two digits even if this will
        put them outside the range and/or leave too few digits for other
        sections.

        **QDateTime**  dateTime = **QDateTime** ::fromString("130", "Mm"); //
        invalid

        This could have meant 1 January 00:30.00 but the M will grab two digits.

        Incorrectly specified fields of the **string** will cause an invalid
        **QDateTime**  to be returned. For example, consider the following code,
        where the two digit year 12 is read as 1912 (see the table below for all
        field defaults); the resulting datetime is invalid because 23 April 1912
        was a Tuesday, not a Monday:

        **QString**  string = "Monday, 23 April 12 22:51:41";
            **QString**
        format = "dddd, d MMMM yy hh:mm:ss";
            **QDateTime**  invalid =
        **QDateTime** ::fromString(string, format);

        The correct code is:

        **QString**  string = "Tuesday, 23 April 12 22:51:41";
            **QString**
        format = "dddd, d MMMM yy hh:mm:ss";
            **QDateTime**  valid =
        **QDateTime** ::fromString(string, format);

        For any field that is not represented in the format, the following
        defaults are used:

        FieldDefault value
        Year1900
        Month1 (January)
        Day1
        Hour0
        Minute0
        Second0

        For example:

        **QDateTime**  dateTime = **QDateTime** ::fromString("1.30.1", "M.d.s");
        // dateTime is January 30 in 1900 at 00:00:01.
            dateTime =
        **QDateTime** ::fromString("12", "yy");
            // dateTime is January 1 in
        1912 at 00:00:00.

        **Note:** If localized month and day names are used, please switch to
        using **QLocale::system** ().toDateTime() as **QDateTime**  methods
        shall change to only recognize English (C locale) names at Qt 6.

        **See also** **toString** (), **QDate::fromString** (),
        **QTime::fromString** (), and **QLocale::toDateTime** ().
        """
        ...

    @typing.overload
    @staticmethod
    def fromString(s: str, format: str, cal: QCalendar) -> "QDateTime":
        """
        https://doc.qt.io/qt-5/qdatetime.html#fromString

        **[static] QDateTime QDateTime::fromString(const QString & string ,
        Qt::DateFormat format = Qt::TextDate)**

        Returns the **QDateTime**  represented by the **string** , using the
        **format** given, or an invalid datetime if this is not possible.

        Note for **Qt::TextDate** : It is recommended that you use the English
        short month names (e.g. "Jan"). Although localized month names can also
        be used in Qt 5, they depend on the user's locale settings.

        **Note:** Support for localized dates, including the format options
        **Qt::SystemLocaleDate** , **Qt::SystemLocaleShortDate** ,
        **Qt::SystemLocaleLongDate** , **Qt::LocaleDate** ,
        **Qt::DefaultLocaleShortDate** , and **Qt::DefaultLocaleLongDate** ,
        shall be removed in Qt 6. Use **QLocale::toDateTime** () instead.

        **See also** **toString** () and **QLocale::toDateTime** ().
        """
        ...

    @staticmethod
    def currentDateTime() -> "QDateTime":
        """
        https://doc.qt.io/qt-5/qdatetime.html#currentDateTime

        **[static] QDateTime QDateTime::currentDateTime()**

        Returns the current datetime, as reported by the system clock, in the
        local time zone.

        **See also** **currentDateTimeUtc** (), **QDate::currentDate** (),
        **QTime::currentTime** (), and **toTimeSpec** ().
        """
        ...

    def secsTo(self, a0: typing.Union["QDateTime", datetime.datetime]) -> int:
        """
        https://doc.qt.io/qt-5/qdatetime.html#secsTo

        **qint64 QDateTime::secsTo(const QDateTime & other ) const**

        Returns the number of seconds from this datetime to the **other**
        datetime. If the **other** datetime is earlier than this datetime, the
        value returned is negative.

        Before performing the comparison, the two datetimes are converted to
        **Qt::UTC**  to ensure that the result is correct if daylight-saving
        (DST) applies to one of the two datetimes but not the other.

        Returns 0 if either datetime is invalid.

        Example:

        **QDateTime**  now = **QDateTime** ::currentDateTime();
        **QDateTime**  xmas(**QDate** (now.date().year(), 12, 25).startOfDay());
        **qDebug** ("There are %d seconds to Christmas", now.secsTo(xmas));

        **See also** **addSecs** (), **daysTo** (), and **QTime::secsTo** ().
        """
        ...

    def daysTo(self, a0: typing.Union["QDateTime", datetime.datetime]) -> int:
        """
        https://doc.qt.io/qt-5/qdatetime.html#daysTo

        **qint64 QDateTime::daysTo(const QDateTime & other ) const**

        Returns the number of days from this datetime to the **other** datetime.
        The number of days is counted as the number of times midnight is reached
        between this datetime to the **other** datetime. This means that a 10
        minute difference from 23:55 to 0:05 the next day counts as one day.

        If the **other** datetime is earlier than this datetime, the value
        returned is negative.

        Example:

        **QDateTime**  startDate(**QDate** (2012, 7, 6), **QTime** (8, 30, 0));
        **QDateTime**  endDate(**QDate** (2012, 7, 7), **QTime** (16, 30, 0));
        **qDebug** () << "Days from startDate to endDate: " <<
        startDate.daysTo(endDate);

            startDate = **QDateTime** (**QDate**
        (2012, 7, 6), **QTime** (23, 55, 0));
            endDate = **QDateTime**
        (**QDate** (2012, 7, 7), **QTime** (0, 5, 0));
            **qDebug** () <<
        "Days from startDate to endDate: " << startDate.daysTo(endDate);
        **qSwap** (startDate, endDate); // Make endDate before startDate.
        **qDebug** () << "Days from startDate to endDate: " <<
        startDate.daysTo(endDate);

        **See also** **addDays** (), **secsTo** (), and **msecsTo** ().
        """
        ...

    def toUTC(self) -> "QDateTime":
        """
        https://doc.qt.io/qt-5/qdatetime.html#toUTC

        **QDateTime QDateTime::toUTC() const**

        Returns a datetime containing the date and time information in this
        datetime, but specified using the **Qt::UTC**  definition.

        Example:

        **QDateTime**  local(**QDateTime** ::currentDateTime());
        **QDateTime**  UTC(local.toUTC());
            **qDebug** () << "Local time is:"
        << local;
            **qDebug** () << "UTC time is:" << UTC;
            **qDebug** ()
        << "No difference between times:" << local.secsTo(UTC);

        **See also** **toTimeSpec** ().
        """
        ...

    def toLocalTime(self) -> "QDateTime":
        """
        https://doc.qt.io/qt-5/qdatetime.html#toLocalTime

        **QDateTime QDateTime::toLocalTime() const**

        Returns a datetime containing the date and time information in this
        datetime, but specified using the **Qt::LocalTime**  definition.

        Example:

        **QDateTime**  UTC(**QDateTime** ::currentDateTimeUtc());
        **QDateTime**  local(UTC.toLocalTime());
            **qDebug** () << "UTC time
        is:" << UTC;
            **qDebug** () << "Local time is:" << local;
        **qDebug** () << "No difference between times:" << UTC.secsTo(local);

        **See also** **toTimeSpec** ().
        """
        ...

    def toTimeSpec(self, spec: Qt.TimeSpec) -> "QDateTime":
        """
        https://doc.qt.io/qt-5/qdatetime.html#toTimeSpec

        **QDateTime QDateTime::toTimeSpec(Qt::TimeSpec spec ) const**

        Returns a copy of this datetime converted to the given time **spec**.

        If **spec** is **Qt::OffsetFromUTC**  then it is set to **Qt::UTC** . To
        set to a spec of **Qt::OffsetFromUTC**  use **toOffsetFromUtc** ().

        If **spec** is **Qt::TimeZone**  then it is set to **Qt::LocalTime** ,
        i.e. the local Time Zone.

        Example:

        **QDateTime**  local(**QDateTime** ::currentDateTime());
        **QDateTime**  UTC(local.toTimeSpec(Qt::UTC));
            **qDebug** () <<
        "Local time is:" << local;
            **qDebug** () << "UTC time is:" << UTC;
        **qDebug** () << "No difference between times:" << local.secsTo(UTC);

        **See also** **timeSpec** (), **toTimeZone** (), and **toOffsetFromUtc**
        ().
        """
        ...

    def addMSecs(self, msecs: int) -> "QDateTime":
        """
        https://doc.qt.io/qt-5/qdatetime.html#addMSecs

        **QDateTime QDateTime::addMSecs(qint64 msecs ) const**

        Returns a **QDateTime**  object containing a datetime **msecs**
        miliseconds later than the datetime of this object (or earlier if
        **msecs** is negative).

        If this datetime is invalid, an invalid datetime will be returned.

        **See also** **addSecs** (), **msecsTo** (), **addDays** (),
        **addMonths** (), and **addYears** ().
        """
        ...

    def addSecs(self, secs: int) -> "QDateTime":
        """
        https://doc.qt.io/qt-5/qdatetime.html#addSecs

        **QDateTime QDateTime::addSecs(qint64 s ) const**

        Returns a **QDateTime**  object containing a datetime **s** seconds
        later than the datetime of this object (or earlier if **s** is
        negative).

        If this datetime is invalid, an invalid datetime will be returned.

        **See also** **addMSecs** (), **secsTo** (), **addDays** (),
        **addMonths** (), and **addYears** ().
        """
        ...

    def addYears(self, years: int) -> "QDateTime":
        """
        https://doc.qt.io/qt-5/qdatetime.html#addYears

        **QDateTime QDateTime::addYears(int nyears ) const**

        Returns a **QDateTime**  object containing a datetime **nyears** years
        later than the datetime of this object (or earlier if **nyears** is
        negative).

        If the **timeSpec** () is **Qt::LocalTime**  and the resulting date and
        time fall in the Standard Time to Daylight-Saving Time transition hour
        then the result will be adjusted accordingly, i.e. if the transition is
        at 2am and the clock goes forward to 3am and the result falls between
        2am and 3am then the result will be adjusted to fall after 3am.

        **See also** **daysTo** (), **addDays** (), **addMonths** (), and
        **addSecs** ().
        """
        ...

    def addMonths(self, months: int) -> "QDateTime":
        """
        https://doc.qt.io/qt-5/qdatetime.html#addMonths

        **QDateTime QDateTime::addMonths(int nmonths ) const**

        Returns a **QDateTime**  object containing a datetime **nmonths** months
        later than the datetime of this object (or earlier if **nmonths** is
        negative).

        If the **timeSpec** () is **Qt::LocalTime**  and the resulting date and
        time fall in the Standard Time to Daylight-Saving Time transition hour
        then the result will be adjusted accordingly, i.e. if the transition is
        at 2am and the clock goes forward to 3am and the result falls between
        2am and 3am then the result will be adjusted to fall after 3am.

        **See also** **daysTo** (), **addDays** (), **addYears** (), and
        **addSecs** ().
        """
        ...

    def addDays(self, days: int) -> "QDateTime":
        """
        https://doc.qt.io/qt-5/qdatetime.html#addDays

        **QDateTime QDateTime::addDays(qint64 ndays ) const**

        Returns a **QDateTime**  object containing a datetime **ndays** days
        later than the datetime of this object (or earlier if **ndays** is
        negative).

        If the **timeSpec** () is **Qt::LocalTime**  and the resulting date and
        time fall in the Standard Time to Daylight-Saving Time transition hour
        then the result will be adjusted accordingly, i.e. if the transition is
        at 2am and the clock goes forward to 3am and the result falls between
        2am and 3am then the result will be adjusted to fall after 3am.

        **See also** **daysTo** (), **addMonths** (), **addYears** (), and
        **addSecs** ().
        """
        ...

    @typing.overload
    def toString(self, format: Qt.DateFormat = ...) -> str:
        """
        https://doc.qt.io/qt-5/qdatetime.html#toString-1

        **QString QDateTime::toString(Qt::DateFormat format = Qt::TextDate)
        const**

        This is an overloaded function.

        Returns the datetime as a string in the **format** given.

        If the **format** is **Qt::TextDate** , the string is formatted in the
        default way. The day and month names will be localized names using the
        system locale, i.e. **QLocale::system** (). An example of this
        formatting is "Wed May 20 03:40:13 1998".

        If the **format** is **Qt::ISODate** , the string format corresponds to
        the ISO 8601 extended specification for representations of dates and
        times, taking the form yyyy-MM-ddTHH:mm:ss[Z|[+|-]HH:mm], depending on
        the **timeSpec** () of the **QDateTime** . If the **timeSpec** () is
        **Qt::UTC** , Z will be appended to the string; if the **timeSpec** ()
        is **Qt::OffsetFromUTC** , the offset in hours and minutes from UTC will
        be appended to the string. To include milliseconds in the ISO 8601 date,
        use the **format** **Qt::ISODateWithMs** , which corresponds to yyyy-MM-
        ddTHH:mm:ss.zzz[Z|[+|-]HH:mm].

        The **format** options **Qt::SystemLocaleDate** ,
        **Qt::SystemLocaleShortDate**  and **Qt::SystemLocaleLongDate**  shall
        be removed in Qt 6. Their use should be replaced with
        **QLocale::system().toString(datetime, QLocale::ShortFormat)**  or
        **QLocale::system().toString(datetime, QLocale::LongFormat)** .

        The **format** options **Qt::LocaleDate** ,
        **Qt::DefaultLocaleShortDate**  and **Qt::DefaultLocaleLongDate**  shall
        be removed in Qt 6. Their use should be replaced with
        **QLocale().toString(datetime, QLocale::ShortFormat)**  or
        **QLocale().toString(datetime, QLocale::LongFormat)** .

        If the **format** is **Qt::RFC2822Date** , the string is formatted
        following **RFC 2822** .

        If the datetime is invalid, an empty string will be returned.

        **Warning:** The **Qt::ISODate**  format is only valid for years in the
        range 0 to 9999.

        **See also** **fromString** (), **QDate::toString** (),
        **QTime::toString** (), and **QLocale::toString** ().
        """
        ...

    @typing.overload
    def toString(self, format: str) -> str:
        """
        https://doc.qt.io/qt-5/qdatetime.html#toString-1

        **QString QDateTime::toString(Qt::DateFormat format = Qt::TextDate)
        const**

        This is an overloaded function.

        Returns the datetime as a string in the **format** given.

        If the **format** is **Qt::TextDate** , the string is formatted in the
        default way. The day and month names will be localized names using the
        system locale, i.e. **QLocale::system** (). An example of this
        formatting is "Wed May 20 03:40:13 1998".

        If the **format** is **Qt::ISODate** , the string format corresponds to
        the ISO 8601 extended specification for representations of dates and
        times, taking the form yyyy-MM-ddTHH:mm:ss[Z|[+|-]HH:mm], depending on
        the **timeSpec** () of the **QDateTime** . If the **timeSpec** () is
        **Qt::UTC** , Z will be appended to the string; if the **timeSpec** ()
        is **Qt::OffsetFromUTC** , the offset in hours and minutes from UTC will
        be appended to the string. To include milliseconds in the ISO 8601 date,
        use the **format** **Qt::ISODateWithMs** , which corresponds to yyyy-MM-
        ddTHH:mm:ss.zzz[Z|[+|-]HH:mm].

        The **format** options **Qt::SystemLocaleDate** ,
        **Qt::SystemLocaleShortDate**  and **Qt::SystemLocaleLongDate**  shall
        be removed in Qt 6. Their use should be replaced with
        **QLocale::system().toString(datetime, QLocale::ShortFormat)**  or
        **QLocale::system().toString(datetime, QLocale::LongFormat)** .

        The **format** options **Qt::LocaleDate** ,
        **Qt::DefaultLocaleShortDate**  and **Qt::DefaultLocaleLongDate**  shall
        be removed in Qt 6. Their use should be replaced with
        **QLocale().toString(datetime, QLocale::ShortFormat)**  or
        **QLocale().toString(datetime, QLocale::LongFormat)** .

        If the **format** is **Qt::RFC2822Date** , the string is formatted
        following **RFC 2822** .

        If the datetime is invalid, an empty string will be returned.

        **Warning:** The **Qt::ISODate**  format is only valid for years in the
        range 0 to 9999.

        **See also** **fromString** (), **QDate::toString** (),
        **QTime::toString** (), and **QLocale::toString** ().
        """
        ...

    @typing.overload
    def toString(self, format: str, cal: QCalendar) -> str:
        """
        https://doc.qt.io/qt-5/qdatetime.html#toString-1

        **QString QDateTime::toString(Qt::DateFormat format = Qt::TextDate)
        const**

        This is an overloaded function.

        Returns the datetime as a string in the **format** given.

        If the **format** is **Qt::TextDate** , the string is formatted in the
        default way. The day and month names will be localized names using the
        system locale, i.e. **QLocale::system** (). An example of this
        formatting is "Wed May 20 03:40:13 1998".

        If the **format** is **Qt::ISODate** , the string format corresponds to
        the ISO 8601 extended specification for representations of dates and
        times, taking the form yyyy-MM-ddTHH:mm:ss[Z|[+|-]HH:mm], depending on
        the **timeSpec** () of the **QDateTime** . If the **timeSpec** () is
        **Qt::UTC** , Z will be appended to the string; if the **timeSpec** ()
        is **Qt::OffsetFromUTC** , the offset in hours and minutes from UTC will
        be appended to the string. To include milliseconds in the ISO 8601 date,
        use the **format** **Qt::ISODateWithMs** , which corresponds to yyyy-MM-
        ddTHH:mm:ss.zzz[Z|[+|-]HH:mm].

        The **format** options **Qt::SystemLocaleDate** ,
        **Qt::SystemLocaleShortDate**  and **Qt::SystemLocaleLongDate**  shall
        be removed in Qt 6. Their use should be replaced with
        **QLocale::system().toString(datetime, QLocale::ShortFormat)**  or
        **QLocale::system().toString(datetime, QLocale::LongFormat)** .

        The **format** options **Qt::LocaleDate** ,
        **Qt::DefaultLocaleShortDate**  and **Qt::DefaultLocaleLongDate**  shall
        be removed in Qt 6. Their use should be replaced with
        **QLocale().toString(datetime, QLocale::ShortFormat)**  or
        **QLocale().toString(datetime, QLocale::LongFormat)** .

        If the **format** is **Qt::RFC2822Date** , the string is formatted
        following **RFC 2822** .

        If the datetime is invalid, an empty string will be returned.

        **Warning:** The **Qt::ISODate**  format is only valid for years in the
        range 0 to 9999.

        **See also** **fromString** (), **QDate::toString** (),
        **QTime::toString** (), and **QLocale::toString** ().
        """
        ...

    def setTime_t(self, secsSince1Jan1970UTC: int) -> None:
        ...

    def setTimeSpec(self, spec: Qt.TimeSpec) -> None:
        """
        https://doc.qt.io/qt-5/qdatetime.html#setTimeSpec

        **void QDateTime::setTimeSpec(Qt::TimeSpec spec )**

        Sets the time specification used in this datetime to **spec**. The
        datetime will refer to a different point in time.

        If **spec** is **Qt::OffsetFromUTC**  then the **timeSpec** () will be
        set to **Qt::UTC** , i.e. an effective offset of 0.

        If **spec** is **Qt::TimeZone**  then the spec will be set to
        **Qt::LocalTime** , i.e. the current system time zone.

        Example:

        **QDateTime**  local(**QDateTime** ::currentDateTime());
            **qDebug**
        () << "Local time is:" << local;

            **QDateTime**  UTC(local);
        UTC.setTimeSpec(Qt::UTC);
            **qDebug** () << "UTC time is:" << UTC;
        **qDebug** () << "There are" << local.secsTo(UTC) << "seconds difference
        between the datetimes.";

        **See also** **timeSpec** (), **setDate** (), **setTime** (),
        **setTimeZone** (), and **Qt::TimeSpec** .
        """
        ...

    def setTime(self, time: typing.Union[QTime, datetime.time]) -> None:
        """
        https://doc.qt.io/qt-5/qdatetime.html#setTime

        **void QDateTime::setTime(const QTime & time )**

        Sets the time part of this datetime to **time**. If **time** is not
        valid, this function sets it to midnight. Therefore, it's possible to
        clear any set time in a **QDateTime**  by setting it to a default
        **QTime** :

        **QDateTime**  dt = **QDateTime** ::currentDateTime();
        dt.setTime(**QTime** ());

        **See also** **time** (), **setDate** (), and **setTimeSpec** ().
        """
        ...

    def setDate(self, date: typing.Union[QDate, datetime.date]) -> None:
        """
        https://doc.qt.io/qt-5/qdatetime.html#setDate

        **void QDateTime::setDate(const QDate & date )**

        Sets the date part of this datetime to **date**. If no time is set yet,
        it is set to midnight. If **date** is invalid, this **QDateTime**
        becomes invalid.

        **See also** **date** (), **setTime** (), and **setTimeSpec** ().
        """
        ...

    def toTime_t(self) -> int:
        ...

    def timeSpec(self) -> Qt.TimeSpec:
        """
        https://doc.qt.io/qt-5/qdatetime.html#timeSpec

        **Qt::TimeSpec QDateTime::timeSpec() const**

        Returns the time specification of the datetime.

        **See also** **setTimeSpec** (), **date** (), **time** (), and
        **Qt::TimeSpec** .
        """
        ...

    def time(self) -> QTime:
        """
        https://doc.qt.io/qt-5/qdatetime.html#time

        **QTime QDateTime::time() const**

        Returns the time part of the datetime.

        **See also** **setTime** (), **date** (), and **timeSpec** ().
        """
        ...

    def date(self) -> QDate:
        """
        https://doc.qt.io/qt-5/qdatetime.html#date

        **QDate QDateTime::date() const**

        Returns the date part of the datetime.

        **See also** **setDate** (), **time** (), and **timeSpec** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdatetime.html#isValid

        **bool QDateTime::isValid() const**

        Returns `true` if both the date and the time are valid and they are
        valid in the current **Qt::TimeSpec** , otherwise returns `false`.

        If the **timeSpec** () is **Qt::LocalTime**  or **Qt::TimeZone**  then
        the date and time are checked to see if they fall in the Standard Time
        to Daylight-Saving Time transition hour, i.e. if the transition is at
        2am and the clock goes forward to 3am then the time from 02:00:00 to
        02:59:59.999 is considered to be invalid.

        **See also** **QDateTime::YearRange** , **QDate::isValid** (), and
        **QTime::isValid** ().
        """
        ...

    def __bool__(self) -> int:
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdatetime.html#isNull

        **bool QDateTime::isNull() const**

        Returns `true` if both the date and the time are null; otherwise returns
        `false`. A null datetime is invalid.

        **See also** **QDate::isNull** (), **QTime::isNull** (), and **isValid**
        ().
        """
        ...

    def toPyDateTime(self) -> datetime.datetime:
        ...

    def __hash__(self) -> int:
        ...

    def __repr__(self) -> str:
        ...
