"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import datetime
from PyQt5.QtCore import *
from PyQt5 import sip


class QDate(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qdate.html

    **Detailed Description**

    A QDate object represents a particular day, regardless of calendar, locale
    or other settings used when creating it or supplied by the system. It can
    report the year, month and day of the month that represent the day with
    respect to the proleptic Gregorian calendar or any calendar supplied as a
    **QCalendar**  object.

    A QDate object is typically created by giving the year, month, and day
    numbers explicitly. Note that QDate interprets year numbers less than 100 as
    presented, i.e., as years 1 through 99, without adding any offset. The
    static function **currentDate** () creates a QDate object containing the
    date read from the system clock. An explicit date can also be set using
    **setDate** (). The **fromString** () function returns a QDate given a
    string and a date format which is used to interpret the date within the
    string.

    The **year** (), **month** (), and **day** () functions provide access to
    the year, month, and day numbers. When more than one of these values is
    needed, it is more efficient to call **QCalendar::partsFromDate** (), to
    save repeating (potentially expensive) calendrical calculations.

    Also, **dayOfWeek** () and **dayOfYear** () functions are provided. The same
    information is provided in textual format by **toString** (). **QLocale**
    can map the day numbers to names, **QCalendar**  can map month numbers to
    names.

    QDate provides a full set of operators to compare two QDate objects where
    smaller means earlier, and larger means later.

    You can increment (or decrement) a date by a given number of days using
    **addDays** (). Similarly you can use **addMonths** () and **addYears** ().
    The **daysTo** () function returns the number of days between two dates.

    The **daysInMonth** () and **daysInYear** () functions return how many days
    there are in this date's month and year, respectively. The **isLeapYear** ()
    function indicates whether a date is in a leap year. **QCalendar**  can also
    supply this information, in some cases more conveniently.

    **Remarks**

    **No Year 0**

    In the Gregorian calendar, there is no year 0. Dates in that year are
    considered invalid. The year -1 is the year "1 before Christ" or "1 before
    common era." The day before 1 January 1 CE, QDate(1, 1, 1), is 31 December 1
    BCE, QDate(-1, 12, 31). Various other calendars behave similarly; see
    **QCalendar::hasYearZero** ().

    **Range of Valid Dates**

    Dates are stored internally as a Julian Day number, an integer count of
    every day in a contiguous range, with 24 November 4714 BCE in the Gregorian
    calendar being Julian Day 0 (1 January 4713 BCE in the Julian calendar). As
    well as being an efficient and accurate way of storing an absolute date, it
    is suitable for converting a date into other calendar systems such as
    Hebrew, Islamic or Chinese. The Julian Day number can be obtained using
    **QDate::toJulianDay** () and can be set using **QDate::fromJulianDay** ().

    The range of Julian Day numbers that QDate can represent is, for technical
    reasons, limited to between -784350574879 and 784354017364, which means from
    before 2 billion BCE to after 2 billion CE. This is more than seven times as
    wide as the range of dates a **QDateTime**  can represent.

    **See also** **QTime** , **QDateTime** , **QCalendar** ,
    **QDateTime::YearRange** , **QDateEdit** , **QDateTimeEdit** , and
    **QCalendarWidget** .
    """

    class MonthNameType(int):
        DateFormat: QDate = ...
        StandaloneFormat: QDate = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qdate.html#QDate-1

        **QDate::QDate()**

        Constructs a null date. Null dates are invalid.

        **See also** **isNull** () and **isValid** ().
        """
        ...

    @typing.overload
    def __init__(self, y: int, m: int, d: int) -> None:
        """
        https://doc.qt.io/qt-5/qdate.html#QDate-2

        **QDate::QDate(int y , int m , int d )**

        Constructs a date with year **y** , month **m** and day **d**.

        The date is understood in terms of the Gregorian calendar. If the
        specified date is invalid, the date is not set and **isValid** ()
        returns `false`.

        **Warning:** Years 1 to 99 are interpreted as is. Year 0 is invalid.

        **See also** **isValid** () and **QCalendar::dateFromParts** ().
        """
        ...

    @typing.overload
    def __init__(self, y: int, m: int, d: int, cal: QCalendar) -> None:
        """
        https://doc.qt.io/qt-5/qdate.html#QDate-1

        **QDate::QDate()**

        Constructs a null date. Null dates are invalid.

        **See also** **isNull** () and **isValid** ().
        """
        ...

    @typing.overload
    def __init__(self, a0: "QDate") -> None:
        """
        https://doc.qt.io/qt-5/qdate.html#QDate-1

        **QDate::QDate()**

        Constructs a null date. Null dates are invalid.

        **See also** **isNull** () and **isValid** ().
        """
        ...

    @typing.overload
    def endOfDay(
        self, spec: Qt.TimeSpec = ..., offsetSeconds: int = ...
    ) -> "QDateTime":
        ...

    @typing.overload
    def endOfDay(self, zone: "QTimeZone") -> "QDateTime":
        ...

    @typing.overload
    def startOfDay(
        self, spec: Qt.TimeSpec = ..., offsetSeconds: int = ...
    ) -> "QDateTime":
        ...

    @typing.overload
    def startOfDay(self, zone: "QTimeZone") -> "QDateTime":
        ...

    def getDate(self) -> typing.Tuple[int, int, int]:
        """
        https://doc.qt.io/qt-5/qdate.html#getDate

        **void QDate::getDate(int * year , int * month , int * day ) const**

        Extracts the date's year, month, and day, and assigns them to * **year**
        , * **month** , and * **day**. The pointers may be null.

        Returns 0 if the date is invalid.

        **Note:** In Qt versions prior to 5.7, this function is marked as
        non-`const`.

        This function was introduced in Qt 4.5.

        **See also** **year** (), **month** (), **day** (), **isValid** (), and
        **QCalendar::partsFromDate** ().
        """
        ...

    @typing.overload
    def setDate(self, year: int, month: int, date: int) -> bool:
        """
        https://doc.qt.io/qt-5/qdate.html#setDate

        **bool QDate::setDate(int year , int month , int day )**

        Sets this to represent the date, in the Gregorian calendar, with the
        given **year** , **month** and **day** numbers. Returns true if the
        resulting date is valid, otherwise it sets this to represent an invalid
        date and returns false.

        This function was introduced in Qt 4.2.

        **See also** **isValid** () and **QCalendar::dateFromParts** ().
        """
        ...

    @typing.overload
    def setDate(self, year: int, month: int, day: int, cal: QCalendar) -> bool:
        """
        https://doc.qt.io/qt-5/qdate.html#setDate-1

        **bool QDate::setDate(int year , int month , int day , QCalendar cal )**

        Sets this to represent the date, in the given calendar **cal** , with
        the given **year** , **month** and **day** numbers. Returns true if the
        resulting date is valid, otherwise it sets this to represent an invalid
        date and returns false.

        This function was introduced in Qt 5.14.

        **See also** **isValid** () and **QCalendar::dateFromParts** ().
        """
        ...

    def toJulianDay(self) -> int:
        """
        https://doc.qt.io/qt-5/qdate.html#toJulianDay

        **qint64 QDate::toJulianDay() const**

        Converts the date to a Julian day.

        **See also** **fromJulianDay** ().
        """
        ...

    @staticmethod
    def fromJulianDay(jd: int) -> "QDate":
        """
        https://doc.qt.io/qt-5/qdate.html#fromJulianDay

        **[static] QDate QDate::fromJulianDay(qint64 jd )**

        Converts the Julian day **jd** to a **QDate** .

        **See also** **toJulianDay** ().
        """
        ...

    @staticmethod
    def isLeapYear(year: int) -> bool:
        """
        https://doc.qt.io/qt-5/qdate.html#isLeapYear

        **[static] bool QDate::isLeapYear(int year )**

        Returns `true` if the specified **year** is a leap year in the Gregorian
        calendar; otherwise returns `false`.

        **See also** **QCalendar::isLeapYear** ().
        """
        ...

    @typing.overload
    @staticmethod
    def fromString(string: str, format: Qt.DateFormat = ...) -> "QDate":
        """
        https://doc.qt.io/qt-5/qdate.html#fromString

        **[static] QDate QDate::fromString(const QString & string ,
        Qt::DateFormat format = Qt::TextDate)**

        Returns the **QDate**  represented by the **string** , using the
        **format** given, or an invalid date if the string cannot be parsed.

        Note for **Qt::TextDate** : It is recommended that you use the English
        short month names (e.g. "Jan"). Although localized month names can also
        be used in Qt 5, they depend on the user's locale settings.

        **Note:** Support for localized dates, including the format options
        **Qt::SystemLocaleDate** , **Qt::SystemLocaleShortDate** ,
        **Qt::SystemLocaleLongDate** , **Qt::LocaleDate** ,
        **Qt::DefaultLocaleShortDate** , and **Qt::DefaultLocaleLongDate** ,
        shall be removed in Qt 6. Use **QLocale::toDate** () instead.

        **See also** **toString** () and **QLocale::toDate** ().
        """
        ...

    @typing.overload
    @staticmethod
    def fromString(s: str, format: str) -> "QDate":
        """
        https://doc.qt.io/qt-5/qdate.html#fromString-1

        **[static] QDate QDate::fromString(const QString & string , const
        QString & format )**

        This is an overloaded function.
        """
        ...

    @typing.overload
    @staticmethod
    def fromString(s: str, format: str, cal: QCalendar) -> "QDate":
        """
        https://doc.qt.io/qt-5/qdate.html#fromString-2

        **[static] QDate QDate::fromString(const QString & string , const
        QString & format , QCalendar cal )**

        Returns the **QDate**  represented by the **string** , using the
        **format** given, or an invalid date if the string cannot be parsed.

        Uses **cal** as calendar if supplied, else the Gregorian calendar.
        Ranges of values in the format descriptions below are for the latter;
        they may be different for other calendars.

        These expressions may be used for the format:

        ExpressionOutput
        dThe day as a number without a leading zero (1 to 31)
        ddThe day as a number with a leading zero (01 to 31)
        dddThe
        abbreviated localized day name (e.g. 'Mon' to 'Sun'). Uses the system
        locale to localize the name, i.e. **QLocale::system** ().
        ddddThe long
        localized day name (e.g. 'Monday' to 'Sunday'). Uses the system locale
        to localize the name, i.e. **QLocale::system** ().
        MThe month as a
        number without a leading zero (1 to 12)
        MMThe month as a number with a
        leading zero (01 to 12)
        MMMThe abbreviated localized month name (e.g.
        'Jan' to 'Dec'). Uses the system locale to localize the name, i.e.
        **QLocale::system** ().
        MMMMThe long localized month name (e.g.
        'January' to 'December'). Uses the system locale to localize the name,
        i.e. **QLocale::system** ().
        yyThe year as a two digit number (00 to
        99)
        yyyyThe year as a four digit number, possibly plus a leading minus
        sign for negative years.

        **Note:** Unlike the other version of this function, day and month names
        must be given in the user's local language. It is only possible to use
        the English names if the user's language is English.

        All other input characters will be treated as text. Any non-empty
        sequence of characters enclosed in single quotes will also be treated
        (stripped of the quotes) as text and not be interpreted as expressions.
        For example:

        QDate date = QDate::fromString("1MM12car2003", "d'MM'MMcaryyyy");
            //
        date is 1 December 2003

        If the format is not satisfied, an invalid **QDate**  is returned. The
        expressions that don't expect leading zeroes (d, M) will be greedy. This
        means that they will use two digits even if this will put them outside
        the accepted range of values and leaves too few digits for other
        sections. For example, the following format string could have meant
        January 30 but the M will grab two digits, resulting in an invalid date:

        QDate date = QDate::fromString("130", "Md"); // invalid

        For any field that is not represented in the format the following
        defaults are used:

        FieldDefault value
        Year1900
        Month1
        Day1

        The following examples demonstrate the default values:

        QDate::fromString("1.30", "M.d");           // January 30 1900
        QDate::fromString("20000110", "yyyyMMdd");  // January 10, 2000
        QDate::fromString("20000110", "yyyyMd");    // January 10, 2000

        **Note:** If localized month and day names are used, please switch to
        using **QLocale::system** ().toDate() as **QDate**  methods shall change
        to only recognize English (C locale) names at Qt 6.

        **See also** **toString** (), **QDateTime::fromString** (),
        **QTime::fromString** (), and **QLocale::toDate** ().
        """
        ...

    @staticmethod
    def currentDate() -> "QDate":
        """
        https://doc.qt.io/qt-5/qdate.html#currentDate

        **[static] QDate QDate::currentDate()**

        Returns the current date, as reported by the system clock.

        **See also** **QTime::currentTime** () and
        **QDateTime::currentDateTime** ().
        """
        ...

    def daysTo(self, a0: typing.Union["QDate", datetime.date]) -> int:
        """
        https://doc.qt.io/qt-5/qdate.html#daysTo

        **qint64 QDate::daysTo(const QDate & d ) const**

        Returns the number of days from this date to **d** (which is negative if
        **d** is earlier than this date).

        Returns 0 if either date is invalid.

        Example:

        QDate d1(1995, 5, 17);  // May 17, 1995
            QDate d2(1995, 5, 20);  //
        May 20, 1995
            d1.daysTo(d2);          // returns 3
            d2.daysTo(d1);
        // returns -3

        **See also** **addDays** ().
        """
        ...

    @typing.overload
    def addYears(self, years: int) -> "QDate":
        """
        https://doc.qt.io/qt-5/qdate.html#addYears

        **QDate QDate::addYears(int nyears , QCalendar cal ) const**

        Returns a **QDate**  object containing a date **nyears** later than the
        date of this object (or earlier if **nyears** is negative).

        Uses **cal** as calendar, if supplied, else the Gregorian calendar.

        **Note:** If the ending day/month combination does not exist in the
        resulting year (e.g., for the Gregorian calendar, if the date was Feb 29
        and the final year is not a leap year), this function will return a date
        that is the latest valid date in the given month (in the example, Feb
        28).

        **See also** **addDays** () and **addMonths** ().
        """
        ...

    @typing.overload
    def addYears(self, years: int, cal: QCalendar) -> "QDate":
        """
        https://doc.qt.io/qt-5/qdate.html#addYears-1

        **QDate QDate::addYears(int nyears ) const**

        This is an overloaded function.
        """
        ...

    @typing.overload
    def addMonths(self, months: int) -> "QDate":
        """
        https://doc.qt.io/qt-5/qdate.html#addMonths

        **QDate QDate::addMonths(int nmonths , QCalendar cal ) const**

        Returns a **QDate**  object containing a date **nmonths** later than the
        date of this object (or earlier if **nmonths** is negative).

        Uses **cal** as calendar, if supplied, else the Gregorian calendar.

        **Note:** If the ending day/month combination does not exist in the
        resulting month/year, this function will return a date that is the
        latest valid date in the selected month.

        **See also** **addDays** () and **addYears** ().
        """
        ...

    @typing.overload
    def addMonths(self, months: int, cal: QCalendar) -> "QDate":
        """
        https://doc.qt.io/qt-5/qdate.html#addMonths-1

        **QDate QDate::addMonths(int nmonths ) const**

        This is an overloaded function.
        """
        ...

    def addDays(self, days: int) -> "QDate":
        """
        https://doc.qt.io/qt-5/qdate.html#addDays

        **QDate QDate::addDays(qint64 ndays ) const**

        Returns a **QDate**  object containing a date **ndays** later than the
        date of this object (or earlier if **ndays** is negative).

        Returns a null date if the current date is invalid or the new date is
        out of range.

        **See also** **addMonths** (), **addYears** (), and **daysTo** ().
        """
        ...

    @typing.overload
    def toString(self, format: Qt.DateFormat = ...) -> str:
        """
        https://doc.qt.io/qt-5/qdate.html#toString-1

        **QString QDate::toString(Qt::DateFormat format = Qt::TextDate) const**

        This is an overloaded function.

        Returns the date as a string. The **format** parameter determines the
        format of the string.

        If the **format** is **Qt::TextDate** , the string is formatted in the
        default way. The day and month names will be localized names using the
        system locale, i.e. **QLocale::system** (). An example of this
        formatting is "Sat May 20 1995".

        If the **format** is **Qt::ISODate** , the string format corresponds to
        the ISO 8601 extended specification for representations of dates and
        times, taking the form yyyy-MM-dd, where yyyy is the year, MM is the
        month of the year (between 01 and 12), and dd is the day of the month
        between 01 and 31.

        The **format** options **Qt::SystemLocaleDate** ,
        **Qt::SystemLocaleShortDate**  and **Qt::SystemLocaleLongDate**  shall
        be removed in Qt 6. Their use should be replaced with
        **QLocale::system().toString(date, QLocale::ShortFormat)**  or
        **QLocale::system().toString(date, QLocale::LongFormat)** .

        The **format** options **Qt::LocaleDate** ,
        **Qt::DefaultLocaleShortDate**  and **Qt::DefaultLocaleLongDate**  shall
        be removed in Qt 6. Their use should be replaced with
        **QLocale().toString(date, QLocale::ShortFormat)**  or
        **QLocale().toString(date, QLocale::LongFormat)** .

        If the **format** is **Qt::RFC2822Date** , the string is formatted in an
        **RFC 2822**  compatible way. An example of this formatting is "20 May
        1995".

        If the date is invalid, an empty string will be returned.

        **Warning:** The **Qt::ISODate**  format is only valid for years in the
        range 0 to 9999.

        **See also** **fromString** () and **QLocale::toString** ().
        """
        ...

    @typing.overload
    def toString(self, f: Qt.DateFormat, cal: QCalendar) -> str:
        """
        https://doc.qt.io/qt-5/qdate.html#toString-1

        **QString QDate::toString(Qt::DateFormat format = Qt::TextDate) const**

        This is an overloaded function.

        Returns the date as a string. The **format** parameter determines the
        format of the string.

        If the **format** is **Qt::TextDate** , the string is formatted in the
        default way. The day and month names will be localized names using the
        system locale, i.e. **QLocale::system** (). An example of this
        formatting is "Sat May 20 1995".

        If the **format** is **Qt::ISODate** , the string format corresponds to
        the ISO 8601 extended specification for representations of dates and
        times, taking the form yyyy-MM-dd, where yyyy is the year, MM is the
        month of the year (between 01 and 12), and dd is the day of the month
        between 01 and 31.

        The **format** options **Qt::SystemLocaleDate** ,
        **Qt::SystemLocaleShortDate**  and **Qt::SystemLocaleLongDate**  shall
        be removed in Qt 6. Their use should be replaced with
        **QLocale::system().toString(date, QLocale::ShortFormat)**  or
        **QLocale::system().toString(date, QLocale::LongFormat)** .

        The **format** options **Qt::LocaleDate** ,
        **Qt::DefaultLocaleShortDate**  and **Qt::DefaultLocaleLongDate**  shall
        be removed in Qt 6. Their use should be replaced with
        **QLocale().toString(date, QLocale::ShortFormat)**  or
        **QLocale().toString(date, QLocale::LongFormat)** .

        If the **format** is **Qt::RFC2822Date** , the string is formatted in an
        **RFC 2822**  compatible way. An example of this formatting is "20 May
        1995".

        If the date is invalid, an empty string will be returned.

        **Warning:** The **Qt::ISODate**  format is only valid for years in the
        range 0 to 9999.

        **See also** **fromString** () and **QLocale::toString** ().
        """
        ...

    @typing.overload
    def toString(self, format: str) -> str:
        """
        https://doc.qt.io/qt-5/qdate.html#toString-1

        **QString QDate::toString(Qt::DateFormat format = Qt::TextDate) const**

        This is an overloaded function.

        Returns the date as a string. The **format** parameter determines the
        format of the string.

        If the **format** is **Qt::TextDate** , the string is formatted in the
        default way. The day and month names will be localized names using the
        system locale, i.e. **QLocale::system** (). An example of this
        formatting is "Sat May 20 1995".

        If the **format** is **Qt::ISODate** , the string format corresponds to
        the ISO 8601 extended specification for representations of dates and
        times, taking the form yyyy-MM-dd, where yyyy is the year, MM is the
        month of the year (between 01 and 12), and dd is the day of the month
        between 01 and 31.

        The **format** options **Qt::SystemLocaleDate** ,
        **Qt::SystemLocaleShortDate**  and **Qt::SystemLocaleLongDate**  shall
        be removed in Qt 6. Their use should be replaced with
        **QLocale::system().toString(date, QLocale::ShortFormat)**  or
        **QLocale::system().toString(date, QLocale::LongFormat)** .

        The **format** options **Qt::LocaleDate** ,
        **Qt::DefaultLocaleShortDate**  and **Qt::DefaultLocaleLongDate**  shall
        be removed in Qt 6. Their use should be replaced with
        **QLocale().toString(date, QLocale::ShortFormat)**  or
        **QLocale().toString(date, QLocale::LongFormat)** .

        If the **format** is **Qt::RFC2822Date** , the string is formatted in an
        **RFC 2822**  compatible way. An example of this formatting is "20 May
        1995".

        If the date is invalid, an empty string will be returned.

        **Warning:** The **Qt::ISODate**  format is only valid for years in the
        range 0 to 9999.

        **See also** **fromString** () and **QLocale::toString** ().
        """
        ...

    @typing.overload
    def toString(self, format: str, cal: QCalendar) -> str:
        """
        https://doc.qt.io/qt-5/qdate.html#toString-1

        **QString QDate::toString(Qt::DateFormat format = Qt::TextDate) const**

        This is an overloaded function.

        Returns the date as a string. The **format** parameter determines the
        format of the string.

        If the **format** is **Qt::TextDate** , the string is formatted in the
        default way. The day and month names will be localized names using the
        system locale, i.e. **QLocale::system** (). An example of this
        formatting is "Sat May 20 1995".

        If the **format** is **Qt::ISODate** , the string format corresponds to
        the ISO 8601 extended specification for representations of dates and
        times, taking the form yyyy-MM-dd, where yyyy is the year, MM is the
        month of the year (between 01 and 12), and dd is the day of the month
        between 01 and 31.

        The **format** options **Qt::SystemLocaleDate** ,
        **Qt::SystemLocaleShortDate**  and **Qt::SystemLocaleLongDate**  shall
        be removed in Qt 6. Their use should be replaced with
        **QLocale::system().toString(date, QLocale::ShortFormat)**  or
        **QLocale::system().toString(date, QLocale::LongFormat)** .

        The **format** options **Qt::LocaleDate** ,
        **Qt::DefaultLocaleShortDate**  and **Qt::DefaultLocaleLongDate**  shall
        be removed in Qt 6. Their use should be replaced with
        **QLocale().toString(date, QLocale::ShortFormat)**  or
        **QLocale().toString(date, QLocale::LongFormat)** .

        If the **format** is **Qt::RFC2822Date** , the string is formatted in an
        **RFC 2822**  compatible way. An example of this formatting is "20 May
        1995".

        If the date is invalid, an empty string will be returned.

        **Warning:** The **Qt::ISODate**  format is only valid for years in the
        range 0 to 9999.

        **See also** **fromString** () and **QLocale::toString** ().
        """
        ...

    @staticmethod
    def longDayName(weekday: int, type: "QDate.MonthNameType" = ...) -> str:
        ...

    @staticmethod
    def longMonthName(month: int, type: "QDate.MonthNameType" = ...) -> str:
        ...

    @staticmethod
    def shortDayName(weekday: int, type: "QDate.MonthNameType" = ...) -> str:
        ...

    @staticmethod
    def shortMonthName(month: int, type: "QDate.MonthNameType" = ...) -> str:
        ...

    def weekNumber(self) -> typing.Tuple[int, int]:
        """
        https://doc.qt.io/qt-5/qdate.html#weekNumber

        **int QDate::weekNumber(int * yearNumber = nullptr) const**

        Returns the ISO 8601 week number (1 to 53).

        Returns 0 if the date is invalid. Otherwise, returns the week number for
        the date. If **yearNumber** is not `nullptr` (its default), stores the
        year as * **yearNumber**.

        In accordance with ISO 8601, each week falls in the year to which most
        of its days belong, in the Gregorian calendar. As ISO 8601's week starts
        on Monday, this is the year in which the week's Thursday falls. Most
        years have 52 weeks, but some have 53.

        **Note:** * **yearNumber** is not always the same as **year** (). For
        example, 1 January 2000 has week number 52 in the year 1999, and 31
        December 2002 has week number 1 in the year 2003.

        **See also** **isValid** ().
        """
        ...

    @typing.overload
    def daysInYear(self) -> int:
        """
        https://doc.qt.io/qt-5/qdate.html#daysInYear

        **int QDate::daysInYear(QCalendar cal ) const**

        Returns the number of days in the year for this date.

        Uses **cal** as calendar if supplied, else the Gregorian calendar (for
        which the result is 365 or 366). Returns 0 if the date is invalid.

        **See also** **day** (), **daysInMonth** (), **QCalendar::daysInYear**
        (), and **QCalendar::maximumMonthsInYear** ().
        """
        ...

    @typing.overload
    def daysInYear(self, cal: QCalendar) -> int:
        """
        https://doc.qt.io/qt-5/qdate.html#daysInYear-1

        **int QDate::daysInYear() const**

        This is an overloaded function.
        """
        ...

    @typing.overload
    def daysInMonth(self) -> int:
        """
        https://doc.qt.io/qt-5/qdate.html#daysInMonth

        **int QDate::daysInMonth(QCalendar cal ) const**

        Returns the number of days in the month for this date.

        Uses **cal** as calendar if supplied, else the Gregorian calendar (for
        which the result ranges from 28 to 31). Returns 0 if the date is
        invalid.

        **See also** **day** (), **daysInYear** (), **QCalendar::daysInMonth**
        (), **QCalendar::maximumDaysInMonth** (), and
        **QCalendar::minimumDaysInMonth** ().
        """
        ...

    @typing.overload
    def daysInMonth(self, cal: QCalendar) -> int:
        """
        https://doc.qt.io/qt-5/qdate.html#daysInMonth-1

        **int QDate::daysInMonth() const**

        This is an overloaded function.
        """
        ...

    @typing.overload
    def dayOfYear(self) -> int:
        """
        https://doc.qt.io/qt-5/qdate.html#dayOfYear

        **int QDate::dayOfYear(QCalendar cal ) const**

        Returns the day of the year (1 for the first day) for this date.

        Uses **cal** as calendar if supplied, else the Gregorian calendar.
        Returns 0 if either the date or the first day of its year is invalid.

        **See also** **day** (), **dayOfWeek** (), and **QCalendar::daysInYear**
        ().
        """
        ...

    @typing.overload
    def dayOfYear(self, cal: QCalendar) -> int:
        """
        https://doc.qt.io/qt-5/qdate.html#dayOfYear-1

        **int QDate::dayOfYear() const**

        This is an overloaded function.
        """
        ...

    @typing.overload
    def dayOfWeek(self) -> int:
        """
        https://doc.qt.io/qt-5/qdate.html#dayOfWeek

        **int QDate::dayOfWeek(QCalendar cal ) const**

        Returns the weekday (1 = Monday to 7 = Sunday) for this date.

        Uses **cal** as calendar if supplied, else the Gregorian calendar.
        Returns 0 if the date is invalid. Some calendars may give special
        meaning (e.g. intercallary days) to values greater than 7.

        **See also** **day** (), **dayOfYear** (), **QCalendar::dayOfWeek** (),
        and **Qt::DayOfWeek** .
        """
        ...

    @typing.overload
    def dayOfWeek(self, cal: QCalendar) -> int:
        """
        https://doc.qt.io/qt-5/qdate.html#dayOfWeek-1

        **int QDate::dayOfWeek() const**

        This is an overloaded function.
        """
        ...

    @typing.overload
    def day(self) -> int:
        """
        https://doc.qt.io/qt-5/qdate.html#day

        **int QDate::day(QCalendar cal ) const**

        Returns the day of the month for this date.

        Uses **cal** as calendar if supplied, else the Gregorian calendar (for
        which the return ranges from 1 to 31). Returns 0 if the date is invalid.

        **See also** **year** (), **month** (), **dayOfWeek** (), and
        **QCalendar::partsFromDate** ().
        """
        ...

    @typing.overload
    def day(self, cal: QCalendar) -> int:
        """
        https://doc.qt.io/qt-5/qdate.html#day-1

        **int QDate::day() const**

        This is an overloaded function.
        """
        ...

    @typing.overload
    def month(self) -> int:
        """
        https://doc.qt.io/qt-5/qdate.html#month

        **int QDate::month(QCalendar cal ) const**

        Returns the month-number for the date.

        Numbers the months of the year starting with 1 for the first. Uses
        **cal** as calendar if supplied, else the Gregorian calendar, for which
        the month numbering is as follows:

        * 1 = "January"
          * 2 = "February"
          * 3 = "March"
          * 4 = "April"
          * 5
        = "May"
          * 6 = "June"
          * 7 = "July"
          * 8 = "August"
          * 9 =
        "September"
          * 10 = "October"
          * 11 = "November"
          * 12 = "December"

        Returns 0 if the date is invalid. Note that some calendars may have more
        than 12 months in some years.

        **See also** **year** (), **day** (), and **QCalendar::partsFromDate**
        ().
        """
        ...

    @typing.overload
    def month(self, cal: QCalendar) -> int:
        """
        https://doc.qt.io/qt-5/qdate.html#month-1

        **int QDate::month() const**

        This is an overloaded function.
        """
        ...

    @typing.overload
    def year(self) -> int:
        """
        https://doc.qt.io/qt-5/qdate.html#year

        **int QDate::year(QCalendar cal ) const**

        Returns the year of this date.

        Uses **cal** as calendar, if supplied, else the Gregorian calendar.

        Returns 0 if the date is invalid. For some calendars, dates before their
        first year may all be invalid.

        If using a calendar which has a year 0, check using **isValid** () if
        the return is 0. Such calendars use negative year numbers in the obvious
        way, with year 1 preceded by year 0, in turn preceded by year -1 and so
        on.

        Some calendars, despite having no year 0, have a conventional numbering
        of the years before their first year, counting backwards from 1. For
        example, in the proleptic Gregorian calendar, successive years before 1
        CE (the first year) are identified as 1 BCE, 2 BCE, 3 BCE and so on. For
        such calendars, negative year numbers are used to indicate these years
        before year 1, with -1 indicating the year before 1.

        **See also** **month** (), **day** (), **QCalendar::hasYearZero** (),
        **QCalendar::isProleptic** (), and **QCalendar::partsFromDate** ().
        """
        ...

    @typing.overload
    def year(self, cal: QCalendar) -> int:
        """
        https://doc.qt.io/qt-5/qdate.html#year-1

        **int QDate::year() const**

        This is an overloaded function.
        """
        ...

    @typing.overload
    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdate.html#isValid

        **bool QDate::isValid() const**

        Returns `true` if this date is valid; otherwise returns `false`.

        **See also** **isNull** () and **QCalendar::isDateValid** ().
        """
        ...

    @typing.overload
    @staticmethod
    def isValid(y: int, m: int, d: int) -> bool:
        """
        https://doc.qt.io/qt-5/qdate.html#isValid-1

        **[static] bool QDate::isValid(int year , int month , int day )**

        This is an overloaded function.

        Returns `true` if the specified date ( **year** , **month** , and
        **day** ) is valid in the Gregorian calendar; otherwise returns `false`.

        Example:

        QDate::isValid(2002, 5, 17);  // true
            QDate::isValid(2002, 2, 30);
        // false (Feb 30 does not exist)
            QDate::isValid(2004, 2, 29);  //
        true (2004 is a leap year)
            QDate::isValid(2000, 2, 29);  // true
        (2000 is a leap year)
            QDate::isValid(2006, 2, 29);  // false (2006
        is not a leap year)
            QDate::isValid(2100, 2, 29);  // false (2100 is
        not a leap year)
            QDate::isValid(1202, 6, 6);   // true (even though
        1202 is pre-Gregorian)

        **See also** **isNull** (), **setDate** (), and
        **QCalendar::isDateValid** ().
        """
        ...

    def __bool__(self) -> int:
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdate.html#isNull

        **bool QDate::isNull() const**

        Returns `true` if the date is null; otherwise returns `false`. A null
        date is invalid.

        **Note:** The behavior of this function is equivalent to **isValid** ().

        **See also** **isValid** ().
        """
        ...

    def toPyDate(self) -> datetime.date:
        ...

    def __hash__(self) -> int:
        ...

    def __repr__(self) -> str:
        ...
