"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QCryptographicHash(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qcryptographichash.html

    **Detailed Description**

    QCryptographicHash can be used to generate cryptographic hashes of binary or
    text data.

    Refer to the documentation of the **QCryptographicHash::Algorithm**  enum
    for a list of the supported algorithms.
    """

    class Algorithm(int):
        Md4: QCryptographicHash = ...
        Md5: QCryptographicHash = ...
        Sha1: QCryptographicHash = ...
        Sha224: QCryptographicHash = ...
        Sha256: QCryptographicHash = ...
        Sha384: QCryptographicHash = ...
        Sha512: QCryptographicHash = ...
        Sha3_224: QCryptographicHash = ...
        Sha3_256: QCryptographicHash = ...
        Sha3_384: QCryptographicHash = ...
        Sha3_512: QCryptographicHash = ...
        Keccak_224: QCryptographicHash = ...
        Keccak_256: QCryptographicHash = ...
        Keccak_384: QCryptographicHash = ...
        Keccak_512: QCryptographicHash = ...

    def __init__(self, method: "QCryptographicHash.Algorithm") -> None:
        """
        https://doc.qt.io/qt-5/qcryptographichash.html#QCryptographicHash

        **QCryptographicHash::QCryptographicHash(QCryptographicHash::Algorithm
        method )**

        Constructs an object that can be used to create a cryptographic hash
        from data using **method**.
        """
        ...

    @staticmethod
    def hashLength(method: "QCryptographicHash.Algorithm") -> int:
        """
        https://doc.qt.io/qt-5/qcryptographichash.html#hashLength

        **[static] int
        QCryptographicHash::hashLength(QCryptographicHash::Algorithm method )**

        Returns the size of the output of the selected hash **method** in bytes.

        This function was introduced in Qt 5.12.
        """
        ...

    @staticmethod
    def hash(
        data: typing.Union[QByteArray, bytes, bytearray],
        method: "QCryptographicHash.Algorithm",
    ) -> QByteArray:
        """
        https://doc.qt.io/qt-5/qcryptographichash.html#hash

        **[static] QByteArray QCryptographicHash::hash(const QByteArray & data ,
        QCryptographicHash::Algorithm method )**

        Returns the hash of **data** using **method**.
        """
        ...

    def result(self) -> QByteArray:
        """
        https://doc.qt.io/qt-5/qcryptographichash.html#result

        **QByteArray QCryptographicHash::result() const**

        Returns the final hash value.

        **See also** **QByteArray::toHex** ().
        """
        ...

    @typing.overload
    def addData(self, data: bytes) -> None:
        """
        https://doc.qt.io/qt-5/qcryptographichash.html#addData

        **void QCryptographicHash::addData(const char * data , int length )**

        Adds the first **length** chars of **data** to the cryptographic hash.
        """
        ...

    @typing.overload
    def addData(self, data: typing.Union[QByteArray, bytes, bytearray]) -> None:
        """
        https://doc.qt.io/qt-5/qcryptographichash.html#addData-1

        **void QCryptographicHash::addData(const QByteArray & data )**

        This function overloads addData().
        """
        ...

    @typing.overload
    def addData(self, device: QIODevice) -> bool:
        """
        https://doc.qt.io/qt-5/qcryptographichash.html#addData-2

        **bool QCryptographicHash::addData(QIODevice * device )**

        Reads the data from the open **QIODevice**  **device** until it ends and
        hashes it. Returns `true` if reading was successful.

        This function was introduced in Qt 5.0.
        """
        ...

    def reset(self) -> None:
        """
        https://doc.qt.io/qt-5/qcryptographichash.html#reset

        **void QCryptographicHash::reset()**

        Resets the object.
        """
        ...
