"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtCore import *


class QChildEvent(QEvent):
    """
    https://doc.qt.io/qt-5/qchildevent.html

    **Detailed Description**

    Child events are sent immediately to objects when children are added or
    removed.

    In both cases you can only rely on the child being a **QObject**  (or, if
    **QObject::isWidgetType** () returns `true`, a **QWidget** ). This is
    because in the **QEvent::ChildAdded**  case the child is not yet fully
    constructed; in the **QEvent::ChildRemoved**  case it might have already
    been destructed.

    The handler for these events is **QObject::childEvent** ().
    """

    @typing.overload
    def __init__(self, type: QEvent.Type, child: QObject) -> None:
        """
        https://doc.qt.io/qt-5/qchildevent.html#QChildEvent

        **QChildEvent::QChildEvent(QEvent::Type type , QObject * child )**

        Constructs a child event object of a particular **type** for the
        **child**.

        **type** can be **QEvent::ChildAdded** , **QEvent::ChildRemoved** , or
        **QEvent::ChildPolished** .

        **See also** **child** ().
        """
        ...

    @typing.overload
    def __init__(self, a0: "QChildEvent") -> None:
        """
        https://doc.qt.io/qt-5/qchildevent.html#QChildEvent

        **QChildEvent::QChildEvent(QEvent::Type type , QObject * child )**

        Constructs a child event object of a particular **type** for the
        **child**.

        **type** can be **QEvent::ChildAdded** , **QEvent::ChildRemoved** , or
        **QEvent::ChildPolished** .

        **See also** **child** ().
        """
        ...

    def removed(self) -> bool:
        """
        https://doc.qt.io/qt-5/qchildevent.html#removed

        **bool QChildEvent::removed() const**

        Returns `true` if **type** () is **QEvent::ChildRemoved** ; otherwise
        returns false.
        """
        ...

    def polished(self) -> bool:
        """
        https://doc.qt.io/qt-5/qchildevent.html#polished

        **bool QChildEvent::polished() const**

        Returns `true` if **type** () is **QEvent::ChildPolished** ; otherwise
        returns false.
        """
        ...

    def added(self) -> bool:
        """
        https://doc.qt.io/qt-5/qchildevent.html#added

        **bool QChildEvent::added() const**

        Returns `true` if **type** () is **QEvent::ChildAdded** ; otherwise
        returns false.
        """
        ...

    def child(self) -> QObject:
        """
        https://doc.qt.io/qt-5/qchildevent.html#child

        **QObject *QChildEvent::child() const**

        Returns the child object that was added or removed.
        """
        ...
