"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QCborStreamWriter(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qcborstreamwriter.html

    **Detailed Description**

    This class can be used to quickly encode a stream of CBOR content directly
    to either a **QByteArray**  or **QIODevice** . CBOR is the Concise Binary
    Object Representation, a very compact form of binary data encoding that is
    compatible with JSON. It was created by the IETF Constrained RESTful
    Environments (CoRE) WG, which has used it in many new RFCs. It is meant to
    be used alongside the **CoAP protocol** .

    QCborStreamWriter provides a StAX-like API, similar to that of
    **QXmlStreamWriter** . It is rather low-level and requires a bit of
    knowledge of CBOR encoding. For a simpler API, see **QCborValue**  and
    especially the encoding function **QCborValue::toCbor** ().

    The typical use of QCborStreamWriter is to create the object on the target
    **QByteArray**  or **QIODevice** , then call one of the **append** ()
    overloads with the desired type to be encoded. To create arrays and maps,
    QCborStreamWriter provides **startArray** () and **startMap** () overloads,
    which must be terminated by the corresponding **endArray** () and **endMap**
    () functions.

    The following example encodes the equivalent of this JSON content:

    { "label": "journald", "autoDetect": false, "condition": "libs.journald",
    "output": [ "privateFeature" ] }

    writer.startMap(4);    // 4 elements in the map
    writer.append(QLatin1String("label"));
    writer.append(QLatin1String("journald"));
    writer.append(QLatin1String("autoDetect"));
           writer.append(false);
    writer.append(QLatin1String("condition"));
    writer.append(QLatin1String("libs.journald"));
    writer.append(QLatin1String("output"));
           writer.startArray(1);
    writer.append(QLatin1String("privateFeature"));
           writer.endArray();
    writer.endMap();

    **CBOR support**

    QCborStreamWriter supports all CBOR features required to create canonical
    and strict streams. It implements almost all of the features specified in
    **RFC 7049** .

    The following table lists the CBOR features that QCborStreamWriter supports.

    FeatureSupport
    Unsigned numbersYes (full range)
    Negative numbersYes
    (full range)
    Byte stringsYes
    Text stringsYes
    Chunked stringsNo
    TagsYes (arbitrary)
    BooleansYes
    NullYes
    UndefinedYes
    Arbitrary
    simple valuesYes
    Half-precision float (16-bit)Yes
    Single-precision float
    (32-bit)Yes
    Double-precision float (64-bit)Yes
    Infinities and NaN
    floating pointYes
    Determinate-length arrays and mapsYes
    Indeterminate-
    length arrays and mapsYes
    Map key types other than strings and integersYes
    (arbitrary)

    **Canonical CBOR encoding**

    Canonical CBOR encoding is defined by **Section 3.9 of RFC 7049** .
    Canonical encoding is not a requirement for Qt's CBOR decoding
    functionality, but it may be required for some protocols. In particular,
    protocols that require the ability to reproduce the same stream identically
    may require this.

    In order to be considered "canonical", a CBOR stream must meet the following
    requirements:

    * Integers must be as small as possible. QCborStreamWriter always does this
    (no user action is required and it is not possible to write overlong
    integers).
      * Array, map and string lengths must be as short as possible.
    As above, QCborStreamWriter automatically does this.
      * Arrays, maps and
    strings must use explicit length. QCborStreamWriter always does this for
    strings; for arrays and maps, be sure to call **startArray** () and
    **startMap** () overloads with explicit length.
      * Keys in every map must
    be sorted in ascending order. QCborStreamWriter offers no help in this item:
    the developer must ensure that before calling **append** () for the map
    pairs.
      * Floating point values should be as small as possible.
    QCborStreamWriter will not convert floating point values; it is up to the
    developer to perform this check prior to calling **append** () (see those
    functions' examples).

    **Strict CBOR mode**

    Strict mode is defined by **Section 3.10 of RFC 7049** . As for Canonical
    encoding above, QCborStreamWriter makes it possible to create strict CBOR
    streams, but does not require them or validate that the output is so.

    * Keys in a map must be unique. QCborStreamWriter performs no validation of
    map keys.
      * Tags may be required to be paired only with the correct types,
    according to their specification. QCborStreamWriter performs no validation
    of tag usage.
      * Text Strings must be properly-encoded UTF-8.
    QCborStreamWriter always writes proper UTF-8 for strings added with
    **append** (), but performs no validation for strings added with
    **appendTextString** ().

    **Invalid CBOR stream**

    It is also possible to misuse QCborStreamWriter and produce invalid CBOR
    streams that will fail to be decoded by a receiver. The following actions
    will produce invalid streams:

    * Append a tag and not append the corresponding tagged value
    (QCborStreamWriter produces no diagnostic).
      * Append too many or too few
    items to an array or map with explicit length (**endMap** () and
    **endArray** () will return false and QCborStreamWriter will log with
    **qWarning** ()).

    **See also** **QCborStreamReader** , **QCborValue** , and
    **QXmlStreamWriter** .
    """

    @typing.overload
    def __init__(self, device: QIODevice) -> None:
        """
        https://doc.qt.io/qt-5/qcborstreamwriter.html#QCborStreamWriter

        **QCborStreamWriter::QCborStreamWriter(QIODevice * device )**

        Creates a QCborStreamWriter object that will write the stream to
        **device**. The device must be opened before the first **append** ()
        call is made. This constructor can be used with any class that derives
        from **QIODevice** , such as **QFile** , **QProcess**  or **QTcpSocket**
        .

        QCborStreamWriter has no buffering, so every **append** () call will
        result in one or more calls to the device's **write()**  method.

        The following example writes an empty map to a file:

        **QFile**  f("output", **QIODevice** ::WriteOnly);
        QCborStreamWriter writer(&f);
               writer.startMap(0);
        writer.endMap();

        QCborStreamWriter does not take ownership of **device**.

        **See also** **device** () and **setDevice** ().
        """
        ...

    @typing.overload
    def __init__(self, data: typing.Union[QByteArray, bytes, bytearray]) -> None:
        """
        https://doc.qt.io/qt-5/qcborstreamwriter.html#QCborStreamWriter-1

        **QCborStreamWriter::QCborStreamWriter(QByteArray * data )**

        Creates a QCborStreamWriter object that will append the stream to
        **data**. All streaming is done immediately to the byte array, without
        the need for flushing any buffers.

        The following example writes a number to a byte array then returns it.

        **QByteArray**  encodedNumber(**qint64**  value)
               {
        **QByteArray**  ba;
                   **QCborStreamWriter**  writer(&ba);
        writer.append(value);
                   return ba;
               }

        QCborStreamWriter does not take ownership of **data**.
        """
        ...

    def endMap(self) -> bool:
        """
        https://doc.qt.io/qt-5/qcborstreamwriter.html#endMap

        **bool QCborStreamWriter::endMap()**

        Terminates the map started by either overload of **startMap** () and
        returns true if the correct number of elements was added to the array.
        This function must be called for every **startMap** () used.

        A return of false indicates error in the application and an
        unrecoverable error in this stream. **QCborStreamWriter**  also writes a
        warning using **qWarning** () if that happens.

        Calling this function when the current container is not a map is also an
        error, though **QCborStreamWriter**  cannot currently detect this
        condition.

        **See also** **startMap** (), **startMap** (quint64), and **endArray**
        ().
        """
        ...

    @typing.overload
    def startMap(self) -> None:
        """
        https://doc.qt.io/qt-5/qcborstreamwriter.html#startMap

        **void QCborStreamWriter::startMap()**

        Starts a CBOR Map with indeterminate length in the CBOR stream. Each
        startMap() call must be paired with one **endMap** () call and the
        current CBOR element extends until the end of the map.

        The map created by this function has no explicit length. Instead, its
        length is implied by the elements contained in it. Note, however, that
        use of indeterminate-length maps is not compliant with canonical CBOR
        encoding (canonical encoding also requires keys to be unique and in
        sorted order).

        The following example appends elements from the linked list of int and
        string pairs passed as input:

        void appendMap(**QCborStreamWriter**  &writer, const **QLinkedList**
        <**QPair** <int, **QString** >> &list)
               {
        writer.startMap();
                   for (const auto pair : list) {
        writer.append(pair.first)
                       writer.append(pair.second);
        }
                   writer.endMap();
               }

        **See also** **startMap** (quint64), **endMap** (), **startArray** (),
        **QCborStreamReader::isMap** (), and
        **QCborStreamReader::isLengthKnown** ().
        """
        ...

    @typing.overload
    def startMap(self, count: int) -> None:
        """
        https://doc.qt.io/qt-5/qcborstreamwriter.html#startMap-1

        **void QCborStreamWriter::startMap(quint64 count )**

        This is an overloaded function.

        Starts a CBOR Map with explicit length of **count** items in the CBOR
        stream. Each startMap call must be paired with one **endMap** () call
        and the current CBOR element extends until the end of the map.

        The map created by this function has an explicit length and therefore
        exactly **count** pairs of items must be added to the CBOR stream.
        Adding fewer or more items will result in failure during **endMap** ()
        and the CBOR stream will be corrupt. However, explicit-length map are
        required by canonical CBOR encoding.

        The following example appends all strings found in the **QMap**  passed
        as input:

        void appendMap(**QCborStreamWriter**  &writer, const **QMap** <int,
        **QString** > &map)
               {
                   writer.startMap(map.size());
        for (auto it = map.begin(); it != map.end(); ++it) {
        writer.append(it.key());
                       writer.append(it.value());
        }
                   writer.endMap();
               }

        **Size limitations** : The parameter to this function is quint64, which
        would seem to allow up to 264-1 pairs in the map. However, both
        **QCborStreamWriter**  and **QCborStreamReader**  are currently limited
        to 231-1 items on 32-bit systems and 263-1 items on 64-bit ones. Also
        note that **QCborMap**  is currently limited to 226 elements in any
        platform.

        **See also** **startMap** (), **endMap** (), **startArray** (),
        **QCborStreamReader::isMap** (), and
        **QCborStreamReader::isLengthKnown** ().
        """
        ...

    def endArray(self) -> bool:
        """
        https://doc.qt.io/qt-5/qcborstreamwriter.html#endArray

        **bool QCborStreamWriter::endArray()**

        Terminates the array started by either overload of **startArray** () and
        returns true if the correct number of elements was added to the array.
        This function must be called for every **startArray** () used.

        A return of false indicates error in the application and an
        unrecoverable error in this stream. **QCborStreamWriter**  also writes a
        warning using **qWarning** () if that happens.

        Calling this function when the current container is not an array is also
        an error, though **QCborStreamWriter**  cannot currently detect this
        condition.

        **See also** **startArray** (), **startArray** (quint64), and **endMap**
        ().
        """
        ...

    @typing.overload
    def startArray(self) -> None:
        """
        https://doc.qt.io/qt-5/qcborstreamwriter.html#startArray

        **void QCborStreamWriter::startArray()**

        Starts a CBOR Array with indeterminate length in the CBOR stream. Each
        startArray() call must be paired with one **endArray** () call and the
        current CBOR element extends until the end of the array.

        The array created by this function has no explicit length. Instead, its
        length is implied by the elements contained in it. Note, however, that
        use of indeterminate-length arrays is not compliant with canonical CBOR
        encoding.

        The following example appends elements from the linked list of strings
        passed as input:

        void appendList(**QCborStreamWriter**  &writer, const **QLinkedList**
        <**QString** > &list)
               {
                   writer.startArray();
        for (const **QString**  &s : list)
                       writer.append(s);
        writer.endArray();
               }

        **See also** **startArray** (quint64), **endArray** (), **startMap** (),
        **QCborStreamReader::isArray** (), and
        **QCborStreamReader::isLengthKnown** ().
        """
        ...

    @typing.overload
    def startArray(self, count: int) -> None:
        """
        https://doc.qt.io/qt-5/qcborstreamwriter.html#startArray-1

        **void QCborStreamWriter::startArray(quint64 count )**

        This is an overloaded function.

        Starts a CBOR Array with explicit length of **count** items in the CBOR
        stream. Each startArray call must be paired with one **endArray** ()
        call and the current CBOR element extends until the end of the array.

        The array created by this function has an explicit length and therefore
        exactly **count** items must be added to the CBOR stream. Adding fewer
        or more items will result in failure during **endArray** () and the CBOR
        stream will be corrupt. However, explicit-length arrays are required by
        canonical CBOR encoding.

        The following example appends all strings found in the **QStringList**
        passed as input:

        void appendList(**QCborStreamWriter**  &writer, const **QStringList**
        &list)
               {
                   writer.startArray(list.size());
        for (const **QString**  &s : list)
                       writer.append(s);
        writer.endArray();
               }

        **Size limitations** : The parameter to this function is quint64, which
        would seem to allow up to 264-1 elements in the array. However, both
        **QCborStreamWriter**  and **QCborStreamReader**  are currently limited
        to 232-2 items on 32-bit systems and 264-2 items on 64-bit ones. Also
        note that **QCborArray**  is currently limited to 227 elements in any
        platform.

        **See also** **startArray** (), **endArray** (), **startMap** (),
        **QCborStreamReader::isArray** (), and
        **QCborStreamReader::isLengthKnown** ().
        """
        ...

    def appendUndefined(self) -> None:
        """
        https://doc.qt.io/qt-5/qcborstreamwriter.html#appendUndefined

        **void QCborStreamWriter::appendUndefined()**

        Appends a CBOR Undefined value to the stream. This function is
        equivalent to (and implemented as):

        writer.append(**QCborSimpleType** ::Undefined);

        **See also** **append** (QCborSimpleType) and
        **QCborStreamReader::isUndefined** ().
        """
        ...

    def appendNull(self) -> None:
        """
        https://doc.qt.io/qt-5/qcborstreamwriter.html#appendNull

        **void QCborStreamWriter::appendNull()**

        Appends a CBOR Null value to the stream. This function is equivalent to
        (and implemented as):

        writer.append(**QCborSimpleType** ::Null);

        **See also** **append** (std::nullptr_t), **append** (QCborSimpleType),
        and **QCborStreamReader::isNull** ().
        """
        ...

    @typing.overload
    def append(self, st: QCborSimpleType) -> None:
        """
        https://doc.qt.io/qt-5/qcborstreamwriter.html#append

        **void QCborStreamWriter::append(quint64 u )**

        This is an overloaded function.

        Appends the 64-bit unsigned value **u** to the CBOR stream, creating a
        CBOR Unsigned Integer value. In the following example, we write the
        values 0, 232 and `UINT64_MAX`:

        writer.append(0U);
               writer.append(Q_UINT64_C(4294967296));
        writer.append(std::numeric_limits<**quint64** >::max());

        **See also** **QCborStreamReader::isUnsignedInteger** () and
        **QCborStreamReader::toUnsignedInteger** ().
        """
        ...

    @typing.overload
    def append(self, tag: QCborKnownTags) -> None:
        """
        https://doc.qt.io/qt-5/qcborstreamwriter.html#append-1

        **void QCborStreamWriter::append(qint64 i )**

        This is an overloaded function.

        Appends the 64-bit signed value **i** to the CBOR stream. This will
        create either a CBOR Unsigned Integer or CBOR NegativeInteger value
        based on the sign of the parameter. In the following example, we write
        the values 0, -1, 232 and `INT64_MAX`:

        writer.append(0);
               writer.append(-1);
        writer.append(Q_INT64_C(4294967296));
        writer.append(std::numeric_limits<**qint64** >::max());

        **See also** **QCborStreamReader::isInteger** () and
        **QCborStreamReader::toInteger** ().
        """
        ...

    @typing.overload
    def append(self, str: str) -> None:
        """
        https://doc.qt.io/qt-5/qcborstreamwriter.html#append-2

        **void QCborStreamWriter::append(QCborNegativeInteger n )**

        This is an overloaded function.

        Appends the 64-bit negative value **n** to the CBOR stream.
        QCborNegativeInteger is a 64-bit enum that holds the absolute value of
        the negative number we want to write. If n is zero, the value written
        will be equivalent to 264 (that is, -18,446,744,073,709,551,616).

        In the following example, we write the values -1, -232 and INT64_MIN:

        writer.append(QCborNegativeInteger(1));
        writer.append(QCborNegativeInteger(Q_INT64_C(4294967296)));
        writer.append(QCborNegativeInteger(-**quint64**
        (std::numeric_limits<**qint64** >::min())));

        Note how this function can be used to encode numbers that cannot fit a
        standard computer's 64-bit signed integer like **qint64** . That is, if
        **n** is larger than `std::numeric_limits<qint64>::max()` or is 0, this
        will represent a negative number smaller than
        `std::numeric_limits<qint64>::min()`.

        **See also** **QCborStreamReader::isNegativeInteger** () and
        **QCborStreamReader::toNegativeInteger** ().
        """
        ...

    @typing.overload
    def append(self, ba: typing.Union[QByteArray, bytes, bytearray]) -> None:
        """
        https://doc.qt.io/qt-5/qcborstreamwriter.html#append-3

        **void QCborStreamWriter::append(const QByteArray & ba )**

        This is an overloaded function.

        Appends the byte array **ba** to the stream, creating a CBOR Byte String
        value. **QCborStreamWriter**  will attempt to write the entire string in
        one chunk.

        The following example will load and append the contents of a file to the
        stream:

        void writeFile(**QCborStreamWriter**  &writer, const **QString**
        &fileName)
               {
                   **QFile**  f(fileName);
                   if
        (f.open(**QIODevice** ::ReadOnly))
        writer.append(f.readAll());
               }

        As the example shows, unlike JSON, CBOR requires no escaping for binary
        content.

        **See also** **appendByteString** (), **QCborStreamReader::isByteArray**
        (), and **QCborStreamReader::readByteArray** ().
        """
        ...

    @typing.overload
    def append(self, b: bool) -> None:
        """
        https://doc.qt.io/qt-5/qcborstreamwriter.html#append-4

        **void QCborStreamWriter::append(QLatin1String str )**

        This is an overloaded function.

        Appends the text string **str** to the stream, creating a CBOR Text
        String value. **QCborStreamWriter**  will attempt to write the entire
        string in one chunk.

        The following example appends a simple string to the stream:

        writer.append(QLatin1String("Hello, World"));

        **Performance note** : CBOR requires that all Text Strings be encoded in
        UTF-8, so this function will iterate over the characters in the string
        to determine whether the contents are US-ASCII or not. If the string is
        found to contain characters outside of US-ASCII, it will allocate memory
        and convert to UTF-8. If this check is unnecessary, use
        **appendTextString** () instead.

        **See also** **QCborStreamReader::isString** () and
        **QCborStreamReader::readString** ().
        """
        ...

    @typing.overload
    def append(self, d: float) -> None:
        """
        https://doc.qt.io/qt-5/qcborstreamwriter.html#append-5

        **void QCborStreamWriter::append(QStringView str )**

        This is an overloaded function.

        Appends the text string **str** to the stream, creating a CBOR Text
        String value. **QCborStreamWriter**  will attempt to write the entire
        string in one chunk.

        The following example writes an arbitrary **QString**  to the stream:

        void writeString(**QCborStreamWriter**  &writer, const **QString**
        &str)
               {
                   writer.append(str);
               }

        **See also** **QCborStreamReader::isString** () and
        **QCborStreamReader::readString** ().
        """
        ...

    @typing.overload
    def append(self, a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qcborstreamwriter.html#append-6

        **void QCborStreamWriter::append(QCborTag tag )**

        This is an overloaded function.

        Appends the CBOR tag **tag** to the stream, creating a CBOR Tag value.
        All tags must be followed by another type which they provide meaning
        for.

        In the following example, we append a CBOR Tag 36 (Regular Expression)
        and a **QRegularExpression** 's pattern to the stream:

        void writeRxPattern(**QCborStreamWriter**  &writer, const
        **QRegularExpression**  &rx)
               {
        writer.append(**QCborTag** (36));
        writer.append(rx.pattern());
               }

        **See also** **QCborStreamReader::isTag** () and
        **QCborStreamReader::toTag** ().
        """
        ...

    def device(self) -> QIODevice:
        """
        https://doc.qt.io/qt-5/qcborstreamwriter.html#device

        **QIODevice *QCborStreamWriter::device() const**

        Returns the **QIODevice**  that this **QCborStreamWriter**  object is
        writing to. The device must have previously been set with either the
        constructor or with **setDevice** ().

        If this object was created by writing to a **QByteArray** , this
        function will return an internal instance of **QBuffer** , which is
        owned by **QCborStreamWriter** .

        **See also** **setDevice** ().
        """
        ...

    def setDevice(self, device: QIODevice) -> None:
        """
        https://doc.qt.io/qt-5/qcborstreamwriter.html#setDevice

        **void QCborStreamWriter::setDevice(QIODevice * device )**

        Replaces the device or byte array that this **QCborStreamWriter**
        object is writing to with **device**.

        **See also** **device** ().
        """
        ...
