"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QByteArrayMatcher(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qbytearraymatcher.html

    **Detailed Description**

    This class is useful when you have a sequence of bytes that you want to
    repeatedly match against some byte arrays (perhaps in a loop), or when you
    want to search for the same sequence of bytes multiple times in the same
    byte array. Using a matcher object and **indexIn** () is faster than
    matching a plain **QByteArray**  with **QByteArray::indexOf** () if repeated
    matching takes place. This class offers no benefit if you are doing one-off
    byte array matches.

    Create the QByteArrayMatcher with the **QByteArray**  you want to search
    for. Then call **indexIn** () on the **QByteArray**  that you want to
    search.

    **See also** **QByteArray**  and **QStringMatcher** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qbytearraymatcher.html#QByteArrayMatcher

        **QByteArrayMatcher::QByteArrayMatcher()**

        Constructs an empty byte array matcher that won't match anything. Call
        **setPattern** () to give it a pattern to match.
        """
        ...

    @typing.overload
    def __init__(self, pattern: typing.Union[QByteArray, bytes, bytearray]) -> None:
        """
        https://doc.qt.io/qt-5/qbytearraymatcher.html#QByteArrayMatcher-1

        **QByteArrayMatcher::QByteArrayMatcher(const QByteArray & pattern )**

        Constructs a byte array matcher that will search for **pattern**. Call
        **indexIn** () to perform a search.
        """
        ...

    @typing.overload
    def __init__(self, other: "QByteArrayMatcher") -> None:
        """
        https://doc.qt.io/qt-5/qbytearraymatcher.html#QByteArrayMatcher-2

        **QByteArrayMatcher::QByteArrayMatcher(const char * pattern , int length
        )**

        Constructs a byte array matcher from **pattern**. **pattern** has the
        given **length**. **pattern** must remain in scope, but the destructor
        does not delete **pattern**.
        """
        ...

    def pattern(self) -> QByteArray:
        """
        https://doc.qt.io/qt-5/qbytearraymatcher.html#pattern

        **QByteArray QByteArrayMatcher::pattern() const**

        Returns the byte array pattern that this byte array matcher will search
        for.

        **See also** **setPattern** ().
        """
        ...

    def indexIn(
        self, ba: typing.Union[QByteArray, bytes, bytearray], from_: int = ...
    ) -> int:
        """
        https://doc.qt.io/qt-5/qbytearraymatcher.html#indexIn

        **int QByteArrayMatcher::indexIn(const QByteArray & ba , int from = 0)
        const**

        Searches the byte array **ba** , from byte position **from** (default 0,
        i.e. from the first byte), for the byte array **pattern** () that was
        set in the constructor or in the most recent call to **setPattern** ().
        Returns the position where the **pattern** () matched in **ba** , or -1
        if no match was found.
        """
        ...

    def setPattern(self, pattern: typing.Union[QByteArray, bytes, bytearray]) -> None:
        """
        https://doc.qt.io/qt-5/qbytearraymatcher.html#setPattern

        **void QByteArrayMatcher::setPattern(const QByteArray & pattern )**

        Sets the byte array that this byte array matcher will search for to
        **pattern**.

        **See also** **pattern** () and **indexIn** ().
        """
        ...
