"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QByteArray(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qbytearray.html

    **Detailed Description**

    QByteArray can be used to store both raw bytes (including '\\0's) and
    traditional 8-bit '\\0'-terminated strings. Using QByteArray is much more
    convenient than using `const char *`. Behind the scenes, it always ensures
    that the data is followed by a '\\0' terminator, and uses **implicit
    sharing**  (copy-on-write) to reduce memory usage and avoid needless copying
    of data.

    In addition to QByteArray, Qt also provides the **QString**  class to store
    string data. For most purposes, **QString**  is the class you want to use.
    It stores 16-bit Unicode characters, making it easy to store non-ASCII/non-
    Latin-1 characters in your application. Furthermore, **QString**  is used
    throughout in the Qt API. The two main cases where QByteArray is appropriate
    are when you need to store raw binary data, and when memory conservation is
    critical (e.g., with Qt for Embedded Linux).

    One way to initialize a QByteArray is simply to pass a `const char *` to its
    constructor. For example, the following code creates a byte array of size 5
    containing the data "Hello":

    **QByteArray**  ba("Hello");

    Although the **size** () is 5, the byte array also maintains an extra '\\0'
    character at the end so that if a function is used that asks for a pointer
    to the underlying data (e.g. a call to **data** ()), the data pointed to is
    guaranteed to be '\\0'-terminated.

    QByteArray makes a deep copy of the `const char *` data, so you can modify
    it later without experiencing side effects. (If for performance reasons you
    don't want to take a deep copy of the character data, use
    **QByteArray::fromRawData** () instead.)

    Another approach is to set the size of the array using **resize** () and to
    initialize the data byte per byte. QByteArray uses 0-based indexes, just
    like C++ arrays. To access the byte at a particular index position, you can
    use operator[](). On non-const byte arrays, operator[]() returns a reference
    to a byte that can be used on the left side of an assignment. For example:

    **QByteArray**  ba;
        ba.resize(5);
        ba[0] = 0x3c;
        ba[1] = 0xb8;
    ba[2] = 0x64;
        ba[3] = 0x18;
        ba[4] = 0xca;

    For read-only access, an alternative syntax is to use **at** ():

    for (int i = 0; i < ba.size(); ++i) {
            if (ba.at(i) >= 'a' &&
    ba.at(i) <= 'f')
                cout << "Found character in range [a-f]" <<
    Qt::endl;
        }

    **at** () can be faster than operator[](), because it never causes a **deep
    copy**  to occur.

    To extract many bytes at a time, use **left** (), **right** (), or **mid**
    ().

    A QByteArray can embed '\\0' bytes. The **size** () function always returns
    the size of the whole array, including embedded '\\0' bytes, but excluding
    the terminating '\\0' added by QByteArray. For example:

    **QByteArray**  ba1("ca\\0r\\0t");
        ba1.size();                     //
    Returns 2.
        ba1.constData();                // Returns "ca" with
    terminating \\0.

        **QByteArray**  ba2("ca\\0r\\0t", 3);
        ba2.size();
    // Returns 3.
        ba2.constData();                // Returns "ca\\0" with
    terminating \\0.

        **QByteArray**  ba3("ca\\0r\\0t", 4);
        ba3.size();
    // Returns 4.
        ba3.constData();                // Returns "ca\\0r" with
    terminating \\0.

        const char cart[] = {'c', 'a', '\\0', 'r', '\\0',
    't'};
        **QByteArray**  ba4(**QByteArray** ::fromRawData(cart, 6));
    ba4.size();                     // Returns 6.
        ba4.constData();
    // Returns "ca\\0r\\0t" without terminating \\0.

    If you want to obtain the length of the data up to and excluding the first
    '\\0' character, call **qstrlen** () on the byte array.

    After a call to **resize** (), newly allocated bytes have undefined values.
    To set all the bytes to a particular value, call **fill** ().

    To obtain a pointer to the actual character data, call **data** () or
    **constData** (). These functions return a pointer to the beginning of the
    data. The pointer is guaranteed to remain valid until a non-const function
    is called on the QByteArray. It is also guaranteed that the data ends with a
    '\\0' byte unless the QByteArray was created from a **raw data** . This '\\0'
    byte is automatically provided by QByteArray and is not counted in **size**
    ().

    QByteArray provides the following basic functions for modifying the byte
    data: **append** (), **prepend** (), **insert** (), **replace** (), and
    **remove** (). For example:

    **QByteArray**  x("and");
        x.prepend("rock ");         // x == "rock and"
    x.append(" roll");          // x == "rock and roll"
        x.replace(5, 3,
    "&");       // x == "rock & roll"

    The **replace** () and **remove** () functions' first two arguments are the
    position from which to start erasing and the number of bytes that should be
    erased.

    When you **append** () data to a non-empty array, the array will be
    reallocated and the new data copied to it. You can avoid this behavior by
    calling **reserve** (), which preallocates a certain amount of memory. You
    can also call **capacity** () to find out how much memory QByteArray
    actually allocated. Data appended to an empty array is not copied.

    A frequent requirement is to remove whitespace characters from a byte array
    ('\\n', '\\t', ' ', etc.). If you want to remove whitespace from both ends of
    a QByteArray, use **trimmed** (). If you want to remove whitespace from both
    ends and replace multiple consecutive whitespaces with a single space
    character within the byte array, use **simplified** ().

    If you want to find all occurrences of a particular character or substring
    in a QByteArray, use **indexOf** () or **lastIndexOf** (). The former
    searches forward starting from a given index position, the latter searches
    backward. Both return the index position of the character or substring if
    they find it; otherwise, they return -1. For example, here's a typical loop
    that finds all occurrences of a particular substring:

    **QByteArray**  ba("We must be <b>bold</b>, very <b>bold</b>");
        int j =
    0;
        while ((j = ba.indexOf("<b>", j)) != -1) {
            cout << "Found <b>
    tag at index position " << j << Qt::endl;
            ++j;
        }

    If you simply want to check whether a QByteArray contains a particular
    character or substring, use **contains** (). If you want to find out how
    many times a particular character or substring occurs in the byte array, use
    **count** (). If you want to replace all occurrences of a particular value
    with another, use one of the two-parameter **replace** () overloads.

    **QByteArray** s can be compared using overloaded operators such as
    operator<(), operator<=(), operator==(), operator>=(), and so on. The
    comparison is based exclusively on the numeric values of the characters and
    is very fast, but is not what a human would expect.
    **QString::localeAwareCompare** () is a better choice for sorting user-
    interface strings.

    For historical reasons, QByteArray distinguishes between a null byte array
    and an empty byte array. A **null** byte array is a byte array that is
    initialized using QByteArray's default constructor or by passing (const char
    *)0 to the constructor. An **empty** byte array is any byte array with size
    0. A null byte array is always empty, but an empty byte array isn't
    necessarily null:

    **QByteArray** ().isNull();          // returns true
        **QByteArray**
    ().isEmpty();         // returns true

        **QByteArray** ("").isNull();
    // returns false
        **QByteArray** ("").isEmpty();       // returns true
    **QByteArray** ("abc").isNull();     // returns false
        **QByteArray**
    ("abc").isEmpty();    // returns false

    All functions except **isNull** () treat null byte arrays the same as empty
    byte arrays. For example, **data** () returns a valid pointer ( **not**
    nullptr) to a '\\0' character for a byte array and QByteArray() compares
    equal to QByteArray(""). We recommend that you always use **isEmpty** () and
    avoid **isNull** ().

    **Maximum size and out-of-memory conditions**

    The current version of QByteArray is limited to just under 2 GB (2^31 bytes)
    in size. The exact value is architecture-dependent, since it depends on the
    overhead required for managing the data block, but is no more than 32 bytes.
    Raw data blocks are also limited by the use of `int` type in the current
    version to 2 GB minus 1 byte.

    In case memory allocation fails, QByteArray will throw a `std::bad_alloc`
    exception. Out of memory conditions in the Qt containers are the only case
    where Qt will throw exceptions.

    Note that the operating system may impose further limits on applications
    holding a lot of allocated memory, especially large, contiguous blocks. Such
    considerations, the configuration of such behavior or any mitigation are
    outside the scope of the QByteArray API.

    **Notes on Locale**

    **Number-String Conversions**

    Functions that perform conversions between numeric data types and strings
    are performed in the C locale, irrespective of the user's locale settings.
    Use **QString**  to perform locale-aware conversions between numbers and
    strings.

    **8-bit Character Comparisons**

    In QByteArray, the notion of uppercase and lowercase and of which character
    is greater than or less than another character is done in the Latin-1
    locale. This affects functions that support a case insensitive option or
    that compare or lowercase or uppercase their arguments. Case insensitive
    operations and comparisons will be accurate if both strings contain only
    Latin-1 characters. Functions that this affects include **contains** (),
    **indexOf** (), **lastIndexOf** (), operator<(), operator<=(), operator>(),
    operator>=(), **isLower** (), **isUpper** (), **toLower** () and **toUpper**
    ().

    This issue does not apply to **QString** s since they represent characters
    using Unicode.

    **See also** **QString**  and **QBitArray** .
    """

    class Base64DecodingStatus(int):
        Ok: QByteArray = ...
        IllegalInputLength: QByteArray = ...
        IllegalCharacter: QByteArray = ...
        IllegalPadding: QByteArray = ...

    class Base64Option(int):
        Base64Encoding: QByteArray = ...
        Base64UrlEncoding: QByteArray = ...
        KeepTrailingEquals: QByteArray = ...
        OmitTrailingEquals: QByteArray = ...
        IgnoreBase64DecodingErrors: QByteArray = ...
        AbortOnBase64DecodingErrors: QByteArray = ...

    class Base64Options(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self, f: typing.Union["QByteArray.Base64Options", "QByteArray.Base64Option"]
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QByteArray.Base64Options") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QByteArray.Base64Options":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class FromBase64Result(sip.simplewrapper):
        decoded: typing = ...
        decodingStatus = ...

        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QByteArray.FromBase64Result") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __int__(self) -> bool:
            ...

        def swap(self, other: "QByteArray.FromBase64Result") -> None:
            ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qbytearray.html#QByteArray

        **QByteArray::QByteArray()**

        Constructs an empty byte array.

        **See also** **isEmpty** ().
        """
        ...

    @typing.overload
    def __init__(self, size: int, c: str) -> None:
        """
        https://doc.qt.io/qt-5/qbytearray.html#QByteArray-1

        **QByteArray::QByteArray(const char * data , int size = -1)**

        Constructs a byte array containing the first **size** bytes of array
        **data**.

        If **data** is 0, a null byte array is constructed.

        If **size** is negative, **data** is assumed to point to a
        '\\0'-terminated string and its length is determined dynamically. The
        terminating \\0 character is not considered part of the byte array.

        QByteArray makes a deep copy of the string data.

        **See also** **fromRawData** ().
        """
        ...

    @typing.overload
    def __init__(self, a: typing.Union["QByteArray", bytes, bytearray]) -> None:
        """
        https://doc.qt.io/qt-5/qbytearray.html#QByteArray-2

        **QByteArray::QByteArray(int size , char ch )**

        Constructs a byte array of size **size** with every byte set to
        character **ch**.

        **See also** **fill** ().
        """
        ...

    @staticmethod
    def fromBase64Encoding(
        base64: typing.Union["QByteArray", bytes, bytearray],
        options: typing.Union[
            "QByteArray.Base64Options", "QByteArray.Base64Option"
        ] = ...,
    ) -> "QByteArray.FromBase64Result":
        ...

    def isLower(self) -> bool:
        """
        https://doc.qt.io/qt-5/qbytearray.html#isLower

        **bool QByteArray::isLower() const**

        Returns `true` if this byte array contains only lowercase letters,
        otherwise returns `false`. The byte array is interpreted as a Latin-1
        encoded string.

        This function was introduced in Qt 5.12.

        **See also** **isUpper** () and **toLower** ().
        """
        ...

    def isUpper(self) -> bool:
        """
        https://doc.qt.io/qt-5/qbytearray.html#isUpper

        **bool QByteArray::isUpper() const**

        Returns `true` if this byte array contains only uppercase letters,
        otherwise returns `false`. The byte array is interpreted as a Latin-1
        encoded string.

        This function was introduced in Qt 5.12.

        **See also** **isLower** () and **toUpper** ().
        """
        ...

    def compare(
        self,
        a: typing.Union["QByteArray", bytes, bytearray],
        cs: Qt.CaseSensitivity = ...,
    ) -> int:
        """
        https://doc.qt.io/qt-5/qbytearray.html#compare

        **int QByteArray::compare(const char * c , Qt::CaseSensitivity cs =
        Qt::CaseSensitive) const**

        Returns an integer less than, equal to, or greater than zero depending
        on whether this **QByteArray**  sorts before, at the same position, or
        after the string pointed to by **c**. The comparison is performed
        according to case sensitivity **cs**.

        This function was introduced in Qt 5.12.

        **See also** **operator==** .
        """
        ...

    def chopped(self, len: int) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#chopped

        **QByteArray QByteArray::chopped(int len ) const**

        Returns a byte array that contains the leftmost **size** () - **len**
        bytes of this byte array.

        **Note:** The behavior is undefined if **len** is negative or greater
        than **size** ().

        This function was introduced in Qt 5.10.

        **See also** **endsWith** (), **left** (), **right** (), **mid** (),
        **chop** (), and **truncate** ().
        """
        ...

    def swap(self, other: "QByteArray") -> None:
        """
        https://doc.qt.io/qt-5/qbytearray.html#swap

        **void QByteArray::swap(QByteArray & other )**

        Swaps byte array **other** with this byte array. This operation is very
        fast and never fails.

        This function was introduced in Qt 4.8.
        """
        ...

    def repeated(self, times: int) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#repeated

        **QByteArray QByteArray::repeated(int times ) const**

        Returns a copy of this byte array repeated the specified number of
        **times**.

        If **times** is less than 1, an empty byte array is returned.

        Example:

        **QByteArray**  ba("ab");
            ba.repeated(4);             // returns
        "abababab"

        This function was introduced in Qt 4.5.
        """
        ...

    @staticmethod
    def fromPercentEncoding(
        input: typing.Union["QByteArray", bytes, bytearray], percent: str = ...
    ) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#fromPercentEncoding

        **[static] QByteArray QByteArray::fromPercentEncoding(const QByteArray &
        input , char percent = '%')**

        Returns a decoded copy of the URI/URL-style percent-encoded **input**.
        The **percent** parameter allows you to replace the '%' character for
        another (for instance, '_' or '=').

        For example:

        **QByteArray**  text = **QByteArray**
        ::fromPercentEncoding("Qt%20is%20great%33");
            text.data();
        // returns "Qt is great!"

        **Note:** Given invalid input (such as a string containing the sequence
        "%G5", which is not a valid hexadecimal number) the output will be
        invalid as well. As an example: the sequence "%G5" could be decoded to
        'W'.

        This function was introduced in Qt 4.4.

        **See also** **toPercentEncoding** () and **QUrl::fromPercentEncoding**
        ().
        """
        ...

    def toPercentEncoding(
        self,
        exclude: typing.Union["QByteArray", bytes, bytearray] = ...,
        include: typing.Union["QByteArray", bytes, bytearray] = ...,
        percent: str = ...,
    ) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#toPercentEncoding

        **QByteArray QByteArray::toPercentEncoding(const QByteArray & exclude =
        QByteArray(), const QByteArray & include = QByteArray(), char percent =
        '%') const**

        Returns a URI/URL-style percent-encoded copy of this byte array. The
        **percent** parameter allows you to override the default '%' character
        for another.

        By default, this function will encode all characters that are not one of
        the following:

        ALPHA ("a" to "z" and "A" to "Z") / DIGIT (0 to 9) / "-" / "." / "_" /
        "~"

        To prevent characters from being encoded pass them to **exclude**. To
        force characters to be encoded pass them to **include**. The **percent**
        character is always encoded.

        Example:

        **QByteArray**  text = "{a fishy string?}";
            **QByteArray**  ba =
        text.toPercentEncoding("{}", "s");
            **qDebug** (ba.constData());
        // prints "{a fi%73hy %73tring%3F}"

        The hex encoding uses the numbers 0-9 and the uppercase letters A-F.

        This function was introduced in Qt 4.4.

        **See also** **fromPercentEncoding** () and **QUrl::toPercentEncoding**
        ().
        """
        ...

    @typing.overload
    def toHex(self) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#toHex

        **QByteArray QByteArray::toHex() const**

        Returns a hex encoded copy of the byte array. The hex encoding uses the
        numbers 0-9 and the letters a-f.

        **See also** **fromHex** ().
        """
        ...

    @typing.overload
    def toHex(self, separator: str) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#toHex-1

        **QByteArray QByteArray::toHex(char separator ) const**

        This is an overloaded function.

        Returns a hex encoded copy of the byte array. The hex encoding uses the
        numbers 0-9 and the letters a-f.

        If **separator** is not '\\0', the separator character is inserted
        between the hex bytes.

        Example:

        **QByteArray**  macAddress = **QByteArray** ::fromHex("123456abcdef");
        macAddress.toHex(':'); // returns "12:34:56:ab:cd:ef"
        macAddress.toHex(0);   // returns "123456abcdef"

        This function was introduced in Qt 5.9.

        **See also** **fromHex** ().
        """
        ...

    def contains(self, a: typing.Union["QByteArray", bytes, bytearray]) -> bool:
        """
        https://doc.qt.io/qt-5/qbytearray.html#contains

        **bool QByteArray::contains(const QByteArray & ba ) const**

        Returns `true` if the byte array contains an occurrence of the byte
        array **ba** ; otherwise returns `false`.

        **See also** **indexOf** () and **count** ().
        """
        ...

    def push_front(self, a: typing.Union["QByteArray", bytes, bytearray]) -> None:
        """
        https://doc.qt.io/qt-5/qbytearray.html#push_front

        **void QByteArray::push_front(const QByteArray & other )**

        This function is provided for STL compatibility. It is equivalent to
        prepend( **other** ).
        """
        ...

    def push_back(self, a: typing.Union["QByteArray", bytes, bytearray]) -> None:
        """
        https://doc.qt.io/qt-5/qbytearray.html#push_back

        **void QByteArray::push_back(const QByteArray & other )**

        This function is provided for STL compatibility. It is equivalent to
        append( **other** ).
        """
        ...

    def squeeze(self) -> None:
        """
        https://doc.qt.io/qt-5/qbytearray.html#squeeze

        **void QByteArray::squeeze()**

        Releases any memory not required to store the array's data.

        The sole purpose of this function is to provide a means of fine tuning
        **QByteArray** 's memory usage. In general, you will rarely ever need to
        call this function.

        **See also** **reserve** () and **capacity** ().
        """
        ...

    def reserve(self, size: int) -> None:
        """
        https://doc.qt.io/qt-5/qbytearray.html#reserve

        **void QByteArray::reserve(int size )**

        Attempts to allocate memory for at least **size** bytes. If you know in
        advance how large the byte array will be, you can call this function,
        and if you call **resize** () often you are likely to get better
        performance. If **size** is an underestimate, the worst that will happen
        is that the **QByteArray**  will be a bit slower.

        The sole purpose of this function is to provide a means of fine tuning
        **QByteArray** 's memory usage. In general, you will rarely ever need to
        call this function. If you want to change the size of the byte array,
        call **resize** ().

        **See also** **squeeze** () and **capacity** ().
        """
        ...

    def capacity(self) -> int:
        """
        https://doc.qt.io/qt-5/qbytearray.html#capacity

        **int QByteArray::capacity() const**

        Returns the maximum number of bytes that can be stored in the byte array
        without forcing a reallocation.

        The sole purpose of this function is to provide a means of fine tuning
        **QByteArray** 's memory usage. In general, you will rarely ever need to
        call this function. If you want to know how many bytes are in the byte
        array, call **size** ().

        **See also** **reserve** () and **squeeze** ().
        """
        ...

    def data(self) -> bytes:
        """
        https://doc.qt.io/qt-5/qbytearray.html#data

        **char *QByteArray::data()**

        Returns a pointer to the data stored in the byte array. The pointer can
        be used to access and modify the bytes that compose the array. The data
        is '\\0'-terminated, i.e. the number of bytes in the returned character
        string is **size** () + 1 for the '\\0' terminator.

        Example:

        **QByteArray**  ba("Hello world");
            char *data = ba.data();
            while
        (*data) {
                cout << "[" << *data << "]" << Qt::endl;
        ++data;
            }

        The pointer remains valid as long as the byte array isn't reallocated or
        destroyed. For read-only access, **constData** () is faster because it
        never causes a **deep copy**  to occur.

        This function is mostly useful to pass a byte array to a function that
        accepts a `const char *`.

        The following example makes a copy of the char* returned by data(), but
        it will corrupt the heap and cause a crash because it does not allocate
        a byte for the '\\0' at the end:

        **QString**  tmp = "test";
            **QByteArray**  text = tmp.toLocal8Bit();
        char *data = new char[text.size()];
            strcpy(data, text.data());
        delete [] data;

        This one allocates the correct amount of space:

        **QString**  tmp = "test";
            **QByteArray**  text = tmp.toLocal8Bit();
        char *data = new char[text.size() + 1];
            strcpy(data, text.data());
        delete [] data;

        Note: A **QByteArray**  can store any byte values including '\\0's, but
        most functions that take `char *` arguments assume that the data ends at
        the first '\\0' they encounter.

        **See also** **constData** () and **operator[]** ().
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-5/qbytearray.html#isEmpty

        **bool QByteArray::isEmpty() const**

        Returns `true` if the byte array has size 0; otherwise returns `false`.

        Example:

        **QByteArray** ().isEmpty();         // returns true
            **QByteArray**
        ("").isEmpty();       // returns true
            **QByteArray**
        ("abc").isEmpty();    // returns false

        **See also** **size** ().
        """
        ...

    def __repr__(self) -> str:
        ...

    def __str__(self) -> str:
        ...

    def __hash__(self) -> int:
        ...

    def __contains__(self, a: typing.Union["QByteArray", bytes, bytearray]) -> int:
        ...

    @typing.overload
    def __getitem__(self, i: int) -> bytes:
        ...

    @typing.overload
    def __getitem__(self, slice: slice) -> "QByteArray":
        ...

    def at(self, i: int) -> bytes:
        """
        https://doc.qt.io/qt-5/qbytearray.html#at

        **char QByteArray::at(int i ) const**

        Returns the character at index position **i** in the byte array.

        **i** must be a valid index position in the byte array (i.e., 0 <= **i**
        < **size** ()).

        **See also** **operator[]** ().
        """
        ...

    def size(self) -> int:
        """
        https://doc.qt.io/qt-5/qbytearray.html#size

        **int QByteArray::size() const**

        Returns the number of bytes in this byte array.

        The last byte in the byte array is at position size() - 1. In addition,
        **QByteArray**  ensures that the byte at position size() is always '\\0',
        so that you can use the return value of **data** () and **constData** ()
        as arguments to functions that expect '\\0'-terminated strings. If the
        **QByteArray**  object was created from a **raw data**  that didn't
        include the trailing null-termination character then **QByteArray**
        doesn't add it automaticall unless the **deep copy**  is created.

        Example:

        **QByteArray**  ba("Hello");
            int n = ba.size();          // n == 5
        ba.data()[0];               // returns 'H'
            ba.data()[4];
        // returns 'o'
            ba.data()[5];               // returns '\\0'

        **See also** **isEmpty** () and **resize** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qbytearray.html#isNull

        **bool QByteArray::isNull() const**

        Returns `true` if this byte array is null; otherwise returns `false`.

        Example:

        **QByteArray** ().isNull();          // returns true
            **QByteArray**
        ("").isNull();        // returns false
            **QByteArray**
        ("abc").isNull();     // returns false

        Qt makes a distinction between null byte arrays and empty byte arrays
        for historical reasons. For most applications, what matters is whether
        or not a byte array contains any data, and this can be determined using
        **isEmpty** ().

        **See also** **isEmpty** ().
        """
        ...

    def length(self) -> int:
        """
        https://doc.qt.io/qt-5/qbytearray.html#length

        **int QByteArray::length() const**

        Same as **size** ().
        """
        ...

    def __len__(self) -> int:
        ...

    @staticmethod
    def fromHex(
        hexEncoded: typing.Union["QByteArray", bytes, bytearray]
    ) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#fromHex

        **[static] QByteArray QByteArray::fromHex(const QByteArray & hexEncoded
        )**

        Returns a decoded copy of the hex encoded array **hexEncoded**. Input is
        not checked for validity; invalid characters in the input are skipped,
        enabling the decoding process to continue with subsequent characters.

        For example:

        **QByteArray**  text = **QByteArray**
        ::fromHex("517420697320677265617421");
            text.data();            //
        returns "Qt is great!"

        **See also** **toHex** ().
        """
        ...

    @staticmethod
    def fromRawData(a0: bytes) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#fromRawData

        **[static] QByteArray QByteArray::fromRawData(const char * data , int
        size )**

        Constructs a **QByteArray**  that uses the first **size** bytes of the
        **data** array. The bytes are **not** copied. The **QByteArray**  will
        contain the **data** pointer. The caller guarantees that **data** will
        not be deleted or modified as long as this **QByteArray**  and any
        copies of it exist that have not been modified. In other words, because
        **QByteArray**  is an **implicitly shared**  class and the instance
        returned by this function contains the **data** pointer, the caller must
        not delete **data** or modify it directly as long as the returned
        **QByteArray**  and any copies exist. However, **QByteArray**  does not
        take ownership of **data** , so the **QByteArray**  destructor will
        never delete the raw **data** , even when the last **QByteArray**
        referring to **data** is destroyed.

        A subsequent attempt to modify the contents of the returned
        **QByteArray**  or any copy made from it will cause it to create a deep
        copy of the **data** array before doing the modification. This ensures
        that the raw **data** array itself will never be modified by
        **QByteArray** .

        Here is an example of how to read data using a **QDataStream**  on raw
        data in memory without copying the raw data into a **QByteArray** :

        static const char mydata[] = {
                '\\x00', '\\x00', '\\x03', '\\x84',
        '\\x78', '\\x9c', '\\x3b', '\\x76',
                '\\xec', '\\x18', '\\xc3', '\\x31',
        '\\x0a', '\\xf1', '\\xcc', '\\x99',
                ...
                '\\x6d', '\\x5b'
        };

            **QByteArray**  data = **QByteArray** ::fromRawData(mydata,
        sizeof(mydata));
            **QDataStream**  in(&data, **QIODevice**
        ::ReadOnly);
            ...

        **Warning:** A byte array created with fromRawData() is **not**
        '\\0'-terminated, unless the raw data contains a 0 character at position
        **size**. While that does not matter for **QDataStream**  or functions
        like **indexOf** (), passing the byte array to a function accepting a
        `const char *` expected to be '\\0'-terminated will fail.

        **See also** **setRawData** (), **data** (), and **constData** ().
        """
        ...

    @typing.overload
    @staticmethod
    def fromBase64(
        base64: typing.Union["QByteArray", bytes, bytearray]
    ) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#fromBase64

        **[static] QByteArray QByteArray::fromBase64(const QByteArray & base64 ,
        QByteArray::Base64Options options )**

        This is an overloaded function.

        Returns a decoded copy of the Base64 array **base64** , using the
        options defined by **options**. If **options** contains
        `IgnoreBase64DecodingErrors` (the default), the input is not checked for
        validity; invalid characters in the input are skipped, enabling the
        decoding process to continue with subsequent characters. If **options**
        contains `AbortOnBase64DecodingErrors`, then decoding will stop at the
        first invalid character.

        For example:

        **QByteArray** ::fromBase64("PHA+SGVsbG8/PC9wPg==", **QByteArray**
        ::Base64Encoding); // returns "<p>Hello?</p>"
            **QByteArray**
        ::fromBase64("PHA-SGVsbG8_PC9wPg==", **QByteArray**
        ::Base64UrlEncoding); // returns "<p>Hello?</p>"

        The algorithm used to decode Base64-encoded data is defined in **RFC
        4648** .

        Returns the decoded data, or, if the `AbortOnBase64DecodingErrors`
        option was passed and the input data was invalid, an empty byte array.

        **Note:** The **fromBase64Encoding** () function is recommended in new
        code.

        This function was introduced in Qt 5.2.

        **See also** **toBase64** () and **fromBase64Encoding** ().
        """
        ...

    @typing.overload
    @staticmethod
    def fromBase64(
        base64: typing.Union["QByteArray", bytes, bytearray],
        options: typing.Union["QByteArray.Base64Options", "QByteArray.Base64Option"],
    ) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#fromBase64-1

        **[static] QByteArray QByteArray::fromBase64(const QByteArray & base64
        )**

        This is an overloaded function.

        Returns a decoded copy of the Base64 array **base64**. Input is not
        checked for validity; invalid characters in the input are skipped,
        enabling the decoding process to continue with subsequent characters.

        For example:

        **QByteArray**  text = **QByteArray** ::fromBase64("UXQgaXMgZ3JlYXQh");
        text.data();            // returns "Qt is great!"

        The algorithm used to decode Base64-encoded data is defined in **RFC
        4648** .

        **Note:** The **fromBase64Encoding** () function is recommended in new
        code.

        **See also** **toBase64** () and **fromBase64Encoding** ().
        """
        ...

    @typing.overload
    @staticmethod
    def number(n: float, format: str = ..., precision: int = ...) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#number

        **[static] QByteArray QByteArray::number(int n , int base = 10)**

        Returns a byte array containing the string equivalent of the number
        **n** to base **base** (10 by default). The **base** can be any value
        between 2 and 36.

        Example:

        int n = 63;
            **QByteArray** ::number(n);              // returns "63"
        **QByteArray** ::number(n, 16);          // returns "3f"
        **QByteArray** ::number(n, 16).toUpper();  // returns "3F"

        **Note:** The format of the number is not localized; the default C
        locale is used irrespective of the user's locale.

        **See also** **setNum** () and **toInt** ().
        """
        ...

    @typing.overload
    @staticmethod
    def number(n: int, base: int = ...) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#number-1

        **[static] QByteArray QByteArray::number(uint n , int base = 10)**

        This is an overloaded function.

        **See also** **toUInt** ().
        """
        ...

    @typing.overload
    def setNum(self, n: float, format: str = ..., precision: int = ...) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#setNum

        **QByteArray &QByteArray::setNum(int n , int base = 10)**

        Sets the byte array to the printed value of **n** in base **base** (10
        by default) and returns a reference to the byte array. The **base** can
        be any value between 2 and 36. For bases other than 10, n is treated as
        an unsigned integer.

        Example:

        **QByteArray**  ba;
            int n = 63;
            ba.setNum(n);           // ba ==
        "63"
            ba.setNum(n, 16);       // ba == "3f"

        **Note:** The format of the number is not localized; the default C
        locale is used irrespective of the user's locale.

        **See also** **number** () and **toInt** ().
        """
        ...

    @typing.overload
    def setNum(self, n: int, base: int = ...) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#setNum-1

        **QByteArray &QByteArray::setNum(short n , int base = 10)**

        This is an overloaded function.

        **See also** **toShort** ().
        """
        ...

    @typing.overload
    def toBase64(self) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#toBase64

        **QByteArray QByteArray::toBase64() const**

        Returns a copy of the byte array, encoded as Base64.

        **QByteArray**  text("Qt is great!");
            text.toBase64();        //
        returns "UXQgaXMgZ3JlYXQh"

        The algorithm used to encode Base64-encoded data is defined in **RFC
        4648** .

        **See also** **fromBase64** ().
        """
        ...

    @typing.overload
    def toBase64(
        self,
        options: typing.Union["QByteArray.Base64Options", "QByteArray.Base64Option"],
    ) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#toBase64-1

        **QByteArray QByteArray::toBase64(QByteArray::Base64Options options )
        const**

        This is an overloaded function.

        Returns a copy of the byte array, encoded using the options **options**.

        **QByteArray**  text("<p>Hello?</p>");
            text.toBase64(**QByteArray**
        ::Base64Encoding | **QByteArray** ::OmitTrailingEquals);      // returns
        "PHA+SGVsbG8/PC9wPg"
            text.toBase64(**QByteArray** ::Base64Encoding);
        // returns "PHA+SGVsbG8/PC9wPg=="
            text.toBase64(**QByteArray**
        ::Base64UrlEncoding);                                    // returns
        "PHA-SGVsbG8_PC9wPg=="
            text.toBase64(**QByteArray**
        ::Base64UrlEncoding | **QByteArray** ::OmitTrailingEquals);   // returns
        "PHA-SGVsbG8_PC9wPg"

        The algorithm used to encode Base64-encoded data is defined in **RFC
        4648** .

        This function was introduced in Qt 5.2.

        **See also** **fromBase64** ().
        """
        ...

    def toDouble(self) -> typing.Tuple[float, bool]:
        """
        https://doc.qt.io/qt-5/qbytearray.html#toDouble

        **double QByteArray::toDouble(bool * ok = nullptr) const**

        Returns the byte array converted to a `double` value.

        Returns an infinity if the conversion overflows or 0.0 if the conversion
        fails for other reasons (e.g. underflow).

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        **QByteArray**  string("1234.56");
            bool ok;
            double a =
        string.toDouble(&ok);   // a == 1234.56, ok == true

            string =
        "1234.56 Volt";
            a = str.toDouble(&ok);             // a == 0, ok ==
        false

        **Warning:** The **QByteArray**  content may only contain valid
        numerical characters which includes the plus/minus sign, the character e
        used in scientific notation, and the decimal point. Including the unit
        or additional characters leads to a conversion error.

        **Note:** The conversion of the number is performed in the default C
        locale, irrespective of the user's locale.

        This function ignores leading and trailing whitespace.

        **See also** **number** ().
        """
        ...

    def toFloat(self) -> typing.Tuple[float, bool]:
        """
        https://doc.qt.io/qt-5/qbytearray.html#toFloat

        **float QByteArray::toFloat(bool * ok = nullptr) const**

        Returns the byte array converted to a `float` value.

        Returns an infinity if the conversion overflows or 0.0 if the conversion
        fails for other reasons (e.g. underflow).

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        **QByteArray**  string("1234.56");
            bool ok;
            float a =
        string.toFloat(&ok);    // a == 1234.56, ok == true

            string =
        "1234.56 Volt";
            a = str.toFloat(&ok);              // a == 0, ok ==
        false

        **Warning:** The **QByteArray**  content may only contain valid
        numerical characters which includes the plus/minus sign, the character e
        used in scientific notation, and the decimal point. Including the unit
        or additional characters leads to a conversion error.

        **Note:** The conversion of the number is performed in the default C
        locale, irrespective of the user's locale.

        This function ignores leading and trailing whitespace.

        **See also** **number** ().
        """
        ...

    def toULongLong(self, base: int = ...) -> typing.Tuple[int, bool]:
        """
        https://doc.qt.io/qt-5/qbytearray.html#toULongLong

        **qulonglong QByteArray::toULongLong(bool * ok = nullptr, int base = 10)
        const**

        Returns the byte array converted to an `unsigned long long` using base
        **base** , which is 10 by default and must be between 2 and 36, or 0.

        If **base** is 0, the base is determined automatically using the
        following rules: If the byte array begins with "0x", it is assumed to be
        hexadecimal; if it begins with "0", it is assumed to be octal; otherwise
        it is assumed to be decimal.

        Returns 0 if the conversion fails.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        **Note:** The conversion of the number is performed in the default C
        locale, irrespective of the user's locale.

        **See also** **number** ().
        """
        ...

    def toLongLong(self, base: int = ...) -> typing.Tuple[int, bool]:
        """
        https://doc.qt.io/qt-5/qbytearray.html#toLongLong

        **qlonglong QByteArray::toLongLong(bool * ok = nullptr, int base = 10)
        const**

        Returns the byte array converted to a `long long` using base **base** ,
        which is 10 by default and must be between 2 and 36, or 0.

        If **base** is 0, the base is determined automatically using the
        following rules: If the byte array begins with "0x", it is assumed to be
        hexadecimal; if it begins with "0", it is assumed to be octal; otherwise
        it is assumed to be decimal.

        Returns 0 if the conversion fails.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        **Note:** The conversion of the number is performed in the default C
        locale, irrespective of the user's locale.

        **See also** **number** ().
        """
        ...

    def toULong(self, base: int = ...) -> typing.Tuple[int, bool]:
        """
        https://doc.qt.io/qt-5/qbytearray.html#toULong

        **ulong QByteArray::toULong(bool * ok = nullptr, int base = 10) const**

        Returns the byte array converted to an `unsigned long int` using base
        **base** , which is 10 by default and must be between 2 and 36, or 0.

        If **base** is 0, the base is determined automatically using the
        following rules: If the byte array begins with "0x", it is assumed to be
        hexadecimal; if it begins with "0", it is assumed to be octal; otherwise
        it is assumed to be decimal.

        Returns 0 if the conversion fails.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        **Note:** The conversion of the number is performed in the default C
        locale, irrespective of the user's locale.

        This function was introduced in Qt 4.1.

        **See also** **number** ().
        """
        ...

    def toLong(self, base: int = ...) -> typing.Tuple[int, bool]:
        """
        https://doc.qt.io/qt-5/qbytearray.html#toLong

        **long QByteArray::toLong(bool * ok = nullptr, int base = 10) const**

        Returns the byte array converted to a `long` int using base **base** ,
        which is 10 by default and must be between 2 and 36, or 0.

        If **base** is 0, the base is determined automatically using the
        following rules: If the byte array begins with "0x", it is assumed to be
        hexadecimal; if it begins with "0", it is assumed to be octal; otherwise
        it is assumed to be decimal.

        Returns 0 if the conversion fails.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        **QByteArray**  str("FF");
            bool ok;
            long hex = str.toLong(&ok,
        16);   // hex == 255, ok == true
            long dec = str.toLong(&ok, 10);
        // dec == 0, ok == false

        **Note:** The conversion of the number is performed in the default C
        locale, irrespective of the user's locale.

        This function was introduced in Qt 4.1.

        **See also** **number** ().
        """
        ...

    def toUInt(self, base: int = ...) -> typing.Tuple[int, bool]:
        """
        https://doc.qt.io/qt-5/qbytearray.html#toUInt

        **uint QByteArray::toUInt(bool * ok = nullptr, int base = 10) const**

        Returns the byte array converted to an `unsigned int` using base
        **base** , which is 10 by default and must be between 2 and 36, or 0.

        If **base** is 0, the base is determined automatically using the
        following rules: If the byte array begins with "0x", it is assumed to be
        hexadecimal; if it begins with "0", it is assumed to be octal; otherwise
        it is assumed to be decimal.

        Returns 0 if the conversion fails.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        **Note:** The conversion of the number is performed in the default C
        locale, irrespective of the user's locale.

        **See also** **number** ().
        """
        ...

    def toInt(self, base: int = ...) -> typing.Tuple[int, bool]:
        """
        https://doc.qt.io/qt-5/qbytearray.html#toInt

        **int QByteArray::toInt(bool * ok = nullptr, int base = 10) const**

        Returns the byte array converted to an `int` using base **base** , which
        is 10 by default and must be between 2 and 36, or 0.

        If **base** is 0, the base is determined automatically using the
        following rules: If the byte array begins with "0x", it is assumed to be
        hexadecimal; if it begins with "0", it is assumed to be octal; otherwise
        it is assumed to be decimal.

        Returns 0 if the conversion fails.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        **QByteArray**  str("FF");
            bool ok;
            int hex = str.toInt(&ok,
        16);     // hex == 255, ok == true
            int dec = str.toInt(&ok, 10);
        // dec == 0, ok == false

        **Note:** The conversion of the number is performed in the default C
        locale, irrespective of the user's locale.

        **See also** **number** ().
        """
        ...

    def toUShort(self, base: int = ...) -> typing.Tuple[int, bool]:
        """
        https://doc.qt.io/qt-5/qbytearray.html#toUShort

        **ushort QByteArray::toUShort(bool * ok = nullptr, int base = 10)
        const**

        Returns the byte array converted to an `unsigned short` using base
        **base** , which is 10 by default and must be between 2 and 36, or 0.

        If **base** is 0, the base is determined automatically using the
        following rules: If the byte array begins with "0x", it is assumed to be
        hexadecimal; if it begins with "0", it is assumed to be octal; otherwise
        it is assumed to be decimal.

        Returns 0 if the conversion fails.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        **Note:** The conversion of the number is performed in the default C
        locale, irrespective of the user's locale.

        **See also** **number** ().
        """
        ...

    def toShort(self, base: int = ...) -> typing.Tuple[int, bool]:
        """
        https://doc.qt.io/qt-5/qbytearray.html#toShort

        **short QByteArray::toShort(bool * ok = nullptr, int base = 10) const**

        Returns the byte array converted to a `short` using base **base** ,
        which is 10 by default and must be between 2 and 36, or 0.

        If **base** is 0, the base is determined automatically using the
        following rules: If the byte array begins with "0x", it is assumed to be
        hexadecimal; if it begins with "0", it is assumed to be octal; otherwise
        it is assumed to be decimal.

        Returns 0 if the conversion fails.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        **Note:** The conversion of the number is performed in the default C
        locale, irrespective of the user's locale.

        **See also** **number** ().
        """
        ...

    def split(self, sep: str) -> typing.List["QByteArray"]:
        """
        https://doc.qt.io/qt-5/qbytearray.html#split

        **QList<QByteArray> QByteArray::split(char sep ) const**

        Splits the byte array into subarrays wherever **sep** occurs, and
        returns the list of those arrays. If **sep** does not match anywhere in
        the byte array, split() returns a single-element list containing this
        byte array.
        """
        ...

    @typing.overload
    def replace(
        self, index: int, len: int, s: typing.Union["QByteArray", bytes, bytearray]
    ) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#replace

        **QByteArray &QByteArray::replace(int pos , int len , const QByteArray &
        after )**

        Replaces **len** bytes from index position **pos** with the byte array
        **after** , and returns a reference to this byte array.

        Example:

        **QByteArray**  x("Say yes!");
            **QByteArray**  y("no");
        x.replace(4, 3, y);
            // x == "Say no!"

        **See also** **insert** () and **remove** ().
        """
        ...

    @typing.overload
    def replace(
        self,
        before: typing.Union["QByteArray", bytes, bytearray],
        after: typing.Union["QByteArray", bytes, bytearray],
    ) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#replace-1

        **QByteArray &QByteArray::replace(int pos , int len , const char * after
        )**

        This is an overloaded function.

        Replaces **len** bytes from index position **pos** with the
        '\\0'-terminated string **after**.

        Notice: this can change the length of the byte array.
        """
        ...

    @typing.overload
    def replace(
        self, before: str, after: typing.Union["QByteArray", bytes, bytearray]
    ) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#replace-2

        **QByteArray &QByteArray::replace(int pos , int len , const char * after
        , int alen )**

        This is an overloaded function.

        Replaces **len** bytes from index position **pos** with **alen** bytes
        from the string **after**. **after** is allowed to have '\\0' characters.

        This function was introduced in Qt 4.7.
        """
        ...

    def remove(self, index: int, len: int) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#remove

        **QByteArray &QByteArray::remove(int pos , int len )**

        Removes **len** bytes from the array, starting at index position **pos**
        , and returns a reference to the array.

        If **pos** is out of range, nothing happens. If **pos** is valid, but
        **pos** \\+ **len** is larger than the size of the array, the array is
        truncated at position **pos**.

        Example:

        **QByteArray**  ba("Montreal");
            ba.remove(1, 4);
            // ba == "Meal"

        **See also** **insert** () and **replace** ().
        """
        ...

    @typing.overload
    def insert(
        self, i: int, a: typing.Union["QByteArray", bytes, bytearray]
    ) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#insert

        **QByteArray &QByteArray::insert(int i , const QByteArray & ba )**

        Inserts the byte array **ba** at index position **i** and returns a
        reference to this byte array.

        Example:

        **QByteArray**  ba("Meal");
            ba.insert(1, **QByteArray** ("ontr"));
        // ba == "Montreal"

        **See also** **append** (), **prepend** (), **replace** (), and
        **remove** ().
        """
        ...

    @typing.overload
    def insert(self, i: int, s: str) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#insert-1

        **QByteArray &QByteArray::insert(int i , char ch )**

        This is an overloaded function.

        Inserts character **ch** at index position **i** in the byte array. If
        **i** is greater than **size** (), the array is first extended using
        **resize** ().
        """
        ...

    @typing.overload
    def insert(self, i: int, count: int, c: bytes) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#insert-2

        **QByteArray &QByteArray::insert(int i , int count , char ch )**

        This is an overloaded function.

        Inserts **count** copies of character **ch** at index position **i** in
        the byte array.

        If **i** is greater than **size** (), the array is first extended using
        **resize** ().

        This function was introduced in Qt 5.7.
        """
        ...

    @typing.overload
    def append(self, a: typing.Union["QByteArray", bytes, bytearray]) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#append

        **QByteArray &QByteArray::append(const QByteArray & ba )**

        Appends the byte array **ba** onto the end of this byte array.

        Example:

        **QByteArray**  x("free");
            **QByteArray**  y("dom");
        x.append(y);
            // x == "freedom"

        This is the same as insert(**size** (), **ba** ).

        Note: **QByteArray**  is an **implicitly shared**  class. Consequently,
        if you append to an empty byte array, then the byte array will just
        share the data held in **ba**. In this case, no copying of data is done,
        taking **constant time** . If a shared instance is modified, it will be
        copied (copy-on-write), taking **linear time** .

        If the byte array being appended to is not empty, a deep copy of the
        data is performed, taking **linear time** .

        This operation typically does not suffer from allocation overhead,
        because **QByteArray**  preallocates extra space at the end of the data
        so that it may grow without reallocating for each append operation.

        **See also** **operator+=** (), **prepend** (), and **insert** ().
        """
        ...

    @typing.overload
    def append(self, s: str) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#append-1

        **QByteArray &QByteArray::append(char ch )**

        This is an overloaded function.

        Appends the character **ch** to this byte array.
        """
        ...

    @typing.overload
    def append(self, count: int, c: bytes) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#append-2

        **QByteArray &QByteArray::append(int count , char ch )**

        This is an overloaded function.

        Appends **count** copies of character **ch** to this byte array and
        returns a reference to this byte array.

        If **count** is negative or zero nothing is appended to the byte array.

        This function was introduced in Qt 5.7.
        """
        ...

    @typing.overload
    def prepend(self, a: typing.Union["QByteArray", bytes, bytearray]) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#prepend

        **QByteArray &QByteArray::prepend(const QByteArray & ba )**

        Prepends the byte array **ba** to this byte array and returns a
        reference to this byte array.

        Example:

        **QByteArray**  x("ship");
            **QByteArray**  y("air");
        x.prepend(y);
            // x == "airship"

        This is the same as insert(0, **ba** ).

        Note: **QByteArray**  is an **implicitly shared**  class. Consequently,
        if you prepend to an empty byte array, then the byte array will just
        share the data held in **ba**. In this case, no copying of data is done,
        taking **constant time** . If a shared instance is modified, it will be
        copied (copy-on-write), taking **linear time** .

        If the byte array being prepended to is not empty, a deep copy of the
        data is performed, taking **linear time** .

        **See also** **append** () and **insert** ().
        """
        ...

    @typing.overload
    def prepend(self, count: int, c: bytes) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#prepend-1

        **QByteArray &QByteArray::prepend(char ch )**

        This is an overloaded function.

        Prepends the character **ch** to this byte array.
        """
        ...

    def rightJustified(
        self, width: int, fill: str = ..., truncate: bool = ...
    ) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#rightJustified

        **QByteArray QByteArray::rightJustified(int width , char fill = ' ',
        bool truncate = false) const**

        Returns a byte array of size **width** that contains the **fill**
        character followed by this byte array.

        If **truncate** is false and the size of the byte array is more than
        **width** , then the returned byte array is a copy of this byte array.

        If **truncate** is true and the size of the byte array is more than
        **width** , then the resulting byte array is truncated at position
        **width**.

        Example:

        **QByteArray**  x("apple");
            **QByteArray**  y = x.rightJustified(8,
        '.');    // y == "...apple"

        **See also** **leftJustified** ().
        """
        ...

    def leftJustified(
        self, width: int, fill: str = ..., truncate: bool = ...
    ) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#leftJustified

        **QByteArray QByteArray::leftJustified(int width , char fill = ' ', bool
        truncate = false) const**

        Returns a byte array of size **width** that contains this byte array
        padded by the **fill** character.

        If **truncate** is false and the **size** () of the byte array is more
        than **width** , then the returned byte array is a copy of this byte
        array.

        If **truncate** is true and the **size** () of the byte array is more
        than **width** , then any bytes in a copy of the byte array after
        position **width** are removed, and the copy is returned.

        Example:

        **QByteArray**  x("apple");
            **QByteArray**  y = x.leftJustified(8,
        '.');   // y == "apple..."

        **See also** **rightJustified** ().
        """
        ...

    def simplified(self) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#simplified

        **QByteArray QByteArray::simplified() const**

        Returns a byte array that has whitespace removed from the start and the
        end, and which has each sequence of internal whitespace replaced with a
        single space.

        Whitespace means any character for which the standard C++ `isspace()`
        function returns `true` in the C locale. This includes the ASCII
        isspace() function returns `true` in the C locale. This includes the
        ASCII characters '\\t', '\\n', '\\v', '\\f', '\\r', and ' '.

        Example:

        **QByteArray**  ba("  lots\\t of\\nwhitespace\\r\\n ");
            ba =
        ba.simplified();
            // ba == "lots of whitespace";

        **See also** **trimmed** ().
        """
        ...

    def trimmed(self) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#trimmed

        **QByteArray QByteArray::trimmed() const**

        Returns a byte array that has whitespace removed from the start and the
        end.

        Whitespace means any character for which the standard C++ `isspace()`
        function returns `true` in the C locale. This includes the ASCII
        characters '\\t', '\\n', '\\v', '\\f', '\\r', and ' '.

        Example:

        **QByteArray**  ba("  lots\\t of\\nwhitespace\\r\\n ");
            ba =
        ba.trimmed();
            // ba == "lots\\t of\\nwhitespace";

        Unlike **simplified** (), trimmed() leaves internal whitespace alone.

        **See also** **simplified** ().
        """
        ...

    def toUpper(self) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#toUpper

        **QByteArray QByteArray::toUpper() const**

        Returns an uppercase copy of the byte array. The bytearray is
        interpreted as a Latin-1 encoded string.

        Example:

        **QByteArray**  x("Qt by THE QT COMPANY");
            **QByteArray**  y =
        x.toUpper();
            // y == "QT BY THE QT COMPANY"

        **See also** **isUpper** (), **toLower** (), and **8-bit Character
        Comparisons** .
        """
        ...

    def toLower(self) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#toLower

        **QByteArray QByteArray::toLower() const**

        Returns a lowercase copy of the byte array. The bytearray is interpreted
        as a Latin-1 encoded string.

        Example:

        **QByteArray**  x("Qt by THE QT COMPANY");
            **QByteArray**  y =
        x.toLower();
            // y == "qt by the qt company"

        **See also** **isLower** (), **toUpper** (), and **8-bit Character
        Comparisons** .
        """
        ...

    def chop(self, n: int) -> None:
        """
        https://doc.qt.io/qt-5/qbytearray.html#chop

        **void QByteArray::chop(int n )**

        Removes **n** bytes from the end of the byte array.

        If **n** is greater than **size** (), the result is an empty byte array.

        Example:

        **QByteArray**  ba("STARTTLS\\r\\n");
            ba.chop(2);                 //
        ba == "STARTTLS"

        **See also** **truncate** (), **resize** (), and **left** ().
        """
        ...

    def truncate(self, pos: int) -> None:
        """
        https://doc.qt.io/qt-5/qbytearray.html#truncate

        **void QByteArray::truncate(int pos )**

        Truncates the byte array at index position **pos**.

        If **pos** is beyond the end of the array, nothing happens.

        Example:

        **QByteArray**  ba("Stockholm");
            ba.truncate(5);             // ba
        == "Stock"

        **See also** **chop** (), **resize** (), and **left** ().
        """
        ...

    def endsWith(self, a: typing.Union["QByteArray", bytes, bytearray]) -> bool:
        """
        https://doc.qt.io/qt-5/qbytearray.html#endsWith

        **bool QByteArray::endsWith(const QByteArray & ba ) const**

        Returns `true` if this byte array ends with byte array **ba** ;
        otherwise returns `false`.

        Example:

        **QByteArray**  url("http://qt-
        project.org/doc/qt-5.0/qtdoc/index.html");
            if
        (url.endsWith(".html"))
                ...

        **See also** **startsWith** () and **right** ().
        """
        ...

    def startsWith(self, a: typing.Union["QByteArray", bytes, bytearray]) -> bool:
        """
        https://doc.qt.io/qt-5/qbytearray.html#startsWith

        **bool QByteArray::startsWith(const QByteArray & ba ) const**

        Returns `true` if this byte array starts with byte array **ba** ;
        otherwise returns `false`.

        Example:

        **QByteArray**  url("ftp://ftp.qt-project.org/");
            if
        (url.startsWith("ftp:"))
                ...

        **See also** **endsWith** () and **left** ().
        """
        ...

    def mid(self, pos: int, length: int = ...) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#mid

        **QByteArray QByteArray::mid(int pos , int len = -1) const**

        Returns a byte array containing **len** bytes from this byte array,
        starting at position **pos**.

        If **len** is -1 (the default), or **pos** \\+ **len** >= **size** (),
        returns a byte array containing all bytes starting at position **pos**
        until the end of the byte array.

        Example:

        **QByteArray**  x("Five pineapples");
            **QByteArray**  y = x.mid(5,
        4);     // y == "pine"
            **QByteArray**  z = x.mid(5);        // z ==
        "pineapples"

        **See also** **left** (), **right** (), **chopped** (), **chop** (), and
        **truncate** ().
        """
        ...

    def right(self, len: int) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#right

        **QByteArray QByteArray::right(int len ) const**

        Returns a byte array that contains the rightmost **len** bytes of this
        byte array.

        The entire byte array is returned if **len** is greater than **size**
        ().

        Example:

        **QByteArray**  x("Pineapple");
            **QByteArray**  y = x.right(5);
        // y == "apple"

        **See also** **endsWith** (), **left** (), **mid** (), **chopped** (),
        **chop** (), and **truncate** ().
        """
        ...

    def left(self, len: int) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#left

        **QByteArray QByteArray::left(int len ) const**

        Returns a byte array that contains the leftmost **len** bytes of this
        byte array.

        The entire byte array is returned if **len** is greater than **size**
        ().

        Example:

        **QByteArray**  x("Pineapple");
            **QByteArray**  y = x.left(4);
        // y == "Pine"

        **See also** **startsWith** (), **right** (), **mid** (), **chopped**
        (), **chop** (), and **truncate** ().
        """
        ...

    @typing.overload
    def count(self, a: typing.Union["QByteArray", bytes, bytearray]) -> int:
        """
        https://doc.qt.io/qt-5/qbytearray.html#count

        **int QByteArray::count(const QByteArray & ba ) const**

        Returns the number of (potentially overlapping) occurrences of byte
        array **ba** in this byte array.

        **See also** **contains** () and **indexOf** ().
        """
        ...

    @typing.overload
    def count(self) -> int:
        """
        https://doc.qt.io/qt-5/qbytearray.html#count-1

        **int QByteArray::count(char ch ) const**

        This is an overloaded function.

        Returns the number of occurrences of character **ch** in the byte array.

        **See also** **contains** () and **indexOf** ().
        """
        ...

    @typing.overload
    def lastIndexOf(
        self, ba: typing.Union["QByteArray", bytes, bytearray], from_: int = ...
    ) -> int:
        """
        https://doc.qt.io/qt-5/qbytearray.html#lastIndexOf

        **int QByteArray::lastIndexOf(const QByteArray & ba , int from = -1)
        const**

        Returns the index position of the last occurrence of the byte array
        **ba** in this byte array, searching backward from index position
        **from**. If **from** is -1 (the default), the search starts at the last
        byte. Returns -1 if **ba** could not be found.

        Example:

        **QByteArray**  x("crazy azimuths");
            **QByteArray**  y("az");
        x.lastIndexOf(y);           // returns 6
            x.lastIndexOf(y, 6);
        // returns 6
            x.lastIndexOf(y, 5);        // returns 2
        x.lastIndexOf(y, 1);        // returns -1

        **See also** **indexOf** (), **contains** (), and **count** ().
        """
        ...

    @typing.overload
    def lastIndexOf(self, str: str, from_: int = ...) -> int:
        """
        https://doc.qt.io/qt-5/qbytearray.html#lastIndexOf-1

        **int QByteArray::lastIndexOf(char ch , int from = -1) const**

        This is an overloaded function.

        Returns the index position of the last occurrence of character **ch** in
        the byte array, searching backward from index position **from**. If
        **from** is -1 (the default), the search starts at the last (**size** ()
        - 1) byte. Returns -1 if **ch** could not be found.

        Example:

        **QByteArray**  ba("ABCBA");
            ba.lastIndexOf("B");        // returns
        3
            ba.lastIndexOf("B", 3);     // returns 3
            ba.lastIndexOf("B",
        2);     // returns 1
            ba.lastIndexOf("X");        // returns -1

        **See also** **indexOf** () and **contains** ().
        """
        ...

    @typing.overload
    def indexOf(
        self, ba: typing.Union["QByteArray", bytes, bytearray], from_: int = ...
    ) -> int:
        """
        https://doc.qt.io/qt-5/qbytearray.html#indexOf

        **int QByteArray::indexOf(const QByteArray & ba , int from = 0) const**

        Returns the index position of the first occurrence of the byte array
        **ba** in this byte array, searching forward from index position
        **from**. Returns -1 if **ba** could not be found.

        Example:

        **QByteArray**  x("sticky question");
            **QByteArray**  y("sti");
        x.indexOf(y);               // returns 0
            x.indexOf(y, 1);
        // returns 10
            x.indexOf(y, 10);           // returns 10
        x.indexOf(y, 11);           // returns -1

        **See also** **lastIndexOf** (), **contains** (), and **count** ().
        """
        ...

    @typing.overload
    def indexOf(self, str: str, from_: int = ...) -> int:
        """
        https://doc.qt.io/qt-5/qbytearray.html#indexOf-1

        **int QByteArray::indexOf(char ch , int from = 0) const**

        This is an overloaded function.

        Returns the index position of the first occurrence of the character
        **ch** in the byte array, searching forward from index position
        **from**. Returns -1 if **ch** could not be found.

        Example:

        **QByteArray**  ba("ABCBA");
            ba.indexOf("B");            // returns
        1
            ba.indexOf("B", 1);         // returns 1
            ba.indexOf("B", 2);
        // returns 3
            ba.indexOf("X");            // returns -1

        **See also** **lastIndexOf** () and **contains** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qbytearray.html#clear

        **void QByteArray::clear()**

        Clears the contents of the byte array and makes it null.

        **See also** **resize** () and **isNull** ().
        """
        ...

    def fill(self, ch: str, size: int = ...) -> "QByteArray":
        """
        https://doc.qt.io/qt-5/qbytearray.html#fill

        **QByteArray &QByteArray::fill(char ch , int size = -1)**

        Sets every byte in the byte array to character **ch**. If **size** is
        different from -1 (the default), the byte array is resized to size
        **size** beforehand.

        Example:

        **QByteArray**  ba("Istambul");
            ba.fill('o');
            // ba ==
        "oooooooo"

            ba.fill('X', 2);
            // ba == "XX"

        **See also** **resize** ().
        """
        ...

    def resize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-5/qbytearray.html#resize

        **void QByteArray::resize(int size )**

        Sets the size of the byte array to **size** bytes.

        If **size** is greater than the current size, the byte array is extended
        to make it **size** bytes with the extra bytes added to the end. The new
        bytes are uninitialized.

        If **size** is less than the current size, bytes are removed from the
        end.

        **See also** **size** () and **truncate** ().
        """
        ...
