"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import sip


class QBitArray(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qbitarray.html

    **Detailed Description**

    A QBitArray is an array that gives access to individual bits and provides
    operators (**AND** , **OR** , **XOR** , and **NOT** ) that work on entire
    arrays of bits. It uses **implicit sharing**  (copy-on-write) to reduce
    memory usage and to avoid the needless copying of data.

    The following code constructs a QBitArray containing 200 bits initialized to
    false (0):

    **QBitArray**  ba(200);

    To initialize the bits to true, either pass `true` as second argument to the
    constructor, or call **fill** () later on.

    QBitArray uses 0-based indexes, just like C++ arrays. To access the bit at a
    particular index position, you can use operator[](). On non-const bit
    arrays, operator[]() returns a reference to a bit that can be used on the
    left side of an assignment. For example:

    **QBitArray**  ba;
        ba.resize(3);
        ba[0] = true;
        ba[1] = false;
    ba[2] = true;

    For technical reasons, it is more efficient to use **testBit** () and
    **setBit** () to access bits in the array than operator[](). For example:

    **QBitArray**  ba(3);
        ba.setBit(0, true);
        ba.setBit(1, false);
    ba.setBit(2, true);

    QBitArray supports `&` (**AND** ), `|` (**OR** ), `^` (**XOR** ), `~`
    (**NOT** ), as well as `&=`, `|=`, and `^=`. These operators work in the
    same way as the built-in C++ bitwise operators of the same name. For
    example:

    **QBitArray**  x(5);
        x.setBit(3, true);
        // x: [ 0, 0, 0, 1, 0 ]
    **QBitArray**  y(5);
        y.setBit(4, true);
        // y: [ 0, 0, 0, 0, 1 ]
    x |= y;
        // x: [ 0, 0, 0, 1, 1 ]

    For historical reasons, QBitArray distinguishes between a null bit array and
    an empty bit array. A **null** bit array is a bit array that is initialized
    using QBitArray's default constructor. An **empty** bit array is any bit
    array with size 0. A null bit array is always empty, but an empty bit array
    isn't necessarily null:

    **QBitArray** ().isNull();           // returns true
        **QBitArray**
    ().isEmpty();          // returns true

        **QBitArray** (0).isNull();
    // returns false
        **QBitArray** (0).isEmpty();         // returns true
    **QBitArray** (3).isNull();          // returns false
        **QBitArray**
    (3).isEmpty();         // returns false

    All functions except **isNull** () treat null bit arrays the same as empty
    bit arrays; for example, QBitArray() compares equal to QBitArray(0). We
    recommend that you always use **isEmpty** () and avoid **isNull** ().

    **See also** **QByteArray**  and **QVector** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qbitarray.html#QBitArray

        **QBitArray::QBitArray()**

        Constructs an empty bit array.

        **See also** **isEmpty** ().
        """
        ...

    @typing.overload
    def __init__(self, size: int, value: bool = ...) -> None:
        """
        https://doc.qt.io/qt-5/qbitarray.html#QBitArray-1

        **QBitArray::QBitArray(int size , bool value = false)**

        Constructs a bit array containing **size** bits. The bits are
        initialized with **value** , which defaults to false (0).
        """
        ...

    @typing.overload
    def __init__(self, other: "QBitArray") -> None:
        """
        https://doc.qt.io/qt-5/qbitarray.html#QBitArray-2

        **QBitArray::QBitArray(const QBitArray & other )**

        Constructs a copy of **other**.

        This operation takes **constant time** , because QBitArray is
        **implicitly shared** . This makes returning a QBitArray from a function
        very fast. If a shared instance is modified, it will be copied (copy-on-
        write), and that takes **linear time** .

        **See also** **operator=** ().
        """
        ...

    @staticmethod
    def fromBits(data: bytes, len: int) -> "QBitArray":
        """
        https://doc.qt.io/qt-5/qbitarray.html#fromBits

        **[static] QBitArray QBitArray::fromBits(const char * data , qsizetype
        size )**

        Creates a **QBitArray**  with the dense bit array located at **data** ,
        with **size** bits. The byte array at **data** must be at least **size**
        / 8 (rounded up) bytes long.

        If **size** is not a multiple of 8, this function will include the
        lowest **size** % 8 bits from the last byte in **data**.

        This function was introduced in Qt 5.11.

        **See also** **bits** ().
        """
        ...

    def bits(self) -> bytes:
        """
        https://doc.qt.io/qt-5/qbitarray.html#bits

        **const char *QBitArray::bits() const**

        Returns a pointer to a dense bit array for this **QBitArray** . Bits are
        counted upwards from the least significant bit in each byte. The number
        of bits relevant in the last byte is given by `size() % 8`.

        This function was introduced in Qt 5.11.

        **See also** **fromBits** () and **size** ().
        """
        ...

    def swap(self, other: "QBitArray") -> None:
        """
        https://doc.qt.io/qt-5/qbitarray.html#swap

        **void QBitArray::swap(QBitArray & other )**

        Swaps bit array **other** with this bit array. This operation is very
        fast and never fails.

        This function was introduced in Qt 4.8.
        """
        ...

    def __hash__(self) -> int:
        ...

    def at(self, i: int) -> bool:
        """
        https://doc.qt.io/qt-5/qbitarray.html#at

        **bool QBitArray::at(int i ) const**

        Returns the value of the bit at index position **i**.

        **i** must be a valid index position in the bit array (i.e., 0 <= **i**
        < **size** ()).

        **See also** **operator[]** ().
        """
        ...

    def __getitem__(self, i: int) -> bool:
        ...

    def toggleBit(self, i: int) -> bool:
        """
        https://doc.qt.io/qt-5/qbitarray.html#toggleBit

        **bool QBitArray::toggleBit(int i )**

        Inverts the value of the bit at index position **i** , returning the
        previous value of that bit as either true (if it was set) or false (if
        it was unset).

        If the previous value was 0, the new value will be 1. If the previous
        value was 1, the new value will be 0.

        **i** must be a valid index position in the bit array (i.e., 0 <= **i**
        < **size** ()).

        **See also** **setBit** () and **clearBit** ().
        """
        ...

    def clearBit(self, i: int) -> None:
        """
        https://doc.qt.io/qt-5/qbitarray.html#clearBit

        **void QBitArray::clearBit(int i )**

        Sets the bit at index position **i** to 0.

        **i** must be a valid index position in the bit array (i.e., 0 <= **i**
        < **size** ()).

        **See also** **setBit** () and **toggleBit** ().
        """
        ...

    @typing.overload
    def setBit(self, i: int) -> None:
        """
        https://doc.qt.io/qt-5/qbitarray.html#setBit

        **void QBitArray::setBit(int i )**

        Sets the bit at index position **i** to 1.

        **i** must be a valid index position in the bit array (i.e., 0 <= **i**
        < **size** ()).

        **See also** **clearBit** () and **toggleBit** ().
        """
        ...

    @typing.overload
    def setBit(self, i: int, val: bool) -> None:
        """
        https://doc.qt.io/qt-5/qbitarray.html#setBit-1

        **void QBitArray::setBit(int i , bool value )**

        This is an overloaded function.

        Sets the bit at index position **i** to **value**.
        """
        ...

    def testBit(self, i: int) -> bool:
        """
        https://doc.qt.io/qt-5/qbitarray.html#testBit

        **bool QBitArray::testBit(int i ) const**

        Returns `true` if the bit at index position **i** is 1; otherwise
        returns `false`.

        **i** must be a valid index position in the bit array (i.e., 0 <= **i**
        < **size** ()).

        **See also** **setBit** () and **clearBit** ().
        """
        ...

    def truncate(self, pos: int) -> None:
        """
        https://doc.qt.io/qt-5/qbitarray.html#truncate

        **void QBitArray::truncate(int pos )**

        Truncates the bit array at index position **pos**.

        If **pos** is beyond the end of the array, nothing happens.

        **See also** **resize** ().
        """
        ...

    @typing.overload
    def fill(self, val: bool, first: int, last: int) -> None:
        """
        https://doc.qt.io/qt-5/qbitarray.html#fill

        **bool QBitArray::fill(bool value , int size = -1)**

        Sets every bit in the bit array to **value** , returning true if
        successful; otherwise returns `false`. If **size** is different from -1
        (the default), the bit array is resized to **size** beforehand.

        Example:

        **QBitArray**  ba(8);
            ba.fill(true);
            // ba: [ 1, 1, 1, 1, 1, 1,
        1, 1 ]

            ba.fill(false, 2);
            // ba: [ 0, 0 ]

        **See also** **resize** ().
        """
        ...

    @typing.overload
    def fill(self, value: bool, size: int = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qbitarray.html#fill-1

        **void QBitArray::fill(bool value , int begin , int end )**

        This is an overloaded function.

        Sets bits at index positions **begin** up to (but not including) **end**
        to **value**.

        **begin** must be a valid index position in the bit array (0 <=
        **begin** < **size** ()).

        **end** must be either a valid index position or equal to **size** (),
        in which case the fill operation runs until the end of the array (0 <=
        **end** <= **size** ()).

        Example:

        **QBitArray**  ba(4);
            ba.fill(true, 1, 2);            // ba: [ 0, 1,
        0, 0 ]
            ba.fill(true, 1, 3);            // ba: [ 0, 1, 1, 0 ]
        ba.fill(true, 1, 4);            // ba: [ 0, 1, 1, 1 ]
        """
        ...

    def __invert__(self) -> "QBitArray":
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qbitarray.html#clear

        **void QBitArray::clear()**

        Clears the contents of the bit array and makes it empty.

        **See also** **resize** () and **isEmpty** ().
        """
        ...

    def isDetached(self) -> bool:
        ...

    def detach(self) -> None:
        ...

    def resize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-5/qbitarray.html#resize

        **void QBitArray::resize(int size )**

        Resizes the bit array to **size** bits.

        If **size** is greater than the current size, the bit array is extended
        to make it **size** bits with the extra bits added to the end. The new
        bits are initialized to false (0).

        If **size** is less than the current size, bits are removed from the
        end.

        **See also** **size** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qbitarray.html#isNull

        **bool QBitArray::isNull() const**

        Returns `true` if this bit array is null; otherwise returns `false`.

        Example:

        **QBitArray** ().isNull();           // returns true
            **QBitArray**
        (0).isNull();          // returns false
            **QBitArray** (3).isNull();
        // returns false

        Qt makes a distinction between null bit arrays and empty bit arrays for
        historical reasons. For most applications, what matters is whether or
        not a bit array contains any data, and this can be determined using
        **isEmpty** ().

        **See also** **isEmpty** ().
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-5/qbitarray.html#isEmpty

        **bool QBitArray::isEmpty() const**

        Returns `true` if this bit array has size 0; otherwise returns false.

        **See also** **size** ().
        """
        ...

    def __len__(self) -> int:
        ...

    @typing.overload
    def count(self) -> int:
        """
        https://doc.qt.io/qt-5/qbitarray.html#count

        **int QBitArray::count() const**

        Same as **size** ().
        """
        ...

    @typing.overload
    def count(self, on: bool) -> int:
        """
        https://doc.qt.io/qt-5/qbitarray.html#count-1

        **int QBitArray::count(bool on ) const**

        If **on** is true, this function returns the number of 1-bits stored in
        the bit array; otherwise the number of 0-bits is returned.
        """
        ...

    def size(self) -> int:
        """
        https://doc.qt.io/qt-5/qbitarray.html#size

        **int QBitArray::size() const**

        Returns the number of bits stored in the bit array.

        **See also** **resize** ().
        """
        ...
