"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5.QtCore import *
from PyQt5 import sip


class QAbstractNativeEventFilter(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qabstractnativeeventfilter.html

    **Detailed Description**
    """

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qabstractnativeeventfilter.html#QAbstractNativeEv
        entFilter

        **QAbstractNativeEventFilter::QAbstractNativeEventFilter()**

        Creates a native event filter.

        By default this doesn't do anything. Remember to install it on the
        application object.
        """
        ...

    def nativeEventFilter(
        self,
        eventType: typing.Union["QByteArray", bytes, bytearray],
        message: PyQt5.sip.voidptr,
    ) -> typing.Tuple[bool, int]:
        """
        https://doc.qt.io/qt-5/qabstractnativeeventfilter.html#nativeEventFilter

        **[pure virtual] bool
        QAbstractNativeEventFilter::nativeEventFilter(const QByteArray &
        eventType , void * message , long * result )**

        This method is called for every native event.

        **Note:** The filter function here receives native messages, for
        example, MSG or XCB event structs.

        It is called by the QPA platform plugin. On Windows, it is called by the
        event dispatcher.

        The type of event **eventType** is specific to the platform plugin
        chosen at run-time, and can be used to cast **message** to the right
        type.

        On X11, **eventType** is set to "xcb_generic_event_t", and the
        **message** can be casted to a xcb_generic_event_t pointer.

        On Windows, **eventType** is set to "windows_generic_MSG" for messages
        sent to toplevel windows, and "windows_dispatcher_MSG" for system-wide
        messages such as messages from a registered hot key. In both cases, the
        **message** can be casted to a MSG pointer. The **result** pointer is
        only used on Windows, and corresponds to the LRESULT pointer.

        On macOS, **eventType** is set to "mac_generic_NSEvent", and the
        **message** can be casted to an NSEvent pointer.

        In your reimplementation of this function, if you want to filter the
        **message** out, i.e. stop it being handled further, return true;
        otherwise return false.

        **Linux example**

        class MyXcbEventFilter : public **QAbstractNativeEventFilter**
            {
        public:
                bool nativeEventFilter(const **QByteArray**  &eventType,
        void *message, long *) override
                {
                    if (eventType ==
        "xcb_generic_event_t") {
                        xcb_generic_event_t* ev =
        static_cast<xcb_generic_event_t \\*>(message);
                        // ...
        }
                    return false;
                }
            };

        **macOS example**

        mycocoaeventfilter.h:

        #include <QAbstractNativeEventFilter>

            class MyCocoaEventFilter
        : public **QAbstractNativeEventFilter**
            {
            public:
                bool
        nativeEventFilter(const **QByteArray**  &eventType, void *message, long
        *) override;
            };

        mycocoaeventfilter.mm:

        #include "mycocoaeventfilter.h"

            #import <AppKit/AppKit.h>
        bool CocoaNativeEventFilter::nativeEventFilter(const QByteArray
        &eventType, void *message, long *)
            {
                if (eventType ==
        "mac_generic_NSEvent") {
                    NSEvent *event =
        static_cast<NSEvent \\*>(message);
                    if ([event type] ==
        NSKeyDown) {
                        // Handle key event
        qDebug() << QString::fromNSString([event characters]);
                    }
        }
                return false;
            }

        myapp.pro:

        HEADERS += mycocoaeventfilter.h
            OBJECTIVE_SOURCES +=
        mycocoaeventfilter.mm
            LIBS += -framework AppKit
        """
        ...
