"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip


class QLowEnergyConnectionParameters(PyQt5.sip.wrapper):
    """
    https://doc.qt.io/qt-5/qlowenergyconnectionparameters.html

    **Detailed Description**

    The connection parameters influence how often a master and a slave device
    synchronize with each other. In general, a lower connection interval and
    latency means faster communication, but also higher power consumption. How
    these criteria should be weighed against each other is highly dependent on
    the concrete use case.

    Android only indirectly permits the adjustment of this parameter set. The
    platform separates the connection parameters into three categories (hight,
    low & balanced priority). Each category implies a predefined set of values
    for **minimumInterval** (), **maximumInterval** () and **latency** ().
    Additionally, the value ranges of each category can vary from one Android
    device to the next. Qt uses the **minimumInterval** () to determine the
    target category as follows:

    **minimumInterval** ()Android priority
    interval <
    30CONNECTION_PRIORITY_HIGH
    30 <= interval <=
    100CONNECTION_PRIORITY_BALANCED
    interval >
    100CONNECTION_PRIORITY_LOW_POWER

    The **supervisionTimeout** () cannot be changed on Android and is therefore
    ignored.

    **See also** **QLowEnergyController::requestConnectionUpdate**  and
    **QLowEnergyController::connectionUpdated** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qlowenergyconnectionparameters.html#QLowEnergyCon
        nectionParameters

        **QLowEnergyConnectionParameters::QLowEnergyConnectionParameters()**

        Constructs a new object of this class. All values are initialized to
        valid defaults.
        """
        ...

    @typing.overload
    def __init__(self, other: "QLowEnergyConnectionParameters") -> None:
        """
        https://doc.qt.io/qt-5/qlowenergyconnectionparameters.html#QLowEnergyCon
        nectionParameters-1

        **QLowEnergyConnectionParameters::QLowEnergyConnectionParameters(const
        QLowEnergyConnectionParameters & other )**

        Constructs a new object of this class that is a copy of **other**.
        """
        ...

    def swap(self, other: "QLowEnergyConnectionParameters") -> None:
        """
        https://doc.qt.io/qt-5/qlowenergyconnectionparameters.html#swap

        **void
        QLowEnergyConnectionParameters::swap(QLowEnergyConnectionParameters &
        other )**

        Swaps this object with **other**.
        """
        ...

    def supervisionTimeout(self) -> int:
        """
        https://doc.qt.io/qt-5/qlowenergyconnectionparameters.html#supervisionTi
        meout

        **int QLowEnergyConnectionParameters::supervisionTimeout() const**

        Returns the link supervision timeout of the connection in milliseconds.

        **See also** **setSupervisionTimeout** ().
        """
        ...

    def setSupervisionTimeout(self, timeout: int) -> None:
        """
        https://doc.qt.io/qt-5/qlowenergyconnectionparameters.html#setSupervisio
        nTimeout

        **void QLowEnergyConnectionParameters::setSupervisionTimeout(int timeout
        )**

        Sets the link supervision timeout to **timeout** milliseconds. There are
        several constraints on this value: It must be in the range [100,32000]
        and it must be larger than (1 + **latency** ()) * 2 *
        **maximumInterval** ().

        On Android, this timeout is not adjustable and therefore ignored.

        **See also** **supervisionTimeout** ().
        """
        ...

    def latency(self) -> int:
        """
        https://doc.qt.io/qt-5/qlowenergyconnectionparameters.html#latency

        **int QLowEnergyConnectionParameters::latency() const**

        Returns the slave latency of the connection.

        **See also** **setLatency** ().
        """
        ...

    def setLatency(self, latency: int) -> None:
        """
        https://doc.qt.io/qt-5/qlowenergyconnectionparameters.html#setLatency

        **void QLowEnergyConnectionParameters::setLatency(int latency )**

        Sets the slave latency of the connection (that is, the number of
        connection events that a slave device is allowed to ignore) to
        **latency**. The minimum value is 0, the maximum is 499.

        **See also** **latency** ().
        """
        ...

    def maximumInterval(self) -> float:
        """
        https://doc.qt.io/qt-5/qlowenergyconnectionparameters.html#maximumInterv
        al

        **double QLowEnergyConnectionParameters::maximumInterval() const**

        Returns the maximum connection interval in milliseconds. The default is
        4000.

        **Note:** If this object was emitted via
        **QLowEnergyController::connectionUpdated** (), then this value is the
        same as **minimumInterval** () and refers to the actual connection
        interval.

        **See also** **setIntervalRange** ().
        """
        ...

    def minimumInterval(self) -> float:
        """
        https://doc.qt.io/qt-5/qlowenergyconnectionparameters.html#minimumInterv
        al

        **double QLowEnergyConnectionParameters::minimumInterval() const**

        Returns the minimum connection interval in milliseconds. The default is
        7.5.

        **Note:** If this object was emitted via
        **QLowEnergyController::connectionUpdated** (), then this value is the
        same as **maximumInterval** () and refers to the actual connection
        interval.

        **See also** **setIntervalRange** ().
        """
        ...

    def setIntervalRange(self, minimum: float, maximum: float) -> None:
        """
        https://doc.qt.io/qt-5/qlowenergyconnectionparameters.html#setIntervalRa
        nge

        **void QLowEnergyConnectionParameters::setIntervalRange(double minimum ,
        double maximum )**

        Sets the range in which the connection interval should be. The actual
        value will be decided by the controller. Both **minimum** and
        **maximum** are given in milliseconds. If **maximum** is smaller than
        **minimum** , it will be set to the value of **minimum**. The smallest
        possible connection interval is 7.5 milliseconds, the largest one is
        4000 milliseconds.

        **See also** **minimumInterval** () and **maximumInterval** ().
        """
        ...
