"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtBluetooth import *


class QBluetoothTransferReply(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qbluetoothtransferreply.html

    **Detailed Description**

    In additional to a copy of the **QBluetoothTransferRequest**  object used to
    create the request, QBluetoothTransferReply contains the contents of the
    reply itself.

    After the file transfer has started, QBluetoothTransferReply emits the
    **transferProgress** () signal, which indicates the progress of the file
    transfer.
    """

    class TransferError(int):
        NoError: QBluetoothTransferReply = ...
        UnknownError: QBluetoothTransferReply = ...
        FileNotFoundError: QBluetoothTransferReply = ...
        HostNotFoundError: QBluetoothTransferReply = ...
        UserCanceledTransferError: QBluetoothTransferReply = ...
        IODeviceNotReadableError: QBluetoothTransferReply = ...
        ResourceBusyError: QBluetoothTransferReply = ...
        SessionError: QBluetoothTransferReply = ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothtransferreply.html#QBluetoothTransferRe
        ply

        **[protected] QBluetoothTransferReply::QBluetoothTransferReply(QObject *
        parent = nullptr)**

        Constructs a new QBluetoothTransferReply with **parent**.
        """
        ...

    def setRequest(self, request: "QBluetoothTransferRequest") -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothtransferreply.html#setRequest

        **[protected] void QBluetoothTransferReply::setRequest(const
        QBluetoothTransferRequest & request )**

        Set the reply's request to **request**.

        **See also** **request** ().
        """
        ...

    def setManager(self, manager: QBluetoothTransferManager) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothtransferreply.html#setManager

        **[protected] void
        QBluetoothTransferReply::setManager(QBluetoothTransferManager * manager
        )**

        Set the reply's manager to the **manager**.

        **See also** **manager** ().
        """
        ...

    def abort(self) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothtransferreply.html#abort

        **[slot] void QBluetoothTransferReply::abort()**

        Aborts this reply.
        """
        ...

    def request(self) -> "QBluetoothTransferRequest":
        """
        https://doc.qt.io/qt-5/qbluetoothtransferreply.html#request

        **QBluetoothTransferRequest QBluetoothTransferReply::request() const**

        Returns the **QBluetoothTransferRequest**  that was used to create this
        **QBluetoothTransferReply**  object.

        **See also** **setRequest** ().
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qbluetoothtransferreply.html#errorString

        **[pure virtual] QString QBluetoothTransferReply::errorString() const**

        String describing the error. Can be displayed to the user.

        **See also** **error** ().
        """
        ...

    def manager(self) -> QBluetoothTransferManager:
        """
        https://doc.qt.io/qt-5/qbluetoothtransferreply.html#manager

        **QBluetoothTransferManager *QBluetoothTransferReply::manager() const**

        Returns the **QBluetoothTransferManager**  that was used to create this
        **QBluetoothTransferReply**  object. Initially, it is also the parent
        object.

        **See also** **setManager** ().
        """
        ...

    def isRunning(self) -> bool:
        """
        https://doc.qt.io/qt-5/qbluetoothtransferreply.html#isRunning

        **[pure virtual] bool QBluetoothTransferReply::isRunning() const**

        Returns true if this reply is running, otherwise false.
        """
        ...

    def isFinished(self) -> bool:
        """
        https://doc.qt.io/qt-5/qbluetoothtransferreply.html#isFinished

        **[pure virtual] bool QBluetoothTransferReply::isFinished() const**

        Returns true if this reply has finished, otherwise false.
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qbluetoothtransferreply.html#error

        **[pure virtual] QBluetoothTransferReply::TransferError
        QBluetoothTransferReply::error() const**

        The error code of the error that occurred.

        **See also** **errorString** ().
        """
        ...

    @property
    def finished(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qbluetoothtransferreply.html#finished

        **[signal] void
        QBluetoothTransferReply::finished(QBluetoothTransferReply * reply )**

        This signal is emitted when the transfer is complete for **reply**.

        To avoid the loss of signal emissions it is recommend to immidiately
        connect to this signal once a `QBluetoothTransferReply` instance has
        been created.
        """
        ...

    @property
    def transferProgress(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qbluetoothtransferreply.html#transferProgress

        **[signal] void QBluetoothTransferReply::transferProgress(qint64
        bytesTransferred , qint64 bytesTotal )**

        This signal is emitted whenever data is transferred. The
        **bytesTransferred** parameter contains the total number of bytes
        transferred so far out of **bytesTotal**.

        To avoid the loss of signal emissions it is recommend to immidiately
        connect to this signal once a **QBluetoothTransferReply**  instance has
        been created.
        """
        ...
