"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtBluetooth import *


class QBluetoothTransferManager(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qbluetoothtransfermanager.html

    **Detailed Description**

    QBluetoothTransferManager uses OBEX to send put commands to remote devices.
    A typical OBEX transfer is initialized as follows:

    // Create a transfer manager
        **QBluetoothTransferManager**
    *transferManager = new **QBluetoothTransferManager** (this);

        //
    Create the transfer request and file to be sent
        **QBluetoothAddress**
    remoteAddress("00:11:22:33:44:55:66");
        **QBluetoothTransferRequest**
    request(remoteAddress);
        **QFile**  *file = new **QFile**
    ("testfile.txt");

        // Ask the transfer manager to send it
    **QBluetoothTransferReply**  *reply = transferManager->put(request, file);
    if (reply->error() == **QBluetoothTransferReply** ::NoError) {
    // Connect to the reply's signals to be informed about the status and do
    cleanups when done
            **QObject** ::connect(reply,
    SIGNAL(finished(**QBluetoothTransferReply** *)),
    this, SLOT(transferFinished(**QBluetoothTransferReply** *)));
    **QObject** ::connect(reply, SIGNAL(error(**QBluetoothTransferReply**
    ::TransferError)),
                             this,
    SLOT(error(**QBluetoothTransferReply** ::TransferError)));
        } else {
    **qWarning** () << "Cannot push testfile.txt:" << reply->errorString();
    }

    Note that this API is not currently supported on Android.
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothtransfermanager.html#QBluetoothTransfer
        Manager

        **QBluetoothTransferManager::QBluetoothTransferManager(QObject * parent
        = nullptr)**

        Constructs a new QBluetoothTransferManager with **parent**.
        """
        ...

    def put(
        self, request: "QBluetoothTransferRequest", data: QtCore.QIODevice
    ) -> "QBluetoothTransferReply":
        """
        https://doc.qt.io/qt-5/qbluetoothtransfermanager.html#put

        **QBluetoothTransferReply *QBluetoothTransferManager::put(const
        QBluetoothTransferRequest & request , QIODevice * data )**

        Sends the contents of **data** to the remote device identified by
        **request** , and returns a new **QBluetoothTransferReply**  that can be
        used to track the request's progress. **data** must remain valid until
        the **finished** () signal is emitted.

        The returned **QBluetoothTransferReply**  object must be immediately
        checked for its **error()**  state. This is required in case this
        function detects an error during the initialization of the
        **QBluetoothTransferReply** . In such cases
        **QBluetoothTransferReply::isFinished** () returns `true` as well.

        If the platform does not support the Object Push profile, this function
        will return `0`.
        """
        ...

    @property
    def finished(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qbluetoothtransfermanager.html#finished

        **[signal] void
        QBluetoothTransferManager::finished(QBluetoothTransferReply * reply )**

        This signal is emitted when the transfer for **reply** finishes.
        """
        ...
