"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5.QtBluetooth import *


class QBluetoothServiceInfo(PyQt5.sip.wrapper):
    """
    https://doc.qt.io/qt-5/qbluetoothserviceinfo.html

    **Detailed Description**

    QBluetoothServiceInfo provides information about a service offered by a
    Bluetooth device. In addition it can be used to register new services on the
    local device. Note that such a registration only affects the Bluetooth SDP
    entries. Any server listening for incoming connections (e.g an RFCOMM
    server) must be started before **registerService** () is called.
    Deregistration must happen in the reverse order.

    QBluetoothServiceInfo is not a value type in the traditional sense. All
    copies of the same service info object share the same data as they do not
    detach upon changing them. This ensures that two copies can (de)register the
    same Bluetooth service.

    On iOS, this class cannot be used because the platform does not expose an
    API which may permit access to QBluetoothServiceInfo related features.
    """

    class Protocol(int):
        UnknownProtocol: QBluetoothServiceInfo = ...
        L2capProtocol: QBluetoothServiceInfo = ...
        RfcommProtocol: QBluetoothServiceInfo = ...

    class AttributeId(int):
        ServiceRecordHandle: QBluetoothServiceInfo = ...
        ServiceClassIds: QBluetoothServiceInfo = ...
        ServiceRecordState: QBluetoothServiceInfo = ...
        ServiceId: QBluetoothServiceInfo = ...
        ProtocolDescriptorList: QBluetoothServiceInfo = ...
        BrowseGroupList: QBluetoothServiceInfo = ...
        LanguageBaseAttributeIdList: QBluetoothServiceInfo = ...
        ServiceInfoTimeToLive: QBluetoothServiceInfo = ...
        ServiceAvailability: QBluetoothServiceInfo = ...
        BluetoothProfileDescriptorList: QBluetoothServiceInfo = ...
        DocumentationUrl: QBluetoothServiceInfo = ...
        ClientExecutableUrl: QBluetoothServiceInfo = ...
        IconUrl: QBluetoothServiceInfo = ...
        AdditionalProtocolDescriptorList: QBluetoothServiceInfo = ...
        PrimaryLanguageBase: QBluetoothServiceInfo = ...
        ServiceName: QBluetoothServiceInfo = ...
        ServiceDescription: QBluetoothServiceInfo = ...
        ServiceProvider: QBluetoothServiceInfo = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#QBluetoothServiceInfo

        **QBluetoothServiceInfo::QBluetoothServiceInfo()**

        Construct a new invalid QBluetoothServiceInfo;
        """
        ...

    @typing.overload
    def __init__(self, other: "QBluetoothServiceInfo") -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#QBluetoothServiceInfo-
        1

        **QBluetoothServiceInfo::QBluetoothServiceInfo(const
        QBluetoothServiceInfo & other )**

        Construct a new QBluetoothServiceInfo that is a copy of **other**.

        The two copies continue to share the same underlying data which does not
        detach upon write.
        """
        ...

    def serviceClassUuids(self) -> typing.List["QBluetoothUuid"]:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#serviceClassUuids

        **QList<QBluetoothUuid> QBluetoothServiceInfo::serviceClassUuids()
        const**

        Returns a list of UUIDs describing the service classes that this service
        conforms to.

        This is a convenience function. It is equivalent to calling
        attribute(**QBluetoothServiceInfo::ServiceClassIds**
        ).value<**QBluetoothServiceInfo::Sequence** >() and subsequently
        iterating over its **QBluetoothUuid**  entries.

        **See also** **attribute** ().
        """
        ...

    def serviceUuid(self) -> "QBluetoothUuid":
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#serviceUuid

        **QBluetoothUuid QBluetoothServiceInfo::serviceUuid() const**

        This is a convenience function. It is equivalent to calling
        attribute(**QBluetoothServiceInfo::ServiceId**
        ).value<**QBluetoothUuid** >().

        Returns the custom UUID of the service. This UUID may be null. UUIDs
        based on **Bluetooth SIG standards**  should be retrieved via
        **serviceClassUuids** ().

        **See also** **setServiceUuid** () and **attribute** ().
        """
        ...

    def setServiceUuid(self, uuid: "QBluetoothUuid") -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#setServiceUuid

        **void QBluetoothServiceInfo::setServiceUuid(const QBluetoothUuid & uuid
        )**

        This is a convenience function. It is equivalent to calling
        **setAttribute** (**QBluetoothServiceInfo::ServiceId** , uuid).

        Sets the custom service UUID to **uuid**. This function should not be
        used to set a standardized service UUID.

        **See also** **serviceUuid** () and **setAttribute** ().
        """
        ...

    def serviceAvailability(self) -> int:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#serviceAvailability

        **quint8 QBluetoothServiceInfo::serviceAvailability() const**

        This is a convenience function. It is equivalent to calling
        attribute(**QBluetoothServiceInfo::ServiceAvailability** ).toUInt().

        Returns the availability of the service.

        **See also** **setServiceAvailability** () and **attribute** ().
        """
        ...

    def setServiceAvailability(self, availability: int) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#setServiceAvailability

        **void QBluetoothServiceInfo::setServiceAvailability(quint8 availability
        )**

        This is a convenience function. It is equivalent to calling
        **setAttribute** (**QBluetoothServiceInfo::ServiceAvailability** ,
        availability).

        Sets the availabiltiy of the service to **availability**.

        **See also** **serviceAvailability** () and **setAttribute** ().
        """
        ...

    def serviceProvider(self) -> str:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#serviceProvider

        **QString QBluetoothServiceInfo::serviceProvider() const**

        This is a convenience function. It is equivalent to calling
        attribute(**QBluetoothServiceInfo::ServiceProvider** ).toString().

        Returns the service provider in the primary language.

        **See also** **setServiceProvider** () and **attribute** ().
        """
        ...

    def setServiceProvider(self, provider: str) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#setServiceProvider

        **void QBluetoothServiceInfo::setServiceProvider(const QString &
        provider )**

        This is a convenience function. It is equivalent to calling
        **setAttribute** (**QBluetoothServiceInfo::ServiceProvider** ,
        provider).

        Sets the service provider in the primary language to **provider**.

        **See also** **serviceProvider** () and **setAttribute** ().
        """
        ...

    def serviceDescription(self) -> str:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#serviceDescription

        **QString QBluetoothServiceInfo::serviceDescription() const**

        This is a convenience function. It is equivalent to calling
        attribute(**QBluetoothServiceInfo::ServiceDescription** ).toString().

        Returns the service description in the primary language.

        **See also** **setServiceDescription** () and **attribute** ().
        """
        ...

    def setServiceDescription(self, description: str) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#setServiceDescription

        **void QBluetoothServiceInfo::setServiceDescription(const QString &
        description )**

        This is a convenience function. It is equivalent to calling
        **setAttribute** (**QBluetoothServiceInfo::ServiceDescription** ,
        description).

        Sets the service description in the primary language to **description**.

        **See also** **serviceDescription** () and **setAttribute** ().
        """
        ...

    def serviceName(self) -> str:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#serviceName

        **QString QBluetoothServiceInfo::serviceName() const**

        This is a convenience function. It is equivalent to calling
        attribute(**QBluetoothServiceInfo::ServiceName** ).toString().

        Returns the service name in the primary language.

        **See also** **setServiceName** () and **attribute** ().
        """
        ...

    def setServiceName(self, name: str) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#setServiceName

        **void QBluetoothServiceInfo::setServiceName(const QString & name )**

        This is a convenience function. It is equivalent to calling
        **setAttribute** (**QBluetoothServiceInfo::ServiceName** , name).

        Sets the service name in the primary language to **name**.

        **See also** **serviceName** () and **setAttribute** ().
        """
        ...

    @typing.overload
    def setAttribute(self, attributeId: int, value: "QBluetoothUuid") -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#setAttribute

        **void QBluetoothServiceInfo::setAttribute(quint16 attributeId , const
        QVariant & value )**

        Sets the attribute identified by **attributeId** to **value**.

        If the service information is already registered with the platform's SDP
        database, the database entry will not be updated until
        **registerService** () was called again.

        **Note:** If an attribute expectes a byte-encoded value (e.g. Bluetooth
        HID services), it should be set as **QByteArray** .

        **See also** **attribute** (), **isRegistered** (), and
        **registerService** ().
        """
        ...

    @typing.overload
    def setAttribute(
        self, attributeId: int, value: typing.Iterable[typing.Any]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#setAttribute-1

        **void QBluetoothServiceInfo::setAttribute(quint16 attributeId , const
        QBluetoothUuid & value )**

        This is a convenience function.

        Sets the attribute identified by **attributeId** to **value**.

        If the service information is already registered with the platform's SDP
        database, the database entry will not be updated until
        **registerService** () was called again.
        """
        ...

    @typing.overload
    def setAttribute(self, attributeId: int, value: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#setAttribute-2

        **void QBluetoothServiceInfo::setAttribute(quint16 attributeId , const
        QBluetoothServiceInfo::Sequence & value )**

        This is a convenience function.

        Sets the attribute identified by **attributeId** to **value**.

        If the service information is already registered with the platform's SDP
        database, the database entry will not be updated until
        **registerService** () was called again.
        """
        ...

    def unregisterService(self) -> bool:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#unregisterService

        **bool QBluetoothServiceInfo::unregisterService()**

        Unregisters this service with the platform's Service Discovery Protocol
        (SDP) implementation. After this, the service will no longer be findable
        by other devices through service discovery.

        Returns true if the service is successfully unregistered, otherwise
        returns false.
        """
        ...

    def registerService(self, localAdapter: QBluetoothAddress = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#registerService

        **bool QBluetoothServiceInfo::registerService(const QBluetoothAddress &
        localAdapter = QBluetoothAddress())**

        Registers this service with the platform's Service Discovery Protocol
        (SDP) implementation, making it findable by other devices when they
        perform service discovery. Returns true if the service is successfully
        registered, otherwise returns false. Once registered changes to the
        record cannot be made. The service must be unregistered and registered
        again with the changes.

        The **localAdapter** parameter determines the local Bluetooth adapter
        under which the service should be registered. If **localAdapter** is
        `null` the default Bluetooth adapter will be used. If this service info
        object is already registered via a local adapter and this is function is
        called using a different local adapter, the previous registration is
        removed and the service reregistered using the new adapter.
        """
        ...

    def isRegistered(self) -> bool:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#isRegistered

        **bool QBluetoothServiceInfo::isRegistered() const**

        Returns true if the service information is registered with the
        platform's Service Discovery Protocol (SDP) implementation, otherwise
        returns false.
        """
        ...

    def protocolDescriptor(
        self, protocol: "QBluetoothUuid.ProtocolUuid"
    ) -> typing.List[typing.Any]:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#protocolDescriptor

        **QBluetoothServiceInfo::Sequence
        QBluetoothServiceInfo::protocolDescriptor(QBluetoothUuid::ProtocolUuid
        protocol ) const**

        Returns the protocol parameters as a **QBluetoothServiceInfo::Sequence**
        for protocol **protocol**.

        An empty **QBluetoothServiceInfo::Sequence**  is returned if
        **protocol** is not supported.
        """
        ...

    def serverChannel(self) -> int:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#serverChannel

        **int QBluetoothServiceInfo::serverChannel() const**

        This is a convenience function. Returns the server channel for services
        which support the RFCOMM protocol, otherwise returns -1.

        This function is equivalent to extracting the information from
        **QBluetoothServiceInfo::Sequence**  returned by
        **QBluetoothServiceInfo::attribute**
        (QBluetootherServiceInfo::ProtocolDescriptorList).
        """
        ...

    def protocolServiceMultiplexer(self) -> int:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#protocolServiceMultipl
        exer

        **int QBluetoothServiceInfo::protocolServiceMultiplexer() const**

        This is a convenience function. Returns the protocol/service multiplexer
        for services which support the L2CAP protocol, otherwise returns -1.

        This function is equivalent to extracting the information from
        **QBluetoothServiceInfo::Sequence**  returned by
        **QBluetoothServiceInfo::attribute**
        (**QBluetoothServiceInfo::ProtocolDescriptorList** ).
        """
        ...

    def socketProtocol(self) -> "QBluetoothServiceInfo.Protocol":
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#socketProtocol

        **QBluetoothServiceInfo::Protocol
        QBluetoothServiceInfo::socketProtocol() const**

        Returns the protocol that the **QBluetoothServiceInfo**  object uses.
        """
        ...

    def removeAttribute(self, attributeId: int) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#removeAttribute

        **void QBluetoothServiceInfo::removeAttribute(quint16 attributeId )**

        Removes the attribute **attributeId** from the **QBluetoothServiceInfo**
        object.

        If the service information is already registered with the platforms SDP
        database, the database entry will not be updated until
        **registerService** () was called again.
        """
        ...

    def contains(self, attributeId: int) -> bool:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#contains

        **bool QBluetoothServiceInfo::contains(quint16 attributeId ) const**

        Returns true if the **QBluetoothServiceInfo**  object contains the
        attribute **attributeId** , otherwise returns false.
        """
        ...

    def attributes(self) -> typing.List[int]:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#attributes

        **QList<quint16> QBluetoothServiceInfo::attributes() const**

        Returns a list of all attribute ids that the **QBluetoothServiceInfo**
        object has.
        """
        ...

    def attribute(self, attributeId: int) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#attribute

        **QVariant QBluetoothServiceInfo::attribute(quint16 attributeId )
        const**

        Returns the value of the attribute **attributeId**.

        **See also** **setAttribute** ().
        """
        ...

    def device(self) -> QBluetoothDeviceInfo:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#device

        **QBluetoothDeviceInfo QBluetoothServiceInfo::device() const**

        Returns the address of the Bluetooth device that provides this service.

        **See also** **setDevice** ().
        """
        ...

    def setDevice(self, info: QBluetoothDeviceInfo) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#setDevice

        **void QBluetoothServiceInfo::setDevice(const QBluetoothDeviceInfo &
        device )**

        Sets the Bluetooth device that provides this service to **device**.

        **See also** **device** ().
        """
        ...

    def isComplete(self) -> bool:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#isComplete

        **bool QBluetoothServiceInfo::isComplete() const**

        Returns true if the **QBluetoothServiceInfo**  object is considered
        complete, otherwise returns false.

        A complete **QBluetoothServiceInfo**  object contains a
        **ProtocolDescriptorList**  attribute.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qbluetoothserviceinfo.html#isValid

        **bool QBluetoothServiceInfo::isValid() const**

        Returns true if the **QBluetoothServiceInfo**  object is valid,
        otherwise returns false.

        An invalid **QBluetoothServiceInfo**  object will have no attributes.
        """
        ...
