"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtBluetooth import *


class QBluetoothServiceDiscoveryAgent(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qbluetoothservicediscoveryagent.html

    **Detailed Description**

    The discovery process relies on the Bluetooth Service Discovery Process
    (SDP). The following steps are required to query the services provided by
    all contactable Bluetooth devices:

    * create an instance of QBluetoothServiceDiscoveryAgent,
      * connect to
    either the **serviceDiscovered** () or **finished** () signals,
      * and call
    **start** ().

    void MyClass::startServiceDiscovery()
        {

            // Create a
    discovery agent and connect to its signals
    **QBluetoothServiceDiscoveryAgent**  *discoveryAgent = new
    **QBluetoothServiceDiscoveryAgent** (this);
            connect(discoveryAgent,
    SIGNAL(serviceDiscovered(**QBluetoothServiceInfo** )),
                    this,
    SLOT(serviceDiscovered(**QBluetoothServiceInfo** )));

            // Start
    a discovery
            discoveryAgent->start();

            //...
        }
    // In your local slot, read information about the found devices
        void
    MyClass::serviceDiscovered(const **QBluetoothServiceInfo**  &service)
        {
    **qDebug** () << "Found new service:" << service.serviceName()
    << '(' << service.device().address().toString() << ')';
        }

    By default a minimal service discovery is performed. In this mode, the
    returned **QBluetoothServiceInfo**  objects are guaranteed to contain only
    device and service UUID information. Depending on platform and device
    capabilities, other service information may also be available. The minimal
    service discovery mode relies on cached SDP data of the platform. Therefore
    it is possible that this discovery does not find a device although it is
    physically available. In such cases a full discovery must be performed to
    force an update of the platform cache. However for most use cases a minimal
    discovery is adequate as it is much quicker and other classes which require
    up-to-date information such as **QBluetoothSocket::connectToService** ()
    will perform additional discovery if required. If the full service
    information is required, pass **FullDiscovery**  as the discoveryMode
    parameter to **start** ().

    This class may internally utilize **QBluetoothDeviceDiscoveryAgent**  to
    find unknown devices.

    The service discovery may find Bluetooth Low Energy services too if the
    target device is a combination of a classic and Low Energy device. Those
    devices are required to advertise their Low Energy services via SDP. If the
    target device only supports Bluetooth Low Energy services, it is likely to
    not advertise them via SDP. The **QLowEnergyController**  class should be
    utilized to perform the service discovery on Low Energy devices.

    On iOS, this class cannot be used because the platform does not expose an
    API which may permit access to QBluetoothServiceDiscoveryAgent related
    features.

    **See also** **QBluetoothDeviceDiscoveryAgent**  and
    **QLowEnergyController** .
    """

    class DiscoveryMode(int):
        MinimalDiscovery: QBluetoothServiceDiscoveryAgent = ...
        FullDiscovery: QBluetoothServiceDiscoveryAgent = ...

    class Error(int):
        NoError: QBluetoothServiceDiscoveryAgent = ...
        InputOutputError: QBluetoothServiceDiscoveryAgent = ...
        PoweredOffError: QBluetoothServiceDiscoveryAgent = ...
        InvalidBluetoothAdapterError: QBluetoothServiceDiscoveryAgent = ...
        UnknownError: QBluetoothServiceDiscoveryAgent = ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothservicediscoveryagent.html#QBluetoothSe
        rviceDiscoveryAgent

        **QBluetoothServiceDiscoveryAgent::QBluetoothServiceDiscoveryAgent(QObje
        ct * parent = nullptr)**

        Constructs a new QBluetoothServiceDiscoveryAgent with **parent**. The
        search is performed via the local default Bluetooth adapter.
        """
        ...

    @typing.overload
    def __init__(
        self,
        deviceAdapter: QBluetoothAddress,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothservicediscoveryagent.html#QBluetoothSe
        rviceDiscoveryAgent-1

        **QBluetoothServiceDiscoveryAgent::QBluetoothServiceDiscoveryAgent(const
        QBluetoothAddress & deviceAdapter , QObject * parent = nullptr)**

        Constructs a new QBluetoothServiceDiscoveryAgent for **deviceAdapter**
        and with **parent**.

        It uses **deviceAdapter** for the service search. If **deviceAdapter**
        is default constructed the resulting QBluetoothServiceDiscoveryAgent
        object will use the local default Bluetooth adapter.

        If a **deviceAdapter** is specified that is not a local adapter
        **error** () will be set to **InvalidBluetoothAdapterError** . Therefore
        it is recommended to test the error flag immediately after using this
        constructor.

        **Note:** On WinRT the passed adapter address will be ignored.

        **Note:** On Android passing any **deviceAdapter** address is
        meaningless as Android 6.0 or later does not publish the local Bluetooth
        address anymore. Subsequently, the passed adapter address can never be
        matched against the local adapter address. Therefore the subsequent call
        to **start** () will always trigger **InvalidBluetoothAdapterError** .

        **See also** **error** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothservicediscoveryagent.html#clear

        **[slot] void QBluetoothServiceDiscoveryAgent::clear()**

        Clears the results of previous service discoveries and resets
        **uuidFilter** (). This function does nothing during an ongoing service
        discovery (see **isActive** ()).

        **See also** **discoveredServices** ().
        """
        ...

    def stop(self) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothservicediscoveryagent.html#stop

        **[slot] void QBluetoothServiceDiscoveryAgent::stop()**

        Stops the service discovery process. The **canceled** () signal will be
        emitted once the search has stopped.
        """
        ...

    def start(
        self, mode: "QBluetoothServiceDiscoveryAgent.DiscoveryMode" = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothservicediscoveryagent.html#start

        **[slot] void QBluetoothServiceDiscoveryAgent::start(QBluetoothServiceDi
        scoveryAgent::DiscoveryMode mode = MinimalDiscovery)**

        Starts service discovery. **mode** specifies the type of service
        discovery to perform.

        On some platforms, device discovery may lead to pairing requests.

        **See also** **DiscoveryMode** .
        """
        ...

    def remoteAddress(self) -> QBluetoothAddress:
        """
        https://doc.qt.io/qt-5/qbluetoothservicediscoveryagent.html#remoteAddres
        s

        **QBluetoothAddress QBluetoothServiceDiscoveryAgent::remoteAddress()
        const**

        Returns the remote device address. If **setRemoteAddress** () is not
        called, the function will return a default constructed
        **QBluetoothAddress** .

        **See also** **setRemoteAddress** ().
        """
        ...

    def setRemoteAddress(self, address: QBluetoothAddress) -> bool:
        """
        https://doc.qt.io/qt-5/qbluetoothservicediscoveryagent.html#setRemoteAdd
        ress

        **bool QBluetoothServiceDiscoveryAgent::setRemoteAddress(const
        QBluetoothAddress & address )**

        Sets the remote device address to **address**. If **address** is default
        constructed, services will be discovered on all contactable Bluetooth
        devices. A new remote address can only be set while there is no service
        discovery in progress; otherwise this function returns false.

        On some platforms the service discovery might lead to pairing requests.
        Therefore it is not recommended to do service discoveries on all
        devices. This function can be used to restrict the service discovery to
        a particular device.

        **See also** **remoteAddress** ().
        """
        ...

    def uuidFilter(self) -> typing.List["QBluetoothUuid"]:
        """
        https://doc.qt.io/qt-5/qbluetoothservicediscoveryagent.html#uuidFilter

        **QList<QBluetoothUuid> QBluetoothServiceDiscoveryAgent::uuidFilter()
        const**

        Returns the UUID filter.

        **See also** **setUuidFilter** ().
        """
        ...

    @typing.overload
    def setUuidFilter(self, uuids: typing.Iterable["QBluetoothUuid"]) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothservicediscoveryagent.html#setUuidFilte
        r

        **void QBluetoothServiceDiscoveryAgent::setUuidFilter(const
        QList<QBluetoothUuid> & uuids )**

        Sets the UUID filter to **uuids**. Only services matching the UUIDs in
        **uuids** will be returned. The matching applies to the service's
        **ServiceId**  and **ServiceClassIds**  attributes.

        An empty UUID list is equivalent to a list containing only
        **QBluetoothUuid::PublicBrowseGroup** .

        **See also** **uuidFilter** ().
        """
        ...

    @typing.overload
    def setUuidFilter(self, uuid: "QBluetoothUuid") -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothservicediscoveryagent.html#setUuidFilte
        r-1

        **void QBluetoothServiceDiscoveryAgent::setUuidFilter(const
        QBluetoothUuid & uuid )**

        This is an overloaded member function, provided for convenience.

        Sets the UUID filter to a list containing the single element **uuid**.
        The matching applies to the service's **ServiceId**  and
        **ServiceClassIds**  attributes.

        **See also** **uuidFilter** ().
        """
        ...

    def discoveredServices(self) -> typing.List["QBluetoothServiceInfo"]:
        """
        https://doc.qt.io/qt-5/qbluetoothservicediscoveryagent.html#discoveredSe
        rvices

        **QList<QBluetoothServiceInfo>
        QBluetoothServiceDiscoveryAgent::discoveredServices() const**

        Returns the list of all discovered services.

        This list of services accumulates newly discovered services from
        multiple calls to **start** (). Unless **clear** () is called the list
        cannot decrease in size. This implies that if a remote Bluetooth device
        moves out of range in between two subsequent calls to **start** () the
        list may contain stale entries.

        **Note:** The list of services should always be cleared before the
        discovery mode is changed.

        **See also** **clear** ().
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qbluetoothservicediscoveryagent.html#errorString

        **QString QBluetoothServiceDiscoveryAgent::errorString() const**

        Returns a human-readable description of the last error that occurred
        during the service discovery.
        """
        ...

    def isActive(self) -> bool:
        """
        https://doc.qt.io/qt-5/qbluetoothservicediscoveryagent.html#isActive

        **bool QBluetoothServiceDiscoveryAgent::isActive() const**

        Returns `true` if the service discovery is currently active; otherwise
        returns `false`. An active discovery can be stopped by calling **stop**
        ().
        """
        ...

    @property
    def canceled(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qbluetoothservicediscoveryagent.html#canceled

        **[signal] void QBluetoothServiceDiscoveryAgent::canceled()**

        This signal is triggered when the service discovery was canceled via a
        call to **stop** ().
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qbluetoothservicediscoveryagent.html#error

        **QBluetoothServiceDiscoveryAgent::Error
        QBluetoothServiceDiscoveryAgent::error() const**

        Returns the type of error that last occurred. If the service discovery
        is done for a single **remoteAddress** () it will return errors that
        occurred while trying to discover services on that device. If the
        **remoteAddress** () is not set and devices are discovered by a scan,
        errors during service discovery on individual devices are not saved and
        no signals are emitted. In this case, errors are fairly normal as some
        devices may not respond to discovery or may no longer be in range. Such
        errors are surpressed. If no services are returned, it can be assumed no
        services could be discovered.
        """
        ...

    @property
    def finished(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qbluetoothservicediscoveryagent.html#finished

        **[signal] void QBluetoothServiceDiscoveryAgent::finished()**

        This signal is emitted when the Bluetooth service discovery completes.

        Unlike the **QBluetoothDeviceDiscoveryAgent::finished** () signal this
        signal will even be emitted when an error occurred during the service
        discovery. Therefore it is recommended to check the **error** () signal
        to evaluate the success of the service discovery discovery.
        """
        ...

    @property
    def serviceDiscovered(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qbluetoothservicediscoveryagent.html#serviceDisco
        vered

        **[signal] void QBluetoothServiceDiscoveryAgent::serviceDiscovered(const
        QBluetoothServiceInfo & info )**

        This signal is emitted when the Bluetooth service described by **info**
        is discovered.

        **Note:** The passed **QBluetoothServiceInfo**  parameter may contain a
        Bluetooth Low Energy service if the target device advertises the service
        via SDP. This is required from device which support both, classic
        Bluetooth (BaseRate) and Low Energy services.

        **See also** **QBluetoothDeviceInfo::coreConfigurations** ().
        """
        ...
