"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtBluetooth import *


class QBluetoothDeviceDiscoveryAgent(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qbluetoothdevicediscoveryagent.html

    **Detailed Description**

    To discover the nearby Bluetooth devices:

    * create an instance of QBluetoothDeviceDiscoveryAgent,
      * connect to
    either the **deviceDiscovered** () or **finished** () signals,
      * and call
    **start** ().

    void MyClass::startDeviceDiscovery()
        {

            // Create a
    discovery agent and connect to its signals
    **QBluetoothDeviceDiscoveryAgent**  *discoveryAgent = new
    **QBluetoothDeviceDiscoveryAgent** (this);
            connect(discoveryAgent,
    SIGNAL(deviceDiscovered(**QBluetoothDeviceInfo** )),
                    this,
    SLOT(deviceDiscovered(**QBluetoothDeviceInfo** )));

            // Start a
    discovery
            discoveryAgent->start();

            //...
        }
    // In your local slot, read information about the found devices
        void
    MyClass::deviceDiscovered(const **QBluetoothDeviceInfo**  &device)
        {
    **qDebug** () << "Found new device:" << device.name() << '(' <<
    device.address().toString() << ')';
        }

    To retrieve results asynchronously, connect to the **deviceDiscovered** ()
    signal. To get a list of all discovered devices, call **discoveredDevices**
    () after the **finished** () signal.

    This class can be used to discover Classic and Low Energy Bluetooth devices.
    The individual device type can be determined via the
    **QBluetoothDeviceInfo::coreConfigurations** () attribute. In most cases the
    list returned by **discoveredDevices** () contains both types of devices.
    However not every platform can detect both types of devices. On platforms
    with this limitation (for example iOS only suports Low Energy discovery),
    the discovery process will limit the search to the type which is supported.

    **Note:** Since Android 6.0 the ability to detect devices requires
    ACCESS_COARSE_LOCATION.

    **Note:** Due to API limitations it is only possible to find devices that
    have been paired using Windows' settings on Windows.

    **Note:** The Win32 backend currently does not support the Received Signal
    Strength Indicator (RSSI), as well as the Manufacturer Specific Data, or
    other data updates advertised by Bluetooth LE devices after discovery.
    """

    class DiscoveryMethod(int):
        ...

    class InquiryType(int):
        GeneralUnlimitedInquiry: QBluetoothDeviceDiscoveryAgent = ...
        LimitedInquiry: QBluetoothDeviceDiscoveryAgent = ...

    class Error(int):
        NoError: QBluetoothDeviceDiscoveryAgent = ...
        InputOutputError: QBluetoothDeviceDiscoveryAgent = ...
        PoweredOffError: QBluetoothDeviceDiscoveryAgent = ...
        InvalidBluetoothAdapterError: QBluetoothDeviceDiscoveryAgent = ...
        UnsupportedPlatformError: QBluetoothDeviceDiscoveryAgent = ...
        UnsupportedDiscoveryMethod: QBluetoothDeviceDiscoveryAgent = ...
        UnknownError: QBluetoothDeviceDiscoveryAgent = ...

    class DiscoveryMethods(PyQt5.sip.wrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QBluetoothDeviceDiscoveryAgent.DiscoveryMethods",
                "QBluetoothDeviceDiscoveryAgent.DiscoveryMethod",
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(
            self, a0: "QBluetoothDeviceDiscoveryAgent.DiscoveryMethods"
        ) -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QBluetoothDeviceDiscoveryAgent.DiscoveryMethods":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothdevicediscoveryagent.html#QBluetoothDev
        iceDiscoveryAgent

        **QBluetoothDeviceDiscoveryAgent::QBluetoothDeviceDiscoveryAgent(QObject
        * parent = nullptr)**

        Constructs a new Bluetooth device discovery agent with parent
        **parent**.
        """
        ...

    @typing.overload
    def __init__(
        self,
        deviceAdapter: QBluetoothAddress,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothdevicediscoveryagent.html#QBluetoothDev
        iceDiscoveryAgent-1

        **QBluetoothDeviceDiscoveryAgent::QBluetoothDeviceDiscoveryAgent(const
        QBluetoothAddress & deviceAdapter , QObject * parent = nullptr)**

        Constructs a new Bluetooth device discovery agent with **parent**.

        It uses **deviceAdapter** for the device search. If **deviceAdapter** is
        default constructed the resulting QBluetoothDeviceDiscoveryAgent object
        will use the local default Bluetooth adapter.

        If a **deviceAdapter** is specified that is not a local adapter
        **error** () will be set to **InvalidBluetoothAdapterError** . Therefore
        it is recommended to test the error flag immediately after using this
        constructor.

        **See also** **error** ().
        """
        ...

    @staticmethod
    def supportedDiscoveryMethods() -> "QBluetoothDeviceDiscoveryAgent.DiscoveryMethods":
        """
        https://doc.qt.io/qt-5/qbluetoothdevicediscoveryagent.html#supportedDisc
        overyMethods

        **[static] QBluetoothDeviceDiscoveryAgent::DiscoveryMethods
        QBluetoothDeviceDiscoveryAgent::supportedDiscoveryMethods()**

        This function returns the discovery methods supported by the current
        platform. It can be used to limit the scope of the device discovery.

        This function was introduced in Qt 5.8.
        """
        ...

    def lowEnergyDiscoveryTimeout(self) -> int:
        """
        https://doc.qt.io/qt-5/qbluetoothdevicediscoveryagent.html#lowEnergyDisc
        overyTimeout

        **int QBluetoothDeviceDiscoveryAgent::lowEnergyDiscoveryTimeout()
        const**

        Returns a timeout in milliseconds that is applied to the Bluetooth Low
        Energy device search. A value of `-1` implies that the platform does not
        support this property and the timeout for the device search cannot be
        adjusted. A return value of `0` implies a never-ending search which must
        be manually stopped via **stop** ().

        This function was introduced in Qt 5.8.

        **See also** **setLowEnergyDiscoveryTimeout** ().
        """
        ...

    def setLowEnergyDiscoveryTimeout(self, msTimeout: int) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothdevicediscoveryagent.html#setLowEnergyD
        iscoveryTimeout

        **void QBluetoothDeviceDiscoveryAgent::setLowEnergyDiscoveryTimeout(int
        timeout )**

        Sets the maximum search time for Bluetooth Low Energy device search to
        **timeout** in milliseconds. If **timeout** is `0` the discovery runs
        until **stop** () is called.

        This reflects the fact that the discovery process for Bluetooth Low
        Energy devices is mostly open ended. The platform continues to look for
        more devices until the search is manually stopped. The timeout ensures
        that the search is aborted after **timeout** milliseconds. Of course, it
        is still possible to manually abort the discovery by calling **stop**
        ().

        The new timeout value does not take effect until the device search is
        restarted. In addition the timeout does not affect the classic Bluetooth
        device search. Depending on the platform the classic search may add more
        time to the total discovery process beyond **timeout**.

        This function was introduced in Qt 5.8.

        **See also** **lowEnergyDiscoveryTimeout** ().
        """
        ...

    def stop(self) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothdevicediscoveryagent.html#stop

        **[slot] void QBluetoothDeviceDiscoveryAgent::stop()**

        Stops Bluetooth device discovery. The cancel() signal is emitted once
        the device discovery is canceled. **start** () maybe called before the
        cancel signal is received. Once **start** () has been called the cancel
        signal from the prior discovery will be discarded.
        """
        ...

    @typing.overload
    def start(self) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothdevicediscoveryagent.html#start

        **[slot] void QBluetoothDeviceDiscoveryAgent::start()**

        Starts Bluetooth device discovery, if it is not already started.

        The **deviceDiscovered** () signal is emitted as each device is
        discovered. The **finished** () signal is emitted once device discovery
        is complete. The discovery utilizes the maximum set of supported
        discovery methods on the platform.

        **See also** **supportedDiscoveryMethods** ().
        """
        ...

    @typing.overload
    def start(
        self,
        method: typing.Union[
            "QBluetoothDeviceDiscoveryAgent.DiscoveryMethods",
            "QBluetoothDeviceDiscoveryAgent.DiscoveryMethod",
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothdevicediscoveryagent.html#start-1

        **[slot] void QBluetoothDeviceDiscoveryAgent::start(QBluetoothDeviceDisc
        overyAgent::DiscoveryMethods methods )**

        Starts Bluetooth device discovery, if it is not already started and the
        provided **methods** are supported. The discovery **methods** limit the
        scope of the device search. For example, if the target service or device
        is a Bluetooth Low Energy device, this function could be used to limit
        the search to Bluetooth Low Energy devices and thereby reduces the
        discovery time significantly.

        **Note:** **methods** only determines the type of discovery and does not
        imply the filtering of the results. For example, the search may still
        contain classic bluetooth devices despite **methods** being set to
        **LowEnergyMethod**  only. This may happen due to previously cached
        search results which may be incorporated into the search results.

        This function was introduced in Qt 5.8.
        """
        ...

    def discoveredDevices(self) -> typing.List["QBluetoothDeviceInfo"]:
        """
        https://doc.qt.io/qt-5/qbluetoothdevicediscoveryagent.html#discoveredDev
        ices

        **QList<QBluetoothDeviceInfo>
        QBluetoothDeviceDiscoveryAgent::discoveredDevices() const**

        Returns a list of all discovered Bluetooth devices.
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qbluetoothdevicediscoveryagent.html#errorString

        **QString QBluetoothDeviceDiscoveryAgent::errorString() const**

        Returns a human-readable description of the last error.
        """
        ...

    def isActive(self) -> bool:
        """
        https://doc.qt.io/qt-5/qbluetoothdevicediscoveryagent.html#isActive

        **bool QBluetoothDeviceDiscoveryAgent::isActive() const**

        Returns true if the agent is currently discovering Bluetooth devices,
        otherwise returns false.
        """
        ...

    def setInquiryType(
        self, type: "QBluetoothDeviceDiscoveryAgent.InquiryType"
    ) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothdevicediscoveryagent.html#inquiryType-
        prop

        **inquiryType : QBluetoothDeviceDiscoveryAgent::InquiryType**

        type of inquiry scan to be used while discovering devices

        This property affects the type of inquiry scan which is performed while
        discovering devices.

        By default, this property is set to **GeneralUnlimitedInquiry** .

        Not all platforms support **LimitedInquiry** .

        **Access functions:**

        QBluetoothDeviceDiscoveryAgent::InquiryType **inquiryType** () const
        void **setInquiryType** (QBluetoothDeviceDiscoveryAgent::InquiryType
        **type** )

        **See also** **InquiryType** .

        **Member Function Documentation**
        """
        ...

    def inquiryType(self) -> "QBluetoothDeviceDiscoveryAgent.InquiryType":
        """
        https://doc.qt.io/qt-5/qbluetoothdevicediscoveryagent.html#inquiryType-
        prop

        **inquiryType : QBluetoothDeviceDiscoveryAgent::InquiryType**

        type of inquiry scan to be used while discovering devices

        This property affects the type of inquiry scan which is performed while
        discovering devices.

        By default, this property is set to **GeneralUnlimitedInquiry** .

        Not all platforms support **LimitedInquiry** .

        **Access functions:**

        QBluetoothDeviceDiscoveryAgent::InquiryType **inquiryType** () const
        void **setInquiryType** (QBluetoothDeviceDiscoveryAgent::InquiryType
        **type** )

        **See also** **InquiryType** .

        **Member Function Documentation**
        """
        ...

    @property
    def canceled(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qbluetoothdevicediscoveryagent.html#canceled

        **[signal] void QBluetoothDeviceDiscoveryAgent::canceled()**

        This signal is emitted when device discovery is aborted by a call to
        **stop** ().
        """
        ...

    @property
    def deviceDiscovered(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qbluetoothdevicediscoveryagent.html#deviceDiscove
        red

        **[signal] void QBluetoothDeviceDiscoveryAgent::deviceDiscovered(const
        QBluetoothDeviceInfo & info )**

        This signal is emitted when the Bluetooth device described by **info**
        is discovered.

        The signal is emitted as soon as the most important device information
        has been collected. However, as long as the **finished** () signal has
        not been emitted the information collection continues even for already
        discovered devices. This is particularly true for signal strength
        information (RSSI) and manufacturer data updates. If the use case
        requires continuous manufacturer data or RSSI updates it is advisable to
        retrieve the device information via **discoveredDevices** () once the
        discovery has finished or listen to the **deviceUpdated** () signal.

        If **lowEnergyDiscoveryTimeout** () is larger than 0 the signal is only
        ever emitted when at least one attribute of **info** changes. This
        reflects the desire to receive updates as more precise information
        becomes available. The exception to this behavior is the case when
        **lowEnergyDiscoveryTimeout**  is set to `0`. A timeout of `0` expresses
        the desire to monitor the appearance and disappearance of Low Energy
        devices over time. Under this condition the deviceDiscovered() signal is
        emitted even if **info** has not changed since the last signal emission.

        **See also** **QBluetoothDeviceInfo::rssi** () and
        **lowEnergyDiscoveryTimeout** ().
        """
        ...

    @property
    def deviceUpdated(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qbluetoothdevicediscoveryagent.html#deviceUpdated

        **[signal] void QBluetoothDeviceDiscoveryAgent::deviceUpdated(const
        QBluetoothDeviceInfo & info , QBluetoothDeviceInfo::Fields updatedFields
        )**

        This signal is emitted when the agent receives additional information
        about the Bluetooth device described by **info**. The **updatedFields**
        flags tell which information has been updated.

        During discovery, some information can change dynamically, such as
        **signal strength**  and **manufacturerData** . This signal informs you
        that if your application is displaying this data, it can be updated,
        rather than waiting until the discovery has finished.

        **See also** **QBluetoothDeviceInfo::rssi** () and
        **lowEnergyDiscoveryTimeout** ().
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qbluetoothdevicediscoveryagent.html#error

        **QBluetoothDeviceDiscoveryAgent::Error
        QBluetoothDeviceDiscoveryAgent::error() const**

        Returns the last error.
        """
        ...

    @property
    def finished(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qbluetoothdevicediscoveryagent.html#finished

        **[signal] void QBluetoothDeviceDiscoveryAgent::finished()**

        This signal is emitted when Bluetooth device discovery completes. The
        signal is not going to be emitted if the device discovery finishes with
        an error.
        """
        ...
