"""Mapping templates for GBD covariates.

This code is automatically generated by gbd_mapping_generator/covariate_builder.py

Any manual changes will be lost.
"""
from typing import Union

from .id import cov_id
from .base_template import ModelableEntity, GbdRecord


class Covariate(ModelableEntity):
    """Container for covariate GBD ids and metadata."""
    __slots__ = ('name', 'kind', 'gbd_id', 'by_age', 'by_sex', 'dichotomous', )

    def __init__(self,
                 name: str,
                 kind: str,
                 gbd_id: Union[cov_id, None],
                 by_age: bool,
                 by_sex: bool,
                 dichotomous: bool, ):
        super().__init__(name=name,
                         kind=kind,
                         gbd_id=gbd_id)
        self.name = name
        self.kind = kind
        self.gbd_id = gbd_id
        self.by_age = by_age
        self.by_sex = by_sex
        self.dichotomous = dichotomous


class Covariates(GbdRecord):
    """Container for GBD covariates."""
    __slots__ = ('abortion_on_demand_illegal_binary', 'legality_of_abortion', 'absolute_value_of_average_latitude',
                 'average_cholera_cases_across_all_years_over_2010_population', 'adult_hiv_death_rate',
                 'alcohol_liters_per_capita', 'antenatal_care_1_visit_coverage_proportion',
                 'antenatal_care_4_visits_coverage_proportion', 'animal_fats_kcal_per_capita',
                 'arv_coverage_proportion', 'asbestos_production_binary', 'asbestos_production_kg_per_capita',
                 'age_specific_fertility_rate', 'tobacco_cigarettes_per_capita', 'coal_production_per_capita',
                 'coastal_population_within_10km_proportion', 'completeness_of_vital_registration',
                 'contraception_modern_prevalence_proportion_by_age', 'contraception_modern_prevalence_proportion',
                 'contraception_total_prevalence_proportion_by_age', 'contraception_total_prevalence_proportion',
                 'contraception_traditional_prevalence_proportion_by_age',
                 'contraception_traditional_prevalence_proportion', 'cumulative_cigarettes_10_years',
                 'cumulative_cigarettes_15_years', 'cumulative_cigarettes_20_years', 'cumulative_cigarettes_5_years',
                 'diabetes_fasting_plasma_glucose_mmol_l_age_standardized_25_and_up',
                 'diabetes_age_standardized_prevalence_proportion', 'diabetes_age_specific_prevalence_proportion',
                 'disaster_deaths_rate_per_1000', 'dtp3_coverage_proportion', 'education_years_per_capita',
                 'famine_binary', 'fao_composite_factor_1', 'fao_composite_factor_2', 'fao_composite_factor_3',
                 'fao_composite_factor_4', 'female_hiv_death_rate_per_1_for_ages_15_49', 'fertility_15_19_year_olds',
                 'fruits_kcal_per_capita', 'gold_production_binary', 'gold_production_kg_per_capita',
                 'health_system_access_unitless', 'health_system_access_2_unitless',
                 'proportion_of_households_using_iodized_salt_adjusted', 'hib3_vaccine_coverage_proportion',
                 'hiv_prevalence_arv_adjusted_custom_lag__percent', 'hiv_prevalence_unadjusted_proportion',
                 'hospital_beds_per_1000', 'in_facility_delivery_proportion', 'saturated_fats_kcal_per_capita',
                 'kcal_of_stimulants_per_capita_per_day', 'sugar_kcal_per_capita', 'landlocked_nation_binary',
                 'average_latitude', 'ldi_income_per_capita', 'lead_gas_outphase_binary',
                 'low_elevation_coastal_zone_under_10m_proportion', 'live_births_thousands',
                 'ln_kcals_of_fiber_consumed_per_capita_per_day', 'ln_total_calories_consumed_as_hydrogenated_oil',
                 'ln_percent_of_total_calories_consumed_as_eggs',
                 'ln_percent_of_total_calories_consumed_as_rape_and_mustard_seed_and_oil',
                 'ln_percent_of_total_calories_consumed_as_soybean_and_soy_oil',
                 'underweight_proportion_less_than_2sd_weight_for_age_less_than_5_years',
                 'malnutrition_shock_binary', 'mean_bmi', 'cholesterol_total_mean_per_capita',
                 'systolic_blood_pressure_mmhg', 'population_weighted_mean_temperature', 'measles_incidence_rate',
                 'measles_natural_history_death_rate', 'measles_notification_rate',
                 'measles_vaccine_coverage_proportion', 'measles_vaccine_supp_coverage_binary',
                 'meningitis_belt_binary', 'ln_milk_kcal_per_capita',
                 'mortality_rate_due_to_death_shocks_in_last_10_years_per_1_person',
                 'mortality_rate_due_to_conflict_in_last_10_years_per_1_person', 'nuts_and_seeds_kcal_per_capita',
                 'opium_cultivation_binary', 'percent_of_total_calories_consumed_as_animal_fat',
                 'live_births_35_and_up_proportion', 'live_births_40_and_up_proportion',
                 'percent_of_total_calories_consumed_as_fruits', 'percent_of_total_calories_consumed_as_legumes',
                 'percent_of_total_calories_consumed_as_milk',
                 'percent_of_total_calories_consumed_as_nuts_and_seeds',
                 'percent_of_total_calories_consumed_as_pig_meat', 'percent_of_total_calories_consumed_as_pufa',
                 'percent_of_total_calories_consumed_as_pufa3', 'percent_of_total_calories_consumed_as_pufa6',
                 'percent_of_total_calories_consumed_as_red_meat',
                 'percent_of_total_calories_consumed_as_saturated_fat',
                 'percent_of_total_calories_consumed_as_sugar', 'percent_of_total_calories_consumed_as_vegetables',
                 'percent_of_total_calories_consumed_as_non_wheat_whole_grains', 'pig_meat_kg_per_capita',
                 'pigs_per_capita', 'coal_reserves_binary', 'coal_reserves_teragrams_per_capita',
                 'indoor_air_pollution_biomass_cooking', 'indoor_air_pollution_coal_cooking',
                 'indoor_air_pollution_all_cooking_fuels', 'outdoor_air_pollution_pm_2_5',
                 'latitude_under_15_proportion', 'elevation_100_to_500m_proportion',
                 'elevation_over_1500m_proportion', 'population_15_to_30_proportion', 'latitude_15_to_30_proportion',
                 'latitude_30_to_45_proportion', 'latitude_over_45_proportion', 'elevation_500_to_1500m_proportion',
                 'population_density_150_300_ppl_sqkm_proportion', 'population_density_300_500_ppl_sqkm_proportion',
                 'population_density_500_1000_ppl_sqkm_proportion',
                 'population_density_over_1000_ppl_sqkm_proportion',
                 'population_density_under_150_ppl_sqkm_proportion', 'population_over_65_proportion',
                 'elevation_under_100m_proportion', 'population_under_30_proportion', 'pufa_kcal_per_capita',
                 'pufa_omega_3_seafood_kcal_per_capita', 'pufa_omega_6_vegetable_oils_kcal_per_capita',
                 'pulses_and_legumes_kcal_per_capita', 'rainfall_population_weighted_mm_yr',
                 'rainfall_quintiles_2_5', 'rainfall_quintiles_3_5', 'rainfall_quintiles_4_5',
                 'rainfall_quintile_1_proportion', 'rainfall_quintile_2_proportion',
                 'rainfall_quintile_3_proportion', 'rainfall_quintile_4_proportion',
                 'rainfall_quintile_5_proportion', 'red_meat_kcal_per_capita',
                 'religion_binary_greater_than_50_percent_muslim', '_percent_packaged_foods_sold_via_retail',
                 '_percent_fats_oils_sold_via_retail', 'rotavirus_vaccine_introduced_binary',
                 'sahel_region_of_africa_binary', 'sanitation_proportion_with_access',
                 'skilled_birth_attendance_proportion', 'sheep_per_capita', 'smoking_prevalence',
                 'smoking_prevalence_reproductive_age_standardized',
                 'ninetieth_percentile_climatic_temperature_in_the_given_country_year',
                 'tetanus_toxoid_coverage_smooth_proportion', 'total_fertility_rate',
                 'total_calories_kcal_per_capita', 'total_packaged_foods_sold_via_retail_tonnes_per_capita',
                 'total_fats_oils_sold_via_retail_tonnes_per_capita', 'vegetables_kcal_per_capita',
                 'vehicles_2_and_up4_wheels_per_capita', 'vehicles_2_wheels_per_capita',
                 'vehicles_4_wheels_per_capita', 'vehicles_2_wheels_fraction_proportion',
                 'vitamin_a_deficiency_prevalence_children_under_5', 'mortality_rate_due_to_war_shocks_per_1_person',
                 'improved_water_source_proportion_with_access', 'whole_grains_kcal_per_capita',
                 'non_wheat_whole_grains_kcal_per_capita', 'itn_adjusted_pfpr_rate',
                 'itn_mortality_reduction_proportion', 'malaria_any_binary', 'malaria_chloroquine_resistance',
                 'malaria_chloroquine_resistance_2', 'malaria_endemicity_0_5_percent',
                 'malaria_endemicity_5_40_percent', 'malaria_endemicity_none', 'malaria_falciparum_binary',
                 'malaria_lysenko_pfpr_2_hyperendemic', 'malaria_lysenko_pfpr_3_medoendemic',
                 'malaria_lysenko_pfpr_4_hypoendemic', 'malaria_lysenko_pfpr_5_epidemic',
                 'map_malaria_mortality_reduction_proportion', 'malaria_s_p_resistance', 'malaria_s_p_resistance_2',
                 'itn_coverage_proportion', 'malaria_endemicity_40_100_percent', 'malaria_endemicity_5_100_percent',
                 'malaria_indoor_residual_spraying_coverage', 'malaria_lysenko_pfpr_1_holoendemic',
                 'malaria_lysenko_pfpr_2_highest_endemicity', 'malaria_lysenko_pfpr_3_highest_endemicity',
                 'malaria_lysenko_pfpr_4_highest_endemicity', 'malaria_population_at_risk_proportion',
                 'malaria_pfpr_rate', 'malaria_prevalence_weighted_resistance', 'malaria_vivax_binary',
                 'malaria_pfpr_with_itn_rate', 'significant_leishmaniasis_endemicity_binary',
                 'leprosy_endemic_binary', 'yellow_fever_endemicity_binary', 'year',
                 'chagas_population_at_risk_2_proportion', 'birth_prevalence_of_chd',
                 'birth_prevalence_of_congenital_chromosomal_anomalies', 'dengue_incidence_per_1000_v7',
                 'hemoglobinopathies_prevalence_x_excess_mortality', 'hepatitis_a_prevalence_proportion',
                 'hepatitis_b_prevalence_proportion', 'hepatitis_c_prevalence_proportion',
                 'hepatitis_e_prevalence_proportion', 'age_standardize_prevalence_of_severe_anemia',
                 'schistosomiasis_prevalence_proportion', 'population_at_risk_of_trachoma_proportion',
                 'maternal_care_and_immunization', 'neonatal_mortality_rate_modeled_2_per_1000',
                 'pcv3_coverage_proportion', 'presence_of_leishmaniasis_binary',
                 'potential_for_leishmaniasis_transmission_binary', 'high_leishmaniasis_endemicity_binary',
                 'under_5_hiv_death_rate', 'interaction_of_malaria_itn_and_pfpr_rate_covariates',
                 'interaction_of_malaria_itn_and_log_pfpr_covariates',
                 'malaria_pfpr_adjusted_for_itn_and_irs_coverage', 'syphilis_prevalence_proportion',
                 'year_x_gbd_analytical_region_5', 'year_x_gbd_analytical_region_9',
                 'year_x_gbd_analytical_region_21', 'year_x_gbd_analytical_region_32',
                 'year_x_gbd_analytical_region_42', 'year_x_gbd_analytical_region_56',
                 'year_x_gbd_analytical_region_65', 'year_x_gbd_analytical_region_70',
                 'year_x_gbd_analytical_region_73', 'year_x_gbd_analytical_region_96',
                 'year_x_gbd_analytical_region_100', 'year_x_gbd_analytical_region_104',
                 'year_x_gbd_analytical_region_120', 'year_x_gbd_analytical_region_124',
                 'year_x_gbd_analytical_region_134', 'year_x_gbd_analytical_region_138',
                 'year_x_gbd_analytical_region_159', 'year_x_gbd_analytical_region_167',
                 'year_x_gbd_analytical_region_174', 'year_x_gbd_analytical_region_192',
                 'year_x_gbd_analytical_region_199', 'year_x_gbd_analytical_superregion_4',
                 'year_x_gbd_analytical_superregion_31', 'year_x_gbd_analytical_superregion_64',
                 'year_x_gbd_analytical_superregion_103', 'year_x_gbd_analytical_superregion_137',
                 'year_x_gbd_analytical_superregion_158', 'year_x_gbd_analytical_superregion_166',
                 'population_weighted_probability_of_dengue_transmission', 'dengue_outbreaks_binary',
                 'exponentiated_version_of_dengue_anomalies',
                 'proportion_of_the_population_living_in_the_classic_monsoon_region',
                 'proportion_of_the_population_living_in_the_classic_monsoon_region_low_income_countries',
                 'dengue_anomalies_deviation_from_mean_dengue_incidence_rate', 'population_at_risk_for_lf_infection',
                 'pc_treatments_per_person_at_risk_for_lf_infection',
                 'total_pc_treatments_per_person_at_risk_for_lf_infection_1999_2012',
                 'smoking_prevalence_age_standardized_females', 'smoking_prevalence_age_standardized_males',
                 'hiv_prevalence_during_pregnancy_by_age',
                 'cumulative_to_date_pc_treatment_per_person_at_risk_1999_2012',
                 'indicator_for_high_income_superregion_location_id_64', 'vitamin_a_supplementation_coverage_rate',
                 'hemoglobinopathies_prevalence_x_excess_mortality_excluding_g6pd_deficiency',
                 'hepatitis_c_prevalence_proportion_capped',
                 'hepatitis_b_prevalence_based_on_gbd_2013_dismod_models',
                 'hepatitis_c_prevalence_based_on_gbd_2013_dismod_models',
                 'indicator_for_southeast_asia_east_asia_and_oceania_superregion_location_id_4',
                 'indicator_for_central_europe_eastern_europe_and_central_asia_superregion_location_id_31',
                 'indicator_for_latin_america_and_caribbean_superregion_location_id_103',
                 'indicator_for_north_africa_and_middle_east_superregion_location_id_137',
                 'indicator_for_south_asia_superregion_location_id_158',
                 'indicator_for_sub_saharan_africa_superregion_location_id_166', 'patterns_of_drinking_score_who',
                 'alcohol_binge_drinker_proportion_age_standardized',
                 'patterns_of_drinking_score_who__indicator_for_score_1',
                 'patterns_of_drinking_score_who__indicator_for_score_2',
                 'patterns_of_drinking_score_who__indicator_for_score_3',
                 'patterns_of_drinking_score_who__indicator_for_score_4',
                 'patterns_of_drinking_score_who__indicator_for_score_5',
                 '_improved_water_source_proportion_with_access_based_on_gbd_2010_definition',
                 'pre_control_prevalence_of_infection_with_lymphatic_filariasis_within_endemic_areas',
                 'seroprevalence_of_varicella', 'smoking_prevalence_age_standardized_both_sexes',
                 'mortality_rate_due_to_war_and_disaster_greater_than_1_10000_binary',
                 'mortality_rate_due_to_war_and_disaster_greater_than_1_10000_in_last_ten_years_binary',
                 'animal_fats_kcal_per_capita_interaction_term_for_eap_super_region',
                 'ln_total_calories_consumed_as_hydrogenated_oil_interaction_term_for_eap_super_region',
                 'percent_of_total_calories_consumed_as_fruits_interaction_term_for_eap_super_region',
                 'percent_of_total_calories_consumed_as_legumes_interaction_term_for_eap_super_region',
                 'percent_of_total_calories_consumed_as_nuts_and_seeds_interaction_term_for_eap_super_region',
                 'percent_of_total_calories_consumed_as_pufa3_interaction_term_for_eap_super_region',
                 'percent_of_total_calories_consumed_as_saturated_fat_interaction_term_for_eap_super_region',
                 'percent_of_total_calories_consumed_as_sugar_interaction_term_for_eap_super_region',
                 'percent_of_total_calories_consumed_as_non_wheat_whole_grains_interaction_term_for_eap_super_region',
                 'pig_meat_kg_per_capita_interaction_term_for_eap_super_region',
                 'pufa_kcal_per_capita_interaction_term_for_eap_super_region',
                 'red_meat_kcal_per_capita_interaction_term_for_eap_super_region',
                 'animal_fats_kcal_per_capita_interaction_term_for_eeca_super_region',
                 'ln_total_calories_consumed_as_hydrogenated_oil_interaction_term_for_eeca_super_region',
                 'percent_of_total_calories_consumed_as_fruits_interaction_term_for_eeca_super_region',
                 'percent_of_total_calories_consumed_as_legumes_interaction_term_for_eeca_super_region',
                 'percent_of_total_calories_consumed_as_nuts_and_seeds_interaction_term_for_eeca_super_region',
                 'percent_of_total_calories_consumed_as_pufa3_interaction_term_for_eeca_super_region',
                 'percent_of_total_calories_consumed_as_saturated_fat_interaction_term_for_eeca_super_region',
                 'percent_of_total_calories_consumed_as_sugar_interaction_term_for_eeca_super_region',
                 'percent_of_total_calories_consumed_as_non_wheat_whole_grains_interaction_term_for_eeca_super_region',
                 'pig_meat_kg_per_capita_interaction_term_for_eeca_super_region',
                 'pufa_kcal_per_capita_interaction_term_for_eeca_super_region',
                 'red_meat_kcal_per_capita_interaction_term_for_eeca_super_region',
                 'animal_fats_kcal_per_capita_interaction_term_for_hi_super_region',
                 'ln_total_calories_consumed_as_hydrogenated_oil_interaction_term_for_hi_super_region',
                 'percent_of_total_calories_consumed_as_fruits_interaction_term_for_hi_super_region',
                 'percent_of_total_calories_consumed_as_legumes_interaction_term_for_hi_super_region',
                 'percent_of_total_calories_consumed_as_nuts_and_seeds_interaction_term_for_hi_super_region',
                 'percent_of_total_calories_consumed_as_pufa3_interaction_term_for_hi_super_region',
                 'percent_of_total_calories_consumed_as_saturated_fat_interaction_term_for_hi_super_region',
                 'percent_of_total_calories_consumed_as_sugar_interaction_term_for_hi_super_region',
                 'percent_of_total_calories_consumed_as_non_wheat_whole_grains_interaction_term_for_hi_super_region',
                 'pig_meat_kg_per_capita_interaction_term_for_hi_super_region',
                 'pufa_kcal_per_capita_interaction_term_for_hi_super_region',
                 'red_meat_kcal_per_capita_interaction_term_for_hi_super_region',
                 'animal_fats_kcal_per_capita_interaction_term_for_lac_super_region',
                 'ln_total_calories_consumed_as_hydrogenated_oil_interaction_term_for_lac_super_region',
                 'percent_of_total_calories_consumed_as_fruits_interaction_term_for_lac_super_region',
                 'percent_of_total_calories_consumed_as_legumes_interaction_term_for_lac_super_region',
                 'percent_of_total_calories_consumed_as_nuts_and_seeds_interaction_term_for_lac_super_region',
                 'percent_of_total_calories_consumed_as_pufa3_interaction_term_for_lac_super_region',
                 'percent_of_total_calories_consumed_as_saturated_fat_interaction_term_for_lac_super_region',
                 'percent_of_total_calories_consumed_as_sugar_interaction_term_for_lac_super_region',
                 'percent_of_total_calories_consumed_as_non_wheat_whole_grains_interaction_term_for_lac_super_region',
                 'pig_meat_kg_per_capita_interaction_term_for_lac_super_region',
                 'pufa_kcal_per_capita_interaction_term_for_lac_super_region',
                 'red_meat_kcal_per_capita_interaction_term_for_lac_super_region',
                 'animal_fats_kcal_per_capita_interaction_term_for_name_super_region',
                 'ln_total_calories_consumed_as_hydrogenated_oil_interaction_term_for_name_super_region',
                 'percent_of_total_calories_consumed_as_fruits_interaction_term_for_name_super_region',
                 'percent_of_total_calories_consumed_as_legumes_interaction_term_for_name_super_region',
                 'percent_of_total_calories_consumed_as_nuts_and_seeds_interaction_term_for_name_super_region',
                 'percent_of_total_calories_consumed_as_pufa3_interaction_term_for_name_super_region',
                 'percent_of_total_calories_consumed_as_saturated_fat_interaction_term_for_name_super_region',
                 'percent_of_total_calories_consumed_as_sugar_interaction_term_for_name_super_region',
                 'percent_of_total_calories_consumed_as_non_wheat_whole_grains_interaction_term_for_name_super_region',
                 'pig_meat_kg_per_capita_interaction_term_for_name_super_region',
                 'pufa_kcal_per_capita_interaction_term_for_name_super_region',
                 'red_meat_kcal_per_capita_interaction_term_for_name_super_region',
                 'animal_fats_kcal_per_capita_interaction_term_for_sa_super_region',
                 'ln_total_calories_consumed_as_hydrogenated_oil_interaction_term_for_sa_super_region',
                 'percent_of_total_calories_consumed_as_fruits_interaction_term_for_sa_super_region',
                 'percent_of_total_calories_consumed_as_legumes_interaction_term_for_sa_super_region',
                 'percent_of_total_calories_consumed_as_nuts_and_seeds_interaction_term_for_sa_super_region',
                 'percent_of_total_calories_consumed_as_pufa3_interaction_term_for_sa_super_region',
                 'percent_of_total_calories_consumed_as_saturated_fat_interaction_term_for_sa_super_region',
                 'percent_of_total_calories_consumed_as_sugar_interaction_term_for_sa_super_region',
                 'percent_of_total_calories_consumed_as_non_wheat_whole_grains_interaction_term_for_sa_super_region',
                 'pig_meat_kg_per_capita_interaction_term_for_sa_super_region',
                 'pufa_kcal_per_capita_interaction_term_for_sa_super_region',
                 'red_meat_kcal_per_capita_interaction_term_for_sa_super_region',
                 'animal_fats_kcal_per_capita_interaction_term_for_ssa_super_region',
                 'ln_total_calories_consumed_as_hydrogenated_oil_interaction_term_for_ssa_super_region',
                 'percent_of_total_calories_consumed_as_fruits_interaction_term_for_ssa_super_region',
                 'percent_of_total_calories_consumed_as_legumes_interaction_term_for_ssa_super_region',
                 'percent_of_total_calories_consumed_as_nuts_and_seeds_interaction_term_for_ssa_super_region',
                 'percent_of_total_calories_consumed_as_pufa3_interaction_term_for_ssa_super_region',
                 'percent_of_total_calories_consumed_as_saturated_fat_interaction_term_for_ssa_super_region',
                 'percent_of_total_calories_consumed_as_sugar_interaction_term_for_ssa_super_region',
                 'percent_of_total_calories_consumed_as_non_wheat_whole_grains_interaction_term_for_ssa_super_region',
                 'pig_meat_kg_per_capita_interaction_term_for_ssa_super_region',
                 'pufa_kcal_per_capita_interaction_term_for_ssa_super_region',
                 'red_meat_kcal_per_capita_interaction_term_for_ssa_super_region',
                 'age_standardized_death_rate_for_endocrince_metabolic_blood_and_immune_disorders',
                 'log_age_standardized_melanoma_incidence',
                 'chagas_specific_mortality_rate_among_the_at_risk_population_ten_year_lag',
                 'asbestos_production_per_capita_offset_by_non_zero_minimum',
                 'coal_production_per_capita_offset_by_non_zero_minimum',
                 'gold_production_per_capita_offset_by_non_zero_minimum',
                 'proportion_of_the_population_living_in_the_indian_ocean_monsoon_belt',
                 'vitamin_a_deficiency_prevalence_age_standardized',
                 'population_at_risk_of_trachoma_modeled_proportion',
                 'saturated_fats_and_animal_fats_kcal_per_capita',
                 'percent_of_total_calories_consumed_as_saturated_and_animal_fats',
                 'percent_of_total_calories_consumed_as_saturated_and_animal_fats_interaction_term_for_eap_super_region',
                 'percent_of_total_calories_consumed_as_saturated_and_animal_fats_interaction_term_for_eeca_super_region',
                 'percent_of_total_calories_consumed_as_saturated_and_animal_fats_interaction_term_for_hi_super_region',
                 'percent_of_total_calories_consumed_as_saturated_and_animal_fats_interaction_term_for_lac_super_region',
                 'percent_of_total_calories_consumed_as_saturated_and_animal_fats_interaction_term_for_name_super_region',
                 'percent_of_total_calories_consumed_as_saturated_and_animal_fats_interaction_term_for_sa_super_region',
                 'percent_of_total_calories_consumed_as_saturated_and_animal_fats_interaction_term_for_ssa_super_region',
                 'prevalence_of_obesity', 'prevalence_of_overweight_and_obesity',
                 'prevalence_of_obesity_age_standardized', 'age_standardized_prevalence_of_ckd_stage_3',
                 'age_standardized_prevalence_of_ckd_stage_4_dismod_model_33304',
                 'age_standardized_prevalence_of_ckd_stage_4_dismod_model_33309',
                 'age_standardized_prevalence_of_ckd_stage_4_dismod_model_33314',
                 'age_standardized_prevalence_of_ckd_stage_4', 'red_meat_w_o_pig_meat_kcal_per_capita',
                 'percent_of_total_calories_consumed_as_red_meat_w_o_pig_meat',
                 'maternal_education_years_per_capita', 'scaled_adult_hiv_rate', 'chagasprevpaho',
                 'proportion_of_the_land_with_altitude_between_1000_2500_meters_above_sea_level',
                 'clay_fraction_in_the_soil_mean', 'silt_fraction_in_the_soil_mean',
                 'enhanced_vegetation_index_long_term_average_2000_2012_mean',
                 'slope_of_the_land_in_degrees_terrain_steepness_mean', 'log_transformed_sev_scalar_tb',
                 'deprecated_log_transformed_sev_scalar_hiv_myco', 'log_transformed_sev_scalar_oth_hiv',
                 'log_transformed_sev_scalar_diarrhea', 'deprecated_log_transformed_sev_scalar_intest_inf',
                 'deprecated_log_transformed_sev_scalar_typhoid', 'deprecated_log_transformed_sev_scalar_paratyph',
                 'deprecated_log_transformed_sev_scalar_oth_intest', 'log_transformed_sev_scalar_lri',
                 'log_transformed_sev_scalar_uri', 'log_transformed_sev_scalar_otitis',
                 'log_transformed_sev_scalar_meningitis', 'deprecated_log_transformed_sev_scalar_mng_pne',
                 'deprecated_log_transformed_sev_scalar_mng_hib', 'deprecated_log_transformed_sev_scalar_mng_men',
                 'deprecated_log_transformed_sev_scalar_oth_mng', 'deprecated_log_transformed_sev_scalar_encepha',
                 'deprecated_log_transformed_sev_scalar_diphtheria',
                 'deprecated_log_transformed_sev_scalar_whooping', 'deprecated_log_transformed_sev_scalar_tetanus',
                 'log_transformed_sev_scalar_measles', 'deprecated_log_transformed_sev_scalar_varicella',
                 'deprecated_log_transformed_sev_scalar_malaria', 'deprecated_log_transformed_sev_scalar_chagas',
                 'deprecated_log_transformed_sev_scalar_leish', 'deprecated_log_transformed_sev_scalar_vis_leish',
                 'deprecated_log_transformed_sev_scalar_cut_leish', 'deprecated_log_transformed_sev_scalar_afr_tryp',
                 'deprecated_log_transformed_sev_scalar_schisto', 'deprecated_log_transformed_sev_scalar_cysticer',
                 'deprecated_log_transformed_sev_scalar_echino', 'deprecated_log_transformed_sev_scalar_lf',
                 'deprecated_log_transformed_sev_scalar_oncho', 'deprecated_log_transformed_sev_scalar_trachoma',
                 'deprecated_log_transformed_sev_scalar_dengue', 'deprecated_log_transformed_sev_scalar_yellow_fev',
                 'deprecated_log_transformed_sev_scalar_rabies', 'deprecated_log_transformed_sev_scalar_nematode',
                 'deprecated_log_transformed_sev_scalar_ascaria', 'deprecated_log_transformed_sev_scalar_trichuria',
                 'deprecated_log_transformed_sev_scalar_hookworm', 'deprecated_log_transformed_sev_scalar_fb_trema',
                 'deprecated_log_transformed_sev_scalar_oth_ntd', 'log_transformed_sev_scalar_mat_hem',
                 'log_transformed_sev_scalar_mat_sepsis', 'log_transformed_sev_scalar_mat_htn',
                 'deprecated_log_transformed_sev_scalar_mat_obst', 'log_transformed_sev_scalar_comp_abort',
                 'log_transformed_sev_scalar_mat_indir', 'log_transformed_sev_scalar_mat_late',
                 'log_transformed_sev_scalar_oth_mat', 'deprecated_log_transformed_sev_scalar_nn_preterm',
                 'deprecated_log_transformed_sev_scalar_nn_enceph',
                 'deprecated_log_transformed_sev_scalar_nn_sepsis', 'deprecated_log_transformed_sev_scalar_nn_hemol',
                 'deprecated_log_transformed_sev_scalar_oth_nn', 'deprecated_log_transformed_sev_scalar_iodine',
                 'deprecated_log_transformed_sev_scalar_oth_nutr', 'log_transformed_sev_scalar_hep',
                 'deprecated_log_transformed_sev_scalar_hep_a', 'log_transformed_sev_scalar_hep_b',
                 'log_transformed_sev_scalar_hep_c', 'deprecated_log_transformed_sev_scalar_hep_e',
                 'deprecated_log_transformed_sev_scalar_leprosy', 'deprecated_log_transformed_sev_scalar_oth_inf',
                 'log_transformed_sev_scalar_esophag_c', 'log_transformed_sev_scalar_stomach_c',
                 'log_transformed_sev_scalar_liver_c', 'log_transformed_sev_scalar_liver_c_hepb',
                 'log_transformed_sev_scalar_liver_c_hepc', 'log_transformed_sev_scalar_oth_liver_c',
                 'log_transformed_sev_scalar_larynx_c', 'log_transformed_sev_scalar_lung_c',
                 'log_transformed_sev_scalar_breast_c', 'log_transformed_sev_scalar_uterus_c',
                 'log_transformed_sev_scalar_prostate_c', 'log_transformed_sev_scalar_colorect_c',
                 'log_transformed_sev_scalar_lip_oral_c', 'log_transformed_sev_scalar_nasoph_c',
                 'log_transformed_sev_scalar_oth_phar_c', 'log_transformed_sev_scalar_gallblad_c',
                 'log_transformed_sev_scalar_pancreas_c', 'deprecated_log_transformed_sev_scalar_melanoma',
                 'deprecated_log_transformed_sev_scalar_skin_c', 'log_transformed_sev_scalar_ovary_c',
                 'deprecated_log_transformed_sev_scalar_testis_c', 'log_transformed_sev_scalar_kidney_c',
                 'log_transformed_sev_scalar_bladder_c', 'deprecated_log_transformed_sev_scalar_brain_c',
                 'log_transformed_sev_scalar_thyroid_c', 'log_transformed_sev_scalar_mesothel',
                 'deprecated_log_transformed_sev_scalar_hodgkin', 'deprecated_log_transformed_sev_scalar_lymphoma',
                 'deprecated_log_transformed_sev_scalar_myeloma', 'log_transformed_sev_scalar_leukemia',
                 'deprecated_log_transformed_sev_scalar_oth_neopla', 'log_transformed_sev_scalar_rhd',
                 'log_transformed_sev_scalar_ihd', 'log_transformed_sev_scalar_stroke',
                 'log_transformed_sev_scalar_isch_stroke', 'log_transformed_sev_scalar_intrahem_stroke',
                 'log_transformed_sev_scalar_cmp', 'log_transformed_sev_scalar_a_fib',
                 'log_transformed_sev_scalar_aort_an', 'log_transformed_sev_scalar_pad',
                 'log_transformed_sev_scalar_endocar', 'log_transformed_sev_scalar_oth_cardio',
                 'log_transformed_sev_scalar_copd', 'deprecated_log_transformed_sev_scalar_pneumocon',
                 'deprecated_log_transformed_sev_scalar_silicosis',
                 'deprecated_log_transformed_sev_scalar_asbestosis', 'deprecated_log_transformed_sev_scalar_coal_w',
                 'deprecated_log_transformed_sev_scalar_oth_pneum', 'log_transformed_sev_scalar_asthma',
                 'log_transformed_sev_scalar_ild', 'log_transformed_sev_scalar_oth_resp',
                 'log_transformed_sev_scalar_cirr_hepb', 'log_transformed_sev_scalar_cirr_hepc',
                 'deprecated_log_transformed_sev_scalar_oth_cirr', 'deprecated_log_transformed_sev_scalar_pud',
                 'deprecated_log_transformed_sev_scalar_gastritis',
                 'deprecated_log_transformed_sev_scalar_appendicit', 'deprecated_log_transformed_sev_scalar_ileus',
                 'deprecated_log_transformed_sev_scalar_hernia', 'deprecated_log_transformed_sev_scalar_ibd',
                 'deprecated_log_transformed_sev_scalar_vasc_intest',
                 'deprecated_log_transformed_sev_scalar_gall_bile', 'log_transformed_sev_scalar_pancreatit',
                 'deprecated_log_transformed_sev_scalar_oth_digest',
                 'deprecated_log_transformed_sev_scalar_alzheimer',
                 'deprecated_log_transformed_sev_scalar_parkinson', 'log_transformed_sev_scalar_idiopathic_epilepsy',
                 'deprecated_log_transformed_sev_scalar_ms', 'deprecated_log_transformed_sev_scalar_migraine',
                 'deprecated_log_transformed_sev_scalar_tens_head', 'deprecated_log_transformed_sev_scalar_med_head',
                 'deprecated_log_transformed_sev_scalar_oth_neuro', 'deprecated_log_transformed_sev_scalar_schizo',
                 'log_transformed_sev_scalar_depression', 'log_transformed_sev_scalar_mdd',
                 'deprecated_log_transformed_sev_scalar_dysthymia', 'deprecated_log_transformed_sev_scalar_bipolar',
                 'log_transformed_sev_scalar_anxiety', 'deprecated_log_transformed_sev_scalar_eating',
                 'deprecated_log_transformed_sev_scalar_anorexia', 'deprecated_log_transformed_sev_scalar_bulimia',
                 'deprecated_log_transformed_sev_scalar_asd', 'deprecated_log_transformed_sev_scalar_autism',
                 'deprecated_log_transformed_sev_scalar_asperger', 'deprecated_log_transformed_sev_scalar_adhd',
                 'deprecated_log_transformed_sev_scalar_conduct', 'log_transformed_sev_scalar_id',
                 'deprecated_log_transformed_sev_scalar_oth_ment', 'deprecated_log_transformed_sev_scalar_agn',
                 'deprecated_log_transformed_sev_scalar_urinary', 'deprecated_log_transformed_sev_scalar_int_neph',
                 'deprecated_log_transformed_sev_scalar_urolith', 'deprecated_log_transformed_sev_scalar_bph',
                 'deprecated_log_transformed_sev_scalar_infert_m', 'deprecated_log_transformed_sev_scalar_oth_urin',
                 'deprecated_log_transformed_sev_scalar_gyne', 'deprecated_log_transformed_sev_scalar_fibroids',
                 'deprecated_log_transformed_sev_scalar_pcos', 'deprecated_log_transformed_sev_scalar_infert_f',
                 'deprecated_log_transformed_sev_scalar_endomet', 'deprecated_log_transformed_sev_scalar_prolapse',
                 'deprecated_log_transformed_sev_scalar_pms', 'deprecated_log_transformed_sev_scalar_oth_gyne',
                 'deprecated_log_transformed_sev_scalar_hemog', 'deprecated_log_transformed_sev_scalar_thalass',
                 'deprecated_log_transformed_sev_scalar_sickle', 'deprecated_log_transformed_sev_scalar_g6pd',
                 'deprecated_log_transformed_sev_scalar_oth_hem', 'deprecated_log_transformed_sev_scalar_endocrine',
                 'deprecated_log_transformed_sev_scalar_rheu_arth', 'log_transformed_sev_scalar_osteoarth',
                 'log_transformed_sev_scalar_back_and_upneck', 'log_transformed_sev_scalar_back_pain',
                 'deprecated_log_transformed_sev_scalar_neck_pain', 'log_transformed_sev_scalar_gout',
                 'deprecated_log_transformed_sev_scalar_oth_msk', 'deprecated_log_transformed_sev_scalar_congenital',
                 'deprecated_log_transformed_sev_scalar_neur_tube',
                 'deprecated_log_transformed_sev_scalar_cong_heart', 'deprecated_log_transformed_sev_scalar_cleft',
                 'deprecated_log_transformed_sev_scalar_down', 'deprecated_log_transformed_sev_scalar_turner',
                 'deprecated_log_transformed_sev_scalar_klinefelter',
                 'deprecated_log_transformed_sev_scalar_chrom_unb', 'deprecated_log_transformed_sev_scalar_oth_cong',
                 'deprecated_log_transformed_sev_scalar_skin', 'deprecated_log_transformed_sev_scalar_dermatitis',
                 'deprecated_log_transformed_sev_scalar_psoriasis',
                 'deprecated_log_transformed_sev_scalar_cellulitis',
                 'deprecated_log_transformed_sev_scalar_pyoderma', 'deprecated_log_transformed_sev_scalar_scabies',
                 'deprecated_log_transformed_sev_scalar_skin_fung',
                 'deprecated_log_transformed_sev_scalar_skin_viral', 'deprecated_log_transformed_sev_scalar_acne',
                 'deprecated_log_transformed_sev_scalar_alopecia', 'deprecated_log_transformed_sev_scalar_pruritus',
                 'deprecated_log_transformed_sev_scalar_urticaria',
                 'deprecated_log_transformed_sev_scalar_decubitus', 'deprecated_log_transformed_sev_scalar_oth_skin',
                 'log_transformed_sev_scalar_sense', 'deprecated_log_transformed_sev_scalar_glaucoma',
                 'log_transformed_sev_scalar_cataract', 'deprecated_log_transformed_sev_scalar_macular',
                 'deprecated_log_transformed_sev_scalar_refraction', 'log_transformed_sev_scalar_hearing',
                 'deprecated_log_transformed_sev_scalar_oth_vision',
                 'deprecated_log_transformed_sev_scalar_oth_sense', 'deprecated_log_transformed_sev_scalar_oral',
                 'deprecated_log_transformed_sev_scalar_dec_caries',
                 'deprecated_log_transformed_sev_scalar_per_caries', 'deprecated_log_transformed_sev_scalar_period',
                 'deprecated_log_transformed_sev_scalar_edentul', 'deprecated_log_transformed_sev_scalar_oth_oral',
                 'log_transformed_sev_scalar_sids', 'log_transformed_sev_scalar_road_inj',
                 'log_transformed_sev_scalar_pedest', 'log_transformed_sev_scalar_cyclist',
                 'log_transformed_sev_scalar_mot_cyc', 'log_transformed_sev_scalar_mot_veh',
                 'log_transformed_sev_scalar_oth_road', 'log_transformed_sev_scalar_oth_trans',
                 'log_transformed_sev_scalar_falls', 'log_transformed_sev_scalar_drown',
                 'log_transformed_sev_scalar_fire', 'log_transformed_sev_scalar_poison',
                 'log_transformed_sev_scalar_mech', 'log_transformed_sev_scalar_mech_gun',
                 'log_transformed_sev_scalar_mech_suff', 'log_transformed_sev_scalar_oth_mech',
                 'deprecated_log_transformed_sev_scalar_med_treat', 'log_transformed_sev_scalar_animal',
                 'log_transformed_sev_scalar_venom', 'log_transformed_sev_scalar_non_ven',
                 'log_transformed_sev_scalar_f_body', 'log_transformed_sev_scalar_f_body_asp',
                 'log_transformed_sev_scalar_f_body_eye', 'log_transformed_sev_scalar_oth_f_body',
                 'log_transformed_sev_scalar_oth_unint', 'log_transformed_sev_scalar_self_harm',
                 'log_transformed_sev_scalar_violence', 'log_transformed_sev_scalar_viol_gun',
                 'log_transformed_sev_scalar_viol_knife', 'log_transformed_sev_scalar_oth_viol',
                 'log_transformed_sev_scalar_disaster', 'deprecated_log_transformed_sev_scalar_war',
                 'log_transformed_sev_scalar_mat_hiv', 'deprecated_log_transformed_sev_scalar_thalass_trait',
                 'deprecated_log_transformed_sev_scalar_sickle_trait',
                 'deprecated_log_transformed_sev_scalar_g6pd_trait',
                 'log_transformed_age_standardized_sev_scalar_tb',
                 'deprecated_log_transformed_age_standardized_sev_scalar_hiv_myco',
                 'log_transformed_age_standardized_sev_scalar_oth_hiv',
                 'log_transformed_age_standardized_sev_scalar_diarrhea',
                 'deprecated_log_transformed_age_standardized_sev_scalar_intest_inf',
                 'deprecated_log_transformed_age_standardized_sev_scalar_typhoid',
                 'deprecated_log_transformed_age_standardized_sev_scalar_paratyph',
                 'log_transformed_age_standardized_sev_scalar_lri',
                 'log_transformed_age_standardized_sev_scalar_uri',
                 'log_transformed_age_standardized_sev_scalar_otitis',
                 'log_transformed_age_standardized_sev_scalar_measles',
                 'log_transformed_age_standardized_sev_scalar_mat_hem',
                 'log_transformed_age_standardized_sev_scalar_mat_sepsis',
                 'log_transformed_age_standardized_sev_scalar_comp_abort',
                 'log_transformed_age_standardized_sev_scalar_hep',
                 'log_transformed_age_standardized_sev_scalar_hep_b',
                 'log_transformed_age_standardized_sev_scalar_hep_c',
                 'log_transformed_age_standardized_sev_scalar_esophag_c',
                 'log_transformed_age_standardized_sev_scalar_stomach_c',
                 'log_transformed_age_standardized_sev_scalar_liver_c',
                 'log_transformed_age_standardized_sev_scalar_liver_c_hepb',
                 'log_transformed_age_standardized_sev_scalar_liver_c_hepc',
                 'log_transformed_age_standardized_sev_scalar_oth_liver_c',
                 'log_transformed_age_standardized_sev_scalar_larynx_c',
                 'log_transformed_age_standardized_sev_scalar_lung_c',
                 'log_transformed_age_standardized_sev_scalar_breast_c',
                 'log_transformed_age_standardized_sev_scalar_uterus_c',
                 'log_transformed_age_standardized_sev_scalar_prostate_c',
                 'log_transformed_age_standardized_sev_scalar_colorect_c',
                 'log_transformed_age_standardized_sev_scalar_lip_oral_c',
                 'log_transformed_age_standardized_sev_scalar_nasoph_c',
                 'log_transformed_age_standardized_sev_scalar_oth_phar_c',
                 'log_transformed_age_standardized_sev_scalar_gallblad_c',
                 'log_transformed_age_standardized_sev_scalar_pancreas_c',
                 'log_transformed_age_standardized_sev_scalar_ovary_c',
                 'log_transformed_age_standardized_sev_scalar_kidney_c',
                 'log_transformed_age_standardized_sev_scalar_bladder_c',
                 'log_transformed_age_standardized_sev_scalar_thyroid_c',
                 'log_transformed_age_standardized_sev_scalar_mesothel',
                 'log_transformed_age_standardized_sev_scalar_leukemia',
                 'log_transformed_age_standardized_sev_scalar_rhd',
                 'log_transformed_age_standardized_sev_scalar_ihd',
                 'log_transformed_age_standardized_sev_scalar_stroke',
                 'log_transformed_age_standardized_sev_scalar_isch_stroke',
                 'log_transformed_age_standardized_sev_scalar_intrahem_stroke',
                 'log_transformed_age_standardized_sev_scalar_cmp',
                 'log_transformed_age_standardized_sev_scalar_a_fib',
                 'log_transformed_age_standardized_sev_scalar_aort_an',
                 'log_transformed_age_standardized_sev_scalar_pad',
                 'log_transformed_age_standardized_sev_scalar_endocar',
                 'log_transformed_age_standardized_sev_scalar_oth_cardio',
                 'log_transformed_age_standardized_sev_scalar_copd',
                 'deprecated_log_transformed_age_standardized_sev_scalar_pneumocon',
                 'deprecated_log_transformed_age_standardized_sev_scalar_silicosis',
                 'deprecated_log_transformed_age_standardized_sev_scalar_asbestosis',
                 'deprecated_log_transformed_age_standardized_sev_scalar_coal_w',
                 'deprecated_log_transformed_age_standardized_sev_scalar_oth_pneum',
                 'log_transformed_age_standardized_sev_scalar_asthma',
                 'log_transformed_age_standardized_sev_scalar_ild',
                 'log_transformed_age_standardized_sev_scalar_oth_resp',
                 'log_transformed_age_standardized_sev_scalar_cirr_hepb',
                 'log_transformed_age_standardized_sev_scalar_cirr_hepc',
                 'deprecated_log_transformed_age_standardized_sev_scalar_oth_cirr',
                 'log_transformed_age_standardized_sev_scalar_pancreatit',
                 'log_transformed_age_standardized_sev_scalar_idiopathic_epilepsy',
                 'log_transformed_age_standardized_sev_scalar_depression',
                 'log_transformed_age_standardized_sev_scalar_mdd',
                 'deprecated_log_transformed_age_standardized_sev_scalar_dysthymia',
                 'log_transformed_age_standardized_sev_scalar_id',
                 'log_transformed_age_standardized_sev_scalar_osteoarth',
                 'log_transformed_age_standardized_sev_scalar_back_and_upneck',
                 'log_transformed_age_standardized_sev_scalar_back_pain',
                 'log_transformed_age_standardized_sev_scalar_gout',
                 'log_transformed_age_standardized_sev_scalar_sense',
                 'log_transformed_age_standardized_sev_scalar_cataract',
                 'log_transformed_age_standardized_sev_scalar_hearing',
                 'log_transformed_age_standardized_sev_scalar_road_inj',
                 'log_transformed_age_standardized_sev_scalar_pedest',
                 'log_transformed_age_standardized_sev_scalar_cyclist',
                 'log_transformed_age_standardized_sev_scalar_mot_cyc',
                 'log_transformed_age_standardized_sev_scalar_mot_veh',
                 'log_transformed_age_standardized_sev_scalar_oth_road',
                 'log_transformed_age_standardized_sev_scalar_oth_trans',
                 'log_transformed_age_standardized_sev_scalar_falls',
                 'log_transformed_age_standardized_sev_scalar_drown',
                 'log_transformed_age_standardized_sev_scalar_fire',
                 'log_transformed_age_standardized_sev_scalar_poison',
                 'log_transformed_age_standardized_sev_scalar_mech',
                 'log_transformed_age_standardized_sev_scalar_mech_gun',
                 'log_transformed_age_standardized_sev_scalar_mech_suff',
                 'log_transformed_age_standardized_sev_scalar_oth_mech',
                 'log_transformed_age_standardized_sev_scalar_animal',
                 'log_transformed_age_standardized_sev_scalar_venom',
                 'log_transformed_age_standardized_sev_scalar_non_ven',
                 'log_transformed_age_standardized_sev_scalar_f_body',
                 'log_transformed_age_standardized_sev_scalar_f_body_asp',
                 'log_transformed_age_standardized_sev_scalar_f_body_eye',
                 'log_transformed_age_standardized_sev_scalar_oth_f_body',
                 'log_transformed_age_standardized_sev_scalar_oth_unint',
                 'log_transformed_age_standardized_sev_scalar_self_harm',
                 'log_transformed_age_standardized_sev_scalar_violence',
                 'log_transformed_age_standardized_sev_scalar_viol_gun',
                 'log_transformed_age_standardized_sev_scalar_viol_knife',
                 'log_transformed_age_standardized_sev_scalar_oth_viol',
                 'deprecated_log_transformed_age_standardized_sev_scalar_disaster', 'h5n1_epidemic_years_binary',
                 'education_age_standardized', 'meningitis_belt_proportion', 'gdp_per_capita_base_2010',
                 'urbanicity', 'age_and_sex_specific_sev_for_unsafe_water',
                 'age_and_sex_specific_sev_for_unsafe_sanitation', 'malaria_incidence_from_map_estimates_africa',
                 'dengue_reporting_trends_transformed_into_relative_risks_relative_to_that_countrys_mean_incidence',
                 'echinococcosis_endemicity', 'echinococcosis_presence', 'socio_demographic_index',
                 'japanese_encelphalitis_endemic_area_binary', 'calcium_adjusted_g', 'calcium_unadjusted_g',
                 'diet_cholesterol_adjusted_mg', 'diet_cholesterol_unadjusted_mg', 'fiber_adjusted_g',
                 'fiber_unadjusted_g', 'omega_3_adjusted_g', 'omega_3_unadjusted_g', 'fruits_adjusted_g',
                 'fruits_unadjusted_g', 'milk_adjusted_g', 'milk_unadjusted_g', 'nuts_seeds_adjusted_g',
                 'nuts_seeds_unadjusted_g', 'pufa_adjusted_percent', 'pulses_legumes_adjusted_g',
                 'pulses_legumes_unadjusted_g', 'red_meats_adjusted_g', 'red_meats_unadjusted_g', 'salt_adjusted_mg',
                 'salt_unadjusted_mg', 'saturated_fats_adjusted_percent', 'stimulants_adjusted_g',
                 'stimulants_unadjusted_g', 'sugar_adjusted_g', 'sugar_unadjusted_g', 'vegetables_adjusted_g',
                 'vegetables_unadjusted_g', 'whole_grains_adjusted_g', 'whole_grains_unadjusted_g',
                 'energy_unadjusted_kcal',
                 'interaction_of_prevalence_weighted_drug_resistance_and_malaria_incidence',
                 'migration_rate_per_1000_population', 'hiv_mortality_females_10_54',
                 'hiv_age_standardized_prevalence', 'log_transformed_age_standardized_sev_scalar_maternal',
                 'log_transformed_age_standardized_sev_scalar_cvd',
                 'log_transformed_age_standardized_sev_scalar_chr_resp',
                 'log_transformed_age_standardized_sev_scalar_cirrhosis',
                 'log_transformed_age_standardized_sev_scalar_digestive',
                 'log_transformed_age_standardized_sev_scalar_msk',
                 'log_transformed_age_standardized_sev_scalar_trans_inj', 'log_transformed_sev_scalar_maternal',
                 'log_transformed_sev_scalar_cvd', 'log_transformed_sev_scalar_chr_resp',
                 'log_transformed_sev_scalar_cirrhosis', 'log_transformed_sev_scalar_digestive',
                 'log_transformed_sev_scalar_msk', 'log_transformed_sev_scalar_trans_inj',
                 'proportion_of_total_population_in_japanese_encephalitis_endemic_area_india',
                 'vitamin_a_unadjusted_iu', 'vitamin_a_rae_unadjusted_ug', 'vitamin_a_retinol_unadjusted_ug',
                 'dietary_zinc_unadjusted_mg', 'death_and_ncc_prevalence_ratio',
                 'cysticercosis_deaths_to_epilepsy_prevalence_ratio',
                 'proportion_of_total_population_covered_by_menafrivac_initiative_meningitis_meningococcal_type_a_vaccine',
                 'stunting_proportion_less_than_2sd_height_for_age_less_than_5_years',
                 'wasting_proportion_less_than_2sd_weight_for_height_less_than_5_years',
                 'malnutrition_childhood_underweight_proportion_less_than_2sd_weight_for_age',
                 'malaria_incidence_adjusted_for_antimalarial_coverage_and_drug_effectiveness',
                 'hepatitis_b_hbsag_seroprevalence', 'hepatitis_c_igg_seroprevalence',
                 'rotavirus_coverage_proportion', 'proportion_of_cirrhosis_due_to_alcohol',
                 'proportion_of_cirrhosis_due_to_hepatitis_b', 'proportion_of_cirrhosis_due_to_hepatitis_c',
                 'proportion_of_cirrhosis_due_to_other_causes',
                 'proportion_of_liver_cancer_due_to_alcohol_age_standardized',
                 'proportion_of_liver_cancer_due_to_hepatitis_b_age_standardized',
                 'proportion_of_liver_cancer_due_to_hepatitis_c_age_standardized',
                 'proportion_of_liver_cancer_due_to_other_causes_age_standardized', 'seroprevalence_of_anti_hav_igg',
                 'seroprevalence_of_anti_hev_igg', 'major_depressive_disorder',
                 'proportion_of_population_involved_in_agricultural_activities', 'prevalence_of_binge_drinking_male',
                 'health_expenditure_per_capita', 'risk_of_selfharm_due_to_major_depressive_disorder',
                 'trans_fatty_acid_bans', 'oop_health_expenditure_per_capita', 'fraction_of_oop_health_expenditure',
                 'lag_distributed_energy', 'art_coverage', 'tuberculosis_case_detection',
                 'universal_health_coverage', 'maternal_alcohol_consumption_during_pregnancy_proportion',
                 'healthcare_access_and_quality_index', 'age_standardized_proportion_adult_underweight',
                 'reproductive_age_standardized_diabetes_prevalence_10_54_yrs_females', 'ors_oral_rehydration',
                 'antibiotics_for_lri', 'zinc_treatment', 'antibiotics_for_diarrhea', 'live_births_by_sex',
                 'age_standardized_melanoma', 'measles_vaccine_coverage_2_doses_proportion', 'sth_school_based_mda',
                 'schisto_cumulative_treatments', 'health_worker_density',
                 'proportion_of_fevers_receiving_effective_treatment', 'iron_energy_unadjusted_mg',
                 'corn_energy_adjusted_g', 'corn_energy_unadjusted_g', 'eggs_energy_adjusted_g',
                 'eggs_energy_unadjusted_g', 'fish_energy_adjusted_g', 'fish_energy_unadjusted_g',
                 'potatoes_energy_adjusted_g', 'potatoes_energy_unadjusted_g', 'poultry_energy_adjusted_g',
                 'poultry_energy_unadjusted_g', 'rice_energy_adjusted_g', 'rice_energy_unadjusted_g',
                 'sweet_energy_potato_adjusted_g', 'sweet_energy_potato_unadjusted_g', 'malaria_pfpr_map',
                 'malaria_incidence_map', 'antimalarial_effective_treatment_ratio_map',
                 'antimalarial_effective_treatment_map', 'risk_of_selfharm_due_to_schizophrenia',
                 'risk_of_selfharm_due_to_anxiety_disorders', 'risk_of_selfharm_due_to_bipolar_disorder',
                 'mean_birth_weight', 'mean_weight_for_height_z_score_whz_0_5_years',
                 'mean_weight_for_age_z_score_waz_0_5_years', 'mean_height_for_age_z_score_haz_0_5_years',
                 'mean_hemoglobin_concentration_age_standardized',
                 'birth_prevalence_of_fetal_alcohol_syndrome_per_1000',
                 'age_standardized_prevalence_of_cocaine_dependence_in_women_of_reproductive_age',
                 'age_standardized_prevalence_of_amphetamine_dependence_in_women_of_reproductive_age',
                 'age_standardized_prevalence_of_opioid_dependence_in_women_of_reproductive_age',
                 'age_standardized_prevalence_of_cannabis_dependence_in_women_of_reproductive_age',
                 'age_standardized_prevalence_of_total_drug_dependence_in_women_of_reproductive_age',
                 'rubella_vaccine_coverage_proportion',
                 'tuberculosis_infection_risk_weighted_prevalence_age_standardized', 'presenting_vision_impairment',
                 'ten_year_lag_distributed_energy_per_capita',
                 'alcohol_consumption_female_reproductive_age_standardized_grams_per_day',
                 'alcohol_consumption_female_reproductive_age_standardized_proportion', 'folic_acid_unadjusted_ug',
                 'smooth_outphase_of_leaded_gasoline', 'no_access_to_handwashing_facility', 'residential_radon',
                 'lead_exposure', 'discontinued_breastfeeding_sev', 'zinc_deficiency', 'diet_low_in_whole_grains',
                 'diet_high_in_processed_meat', 'diet_high_in_trans_fatty_acids', 'diet_high_in_sodium',
                 'low_physical_activity_sev', 'tuberculosis_prevalence_age_standardized', 'low_bone_mineral_density',
                 'age_standardized_bone_mineral_density_among_population_age_60_and_up_years',
                 'malnutrition_shock_log_transformed_mortality_rate', 'malnutrition_shock_mortality_rate',
                 'mean_war_mortality_rate_in_the_previous_ten_years', 'shock_log_transformed_mortality_rate',
                 'shock_mortality_rate', 'disaster_log_transformed_mortality_rate', 'disaster_mortality_rate',
                 'state_actor_violence_log_transformed_mortality_rate', 'state_actor_violence_mortality_rate',
                 'war_log_transformed_mortality_rate', 'war_mortality_rate', 'age_standardized_melanoma_incidence',
                 'alcohol_abstainer_proportion_age_standardized',
                 'log_transformed_age_standardized_sev_scalar_for_both_sexes_combined_tb', 'secondhand_smoke',
                 'saturated_fatty_acid_consumption__percent_of_total_dietary_energy',
                 'asbestos_consumption_metric_tons_per_year_per_capita', 'visceral_leishmaniasis_incidence',
                 'homicide_rate_sex_specific', 'op_visits_per_cap', 'ip_admissons_per_cap',
                 'non_partner_lifetime_prevalence_of_sexual_violence_female_only', 'all_age_underweight',
                 'zinc_treatment_for_diarrhea', 'fortification_standard',
                 'fortification_standard_including_folic_acid', 'adult_hiv_crude_death_rate',
                 'demand_for_contraception_satisfied_with_modern_methods',
                 'demand_for_contraception_satisfied_with_modern_methods_by_age',
                 'long_term_population_weighted_mean_temperature', 'polio_3_dose_coverage_proportion',
                 'hepatitis_b_3_dose_coverage_proportion',
                 'proportion_of_the_population_from_east_africa_india_central_asia',
                 'proportion_of_the_population_from_west_africa', 'proportion_of_the_population_from_euro_america',
                 'proportion_of_the_population_from_east_asia', 'proportion_of_the_population_from_indo_oceania',
                 'composite_fortification_standard_and_folic_acid_inclusion',
                 'intravenous_drug_use_proportion_by_age', 'intravenous_drug_use_age_standardized_proportion',
                 'hepatitis_a_infection_incidence', 'alcohol_consumption_age_standardized_in_grams_per_day',
                 'alcohol_drinker_proportion_age_standardized', 'hepatitis_b_infection_incidence',
                 'hepatitis_c_infection_incidence', 'hepatitis_e_infection_incidence',
                 'proportion_of_liver_cancer_due_to_nash_age_standardized', 'proportion_of_cirrhosis_due_to_nash',
                 'muslim_religion_proportion_of_population', 'echino_endemicity_level_1',
                 'echino_endemicity_level_2', 'echino_endemicity_level_3',
                 'tb_strain_prevalence_weighted_transmission_rr',
                 'tb_strain_prevalence_weighted_treatment_failure_rr',
                 'tb_strain_prevalence_weighted_treatment_delay_rr',
                 'preterm_birth_prevalence_less_than_37_weeks_of_gestation',
                 'extremely_preterm_birth_prevalence_less_than_28_weeks_of_gestation',
                 'short_gestation_sev_all_ages_by_sex', 'age_and_sex_specific_sev_for_child_underweight',
                 'age_standardized_sev_for_child_underweight', 'age_and_sex_specific_sev_for_child_stunting',
                 'age_standardized_sev_for_child_stunting', 'age_and_sex_specific_sev_for_child_wasting',
                 'age_standardized_sev_for_child_wasting', 'low_birth_weight_sev_all_ages_by_sex',
                 'low_birth_weight_and_short_gestation_sev_all_ages_by_sex', 'preeclampsia_incidence_ratio_all_ages',
                 'abo_blood_type_mismatch_at_birth', 'rhesus_blood_type_mismatch_at_birth',
                 'adult_hiv_death_rate_both_sexes', 'fortification_standard_including_iron',
                 'composite_fortification_standard_and_iron_inclusion',
                 'pelvic_inflammatory_disease_age_standardized_prevalence',
                 'pelvic_inflammatory_disease_all_age_prevalence', 'nafld_nash_prevalence',
                 'hepatitis_b_3_dose_coverage_proportion_lagged_5_years',
                 'hepatitis_b_3_dose_coverage_proportion_lagged_ten_years',
                 'interaction_between_sdi_and_2_and_up4_wheeled_vehicles_per_capita',
                 'age_standardized_death_rate_of_diabetes_0_15_years_per_100_000',
                 'age_and_sex_specific_sev_for_alcohol_use', 'age_standardized_sev_for_alcohol_use',
                 'underweight_women_of_reproductive_age', 'underweight_women_age_specific',
                 'underweight_men_age_specific', 'opioids_per_million_population_per_day',
                 'prevalence_of_mtbc_lineage_1_strains_proportion',
                 'prevalence_of_mtbc_lineage_2_strains_proportion',
                 'prevalence_of_mtbc_lineage_3_strains_proportion',
                 'prevalence_of_mtbc_lineage_4_strains_proportion', 'prevalence_of_maf_lineage_5_and_6_proportion',
                 'log_transformed_sev_scalar_group_i', 'log_transformed_sev_scalar_drug_sus_tb',
                 'log_transformed_sev_scalar_mdr_tb', 'log_transformed_sev_scalar_xdr_tb',
                 'log_transformed_sev_scalar_hiv', 'log_transformed_sev_scalar_drug_sus_hiv_tb',
                 'log_transformed_sev_scalar_mdr_hiv_tb', 'log_transformed_sev_scalar_xdr_hiv_tb',
                 'log_transformed_sev_scalar_mng_pne', 'log_transformed_sev_scalar_mng_hib',
                 'log_transformed_sev_scalar_mng_men', 'log_transformed_sev_scalar_oth_mng',
                 'log_transformed_sev_scalar_encepha', 'deprecated_log_transformed_sev_scalar_diptheria',
                 'deprecated_log_transformed_sev_scalar_neonatal_preterm', 'log_transformed_sev_scalar_nn_enceph',
                 'log_transformed_sev_scalar_nn_sepsis', 'log_transformed_sev_scalar_nn_hemol',
                 'log_transformed_sev_scalar_oth_nn', 'deprecated_log_transformed_sev_scalar_nutrition_pem',
                 'deprecated_log_transformed_sev_scalar_nutrition_vitamina',
                 'deprecated_log_transformed_sev_scalar_nutrition_iron', 'deprecated_log_transformed_sev_scalar_sti',
                 'deprecated_log_transformed_sev_scalar_std_syphilis',
                 'deprecated_log_transformed_sev_scalar_std_chlamydia',
                 'deprecated_log_transformed_sev_scalar_std_gonnorhea',
                 'deprecated_log_transformed_sev_scalar_std_tricho',
                 'deprecated_log_transformed_sev_scalar_std_herpes',
                 'deprecated_log_transformed_sev_scalar_std_other', 'log_transformed_sev_scalar_ncd',
                 'deprecated_log_transformed_sev_scalar_neo_liver_alcohol',
                 'deprecated_log_transformed_sev_scalar_neo_cervical', 'log_transformed_sev_scalar_lymphoma',
                 'log_transformed_sev_scalar_myeloma', 'log_transformed_sev_scalar_all',
                 'log_transformed_sev_scalar_cll', 'log_transformed_sev_scalar_aml',
                 'log_transformed_sev_scalar_cml', 'log_transformed_sev_scalar_oth_leukemia',
                 'deprecated_log_transformed_sev_scalar_cvd_htn',
                 'deprecated_log_transformed_sev_scalar_cvd_cmp_alcoholic', 'log_transformed_sev_scalar_oth_cmp',
                 'deprecated_log_transformed_sev_scalar_cirrhosis_alcohol', 'log_transformed_sev_scalar_pud',
                 'log_transformed_sev_scalar_gall_bile', 'log_transformed_sev_scalar_alzheimers',
                 'deprecated_log_transformed_sev_scalar_parkinsons', 'log_transformed_sev_scalar_ms',
                 'deprecated_log_transformed_sev_scalar_mental_alcohol',
                 'deprecated_log_transformed_sev_scalar_drugs',
                 'deprecated_log_transformed_sev_scalar_mental_drug_opioids',
                 'deprecated_log_transformed_sev_scalar_mental_drug_cocaine',
                 'deprecated_log_transformed_sev_scalar_mental_drug_amphet',
                 'deprecated_log_transformed_sev_scalar_mental_drug_cannabis',
                 'deprecated_log_transformed_sev_scalar_mental_drug_other',
                 'deprecated_log_transformed_sev_scalar_diabetes', 'deprecated_log_transformed_sev_scalar_ckd',
                 'deprecated_log_transformed_sev_scalar_ckd_diabetes',
                 'deprecated_log_transformed_sev_scalar_ckd_htn',
                 'deprecated_log_transformed_sev_scalar_ckd_glomerulo',
                 'deprecated_log_transformed_sev_scalar_ckd_other', 'log_transformed_sev_scalar_rheu_arth',
                 'log_transformed_sev_scalar_glaucoma', 'log_transformed_sev_scalar_macular',
                 'log_transformed_sev_scalar_injuries', 'log_transformed_sev_scalar_self_fire',
                 'log_transformed_sev_scalar_self_other', 'log_transformed_sev_scalar_sex_viol',
                 'log_transformed_age_standardized_sev_scalar_group_i',
                 'log_transformed_age_standardized_sev_scalar_drug_sus_tb',
                 'log_transformed_age_standardized_sev_scalar_mdr_tb',
                 'log_transformed_age_standardized_sev_scalar_xdr_tb',
                 'log_transformed_age_standardized_sev_scalar_hiv',
                 'log_transformed_age_standardized_sev_scalar_drug_sus_hiv_tb',
                 'log_transformed_age_standardized_sev_scalar_mdr_hiv_tb',
                 'log_transformed_age_standardized_sev_scalar_xdr_hiv_tb',
                 'log_transformed_age_standardized_sev_scalar_meningitis',
                 'log_transformed_age_standardized_sev_scalar_mng_pne',
                 'log_transformed_age_standardized_sev_scalar_mng_hib',
                 'log_transformed_age_standardized_sev_scalar_mng_men',
                 'log_transformed_age_standardized_sev_scalar_oth_mng',
                 'log_transformed_age_standardized_sev_scalar_encepha',
                 'deprecated_log_transformed_age_standardized_sev_scalar_diptheria',
                 'deprecated_log_transformed_age_standardized_sev_scalar_whooping',
                 'deprecated_log_transformed_age_standardized_sev_scalar_tetanus',
                 'deprecated_log_transformed_age_standardized_sev_scalar_neonatal_preterm',
                 'log_transformed_age_standardized_sev_scalar_nn_enceph',
                 'log_transformed_age_standardized_sev_scalar_nn_sepsis',
                 'log_transformed_age_standardized_sev_scalar_nn_hemol',
                 'log_transformed_age_standardized_sev_scalar_oth_nn',
                 'deprecated_log_transformed_age_standardized_sev_scalar_nutrition_pem',
                 'deprecated_log_transformed_age_standardized_sev_scalar_nutrition_vitamina',
                 'deprecated_log_transformed_age_standardized_sev_scalar_nutrition_iron',
                 'deprecated_log_transformed_age_standardized_sev_scalar_sti',
                 'deprecated_log_transformed_age_standardized_sev_scalar_std_syphilis',
                 'deprecated_log_transformed_age_standardized_sev_scalar_std_chlamydia',
                 'deprecated_log_transformed_age_standardized_sev_scalar_std_gonnorhea',
                 'deprecated_log_transformed_age_standardized_sev_scalar_std_tricho',
                 'deprecated_log_transformed_age_standardized_sev_scalar_std_herpes',
                 'deprecated_log_transformed_age_standardized_sev_scalar_std_other',
                 'deprecated_log_transformed_age_standardized_sev_scalar_ncd',
                 'deprecated_log_transformed_age_standardized_sev_scalar_neo_liver_alcohol',
                 'deprecated_log_transformed_age_standardized_sev_scalar_neo_cervical',
                 'log_transformed_age_standardized_sev_scalar_lymphoma',
                 'log_transformed_age_standardized_sev_scalar_myeloma',
                 'log_transformed_age_standardized_sev_scalar_all',
                 'log_transformed_age_standardized_sev_scalar_cll',
                 'log_transformed_age_standardized_sev_scalar_aml',
                 'log_transformed_age_standardized_sev_scalar_cml',
                 'log_transformed_age_standardized_sev_scalar_oth_leukemia',
                 'deprecated_log_transformed_age_standardized_sev_scalar_cvd_htn',
                 'deprecated_log_transformed_age_standardized_sev_scalar_cvd_cmp_alcoholic',
                 'log_transformed_age_standardized_sev_scalar_oth_cmp',
                 'deprecated_log_transformed_age_standardized_sev_scalar_cirrhosis_alcohol',
                 'log_transformed_age_standardized_sev_scalar_pud',
                 'log_transformed_age_standardized_sev_scalar_gall_bile',
                 'log_transformed_age_standardized_sev_scalar_alzheimers',
                 'deprecated_log_transformed_age_standardized_sev_scalar_parkinsons',
                 'log_transformed_age_standardized_sev_scalar_ms',
                 'deprecated_log_transformed_age_standardized_sev_scalar_mental_alcohol',
                 'deprecated_log_transformed_age_standardized_sev_scalar_drugs',
                 'deprecated_log_transformed_age_standardized_sev_scalar_mental_drug_opioids',
                 'deprecated_log_transformed_age_standardized_sev_scalar_mental_drug_cocaine',
                 'deprecated_log_transformed_age_standardized_sev_scalar_mental_drug_amphet',
                 'deprecated_log_transformed_age_standardized_sev_scalar_mental_drug_cannabis',
                 'deprecated_log_transformed_age_standardized_sev_scalar_mental_drug_other',
                 'deprecated_log_transformed_age_standardized_sev_scalar_diabetes',
                 'deprecated_log_transformed_age_standardized_sev_scalar_ckd',
                 'deprecated_log_transformed_age_standardized_sev_scalar_ckd_diabetes',
                 'deprecated_log_transformed_age_standardized_sev_scalar_ckd_htn',
                 'deprecated_log_transformed_age_standardized_sev_scalar_ckd_glomerulo',
                 'deprecated_log_transformed_age_standardized_sev_scalar_ckd_other',
                 'log_transformed_age_standardized_sev_scalar_rheu_arth',
                 'log_transformed_age_standardized_sev_scalar_glaucoma',
                 'log_transformed_age_standardized_sev_scalar_macular',
                 'log_transformed_age_standardized_sev_scalar_sids',
                 'log_transformed_age_standardized_sev_scalar_injuries',
                 'log_transformed_age_standardized_sev_scalar_self_fire',
                 'log_transformed_age_standardized_sev_scalar_self_other',
                 'log_transformed_age_standardized_sev_scalar_sex_viol',
                 'opioids_per_million_population_per_day_5_year_lag',
                 'opioids_per_million_population_per_day_ten_year_lag', 'occupation_professionals',
                 'health_industry_workers', 'education_years_per_capita_aggregated_by_age_15_and_up_and_sex',
                 'underweight_age_and_sex_specific', 'total_physical_activity_met_min_week_age_specific',
                 'total_physical_activity_met_min_week_age_standardized',
                 'full_vaccine_coverage_indicator_proportion',
                 'bacille_calmette_guerin_bcg_vaccine_coverage_proportion',
                 'hepatitis_b_vaccine_coverage_proportion_aged_through_time',
                 'adolescent_birth_rates_10_19_years_of_age', 'percent_well_certified',
                 'log_total_health_expenditure_per_capita', 'count_of_population_censuses',
                 'birth_registry_completeness', 'pigs_raised_in_extensive_agricultural_systems_per_capita',
                 'pigs_raised_in_semi_extensive_agricultural_systems_per_capita',
                 'pigs_raised_in_intensive_industrial_agricultural_systems_per_capita',
                 'implicit_versus_explicitly_defined_nash', 'mean_hemoglobin_age_sex_specific',
                 'physicians_per_capita', 'nurses_and_midwives_per_capita', 'pharmacists_per_capita',
                 'hiv_mortality_rate', 'untreated_hiv', 'medical_schools', 'dentists_per_capita',
                 'full_vaccine_coverage_indicator_proportion_sage_method_dtp3_pcv3_mcv2', 'net_reproductive_rate',
                 'log_transformed_coal_production_per_capita', 'systolic_blood_pressure_mmhg_us_r_e',
                 'low_density_lipoprotein_mmol_l_us_r_e', 'mean_bmi_kg_m2_us_r_e',
                 'education_years_per_capita_us_r_e', 'ldi_income_per_capita_us_r_e',
                 'fasting_plasma_glucose_us_r_e', 'total_physical_activity_met_min_week_age_specific_us_r_e',
                 'total_physical_activity_met_min_week_age_standardized_us_r_e', 'alcohol_liters_per_capita_us_r_e',
                 'smoking_prevalence_us_r_e', 'outdoor_air_pollution_pm_2_5_us_r_e', 'fruits_unadjusted_g_us_r_e',
                 'vegetables_unadjusted_g_us_r_e', 'proportion_of_the_population_with_at_least_6_years_of_education',
                 'proportion_of_the_population_with_at_least_12_years_of_education',
                 'proportion_of_the_population_with_at_least_15_years_of_education',
                 'education_absolute_inequality_aaid', 'education_relative_inequality_gini',
                 'proportion_of_the_population_with_at_least_6_years_of_education_age_standardized',
                 'proportion_of_the_population_with_at_least_12_years_of_education_age_standardized',
                 'proportion_of_the_population_with_at_least_15_years_of_education_age_standardized',
                 'education_absolute_inequality_aaid_age_standardized',
                 'education_relative_inequality_gini_age_standardized',
                 'proportion_of_the_population_with_at_least_6_years_of_education_maternal',
                 'proportion_of_the_population_with_at_least_12_years_of_education_maternal',
                 'proportion_of_the_population_with_at_least_15_years_of_education_maternal',
                 'education_absolute_inequality_aaid_maternal', 'education_relative_inequality_gini_maternal',
                 'mmr_due_toe_maternal_hemorrhage', 'mmr_due_to_maternal_hypertensive_disorders',
                 'mmr_due_to_abortion_and_miscarriage', 'mmr_due_to_sepsis_and_other_maternal_infections',
                 'mmr_due_to_obstructed_labor', 'mmr_due_to_ectopic_pregnancy', 'mean_hemoglobin',
                 'age_standardized_sev_for_unsafe_water', 'age_standardized_sev_for_unsafe_sanitation',
                 'age_and_sex_specific_sev_for_handwashing', 'age_standardized_sev_for_handwashing',
                 'age_and_sex_specific_sev_for_ambient_particulate_matter',
                 'age_standardized_sev_for_ambient_particulate_matter',
                 'age_and_sex_specific_sev_for_household_air_pollution',
                 'age_standardized_sev_for_household_air_pollution', 'age_and_sex_specific_sev_for_ozone',
                 'age_standardized_sev_for_ozone', 'age_and_sex_specific_sev_for_radon',
                 'age_standardized_sev_for_radon', 'age_and_sex_specific_sev_for_lead',
                 'age_standardized_sev_for_lead', 'age_and_sex_specific_sev_for_occupational_asbestos',
                 'age_standardized_sev_for_occupational_asbestos',
                 'age_and_sex_specific_sev_for_occupational_arsenic',
                 'age_standardized_sev_for_occupational_arsenic',
                 'age_and_sex_specific_sev_for_occupational_benzene',
                 'age_standardized_sev_for_occupational_benzene',
                 'age_and_sex_specific_sev_for_occupational_beryllium',
                 'age_standardized_sev_for_occupational_beryllium',
                 'age_and_sex_specific_sev_for_occupational_cadmium',
                 'age_standardized_sev_for_occupational_cadmium',
                 'age_and_sex_specific_sev_for_occupational_chromium',
                 'age_standardized_sev_for_occupational_chromium',
                 'age_and_sex_specific_sev_for_occupational_diesel', 'age_standardized_sev_for_occupational_diesel',
                 'age_and_sex_specific_sev_for_occupational_formaldehyde',
                 'age_standardized_sev_for_occupational_formaldehyde',
                 'age_and_sex_specific_sev_for_occupational_nickel', 'age_standardized_sev_for_occupational_nickel',
                 'age_and_sex_specific_sev_for_occupational_pah', 'age_standardized_sev_for_occupational_pah',
                 'age_and_sex_specific_sev_for_occupational_silica', 'age_standardized_sev_for_occupational_silica',
                 'age_and_sex_specific_sev_for_occupational_sulfuric_acid',
                 'age_standardized_sev_for_occupational_sulfuric_acid',
                 'age_and_sex_specific_sev_for_occupational_trichloroethylene',
                 'age_standardized_sev_for_occupational_trichloroethylene',
                 'age_and_sex_specific_sev_for_occupational_asthmagens',
                 'age_standardized_sev_for_occupational_asthmagens',
                 'age_and_sex_specific_sev_for_occupational_particulates',
                 'age_standardized_sev_for_occupational_particulates',
                 'age_and_sex_specific_sev_for_occupational_noise', 'age_standardized_sev_for_occupational_noise',
                 'age_and_sex_specific_sev_for_occupational_injury', 'age_standardized_sev_for_occupational_injury',
                 'age_and_sex_specific_sev_for_occupational_ergonomic',
                 'age_standardized_sev_for_occupational_ergonomic',
                 'age_and_sex_specific_sev_for_non_exclusive_breastfeeding',
                 'age_standardized_sev_for_non_exclusive_breastfeeding',
                 'age_and_sex_specific_sev_for_discontinued_breastfeeding',
                 'age_standardized_sev_for_discontinued_breastfeeding',
                 'age_and_sex_specific_sev_for_short_gestation', 'age_standardized_sev_for_short_gestation',
                 'age_and_sex_specific_sev_for_low_birth_weight', 'age_standardized_sev_for_low_birth_weight',
                 'age_and_sex_specific_sev_for_iron_deficiency', 'age_standardized_sev_for_iron_deficiency',
                 'age_and_sex_specific_sev_for_vitamin_a_deficiency',
                 'age_standardized_sev_for_vitamin_a_deficiency', 'age_and_sex_specific_sev_for_zinc_deficiency',
                 'age_standardized_sev_for_zinc_deficiency', 'age_and_sex_specific_sev_for_smoking',
                 'age_standardized_sev_for_smoking', 'age_and_sex_specific_sev_for_chewing_tobacco',
                 'age_standardized_sev_for_chewing_tobacco', 'age_and_sex_specific_sev_for_secondhand_smoke',
                 'age_standardized_sev_for_secondhand_smoke', 'age_and_sex_specific_sev_for_drug_use',
                 'age_standardized_sev_for_drug_use', 'age_and_sex_specific_sev_for_low_fruit',
                 'age_standardized_sev_for_low_fruit', 'age_and_sex_specific_sev_for_low_vegetables',
                 'age_standardized_sev_for_low_vegetables', 'age_and_sex_specific_sev_for_low_legumes',
                 'age_standardized_sev_for_low_legumes', 'age_and_sex_specific_sev_for_low_whole_grains',
                 'age_standardized_sev_for_low_whole_grains', 'age_and_sex_specific_sev_for_low_nuts_and_seeds',
                 'age_standardized_sev_for_low_nuts_and_seeds', 'age_and_sex_specific_sev_for_low_milk',
                 'age_standardized_sev_for_low_milk', 'age_and_sex_specific_sev_for_high_red_meat',
                 'age_standardized_sev_for_high_red_meat', 'age_and_sex_specific_sev_for_high_processed_meat',
                 'age_standardized_sev_for_high_processed_meat',
                 'age_and_sex_specific_sev_for_high_sweetened_beverages',
                 'age_standardized_sev_for_high_sweetened_beverages', 'age_and_sex_specific_sev_for_low_fiber',
                 'age_standardized_sev_for_low_fiber', 'age_and_sex_specific_sev_for_low_calcium',
                 'age_standardized_sev_for_low_calcium', 'age_and_sex_specific_sev_for_low_omega_3',
                 'age_standardized_sev_for_low_omega_3', 'age_and_sex_specific_sev_for_low_pufa',
                 'age_standardized_sev_for_low_pufa', 'age_and_sex_specific_sev_for_high_trans_fat',
                 'age_standardized_sev_for_high_trans_fat', 'age_and_sex_specific_sev_for_high_sodium',
                 'age_standardized_sev_for_high_sodium', 'age_and_sex_specific_sev_for_intimate_partner_violence',
                 'age_standardized_sev_for_intimate_partner_violence',
                 'age_and_sex_specific_sev_for_childhood_sexual_abuse',
                 'age_standardized_sev_for_childhood_sexual_abuse', 'age_and_sex_specific_sev_for_bullying',
                 'age_standardized_sev_for_bullying', 'age_and_sex_specific_sev_for_unsafe_sex',
                 'age_standardized_sev_for_unsafe_sex', 'age_and_sex_specific_sev_for_low_physical_activity',
                 'age_standardized_sev_for_low_physical_activity',
                 'age_and_sex_specific_sev_for_high_fasting_plasma_glucose',
                 'age_standardized_sev_for_high_fasting_plasma_glucose', 'age_and_sex_specific_sev_for_high_ldl',
                 'age_standardized_sev_for_high_ldl', 'age_and_sex_specific_sev_for_high_blood_pressure',
                 'age_standardized_sev_for_high_blood_pressure', 'age_and_sex_specific_sev_for_high_body_mass_index',
                 'age_standardized_sev_for_high_body_mass_index',
                 'age_and_sex_specific_sev_for_low_bone_mineral_density',
                 'age_standardized_sev_for_low_bone_mineral_density',
                 'age_and_sex_specific_sev_for_impaired_kidney_function',
                 'age_standardized_sev_for_impaired_kidney_function',
                 'deprecated_log_transformed_age_standardized_sev_scalar_communicable_maternal_neonatal_and_nutritional_diseases_deprecated',
                 'deprecated_log_transformed_sev_scalar_communicable_maternal_neonatal_and_nutritional_diseases_deprecated',
                 'deprecated_log_transformed_age_standardized_sev_scalar_hiv_aids_extensively_drug_resistant_tuberculosis',
                 'deprecated_log_transformed_sev_scalar_hiv_aids_extensively_drug_resistant_tuberculosis',
                 'deprecated_log_transformed_age_standardized_sev_scalar_sexually_transmitted_infections_excluding_hiv',
                 'deprecated_log_transformed_sev_scalar_sexually_transmitted_infections_excluding_hiv',
                 'deprecated_log_transformed_age_standardized_sev_scalar_extensively_drug_resistant_tuberculosis',
                 'deprecated_log_transformed_sev_scalar_extensively_drug_resistant_tuberculosis',
                 'log_transformed_age_standardized_sev_scalar_obst_labor', 'log_transformed_sev_scalar_obst_labor',
                 'log_transformed_age_standardized_sev_scalar_ectopic_preg',
                 'log_transformed_sev_scalar_ectopic_preg', 'log_transformed_age_standardized_sev_scalar_neonatal',
                 'log_transformed_sev_scalar_neonatal', 'log_transformed_age_standardized_sev_scalar_liver_c_nash',
                 'log_transformed_sev_scalar_liver_c_nash', 'log_transformed_age_standardized_sev_scalar_sub_hem',
                 'log_transformed_sev_scalar_sub_hem', 'log_transformed_age_standardized_sev_scalar_valvular',
                 'log_transformed_sev_scalar_valvular', 'log_transformed_age_standardized_sev_scalar_cavd',
                 'log_transformed_sev_scalar_cavd', 'log_transformed_age_standardized_sev_scalar_upper_digest',
                 'log_transformed_sev_scalar_upper_digest',
                 'deprecated_log_transformed_age_standardized_sev_scalar_parkinsons_disease',
                 'deprecated_log_transformed_sev_scalar_parkinsons_disease',
                 'deprecated_log_transformed_age_standardized_sev_scalar_drug_use_disorders',
                 'deprecated_log_transformed_sev_scalar_drug_use_disorders',
                 'log_transformed_age_standardized_sev_scalar_blindness', 'log_transformed_sev_scalar_blindness',
                 'deprecated_log_transformed_age_standardized_sev_scalar_injuries',
                 'deprecated_log_transformed_sev_scalar_injuries',
                 'log_transformed_age_standardized_sev_scalar_inj_pois_co', 'log_transformed_sev_scalar_inj_pois_co',
                 'log_transformed_age_standardized_sev_scalar_inj_pois_oth',
                 'log_transformed_sev_scalar_inj_pois_oth',
                 'log_transformed_age_standardized_sev_scalar_heat__and_up_cold',
                 'log_transformed_sev_scalar_heat__and_up_cold',
                 'deprecated_log_transformed_age_standardized_sev_scalar_sexual_violence',
                 'deprecated_log_transformed_sev_scalar_sexual_violence',
                 'log_transformed_age_standardized_sev_scalar_mat_htn',
                 'log_transformed_age_standardized_sev_scalar_mat_indir',
                 'log_transformed_age_standardized_sev_scalar_mat_late',
                 'log_transformed_age_standardized_sev_scalar_oth_mat',
                 'log_transformed_age_standardized_sev_scalar_ncd',
                 'log_transformed_age_standardized_sev_scalar_anxiety',
                 'log_transformed_age_standardized_sev_scalar_disaster',
                 'log_transformed_age_standardized_sev_scalar_mat_hiv',
                 'log_transformed_age_standardized_sev_scalar_mat_abort', 'log_transformed_sev_scalar_mat_abort',
                 'proportion_of_the_population_with_0_years_of_education',
                 'proportion_of_the_population_with_0_years_of_education_maternal',
                 'proportion_of_the_population_with_0_years_of_education_age_standardized',
                 'stillbirth_to_live_birth_ratio', 'proportion_pnn_pop_aged_1_5_mo',
                 'proportion_1_4_pop_aged_1_year', 'gallup_negative_experience_index',
                 'hemoglobin_c_sickle_type_c_trait', 'hemoglobin_s_sickle_type_s_trait',
                 'non_steroidal_anti_inflammatory_drug_nsaid_use', 'proton_pump_inhibitor_ppi_use',
                 'direct_antivirals_das_for_hcv', 'proportion_of_the_population_working_in_mining_with_20_year_lag',
                 'gold_production_kg_per_capita_smoothed_with_20_year_lag',
                 'diabetes_fasting_plasma_glucose_mmol_l_by_age',
                 'hepatitis_b_seroprevalence_hbsag_lagged_over_time',
                 'hepatitis_c_seroprevalence_anti_hcv_lagged_over_time',
                 'hepatitis_a_seroprevalence_anti_hav_age_standardized',
                 'hepatitis_b_seroprevalence_hbsag_age_standardized',
                 'hepatitis_c_seroprevalence_anti_hcv_age_standardized',
                 'hepatitis_e_seroprevalence_anti_hev_age_standardized', 'hpv1_coverage_proportion',
                 'bac_law_general_population_quartile', 'bac_law_youth_drivers_quartile',
                 'bac_law_professional_drivers_quartile', 'speed_limit_law_urban_quartile',
                 'speed_limit_law_rural_quartile', 'speed_limit_law_highways_quartile',
                 'seat_belt_frequency__percent', 'menafrivac_campaign_ever_never',
                 'time_since_last_mass_menafrivac_campaign', 'time_since_any_menafrivac_campaign',
                 'liters_of_alcohol_consumed_per_capita', 'live_births_by_childs_sex_and_maternal_age',
                 'twelve__month_non_partner_sexual_violence', 'population_15_to_30_males_proportion',
                 'max_trachoma_population_at_risk', 'schistosomiasis_prevalence_for_gbd_2019_cod_testing',
                 'schistosomiasis_prevalence_results', 'who_sth_mda_coverage',
                 'cystic_echinococcosis_endemicity_level', 'bcg_lagged_five_year_coverage_proportion',
                 'dtp3_lagged_five_year_coverage_proportion', 'mcv1_lagged_five_year_coverage_proportion',
                 'mcv2_lagged_five_year_coverage_proportion', 'polio3_lagged_five_year_coverage_proportion',
                 'rcv1_lagged_five_year_coverage_proportion', 'hib3_lagged_five_year_coverage_proportion',
                 'pcv3_lagged_five_year_coverage_proportion', 'rotac_lagged_five_year_coverage_proportion',
                 'hepb3_lagged_five_year_coverage_proportion', 'vitamin_a_supplementation_age_specific',
                 'proportion_of_population_vulnerable_to_venomous_snakebites', 'inj_time',
                 'mean_number_of_venomous_snake_species', 'tfr_u20_us_r_e', 'dengue_all_age_csmr',
                 'education_years_per_capita_aggregated_by_age_15_and_up_and_sex_us_r_e',
                 'age_and_sex_specific_sev_for_high_temperature', 'age_and_sex_specific_sev_for_low_temperature',
                 'age_standardized_sev_for_high_temperature', 'age_standardized_sev_for_low_temperature',
                 'hpv2_coverage_proportion', 'inpatient_utilization_envelope',
                 'opioid_substitution_therapy_ost_treatment_coverage', 'government_spending_on_health',
                 'liters_of_alcohol_consumed_per_capita_by_age_and_sex', 'total_government_spending',
                 'chronic_hepatitis_c_age_standardized', 'high_risk_menafrivac_coverage_proportion',
                 'vaccine_adjusted_hbsag_serporevalence_age_standardized', 'solar_radiation_downwards',
                 'hib3_transformed_population_level_coverage_including_indirect_effects_proportion',
                 'age_standardized_daily_smoking_prevalence_both_sexes', 'log_transformed_sev_scalar_oth_cirr',
                 'log_transformed_age_standardized_sev_scalar_oth_cirr', 'log_transformed_sev_scalar_burkitt',
                 'log_transformed_age_standardized_sev_scalar_burkitt', 'log_transformed_sev_scalar_oth_lymphoma',
                 'log_transformed_age_standardized_sev_scalar_oth_lymphoma',
                 'log_transformed_sev_scalar_osteoarth_hip',
                 'log_transformed_age_standardized_sev_scalar_osteoarth_hip',
                 'log_transformed_sev_scalar_osteoarth_knee',
                 'log_transformed_age_standardized_sev_scalar_osteoarth_knee', 'ascariasis_prevalence',
                 'custom_age_standardized_and_sex_specific_sev_for_alcohol_use',
                 '_overweight_women_of_reproductive_age', 'sheep_density', 'leprosy_mb_cure_rate',
                 'proportion_of_mb_pb_cases_in_leprosy_population', )

    def __init__(self, **kwargs):
        super().__init__()
        self.abortion_on_demand_illegal_binary = kwargs.get('abortion_on_demand_illegal_binary')
        self.legality_of_abortion = kwargs.get('legality_of_abortion')
        self.absolute_value_of_average_latitude = kwargs.get('absolute_value_of_average_latitude')
        self.average_cholera_cases_across_all_years_over_2010_population = kwargs.get('average_cholera_cases_across_all_years_over_2010_population')
        self.adult_hiv_death_rate = kwargs.get('adult_hiv_death_rate')
        self.alcohol_liters_per_capita = kwargs.get('alcohol_liters_per_capita')
        self.antenatal_care_1_visit_coverage_proportion = kwargs.get('antenatal_care_1_visit_coverage_proportion')
        self.antenatal_care_4_visits_coverage_proportion = kwargs.get('antenatal_care_4_visits_coverage_proportion')
        self.animal_fats_kcal_per_capita = kwargs.get('animal_fats_kcal_per_capita')
        self.arv_coverage_proportion = kwargs.get('arv_coverage_proportion')
        self.asbestos_production_binary = kwargs.get('asbestos_production_binary')
        self.asbestos_production_kg_per_capita = kwargs.get('asbestos_production_kg_per_capita')
        self.age_specific_fertility_rate = kwargs.get('age_specific_fertility_rate')
        self.tobacco_cigarettes_per_capita = kwargs.get('tobacco_cigarettes_per_capita')
        self.coal_production_per_capita = kwargs.get('coal_production_per_capita')
        self.coastal_population_within_10km_proportion = kwargs.get('coastal_population_within_10km_proportion')
        self.completeness_of_vital_registration = kwargs.get('completeness_of_vital_registration')
        self.contraception_modern_prevalence_proportion_by_age = kwargs.get('contraception_modern_prevalence_proportion_by_age')
        self.contraception_modern_prevalence_proportion = kwargs.get('contraception_modern_prevalence_proportion')
        self.contraception_total_prevalence_proportion_by_age = kwargs.get('contraception_total_prevalence_proportion_by_age')
        self.contraception_total_prevalence_proportion = kwargs.get('contraception_total_prevalence_proportion')
        self.contraception_traditional_prevalence_proportion_by_age = kwargs.get('contraception_traditional_prevalence_proportion_by_age')
        self.contraception_traditional_prevalence_proportion = kwargs.get('contraception_traditional_prevalence_proportion')
        self.cumulative_cigarettes_10_years = kwargs.get('cumulative_cigarettes_10_years')
        self.cumulative_cigarettes_15_years = kwargs.get('cumulative_cigarettes_15_years')
        self.cumulative_cigarettes_20_years = kwargs.get('cumulative_cigarettes_20_years')
        self.cumulative_cigarettes_5_years = kwargs.get('cumulative_cigarettes_5_years')
        self.diabetes_fasting_plasma_glucose_mmol_l_age_standardized_25_and_up = kwargs.get('diabetes_fasting_plasma_glucose_mmol_l_age_standardized_25_and_up')
        self.diabetes_age_standardized_prevalence_proportion = kwargs.get('diabetes_age_standardized_prevalence_proportion')
        self.diabetes_age_specific_prevalence_proportion = kwargs.get('diabetes_age_specific_prevalence_proportion')
        self.disaster_deaths_rate_per_1000 = kwargs.get('disaster_deaths_rate_per_1000')
        self.dtp3_coverage_proportion = kwargs.get('dtp3_coverage_proportion')
        self.education_years_per_capita = kwargs.get('education_years_per_capita')
        self.famine_binary = kwargs.get('famine_binary')
        self.fao_composite_factor_1 = kwargs.get('fao_composite_factor_1')
        self.fao_composite_factor_2 = kwargs.get('fao_composite_factor_2')
        self.fao_composite_factor_3 = kwargs.get('fao_composite_factor_3')
        self.fao_composite_factor_4 = kwargs.get('fao_composite_factor_4')
        self.female_hiv_death_rate_per_1_for_ages_15_49 = kwargs.get('female_hiv_death_rate_per_1_for_ages_15_49')
        self.fertility_15_19_year_olds = kwargs.get('fertility_15_19_year_olds')
        self.fruits_kcal_per_capita = kwargs.get('fruits_kcal_per_capita')
        self.gold_production_binary = kwargs.get('gold_production_binary')
        self.gold_production_kg_per_capita = kwargs.get('gold_production_kg_per_capita')
        self.health_system_access_unitless = kwargs.get('health_system_access_unitless')
        self.health_system_access_2_unitless = kwargs.get('health_system_access_2_unitless')
        self.proportion_of_households_using_iodized_salt_adjusted = kwargs.get('proportion_of_households_using_iodized_salt_adjusted')
        self.hib3_vaccine_coverage_proportion = kwargs.get('hib3_vaccine_coverage_proportion')
        self.hiv_prevalence_arv_adjusted_custom_lag__percent = kwargs.get('hiv_prevalence_arv_adjusted_custom_lag__percent')
        self.hiv_prevalence_unadjusted_proportion = kwargs.get('hiv_prevalence_unadjusted_proportion')
        self.hospital_beds_per_1000 = kwargs.get('hospital_beds_per_1000')
        self.in_facility_delivery_proportion = kwargs.get('in_facility_delivery_proportion')
        self.saturated_fats_kcal_per_capita = kwargs.get('saturated_fats_kcal_per_capita')
        self.kcal_of_stimulants_per_capita_per_day = kwargs.get('kcal_of_stimulants_per_capita_per_day')
        self.sugar_kcal_per_capita = kwargs.get('sugar_kcal_per_capita')
        self.landlocked_nation_binary = kwargs.get('landlocked_nation_binary')
        self.average_latitude = kwargs.get('average_latitude')
        self.ldi_income_per_capita = kwargs.get('ldi_income_per_capita')
        self.lead_gas_outphase_binary = kwargs.get('lead_gas_outphase_binary')
        self.low_elevation_coastal_zone_under_10m_proportion = kwargs.get('low_elevation_coastal_zone_under_10m_proportion')
        self.live_births_thousands = kwargs.get('live_births_thousands')
        self.ln_kcals_of_fiber_consumed_per_capita_per_day = kwargs.get('ln_kcals_of_fiber_consumed_per_capita_per_day')
        self.ln_total_calories_consumed_as_hydrogenated_oil = kwargs.get('ln_total_calories_consumed_as_hydrogenated_oil')
        self.ln_percent_of_total_calories_consumed_as_eggs = kwargs.get('ln_percent_of_total_calories_consumed_as_eggs')
        self.ln_percent_of_total_calories_consumed_as_rape_and_mustard_seed_and_oil = kwargs.get('ln_percent_of_total_calories_consumed_as_rape_and_mustard_seed_and_oil')
        self.ln_percent_of_total_calories_consumed_as_soybean_and_soy_oil = kwargs.get('ln_percent_of_total_calories_consumed_as_soybean_and_soy_oil')
        self.underweight_proportion_less_than_2sd_weight_for_age_less_than_5_years = kwargs.get('underweight_proportion_less_than_2sd_weight_for_age_less_than_5_years')
        self.malnutrition_shock_binary = kwargs.get('malnutrition_shock_binary')
        self.mean_bmi = kwargs.get('mean_bmi')
        self.cholesterol_total_mean_per_capita = kwargs.get('cholesterol_total_mean_per_capita')
        self.systolic_blood_pressure_mmhg = kwargs.get('systolic_blood_pressure_mmhg')
        self.population_weighted_mean_temperature = kwargs.get('population_weighted_mean_temperature')
        self.measles_incidence_rate = kwargs.get('measles_incidence_rate')
        self.measles_natural_history_death_rate = kwargs.get('measles_natural_history_death_rate')
        self.measles_notification_rate = kwargs.get('measles_notification_rate')
        self.measles_vaccine_coverage_proportion = kwargs.get('measles_vaccine_coverage_proportion')
        self.measles_vaccine_supp_coverage_binary = kwargs.get('measles_vaccine_supp_coverage_binary')
        self.meningitis_belt_binary = kwargs.get('meningitis_belt_binary')
        self.ln_milk_kcal_per_capita = kwargs.get('ln_milk_kcal_per_capita')
        self.mortality_rate_due_to_death_shocks_in_last_10_years_per_1_person = kwargs.get('mortality_rate_due_to_death_shocks_in_last_10_years_per_1_person')
        self.mortality_rate_due_to_conflict_in_last_10_years_per_1_person = kwargs.get('mortality_rate_due_to_conflict_in_last_10_years_per_1_person')
        self.nuts_and_seeds_kcal_per_capita = kwargs.get('nuts_and_seeds_kcal_per_capita')
        self.opium_cultivation_binary = kwargs.get('opium_cultivation_binary')
        self.percent_of_total_calories_consumed_as_animal_fat = kwargs.get('percent_of_total_calories_consumed_as_animal_fat')
        self.live_births_35_and_up_proportion = kwargs.get('live_births_35_and_up_proportion')
        self.live_births_40_and_up_proportion = kwargs.get('live_births_40_and_up_proportion')
        self.percent_of_total_calories_consumed_as_fruits = kwargs.get('percent_of_total_calories_consumed_as_fruits')
        self.percent_of_total_calories_consumed_as_legumes = kwargs.get('percent_of_total_calories_consumed_as_legumes')
        self.percent_of_total_calories_consumed_as_milk = kwargs.get('percent_of_total_calories_consumed_as_milk')
        self.percent_of_total_calories_consumed_as_nuts_and_seeds = kwargs.get('percent_of_total_calories_consumed_as_nuts_and_seeds')
        self.percent_of_total_calories_consumed_as_pig_meat = kwargs.get('percent_of_total_calories_consumed_as_pig_meat')
        self.percent_of_total_calories_consumed_as_pufa = kwargs.get('percent_of_total_calories_consumed_as_pufa')
        self.percent_of_total_calories_consumed_as_pufa3 = kwargs.get('percent_of_total_calories_consumed_as_pufa3')
        self.percent_of_total_calories_consumed_as_pufa6 = kwargs.get('percent_of_total_calories_consumed_as_pufa6')
        self.percent_of_total_calories_consumed_as_red_meat = kwargs.get('percent_of_total_calories_consumed_as_red_meat')
        self.percent_of_total_calories_consumed_as_saturated_fat = kwargs.get('percent_of_total_calories_consumed_as_saturated_fat')
        self.percent_of_total_calories_consumed_as_sugar = kwargs.get('percent_of_total_calories_consumed_as_sugar')
        self.percent_of_total_calories_consumed_as_vegetables = kwargs.get('percent_of_total_calories_consumed_as_vegetables')
        self.percent_of_total_calories_consumed_as_non_wheat_whole_grains = kwargs.get('percent_of_total_calories_consumed_as_non_wheat_whole_grains')
        self.pig_meat_kg_per_capita = kwargs.get('pig_meat_kg_per_capita')
        self.pigs_per_capita = kwargs.get('pigs_per_capita')
        self.coal_reserves_binary = kwargs.get('coal_reserves_binary')
        self.coal_reserves_teragrams_per_capita = kwargs.get('coal_reserves_teragrams_per_capita')
        self.indoor_air_pollution_biomass_cooking = kwargs.get('indoor_air_pollution_biomass_cooking')
        self.indoor_air_pollution_coal_cooking = kwargs.get('indoor_air_pollution_coal_cooking')
        self.indoor_air_pollution_all_cooking_fuels = kwargs.get('indoor_air_pollution_all_cooking_fuels')
        self.outdoor_air_pollution_pm_2_5 = kwargs.get('outdoor_air_pollution_pm_2_5')
        self.latitude_under_15_proportion = kwargs.get('latitude_under_15_proportion')
        self.elevation_100_to_500m_proportion = kwargs.get('elevation_100_to_500m_proportion')
        self.elevation_over_1500m_proportion = kwargs.get('elevation_over_1500m_proportion')
        self.population_15_to_30_proportion = kwargs.get('population_15_to_30_proportion')
        self.latitude_15_to_30_proportion = kwargs.get('latitude_15_to_30_proportion')
        self.latitude_30_to_45_proportion = kwargs.get('latitude_30_to_45_proportion')
        self.latitude_over_45_proportion = kwargs.get('latitude_over_45_proportion')
        self.elevation_500_to_1500m_proportion = kwargs.get('elevation_500_to_1500m_proportion')
        self.population_density_150_300_ppl_sqkm_proportion = kwargs.get('population_density_150_300_ppl_sqkm_proportion')
        self.population_density_300_500_ppl_sqkm_proportion = kwargs.get('population_density_300_500_ppl_sqkm_proportion')
        self.population_density_500_1000_ppl_sqkm_proportion = kwargs.get('population_density_500_1000_ppl_sqkm_proportion')
        self.population_density_over_1000_ppl_sqkm_proportion = kwargs.get('population_density_over_1000_ppl_sqkm_proportion')
        self.population_density_under_150_ppl_sqkm_proportion = kwargs.get('population_density_under_150_ppl_sqkm_proportion')
        self.population_over_65_proportion = kwargs.get('population_over_65_proportion')
        self.elevation_under_100m_proportion = kwargs.get('elevation_under_100m_proportion')
        self.population_under_30_proportion = kwargs.get('population_under_30_proportion')
        self.pufa_kcal_per_capita = kwargs.get('pufa_kcal_per_capita')
        self.pufa_omega_3_seafood_kcal_per_capita = kwargs.get('pufa_omega_3_seafood_kcal_per_capita')
        self.pufa_omega_6_vegetable_oils_kcal_per_capita = kwargs.get('pufa_omega_6_vegetable_oils_kcal_per_capita')
        self.pulses_and_legumes_kcal_per_capita = kwargs.get('pulses_and_legumes_kcal_per_capita')
        self.rainfall_population_weighted_mm_yr = kwargs.get('rainfall_population_weighted_mm_yr')
        self.rainfall_quintiles_2_5 = kwargs.get('rainfall_quintiles_2_5')
        self.rainfall_quintiles_3_5 = kwargs.get('rainfall_quintiles_3_5')
        self.rainfall_quintiles_4_5 = kwargs.get('rainfall_quintiles_4_5')
        self.rainfall_quintile_1_proportion = kwargs.get('rainfall_quintile_1_proportion')
        self.rainfall_quintile_2_proportion = kwargs.get('rainfall_quintile_2_proportion')
        self.rainfall_quintile_3_proportion = kwargs.get('rainfall_quintile_3_proportion')
        self.rainfall_quintile_4_proportion = kwargs.get('rainfall_quintile_4_proportion')
        self.rainfall_quintile_5_proportion = kwargs.get('rainfall_quintile_5_proportion')
        self.red_meat_kcal_per_capita = kwargs.get('red_meat_kcal_per_capita')
        self.religion_binary_greater_than_50_percent_muslim = kwargs.get('religion_binary_greater_than_50_percent_muslim')
        self._percent_packaged_foods_sold_via_retail = kwargs.get('_percent_packaged_foods_sold_via_retail')
        self._percent_fats_oils_sold_via_retail = kwargs.get('_percent_fats_oils_sold_via_retail')
        self.rotavirus_vaccine_introduced_binary = kwargs.get('rotavirus_vaccine_introduced_binary')
        self.sahel_region_of_africa_binary = kwargs.get('sahel_region_of_africa_binary')
        self.sanitation_proportion_with_access = kwargs.get('sanitation_proportion_with_access')
        self.skilled_birth_attendance_proportion = kwargs.get('skilled_birth_attendance_proportion')
        self.sheep_per_capita = kwargs.get('sheep_per_capita')
        self.smoking_prevalence = kwargs.get('smoking_prevalence')
        self.smoking_prevalence_reproductive_age_standardized = kwargs.get('smoking_prevalence_reproductive_age_standardized')
        self.ninetieth_percentile_climatic_temperature_in_the_given_country_year = kwargs.get('ninetieth_percentile_climatic_temperature_in_the_given_country_year')
        self.tetanus_toxoid_coverage_smooth_proportion = kwargs.get('tetanus_toxoid_coverage_smooth_proportion')
        self.total_fertility_rate = kwargs.get('total_fertility_rate')
        self.total_calories_kcal_per_capita = kwargs.get('total_calories_kcal_per_capita')
        self.total_packaged_foods_sold_via_retail_tonnes_per_capita = kwargs.get('total_packaged_foods_sold_via_retail_tonnes_per_capita')
        self.total_fats_oils_sold_via_retail_tonnes_per_capita = kwargs.get('total_fats_oils_sold_via_retail_tonnes_per_capita')
        self.vegetables_kcal_per_capita = kwargs.get('vegetables_kcal_per_capita')
        self.vehicles_2_and_up4_wheels_per_capita = kwargs.get('vehicles_2_and_up4_wheels_per_capita')
        self.vehicles_2_wheels_per_capita = kwargs.get('vehicles_2_wheels_per_capita')
        self.vehicles_4_wheels_per_capita = kwargs.get('vehicles_4_wheels_per_capita')
        self.vehicles_2_wheels_fraction_proportion = kwargs.get('vehicles_2_wheels_fraction_proportion')
        self.vitamin_a_deficiency_prevalence_children_under_5 = kwargs.get('vitamin_a_deficiency_prevalence_children_under_5')
        self.mortality_rate_due_to_war_shocks_per_1_person = kwargs.get('mortality_rate_due_to_war_shocks_per_1_person')
        self.improved_water_source_proportion_with_access = kwargs.get('improved_water_source_proportion_with_access')
        self.whole_grains_kcal_per_capita = kwargs.get('whole_grains_kcal_per_capita')
        self.non_wheat_whole_grains_kcal_per_capita = kwargs.get('non_wheat_whole_grains_kcal_per_capita')
        self.itn_adjusted_pfpr_rate = kwargs.get('itn_adjusted_pfpr_rate')
        self.itn_mortality_reduction_proportion = kwargs.get('itn_mortality_reduction_proportion')
        self.malaria_any_binary = kwargs.get('malaria_any_binary')
        self.malaria_chloroquine_resistance = kwargs.get('malaria_chloroquine_resistance')
        self.malaria_chloroquine_resistance_2 = kwargs.get('malaria_chloroquine_resistance_2')
        self.malaria_endemicity_0_5_percent = kwargs.get('malaria_endemicity_0_5_percent')
        self.malaria_endemicity_5_40_percent = kwargs.get('malaria_endemicity_5_40_percent')
        self.malaria_endemicity_none = kwargs.get('malaria_endemicity_none')
        self.malaria_falciparum_binary = kwargs.get('malaria_falciparum_binary')
        self.malaria_lysenko_pfpr_2_hyperendemic = kwargs.get('malaria_lysenko_pfpr_2_hyperendemic')
        self.malaria_lysenko_pfpr_3_medoendemic = kwargs.get('malaria_lysenko_pfpr_3_medoendemic')
        self.malaria_lysenko_pfpr_4_hypoendemic = kwargs.get('malaria_lysenko_pfpr_4_hypoendemic')
        self.malaria_lysenko_pfpr_5_epidemic = kwargs.get('malaria_lysenko_pfpr_5_epidemic')
        self.map_malaria_mortality_reduction_proportion = kwargs.get('map_malaria_mortality_reduction_proportion')
        self.malaria_s_p_resistance = kwargs.get('malaria_s_p_resistance')
        self.malaria_s_p_resistance_2 = kwargs.get('malaria_s_p_resistance_2')
        self.itn_coverage_proportion = kwargs.get('itn_coverage_proportion')
        self.malaria_endemicity_40_100_percent = kwargs.get('malaria_endemicity_40_100_percent')
        self.malaria_endemicity_5_100_percent = kwargs.get('malaria_endemicity_5_100_percent')
        self.malaria_indoor_residual_spraying_coverage = kwargs.get('malaria_indoor_residual_spraying_coverage')
        self.malaria_lysenko_pfpr_1_holoendemic = kwargs.get('malaria_lysenko_pfpr_1_holoendemic')
        self.malaria_lysenko_pfpr_2_highest_endemicity = kwargs.get('malaria_lysenko_pfpr_2_highest_endemicity')
        self.malaria_lysenko_pfpr_3_highest_endemicity = kwargs.get('malaria_lysenko_pfpr_3_highest_endemicity')
        self.malaria_lysenko_pfpr_4_highest_endemicity = kwargs.get('malaria_lysenko_pfpr_4_highest_endemicity')
        self.malaria_population_at_risk_proportion = kwargs.get('malaria_population_at_risk_proportion')
        self.malaria_pfpr_rate = kwargs.get('malaria_pfpr_rate')
        self.malaria_prevalence_weighted_resistance = kwargs.get('malaria_prevalence_weighted_resistance')
        self.malaria_vivax_binary = kwargs.get('malaria_vivax_binary')
        self.malaria_pfpr_with_itn_rate = kwargs.get('malaria_pfpr_with_itn_rate')
        self.significant_leishmaniasis_endemicity_binary = kwargs.get('significant_leishmaniasis_endemicity_binary')
        self.leprosy_endemic_binary = kwargs.get('leprosy_endemic_binary')
        self.yellow_fever_endemicity_binary = kwargs.get('yellow_fever_endemicity_binary')
        self.year = kwargs.get('year')
        self.chagas_population_at_risk_2_proportion = kwargs.get('chagas_population_at_risk_2_proportion')
        self.birth_prevalence_of_chd = kwargs.get('birth_prevalence_of_chd')
        self.birth_prevalence_of_congenital_chromosomal_anomalies = kwargs.get('birth_prevalence_of_congenital_chromosomal_anomalies')
        self.dengue_incidence_per_1000_v7 = kwargs.get('dengue_incidence_per_1000_v7')
        self.hemoglobinopathies_prevalence_x_excess_mortality = kwargs.get('hemoglobinopathies_prevalence_x_excess_mortality')
        self.hepatitis_a_prevalence_proportion = kwargs.get('hepatitis_a_prevalence_proportion')
        self.hepatitis_b_prevalence_proportion = kwargs.get('hepatitis_b_prevalence_proportion')
        self.hepatitis_c_prevalence_proportion = kwargs.get('hepatitis_c_prevalence_proportion')
        self.hepatitis_e_prevalence_proportion = kwargs.get('hepatitis_e_prevalence_proportion')
        self.age_standardize_prevalence_of_severe_anemia = kwargs.get('age_standardize_prevalence_of_severe_anemia')
        self.schistosomiasis_prevalence_proportion = kwargs.get('schistosomiasis_prevalence_proportion')
        self.population_at_risk_of_trachoma_proportion = kwargs.get('population_at_risk_of_trachoma_proportion')
        self.maternal_care_and_immunization = kwargs.get('maternal_care_and_immunization')
        self.neonatal_mortality_rate_modeled_2_per_1000 = kwargs.get('neonatal_mortality_rate_modeled_2_per_1000')
        self.pcv3_coverage_proportion = kwargs.get('pcv3_coverage_proportion')
        self.presence_of_leishmaniasis_binary = kwargs.get('presence_of_leishmaniasis_binary')
        self.potential_for_leishmaniasis_transmission_binary = kwargs.get('potential_for_leishmaniasis_transmission_binary')
        self.high_leishmaniasis_endemicity_binary = kwargs.get('high_leishmaniasis_endemicity_binary')
        self.under_5_hiv_death_rate = kwargs.get('under_5_hiv_death_rate')
        self.interaction_of_malaria_itn_and_pfpr_rate_covariates = kwargs.get('interaction_of_malaria_itn_and_pfpr_rate_covariates')
        self.interaction_of_malaria_itn_and_log_pfpr_covariates = kwargs.get('interaction_of_malaria_itn_and_log_pfpr_covariates')
        self.malaria_pfpr_adjusted_for_itn_and_irs_coverage = kwargs.get('malaria_pfpr_adjusted_for_itn_and_irs_coverage')
        self.syphilis_prevalence_proportion = kwargs.get('syphilis_prevalence_proportion')
        self.year_x_gbd_analytical_region_5 = kwargs.get('year_x_gbd_analytical_region_5')
        self.year_x_gbd_analytical_region_9 = kwargs.get('year_x_gbd_analytical_region_9')
        self.year_x_gbd_analytical_region_21 = kwargs.get('year_x_gbd_analytical_region_21')
        self.year_x_gbd_analytical_region_32 = kwargs.get('year_x_gbd_analytical_region_32')
        self.year_x_gbd_analytical_region_42 = kwargs.get('year_x_gbd_analytical_region_42')
        self.year_x_gbd_analytical_region_56 = kwargs.get('year_x_gbd_analytical_region_56')
        self.year_x_gbd_analytical_region_65 = kwargs.get('year_x_gbd_analytical_region_65')
        self.year_x_gbd_analytical_region_70 = kwargs.get('year_x_gbd_analytical_region_70')
        self.year_x_gbd_analytical_region_73 = kwargs.get('year_x_gbd_analytical_region_73')
        self.year_x_gbd_analytical_region_96 = kwargs.get('year_x_gbd_analytical_region_96')
        self.year_x_gbd_analytical_region_100 = kwargs.get('year_x_gbd_analytical_region_100')
        self.year_x_gbd_analytical_region_104 = kwargs.get('year_x_gbd_analytical_region_104')
        self.year_x_gbd_analytical_region_120 = kwargs.get('year_x_gbd_analytical_region_120')
        self.year_x_gbd_analytical_region_124 = kwargs.get('year_x_gbd_analytical_region_124')
        self.year_x_gbd_analytical_region_134 = kwargs.get('year_x_gbd_analytical_region_134')
        self.year_x_gbd_analytical_region_138 = kwargs.get('year_x_gbd_analytical_region_138')
        self.year_x_gbd_analytical_region_159 = kwargs.get('year_x_gbd_analytical_region_159')
        self.year_x_gbd_analytical_region_167 = kwargs.get('year_x_gbd_analytical_region_167')
        self.year_x_gbd_analytical_region_174 = kwargs.get('year_x_gbd_analytical_region_174')
        self.year_x_gbd_analytical_region_192 = kwargs.get('year_x_gbd_analytical_region_192')
        self.year_x_gbd_analytical_region_199 = kwargs.get('year_x_gbd_analytical_region_199')
        self.year_x_gbd_analytical_superregion_4 = kwargs.get('year_x_gbd_analytical_superregion_4')
        self.year_x_gbd_analytical_superregion_31 = kwargs.get('year_x_gbd_analytical_superregion_31')
        self.year_x_gbd_analytical_superregion_64 = kwargs.get('year_x_gbd_analytical_superregion_64')
        self.year_x_gbd_analytical_superregion_103 = kwargs.get('year_x_gbd_analytical_superregion_103')
        self.year_x_gbd_analytical_superregion_137 = kwargs.get('year_x_gbd_analytical_superregion_137')
        self.year_x_gbd_analytical_superregion_158 = kwargs.get('year_x_gbd_analytical_superregion_158')
        self.year_x_gbd_analytical_superregion_166 = kwargs.get('year_x_gbd_analytical_superregion_166')
        self.population_weighted_probability_of_dengue_transmission = kwargs.get('population_weighted_probability_of_dengue_transmission')
        self.dengue_outbreaks_binary = kwargs.get('dengue_outbreaks_binary')
        self.exponentiated_version_of_dengue_anomalies = kwargs.get('exponentiated_version_of_dengue_anomalies')
        self.proportion_of_the_population_living_in_the_classic_monsoon_region = kwargs.get('proportion_of_the_population_living_in_the_classic_monsoon_region')
        self.proportion_of_the_population_living_in_the_classic_monsoon_region_low_income_countries = kwargs.get('proportion_of_the_population_living_in_the_classic_monsoon_region_low_income_countries')
        self.dengue_anomalies_deviation_from_mean_dengue_incidence_rate = kwargs.get('dengue_anomalies_deviation_from_mean_dengue_incidence_rate')
        self.population_at_risk_for_lf_infection = kwargs.get('population_at_risk_for_lf_infection')
        self.pc_treatments_per_person_at_risk_for_lf_infection = kwargs.get('pc_treatments_per_person_at_risk_for_lf_infection')
        self.total_pc_treatments_per_person_at_risk_for_lf_infection_1999_2012 = kwargs.get('total_pc_treatments_per_person_at_risk_for_lf_infection_1999_2012')
        self.smoking_prevalence_age_standardized_females = kwargs.get('smoking_prevalence_age_standardized_females')
        self.smoking_prevalence_age_standardized_males = kwargs.get('smoking_prevalence_age_standardized_males')
        self.hiv_prevalence_during_pregnancy_by_age = kwargs.get('hiv_prevalence_during_pregnancy_by_age')
        self.cumulative_to_date_pc_treatment_per_person_at_risk_1999_2012 = kwargs.get('cumulative_to_date_pc_treatment_per_person_at_risk_1999_2012')
        self.indicator_for_high_income_superregion_location_id_64 = kwargs.get('indicator_for_high_income_superregion_location_id_64')
        self.vitamin_a_supplementation_coverage_rate = kwargs.get('vitamin_a_supplementation_coverage_rate')
        self.hemoglobinopathies_prevalence_x_excess_mortality_excluding_g6pd_deficiency = kwargs.get('hemoglobinopathies_prevalence_x_excess_mortality_excluding_g6pd_deficiency')
        self.hepatitis_c_prevalence_proportion_capped = kwargs.get('hepatitis_c_prevalence_proportion_capped')
        self.hepatitis_b_prevalence_based_on_gbd_2013_dismod_models = kwargs.get('hepatitis_b_prevalence_based_on_gbd_2013_dismod_models')
        self.hepatitis_c_prevalence_based_on_gbd_2013_dismod_models = kwargs.get('hepatitis_c_prevalence_based_on_gbd_2013_dismod_models')
        self.indicator_for_southeast_asia_east_asia_and_oceania_superregion_location_id_4 = kwargs.get('indicator_for_southeast_asia_east_asia_and_oceania_superregion_location_id_4')
        self.indicator_for_central_europe_eastern_europe_and_central_asia_superregion_location_id_31 = kwargs.get('indicator_for_central_europe_eastern_europe_and_central_asia_superregion_location_id_31')
        self.indicator_for_latin_america_and_caribbean_superregion_location_id_103 = kwargs.get('indicator_for_latin_america_and_caribbean_superregion_location_id_103')
        self.indicator_for_north_africa_and_middle_east_superregion_location_id_137 = kwargs.get('indicator_for_north_africa_and_middle_east_superregion_location_id_137')
        self.indicator_for_south_asia_superregion_location_id_158 = kwargs.get('indicator_for_south_asia_superregion_location_id_158')
        self.indicator_for_sub_saharan_africa_superregion_location_id_166 = kwargs.get('indicator_for_sub_saharan_africa_superregion_location_id_166')
        self.patterns_of_drinking_score_who = kwargs.get('patterns_of_drinking_score_who')
        self.alcohol_binge_drinker_proportion_age_standardized = kwargs.get('alcohol_binge_drinker_proportion_age_standardized')
        self.patterns_of_drinking_score_who__indicator_for_score_1 = kwargs.get('patterns_of_drinking_score_who__indicator_for_score_1')
        self.patterns_of_drinking_score_who__indicator_for_score_2 = kwargs.get('patterns_of_drinking_score_who__indicator_for_score_2')
        self.patterns_of_drinking_score_who__indicator_for_score_3 = kwargs.get('patterns_of_drinking_score_who__indicator_for_score_3')
        self.patterns_of_drinking_score_who__indicator_for_score_4 = kwargs.get('patterns_of_drinking_score_who__indicator_for_score_4')
        self.patterns_of_drinking_score_who__indicator_for_score_5 = kwargs.get('patterns_of_drinking_score_who__indicator_for_score_5')
        self._improved_water_source_proportion_with_access_based_on_gbd_2010_definition = kwargs.get('_improved_water_source_proportion_with_access_based_on_gbd_2010_definition')
        self.pre_control_prevalence_of_infection_with_lymphatic_filariasis_within_endemic_areas = kwargs.get('pre_control_prevalence_of_infection_with_lymphatic_filariasis_within_endemic_areas')
        self.seroprevalence_of_varicella = kwargs.get('seroprevalence_of_varicella')
        self.smoking_prevalence_age_standardized_both_sexes = kwargs.get('smoking_prevalence_age_standardized_both_sexes')
        self.mortality_rate_due_to_war_and_disaster_greater_than_1_10000_binary = kwargs.get('mortality_rate_due_to_war_and_disaster_greater_than_1_10000_binary')
        self.mortality_rate_due_to_war_and_disaster_greater_than_1_10000_in_last_ten_years_binary = kwargs.get('mortality_rate_due_to_war_and_disaster_greater_than_1_10000_in_last_ten_years_binary')
        self.animal_fats_kcal_per_capita_interaction_term_for_eap_super_region = kwargs.get('animal_fats_kcal_per_capita_interaction_term_for_eap_super_region')
        self.ln_total_calories_consumed_as_hydrogenated_oil_interaction_term_for_eap_super_region = kwargs.get('ln_total_calories_consumed_as_hydrogenated_oil_interaction_term_for_eap_super_region')
        self.percent_of_total_calories_consumed_as_fruits_interaction_term_for_eap_super_region = kwargs.get('percent_of_total_calories_consumed_as_fruits_interaction_term_for_eap_super_region')
        self.percent_of_total_calories_consumed_as_legumes_interaction_term_for_eap_super_region = kwargs.get('percent_of_total_calories_consumed_as_legumes_interaction_term_for_eap_super_region')
        self.percent_of_total_calories_consumed_as_nuts_and_seeds_interaction_term_for_eap_super_region = kwargs.get('percent_of_total_calories_consumed_as_nuts_and_seeds_interaction_term_for_eap_super_region')
        self.percent_of_total_calories_consumed_as_pufa3_interaction_term_for_eap_super_region = kwargs.get('percent_of_total_calories_consumed_as_pufa3_interaction_term_for_eap_super_region')
        self.percent_of_total_calories_consumed_as_saturated_fat_interaction_term_for_eap_super_region = kwargs.get('percent_of_total_calories_consumed_as_saturated_fat_interaction_term_for_eap_super_region')
        self.percent_of_total_calories_consumed_as_sugar_interaction_term_for_eap_super_region = kwargs.get('percent_of_total_calories_consumed_as_sugar_interaction_term_for_eap_super_region')
        self.percent_of_total_calories_consumed_as_non_wheat_whole_grains_interaction_term_for_eap_super_region = kwargs.get('percent_of_total_calories_consumed_as_non_wheat_whole_grains_interaction_term_for_eap_super_region')
        self.pig_meat_kg_per_capita_interaction_term_for_eap_super_region = kwargs.get('pig_meat_kg_per_capita_interaction_term_for_eap_super_region')
        self.pufa_kcal_per_capita_interaction_term_for_eap_super_region = kwargs.get('pufa_kcal_per_capita_interaction_term_for_eap_super_region')
        self.red_meat_kcal_per_capita_interaction_term_for_eap_super_region = kwargs.get('red_meat_kcal_per_capita_interaction_term_for_eap_super_region')
        self.animal_fats_kcal_per_capita_interaction_term_for_eeca_super_region = kwargs.get('animal_fats_kcal_per_capita_interaction_term_for_eeca_super_region')
        self.ln_total_calories_consumed_as_hydrogenated_oil_interaction_term_for_eeca_super_region = kwargs.get('ln_total_calories_consumed_as_hydrogenated_oil_interaction_term_for_eeca_super_region')
        self.percent_of_total_calories_consumed_as_fruits_interaction_term_for_eeca_super_region = kwargs.get('percent_of_total_calories_consumed_as_fruits_interaction_term_for_eeca_super_region')
        self.percent_of_total_calories_consumed_as_legumes_interaction_term_for_eeca_super_region = kwargs.get('percent_of_total_calories_consumed_as_legumes_interaction_term_for_eeca_super_region')
        self.percent_of_total_calories_consumed_as_nuts_and_seeds_interaction_term_for_eeca_super_region = kwargs.get('percent_of_total_calories_consumed_as_nuts_and_seeds_interaction_term_for_eeca_super_region')
        self.percent_of_total_calories_consumed_as_pufa3_interaction_term_for_eeca_super_region = kwargs.get('percent_of_total_calories_consumed_as_pufa3_interaction_term_for_eeca_super_region')
        self.percent_of_total_calories_consumed_as_saturated_fat_interaction_term_for_eeca_super_region = kwargs.get('percent_of_total_calories_consumed_as_saturated_fat_interaction_term_for_eeca_super_region')
        self.percent_of_total_calories_consumed_as_sugar_interaction_term_for_eeca_super_region = kwargs.get('percent_of_total_calories_consumed_as_sugar_interaction_term_for_eeca_super_region')
        self.percent_of_total_calories_consumed_as_non_wheat_whole_grains_interaction_term_for_eeca_super_region = kwargs.get('percent_of_total_calories_consumed_as_non_wheat_whole_grains_interaction_term_for_eeca_super_region')
        self.pig_meat_kg_per_capita_interaction_term_for_eeca_super_region = kwargs.get('pig_meat_kg_per_capita_interaction_term_for_eeca_super_region')
        self.pufa_kcal_per_capita_interaction_term_for_eeca_super_region = kwargs.get('pufa_kcal_per_capita_interaction_term_for_eeca_super_region')
        self.red_meat_kcal_per_capita_interaction_term_for_eeca_super_region = kwargs.get('red_meat_kcal_per_capita_interaction_term_for_eeca_super_region')
        self.animal_fats_kcal_per_capita_interaction_term_for_hi_super_region = kwargs.get('animal_fats_kcal_per_capita_interaction_term_for_hi_super_region')
        self.ln_total_calories_consumed_as_hydrogenated_oil_interaction_term_for_hi_super_region = kwargs.get('ln_total_calories_consumed_as_hydrogenated_oil_interaction_term_for_hi_super_region')
        self.percent_of_total_calories_consumed_as_fruits_interaction_term_for_hi_super_region = kwargs.get('percent_of_total_calories_consumed_as_fruits_interaction_term_for_hi_super_region')
        self.percent_of_total_calories_consumed_as_legumes_interaction_term_for_hi_super_region = kwargs.get('percent_of_total_calories_consumed_as_legumes_interaction_term_for_hi_super_region')
        self.percent_of_total_calories_consumed_as_nuts_and_seeds_interaction_term_for_hi_super_region = kwargs.get('percent_of_total_calories_consumed_as_nuts_and_seeds_interaction_term_for_hi_super_region')
        self.percent_of_total_calories_consumed_as_pufa3_interaction_term_for_hi_super_region = kwargs.get('percent_of_total_calories_consumed_as_pufa3_interaction_term_for_hi_super_region')
        self.percent_of_total_calories_consumed_as_saturated_fat_interaction_term_for_hi_super_region = kwargs.get('percent_of_total_calories_consumed_as_saturated_fat_interaction_term_for_hi_super_region')
        self.percent_of_total_calories_consumed_as_sugar_interaction_term_for_hi_super_region = kwargs.get('percent_of_total_calories_consumed_as_sugar_interaction_term_for_hi_super_region')
        self.percent_of_total_calories_consumed_as_non_wheat_whole_grains_interaction_term_for_hi_super_region = kwargs.get('percent_of_total_calories_consumed_as_non_wheat_whole_grains_interaction_term_for_hi_super_region')
        self.pig_meat_kg_per_capita_interaction_term_for_hi_super_region = kwargs.get('pig_meat_kg_per_capita_interaction_term_for_hi_super_region')
        self.pufa_kcal_per_capita_interaction_term_for_hi_super_region = kwargs.get('pufa_kcal_per_capita_interaction_term_for_hi_super_region')
        self.red_meat_kcal_per_capita_interaction_term_for_hi_super_region = kwargs.get('red_meat_kcal_per_capita_interaction_term_for_hi_super_region')
        self.animal_fats_kcal_per_capita_interaction_term_for_lac_super_region = kwargs.get('animal_fats_kcal_per_capita_interaction_term_for_lac_super_region')
        self.ln_total_calories_consumed_as_hydrogenated_oil_interaction_term_for_lac_super_region = kwargs.get('ln_total_calories_consumed_as_hydrogenated_oil_interaction_term_for_lac_super_region')
        self.percent_of_total_calories_consumed_as_fruits_interaction_term_for_lac_super_region = kwargs.get('percent_of_total_calories_consumed_as_fruits_interaction_term_for_lac_super_region')
        self.percent_of_total_calories_consumed_as_legumes_interaction_term_for_lac_super_region = kwargs.get('percent_of_total_calories_consumed_as_legumes_interaction_term_for_lac_super_region')
        self.percent_of_total_calories_consumed_as_nuts_and_seeds_interaction_term_for_lac_super_region = kwargs.get('percent_of_total_calories_consumed_as_nuts_and_seeds_interaction_term_for_lac_super_region')
        self.percent_of_total_calories_consumed_as_pufa3_interaction_term_for_lac_super_region = kwargs.get('percent_of_total_calories_consumed_as_pufa3_interaction_term_for_lac_super_region')
        self.percent_of_total_calories_consumed_as_saturated_fat_interaction_term_for_lac_super_region = kwargs.get('percent_of_total_calories_consumed_as_saturated_fat_interaction_term_for_lac_super_region')
        self.percent_of_total_calories_consumed_as_sugar_interaction_term_for_lac_super_region = kwargs.get('percent_of_total_calories_consumed_as_sugar_interaction_term_for_lac_super_region')
        self.percent_of_total_calories_consumed_as_non_wheat_whole_grains_interaction_term_for_lac_super_region = kwargs.get('percent_of_total_calories_consumed_as_non_wheat_whole_grains_interaction_term_for_lac_super_region')
        self.pig_meat_kg_per_capita_interaction_term_for_lac_super_region = kwargs.get('pig_meat_kg_per_capita_interaction_term_for_lac_super_region')
        self.pufa_kcal_per_capita_interaction_term_for_lac_super_region = kwargs.get('pufa_kcal_per_capita_interaction_term_for_lac_super_region')
        self.red_meat_kcal_per_capita_interaction_term_for_lac_super_region = kwargs.get('red_meat_kcal_per_capita_interaction_term_for_lac_super_region')
        self.animal_fats_kcal_per_capita_interaction_term_for_name_super_region = kwargs.get('animal_fats_kcal_per_capita_interaction_term_for_name_super_region')
        self.ln_total_calories_consumed_as_hydrogenated_oil_interaction_term_for_name_super_region = kwargs.get('ln_total_calories_consumed_as_hydrogenated_oil_interaction_term_for_name_super_region')
        self.percent_of_total_calories_consumed_as_fruits_interaction_term_for_name_super_region = kwargs.get('percent_of_total_calories_consumed_as_fruits_interaction_term_for_name_super_region')
        self.percent_of_total_calories_consumed_as_legumes_interaction_term_for_name_super_region = kwargs.get('percent_of_total_calories_consumed_as_legumes_interaction_term_for_name_super_region')
        self.percent_of_total_calories_consumed_as_nuts_and_seeds_interaction_term_for_name_super_region = kwargs.get('percent_of_total_calories_consumed_as_nuts_and_seeds_interaction_term_for_name_super_region')
        self.percent_of_total_calories_consumed_as_pufa3_interaction_term_for_name_super_region = kwargs.get('percent_of_total_calories_consumed_as_pufa3_interaction_term_for_name_super_region')
        self.percent_of_total_calories_consumed_as_saturated_fat_interaction_term_for_name_super_region = kwargs.get('percent_of_total_calories_consumed_as_saturated_fat_interaction_term_for_name_super_region')
        self.percent_of_total_calories_consumed_as_sugar_interaction_term_for_name_super_region = kwargs.get('percent_of_total_calories_consumed_as_sugar_interaction_term_for_name_super_region')
        self.percent_of_total_calories_consumed_as_non_wheat_whole_grains_interaction_term_for_name_super_region = kwargs.get('percent_of_total_calories_consumed_as_non_wheat_whole_grains_interaction_term_for_name_super_region')
        self.pig_meat_kg_per_capita_interaction_term_for_name_super_region = kwargs.get('pig_meat_kg_per_capita_interaction_term_for_name_super_region')
        self.pufa_kcal_per_capita_interaction_term_for_name_super_region = kwargs.get('pufa_kcal_per_capita_interaction_term_for_name_super_region')
        self.red_meat_kcal_per_capita_interaction_term_for_name_super_region = kwargs.get('red_meat_kcal_per_capita_interaction_term_for_name_super_region')
        self.animal_fats_kcal_per_capita_interaction_term_for_sa_super_region = kwargs.get('animal_fats_kcal_per_capita_interaction_term_for_sa_super_region')
        self.ln_total_calories_consumed_as_hydrogenated_oil_interaction_term_for_sa_super_region = kwargs.get('ln_total_calories_consumed_as_hydrogenated_oil_interaction_term_for_sa_super_region')
        self.percent_of_total_calories_consumed_as_fruits_interaction_term_for_sa_super_region = kwargs.get('percent_of_total_calories_consumed_as_fruits_interaction_term_for_sa_super_region')
        self.percent_of_total_calories_consumed_as_legumes_interaction_term_for_sa_super_region = kwargs.get('percent_of_total_calories_consumed_as_legumes_interaction_term_for_sa_super_region')
        self.percent_of_total_calories_consumed_as_nuts_and_seeds_interaction_term_for_sa_super_region = kwargs.get('percent_of_total_calories_consumed_as_nuts_and_seeds_interaction_term_for_sa_super_region')
        self.percent_of_total_calories_consumed_as_pufa3_interaction_term_for_sa_super_region = kwargs.get('percent_of_total_calories_consumed_as_pufa3_interaction_term_for_sa_super_region')
        self.percent_of_total_calories_consumed_as_saturated_fat_interaction_term_for_sa_super_region = kwargs.get('percent_of_total_calories_consumed_as_saturated_fat_interaction_term_for_sa_super_region')
        self.percent_of_total_calories_consumed_as_sugar_interaction_term_for_sa_super_region = kwargs.get('percent_of_total_calories_consumed_as_sugar_interaction_term_for_sa_super_region')
        self.percent_of_total_calories_consumed_as_non_wheat_whole_grains_interaction_term_for_sa_super_region = kwargs.get('percent_of_total_calories_consumed_as_non_wheat_whole_grains_interaction_term_for_sa_super_region')
        self.pig_meat_kg_per_capita_interaction_term_for_sa_super_region = kwargs.get('pig_meat_kg_per_capita_interaction_term_for_sa_super_region')
        self.pufa_kcal_per_capita_interaction_term_for_sa_super_region = kwargs.get('pufa_kcal_per_capita_interaction_term_for_sa_super_region')
        self.red_meat_kcal_per_capita_interaction_term_for_sa_super_region = kwargs.get('red_meat_kcal_per_capita_interaction_term_for_sa_super_region')
        self.animal_fats_kcal_per_capita_interaction_term_for_ssa_super_region = kwargs.get('animal_fats_kcal_per_capita_interaction_term_for_ssa_super_region')
        self.ln_total_calories_consumed_as_hydrogenated_oil_interaction_term_for_ssa_super_region = kwargs.get('ln_total_calories_consumed_as_hydrogenated_oil_interaction_term_for_ssa_super_region')
        self.percent_of_total_calories_consumed_as_fruits_interaction_term_for_ssa_super_region = kwargs.get('percent_of_total_calories_consumed_as_fruits_interaction_term_for_ssa_super_region')
        self.percent_of_total_calories_consumed_as_legumes_interaction_term_for_ssa_super_region = kwargs.get('percent_of_total_calories_consumed_as_legumes_interaction_term_for_ssa_super_region')
        self.percent_of_total_calories_consumed_as_nuts_and_seeds_interaction_term_for_ssa_super_region = kwargs.get('percent_of_total_calories_consumed_as_nuts_and_seeds_interaction_term_for_ssa_super_region')
        self.percent_of_total_calories_consumed_as_pufa3_interaction_term_for_ssa_super_region = kwargs.get('percent_of_total_calories_consumed_as_pufa3_interaction_term_for_ssa_super_region')
        self.percent_of_total_calories_consumed_as_saturated_fat_interaction_term_for_ssa_super_region = kwargs.get('percent_of_total_calories_consumed_as_saturated_fat_interaction_term_for_ssa_super_region')
        self.percent_of_total_calories_consumed_as_sugar_interaction_term_for_ssa_super_region = kwargs.get('percent_of_total_calories_consumed_as_sugar_interaction_term_for_ssa_super_region')
        self.percent_of_total_calories_consumed_as_non_wheat_whole_grains_interaction_term_for_ssa_super_region = kwargs.get('percent_of_total_calories_consumed_as_non_wheat_whole_grains_interaction_term_for_ssa_super_region')
        self.pig_meat_kg_per_capita_interaction_term_for_ssa_super_region = kwargs.get('pig_meat_kg_per_capita_interaction_term_for_ssa_super_region')
        self.pufa_kcal_per_capita_interaction_term_for_ssa_super_region = kwargs.get('pufa_kcal_per_capita_interaction_term_for_ssa_super_region')
        self.red_meat_kcal_per_capita_interaction_term_for_ssa_super_region = kwargs.get('red_meat_kcal_per_capita_interaction_term_for_ssa_super_region')
        self.age_standardized_death_rate_for_endocrince_metabolic_blood_and_immune_disorders = kwargs.get('age_standardized_death_rate_for_endocrince_metabolic_blood_and_immune_disorders')
        self.log_age_standardized_melanoma_incidence = kwargs.get('log_age_standardized_melanoma_incidence')
        self.chagas_specific_mortality_rate_among_the_at_risk_population_ten_year_lag = kwargs.get('chagas_specific_mortality_rate_among_the_at_risk_population_ten_year_lag')
        self.asbestos_production_per_capita_offset_by_non_zero_minimum = kwargs.get('asbestos_production_per_capita_offset_by_non_zero_minimum')
        self.coal_production_per_capita_offset_by_non_zero_minimum = kwargs.get('coal_production_per_capita_offset_by_non_zero_minimum')
        self.gold_production_per_capita_offset_by_non_zero_minimum = kwargs.get('gold_production_per_capita_offset_by_non_zero_minimum')
        self.proportion_of_the_population_living_in_the_indian_ocean_monsoon_belt = kwargs.get('proportion_of_the_population_living_in_the_indian_ocean_monsoon_belt')
        self.vitamin_a_deficiency_prevalence_age_standardized = kwargs.get('vitamin_a_deficiency_prevalence_age_standardized')
        self.population_at_risk_of_trachoma_modeled_proportion = kwargs.get('population_at_risk_of_trachoma_modeled_proportion')
        self.saturated_fats_and_animal_fats_kcal_per_capita = kwargs.get('saturated_fats_and_animal_fats_kcal_per_capita')
        self.percent_of_total_calories_consumed_as_saturated_and_animal_fats = kwargs.get('percent_of_total_calories_consumed_as_saturated_and_animal_fats')
        self.percent_of_total_calories_consumed_as_saturated_and_animal_fats_interaction_term_for_eap_super_region = kwargs.get('percent_of_total_calories_consumed_as_saturated_and_animal_fats_interaction_term_for_eap_super_region')
        self.percent_of_total_calories_consumed_as_saturated_and_animal_fats_interaction_term_for_eeca_super_region = kwargs.get('percent_of_total_calories_consumed_as_saturated_and_animal_fats_interaction_term_for_eeca_super_region')
        self.percent_of_total_calories_consumed_as_saturated_and_animal_fats_interaction_term_for_hi_super_region = kwargs.get('percent_of_total_calories_consumed_as_saturated_and_animal_fats_interaction_term_for_hi_super_region')
        self.percent_of_total_calories_consumed_as_saturated_and_animal_fats_interaction_term_for_lac_super_region = kwargs.get('percent_of_total_calories_consumed_as_saturated_and_animal_fats_interaction_term_for_lac_super_region')
        self.percent_of_total_calories_consumed_as_saturated_and_animal_fats_interaction_term_for_name_super_region = kwargs.get('percent_of_total_calories_consumed_as_saturated_and_animal_fats_interaction_term_for_name_super_region')
        self.percent_of_total_calories_consumed_as_saturated_and_animal_fats_interaction_term_for_sa_super_region = kwargs.get('percent_of_total_calories_consumed_as_saturated_and_animal_fats_interaction_term_for_sa_super_region')
        self.percent_of_total_calories_consumed_as_saturated_and_animal_fats_interaction_term_for_ssa_super_region = kwargs.get('percent_of_total_calories_consumed_as_saturated_and_animal_fats_interaction_term_for_ssa_super_region')
        self.prevalence_of_obesity = kwargs.get('prevalence_of_obesity')
        self.prevalence_of_overweight_and_obesity = kwargs.get('prevalence_of_overweight_and_obesity')
        self.prevalence_of_obesity_age_standardized = kwargs.get('prevalence_of_obesity_age_standardized')
        self.age_standardized_prevalence_of_ckd_stage_3 = kwargs.get('age_standardized_prevalence_of_ckd_stage_3')
        self.age_standardized_prevalence_of_ckd_stage_4_dismod_model_33304 = kwargs.get('age_standardized_prevalence_of_ckd_stage_4_dismod_model_33304')
        self.age_standardized_prevalence_of_ckd_stage_4_dismod_model_33309 = kwargs.get('age_standardized_prevalence_of_ckd_stage_4_dismod_model_33309')
        self.age_standardized_prevalence_of_ckd_stage_4_dismod_model_33314 = kwargs.get('age_standardized_prevalence_of_ckd_stage_4_dismod_model_33314')
        self.age_standardized_prevalence_of_ckd_stage_4 = kwargs.get('age_standardized_prevalence_of_ckd_stage_4')
        self.red_meat_w_o_pig_meat_kcal_per_capita = kwargs.get('red_meat_w_o_pig_meat_kcal_per_capita')
        self.percent_of_total_calories_consumed_as_red_meat_w_o_pig_meat = kwargs.get('percent_of_total_calories_consumed_as_red_meat_w_o_pig_meat')
        self.maternal_education_years_per_capita = kwargs.get('maternal_education_years_per_capita')
        self.scaled_adult_hiv_rate = kwargs.get('scaled_adult_hiv_rate')
        self.chagasprevpaho = kwargs.get('chagasprevpaho')
        self.proportion_of_the_land_with_altitude_between_1000_2500_meters_above_sea_level = kwargs.get('proportion_of_the_land_with_altitude_between_1000_2500_meters_above_sea_level')
        self.clay_fraction_in_the_soil_mean = kwargs.get('clay_fraction_in_the_soil_mean')
        self.silt_fraction_in_the_soil_mean = kwargs.get('silt_fraction_in_the_soil_mean')
        self.enhanced_vegetation_index_long_term_average_2000_2012_mean = kwargs.get('enhanced_vegetation_index_long_term_average_2000_2012_mean')
        self.slope_of_the_land_in_degrees_terrain_steepness_mean = kwargs.get('slope_of_the_land_in_degrees_terrain_steepness_mean')
        self.log_transformed_sev_scalar_tb = kwargs.get('log_transformed_sev_scalar_tb')
        self.deprecated_log_transformed_sev_scalar_hiv_myco = kwargs.get('deprecated_log_transformed_sev_scalar_hiv_myco')
        self.log_transformed_sev_scalar_oth_hiv = kwargs.get('log_transformed_sev_scalar_oth_hiv')
        self.log_transformed_sev_scalar_diarrhea = kwargs.get('log_transformed_sev_scalar_diarrhea')
        self.deprecated_log_transformed_sev_scalar_intest_inf = kwargs.get('deprecated_log_transformed_sev_scalar_intest_inf')
        self.deprecated_log_transformed_sev_scalar_typhoid = kwargs.get('deprecated_log_transformed_sev_scalar_typhoid')
        self.deprecated_log_transformed_sev_scalar_paratyph = kwargs.get('deprecated_log_transformed_sev_scalar_paratyph')
        self.deprecated_log_transformed_sev_scalar_oth_intest = kwargs.get('deprecated_log_transformed_sev_scalar_oth_intest')
        self.log_transformed_sev_scalar_lri = kwargs.get('log_transformed_sev_scalar_lri')
        self.log_transformed_sev_scalar_uri = kwargs.get('log_transformed_sev_scalar_uri')
        self.log_transformed_sev_scalar_otitis = kwargs.get('log_transformed_sev_scalar_otitis')
        self.log_transformed_sev_scalar_meningitis = kwargs.get('log_transformed_sev_scalar_meningitis')
        self.deprecated_log_transformed_sev_scalar_mng_pne = kwargs.get('deprecated_log_transformed_sev_scalar_mng_pne')
        self.deprecated_log_transformed_sev_scalar_mng_hib = kwargs.get('deprecated_log_transformed_sev_scalar_mng_hib')
        self.deprecated_log_transformed_sev_scalar_mng_men = kwargs.get('deprecated_log_transformed_sev_scalar_mng_men')
        self.deprecated_log_transformed_sev_scalar_oth_mng = kwargs.get('deprecated_log_transformed_sev_scalar_oth_mng')
        self.deprecated_log_transformed_sev_scalar_encepha = kwargs.get('deprecated_log_transformed_sev_scalar_encepha')
        self.deprecated_log_transformed_sev_scalar_diphtheria = kwargs.get('deprecated_log_transformed_sev_scalar_diphtheria')
        self.deprecated_log_transformed_sev_scalar_whooping = kwargs.get('deprecated_log_transformed_sev_scalar_whooping')
        self.deprecated_log_transformed_sev_scalar_tetanus = kwargs.get('deprecated_log_transformed_sev_scalar_tetanus')
        self.log_transformed_sev_scalar_measles = kwargs.get('log_transformed_sev_scalar_measles')
        self.deprecated_log_transformed_sev_scalar_varicella = kwargs.get('deprecated_log_transformed_sev_scalar_varicella')
        self.deprecated_log_transformed_sev_scalar_malaria = kwargs.get('deprecated_log_transformed_sev_scalar_malaria')
        self.deprecated_log_transformed_sev_scalar_chagas = kwargs.get('deprecated_log_transformed_sev_scalar_chagas')
        self.deprecated_log_transformed_sev_scalar_leish = kwargs.get('deprecated_log_transformed_sev_scalar_leish')
        self.deprecated_log_transformed_sev_scalar_vis_leish = kwargs.get('deprecated_log_transformed_sev_scalar_vis_leish')
        self.deprecated_log_transformed_sev_scalar_cut_leish = kwargs.get('deprecated_log_transformed_sev_scalar_cut_leish')
        self.deprecated_log_transformed_sev_scalar_afr_tryp = kwargs.get('deprecated_log_transformed_sev_scalar_afr_tryp')
        self.deprecated_log_transformed_sev_scalar_schisto = kwargs.get('deprecated_log_transformed_sev_scalar_schisto')
        self.deprecated_log_transformed_sev_scalar_cysticer = kwargs.get('deprecated_log_transformed_sev_scalar_cysticer')
        self.deprecated_log_transformed_sev_scalar_echino = kwargs.get('deprecated_log_transformed_sev_scalar_echino')
        self.deprecated_log_transformed_sev_scalar_lf = kwargs.get('deprecated_log_transformed_sev_scalar_lf')
        self.deprecated_log_transformed_sev_scalar_oncho = kwargs.get('deprecated_log_transformed_sev_scalar_oncho')
        self.deprecated_log_transformed_sev_scalar_trachoma = kwargs.get('deprecated_log_transformed_sev_scalar_trachoma')
        self.deprecated_log_transformed_sev_scalar_dengue = kwargs.get('deprecated_log_transformed_sev_scalar_dengue')
        self.deprecated_log_transformed_sev_scalar_yellow_fev = kwargs.get('deprecated_log_transformed_sev_scalar_yellow_fev')
        self.deprecated_log_transformed_sev_scalar_rabies = kwargs.get('deprecated_log_transformed_sev_scalar_rabies')
        self.deprecated_log_transformed_sev_scalar_nematode = kwargs.get('deprecated_log_transformed_sev_scalar_nematode')
        self.deprecated_log_transformed_sev_scalar_ascaria = kwargs.get('deprecated_log_transformed_sev_scalar_ascaria')
        self.deprecated_log_transformed_sev_scalar_trichuria = kwargs.get('deprecated_log_transformed_sev_scalar_trichuria')
        self.deprecated_log_transformed_sev_scalar_hookworm = kwargs.get('deprecated_log_transformed_sev_scalar_hookworm')
        self.deprecated_log_transformed_sev_scalar_fb_trema = kwargs.get('deprecated_log_transformed_sev_scalar_fb_trema')
        self.deprecated_log_transformed_sev_scalar_oth_ntd = kwargs.get('deprecated_log_transformed_sev_scalar_oth_ntd')
        self.log_transformed_sev_scalar_mat_hem = kwargs.get('log_transformed_sev_scalar_mat_hem')
        self.log_transformed_sev_scalar_mat_sepsis = kwargs.get('log_transformed_sev_scalar_mat_sepsis')
        self.log_transformed_sev_scalar_mat_htn = kwargs.get('log_transformed_sev_scalar_mat_htn')
        self.deprecated_log_transformed_sev_scalar_mat_obst = kwargs.get('deprecated_log_transformed_sev_scalar_mat_obst')
        self.log_transformed_sev_scalar_comp_abort = kwargs.get('log_transformed_sev_scalar_comp_abort')
        self.log_transformed_sev_scalar_mat_indir = kwargs.get('log_transformed_sev_scalar_mat_indir')
        self.log_transformed_sev_scalar_mat_late = kwargs.get('log_transformed_sev_scalar_mat_late')
        self.log_transformed_sev_scalar_oth_mat = kwargs.get('log_transformed_sev_scalar_oth_mat')
        self.deprecated_log_transformed_sev_scalar_nn_preterm = kwargs.get('deprecated_log_transformed_sev_scalar_nn_preterm')
        self.deprecated_log_transformed_sev_scalar_nn_enceph = kwargs.get('deprecated_log_transformed_sev_scalar_nn_enceph')
        self.deprecated_log_transformed_sev_scalar_nn_sepsis = kwargs.get('deprecated_log_transformed_sev_scalar_nn_sepsis')
        self.deprecated_log_transformed_sev_scalar_nn_hemol = kwargs.get('deprecated_log_transformed_sev_scalar_nn_hemol')
        self.deprecated_log_transformed_sev_scalar_oth_nn = kwargs.get('deprecated_log_transformed_sev_scalar_oth_nn')
        self.deprecated_log_transformed_sev_scalar_iodine = kwargs.get('deprecated_log_transformed_sev_scalar_iodine')
        self.deprecated_log_transformed_sev_scalar_oth_nutr = kwargs.get('deprecated_log_transformed_sev_scalar_oth_nutr')
        self.log_transformed_sev_scalar_hep = kwargs.get('log_transformed_sev_scalar_hep')
        self.deprecated_log_transformed_sev_scalar_hep_a = kwargs.get('deprecated_log_transformed_sev_scalar_hep_a')
        self.log_transformed_sev_scalar_hep_b = kwargs.get('log_transformed_sev_scalar_hep_b')
        self.log_transformed_sev_scalar_hep_c = kwargs.get('log_transformed_sev_scalar_hep_c')
        self.deprecated_log_transformed_sev_scalar_hep_e = kwargs.get('deprecated_log_transformed_sev_scalar_hep_e')
        self.deprecated_log_transformed_sev_scalar_leprosy = kwargs.get('deprecated_log_transformed_sev_scalar_leprosy')
        self.deprecated_log_transformed_sev_scalar_oth_inf = kwargs.get('deprecated_log_transformed_sev_scalar_oth_inf')
        self.log_transformed_sev_scalar_esophag_c = kwargs.get('log_transformed_sev_scalar_esophag_c')
        self.log_transformed_sev_scalar_stomach_c = kwargs.get('log_transformed_sev_scalar_stomach_c')
        self.log_transformed_sev_scalar_liver_c = kwargs.get('log_transformed_sev_scalar_liver_c')
        self.log_transformed_sev_scalar_liver_c_hepb = kwargs.get('log_transformed_sev_scalar_liver_c_hepb')
        self.log_transformed_sev_scalar_liver_c_hepc = kwargs.get('log_transformed_sev_scalar_liver_c_hepc')
        self.log_transformed_sev_scalar_oth_liver_c = kwargs.get('log_transformed_sev_scalar_oth_liver_c')
        self.log_transformed_sev_scalar_larynx_c = kwargs.get('log_transformed_sev_scalar_larynx_c')
        self.log_transformed_sev_scalar_lung_c = kwargs.get('log_transformed_sev_scalar_lung_c')
        self.log_transformed_sev_scalar_breast_c = kwargs.get('log_transformed_sev_scalar_breast_c')
        self.log_transformed_sev_scalar_uterus_c = kwargs.get('log_transformed_sev_scalar_uterus_c')
        self.log_transformed_sev_scalar_prostate_c = kwargs.get('log_transformed_sev_scalar_prostate_c')
        self.log_transformed_sev_scalar_colorect_c = kwargs.get('log_transformed_sev_scalar_colorect_c')
        self.log_transformed_sev_scalar_lip_oral_c = kwargs.get('log_transformed_sev_scalar_lip_oral_c')
        self.log_transformed_sev_scalar_nasoph_c = kwargs.get('log_transformed_sev_scalar_nasoph_c')
        self.log_transformed_sev_scalar_oth_phar_c = kwargs.get('log_transformed_sev_scalar_oth_phar_c')
        self.log_transformed_sev_scalar_gallblad_c = kwargs.get('log_transformed_sev_scalar_gallblad_c')
        self.log_transformed_sev_scalar_pancreas_c = kwargs.get('log_transformed_sev_scalar_pancreas_c')
        self.deprecated_log_transformed_sev_scalar_melanoma = kwargs.get('deprecated_log_transformed_sev_scalar_melanoma')
        self.deprecated_log_transformed_sev_scalar_skin_c = kwargs.get('deprecated_log_transformed_sev_scalar_skin_c')
        self.log_transformed_sev_scalar_ovary_c = kwargs.get('log_transformed_sev_scalar_ovary_c')
        self.deprecated_log_transformed_sev_scalar_testis_c = kwargs.get('deprecated_log_transformed_sev_scalar_testis_c')
        self.log_transformed_sev_scalar_kidney_c = kwargs.get('log_transformed_sev_scalar_kidney_c')
        self.log_transformed_sev_scalar_bladder_c = kwargs.get('log_transformed_sev_scalar_bladder_c')
        self.deprecated_log_transformed_sev_scalar_brain_c = kwargs.get('deprecated_log_transformed_sev_scalar_brain_c')
        self.log_transformed_sev_scalar_thyroid_c = kwargs.get('log_transformed_sev_scalar_thyroid_c')
        self.log_transformed_sev_scalar_mesothel = kwargs.get('log_transformed_sev_scalar_mesothel')
        self.deprecated_log_transformed_sev_scalar_hodgkin = kwargs.get('deprecated_log_transformed_sev_scalar_hodgkin')
        self.deprecated_log_transformed_sev_scalar_lymphoma = kwargs.get('deprecated_log_transformed_sev_scalar_lymphoma')
        self.deprecated_log_transformed_sev_scalar_myeloma = kwargs.get('deprecated_log_transformed_sev_scalar_myeloma')
        self.log_transformed_sev_scalar_leukemia = kwargs.get('log_transformed_sev_scalar_leukemia')
        self.deprecated_log_transformed_sev_scalar_oth_neopla = kwargs.get('deprecated_log_transformed_sev_scalar_oth_neopla')
        self.log_transformed_sev_scalar_rhd = kwargs.get('log_transformed_sev_scalar_rhd')
        self.log_transformed_sev_scalar_ihd = kwargs.get('log_transformed_sev_scalar_ihd')
        self.log_transformed_sev_scalar_stroke = kwargs.get('log_transformed_sev_scalar_stroke')
        self.log_transformed_sev_scalar_isch_stroke = kwargs.get('log_transformed_sev_scalar_isch_stroke')
        self.log_transformed_sev_scalar_intrahem_stroke = kwargs.get('log_transformed_sev_scalar_intrahem_stroke')
        self.log_transformed_sev_scalar_cmp = kwargs.get('log_transformed_sev_scalar_cmp')
        self.log_transformed_sev_scalar_a_fib = kwargs.get('log_transformed_sev_scalar_a_fib')
        self.log_transformed_sev_scalar_aort_an = kwargs.get('log_transformed_sev_scalar_aort_an')
        self.log_transformed_sev_scalar_pad = kwargs.get('log_transformed_sev_scalar_pad')
        self.log_transformed_sev_scalar_endocar = kwargs.get('log_transformed_sev_scalar_endocar')
        self.log_transformed_sev_scalar_oth_cardio = kwargs.get('log_transformed_sev_scalar_oth_cardio')
        self.log_transformed_sev_scalar_copd = kwargs.get('log_transformed_sev_scalar_copd')
        self.deprecated_log_transformed_sev_scalar_pneumocon = kwargs.get('deprecated_log_transformed_sev_scalar_pneumocon')
        self.deprecated_log_transformed_sev_scalar_silicosis = kwargs.get('deprecated_log_transformed_sev_scalar_silicosis')
        self.deprecated_log_transformed_sev_scalar_asbestosis = kwargs.get('deprecated_log_transformed_sev_scalar_asbestosis')
        self.deprecated_log_transformed_sev_scalar_coal_w = kwargs.get('deprecated_log_transformed_sev_scalar_coal_w')
        self.deprecated_log_transformed_sev_scalar_oth_pneum = kwargs.get('deprecated_log_transformed_sev_scalar_oth_pneum')
        self.log_transformed_sev_scalar_asthma = kwargs.get('log_transformed_sev_scalar_asthma')
        self.log_transformed_sev_scalar_ild = kwargs.get('log_transformed_sev_scalar_ild')
        self.log_transformed_sev_scalar_oth_resp = kwargs.get('log_transformed_sev_scalar_oth_resp')
        self.log_transformed_sev_scalar_cirr_hepb = kwargs.get('log_transformed_sev_scalar_cirr_hepb')
        self.log_transformed_sev_scalar_cirr_hepc = kwargs.get('log_transformed_sev_scalar_cirr_hepc')
        self.deprecated_log_transformed_sev_scalar_oth_cirr = kwargs.get('deprecated_log_transformed_sev_scalar_oth_cirr')
        self.deprecated_log_transformed_sev_scalar_pud = kwargs.get('deprecated_log_transformed_sev_scalar_pud')
        self.deprecated_log_transformed_sev_scalar_gastritis = kwargs.get('deprecated_log_transformed_sev_scalar_gastritis')
        self.deprecated_log_transformed_sev_scalar_appendicit = kwargs.get('deprecated_log_transformed_sev_scalar_appendicit')
        self.deprecated_log_transformed_sev_scalar_ileus = kwargs.get('deprecated_log_transformed_sev_scalar_ileus')
        self.deprecated_log_transformed_sev_scalar_hernia = kwargs.get('deprecated_log_transformed_sev_scalar_hernia')
        self.deprecated_log_transformed_sev_scalar_ibd = kwargs.get('deprecated_log_transformed_sev_scalar_ibd')
        self.deprecated_log_transformed_sev_scalar_vasc_intest = kwargs.get('deprecated_log_transformed_sev_scalar_vasc_intest')
        self.deprecated_log_transformed_sev_scalar_gall_bile = kwargs.get('deprecated_log_transformed_sev_scalar_gall_bile')
        self.log_transformed_sev_scalar_pancreatit = kwargs.get('log_transformed_sev_scalar_pancreatit')
        self.deprecated_log_transformed_sev_scalar_oth_digest = kwargs.get('deprecated_log_transformed_sev_scalar_oth_digest')
        self.deprecated_log_transformed_sev_scalar_alzheimer = kwargs.get('deprecated_log_transformed_sev_scalar_alzheimer')
        self.deprecated_log_transformed_sev_scalar_parkinson = kwargs.get('deprecated_log_transformed_sev_scalar_parkinson')
        self.log_transformed_sev_scalar_idiopathic_epilepsy = kwargs.get('log_transformed_sev_scalar_idiopathic_epilepsy')
        self.deprecated_log_transformed_sev_scalar_ms = kwargs.get('deprecated_log_transformed_sev_scalar_ms')
        self.deprecated_log_transformed_sev_scalar_migraine = kwargs.get('deprecated_log_transformed_sev_scalar_migraine')
        self.deprecated_log_transformed_sev_scalar_tens_head = kwargs.get('deprecated_log_transformed_sev_scalar_tens_head')
        self.deprecated_log_transformed_sev_scalar_med_head = kwargs.get('deprecated_log_transformed_sev_scalar_med_head')
        self.deprecated_log_transformed_sev_scalar_oth_neuro = kwargs.get('deprecated_log_transformed_sev_scalar_oth_neuro')
        self.deprecated_log_transformed_sev_scalar_schizo = kwargs.get('deprecated_log_transformed_sev_scalar_schizo')
        self.log_transformed_sev_scalar_depression = kwargs.get('log_transformed_sev_scalar_depression')
        self.log_transformed_sev_scalar_mdd = kwargs.get('log_transformed_sev_scalar_mdd')
        self.deprecated_log_transformed_sev_scalar_dysthymia = kwargs.get('deprecated_log_transformed_sev_scalar_dysthymia')
        self.deprecated_log_transformed_sev_scalar_bipolar = kwargs.get('deprecated_log_transformed_sev_scalar_bipolar')
        self.log_transformed_sev_scalar_anxiety = kwargs.get('log_transformed_sev_scalar_anxiety')
        self.deprecated_log_transformed_sev_scalar_eating = kwargs.get('deprecated_log_transformed_sev_scalar_eating')
        self.deprecated_log_transformed_sev_scalar_anorexia = kwargs.get('deprecated_log_transformed_sev_scalar_anorexia')
        self.deprecated_log_transformed_sev_scalar_bulimia = kwargs.get('deprecated_log_transformed_sev_scalar_bulimia')
        self.deprecated_log_transformed_sev_scalar_asd = kwargs.get('deprecated_log_transformed_sev_scalar_asd')
        self.deprecated_log_transformed_sev_scalar_autism = kwargs.get('deprecated_log_transformed_sev_scalar_autism')
        self.deprecated_log_transformed_sev_scalar_asperger = kwargs.get('deprecated_log_transformed_sev_scalar_asperger')
        self.deprecated_log_transformed_sev_scalar_adhd = kwargs.get('deprecated_log_transformed_sev_scalar_adhd')
        self.deprecated_log_transformed_sev_scalar_conduct = kwargs.get('deprecated_log_transformed_sev_scalar_conduct')
        self.log_transformed_sev_scalar_id = kwargs.get('log_transformed_sev_scalar_id')
        self.deprecated_log_transformed_sev_scalar_oth_ment = kwargs.get('deprecated_log_transformed_sev_scalar_oth_ment')
        self.deprecated_log_transformed_sev_scalar_agn = kwargs.get('deprecated_log_transformed_sev_scalar_agn')
        self.deprecated_log_transformed_sev_scalar_urinary = kwargs.get('deprecated_log_transformed_sev_scalar_urinary')
        self.deprecated_log_transformed_sev_scalar_int_neph = kwargs.get('deprecated_log_transformed_sev_scalar_int_neph')
        self.deprecated_log_transformed_sev_scalar_urolith = kwargs.get('deprecated_log_transformed_sev_scalar_urolith')
        self.deprecated_log_transformed_sev_scalar_bph = kwargs.get('deprecated_log_transformed_sev_scalar_bph')
        self.deprecated_log_transformed_sev_scalar_infert_m = kwargs.get('deprecated_log_transformed_sev_scalar_infert_m')
        self.deprecated_log_transformed_sev_scalar_oth_urin = kwargs.get('deprecated_log_transformed_sev_scalar_oth_urin')
        self.deprecated_log_transformed_sev_scalar_gyne = kwargs.get('deprecated_log_transformed_sev_scalar_gyne')
        self.deprecated_log_transformed_sev_scalar_fibroids = kwargs.get('deprecated_log_transformed_sev_scalar_fibroids')
        self.deprecated_log_transformed_sev_scalar_pcos = kwargs.get('deprecated_log_transformed_sev_scalar_pcos')
        self.deprecated_log_transformed_sev_scalar_infert_f = kwargs.get('deprecated_log_transformed_sev_scalar_infert_f')
        self.deprecated_log_transformed_sev_scalar_endomet = kwargs.get('deprecated_log_transformed_sev_scalar_endomet')
        self.deprecated_log_transformed_sev_scalar_prolapse = kwargs.get('deprecated_log_transformed_sev_scalar_prolapse')
        self.deprecated_log_transformed_sev_scalar_pms = kwargs.get('deprecated_log_transformed_sev_scalar_pms')
        self.deprecated_log_transformed_sev_scalar_oth_gyne = kwargs.get('deprecated_log_transformed_sev_scalar_oth_gyne')
        self.deprecated_log_transformed_sev_scalar_hemog = kwargs.get('deprecated_log_transformed_sev_scalar_hemog')
        self.deprecated_log_transformed_sev_scalar_thalass = kwargs.get('deprecated_log_transformed_sev_scalar_thalass')
        self.deprecated_log_transformed_sev_scalar_sickle = kwargs.get('deprecated_log_transformed_sev_scalar_sickle')
        self.deprecated_log_transformed_sev_scalar_g6pd = kwargs.get('deprecated_log_transformed_sev_scalar_g6pd')
        self.deprecated_log_transformed_sev_scalar_oth_hem = kwargs.get('deprecated_log_transformed_sev_scalar_oth_hem')
        self.deprecated_log_transformed_sev_scalar_endocrine = kwargs.get('deprecated_log_transformed_sev_scalar_endocrine')
        self.deprecated_log_transformed_sev_scalar_rheu_arth = kwargs.get('deprecated_log_transformed_sev_scalar_rheu_arth')
        self.log_transformed_sev_scalar_osteoarth = kwargs.get('log_transformed_sev_scalar_osteoarth')
        self.log_transformed_sev_scalar_back_and_upneck = kwargs.get('log_transformed_sev_scalar_back_and_upneck')
        self.log_transformed_sev_scalar_back_pain = kwargs.get('log_transformed_sev_scalar_back_pain')
        self.deprecated_log_transformed_sev_scalar_neck_pain = kwargs.get('deprecated_log_transformed_sev_scalar_neck_pain')
        self.log_transformed_sev_scalar_gout = kwargs.get('log_transformed_sev_scalar_gout')
        self.deprecated_log_transformed_sev_scalar_oth_msk = kwargs.get('deprecated_log_transformed_sev_scalar_oth_msk')
        self.deprecated_log_transformed_sev_scalar_congenital = kwargs.get('deprecated_log_transformed_sev_scalar_congenital')
        self.deprecated_log_transformed_sev_scalar_neur_tube = kwargs.get('deprecated_log_transformed_sev_scalar_neur_tube')
        self.deprecated_log_transformed_sev_scalar_cong_heart = kwargs.get('deprecated_log_transformed_sev_scalar_cong_heart')
        self.deprecated_log_transformed_sev_scalar_cleft = kwargs.get('deprecated_log_transformed_sev_scalar_cleft')
        self.deprecated_log_transformed_sev_scalar_down = kwargs.get('deprecated_log_transformed_sev_scalar_down')
        self.deprecated_log_transformed_sev_scalar_turner = kwargs.get('deprecated_log_transformed_sev_scalar_turner')
        self.deprecated_log_transformed_sev_scalar_klinefelter = kwargs.get('deprecated_log_transformed_sev_scalar_klinefelter')
        self.deprecated_log_transformed_sev_scalar_chrom_unb = kwargs.get('deprecated_log_transformed_sev_scalar_chrom_unb')
        self.deprecated_log_transformed_sev_scalar_oth_cong = kwargs.get('deprecated_log_transformed_sev_scalar_oth_cong')
        self.deprecated_log_transformed_sev_scalar_skin = kwargs.get('deprecated_log_transformed_sev_scalar_skin')
        self.deprecated_log_transformed_sev_scalar_dermatitis = kwargs.get('deprecated_log_transformed_sev_scalar_dermatitis')
        self.deprecated_log_transformed_sev_scalar_psoriasis = kwargs.get('deprecated_log_transformed_sev_scalar_psoriasis')
        self.deprecated_log_transformed_sev_scalar_cellulitis = kwargs.get('deprecated_log_transformed_sev_scalar_cellulitis')
        self.deprecated_log_transformed_sev_scalar_pyoderma = kwargs.get('deprecated_log_transformed_sev_scalar_pyoderma')
        self.deprecated_log_transformed_sev_scalar_scabies = kwargs.get('deprecated_log_transformed_sev_scalar_scabies')
        self.deprecated_log_transformed_sev_scalar_skin_fung = kwargs.get('deprecated_log_transformed_sev_scalar_skin_fung')
        self.deprecated_log_transformed_sev_scalar_skin_viral = kwargs.get('deprecated_log_transformed_sev_scalar_skin_viral')
        self.deprecated_log_transformed_sev_scalar_acne = kwargs.get('deprecated_log_transformed_sev_scalar_acne')
        self.deprecated_log_transformed_sev_scalar_alopecia = kwargs.get('deprecated_log_transformed_sev_scalar_alopecia')
        self.deprecated_log_transformed_sev_scalar_pruritus = kwargs.get('deprecated_log_transformed_sev_scalar_pruritus')
        self.deprecated_log_transformed_sev_scalar_urticaria = kwargs.get('deprecated_log_transformed_sev_scalar_urticaria')
        self.deprecated_log_transformed_sev_scalar_decubitus = kwargs.get('deprecated_log_transformed_sev_scalar_decubitus')
        self.deprecated_log_transformed_sev_scalar_oth_skin = kwargs.get('deprecated_log_transformed_sev_scalar_oth_skin')
        self.log_transformed_sev_scalar_sense = kwargs.get('log_transformed_sev_scalar_sense')
        self.deprecated_log_transformed_sev_scalar_glaucoma = kwargs.get('deprecated_log_transformed_sev_scalar_glaucoma')
        self.log_transformed_sev_scalar_cataract = kwargs.get('log_transformed_sev_scalar_cataract')
        self.deprecated_log_transformed_sev_scalar_macular = kwargs.get('deprecated_log_transformed_sev_scalar_macular')
        self.deprecated_log_transformed_sev_scalar_refraction = kwargs.get('deprecated_log_transformed_sev_scalar_refraction')
        self.log_transformed_sev_scalar_hearing = kwargs.get('log_transformed_sev_scalar_hearing')
        self.deprecated_log_transformed_sev_scalar_oth_vision = kwargs.get('deprecated_log_transformed_sev_scalar_oth_vision')
        self.deprecated_log_transformed_sev_scalar_oth_sense = kwargs.get('deprecated_log_transformed_sev_scalar_oth_sense')
        self.deprecated_log_transformed_sev_scalar_oral = kwargs.get('deprecated_log_transformed_sev_scalar_oral')
        self.deprecated_log_transformed_sev_scalar_dec_caries = kwargs.get('deprecated_log_transformed_sev_scalar_dec_caries')
        self.deprecated_log_transformed_sev_scalar_per_caries = kwargs.get('deprecated_log_transformed_sev_scalar_per_caries')
        self.deprecated_log_transformed_sev_scalar_period = kwargs.get('deprecated_log_transformed_sev_scalar_period')
        self.deprecated_log_transformed_sev_scalar_edentul = kwargs.get('deprecated_log_transformed_sev_scalar_edentul')
        self.deprecated_log_transformed_sev_scalar_oth_oral = kwargs.get('deprecated_log_transformed_sev_scalar_oth_oral')
        self.log_transformed_sev_scalar_sids = kwargs.get('log_transformed_sev_scalar_sids')
        self.log_transformed_sev_scalar_road_inj = kwargs.get('log_transformed_sev_scalar_road_inj')
        self.log_transformed_sev_scalar_pedest = kwargs.get('log_transformed_sev_scalar_pedest')
        self.log_transformed_sev_scalar_cyclist = kwargs.get('log_transformed_sev_scalar_cyclist')
        self.log_transformed_sev_scalar_mot_cyc = kwargs.get('log_transformed_sev_scalar_mot_cyc')
        self.log_transformed_sev_scalar_mot_veh = kwargs.get('log_transformed_sev_scalar_mot_veh')
        self.log_transformed_sev_scalar_oth_road = kwargs.get('log_transformed_sev_scalar_oth_road')
        self.log_transformed_sev_scalar_oth_trans = kwargs.get('log_transformed_sev_scalar_oth_trans')
        self.log_transformed_sev_scalar_falls = kwargs.get('log_transformed_sev_scalar_falls')
        self.log_transformed_sev_scalar_drown = kwargs.get('log_transformed_sev_scalar_drown')
        self.log_transformed_sev_scalar_fire = kwargs.get('log_transformed_sev_scalar_fire')
        self.log_transformed_sev_scalar_poison = kwargs.get('log_transformed_sev_scalar_poison')
        self.log_transformed_sev_scalar_mech = kwargs.get('log_transformed_sev_scalar_mech')
        self.log_transformed_sev_scalar_mech_gun = kwargs.get('log_transformed_sev_scalar_mech_gun')
        self.log_transformed_sev_scalar_mech_suff = kwargs.get('log_transformed_sev_scalar_mech_suff')
        self.log_transformed_sev_scalar_oth_mech = kwargs.get('log_transformed_sev_scalar_oth_mech')
        self.deprecated_log_transformed_sev_scalar_med_treat = kwargs.get('deprecated_log_transformed_sev_scalar_med_treat')
        self.log_transformed_sev_scalar_animal = kwargs.get('log_transformed_sev_scalar_animal')
        self.log_transformed_sev_scalar_venom = kwargs.get('log_transformed_sev_scalar_venom')
        self.log_transformed_sev_scalar_non_ven = kwargs.get('log_transformed_sev_scalar_non_ven')
        self.log_transformed_sev_scalar_f_body = kwargs.get('log_transformed_sev_scalar_f_body')
        self.log_transformed_sev_scalar_f_body_asp = kwargs.get('log_transformed_sev_scalar_f_body_asp')
        self.log_transformed_sev_scalar_f_body_eye = kwargs.get('log_transformed_sev_scalar_f_body_eye')
        self.log_transformed_sev_scalar_oth_f_body = kwargs.get('log_transformed_sev_scalar_oth_f_body')
        self.log_transformed_sev_scalar_oth_unint = kwargs.get('log_transformed_sev_scalar_oth_unint')
        self.log_transformed_sev_scalar_self_harm = kwargs.get('log_transformed_sev_scalar_self_harm')
        self.log_transformed_sev_scalar_violence = kwargs.get('log_transformed_sev_scalar_violence')
        self.log_transformed_sev_scalar_viol_gun = kwargs.get('log_transformed_sev_scalar_viol_gun')
        self.log_transformed_sev_scalar_viol_knife = kwargs.get('log_transformed_sev_scalar_viol_knife')
        self.log_transformed_sev_scalar_oth_viol = kwargs.get('log_transformed_sev_scalar_oth_viol')
        self.log_transformed_sev_scalar_disaster = kwargs.get('log_transformed_sev_scalar_disaster')
        self.deprecated_log_transformed_sev_scalar_war = kwargs.get('deprecated_log_transformed_sev_scalar_war')
        self.log_transformed_sev_scalar_mat_hiv = kwargs.get('log_transformed_sev_scalar_mat_hiv')
        self.deprecated_log_transformed_sev_scalar_thalass_trait = kwargs.get('deprecated_log_transformed_sev_scalar_thalass_trait')
        self.deprecated_log_transformed_sev_scalar_sickle_trait = kwargs.get('deprecated_log_transformed_sev_scalar_sickle_trait')
        self.deprecated_log_transformed_sev_scalar_g6pd_trait = kwargs.get('deprecated_log_transformed_sev_scalar_g6pd_trait')
        self.log_transformed_age_standardized_sev_scalar_tb = kwargs.get('log_transformed_age_standardized_sev_scalar_tb')
        self.deprecated_log_transformed_age_standardized_sev_scalar_hiv_myco = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_hiv_myco')
        self.log_transformed_age_standardized_sev_scalar_oth_hiv = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_hiv')
        self.log_transformed_age_standardized_sev_scalar_diarrhea = kwargs.get('log_transformed_age_standardized_sev_scalar_diarrhea')
        self.deprecated_log_transformed_age_standardized_sev_scalar_intest_inf = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_intest_inf')
        self.deprecated_log_transformed_age_standardized_sev_scalar_typhoid = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_typhoid')
        self.deprecated_log_transformed_age_standardized_sev_scalar_paratyph = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_paratyph')
        self.log_transformed_age_standardized_sev_scalar_lri = kwargs.get('log_transformed_age_standardized_sev_scalar_lri')
        self.log_transformed_age_standardized_sev_scalar_uri = kwargs.get('log_transformed_age_standardized_sev_scalar_uri')
        self.log_transformed_age_standardized_sev_scalar_otitis = kwargs.get('log_transformed_age_standardized_sev_scalar_otitis')
        self.log_transformed_age_standardized_sev_scalar_measles = kwargs.get('log_transformed_age_standardized_sev_scalar_measles')
        self.log_transformed_age_standardized_sev_scalar_mat_hem = kwargs.get('log_transformed_age_standardized_sev_scalar_mat_hem')
        self.log_transformed_age_standardized_sev_scalar_mat_sepsis = kwargs.get('log_transformed_age_standardized_sev_scalar_mat_sepsis')
        self.log_transformed_age_standardized_sev_scalar_comp_abort = kwargs.get('log_transformed_age_standardized_sev_scalar_comp_abort')
        self.log_transformed_age_standardized_sev_scalar_hep = kwargs.get('log_transformed_age_standardized_sev_scalar_hep')
        self.log_transformed_age_standardized_sev_scalar_hep_b = kwargs.get('log_transformed_age_standardized_sev_scalar_hep_b')
        self.log_transformed_age_standardized_sev_scalar_hep_c = kwargs.get('log_transformed_age_standardized_sev_scalar_hep_c')
        self.log_transformed_age_standardized_sev_scalar_esophag_c = kwargs.get('log_transformed_age_standardized_sev_scalar_esophag_c')
        self.log_transformed_age_standardized_sev_scalar_stomach_c = kwargs.get('log_transformed_age_standardized_sev_scalar_stomach_c')
        self.log_transformed_age_standardized_sev_scalar_liver_c = kwargs.get('log_transformed_age_standardized_sev_scalar_liver_c')
        self.log_transformed_age_standardized_sev_scalar_liver_c_hepb = kwargs.get('log_transformed_age_standardized_sev_scalar_liver_c_hepb')
        self.log_transformed_age_standardized_sev_scalar_liver_c_hepc = kwargs.get('log_transformed_age_standardized_sev_scalar_liver_c_hepc')
        self.log_transformed_age_standardized_sev_scalar_oth_liver_c = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_liver_c')
        self.log_transformed_age_standardized_sev_scalar_larynx_c = kwargs.get('log_transformed_age_standardized_sev_scalar_larynx_c')
        self.log_transformed_age_standardized_sev_scalar_lung_c = kwargs.get('log_transformed_age_standardized_sev_scalar_lung_c')
        self.log_transformed_age_standardized_sev_scalar_breast_c = kwargs.get('log_transformed_age_standardized_sev_scalar_breast_c')
        self.log_transformed_age_standardized_sev_scalar_uterus_c = kwargs.get('log_transformed_age_standardized_sev_scalar_uterus_c')
        self.log_transformed_age_standardized_sev_scalar_prostate_c = kwargs.get('log_transformed_age_standardized_sev_scalar_prostate_c')
        self.log_transformed_age_standardized_sev_scalar_colorect_c = kwargs.get('log_transformed_age_standardized_sev_scalar_colorect_c')
        self.log_transformed_age_standardized_sev_scalar_lip_oral_c = kwargs.get('log_transformed_age_standardized_sev_scalar_lip_oral_c')
        self.log_transformed_age_standardized_sev_scalar_nasoph_c = kwargs.get('log_transformed_age_standardized_sev_scalar_nasoph_c')
        self.log_transformed_age_standardized_sev_scalar_oth_phar_c = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_phar_c')
        self.log_transformed_age_standardized_sev_scalar_gallblad_c = kwargs.get('log_transformed_age_standardized_sev_scalar_gallblad_c')
        self.log_transformed_age_standardized_sev_scalar_pancreas_c = kwargs.get('log_transformed_age_standardized_sev_scalar_pancreas_c')
        self.log_transformed_age_standardized_sev_scalar_ovary_c = kwargs.get('log_transformed_age_standardized_sev_scalar_ovary_c')
        self.log_transformed_age_standardized_sev_scalar_kidney_c = kwargs.get('log_transformed_age_standardized_sev_scalar_kidney_c')
        self.log_transformed_age_standardized_sev_scalar_bladder_c = kwargs.get('log_transformed_age_standardized_sev_scalar_bladder_c')
        self.log_transformed_age_standardized_sev_scalar_thyroid_c = kwargs.get('log_transformed_age_standardized_sev_scalar_thyroid_c')
        self.log_transformed_age_standardized_sev_scalar_mesothel = kwargs.get('log_transformed_age_standardized_sev_scalar_mesothel')
        self.log_transformed_age_standardized_sev_scalar_leukemia = kwargs.get('log_transformed_age_standardized_sev_scalar_leukemia')
        self.log_transformed_age_standardized_sev_scalar_rhd = kwargs.get('log_transformed_age_standardized_sev_scalar_rhd')
        self.log_transformed_age_standardized_sev_scalar_ihd = kwargs.get('log_transformed_age_standardized_sev_scalar_ihd')
        self.log_transformed_age_standardized_sev_scalar_stroke = kwargs.get('log_transformed_age_standardized_sev_scalar_stroke')
        self.log_transformed_age_standardized_sev_scalar_isch_stroke = kwargs.get('log_transformed_age_standardized_sev_scalar_isch_stroke')
        self.log_transformed_age_standardized_sev_scalar_intrahem_stroke = kwargs.get('log_transformed_age_standardized_sev_scalar_intrahem_stroke')
        self.log_transformed_age_standardized_sev_scalar_cmp = kwargs.get('log_transformed_age_standardized_sev_scalar_cmp')
        self.log_transformed_age_standardized_sev_scalar_a_fib = kwargs.get('log_transformed_age_standardized_sev_scalar_a_fib')
        self.log_transformed_age_standardized_sev_scalar_aort_an = kwargs.get('log_transformed_age_standardized_sev_scalar_aort_an')
        self.log_transformed_age_standardized_sev_scalar_pad = kwargs.get('log_transformed_age_standardized_sev_scalar_pad')
        self.log_transformed_age_standardized_sev_scalar_endocar = kwargs.get('log_transformed_age_standardized_sev_scalar_endocar')
        self.log_transformed_age_standardized_sev_scalar_oth_cardio = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_cardio')
        self.log_transformed_age_standardized_sev_scalar_copd = kwargs.get('log_transformed_age_standardized_sev_scalar_copd')
        self.deprecated_log_transformed_age_standardized_sev_scalar_pneumocon = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_pneumocon')
        self.deprecated_log_transformed_age_standardized_sev_scalar_silicosis = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_silicosis')
        self.deprecated_log_transformed_age_standardized_sev_scalar_asbestosis = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_asbestosis')
        self.deprecated_log_transformed_age_standardized_sev_scalar_coal_w = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_coal_w')
        self.deprecated_log_transformed_age_standardized_sev_scalar_oth_pneum = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_oth_pneum')
        self.log_transformed_age_standardized_sev_scalar_asthma = kwargs.get('log_transformed_age_standardized_sev_scalar_asthma')
        self.log_transformed_age_standardized_sev_scalar_ild = kwargs.get('log_transformed_age_standardized_sev_scalar_ild')
        self.log_transformed_age_standardized_sev_scalar_oth_resp = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_resp')
        self.log_transformed_age_standardized_sev_scalar_cirr_hepb = kwargs.get('log_transformed_age_standardized_sev_scalar_cirr_hepb')
        self.log_transformed_age_standardized_sev_scalar_cirr_hepc = kwargs.get('log_transformed_age_standardized_sev_scalar_cirr_hepc')
        self.deprecated_log_transformed_age_standardized_sev_scalar_oth_cirr = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_oth_cirr')
        self.log_transformed_age_standardized_sev_scalar_pancreatit = kwargs.get('log_transformed_age_standardized_sev_scalar_pancreatit')
        self.log_transformed_age_standardized_sev_scalar_idiopathic_epilepsy = kwargs.get('log_transformed_age_standardized_sev_scalar_idiopathic_epilepsy')
        self.log_transformed_age_standardized_sev_scalar_depression = kwargs.get('log_transformed_age_standardized_sev_scalar_depression')
        self.log_transformed_age_standardized_sev_scalar_mdd = kwargs.get('log_transformed_age_standardized_sev_scalar_mdd')
        self.deprecated_log_transformed_age_standardized_sev_scalar_dysthymia = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_dysthymia')
        self.log_transformed_age_standardized_sev_scalar_id = kwargs.get('log_transformed_age_standardized_sev_scalar_id')
        self.log_transformed_age_standardized_sev_scalar_osteoarth = kwargs.get('log_transformed_age_standardized_sev_scalar_osteoarth')
        self.log_transformed_age_standardized_sev_scalar_back_and_upneck = kwargs.get('log_transformed_age_standardized_sev_scalar_back_and_upneck')
        self.log_transformed_age_standardized_sev_scalar_back_pain = kwargs.get('log_transformed_age_standardized_sev_scalar_back_pain')
        self.log_transformed_age_standardized_sev_scalar_gout = kwargs.get('log_transformed_age_standardized_sev_scalar_gout')
        self.log_transformed_age_standardized_sev_scalar_sense = kwargs.get('log_transformed_age_standardized_sev_scalar_sense')
        self.log_transformed_age_standardized_sev_scalar_cataract = kwargs.get('log_transformed_age_standardized_sev_scalar_cataract')
        self.log_transformed_age_standardized_sev_scalar_hearing = kwargs.get('log_transformed_age_standardized_sev_scalar_hearing')
        self.log_transformed_age_standardized_sev_scalar_road_inj = kwargs.get('log_transformed_age_standardized_sev_scalar_road_inj')
        self.log_transformed_age_standardized_sev_scalar_pedest = kwargs.get('log_transformed_age_standardized_sev_scalar_pedest')
        self.log_transformed_age_standardized_sev_scalar_cyclist = kwargs.get('log_transformed_age_standardized_sev_scalar_cyclist')
        self.log_transformed_age_standardized_sev_scalar_mot_cyc = kwargs.get('log_transformed_age_standardized_sev_scalar_mot_cyc')
        self.log_transformed_age_standardized_sev_scalar_mot_veh = kwargs.get('log_transformed_age_standardized_sev_scalar_mot_veh')
        self.log_transformed_age_standardized_sev_scalar_oth_road = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_road')
        self.log_transformed_age_standardized_sev_scalar_oth_trans = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_trans')
        self.log_transformed_age_standardized_sev_scalar_falls = kwargs.get('log_transformed_age_standardized_sev_scalar_falls')
        self.log_transformed_age_standardized_sev_scalar_drown = kwargs.get('log_transformed_age_standardized_sev_scalar_drown')
        self.log_transformed_age_standardized_sev_scalar_fire = kwargs.get('log_transformed_age_standardized_sev_scalar_fire')
        self.log_transformed_age_standardized_sev_scalar_poison = kwargs.get('log_transformed_age_standardized_sev_scalar_poison')
        self.log_transformed_age_standardized_sev_scalar_mech = kwargs.get('log_transformed_age_standardized_sev_scalar_mech')
        self.log_transformed_age_standardized_sev_scalar_mech_gun = kwargs.get('log_transformed_age_standardized_sev_scalar_mech_gun')
        self.log_transformed_age_standardized_sev_scalar_mech_suff = kwargs.get('log_transformed_age_standardized_sev_scalar_mech_suff')
        self.log_transformed_age_standardized_sev_scalar_oth_mech = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_mech')
        self.log_transformed_age_standardized_sev_scalar_animal = kwargs.get('log_transformed_age_standardized_sev_scalar_animal')
        self.log_transformed_age_standardized_sev_scalar_venom = kwargs.get('log_transformed_age_standardized_sev_scalar_venom')
        self.log_transformed_age_standardized_sev_scalar_non_ven = kwargs.get('log_transformed_age_standardized_sev_scalar_non_ven')
        self.log_transformed_age_standardized_sev_scalar_f_body = kwargs.get('log_transformed_age_standardized_sev_scalar_f_body')
        self.log_transformed_age_standardized_sev_scalar_f_body_asp = kwargs.get('log_transformed_age_standardized_sev_scalar_f_body_asp')
        self.log_transformed_age_standardized_sev_scalar_f_body_eye = kwargs.get('log_transformed_age_standardized_sev_scalar_f_body_eye')
        self.log_transformed_age_standardized_sev_scalar_oth_f_body = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_f_body')
        self.log_transformed_age_standardized_sev_scalar_oth_unint = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_unint')
        self.log_transformed_age_standardized_sev_scalar_self_harm = kwargs.get('log_transformed_age_standardized_sev_scalar_self_harm')
        self.log_transformed_age_standardized_sev_scalar_violence = kwargs.get('log_transformed_age_standardized_sev_scalar_violence')
        self.log_transformed_age_standardized_sev_scalar_viol_gun = kwargs.get('log_transformed_age_standardized_sev_scalar_viol_gun')
        self.log_transformed_age_standardized_sev_scalar_viol_knife = kwargs.get('log_transformed_age_standardized_sev_scalar_viol_knife')
        self.log_transformed_age_standardized_sev_scalar_oth_viol = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_viol')
        self.deprecated_log_transformed_age_standardized_sev_scalar_disaster = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_disaster')
        self.h5n1_epidemic_years_binary = kwargs.get('h5n1_epidemic_years_binary')
        self.education_age_standardized = kwargs.get('education_age_standardized')
        self.meningitis_belt_proportion = kwargs.get('meningitis_belt_proportion')
        self.gdp_per_capita_base_2010 = kwargs.get('gdp_per_capita_base_2010')
        self.urbanicity = kwargs.get('urbanicity')
        self.age_and_sex_specific_sev_for_unsafe_water = kwargs.get('age_and_sex_specific_sev_for_unsafe_water')
        self.age_and_sex_specific_sev_for_unsafe_sanitation = kwargs.get('age_and_sex_specific_sev_for_unsafe_sanitation')
        self.malaria_incidence_from_map_estimates_africa = kwargs.get('malaria_incidence_from_map_estimates_africa')
        self.dengue_reporting_trends_transformed_into_relative_risks_relative_to_that_countrys_mean_incidence = kwargs.get('dengue_reporting_trends_transformed_into_relative_risks_relative_to_that_countrys_mean_incidence')
        self.echinococcosis_endemicity = kwargs.get('echinococcosis_endemicity')
        self.echinococcosis_presence = kwargs.get('echinococcosis_presence')
        self.socio_demographic_index = kwargs.get('socio_demographic_index')
        self.japanese_encelphalitis_endemic_area_binary = kwargs.get('japanese_encelphalitis_endemic_area_binary')
        self.calcium_adjusted_g = kwargs.get('calcium_adjusted_g')
        self.calcium_unadjusted_g = kwargs.get('calcium_unadjusted_g')
        self.diet_cholesterol_adjusted_mg = kwargs.get('diet_cholesterol_adjusted_mg')
        self.diet_cholesterol_unadjusted_mg = kwargs.get('diet_cholesterol_unadjusted_mg')
        self.fiber_adjusted_g = kwargs.get('fiber_adjusted_g')
        self.fiber_unadjusted_g = kwargs.get('fiber_unadjusted_g')
        self.omega_3_adjusted_g = kwargs.get('omega_3_adjusted_g')
        self.omega_3_unadjusted_g = kwargs.get('omega_3_unadjusted_g')
        self.fruits_adjusted_g = kwargs.get('fruits_adjusted_g')
        self.fruits_unadjusted_g = kwargs.get('fruits_unadjusted_g')
        self.milk_adjusted_g = kwargs.get('milk_adjusted_g')
        self.milk_unadjusted_g = kwargs.get('milk_unadjusted_g')
        self.nuts_seeds_adjusted_g = kwargs.get('nuts_seeds_adjusted_g')
        self.nuts_seeds_unadjusted_g = kwargs.get('nuts_seeds_unadjusted_g')
        self.pufa_adjusted_percent = kwargs.get('pufa_adjusted_percent')
        self.pulses_legumes_adjusted_g = kwargs.get('pulses_legumes_adjusted_g')
        self.pulses_legumes_unadjusted_g = kwargs.get('pulses_legumes_unadjusted_g')
        self.red_meats_adjusted_g = kwargs.get('red_meats_adjusted_g')
        self.red_meats_unadjusted_g = kwargs.get('red_meats_unadjusted_g')
        self.salt_adjusted_mg = kwargs.get('salt_adjusted_mg')
        self.salt_unadjusted_mg = kwargs.get('salt_unadjusted_mg')
        self.saturated_fats_adjusted_percent = kwargs.get('saturated_fats_adjusted_percent')
        self.stimulants_adjusted_g = kwargs.get('stimulants_adjusted_g')
        self.stimulants_unadjusted_g = kwargs.get('stimulants_unadjusted_g')
        self.sugar_adjusted_g = kwargs.get('sugar_adjusted_g')
        self.sugar_unadjusted_g = kwargs.get('sugar_unadjusted_g')
        self.vegetables_adjusted_g = kwargs.get('vegetables_adjusted_g')
        self.vegetables_unadjusted_g = kwargs.get('vegetables_unadjusted_g')
        self.whole_grains_adjusted_g = kwargs.get('whole_grains_adjusted_g')
        self.whole_grains_unadjusted_g = kwargs.get('whole_grains_unadjusted_g')
        self.energy_unadjusted_kcal = kwargs.get('energy_unadjusted_kcal')
        self.interaction_of_prevalence_weighted_drug_resistance_and_malaria_incidence = kwargs.get('interaction_of_prevalence_weighted_drug_resistance_and_malaria_incidence')
        self.migration_rate_per_1000_population = kwargs.get('migration_rate_per_1000_population')
        self.hiv_mortality_females_10_54 = kwargs.get('hiv_mortality_females_10_54')
        self.hiv_age_standardized_prevalence = kwargs.get('hiv_age_standardized_prevalence')
        self.log_transformed_age_standardized_sev_scalar_maternal = kwargs.get('log_transformed_age_standardized_sev_scalar_maternal')
        self.log_transformed_age_standardized_sev_scalar_cvd = kwargs.get('log_transformed_age_standardized_sev_scalar_cvd')
        self.log_transformed_age_standardized_sev_scalar_chr_resp = kwargs.get('log_transformed_age_standardized_sev_scalar_chr_resp')
        self.log_transformed_age_standardized_sev_scalar_cirrhosis = kwargs.get('log_transformed_age_standardized_sev_scalar_cirrhosis')
        self.log_transformed_age_standardized_sev_scalar_digestive = kwargs.get('log_transformed_age_standardized_sev_scalar_digestive')
        self.log_transformed_age_standardized_sev_scalar_msk = kwargs.get('log_transformed_age_standardized_sev_scalar_msk')
        self.log_transformed_age_standardized_sev_scalar_trans_inj = kwargs.get('log_transformed_age_standardized_sev_scalar_trans_inj')
        self.log_transformed_sev_scalar_maternal = kwargs.get('log_transformed_sev_scalar_maternal')
        self.log_transformed_sev_scalar_cvd = kwargs.get('log_transformed_sev_scalar_cvd')
        self.log_transformed_sev_scalar_chr_resp = kwargs.get('log_transformed_sev_scalar_chr_resp')
        self.log_transformed_sev_scalar_cirrhosis = kwargs.get('log_transformed_sev_scalar_cirrhosis')
        self.log_transformed_sev_scalar_digestive = kwargs.get('log_transformed_sev_scalar_digestive')
        self.log_transformed_sev_scalar_msk = kwargs.get('log_transformed_sev_scalar_msk')
        self.log_transformed_sev_scalar_trans_inj = kwargs.get('log_transformed_sev_scalar_trans_inj')
        self.proportion_of_total_population_in_japanese_encephalitis_endemic_area_india = kwargs.get('proportion_of_total_population_in_japanese_encephalitis_endemic_area_india')
        self.vitamin_a_unadjusted_iu = kwargs.get('vitamin_a_unadjusted_iu')
        self.vitamin_a_rae_unadjusted_ug = kwargs.get('vitamin_a_rae_unadjusted_ug')
        self.vitamin_a_retinol_unadjusted_ug = kwargs.get('vitamin_a_retinol_unadjusted_ug')
        self.dietary_zinc_unadjusted_mg = kwargs.get('dietary_zinc_unadjusted_mg')
        self.death_and_ncc_prevalence_ratio = kwargs.get('death_and_ncc_prevalence_ratio')
        self.cysticercosis_deaths_to_epilepsy_prevalence_ratio = kwargs.get('cysticercosis_deaths_to_epilepsy_prevalence_ratio')
        self.proportion_of_total_population_covered_by_menafrivac_initiative_meningitis_meningococcal_type_a_vaccine = kwargs.get('proportion_of_total_population_covered_by_menafrivac_initiative_meningitis_meningococcal_type_a_vaccine')
        self.stunting_proportion_less_than_2sd_height_for_age_less_than_5_years = kwargs.get('stunting_proportion_less_than_2sd_height_for_age_less_than_5_years')
        self.wasting_proportion_less_than_2sd_weight_for_height_less_than_5_years = kwargs.get('wasting_proportion_less_than_2sd_weight_for_height_less_than_5_years')
        self.malnutrition_childhood_underweight_proportion_less_than_2sd_weight_for_age = kwargs.get('malnutrition_childhood_underweight_proportion_less_than_2sd_weight_for_age')
        self.malaria_incidence_adjusted_for_antimalarial_coverage_and_drug_effectiveness = kwargs.get('malaria_incidence_adjusted_for_antimalarial_coverage_and_drug_effectiveness')
        self.hepatitis_b_hbsag_seroprevalence = kwargs.get('hepatitis_b_hbsag_seroprevalence')
        self.hepatitis_c_igg_seroprevalence = kwargs.get('hepatitis_c_igg_seroprevalence')
        self.rotavirus_coverage_proportion = kwargs.get('rotavirus_coverage_proportion')
        self.proportion_of_cirrhosis_due_to_alcohol = kwargs.get('proportion_of_cirrhosis_due_to_alcohol')
        self.proportion_of_cirrhosis_due_to_hepatitis_b = kwargs.get('proportion_of_cirrhosis_due_to_hepatitis_b')
        self.proportion_of_cirrhosis_due_to_hepatitis_c = kwargs.get('proportion_of_cirrhosis_due_to_hepatitis_c')
        self.proportion_of_cirrhosis_due_to_other_causes = kwargs.get('proportion_of_cirrhosis_due_to_other_causes')
        self.proportion_of_liver_cancer_due_to_alcohol_age_standardized = kwargs.get('proportion_of_liver_cancer_due_to_alcohol_age_standardized')
        self.proportion_of_liver_cancer_due_to_hepatitis_b_age_standardized = kwargs.get('proportion_of_liver_cancer_due_to_hepatitis_b_age_standardized')
        self.proportion_of_liver_cancer_due_to_hepatitis_c_age_standardized = kwargs.get('proportion_of_liver_cancer_due_to_hepatitis_c_age_standardized')
        self.proportion_of_liver_cancer_due_to_other_causes_age_standardized = kwargs.get('proportion_of_liver_cancer_due_to_other_causes_age_standardized')
        self.seroprevalence_of_anti_hav_igg = kwargs.get('seroprevalence_of_anti_hav_igg')
        self.seroprevalence_of_anti_hev_igg = kwargs.get('seroprevalence_of_anti_hev_igg')
        self.major_depressive_disorder = kwargs.get('major_depressive_disorder')
        self.proportion_of_population_involved_in_agricultural_activities = kwargs.get('proportion_of_population_involved_in_agricultural_activities')
        self.prevalence_of_binge_drinking_male = kwargs.get('prevalence_of_binge_drinking_male')
        self.health_expenditure_per_capita = kwargs.get('health_expenditure_per_capita')
        self.risk_of_selfharm_due_to_major_depressive_disorder = kwargs.get('risk_of_selfharm_due_to_major_depressive_disorder')
        self.trans_fatty_acid_bans = kwargs.get('trans_fatty_acid_bans')
        self.oop_health_expenditure_per_capita = kwargs.get('oop_health_expenditure_per_capita')
        self.fraction_of_oop_health_expenditure = kwargs.get('fraction_of_oop_health_expenditure')
        self.lag_distributed_energy = kwargs.get('lag_distributed_energy')
        self.art_coverage = kwargs.get('art_coverage')
        self.tuberculosis_case_detection = kwargs.get('tuberculosis_case_detection')
        self.universal_health_coverage = kwargs.get('universal_health_coverage')
        self.maternal_alcohol_consumption_during_pregnancy_proportion = kwargs.get('maternal_alcohol_consumption_during_pregnancy_proportion')
        self.healthcare_access_and_quality_index = kwargs.get('healthcare_access_and_quality_index')
        self.age_standardized_proportion_adult_underweight = kwargs.get('age_standardized_proportion_adult_underweight')
        self.reproductive_age_standardized_diabetes_prevalence_10_54_yrs_females = kwargs.get('reproductive_age_standardized_diabetes_prevalence_10_54_yrs_females')
        self.ors_oral_rehydration = kwargs.get('ors_oral_rehydration')
        self.antibiotics_for_lri = kwargs.get('antibiotics_for_lri')
        self.zinc_treatment = kwargs.get('zinc_treatment')
        self.antibiotics_for_diarrhea = kwargs.get('antibiotics_for_diarrhea')
        self.live_births_by_sex = kwargs.get('live_births_by_sex')
        self.age_standardized_melanoma = kwargs.get('age_standardized_melanoma')
        self.measles_vaccine_coverage_2_doses_proportion = kwargs.get('measles_vaccine_coverage_2_doses_proportion')
        self.sth_school_based_mda = kwargs.get('sth_school_based_mda')
        self.schisto_cumulative_treatments = kwargs.get('schisto_cumulative_treatments')
        self.health_worker_density = kwargs.get('health_worker_density')
        self.proportion_of_fevers_receiving_effective_treatment = kwargs.get('proportion_of_fevers_receiving_effective_treatment')
        self.iron_energy_unadjusted_mg = kwargs.get('iron_energy_unadjusted_mg')
        self.corn_energy_adjusted_g = kwargs.get('corn_energy_adjusted_g')
        self.corn_energy_unadjusted_g = kwargs.get('corn_energy_unadjusted_g')
        self.eggs_energy_adjusted_g = kwargs.get('eggs_energy_adjusted_g')
        self.eggs_energy_unadjusted_g = kwargs.get('eggs_energy_unadjusted_g')
        self.fish_energy_adjusted_g = kwargs.get('fish_energy_adjusted_g')
        self.fish_energy_unadjusted_g = kwargs.get('fish_energy_unadjusted_g')
        self.potatoes_energy_adjusted_g = kwargs.get('potatoes_energy_adjusted_g')
        self.potatoes_energy_unadjusted_g = kwargs.get('potatoes_energy_unadjusted_g')
        self.poultry_energy_adjusted_g = kwargs.get('poultry_energy_adjusted_g')
        self.poultry_energy_unadjusted_g = kwargs.get('poultry_energy_unadjusted_g')
        self.rice_energy_adjusted_g = kwargs.get('rice_energy_adjusted_g')
        self.rice_energy_unadjusted_g = kwargs.get('rice_energy_unadjusted_g')
        self.sweet_energy_potato_adjusted_g = kwargs.get('sweet_energy_potato_adjusted_g')
        self.sweet_energy_potato_unadjusted_g = kwargs.get('sweet_energy_potato_unadjusted_g')
        self.malaria_pfpr_map = kwargs.get('malaria_pfpr_map')
        self.malaria_incidence_map = kwargs.get('malaria_incidence_map')
        self.antimalarial_effective_treatment_ratio_map = kwargs.get('antimalarial_effective_treatment_ratio_map')
        self.antimalarial_effective_treatment_map = kwargs.get('antimalarial_effective_treatment_map')
        self.risk_of_selfharm_due_to_schizophrenia = kwargs.get('risk_of_selfharm_due_to_schizophrenia')
        self.risk_of_selfharm_due_to_anxiety_disorders = kwargs.get('risk_of_selfharm_due_to_anxiety_disorders')
        self.risk_of_selfharm_due_to_bipolar_disorder = kwargs.get('risk_of_selfharm_due_to_bipolar_disorder')
        self.mean_birth_weight = kwargs.get('mean_birth_weight')
        self.mean_weight_for_height_z_score_whz_0_5_years = kwargs.get('mean_weight_for_height_z_score_whz_0_5_years')
        self.mean_weight_for_age_z_score_waz_0_5_years = kwargs.get('mean_weight_for_age_z_score_waz_0_5_years')
        self.mean_height_for_age_z_score_haz_0_5_years = kwargs.get('mean_height_for_age_z_score_haz_0_5_years')
        self.mean_hemoglobin_concentration_age_standardized = kwargs.get('mean_hemoglobin_concentration_age_standardized')
        self.birth_prevalence_of_fetal_alcohol_syndrome_per_1000 = kwargs.get('birth_prevalence_of_fetal_alcohol_syndrome_per_1000')
        self.age_standardized_prevalence_of_cocaine_dependence_in_women_of_reproductive_age = kwargs.get('age_standardized_prevalence_of_cocaine_dependence_in_women_of_reproductive_age')
        self.age_standardized_prevalence_of_amphetamine_dependence_in_women_of_reproductive_age = kwargs.get('age_standardized_prevalence_of_amphetamine_dependence_in_women_of_reproductive_age')
        self.age_standardized_prevalence_of_opioid_dependence_in_women_of_reproductive_age = kwargs.get('age_standardized_prevalence_of_opioid_dependence_in_women_of_reproductive_age')
        self.age_standardized_prevalence_of_cannabis_dependence_in_women_of_reproductive_age = kwargs.get('age_standardized_prevalence_of_cannabis_dependence_in_women_of_reproductive_age')
        self.age_standardized_prevalence_of_total_drug_dependence_in_women_of_reproductive_age = kwargs.get('age_standardized_prevalence_of_total_drug_dependence_in_women_of_reproductive_age')
        self.rubella_vaccine_coverage_proportion = kwargs.get('rubella_vaccine_coverage_proportion')
        self.tuberculosis_infection_risk_weighted_prevalence_age_standardized = kwargs.get('tuberculosis_infection_risk_weighted_prevalence_age_standardized')
        self.presenting_vision_impairment = kwargs.get('presenting_vision_impairment')
        self.ten_year_lag_distributed_energy_per_capita = kwargs.get('ten_year_lag_distributed_energy_per_capita')
        self.alcohol_consumption_female_reproductive_age_standardized_grams_per_day = kwargs.get('alcohol_consumption_female_reproductive_age_standardized_grams_per_day')
        self.alcohol_consumption_female_reproductive_age_standardized_proportion = kwargs.get('alcohol_consumption_female_reproductive_age_standardized_proportion')
        self.folic_acid_unadjusted_ug = kwargs.get('folic_acid_unadjusted_ug')
        self.smooth_outphase_of_leaded_gasoline = kwargs.get('smooth_outphase_of_leaded_gasoline')
        self.no_access_to_handwashing_facility = kwargs.get('no_access_to_handwashing_facility')
        self.residential_radon = kwargs.get('residential_radon')
        self.lead_exposure = kwargs.get('lead_exposure')
        self.discontinued_breastfeeding_sev = kwargs.get('discontinued_breastfeeding_sev')
        self.zinc_deficiency = kwargs.get('zinc_deficiency')
        self.diet_low_in_whole_grains = kwargs.get('diet_low_in_whole_grains')
        self.diet_high_in_processed_meat = kwargs.get('diet_high_in_processed_meat')
        self.diet_high_in_trans_fatty_acids = kwargs.get('diet_high_in_trans_fatty_acids')
        self.diet_high_in_sodium = kwargs.get('diet_high_in_sodium')
        self.low_physical_activity_sev = kwargs.get('low_physical_activity_sev')
        self.tuberculosis_prevalence_age_standardized = kwargs.get('tuberculosis_prevalence_age_standardized')
        self.low_bone_mineral_density = kwargs.get('low_bone_mineral_density')
        self.age_standardized_bone_mineral_density_among_population_age_60_and_up_years = kwargs.get('age_standardized_bone_mineral_density_among_population_age_60_and_up_years')
        self.malnutrition_shock_log_transformed_mortality_rate = kwargs.get('malnutrition_shock_log_transformed_mortality_rate')
        self.malnutrition_shock_mortality_rate = kwargs.get('malnutrition_shock_mortality_rate')
        self.mean_war_mortality_rate_in_the_previous_ten_years = kwargs.get('mean_war_mortality_rate_in_the_previous_ten_years')
        self.shock_log_transformed_mortality_rate = kwargs.get('shock_log_transformed_mortality_rate')
        self.shock_mortality_rate = kwargs.get('shock_mortality_rate')
        self.disaster_log_transformed_mortality_rate = kwargs.get('disaster_log_transformed_mortality_rate')
        self.disaster_mortality_rate = kwargs.get('disaster_mortality_rate')
        self.state_actor_violence_log_transformed_mortality_rate = kwargs.get('state_actor_violence_log_transformed_mortality_rate')
        self.state_actor_violence_mortality_rate = kwargs.get('state_actor_violence_mortality_rate')
        self.war_log_transformed_mortality_rate = kwargs.get('war_log_transformed_mortality_rate')
        self.war_mortality_rate = kwargs.get('war_mortality_rate')
        self.age_standardized_melanoma_incidence = kwargs.get('age_standardized_melanoma_incidence')
        self.alcohol_abstainer_proportion_age_standardized = kwargs.get('alcohol_abstainer_proportion_age_standardized')
        self.log_transformed_age_standardized_sev_scalar_for_both_sexes_combined_tb = kwargs.get('log_transformed_age_standardized_sev_scalar_for_both_sexes_combined_tb')
        self.secondhand_smoke = kwargs.get('secondhand_smoke')
        self.saturated_fatty_acid_consumption__percent_of_total_dietary_energy = kwargs.get('saturated_fatty_acid_consumption__percent_of_total_dietary_energy')
        self.asbestos_consumption_metric_tons_per_year_per_capita = kwargs.get('asbestos_consumption_metric_tons_per_year_per_capita')
        self.visceral_leishmaniasis_incidence = kwargs.get('visceral_leishmaniasis_incidence')
        self.homicide_rate_sex_specific = kwargs.get('homicide_rate_sex_specific')
        self.op_visits_per_cap = kwargs.get('op_visits_per_cap')
        self.ip_admissons_per_cap = kwargs.get('ip_admissons_per_cap')
        self.non_partner_lifetime_prevalence_of_sexual_violence_female_only = kwargs.get('non_partner_lifetime_prevalence_of_sexual_violence_female_only')
        self.all_age_underweight = kwargs.get('all_age_underweight')
        self.zinc_treatment_for_diarrhea = kwargs.get('zinc_treatment_for_diarrhea')
        self.fortification_standard = kwargs.get('fortification_standard')
        self.fortification_standard_including_folic_acid = kwargs.get('fortification_standard_including_folic_acid')
        self.adult_hiv_crude_death_rate = kwargs.get('adult_hiv_crude_death_rate')
        self.demand_for_contraception_satisfied_with_modern_methods = kwargs.get('demand_for_contraception_satisfied_with_modern_methods')
        self.demand_for_contraception_satisfied_with_modern_methods_by_age = kwargs.get('demand_for_contraception_satisfied_with_modern_methods_by_age')
        self.long_term_population_weighted_mean_temperature = kwargs.get('long_term_population_weighted_mean_temperature')
        self.polio_3_dose_coverage_proportion = kwargs.get('polio_3_dose_coverage_proportion')
        self.hepatitis_b_3_dose_coverage_proportion = kwargs.get('hepatitis_b_3_dose_coverage_proportion')
        self.proportion_of_the_population_from_east_africa_india_central_asia = kwargs.get('proportion_of_the_population_from_east_africa_india_central_asia')
        self.proportion_of_the_population_from_west_africa = kwargs.get('proportion_of_the_population_from_west_africa')
        self.proportion_of_the_population_from_euro_america = kwargs.get('proportion_of_the_population_from_euro_america')
        self.proportion_of_the_population_from_east_asia = kwargs.get('proportion_of_the_population_from_east_asia')
        self.proportion_of_the_population_from_indo_oceania = kwargs.get('proportion_of_the_population_from_indo_oceania')
        self.composite_fortification_standard_and_folic_acid_inclusion = kwargs.get('composite_fortification_standard_and_folic_acid_inclusion')
        self.intravenous_drug_use_proportion_by_age = kwargs.get('intravenous_drug_use_proportion_by_age')
        self.intravenous_drug_use_age_standardized_proportion = kwargs.get('intravenous_drug_use_age_standardized_proportion')
        self.hepatitis_a_infection_incidence = kwargs.get('hepatitis_a_infection_incidence')
        self.alcohol_consumption_age_standardized_in_grams_per_day = kwargs.get('alcohol_consumption_age_standardized_in_grams_per_day')
        self.alcohol_drinker_proportion_age_standardized = kwargs.get('alcohol_drinker_proportion_age_standardized')
        self.hepatitis_b_infection_incidence = kwargs.get('hepatitis_b_infection_incidence')
        self.hepatitis_c_infection_incidence = kwargs.get('hepatitis_c_infection_incidence')
        self.hepatitis_e_infection_incidence = kwargs.get('hepatitis_e_infection_incidence')
        self.proportion_of_liver_cancer_due_to_nash_age_standardized = kwargs.get('proportion_of_liver_cancer_due_to_nash_age_standardized')
        self.proportion_of_cirrhosis_due_to_nash = kwargs.get('proportion_of_cirrhosis_due_to_nash')
        self.muslim_religion_proportion_of_population = kwargs.get('muslim_religion_proportion_of_population')
        self.echino_endemicity_level_1 = kwargs.get('echino_endemicity_level_1')
        self.echino_endemicity_level_2 = kwargs.get('echino_endemicity_level_2')
        self.echino_endemicity_level_3 = kwargs.get('echino_endemicity_level_3')
        self.tb_strain_prevalence_weighted_transmission_rr = kwargs.get('tb_strain_prevalence_weighted_transmission_rr')
        self.tb_strain_prevalence_weighted_treatment_failure_rr = kwargs.get('tb_strain_prevalence_weighted_treatment_failure_rr')
        self.tb_strain_prevalence_weighted_treatment_delay_rr = kwargs.get('tb_strain_prevalence_weighted_treatment_delay_rr')
        self.preterm_birth_prevalence_less_than_37_weeks_of_gestation = kwargs.get('preterm_birth_prevalence_less_than_37_weeks_of_gestation')
        self.extremely_preterm_birth_prevalence_less_than_28_weeks_of_gestation = kwargs.get('extremely_preterm_birth_prevalence_less_than_28_weeks_of_gestation')
        self.short_gestation_sev_all_ages_by_sex = kwargs.get('short_gestation_sev_all_ages_by_sex')
        self.age_and_sex_specific_sev_for_child_underweight = kwargs.get('age_and_sex_specific_sev_for_child_underweight')
        self.age_standardized_sev_for_child_underweight = kwargs.get('age_standardized_sev_for_child_underweight')
        self.age_and_sex_specific_sev_for_child_stunting = kwargs.get('age_and_sex_specific_sev_for_child_stunting')
        self.age_standardized_sev_for_child_stunting = kwargs.get('age_standardized_sev_for_child_stunting')
        self.age_and_sex_specific_sev_for_child_wasting = kwargs.get('age_and_sex_specific_sev_for_child_wasting')
        self.age_standardized_sev_for_child_wasting = kwargs.get('age_standardized_sev_for_child_wasting')
        self.low_birth_weight_sev_all_ages_by_sex = kwargs.get('low_birth_weight_sev_all_ages_by_sex')
        self.low_birth_weight_and_short_gestation_sev_all_ages_by_sex = kwargs.get('low_birth_weight_and_short_gestation_sev_all_ages_by_sex')
        self.preeclampsia_incidence_ratio_all_ages = kwargs.get('preeclampsia_incidence_ratio_all_ages')
        self.abo_blood_type_mismatch_at_birth = kwargs.get('abo_blood_type_mismatch_at_birth')
        self.rhesus_blood_type_mismatch_at_birth = kwargs.get('rhesus_blood_type_mismatch_at_birth')
        self.adult_hiv_death_rate_both_sexes = kwargs.get('adult_hiv_death_rate_both_sexes')
        self.fortification_standard_including_iron = kwargs.get('fortification_standard_including_iron')
        self.composite_fortification_standard_and_iron_inclusion = kwargs.get('composite_fortification_standard_and_iron_inclusion')
        self.pelvic_inflammatory_disease_age_standardized_prevalence = kwargs.get('pelvic_inflammatory_disease_age_standardized_prevalence')
        self.pelvic_inflammatory_disease_all_age_prevalence = kwargs.get('pelvic_inflammatory_disease_all_age_prevalence')
        self.nafld_nash_prevalence = kwargs.get('nafld_nash_prevalence')
        self.hepatitis_b_3_dose_coverage_proportion_lagged_5_years = kwargs.get('hepatitis_b_3_dose_coverage_proportion_lagged_5_years')
        self.hepatitis_b_3_dose_coverage_proportion_lagged_ten_years = kwargs.get('hepatitis_b_3_dose_coverage_proportion_lagged_ten_years')
        self.interaction_between_sdi_and_2_and_up4_wheeled_vehicles_per_capita = kwargs.get('interaction_between_sdi_and_2_and_up4_wheeled_vehicles_per_capita')
        self.age_standardized_death_rate_of_diabetes_0_15_years_per_100_000 = kwargs.get('age_standardized_death_rate_of_diabetes_0_15_years_per_100_000')
        self.age_and_sex_specific_sev_for_alcohol_use = kwargs.get('age_and_sex_specific_sev_for_alcohol_use')
        self.age_standardized_sev_for_alcohol_use = kwargs.get('age_standardized_sev_for_alcohol_use')
        self.underweight_women_of_reproductive_age = kwargs.get('underweight_women_of_reproductive_age')
        self.underweight_women_age_specific = kwargs.get('underweight_women_age_specific')
        self.underweight_men_age_specific = kwargs.get('underweight_men_age_specific')
        self.opioids_per_million_population_per_day = kwargs.get('opioids_per_million_population_per_day')
        self.prevalence_of_mtbc_lineage_1_strains_proportion = kwargs.get('prevalence_of_mtbc_lineage_1_strains_proportion')
        self.prevalence_of_mtbc_lineage_2_strains_proportion = kwargs.get('prevalence_of_mtbc_lineage_2_strains_proportion')
        self.prevalence_of_mtbc_lineage_3_strains_proportion = kwargs.get('prevalence_of_mtbc_lineage_3_strains_proportion')
        self.prevalence_of_mtbc_lineage_4_strains_proportion = kwargs.get('prevalence_of_mtbc_lineage_4_strains_proportion')
        self.prevalence_of_maf_lineage_5_and_6_proportion = kwargs.get('prevalence_of_maf_lineage_5_and_6_proportion')
        self.log_transformed_sev_scalar_group_i = kwargs.get('log_transformed_sev_scalar_group_i')
        self.log_transformed_sev_scalar_drug_sus_tb = kwargs.get('log_transformed_sev_scalar_drug_sus_tb')
        self.log_transformed_sev_scalar_mdr_tb = kwargs.get('log_transformed_sev_scalar_mdr_tb')
        self.log_transformed_sev_scalar_xdr_tb = kwargs.get('log_transformed_sev_scalar_xdr_tb')
        self.log_transformed_sev_scalar_hiv = kwargs.get('log_transformed_sev_scalar_hiv')
        self.log_transformed_sev_scalar_drug_sus_hiv_tb = kwargs.get('log_transformed_sev_scalar_drug_sus_hiv_tb')
        self.log_transformed_sev_scalar_mdr_hiv_tb = kwargs.get('log_transformed_sev_scalar_mdr_hiv_tb')
        self.log_transformed_sev_scalar_xdr_hiv_tb = kwargs.get('log_transformed_sev_scalar_xdr_hiv_tb')
        self.log_transformed_sev_scalar_mng_pne = kwargs.get('log_transformed_sev_scalar_mng_pne')
        self.log_transformed_sev_scalar_mng_hib = kwargs.get('log_transformed_sev_scalar_mng_hib')
        self.log_transformed_sev_scalar_mng_men = kwargs.get('log_transformed_sev_scalar_mng_men')
        self.log_transformed_sev_scalar_oth_mng = kwargs.get('log_transformed_sev_scalar_oth_mng')
        self.log_transformed_sev_scalar_encepha = kwargs.get('log_transformed_sev_scalar_encepha')
        self.deprecated_log_transformed_sev_scalar_diptheria = kwargs.get('deprecated_log_transformed_sev_scalar_diptheria')
        self.deprecated_log_transformed_sev_scalar_neonatal_preterm = kwargs.get('deprecated_log_transformed_sev_scalar_neonatal_preterm')
        self.log_transformed_sev_scalar_nn_enceph = kwargs.get('log_transformed_sev_scalar_nn_enceph')
        self.log_transformed_sev_scalar_nn_sepsis = kwargs.get('log_transformed_sev_scalar_nn_sepsis')
        self.log_transformed_sev_scalar_nn_hemol = kwargs.get('log_transformed_sev_scalar_nn_hemol')
        self.log_transformed_sev_scalar_oth_nn = kwargs.get('log_transformed_sev_scalar_oth_nn')
        self.deprecated_log_transformed_sev_scalar_nutrition_pem = kwargs.get('deprecated_log_transformed_sev_scalar_nutrition_pem')
        self.deprecated_log_transformed_sev_scalar_nutrition_vitamina = kwargs.get('deprecated_log_transformed_sev_scalar_nutrition_vitamina')
        self.deprecated_log_transformed_sev_scalar_nutrition_iron = kwargs.get('deprecated_log_transformed_sev_scalar_nutrition_iron')
        self.deprecated_log_transformed_sev_scalar_sti = kwargs.get('deprecated_log_transformed_sev_scalar_sti')
        self.deprecated_log_transformed_sev_scalar_std_syphilis = kwargs.get('deprecated_log_transformed_sev_scalar_std_syphilis')
        self.deprecated_log_transformed_sev_scalar_std_chlamydia = kwargs.get('deprecated_log_transformed_sev_scalar_std_chlamydia')
        self.deprecated_log_transformed_sev_scalar_std_gonnorhea = kwargs.get('deprecated_log_transformed_sev_scalar_std_gonnorhea')
        self.deprecated_log_transformed_sev_scalar_std_tricho = kwargs.get('deprecated_log_transformed_sev_scalar_std_tricho')
        self.deprecated_log_transformed_sev_scalar_std_herpes = kwargs.get('deprecated_log_transformed_sev_scalar_std_herpes')
        self.deprecated_log_transformed_sev_scalar_std_other = kwargs.get('deprecated_log_transformed_sev_scalar_std_other')
        self.log_transformed_sev_scalar_ncd = kwargs.get('log_transformed_sev_scalar_ncd')
        self.deprecated_log_transformed_sev_scalar_neo_liver_alcohol = kwargs.get('deprecated_log_transformed_sev_scalar_neo_liver_alcohol')
        self.deprecated_log_transformed_sev_scalar_neo_cervical = kwargs.get('deprecated_log_transformed_sev_scalar_neo_cervical')
        self.log_transformed_sev_scalar_lymphoma = kwargs.get('log_transformed_sev_scalar_lymphoma')
        self.log_transformed_sev_scalar_myeloma = kwargs.get('log_transformed_sev_scalar_myeloma')
        self.log_transformed_sev_scalar_all = kwargs.get('log_transformed_sev_scalar_all')
        self.log_transformed_sev_scalar_cll = kwargs.get('log_transformed_sev_scalar_cll')
        self.log_transformed_sev_scalar_aml = kwargs.get('log_transformed_sev_scalar_aml')
        self.log_transformed_sev_scalar_cml = kwargs.get('log_transformed_sev_scalar_cml')
        self.log_transformed_sev_scalar_oth_leukemia = kwargs.get('log_transformed_sev_scalar_oth_leukemia')
        self.deprecated_log_transformed_sev_scalar_cvd_htn = kwargs.get('deprecated_log_transformed_sev_scalar_cvd_htn')
        self.deprecated_log_transformed_sev_scalar_cvd_cmp_alcoholic = kwargs.get('deprecated_log_transformed_sev_scalar_cvd_cmp_alcoholic')
        self.log_transformed_sev_scalar_oth_cmp = kwargs.get('log_transformed_sev_scalar_oth_cmp')
        self.deprecated_log_transformed_sev_scalar_cirrhosis_alcohol = kwargs.get('deprecated_log_transformed_sev_scalar_cirrhosis_alcohol')
        self.log_transformed_sev_scalar_pud = kwargs.get('log_transformed_sev_scalar_pud')
        self.log_transformed_sev_scalar_gall_bile = kwargs.get('log_transformed_sev_scalar_gall_bile')
        self.log_transformed_sev_scalar_alzheimers = kwargs.get('log_transformed_sev_scalar_alzheimers')
        self.deprecated_log_transformed_sev_scalar_parkinsons = kwargs.get('deprecated_log_transformed_sev_scalar_parkinsons')
        self.log_transformed_sev_scalar_ms = kwargs.get('log_transformed_sev_scalar_ms')
        self.deprecated_log_transformed_sev_scalar_mental_alcohol = kwargs.get('deprecated_log_transformed_sev_scalar_mental_alcohol')
        self.deprecated_log_transformed_sev_scalar_drugs = kwargs.get('deprecated_log_transformed_sev_scalar_drugs')
        self.deprecated_log_transformed_sev_scalar_mental_drug_opioids = kwargs.get('deprecated_log_transformed_sev_scalar_mental_drug_opioids')
        self.deprecated_log_transformed_sev_scalar_mental_drug_cocaine = kwargs.get('deprecated_log_transformed_sev_scalar_mental_drug_cocaine')
        self.deprecated_log_transformed_sev_scalar_mental_drug_amphet = kwargs.get('deprecated_log_transformed_sev_scalar_mental_drug_amphet')
        self.deprecated_log_transformed_sev_scalar_mental_drug_cannabis = kwargs.get('deprecated_log_transformed_sev_scalar_mental_drug_cannabis')
        self.deprecated_log_transformed_sev_scalar_mental_drug_other = kwargs.get('deprecated_log_transformed_sev_scalar_mental_drug_other')
        self.deprecated_log_transformed_sev_scalar_diabetes = kwargs.get('deprecated_log_transformed_sev_scalar_diabetes')
        self.deprecated_log_transformed_sev_scalar_ckd = kwargs.get('deprecated_log_transformed_sev_scalar_ckd')
        self.deprecated_log_transformed_sev_scalar_ckd_diabetes = kwargs.get('deprecated_log_transformed_sev_scalar_ckd_diabetes')
        self.deprecated_log_transformed_sev_scalar_ckd_htn = kwargs.get('deprecated_log_transformed_sev_scalar_ckd_htn')
        self.deprecated_log_transformed_sev_scalar_ckd_glomerulo = kwargs.get('deprecated_log_transformed_sev_scalar_ckd_glomerulo')
        self.deprecated_log_transformed_sev_scalar_ckd_other = kwargs.get('deprecated_log_transformed_sev_scalar_ckd_other')
        self.log_transformed_sev_scalar_rheu_arth = kwargs.get('log_transformed_sev_scalar_rheu_arth')
        self.log_transformed_sev_scalar_glaucoma = kwargs.get('log_transformed_sev_scalar_glaucoma')
        self.log_transformed_sev_scalar_macular = kwargs.get('log_transformed_sev_scalar_macular')
        self.log_transformed_sev_scalar_injuries = kwargs.get('log_transformed_sev_scalar_injuries')
        self.log_transformed_sev_scalar_self_fire = kwargs.get('log_transformed_sev_scalar_self_fire')
        self.log_transformed_sev_scalar_self_other = kwargs.get('log_transformed_sev_scalar_self_other')
        self.log_transformed_sev_scalar_sex_viol = kwargs.get('log_transformed_sev_scalar_sex_viol')
        self.log_transformed_age_standardized_sev_scalar_group_i = kwargs.get('log_transformed_age_standardized_sev_scalar_group_i')
        self.log_transformed_age_standardized_sev_scalar_drug_sus_tb = kwargs.get('log_transformed_age_standardized_sev_scalar_drug_sus_tb')
        self.log_transformed_age_standardized_sev_scalar_mdr_tb = kwargs.get('log_transformed_age_standardized_sev_scalar_mdr_tb')
        self.log_transformed_age_standardized_sev_scalar_xdr_tb = kwargs.get('log_transformed_age_standardized_sev_scalar_xdr_tb')
        self.log_transformed_age_standardized_sev_scalar_hiv = kwargs.get('log_transformed_age_standardized_sev_scalar_hiv')
        self.log_transformed_age_standardized_sev_scalar_drug_sus_hiv_tb = kwargs.get('log_transformed_age_standardized_sev_scalar_drug_sus_hiv_tb')
        self.log_transformed_age_standardized_sev_scalar_mdr_hiv_tb = kwargs.get('log_transformed_age_standardized_sev_scalar_mdr_hiv_tb')
        self.log_transformed_age_standardized_sev_scalar_xdr_hiv_tb = kwargs.get('log_transformed_age_standardized_sev_scalar_xdr_hiv_tb')
        self.log_transformed_age_standardized_sev_scalar_meningitis = kwargs.get('log_transformed_age_standardized_sev_scalar_meningitis')
        self.log_transformed_age_standardized_sev_scalar_mng_pne = kwargs.get('log_transformed_age_standardized_sev_scalar_mng_pne')
        self.log_transformed_age_standardized_sev_scalar_mng_hib = kwargs.get('log_transformed_age_standardized_sev_scalar_mng_hib')
        self.log_transformed_age_standardized_sev_scalar_mng_men = kwargs.get('log_transformed_age_standardized_sev_scalar_mng_men')
        self.log_transformed_age_standardized_sev_scalar_oth_mng = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_mng')
        self.log_transformed_age_standardized_sev_scalar_encepha = kwargs.get('log_transformed_age_standardized_sev_scalar_encepha')
        self.deprecated_log_transformed_age_standardized_sev_scalar_diptheria = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_diptheria')
        self.deprecated_log_transformed_age_standardized_sev_scalar_whooping = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_whooping')
        self.deprecated_log_transformed_age_standardized_sev_scalar_tetanus = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_tetanus')
        self.deprecated_log_transformed_age_standardized_sev_scalar_neonatal_preterm = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_neonatal_preterm')
        self.log_transformed_age_standardized_sev_scalar_nn_enceph = kwargs.get('log_transformed_age_standardized_sev_scalar_nn_enceph')
        self.log_transformed_age_standardized_sev_scalar_nn_sepsis = kwargs.get('log_transformed_age_standardized_sev_scalar_nn_sepsis')
        self.log_transformed_age_standardized_sev_scalar_nn_hemol = kwargs.get('log_transformed_age_standardized_sev_scalar_nn_hemol')
        self.log_transformed_age_standardized_sev_scalar_oth_nn = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_nn')
        self.deprecated_log_transformed_age_standardized_sev_scalar_nutrition_pem = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_nutrition_pem')
        self.deprecated_log_transformed_age_standardized_sev_scalar_nutrition_vitamina = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_nutrition_vitamina')
        self.deprecated_log_transformed_age_standardized_sev_scalar_nutrition_iron = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_nutrition_iron')
        self.deprecated_log_transformed_age_standardized_sev_scalar_sti = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_sti')
        self.deprecated_log_transformed_age_standardized_sev_scalar_std_syphilis = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_std_syphilis')
        self.deprecated_log_transformed_age_standardized_sev_scalar_std_chlamydia = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_std_chlamydia')
        self.deprecated_log_transformed_age_standardized_sev_scalar_std_gonnorhea = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_std_gonnorhea')
        self.deprecated_log_transformed_age_standardized_sev_scalar_std_tricho = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_std_tricho')
        self.deprecated_log_transformed_age_standardized_sev_scalar_std_herpes = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_std_herpes')
        self.deprecated_log_transformed_age_standardized_sev_scalar_std_other = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_std_other')
        self.deprecated_log_transformed_age_standardized_sev_scalar_ncd = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_ncd')
        self.deprecated_log_transformed_age_standardized_sev_scalar_neo_liver_alcohol = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_neo_liver_alcohol')
        self.deprecated_log_transformed_age_standardized_sev_scalar_neo_cervical = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_neo_cervical')
        self.log_transformed_age_standardized_sev_scalar_lymphoma = kwargs.get('log_transformed_age_standardized_sev_scalar_lymphoma')
        self.log_transformed_age_standardized_sev_scalar_myeloma = kwargs.get('log_transformed_age_standardized_sev_scalar_myeloma')
        self.log_transformed_age_standardized_sev_scalar_all = kwargs.get('log_transformed_age_standardized_sev_scalar_all')
        self.log_transformed_age_standardized_sev_scalar_cll = kwargs.get('log_transformed_age_standardized_sev_scalar_cll')
        self.log_transformed_age_standardized_sev_scalar_aml = kwargs.get('log_transformed_age_standardized_sev_scalar_aml')
        self.log_transformed_age_standardized_sev_scalar_cml = kwargs.get('log_transformed_age_standardized_sev_scalar_cml')
        self.log_transformed_age_standardized_sev_scalar_oth_leukemia = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_leukemia')
        self.deprecated_log_transformed_age_standardized_sev_scalar_cvd_htn = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_cvd_htn')
        self.deprecated_log_transformed_age_standardized_sev_scalar_cvd_cmp_alcoholic = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_cvd_cmp_alcoholic')
        self.log_transformed_age_standardized_sev_scalar_oth_cmp = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_cmp')
        self.deprecated_log_transformed_age_standardized_sev_scalar_cirrhosis_alcohol = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_cirrhosis_alcohol')
        self.log_transformed_age_standardized_sev_scalar_pud = kwargs.get('log_transformed_age_standardized_sev_scalar_pud')
        self.log_transformed_age_standardized_sev_scalar_gall_bile = kwargs.get('log_transformed_age_standardized_sev_scalar_gall_bile')
        self.log_transformed_age_standardized_sev_scalar_alzheimers = kwargs.get('log_transformed_age_standardized_sev_scalar_alzheimers')
        self.deprecated_log_transformed_age_standardized_sev_scalar_parkinsons = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_parkinsons')
        self.log_transformed_age_standardized_sev_scalar_ms = kwargs.get('log_transformed_age_standardized_sev_scalar_ms')
        self.deprecated_log_transformed_age_standardized_sev_scalar_mental_alcohol = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_mental_alcohol')
        self.deprecated_log_transformed_age_standardized_sev_scalar_drugs = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_drugs')
        self.deprecated_log_transformed_age_standardized_sev_scalar_mental_drug_opioids = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_mental_drug_opioids')
        self.deprecated_log_transformed_age_standardized_sev_scalar_mental_drug_cocaine = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_mental_drug_cocaine')
        self.deprecated_log_transformed_age_standardized_sev_scalar_mental_drug_amphet = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_mental_drug_amphet')
        self.deprecated_log_transformed_age_standardized_sev_scalar_mental_drug_cannabis = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_mental_drug_cannabis')
        self.deprecated_log_transformed_age_standardized_sev_scalar_mental_drug_other = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_mental_drug_other')
        self.deprecated_log_transformed_age_standardized_sev_scalar_diabetes = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_diabetes')
        self.deprecated_log_transformed_age_standardized_sev_scalar_ckd = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_ckd')
        self.deprecated_log_transformed_age_standardized_sev_scalar_ckd_diabetes = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_ckd_diabetes')
        self.deprecated_log_transformed_age_standardized_sev_scalar_ckd_htn = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_ckd_htn')
        self.deprecated_log_transformed_age_standardized_sev_scalar_ckd_glomerulo = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_ckd_glomerulo')
        self.deprecated_log_transformed_age_standardized_sev_scalar_ckd_other = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_ckd_other')
        self.log_transformed_age_standardized_sev_scalar_rheu_arth = kwargs.get('log_transformed_age_standardized_sev_scalar_rheu_arth')
        self.log_transformed_age_standardized_sev_scalar_glaucoma = kwargs.get('log_transformed_age_standardized_sev_scalar_glaucoma')
        self.log_transformed_age_standardized_sev_scalar_macular = kwargs.get('log_transformed_age_standardized_sev_scalar_macular')
        self.log_transformed_age_standardized_sev_scalar_sids = kwargs.get('log_transformed_age_standardized_sev_scalar_sids')
        self.log_transformed_age_standardized_sev_scalar_injuries = kwargs.get('log_transformed_age_standardized_sev_scalar_injuries')
        self.log_transformed_age_standardized_sev_scalar_self_fire = kwargs.get('log_transformed_age_standardized_sev_scalar_self_fire')
        self.log_transformed_age_standardized_sev_scalar_self_other = kwargs.get('log_transformed_age_standardized_sev_scalar_self_other')
        self.log_transformed_age_standardized_sev_scalar_sex_viol = kwargs.get('log_transformed_age_standardized_sev_scalar_sex_viol')
        self.opioids_per_million_population_per_day_5_year_lag = kwargs.get('opioids_per_million_population_per_day_5_year_lag')
        self.opioids_per_million_population_per_day_ten_year_lag = kwargs.get('opioids_per_million_population_per_day_ten_year_lag')
        self.occupation_professionals = kwargs.get('occupation_professionals')
        self.health_industry_workers = kwargs.get('health_industry_workers')
        self.education_years_per_capita_aggregated_by_age_15_and_up_and_sex = kwargs.get('education_years_per_capita_aggregated_by_age_15_and_up_and_sex')
        self.underweight_age_and_sex_specific = kwargs.get('underweight_age_and_sex_specific')
        self.total_physical_activity_met_min_week_age_specific = kwargs.get('total_physical_activity_met_min_week_age_specific')
        self.total_physical_activity_met_min_week_age_standardized = kwargs.get('total_physical_activity_met_min_week_age_standardized')
        self.full_vaccine_coverage_indicator_proportion = kwargs.get('full_vaccine_coverage_indicator_proportion')
        self.bacille_calmette_guerin_bcg_vaccine_coverage_proportion = kwargs.get('bacille_calmette_guerin_bcg_vaccine_coverage_proportion')
        self.hepatitis_b_vaccine_coverage_proportion_aged_through_time = kwargs.get('hepatitis_b_vaccine_coverage_proportion_aged_through_time')
        self.adolescent_birth_rates_10_19_years_of_age = kwargs.get('adolescent_birth_rates_10_19_years_of_age')
        self.percent_well_certified = kwargs.get('percent_well_certified')
        self.log_total_health_expenditure_per_capita = kwargs.get('log_total_health_expenditure_per_capita')
        self.count_of_population_censuses = kwargs.get('count_of_population_censuses')
        self.birth_registry_completeness = kwargs.get('birth_registry_completeness')
        self.pigs_raised_in_extensive_agricultural_systems_per_capita = kwargs.get('pigs_raised_in_extensive_agricultural_systems_per_capita')
        self.pigs_raised_in_semi_extensive_agricultural_systems_per_capita = kwargs.get('pigs_raised_in_semi_extensive_agricultural_systems_per_capita')
        self.pigs_raised_in_intensive_industrial_agricultural_systems_per_capita = kwargs.get('pigs_raised_in_intensive_industrial_agricultural_systems_per_capita')
        self.implicit_versus_explicitly_defined_nash = kwargs.get('implicit_versus_explicitly_defined_nash')
        self.mean_hemoglobin_age_sex_specific = kwargs.get('mean_hemoglobin_age_sex_specific')
        self.physicians_per_capita = kwargs.get('physicians_per_capita')
        self.nurses_and_midwives_per_capita = kwargs.get('nurses_and_midwives_per_capita')
        self.pharmacists_per_capita = kwargs.get('pharmacists_per_capita')
        self.hiv_mortality_rate = kwargs.get('hiv_mortality_rate')
        self.untreated_hiv = kwargs.get('untreated_hiv')
        self.medical_schools = kwargs.get('medical_schools')
        self.dentists_per_capita = kwargs.get('dentists_per_capita')
        self.full_vaccine_coverage_indicator_proportion_sage_method_dtp3_pcv3_mcv2 = kwargs.get('full_vaccine_coverage_indicator_proportion_sage_method_dtp3_pcv3_mcv2')
        self.net_reproductive_rate = kwargs.get('net_reproductive_rate')
        self.log_transformed_coal_production_per_capita = kwargs.get('log_transformed_coal_production_per_capita')
        self.systolic_blood_pressure_mmhg_us_r_e = kwargs.get('systolic_blood_pressure_mmhg_us_r_e')
        self.low_density_lipoprotein_mmol_l_us_r_e = kwargs.get('low_density_lipoprotein_mmol_l_us_r_e')
        self.mean_bmi_kg_m2_us_r_e = kwargs.get('mean_bmi_kg_m2_us_r_e')
        self.education_years_per_capita_us_r_e = kwargs.get('education_years_per_capita_us_r_e')
        self.ldi_income_per_capita_us_r_e = kwargs.get('ldi_income_per_capita_us_r_e')
        self.fasting_plasma_glucose_us_r_e = kwargs.get('fasting_plasma_glucose_us_r_e')
        self.total_physical_activity_met_min_week_age_specific_us_r_e = kwargs.get('total_physical_activity_met_min_week_age_specific_us_r_e')
        self.total_physical_activity_met_min_week_age_standardized_us_r_e = kwargs.get('total_physical_activity_met_min_week_age_standardized_us_r_e')
        self.alcohol_liters_per_capita_us_r_e = kwargs.get('alcohol_liters_per_capita_us_r_e')
        self.smoking_prevalence_us_r_e = kwargs.get('smoking_prevalence_us_r_e')
        self.outdoor_air_pollution_pm_2_5_us_r_e = kwargs.get('outdoor_air_pollution_pm_2_5_us_r_e')
        self.fruits_unadjusted_g_us_r_e = kwargs.get('fruits_unadjusted_g_us_r_e')
        self.vegetables_unadjusted_g_us_r_e = kwargs.get('vegetables_unadjusted_g_us_r_e')
        self.proportion_of_the_population_with_at_least_6_years_of_education = kwargs.get('proportion_of_the_population_with_at_least_6_years_of_education')
        self.proportion_of_the_population_with_at_least_12_years_of_education = kwargs.get('proportion_of_the_population_with_at_least_12_years_of_education')
        self.proportion_of_the_population_with_at_least_15_years_of_education = kwargs.get('proportion_of_the_population_with_at_least_15_years_of_education')
        self.education_absolute_inequality_aaid = kwargs.get('education_absolute_inequality_aaid')
        self.education_relative_inequality_gini = kwargs.get('education_relative_inequality_gini')
        self.proportion_of_the_population_with_at_least_6_years_of_education_age_standardized = kwargs.get('proportion_of_the_population_with_at_least_6_years_of_education_age_standardized')
        self.proportion_of_the_population_with_at_least_12_years_of_education_age_standardized = kwargs.get('proportion_of_the_population_with_at_least_12_years_of_education_age_standardized')
        self.proportion_of_the_population_with_at_least_15_years_of_education_age_standardized = kwargs.get('proportion_of_the_population_with_at_least_15_years_of_education_age_standardized')
        self.education_absolute_inequality_aaid_age_standardized = kwargs.get('education_absolute_inequality_aaid_age_standardized')
        self.education_relative_inequality_gini_age_standardized = kwargs.get('education_relative_inequality_gini_age_standardized')
        self.proportion_of_the_population_with_at_least_6_years_of_education_maternal = kwargs.get('proportion_of_the_population_with_at_least_6_years_of_education_maternal')
        self.proportion_of_the_population_with_at_least_12_years_of_education_maternal = kwargs.get('proportion_of_the_population_with_at_least_12_years_of_education_maternal')
        self.proportion_of_the_population_with_at_least_15_years_of_education_maternal = kwargs.get('proportion_of_the_population_with_at_least_15_years_of_education_maternal')
        self.education_absolute_inequality_aaid_maternal = kwargs.get('education_absolute_inequality_aaid_maternal')
        self.education_relative_inequality_gini_maternal = kwargs.get('education_relative_inequality_gini_maternal')
        self.mmr_due_toe_maternal_hemorrhage = kwargs.get('mmr_due_toe_maternal_hemorrhage')
        self.mmr_due_to_maternal_hypertensive_disorders = kwargs.get('mmr_due_to_maternal_hypertensive_disorders')
        self.mmr_due_to_abortion_and_miscarriage = kwargs.get('mmr_due_to_abortion_and_miscarriage')
        self.mmr_due_to_sepsis_and_other_maternal_infections = kwargs.get('mmr_due_to_sepsis_and_other_maternal_infections')
        self.mmr_due_to_obstructed_labor = kwargs.get('mmr_due_to_obstructed_labor')
        self.mmr_due_to_ectopic_pregnancy = kwargs.get('mmr_due_to_ectopic_pregnancy')
        self.mean_hemoglobin = kwargs.get('mean_hemoglobin')
        self.age_standardized_sev_for_unsafe_water = kwargs.get('age_standardized_sev_for_unsafe_water')
        self.age_standardized_sev_for_unsafe_sanitation = kwargs.get('age_standardized_sev_for_unsafe_sanitation')
        self.age_and_sex_specific_sev_for_handwashing = kwargs.get('age_and_sex_specific_sev_for_handwashing')
        self.age_standardized_sev_for_handwashing = kwargs.get('age_standardized_sev_for_handwashing')
        self.age_and_sex_specific_sev_for_ambient_particulate_matter = kwargs.get('age_and_sex_specific_sev_for_ambient_particulate_matter')
        self.age_standardized_sev_for_ambient_particulate_matter = kwargs.get('age_standardized_sev_for_ambient_particulate_matter')
        self.age_and_sex_specific_sev_for_household_air_pollution = kwargs.get('age_and_sex_specific_sev_for_household_air_pollution')
        self.age_standardized_sev_for_household_air_pollution = kwargs.get('age_standardized_sev_for_household_air_pollution')
        self.age_and_sex_specific_sev_for_ozone = kwargs.get('age_and_sex_specific_sev_for_ozone')
        self.age_standardized_sev_for_ozone = kwargs.get('age_standardized_sev_for_ozone')
        self.age_and_sex_specific_sev_for_radon = kwargs.get('age_and_sex_specific_sev_for_radon')
        self.age_standardized_sev_for_radon = kwargs.get('age_standardized_sev_for_radon')
        self.age_and_sex_specific_sev_for_lead = kwargs.get('age_and_sex_specific_sev_for_lead')
        self.age_standardized_sev_for_lead = kwargs.get('age_standardized_sev_for_lead')
        self.age_and_sex_specific_sev_for_occupational_asbestos = kwargs.get('age_and_sex_specific_sev_for_occupational_asbestos')
        self.age_standardized_sev_for_occupational_asbestos = kwargs.get('age_standardized_sev_for_occupational_asbestos')
        self.age_and_sex_specific_sev_for_occupational_arsenic = kwargs.get('age_and_sex_specific_sev_for_occupational_arsenic')
        self.age_standardized_sev_for_occupational_arsenic = kwargs.get('age_standardized_sev_for_occupational_arsenic')
        self.age_and_sex_specific_sev_for_occupational_benzene = kwargs.get('age_and_sex_specific_sev_for_occupational_benzene')
        self.age_standardized_sev_for_occupational_benzene = kwargs.get('age_standardized_sev_for_occupational_benzene')
        self.age_and_sex_specific_sev_for_occupational_beryllium = kwargs.get('age_and_sex_specific_sev_for_occupational_beryllium')
        self.age_standardized_sev_for_occupational_beryllium = kwargs.get('age_standardized_sev_for_occupational_beryllium')
        self.age_and_sex_specific_sev_for_occupational_cadmium = kwargs.get('age_and_sex_specific_sev_for_occupational_cadmium')
        self.age_standardized_sev_for_occupational_cadmium = kwargs.get('age_standardized_sev_for_occupational_cadmium')
        self.age_and_sex_specific_sev_for_occupational_chromium = kwargs.get('age_and_sex_specific_sev_for_occupational_chromium')
        self.age_standardized_sev_for_occupational_chromium = kwargs.get('age_standardized_sev_for_occupational_chromium')
        self.age_and_sex_specific_sev_for_occupational_diesel = kwargs.get('age_and_sex_specific_sev_for_occupational_diesel')
        self.age_standardized_sev_for_occupational_diesel = kwargs.get('age_standardized_sev_for_occupational_diesel')
        self.age_and_sex_specific_sev_for_occupational_formaldehyde = kwargs.get('age_and_sex_specific_sev_for_occupational_formaldehyde')
        self.age_standardized_sev_for_occupational_formaldehyde = kwargs.get('age_standardized_sev_for_occupational_formaldehyde')
        self.age_and_sex_specific_sev_for_occupational_nickel = kwargs.get('age_and_sex_specific_sev_for_occupational_nickel')
        self.age_standardized_sev_for_occupational_nickel = kwargs.get('age_standardized_sev_for_occupational_nickel')
        self.age_and_sex_specific_sev_for_occupational_pah = kwargs.get('age_and_sex_specific_sev_for_occupational_pah')
        self.age_standardized_sev_for_occupational_pah = kwargs.get('age_standardized_sev_for_occupational_pah')
        self.age_and_sex_specific_sev_for_occupational_silica = kwargs.get('age_and_sex_specific_sev_for_occupational_silica')
        self.age_standardized_sev_for_occupational_silica = kwargs.get('age_standardized_sev_for_occupational_silica')
        self.age_and_sex_specific_sev_for_occupational_sulfuric_acid = kwargs.get('age_and_sex_specific_sev_for_occupational_sulfuric_acid')
        self.age_standardized_sev_for_occupational_sulfuric_acid = kwargs.get('age_standardized_sev_for_occupational_sulfuric_acid')
        self.age_and_sex_specific_sev_for_occupational_trichloroethylene = kwargs.get('age_and_sex_specific_sev_for_occupational_trichloroethylene')
        self.age_standardized_sev_for_occupational_trichloroethylene = kwargs.get('age_standardized_sev_for_occupational_trichloroethylene')
        self.age_and_sex_specific_sev_for_occupational_asthmagens = kwargs.get('age_and_sex_specific_sev_for_occupational_asthmagens')
        self.age_standardized_sev_for_occupational_asthmagens = kwargs.get('age_standardized_sev_for_occupational_asthmagens')
        self.age_and_sex_specific_sev_for_occupational_particulates = kwargs.get('age_and_sex_specific_sev_for_occupational_particulates')
        self.age_standardized_sev_for_occupational_particulates = kwargs.get('age_standardized_sev_for_occupational_particulates')
        self.age_and_sex_specific_sev_for_occupational_noise = kwargs.get('age_and_sex_specific_sev_for_occupational_noise')
        self.age_standardized_sev_for_occupational_noise = kwargs.get('age_standardized_sev_for_occupational_noise')
        self.age_and_sex_specific_sev_for_occupational_injury = kwargs.get('age_and_sex_specific_sev_for_occupational_injury')
        self.age_standardized_sev_for_occupational_injury = kwargs.get('age_standardized_sev_for_occupational_injury')
        self.age_and_sex_specific_sev_for_occupational_ergonomic = kwargs.get('age_and_sex_specific_sev_for_occupational_ergonomic')
        self.age_standardized_sev_for_occupational_ergonomic = kwargs.get('age_standardized_sev_for_occupational_ergonomic')
        self.age_and_sex_specific_sev_for_non_exclusive_breastfeeding = kwargs.get('age_and_sex_specific_sev_for_non_exclusive_breastfeeding')
        self.age_standardized_sev_for_non_exclusive_breastfeeding = kwargs.get('age_standardized_sev_for_non_exclusive_breastfeeding')
        self.age_and_sex_specific_sev_for_discontinued_breastfeeding = kwargs.get('age_and_sex_specific_sev_for_discontinued_breastfeeding')
        self.age_standardized_sev_for_discontinued_breastfeeding = kwargs.get('age_standardized_sev_for_discontinued_breastfeeding')
        self.age_and_sex_specific_sev_for_short_gestation = kwargs.get('age_and_sex_specific_sev_for_short_gestation')
        self.age_standardized_sev_for_short_gestation = kwargs.get('age_standardized_sev_for_short_gestation')
        self.age_and_sex_specific_sev_for_low_birth_weight = kwargs.get('age_and_sex_specific_sev_for_low_birth_weight')
        self.age_standardized_sev_for_low_birth_weight = kwargs.get('age_standardized_sev_for_low_birth_weight')
        self.age_and_sex_specific_sev_for_iron_deficiency = kwargs.get('age_and_sex_specific_sev_for_iron_deficiency')
        self.age_standardized_sev_for_iron_deficiency = kwargs.get('age_standardized_sev_for_iron_deficiency')
        self.age_and_sex_specific_sev_for_vitamin_a_deficiency = kwargs.get('age_and_sex_specific_sev_for_vitamin_a_deficiency')
        self.age_standardized_sev_for_vitamin_a_deficiency = kwargs.get('age_standardized_sev_for_vitamin_a_deficiency')
        self.age_and_sex_specific_sev_for_zinc_deficiency = kwargs.get('age_and_sex_specific_sev_for_zinc_deficiency')
        self.age_standardized_sev_for_zinc_deficiency = kwargs.get('age_standardized_sev_for_zinc_deficiency')
        self.age_and_sex_specific_sev_for_smoking = kwargs.get('age_and_sex_specific_sev_for_smoking')
        self.age_standardized_sev_for_smoking = kwargs.get('age_standardized_sev_for_smoking')
        self.age_and_sex_specific_sev_for_chewing_tobacco = kwargs.get('age_and_sex_specific_sev_for_chewing_tobacco')
        self.age_standardized_sev_for_chewing_tobacco = kwargs.get('age_standardized_sev_for_chewing_tobacco')
        self.age_and_sex_specific_sev_for_secondhand_smoke = kwargs.get('age_and_sex_specific_sev_for_secondhand_smoke')
        self.age_standardized_sev_for_secondhand_smoke = kwargs.get('age_standardized_sev_for_secondhand_smoke')
        self.age_and_sex_specific_sev_for_drug_use = kwargs.get('age_and_sex_specific_sev_for_drug_use')
        self.age_standardized_sev_for_drug_use = kwargs.get('age_standardized_sev_for_drug_use')
        self.age_and_sex_specific_sev_for_low_fruit = kwargs.get('age_and_sex_specific_sev_for_low_fruit')
        self.age_standardized_sev_for_low_fruit = kwargs.get('age_standardized_sev_for_low_fruit')
        self.age_and_sex_specific_sev_for_low_vegetables = kwargs.get('age_and_sex_specific_sev_for_low_vegetables')
        self.age_standardized_sev_for_low_vegetables = kwargs.get('age_standardized_sev_for_low_vegetables')
        self.age_and_sex_specific_sev_for_low_legumes = kwargs.get('age_and_sex_specific_sev_for_low_legumes')
        self.age_standardized_sev_for_low_legumes = kwargs.get('age_standardized_sev_for_low_legumes')
        self.age_and_sex_specific_sev_for_low_whole_grains = kwargs.get('age_and_sex_specific_sev_for_low_whole_grains')
        self.age_standardized_sev_for_low_whole_grains = kwargs.get('age_standardized_sev_for_low_whole_grains')
        self.age_and_sex_specific_sev_for_low_nuts_and_seeds = kwargs.get('age_and_sex_specific_sev_for_low_nuts_and_seeds')
        self.age_standardized_sev_for_low_nuts_and_seeds = kwargs.get('age_standardized_sev_for_low_nuts_and_seeds')
        self.age_and_sex_specific_sev_for_low_milk = kwargs.get('age_and_sex_specific_sev_for_low_milk')
        self.age_standardized_sev_for_low_milk = kwargs.get('age_standardized_sev_for_low_milk')
        self.age_and_sex_specific_sev_for_high_red_meat = kwargs.get('age_and_sex_specific_sev_for_high_red_meat')
        self.age_standardized_sev_for_high_red_meat = kwargs.get('age_standardized_sev_for_high_red_meat')
        self.age_and_sex_specific_sev_for_high_processed_meat = kwargs.get('age_and_sex_specific_sev_for_high_processed_meat')
        self.age_standardized_sev_for_high_processed_meat = kwargs.get('age_standardized_sev_for_high_processed_meat')
        self.age_and_sex_specific_sev_for_high_sweetened_beverages = kwargs.get('age_and_sex_specific_sev_for_high_sweetened_beverages')
        self.age_standardized_sev_for_high_sweetened_beverages = kwargs.get('age_standardized_sev_for_high_sweetened_beverages')
        self.age_and_sex_specific_sev_for_low_fiber = kwargs.get('age_and_sex_specific_sev_for_low_fiber')
        self.age_standardized_sev_for_low_fiber = kwargs.get('age_standardized_sev_for_low_fiber')
        self.age_and_sex_specific_sev_for_low_calcium = kwargs.get('age_and_sex_specific_sev_for_low_calcium')
        self.age_standardized_sev_for_low_calcium = kwargs.get('age_standardized_sev_for_low_calcium')
        self.age_and_sex_specific_sev_for_low_omega_3 = kwargs.get('age_and_sex_specific_sev_for_low_omega_3')
        self.age_standardized_sev_for_low_omega_3 = kwargs.get('age_standardized_sev_for_low_omega_3')
        self.age_and_sex_specific_sev_for_low_pufa = kwargs.get('age_and_sex_specific_sev_for_low_pufa')
        self.age_standardized_sev_for_low_pufa = kwargs.get('age_standardized_sev_for_low_pufa')
        self.age_and_sex_specific_sev_for_high_trans_fat = kwargs.get('age_and_sex_specific_sev_for_high_trans_fat')
        self.age_standardized_sev_for_high_trans_fat = kwargs.get('age_standardized_sev_for_high_trans_fat')
        self.age_and_sex_specific_sev_for_high_sodium = kwargs.get('age_and_sex_specific_sev_for_high_sodium')
        self.age_standardized_sev_for_high_sodium = kwargs.get('age_standardized_sev_for_high_sodium')
        self.age_and_sex_specific_sev_for_intimate_partner_violence = kwargs.get('age_and_sex_specific_sev_for_intimate_partner_violence')
        self.age_standardized_sev_for_intimate_partner_violence = kwargs.get('age_standardized_sev_for_intimate_partner_violence')
        self.age_and_sex_specific_sev_for_childhood_sexual_abuse = kwargs.get('age_and_sex_specific_sev_for_childhood_sexual_abuse')
        self.age_standardized_sev_for_childhood_sexual_abuse = kwargs.get('age_standardized_sev_for_childhood_sexual_abuse')
        self.age_and_sex_specific_sev_for_bullying = kwargs.get('age_and_sex_specific_sev_for_bullying')
        self.age_standardized_sev_for_bullying = kwargs.get('age_standardized_sev_for_bullying')
        self.age_and_sex_specific_sev_for_unsafe_sex = kwargs.get('age_and_sex_specific_sev_for_unsafe_sex')
        self.age_standardized_sev_for_unsafe_sex = kwargs.get('age_standardized_sev_for_unsafe_sex')
        self.age_and_sex_specific_sev_for_low_physical_activity = kwargs.get('age_and_sex_specific_sev_for_low_physical_activity')
        self.age_standardized_sev_for_low_physical_activity = kwargs.get('age_standardized_sev_for_low_physical_activity')
        self.age_and_sex_specific_sev_for_high_fasting_plasma_glucose = kwargs.get('age_and_sex_specific_sev_for_high_fasting_plasma_glucose')
        self.age_standardized_sev_for_high_fasting_plasma_glucose = kwargs.get('age_standardized_sev_for_high_fasting_plasma_glucose')
        self.age_and_sex_specific_sev_for_high_ldl = kwargs.get('age_and_sex_specific_sev_for_high_ldl')
        self.age_standardized_sev_for_high_ldl = kwargs.get('age_standardized_sev_for_high_ldl')
        self.age_and_sex_specific_sev_for_high_blood_pressure = kwargs.get('age_and_sex_specific_sev_for_high_blood_pressure')
        self.age_standardized_sev_for_high_blood_pressure = kwargs.get('age_standardized_sev_for_high_blood_pressure')
        self.age_and_sex_specific_sev_for_high_body_mass_index = kwargs.get('age_and_sex_specific_sev_for_high_body_mass_index')
        self.age_standardized_sev_for_high_body_mass_index = kwargs.get('age_standardized_sev_for_high_body_mass_index')
        self.age_and_sex_specific_sev_for_low_bone_mineral_density = kwargs.get('age_and_sex_specific_sev_for_low_bone_mineral_density')
        self.age_standardized_sev_for_low_bone_mineral_density = kwargs.get('age_standardized_sev_for_low_bone_mineral_density')
        self.age_and_sex_specific_sev_for_impaired_kidney_function = kwargs.get('age_and_sex_specific_sev_for_impaired_kidney_function')
        self.age_standardized_sev_for_impaired_kidney_function = kwargs.get('age_standardized_sev_for_impaired_kidney_function')
        self.deprecated_log_transformed_age_standardized_sev_scalar_communicable_maternal_neonatal_and_nutritional_diseases_deprecated = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_communicable_maternal_neonatal_and_nutritional_diseases_deprecated')
        self.deprecated_log_transformed_sev_scalar_communicable_maternal_neonatal_and_nutritional_diseases_deprecated = kwargs.get('deprecated_log_transformed_sev_scalar_communicable_maternal_neonatal_and_nutritional_diseases_deprecated')
        self.deprecated_log_transformed_age_standardized_sev_scalar_hiv_aids_extensively_drug_resistant_tuberculosis = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_hiv_aids_extensively_drug_resistant_tuberculosis')
        self.deprecated_log_transformed_sev_scalar_hiv_aids_extensively_drug_resistant_tuberculosis = kwargs.get('deprecated_log_transformed_sev_scalar_hiv_aids_extensively_drug_resistant_tuberculosis')
        self.deprecated_log_transformed_age_standardized_sev_scalar_sexually_transmitted_infections_excluding_hiv = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_sexually_transmitted_infections_excluding_hiv')
        self.deprecated_log_transformed_sev_scalar_sexually_transmitted_infections_excluding_hiv = kwargs.get('deprecated_log_transformed_sev_scalar_sexually_transmitted_infections_excluding_hiv')
        self.deprecated_log_transformed_age_standardized_sev_scalar_extensively_drug_resistant_tuberculosis = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_extensively_drug_resistant_tuberculosis')
        self.deprecated_log_transformed_sev_scalar_extensively_drug_resistant_tuberculosis = kwargs.get('deprecated_log_transformed_sev_scalar_extensively_drug_resistant_tuberculosis')
        self.log_transformed_age_standardized_sev_scalar_obst_labor = kwargs.get('log_transformed_age_standardized_sev_scalar_obst_labor')
        self.log_transformed_sev_scalar_obst_labor = kwargs.get('log_transformed_sev_scalar_obst_labor')
        self.log_transformed_age_standardized_sev_scalar_ectopic_preg = kwargs.get('log_transformed_age_standardized_sev_scalar_ectopic_preg')
        self.log_transformed_sev_scalar_ectopic_preg = kwargs.get('log_transformed_sev_scalar_ectopic_preg')
        self.log_transformed_age_standardized_sev_scalar_neonatal = kwargs.get('log_transformed_age_standardized_sev_scalar_neonatal')
        self.log_transformed_sev_scalar_neonatal = kwargs.get('log_transformed_sev_scalar_neonatal')
        self.log_transformed_age_standardized_sev_scalar_liver_c_nash = kwargs.get('log_transformed_age_standardized_sev_scalar_liver_c_nash')
        self.log_transformed_sev_scalar_liver_c_nash = kwargs.get('log_transformed_sev_scalar_liver_c_nash')
        self.log_transformed_age_standardized_sev_scalar_sub_hem = kwargs.get('log_transformed_age_standardized_sev_scalar_sub_hem')
        self.log_transformed_sev_scalar_sub_hem = kwargs.get('log_transformed_sev_scalar_sub_hem')
        self.log_transformed_age_standardized_sev_scalar_valvular = kwargs.get('log_transformed_age_standardized_sev_scalar_valvular')
        self.log_transformed_sev_scalar_valvular = kwargs.get('log_transformed_sev_scalar_valvular')
        self.log_transformed_age_standardized_sev_scalar_cavd = kwargs.get('log_transformed_age_standardized_sev_scalar_cavd')
        self.log_transformed_sev_scalar_cavd = kwargs.get('log_transformed_sev_scalar_cavd')
        self.log_transformed_age_standardized_sev_scalar_upper_digest = kwargs.get('log_transformed_age_standardized_sev_scalar_upper_digest')
        self.log_transformed_sev_scalar_upper_digest = kwargs.get('log_transformed_sev_scalar_upper_digest')
        self.deprecated_log_transformed_age_standardized_sev_scalar_parkinsons_disease = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_parkinsons_disease')
        self.deprecated_log_transformed_sev_scalar_parkinsons_disease = kwargs.get('deprecated_log_transformed_sev_scalar_parkinsons_disease')
        self.deprecated_log_transformed_age_standardized_sev_scalar_drug_use_disorders = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_drug_use_disorders')
        self.deprecated_log_transformed_sev_scalar_drug_use_disorders = kwargs.get('deprecated_log_transformed_sev_scalar_drug_use_disorders')
        self.log_transformed_age_standardized_sev_scalar_blindness = kwargs.get('log_transformed_age_standardized_sev_scalar_blindness')
        self.log_transformed_sev_scalar_blindness = kwargs.get('log_transformed_sev_scalar_blindness')
        self.deprecated_log_transformed_age_standardized_sev_scalar_injuries = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_injuries')
        self.deprecated_log_transformed_sev_scalar_injuries = kwargs.get('deprecated_log_transformed_sev_scalar_injuries')
        self.log_transformed_age_standardized_sev_scalar_inj_pois_co = kwargs.get('log_transformed_age_standardized_sev_scalar_inj_pois_co')
        self.log_transformed_sev_scalar_inj_pois_co = kwargs.get('log_transformed_sev_scalar_inj_pois_co')
        self.log_transformed_age_standardized_sev_scalar_inj_pois_oth = kwargs.get('log_transformed_age_standardized_sev_scalar_inj_pois_oth')
        self.log_transformed_sev_scalar_inj_pois_oth = kwargs.get('log_transformed_sev_scalar_inj_pois_oth')
        self.log_transformed_age_standardized_sev_scalar_heat__and_up_cold = kwargs.get('log_transformed_age_standardized_sev_scalar_heat__and_up_cold')
        self.log_transformed_sev_scalar_heat__and_up_cold = kwargs.get('log_transformed_sev_scalar_heat__and_up_cold')
        self.deprecated_log_transformed_age_standardized_sev_scalar_sexual_violence = kwargs.get('deprecated_log_transformed_age_standardized_sev_scalar_sexual_violence')
        self.deprecated_log_transformed_sev_scalar_sexual_violence = kwargs.get('deprecated_log_transformed_sev_scalar_sexual_violence')
        self.log_transformed_age_standardized_sev_scalar_mat_htn = kwargs.get('log_transformed_age_standardized_sev_scalar_mat_htn')
        self.log_transformed_age_standardized_sev_scalar_mat_indir = kwargs.get('log_transformed_age_standardized_sev_scalar_mat_indir')
        self.log_transformed_age_standardized_sev_scalar_mat_late = kwargs.get('log_transformed_age_standardized_sev_scalar_mat_late')
        self.log_transformed_age_standardized_sev_scalar_oth_mat = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_mat')
        self.log_transformed_age_standardized_sev_scalar_ncd = kwargs.get('log_transformed_age_standardized_sev_scalar_ncd')
        self.log_transformed_age_standardized_sev_scalar_anxiety = kwargs.get('log_transformed_age_standardized_sev_scalar_anxiety')
        self.log_transformed_age_standardized_sev_scalar_disaster = kwargs.get('log_transformed_age_standardized_sev_scalar_disaster')
        self.log_transformed_age_standardized_sev_scalar_mat_hiv = kwargs.get('log_transformed_age_standardized_sev_scalar_mat_hiv')
        self.log_transformed_age_standardized_sev_scalar_mat_abort = kwargs.get('log_transformed_age_standardized_sev_scalar_mat_abort')
        self.log_transformed_sev_scalar_mat_abort = kwargs.get('log_transformed_sev_scalar_mat_abort')
        self.proportion_of_the_population_with_0_years_of_education = kwargs.get('proportion_of_the_population_with_0_years_of_education')
        self.proportion_of_the_population_with_0_years_of_education_maternal = kwargs.get('proportion_of_the_population_with_0_years_of_education_maternal')
        self.proportion_of_the_population_with_0_years_of_education_age_standardized = kwargs.get('proportion_of_the_population_with_0_years_of_education_age_standardized')
        self.stillbirth_to_live_birth_ratio = kwargs.get('stillbirth_to_live_birth_ratio')
        self.proportion_pnn_pop_aged_1_5_mo = kwargs.get('proportion_pnn_pop_aged_1_5_mo')
        self.proportion_1_4_pop_aged_1_year = kwargs.get('proportion_1_4_pop_aged_1_year')
        self.gallup_negative_experience_index = kwargs.get('gallup_negative_experience_index')
        self.hemoglobin_c_sickle_type_c_trait = kwargs.get('hemoglobin_c_sickle_type_c_trait')
        self.hemoglobin_s_sickle_type_s_trait = kwargs.get('hemoglobin_s_sickle_type_s_trait')
        self.non_steroidal_anti_inflammatory_drug_nsaid_use = kwargs.get('non_steroidal_anti_inflammatory_drug_nsaid_use')
        self.proton_pump_inhibitor_ppi_use = kwargs.get('proton_pump_inhibitor_ppi_use')
        self.direct_antivirals_das_for_hcv = kwargs.get('direct_antivirals_das_for_hcv')
        self.proportion_of_the_population_working_in_mining_with_20_year_lag = kwargs.get('proportion_of_the_population_working_in_mining_with_20_year_lag')
        self.gold_production_kg_per_capita_smoothed_with_20_year_lag = kwargs.get('gold_production_kg_per_capita_smoothed_with_20_year_lag')
        self.diabetes_fasting_plasma_glucose_mmol_l_by_age = kwargs.get('diabetes_fasting_plasma_glucose_mmol_l_by_age')
        self.hepatitis_b_seroprevalence_hbsag_lagged_over_time = kwargs.get('hepatitis_b_seroprevalence_hbsag_lagged_over_time')
        self.hepatitis_c_seroprevalence_anti_hcv_lagged_over_time = kwargs.get('hepatitis_c_seroprevalence_anti_hcv_lagged_over_time')
        self.hepatitis_a_seroprevalence_anti_hav_age_standardized = kwargs.get('hepatitis_a_seroprevalence_anti_hav_age_standardized')
        self.hepatitis_b_seroprevalence_hbsag_age_standardized = kwargs.get('hepatitis_b_seroprevalence_hbsag_age_standardized')
        self.hepatitis_c_seroprevalence_anti_hcv_age_standardized = kwargs.get('hepatitis_c_seroprevalence_anti_hcv_age_standardized')
        self.hepatitis_e_seroprevalence_anti_hev_age_standardized = kwargs.get('hepatitis_e_seroprevalence_anti_hev_age_standardized')
        self.hpv1_coverage_proportion = kwargs.get('hpv1_coverage_proportion')
        self.bac_law_general_population_quartile = kwargs.get('bac_law_general_population_quartile')
        self.bac_law_youth_drivers_quartile = kwargs.get('bac_law_youth_drivers_quartile')
        self.bac_law_professional_drivers_quartile = kwargs.get('bac_law_professional_drivers_quartile')
        self.speed_limit_law_urban_quartile = kwargs.get('speed_limit_law_urban_quartile')
        self.speed_limit_law_rural_quartile = kwargs.get('speed_limit_law_rural_quartile')
        self.speed_limit_law_highways_quartile = kwargs.get('speed_limit_law_highways_quartile')
        self.seat_belt_frequency__percent = kwargs.get('seat_belt_frequency__percent')
        self.menafrivac_campaign_ever_never = kwargs.get('menafrivac_campaign_ever_never')
        self.time_since_last_mass_menafrivac_campaign = kwargs.get('time_since_last_mass_menafrivac_campaign')
        self.time_since_any_menafrivac_campaign = kwargs.get('time_since_any_menafrivac_campaign')
        self.liters_of_alcohol_consumed_per_capita = kwargs.get('liters_of_alcohol_consumed_per_capita')
        self.live_births_by_childs_sex_and_maternal_age = kwargs.get('live_births_by_childs_sex_and_maternal_age')
        self.twelve__month_non_partner_sexual_violence = kwargs.get('twelve__month_non_partner_sexual_violence')
        self.population_15_to_30_males_proportion = kwargs.get('population_15_to_30_males_proportion')
        self.max_trachoma_population_at_risk = kwargs.get('max_trachoma_population_at_risk')
        self.schistosomiasis_prevalence_for_gbd_2019_cod_testing = kwargs.get('schistosomiasis_prevalence_for_gbd_2019_cod_testing')
        self.schistosomiasis_prevalence_results = kwargs.get('schistosomiasis_prevalence_results')
        self.who_sth_mda_coverage = kwargs.get('who_sth_mda_coverage')
        self.cystic_echinococcosis_endemicity_level = kwargs.get('cystic_echinococcosis_endemicity_level')
        self.bcg_lagged_five_year_coverage_proportion = kwargs.get('bcg_lagged_five_year_coverage_proportion')
        self.dtp3_lagged_five_year_coverage_proportion = kwargs.get('dtp3_lagged_five_year_coverage_proportion')
        self.mcv1_lagged_five_year_coverage_proportion = kwargs.get('mcv1_lagged_five_year_coverage_proportion')
        self.mcv2_lagged_five_year_coverage_proportion = kwargs.get('mcv2_lagged_five_year_coverage_proportion')
        self.polio3_lagged_five_year_coverage_proportion = kwargs.get('polio3_lagged_five_year_coverage_proportion')
        self.rcv1_lagged_five_year_coverage_proportion = kwargs.get('rcv1_lagged_five_year_coverage_proportion')
        self.hib3_lagged_five_year_coverage_proportion = kwargs.get('hib3_lagged_five_year_coverage_proportion')
        self.pcv3_lagged_five_year_coverage_proportion = kwargs.get('pcv3_lagged_five_year_coverage_proportion')
        self.rotac_lagged_five_year_coverage_proportion = kwargs.get('rotac_lagged_five_year_coverage_proportion')
        self.hepb3_lagged_five_year_coverage_proportion = kwargs.get('hepb3_lagged_five_year_coverage_proportion')
        self.vitamin_a_supplementation_age_specific = kwargs.get('vitamin_a_supplementation_age_specific')
        self.proportion_of_population_vulnerable_to_venomous_snakebites = kwargs.get('proportion_of_population_vulnerable_to_venomous_snakebites')
        self.inj_time = kwargs.get('inj_time')
        self.mean_number_of_venomous_snake_species = kwargs.get('mean_number_of_venomous_snake_species')
        self.tfr_u20_us_r_e = kwargs.get('tfr_u20_us_r_e')
        self.dengue_all_age_csmr = kwargs.get('dengue_all_age_csmr')
        self.education_years_per_capita_aggregated_by_age_15_and_up_and_sex_us_r_e = kwargs.get('education_years_per_capita_aggregated_by_age_15_and_up_and_sex_us_r_e')
        self.age_and_sex_specific_sev_for_high_temperature = kwargs.get('age_and_sex_specific_sev_for_high_temperature')
        self.age_and_sex_specific_sev_for_low_temperature = kwargs.get('age_and_sex_specific_sev_for_low_temperature')
        self.age_standardized_sev_for_high_temperature = kwargs.get('age_standardized_sev_for_high_temperature')
        self.age_standardized_sev_for_low_temperature = kwargs.get('age_standardized_sev_for_low_temperature')
        self.hpv2_coverage_proportion = kwargs.get('hpv2_coverage_proportion')
        self.inpatient_utilization_envelope = kwargs.get('inpatient_utilization_envelope')
        self.opioid_substitution_therapy_ost_treatment_coverage = kwargs.get('opioid_substitution_therapy_ost_treatment_coverage')
        self.government_spending_on_health = kwargs.get('government_spending_on_health')
        self.liters_of_alcohol_consumed_per_capita_by_age_and_sex = kwargs.get('liters_of_alcohol_consumed_per_capita_by_age_and_sex')
        self.total_government_spending = kwargs.get('total_government_spending')
        self.chronic_hepatitis_c_age_standardized = kwargs.get('chronic_hepatitis_c_age_standardized')
        self.high_risk_menafrivac_coverage_proportion = kwargs.get('high_risk_menafrivac_coverage_proportion')
        self.vaccine_adjusted_hbsag_serporevalence_age_standardized = kwargs.get('vaccine_adjusted_hbsag_serporevalence_age_standardized')
        self.solar_radiation_downwards = kwargs.get('solar_radiation_downwards')
        self.hib3_transformed_population_level_coverage_including_indirect_effects_proportion = kwargs.get('hib3_transformed_population_level_coverage_including_indirect_effects_proportion')
        self.age_standardized_daily_smoking_prevalence_both_sexes = kwargs.get('age_standardized_daily_smoking_prevalence_both_sexes')
        self.log_transformed_sev_scalar_oth_cirr = kwargs.get('log_transformed_sev_scalar_oth_cirr')
        self.log_transformed_age_standardized_sev_scalar_oth_cirr = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_cirr')
        self.log_transformed_sev_scalar_burkitt = kwargs.get('log_transformed_sev_scalar_burkitt')
        self.log_transformed_age_standardized_sev_scalar_burkitt = kwargs.get('log_transformed_age_standardized_sev_scalar_burkitt')
        self.log_transformed_sev_scalar_oth_lymphoma = kwargs.get('log_transformed_sev_scalar_oth_lymphoma')
        self.log_transformed_age_standardized_sev_scalar_oth_lymphoma = kwargs.get('log_transformed_age_standardized_sev_scalar_oth_lymphoma')
        self.log_transformed_sev_scalar_osteoarth_hip = kwargs.get('log_transformed_sev_scalar_osteoarth_hip')
        self.log_transformed_age_standardized_sev_scalar_osteoarth_hip = kwargs.get('log_transformed_age_standardized_sev_scalar_osteoarth_hip')
        self.log_transformed_sev_scalar_osteoarth_knee = kwargs.get('log_transformed_sev_scalar_osteoarth_knee')
        self.log_transformed_age_standardized_sev_scalar_osteoarth_knee = kwargs.get('log_transformed_age_standardized_sev_scalar_osteoarth_knee')
        self.ascariasis_prevalence = kwargs.get('ascariasis_prevalence')
        self.custom_age_standardized_and_sex_specific_sev_for_alcohol_use = kwargs.get('custom_age_standardized_and_sex_specific_sev_for_alcohol_use')
        self._overweight_women_of_reproductive_age = kwargs.get('_overweight_women_of_reproductive_age')
        self.sheep_density = kwargs.get('sheep_density')
        self.leprosy_mb_cure_rate = kwargs.get('leprosy_mb_cure_rate')
        self.proportion_of_mb_pb_cases_in_leprosy_population = kwargs.get('proportion_of_mb_pb_cases_in_leprosy_population')
