"""Mapping templates for GBD causes.

This code is automatically generated by gbd_mapping_generator/cause_builder.py

Any manual changes will be lost.
"""
from typing import Union, Tuple

from .id import c_id, me_id, _Unknown
from .base_template import Restrictions, ModelableEntity, GbdRecord
from .sequela_template import Sequela
from .etiology_template import Etiology


class Cause(ModelableEntity):
    """Container for cause GBD ids and metadata"""
    __slots__ = ('name', 'kind', 'gbd_id', 'me_id', 'most_detailed', 'level', 'restrictions', 'parent', 'sub_causes',
                 'sequelae', 'etiologies', )

    def __init__(self,
                 name: str,
                 kind: str,
                 gbd_id: c_id,
                 me_id: Union[me_id, _Unknown],
                 most_detailed: bool,
                 level: int,
                 restrictions: Restrictions,
                 parent: "Cause" = None,
                 sub_causes: Tuple["Cause", ...] = None,
                 sequelae: Tuple[Sequela, ...] = None,
                 etiologies: Tuple[Etiology, ...] = None, ):
        super().__init__(name=name,
                         kind=kind,
                         gbd_id=gbd_id)
        self.name = name
        self.kind = kind
        self.gbd_id = gbd_id
        self.me_id = me_id
        self.most_detailed = most_detailed
        self.level = level
        self.restrictions = restrictions
        self.parent = parent
        self.sub_causes = sub_causes
        self.sequelae = sequelae
        self.etiologies = etiologies


class Causes(GbdRecord):
    """Container for GBD causes."""
    __slots__ = ('all_causes', 'communicable_maternal_neonatal_and_nutritional_diseases', 'tuberculosis', 'hiv_aids',
                 'hiv_aids_resulting_in_other_diseases', 'diarrheal_diseases', 'typhoid_fever', 'paratyphoid_fever',
                 'other_intestinal_infectious_diseases', 'lower_respiratory_infections',
                 'upper_respiratory_infections', 'otitis_media', 'meningitis', 'encephalitis', 'diphtheria',
                 'whooping_cough', 'tetanus', 'measles', 'varicella_and_herpes_zoster',
                 'neglected_tropical_diseases_and_malaria', 'malaria', 'chagas_disease', 'leishmaniasis',
                 'visceral_leishmaniasis', 'cutaneous_and_mucocutaneous_leishmaniasis', 'african_trypanosomiasis',
                 'schistosomiasis', 'cysticercosis', 'cystic_echinococcosis', 'lymphatic_filariasis',
                 'onchocerciasis', 'trachoma', 'dengue', 'yellow_fever', 'rabies', 'intestinal_nematode_infections',
                 'ascariasis', 'trichuriasis', 'hookworm_disease', 'food_borne_trematodiases',
                 'other_neglected_tropical_diseases', 'maternal_disorders', 'maternal_hemorrhage',
                 'maternal_sepsis_and_other_maternal_infections', 'maternal_hypertensive_disorders',
                 'maternal_obstructed_labor_and_uterine_rupture', 'ectopic_pregnancy', 'indirect_maternal_deaths',
                 'late_maternal_deaths', 'other_maternal_disorders', 'neonatal_disorders', 'neonatal_preterm_birth',
                 'neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
                 'neonatal_sepsis_and_other_neonatal_infections', 'hemolytic_disease_and_other_neonatal_jaundice',
                 'other_neonatal_disorders', 'nutritional_deficiencies', 'protein_energy_malnutrition',
                 'iodine_deficiency', 'vitamin_a_deficiency', 'dietary_iron_deficiency',
                 'other_nutritional_deficiencies', 'sexually_transmitted_infections_excluding_hiv', 'syphilis',
                 'chlamydial_infection', 'gonococcal_infection', 'trichomoniasis', 'genital_herpes',
                 'other_sexually_transmitted_infections', 'acute_hepatitis', 'acute_hepatitis_a',
                 'acute_hepatitis_b', 'acute_hepatitis_c', 'acute_hepatitis_e', 'leprosy',
                 'other_unspecified_infectious_diseases', 'non_communicable_diseases', 'neoplasms',
                 'esophageal_cancer', 'stomach_cancer', 'liver_cancer', 'liver_cancer_due_to_hepatitis_b',
                 'liver_cancer_due_to_hepatitis_c', 'liver_cancer_due_to_alcohol_use', 'larynx_cancer',
                 'tracheal_bronchus_and_lung_cancer', 'breast_cancer', 'cervical_cancer', 'uterine_cancer',
                 'prostate_cancer', 'colon_and_rectum_cancer', 'lip_and_oral_cavity_cancer', 'nasopharynx_cancer',
                 'other_pharynx_cancer', 'gallbladder_and_biliary_tract_cancer', 'pancreatic_cancer',
                 'malignant_skin_melanoma', 'non_melanoma_skin_cancer', 'ovarian_cancer', 'testicular_cancer',
                 'kidney_cancer', 'bladder_cancer', 'brain_and_central_nervous_system_cancer', 'thyroid_cancer',
                 'mesothelioma', 'hodgkin_lymphoma', 'non_hodgkin_lymphoma', 'multiple_myeloma', 'leukemia',
                 'other_neoplasms', 'cardiovascular_diseases', 'rheumatic_heart_disease', 'ischemic_heart_disease',
                 'stroke', 'ischemic_stroke', 'intracerebral_hemorrhage', 'subarachnoid_hemorrhage',
                 'hypertensive_heart_disease', 'cardiomyopathy_and_myocarditis', 'atrial_fibrillation_and_flutter',
                 'aortic_aneurysm', 'peripheral_artery_disease', 'endocarditis',
                 'non_rheumatic_valvular_heart_disease', 'chronic_respiratory_diseases',
                 'chronic_obstructive_pulmonary_disease', 'pneumoconiosis', 'silicosis', 'asbestosis',
                 'coal_workers_pneumoconiosis', 'other_pneumoconiosis', 'asthma',
                 'interstitial_lung_disease_and_pulmonary_sarcoidosis', 'other_chronic_respiratory_diseases',
                 'cirrhosis_and_other_chronic_liver_diseases',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_use',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_other_causes', 'digestive_diseases',
                 'peptic_ulcer_disease', 'gastritis_and_duodenitis', 'appendicitis',
                 'paralytic_ileus_and_intestinal_obstruction', 'inguinal_femoral_and_abdominal_hernia',
                 'inflammatory_bowel_disease', 'vascular_intestinal_disorders', 'gallbladder_and_biliary_diseases',
                 'pancreatitis', 'gastroesophageal_reflux_disease', 'other_digestive_diseases',
                 'neurological_disorders', 'alzheimers_disease_and_other_dementias', 'parkinsons_disease',
                 'idiopathic_epilepsy', 'multiple_sclerosis', 'migraine', 'tension_type_headache',
                 'motor_neuron_disease', 'other_neurological_disorders', 'mental_disorders', 'schizophrenia',
                 'alcohol_use_disorders', 'drug_use_disorders', 'opioid_use_disorders', 'cocaine_use_disorders',
                 'amphetamine_use_disorders', 'cannabis_use_disorders', 'other_drug_use_disorders',
                 'depressive_disorders', 'major_depressive_disorder', 'dysthymia', 'bipolar_disorder',
                 'anxiety_disorders', 'eating_disorders', 'anorexia_nervosa', 'bulimia_nervosa',
                 'autism_spectrum_disorders', 'attention_deficit_hyperactivity_disorder', 'conduct_disorder',
                 'idiopathic_developmental_intellectual_disability', 'other_mental_disorders', 'diabetes_mellitus',
                 'acute_glomerulonephritis', 'chronic_kidney_disease', 'chronic_kidney_disease_due_to_hypertension',
                 'chronic_kidney_disease_due_to_glomerulonephritis',
                 'chronic_kidney_disease_due_to_other_and_unspecified_causes',
                 'urinary_diseases_and_male_infertility', 'urinary_tract_infections_and_interstitial_nephritis',
                 'urolithiasis', 'benign_prostatic_hyperplasia', 'male_infertility', 'other_urinary_diseases',
                 'gynecological_diseases', 'uterine_fibroids', 'polycystic_ovarian_syndrome', 'female_infertility',
                 'endometriosis', 'genital_prolapse', 'premenstrual_syndrome', 'other_gynecological_diseases',
                 'hemoglobinopathies_and_hemolytic_anemias', 'thalassemias', 'sickle_cell_disorders',
                 'g6pd_deficiency', 'other_hemoglobinopathies_and_hemolytic_anemias',
                 'endocrine_metabolic_blood_and_immune_disorders', 'musculoskeletal_disorders',
                 'rheumatoid_arthritis', 'osteoarthritis', 'low_back_pain', 'neck_pain', 'gout',
                 'other_musculoskeletal_disorders', 'other_non_communicable_diseases', 'congenital_birth_defects',
                 'neural_tube_defects', 'congenital_heart_anomalies', 'orofacial_clefts', 'down_syndrome',
                 'turner_syndrome', 'klinefelter_syndrome', 'other_chromosomal_abnormalities',
                 'congenital_musculoskeletal_and_limb_anomalies', 'urogenital_congenital_anomalies',
                 'digestive_congenital_anomalies', 'other_congenital_birth_defects',
                 'skin_and_subcutaneous_diseases', 'dermatitis', 'psoriasis', 'cellulitis', 'pyoderma', 'scabies',
                 'fungal_skin_diseases', 'viral_skin_diseases', 'acne_vulgaris', 'alopecia_areata', 'pruritus',
                 'urticaria', 'decubitus_ulcer', 'other_skin_and_subcutaneous_diseases', 'sense_organ_diseases',
                 'glaucoma', 'cataract', 'age_related_macular_degeneration', 'age_related_and_other_hearing_loss',
                 'other_vision_loss', 'other_sense_organ_diseases', 'oral_disorders', 'caries_of_deciduous_teeth',
                 'caries_of_permanent_teeth', 'periodontal_diseases', 'edentulism', 'other_oral_disorders',
                 'sudden_infant_death_syndrome', 'injuries', 'transport_injuries', 'road_injuries',
                 'pedestrian_road_injuries', 'cyclist_road_injuries', 'motorcyclist_road_injuries',
                 'motor_vehicle_road_injuries', 'other_road_injuries', 'other_transport_injuries',
                 'unintentional_injuries', 'falls', 'drowning', 'fire_heat_and_hot_substances', 'poisonings',
                 'poisoning_by_carbon_monoxide', 'poisoning_by_other_means', 'exposure_to_mechanical_forces',
                 'unintentional_firearm_injuries', 'other_exposure_to_mechanical_forces',
                 'adverse_effects_of_medical_treatment', 'animal_contact', 'venomous_animal_contact',
                 'non_venomous_animal_contact', 'foreign_body', 'pulmonary_aspiration_and_foreign_body_in_airway',
                 'foreign_body_in_eyes', 'foreign_body_in_other_body_part', 'other_unintentional_injuries',
                 'self_harm_and_interpersonal_violence', 'self_harm', 'self_harm_by_firearm',
                 'self_harm_by_other_specified_means', 'interpersonal_violence', 'physical_violence_by_firearm',
                 'physical_violence_by_sharp_object', 'physical_violence_by_other_means',
                 'exposure_to_forces_of_nature', 'maternal_deaths_aggravated_by_hiv_aids', 'thalassemias_trait',
                 'sickle_cell_trait', 'g6pd_trait', 'environmental_heat_and_cold_exposure', 'ebola',
                 'acute_lymphoid_leukemia', 'chronic_lymphoid_leukemia', 'acute_myeloid_leukemia',
                 'chronic_myeloid_leukemia', 'non_melanoma_skin_cancer_squamous_cell_carcinoma',
                 'non_melanoma_skin_cancer_basal_cell_carcinoma', 'executions_and_police_conflict',
                 'drug_susceptible_tuberculosis', 'zika_virus', 'guinea_worm_disease', 'alcoholic_cardiomyopathy',
                 'sexual_violence', 'myocarditis', 'other_leukemia', 'other_cardiomyopathy',
                 'conflict_and_terrorism', 'multidrug_resistant_tuberculosis_without_extensive_drug_resistance',
                 'extensively_drug_resistant_tuberculosis', 'hiv_aids_drug_susceptible_tuberculosis',
                 'hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance',
                 'hiv_aids_extensively_drug_resistant_tuberculosis', 'latent_tuberculosis_infection',
                 'hiv_aids_and_sexually_transmitted_infections', 'respiratory_infections_and_tuberculosis',
                 'enteric_infections', 'typhoid_and_paratyphoid', 'invasive_non_typhoidal_salmonella_ints',
                 'other_infectious_diseases', 'maternal_and_neonatal_disorders',
                 'myelodysplastic_myeloproliferative_and_other_hematopoietic_neoplasms',
                 'benign_and_in_situ_intestinal_neoplasms', 'benign_and_in_situ_cervical_and_uterine_neoplasms',
                 'other_benign_and_in_situ_neoplasms', 'non_rheumatic_calcific_aortic_valve_disease',
                 'non_rheumatic_degenerative_mitral_valve_disease', 'other_non_rheumatic_valve_diseases',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_nafld', 'headache_disorders',
                 'substance_use_disorders', 'diabetes_and_kidney_diseases', 'diabetes_mellitus_type_1',
                 'diabetes_mellitus_type_2', 'atopic_dermatitis', 'contact_dermatitis', 'seborrhoeic_dermatitis',
                 'bacterial_skin_diseases', 'blindness_and_vision_loss', 'upper_digestive_system_diseases',
                 'maternal_abortion_and_miscarriage', 'liver_cancer_due_to_nash',
                 'chronic_kidney_disease_due_to_diabetes_mellitus_type_1',
                 'chronic_kidney_disease_due_to_diabetes_mellitus_type_2', 'refraction_disorders',
                 'near_vision_loss', 'osteoarthritis_hip', 'osteoarthritis_knee', 'osteoarthritis_hand',
                 'osteoarthritis_other', 'liver_cancer_due_to_other_causes', 'other_malignant_neoplasms',
                 'other_cardiovascular_and_circulatory_diseases', 'total_burden_related_to_hepatitis_b',
                 'total_burden_related_to_hepatitis_c',
                 'total_burden_related_to_non_alcoholic_fatty_liver_disease_nafld', 'total_cancers', )

    def __init__(self, **kwargs):
        super().__init__()
        self.all_causes = kwargs.get('all_causes')
        self.communicable_maternal_neonatal_and_nutritional_diseases = kwargs.get('communicable_maternal_neonatal_and_nutritional_diseases')
        self.tuberculosis = kwargs.get('tuberculosis')
        self.hiv_aids = kwargs.get('hiv_aids')
        self.hiv_aids_resulting_in_other_diseases = kwargs.get('hiv_aids_resulting_in_other_diseases')
        self.diarrheal_diseases = kwargs.get('diarrheal_diseases')
        self.typhoid_fever = kwargs.get('typhoid_fever')
        self.paratyphoid_fever = kwargs.get('paratyphoid_fever')
        self.other_intestinal_infectious_diseases = kwargs.get('other_intestinal_infectious_diseases')
        self.lower_respiratory_infections = kwargs.get('lower_respiratory_infections')
        self.upper_respiratory_infections = kwargs.get('upper_respiratory_infections')
        self.otitis_media = kwargs.get('otitis_media')
        self.meningitis = kwargs.get('meningitis')
        self.encephalitis = kwargs.get('encephalitis')
        self.diphtheria = kwargs.get('diphtheria')
        self.whooping_cough = kwargs.get('whooping_cough')
        self.tetanus = kwargs.get('tetanus')
        self.measles = kwargs.get('measles')
        self.varicella_and_herpes_zoster = kwargs.get('varicella_and_herpes_zoster')
        self.neglected_tropical_diseases_and_malaria = kwargs.get('neglected_tropical_diseases_and_malaria')
        self.malaria = kwargs.get('malaria')
        self.chagas_disease = kwargs.get('chagas_disease')
        self.leishmaniasis = kwargs.get('leishmaniasis')
        self.visceral_leishmaniasis = kwargs.get('visceral_leishmaniasis')
        self.cutaneous_and_mucocutaneous_leishmaniasis = kwargs.get('cutaneous_and_mucocutaneous_leishmaniasis')
        self.african_trypanosomiasis = kwargs.get('african_trypanosomiasis')
        self.schistosomiasis = kwargs.get('schistosomiasis')
        self.cysticercosis = kwargs.get('cysticercosis')
        self.cystic_echinococcosis = kwargs.get('cystic_echinococcosis')
        self.lymphatic_filariasis = kwargs.get('lymphatic_filariasis')
        self.onchocerciasis = kwargs.get('onchocerciasis')
        self.trachoma = kwargs.get('trachoma')
        self.dengue = kwargs.get('dengue')
        self.yellow_fever = kwargs.get('yellow_fever')
        self.rabies = kwargs.get('rabies')
        self.intestinal_nematode_infections = kwargs.get('intestinal_nematode_infections')
        self.ascariasis = kwargs.get('ascariasis')
        self.trichuriasis = kwargs.get('trichuriasis')
        self.hookworm_disease = kwargs.get('hookworm_disease')
        self.food_borne_trematodiases = kwargs.get('food_borne_trematodiases')
        self.other_neglected_tropical_diseases = kwargs.get('other_neglected_tropical_diseases')
        self.maternal_disorders = kwargs.get('maternal_disorders')
        self.maternal_hemorrhage = kwargs.get('maternal_hemorrhage')
        self.maternal_sepsis_and_other_maternal_infections = kwargs.get('maternal_sepsis_and_other_maternal_infections')
        self.maternal_hypertensive_disorders = kwargs.get('maternal_hypertensive_disorders')
        self.maternal_obstructed_labor_and_uterine_rupture = kwargs.get('maternal_obstructed_labor_and_uterine_rupture')
        self.ectopic_pregnancy = kwargs.get('ectopic_pregnancy')
        self.indirect_maternal_deaths = kwargs.get('indirect_maternal_deaths')
        self.late_maternal_deaths = kwargs.get('late_maternal_deaths')
        self.other_maternal_disorders = kwargs.get('other_maternal_disorders')
        self.neonatal_disorders = kwargs.get('neonatal_disorders')
        self.neonatal_preterm_birth = kwargs.get('neonatal_preterm_birth')
        self.neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma = kwargs.get('neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma')
        self.neonatal_sepsis_and_other_neonatal_infections = kwargs.get('neonatal_sepsis_and_other_neonatal_infections')
        self.hemolytic_disease_and_other_neonatal_jaundice = kwargs.get('hemolytic_disease_and_other_neonatal_jaundice')
        self.other_neonatal_disorders = kwargs.get('other_neonatal_disorders')
        self.nutritional_deficiencies = kwargs.get('nutritional_deficiencies')
        self.protein_energy_malnutrition = kwargs.get('protein_energy_malnutrition')
        self.iodine_deficiency = kwargs.get('iodine_deficiency')
        self.vitamin_a_deficiency = kwargs.get('vitamin_a_deficiency')
        self.dietary_iron_deficiency = kwargs.get('dietary_iron_deficiency')
        self.other_nutritional_deficiencies = kwargs.get('other_nutritional_deficiencies')
        self.sexually_transmitted_infections_excluding_hiv = kwargs.get('sexually_transmitted_infections_excluding_hiv')
        self.syphilis = kwargs.get('syphilis')
        self.chlamydial_infection = kwargs.get('chlamydial_infection')
        self.gonococcal_infection = kwargs.get('gonococcal_infection')
        self.trichomoniasis = kwargs.get('trichomoniasis')
        self.genital_herpes = kwargs.get('genital_herpes')
        self.other_sexually_transmitted_infections = kwargs.get('other_sexually_transmitted_infections')
        self.acute_hepatitis = kwargs.get('acute_hepatitis')
        self.acute_hepatitis_a = kwargs.get('acute_hepatitis_a')
        self.acute_hepatitis_b = kwargs.get('acute_hepatitis_b')
        self.acute_hepatitis_c = kwargs.get('acute_hepatitis_c')
        self.acute_hepatitis_e = kwargs.get('acute_hepatitis_e')
        self.leprosy = kwargs.get('leprosy')
        self.other_unspecified_infectious_diseases = kwargs.get('other_unspecified_infectious_diseases')
        self.non_communicable_diseases = kwargs.get('non_communicable_diseases')
        self.neoplasms = kwargs.get('neoplasms')
        self.esophageal_cancer = kwargs.get('esophageal_cancer')
        self.stomach_cancer = kwargs.get('stomach_cancer')
        self.liver_cancer = kwargs.get('liver_cancer')
        self.liver_cancer_due_to_hepatitis_b = kwargs.get('liver_cancer_due_to_hepatitis_b')
        self.liver_cancer_due_to_hepatitis_c = kwargs.get('liver_cancer_due_to_hepatitis_c')
        self.liver_cancer_due_to_alcohol_use = kwargs.get('liver_cancer_due_to_alcohol_use')
        self.larynx_cancer = kwargs.get('larynx_cancer')
        self.tracheal_bronchus_and_lung_cancer = kwargs.get('tracheal_bronchus_and_lung_cancer')
        self.breast_cancer = kwargs.get('breast_cancer')
        self.cervical_cancer = kwargs.get('cervical_cancer')
        self.uterine_cancer = kwargs.get('uterine_cancer')
        self.prostate_cancer = kwargs.get('prostate_cancer')
        self.colon_and_rectum_cancer = kwargs.get('colon_and_rectum_cancer')
        self.lip_and_oral_cavity_cancer = kwargs.get('lip_and_oral_cavity_cancer')
        self.nasopharynx_cancer = kwargs.get('nasopharynx_cancer')
        self.other_pharynx_cancer = kwargs.get('other_pharynx_cancer')
        self.gallbladder_and_biliary_tract_cancer = kwargs.get('gallbladder_and_biliary_tract_cancer')
        self.pancreatic_cancer = kwargs.get('pancreatic_cancer')
        self.malignant_skin_melanoma = kwargs.get('malignant_skin_melanoma')
        self.non_melanoma_skin_cancer = kwargs.get('non_melanoma_skin_cancer')
        self.ovarian_cancer = kwargs.get('ovarian_cancer')
        self.testicular_cancer = kwargs.get('testicular_cancer')
        self.kidney_cancer = kwargs.get('kidney_cancer')
        self.bladder_cancer = kwargs.get('bladder_cancer')
        self.brain_and_central_nervous_system_cancer = kwargs.get('brain_and_central_nervous_system_cancer')
        self.thyroid_cancer = kwargs.get('thyroid_cancer')
        self.mesothelioma = kwargs.get('mesothelioma')
        self.hodgkin_lymphoma = kwargs.get('hodgkin_lymphoma')
        self.non_hodgkin_lymphoma = kwargs.get('non_hodgkin_lymphoma')
        self.multiple_myeloma = kwargs.get('multiple_myeloma')
        self.leukemia = kwargs.get('leukemia')
        self.other_neoplasms = kwargs.get('other_neoplasms')
        self.cardiovascular_diseases = kwargs.get('cardiovascular_diseases')
        self.rheumatic_heart_disease = kwargs.get('rheumatic_heart_disease')
        self.ischemic_heart_disease = kwargs.get('ischemic_heart_disease')
        self.stroke = kwargs.get('stroke')
        self.ischemic_stroke = kwargs.get('ischemic_stroke')
        self.intracerebral_hemorrhage = kwargs.get('intracerebral_hemorrhage')
        self.subarachnoid_hemorrhage = kwargs.get('subarachnoid_hemorrhage')
        self.hypertensive_heart_disease = kwargs.get('hypertensive_heart_disease')
        self.cardiomyopathy_and_myocarditis = kwargs.get('cardiomyopathy_and_myocarditis')
        self.atrial_fibrillation_and_flutter = kwargs.get('atrial_fibrillation_and_flutter')
        self.aortic_aneurysm = kwargs.get('aortic_aneurysm')
        self.peripheral_artery_disease = kwargs.get('peripheral_artery_disease')
        self.endocarditis = kwargs.get('endocarditis')
        self.non_rheumatic_valvular_heart_disease = kwargs.get('non_rheumatic_valvular_heart_disease')
        self.chronic_respiratory_diseases = kwargs.get('chronic_respiratory_diseases')
        self.chronic_obstructive_pulmonary_disease = kwargs.get('chronic_obstructive_pulmonary_disease')
        self.pneumoconiosis = kwargs.get('pneumoconiosis')
        self.silicosis = kwargs.get('silicosis')
        self.asbestosis = kwargs.get('asbestosis')
        self.coal_workers_pneumoconiosis = kwargs.get('coal_workers_pneumoconiosis')
        self.other_pneumoconiosis = kwargs.get('other_pneumoconiosis')
        self.asthma = kwargs.get('asthma')
        self.interstitial_lung_disease_and_pulmonary_sarcoidosis = kwargs.get('interstitial_lung_disease_and_pulmonary_sarcoidosis')
        self.other_chronic_respiratory_diseases = kwargs.get('other_chronic_respiratory_diseases')
        self.cirrhosis_and_other_chronic_liver_diseases = kwargs.get('cirrhosis_and_other_chronic_liver_diseases')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_use = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_use')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_other_causes = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_other_causes')
        self.digestive_diseases = kwargs.get('digestive_diseases')
        self.peptic_ulcer_disease = kwargs.get('peptic_ulcer_disease')
        self.gastritis_and_duodenitis = kwargs.get('gastritis_and_duodenitis')
        self.appendicitis = kwargs.get('appendicitis')
        self.paralytic_ileus_and_intestinal_obstruction = kwargs.get('paralytic_ileus_and_intestinal_obstruction')
        self.inguinal_femoral_and_abdominal_hernia = kwargs.get('inguinal_femoral_and_abdominal_hernia')
        self.inflammatory_bowel_disease = kwargs.get('inflammatory_bowel_disease')
        self.vascular_intestinal_disorders = kwargs.get('vascular_intestinal_disorders')
        self.gallbladder_and_biliary_diseases = kwargs.get('gallbladder_and_biliary_diseases')
        self.pancreatitis = kwargs.get('pancreatitis')
        self.gastroesophageal_reflux_disease = kwargs.get('gastroesophageal_reflux_disease')
        self.other_digestive_diseases = kwargs.get('other_digestive_diseases')
        self.neurological_disorders = kwargs.get('neurological_disorders')
        self.alzheimers_disease_and_other_dementias = kwargs.get('alzheimers_disease_and_other_dementias')
        self.parkinsons_disease = kwargs.get('parkinsons_disease')
        self.idiopathic_epilepsy = kwargs.get('idiopathic_epilepsy')
        self.multiple_sclerosis = kwargs.get('multiple_sclerosis')
        self.migraine = kwargs.get('migraine')
        self.tension_type_headache = kwargs.get('tension_type_headache')
        self.motor_neuron_disease = kwargs.get('motor_neuron_disease')
        self.other_neurological_disorders = kwargs.get('other_neurological_disorders')
        self.mental_disorders = kwargs.get('mental_disorders')
        self.schizophrenia = kwargs.get('schizophrenia')
        self.alcohol_use_disorders = kwargs.get('alcohol_use_disorders')
        self.drug_use_disorders = kwargs.get('drug_use_disorders')
        self.opioid_use_disorders = kwargs.get('opioid_use_disorders')
        self.cocaine_use_disorders = kwargs.get('cocaine_use_disorders')
        self.amphetamine_use_disorders = kwargs.get('amphetamine_use_disorders')
        self.cannabis_use_disorders = kwargs.get('cannabis_use_disorders')
        self.other_drug_use_disorders = kwargs.get('other_drug_use_disorders')
        self.depressive_disorders = kwargs.get('depressive_disorders')
        self.major_depressive_disorder = kwargs.get('major_depressive_disorder')
        self.dysthymia = kwargs.get('dysthymia')
        self.bipolar_disorder = kwargs.get('bipolar_disorder')
        self.anxiety_disorders = kwargs.get('anxiety_disorders')
        self.eating_disorders = kwargs.get('eating_disorders')
        self.anorexia_nervosa = kwargs.get('anorexia_nervosa')
        self.bulimia_nervosa = kwargs.get('bulimia_nervosa')
        self.autism_spectrum_disorders = kwargs.get('autism_spectrum_disorders')
        self.attention_deficit_hyperactivity_disorder = kwargs.get('attention_deficit_hyperactivity_disorder')
        self.conduct_disorder = kwargs.get('conduct_disorder')
        self.idiopathic_developmental_intellectual_disability = kwargs.get('idiopathic_developmental_intellectual_disability')
        self.other_mental_disorders = kwargs.get('other_mental_disorders')
        self.diabetes_mellitus = kwargs.get('diabetes_mellitus')
        self.acute_glomerulonephritis = kwargs.get('acute_glomerulonephritis')
        self.chronic_kidney_disease = kwargs.get('chronic_kidney_disease')
        self.chronic_kidney_disease_due_to_hypertension = kwargs.get('chronic_kidney_disease_due_to_hypertension')
        self.chronic_kidney_disease_due_to_glomerulonephritis = kwargs.get('chronic_kidney_disease_due_to_glomerulonephritis')
        self.chronic_kidney_disease_due_to_other_and_unspecified_causes = kwargs.get('chronic_kidney_disease_due_to_other_and_unspecified_causes')
        self.urinary_diseases_and_male_infertility = kwargs.get('urinary_diseases_and_male_infertility')
        self.urinary_tract_infections_and_interstitial_nephritis = kwargs.get('urinary_tract_infections_and_interstitial_nephritis')
        self.urolithiasis = kwargs.get('urolithiasis')
        self.benign_prostatic_hyperplasia = kwargs.get('benign_prostatic_hyperplasia')
        self.male_infertility = kwargs.get('male_infertility')
        self.other_urinary_diseases = kwargs.get('other_urinary_diseases')
        self.gynecological_diseases = kwargs.get('gynecological_diseases')
        self.uterine_fibroids = kwargs.get('uterine_fibroids')
        self.polycystic_ovarian_syndrome = kwargs.get('polycystic_ovarian_syndrome')
        self.female_infertility = kwargs.get('female_infertility')
        self.endometriosis = kwargs.get('endometriosis')
        self.genital_prolapse = kwargs.get('genital_prolapse')
        self.premenstrual_syndrome = kwargs.get('premenstrual_syndrome')
        self.other_gynecological_diseases = kwargs.get('other_gynecological_diseases')
        self.hemoglobinopathies_and_hemolytic_anemias = kwargs.get('hemoglobinopathies_and_hemolytic_anemias')
        self.thalassemias = kwargs.get('thalassemias')
        self.sickle_cell_disorders = kwargs.get('sickle_cell_disorders')
        self.g6pd_deficiency = kwargs.get('g6pd_deficiency')
        self.other_hemoglobinopathies_and_hemolytic_anemias = kwargs.get('other_hemoglobinopathies_and_hemolytic_anemias')
        self.endocrine_metabolic_blood_and_immune_disorders = kwargs.get('endocrine_metabolic_blood_and_immune_disorders')
        self.musculoskeletal_disorders = kwargs.get('musculoskeletal_disorders')
        self.rheumatoid_arthritis = kwargs.get('rheumatoid_arthritis')
        self.osteoarthritis = kwargs.get('osteoarthritis')
        self.low_back_pain = kwargs.get('low_back_pain')
        self.neck_pain = kwargs.get('neck_pain')
        self.gout = kwargs.get('gout')
        self.other_musculoskeletal_disorders = kwargs.get('other_musculoskeletal_disorders')
        self.other_non_communicable_diseases = kwargs.get('other_non_communicable_diseases')
        self.congenital_birth_defects = kwargs.get('congenital_birth_defects')
        self.neural_tube_defects = kwargs.get('neural_tube_defects')
        self.congenital_heart_anomalies = kwargs.get('congenital_heart_anomalies')
        self.orofacial_clefts = kwargs.get('orofacial_clefts')
        self.down_syndrome = kwargs.get('down_syndrome')
        self.turner_syndrome = kwargs.get('turner_syndrome')
        self.klinefelter_syndrome = kwargs.get('klinefelter_syndrome')
        self.other_chromosomal_abnormalities = kwargs.get('other_chromosomal_abnormalities')
        self.congenital_musculoskeletal_and_limb_anomalies = kwargs.get('congenital_musculoskeletal_and_limb_anomalies')
        self.urogenital_congenital_anomalies = kwargs.get('urogenital_congenital_anomalies')
        self.digestive_congenital_anomalies = kwargs.get('digestive_congenital_anomalies')
        self.other_congenital_birth_defects = kwargs.get('other_congenital_birth_defects')
        self.skin_and_subcutaneous_diseases = kwargs.get('skin_and_subcutaneous_diseases')
        self.dermatitis = kwargs.get('dermatitis')
        self.psoriasis = kwargs.get('psoriasis')
        self.cellulitis = kwargs.get('cellulitis')
        self.pyoderma = kwargs.get('pyoderma')
        self.scabies = kwargs.get('scabies')
        self.fungal_skin_diseases = kwargs.get('fungal_skin_diseases')
        self.viral_skin_diseases = kwargs.get('viral_skin_diseases')
        self.acne_vulgaris = kwargs.get('acne_vulgaris')
        self.alopecia_areata = kwargs.get('alopecia_areata')
        self.pruritus = kwargs.get('pruritus')
        self.urticaria = kwargs.get('urticaria')
        self.decubitus_ulcer = kwargs.get('decubitus_ulcer')
        self.other_skin_and_subcutaneous_diseases = kwargs.get('other_skin_and_subcutaneous_diseases')
        self.sense_organ_diseases = kwargs.get('sense_organ_diseases')
        self.glaucoma = kwargs.get('glaucoma')
        self.cataract = kwargs.get('cataract')
        self.age_related_macular_degeneration = kwargs.get('age_related_macular_degeneration')
        self.age_related_and_other_hearing_loss = kwargs.get('age_related_and_other_hearing_loss')
        self.other_vision_loss = kwargs.get('other_vision_loss')
        self.other_sense_organ_diseases = kwargs.get('other_sense_organ_diseases')
        self.oral_disorders = kwargs.get('oral_disorders')
        self.caries_of_deciduous_teeth = kwargs.get('caries_of_deciduous_teeth')
        self.caries_of_permanent_teeth = kwargs.get('caries_of_permanent_teeth')
        self.periodontal_diseases = kwargs.get('periodontal_diseases')
        self.edentulism = kwargs.get('edentulism')
        self.other_oral_disorders = kwargs.get('other_oral_disorders')
        self.sudden_infant_death_syndrome = kwargs.get('sudden_infant_death_syndrome')
        self.injuries = kwargs.get('injuries')
        self.transport_injuries = kwargs.get('transport_injuries')
        self.road_injuries = kwargs.get('road_injuries')
        self.pedestrian_road_injuries = kwargs.get('pedestrian_road_injuries')
        self.cyclist_road_injuries = kwargs.get('cyclist_road_injuries')
        self.motorcyclist_road_injuries = kwargs.get('motorcyclist_road_injuries')
        self.motor_vehicle_road_injuries = kwargs.get('motor_vehicle_road_injuries')
        self.other_road_injuries = kwargs.get('other_road_injuries')
        self.other_transport_injuries = kwargs.get('other_transport_injuries')
        self.unintentional_injuries = kwargs.get('unintentional_injuries')
        self.falls = kwargs.get('falls')
        self.drowning = kwargs.get('drowning')
        self.fire_heat_and_hot_substances = kwargs.get('fire_heat_and_hot_substances')
        self.poisonings = kwargs.get('poisonings')
        self.poisoning_by_carbon_monoxide = kwargs.get('poisoning_by_carbon_monoxide')
        self.poisoning_by_other_means = kwargs.get('poisoning_by_other_means')
        self.exposure_to_mechanical_forces = kwargs.get('exposure_to_mechanical_forces')
        self.unintentional_firearm_injuries = kwargs.get('unintentional_firearm_injuries')
        self.other_exposure_to_mechanical_forces = kwargs.get('other_exposure_to_mechanical_forces')
        self.adverse_effects_of_medical_treatment = kwargs.get('adverse_effects_of_medical_treatment')
        self.animal_contact = kwargs.get('animal_contact')
        self.venomous_animal_contact = kwargs.get('venomous_animal_contact')
        self.non_venomous_animal_contact = kwargs.get('non_venomous_animal_contact')
        self.foreign_body = kwargs.get('foreign_body')
        self.pulmonary_aspiration_and_foreign_body_in_airway = kwargs.get('pulmonary_aspiration_and_foreign_body_in_airway')
        self.foreign_body_in_eyes = kwargs.get('foreign_body_in_eyes')
        self.foreign_body_in_other_body_part = kwargs.get('foreign_body_in_other_body_part')
        self.other_unintentional_injuries = kwargs.get('other_unintentional_injuries')
        self.self_harm_and_interpersonal_violence = kwargs.get('self_harm_and_interpersonal_violence')
        self.self_harm = kwargs.get('self_harm')
        self.self_harm_by_firearm = kwargs.get('self_harm_by_firearm')
        self.self_harm_by_other_specified_means = kwargs.get('self_harm_by_other_specified_means')
        self.interpersonal_violence = kwargs.get('interpersonal_violence')
        self.physical_violence_by_firearm = kwargs.get('physical_violence_by_firearm')
        self.physical_violence_by_sharp_object = kwargs.get('physical_violence_by_sharp_object')
        self.physical_violence_by_other_means = kwargs.get('physical_violence_by_other_means')
        self.exposure_to_forces_of_nature = kwargs.get('exposure_to_forces_of_nature')
        self.maternal_deaths_aggravated_by_hiv_aids = kwargs.get('maternal_deaths_aggravated_by_hiv_aids')
        self.thalassemias_trait = kwargs.get('thalassemias_trait')
        self.sickle_cell_trait = kwargs.get('sickle_cell_trait')
        self.g6pd_trait = kwargs.get('g6pd_trait')
        self.environmental_heat_and_cold_exposure = kwargs.get('environmental_heat_and_cold_exposure')
        self.ebola = kwargs.get('ebola')
        self.acute_lymphoid_leukemia = kwargs.get('acute_lymphoid_leukemia')
        self.chronic_lymphoid_leukemia = kwargs.get('chronic_lymphoid_leukemia')
        self.acute_myeloid_leukemia = kwargs.get('acute_myeloid_leukemia')
        self.chronic_myeloid_leukemia = kwargs.get('chronic_myeloid_leukemia')
        self.non_melanoma_skin_cancer_squamous_cell_carcinoma = kwargs.get('non_melanoma_skin_cancer_squamous_cell_carcinoma')
        self.non_melanoma_skin_cancer_basal_cell_carcinoma = kwargs.get('non_melanoma_skin_cancer_basal_cell_carcinoma')
        self.executions_and_police_conflict = kwargs.get('executions_and_police_conflict')
        self.drug_susceptible_tuberculosis = kwargs.get('drug_susceptible_tuberculosis')
        self.zika_virus = kwargs.get('zika_virus')
        self.guinea_worm_disease = kwargs.get('guinea_worm_disease')
        self.alcoholic_cardiomyopathy = kwargs.get('alcoholic_cardiomyopathy')
        self.sexual_violence = kwargs.get('sexual_violence')
        self.myocarditis = kwargs.get('myocarditis')
        self.other_leukemia = kwargs.get('other_leukemia')
        self.other_cardiomyopathy = kwargs.get('other_cardiomyopathy')
        self.conflict_and_terrorism = kwargs.get('conflict_and_terrorism')
        self.multidrug_resistant_tuberculosis_without_extensive_drug_resistance = kwargs.get('multidrug_resistant_tuberculosis_without_extensive_drug_resistance')
        self.extensively_drug_resistant_tuberculosis = kwargs.get('extensively_drug_resistant_tuberculosis')
        self.hiv_aids_drug_susceptible_tuberculosis = kwargs.get('hiv_aids_drug_susceptible_tuberculosis')
        self.hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance = kwargs.get('hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance')
        self.hiv_aids_extensively_drug_resistant_tuberculosis = kwargs.get('hiv_aids_extensively_drug_resistant_tuberculosis')
        self.latent_tuberculosis_infection = kwargs.get('latent_tuberculosis_infection')
        self.hiv_aids_and_sexually_transmitted_infections = kwargs.get('hiv_aids_and_sexually_transmitted_infections')
        self.respiratory_infections_and_tuberculosis = kwargs.get('respiratory_infections_and_tuberculosis')
        self.enteric_infections = kwargs.get('enteric_infections')
        self.typhoid_and_paratyphoid = kwargs.get('typhoid_and_paratyphoid')
        self.invasive_non_typhoidal_salmonella_ints = kwargs.get('invasive_non_typhoidal_salmonella_ints')
        self.other_infectious_diseases = kwargs.get('other_infectious_diseases')
        self.maternal_and_neonatal_disorders = kwargs.get('maternal_and_neonatal_disorders')
        self.myelodysplastic_myeloproliferative_and_other_hematopoietic_neoplasms = kwargs.get('myelodysplastic_myeloproliferative_and_other_hematopoietic_neoplasms')
        self.benign_and_in_situ_intestinal_neoplasms = kwargs.get('benign_and_in_situ_intestinal_neoplasms')
        self.benign_and_in_situ_cervical_and_uterine_neoplasms = kwargs.get('benign_and_in_situ_cervical_and_uterine_neoplasms')
        self.other_benign_and_in_situ_neoplasms = kwargs.get('other_benign_and_in_situ_neoplasms')
        self.non_rheumatic_calcific_aortic_valve_disease = kwargs.get('non_rheumatic_calcific_aortic_valve_disease')
        self.non_rheumatic_degenerative_mitral_valve_disease = kwargs.get('non_rheumatic_degenerative_mitral_valve_disease')
        self.other_non_rheumatic_valve_diseases = kwargs.get('other_non_rheumatic_valve_diseases')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_nafld = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_nafld')
        self.headache_disorders = kwargs.get('headache_disorders')
        self.substance_use_disorders = kwargs.get('substance_use_disorders')
        self.diabetes_and_kidney_diseases = kwargs.get('diabetes_and_kidney_diseases')
        self.diabetes_mellitus_type_1 = kwargs.get('diabetes_mellitus_type_1')
        self.diabetes_mellitus_type_2 = kwargs.get('diabetes_mellitus_type_2')
        self.atopic_dermatitis = kwargs.get('atopic_dermatitis')
        self.contact_dermatitis = kwargs.get('contact_dermatitis')
        self.seborrhoeic_dermatitis = kwargs.get('seborrhoeic_dermatitis')
        self.bacterial_skin_diseases = kwargs.get('bacterial_skin_diseases')
        self.blindness_and_vision_loss = kwargs.get('blindness_and_vision_loss')
        self.upper_digestive_system_diseases = kwargs.get('upper_digestive_system_diseases')
        self.maternal_abortion_and_miscarriage = kwargs.get('maternal_abortion_and_miscarriage')
        self.liver_cancer_due_to_nash = kwargs.get('liver_cancer_due_to_nash')
        self.chronic_kidney_disease_due_to_diabetes_mellitus_type_1 = kwargs.get('chronic_kidney_disease_due_to_diabetes_mellitus_type_1')
        self.chronic_kidney_disease_due_to_diabetes_mellitus_type_2 = kwargs.get('chronic_kidney_disease_due_to_diabetes_mellitus_type_2')
        self.refraction_disorders = kwargs.get('refraction_disorders')
        self.near_vision_loss = kwargs.get('near_vision_loss')
        self.osteoarthritis_hip = kwargs.get('osteoarthritis_hip')
        self.osteoarthritis_knee = kwargs.get('osteoarthritis_knee')
        self.osteoarthritis_hand = kwargs.get('osteoarthritis_hand')
        self.osteoarthritis_other = kwargs.get('osteoarthritis_other')
        self.liver_cancer_due_to_other_causes = kwargs.get('liver_cancer_due_to_other_causes')
        self.other_malignant_neoplasms = kwargs.get('other_malignant_neoplasms')
        self.other_cardiovascular_and_circulatory_diseases = kwargs.get('other_cardiovascular_and_circulatory_diseases')
        self.total_burden_related_to_hepatitis_b = kwargs.get('total_burden_related_to_hepatitis_b')
        self.total_burden_related_to_hepatitis_c = kwargs.get('total_burden_related_to_hepatitis_c')
        self.total_burden_related_to_non_alcoholic_fatty_liver_disease_nafld = kwargs.get('total_burden_related_to_non_alcoholic_fatty_liver_disease_nafld')
        self.total_cancers = kwargs.get('total_cancers')
