# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class RouteGroup(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        RouteGroup - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'attributes': 'RouteGroupAttributes',
            'offered_per_interval': 'list[float]',
            'average_talk_time_seconds_per_interval': 'list[float]',
            'average_after_call_work_seconds_per_interval': 'list[float]',
            'completed_per_interval': 'list[float]',
            'abandoned_per_interval': 'list[float]'
        }

        self.attribute_map = {
            'attributes': 'attributes',
            'offered_per_interval': 'offeredPerInterval',
            'average_talk_time_seconds_per_interval': 'averageTalkTimeSecondsPerInterval',
            'average_after_call_work_seconds_per_interval': 'averageAfterCallWorkSecondsPerInterval',
            'completed_per_interval': 'completedPerInterval',
            'abandoned_per_interval': 'abandonedPerInterval'
        }

        self._attributes = None
        self._offered_per_interval = None
        self._average_talk_time_seconds_per_interval = None
        self._average_after_call_work_seconds_per_interval = None
        self._completed_per_interval = None
        self._abandoned_per_interval = None

    @property
    def attributes(self):
        """
        Gets the attributes of this RouteGroup.
        The attributes that describe this route group

        :return: The attributes of this RouteGroup.
        :rtype: RouteGroupAttributes
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes):
        """
        Sets the attributes of this RouteGroup.
        The attributes that describe this route group

        :param attributes: The attributes of this RouteGroup.
        :type: RouteGroupAttributes
        """
        
        self._attributes = attributes

    @property
    def offered_per_interval(self):
        """
        Gets the offered_per_interval of this RouteGroup.
        Interactions offered per 15 minute interval

        :return: The offered_per_interval of this RouteGroup.
        :rtype: list[float]
        """
        return self._offered_per_interval

    @offered_per_interval.setter
    def offered_per_interval(self, offered_per_interval):
        """
        Sets the offered_per_interval of this RouteGroup.
        Interactions offered per 15 minute interval

        :param offered_per_interval: The offered_per_interval of this RouteGroup.
        :type: list[float]
        """
        
        self._offered_per_interval = offered_per_interval

    @property
    def average_talk_time_seconds_per_interval(self):
        """
        Gets the average_talk_time_seconds_per_interval of this RouteGroup.
        Average talk time in seconds per 15 minute interval

        :return: The average_talk_time_seconds_per_interval of this RouteGroup.
        :rtype: list[float]
        """
        return self._average_talk_time_seconds_per_interval

    @average_talk_time_seconds_per_interval.setter
    def average_talk_time_seconds_per_interval(self, average_talk_time_seconds_per_interval):
        """
        Sets the average_talk_time_seconds_per_interval of this RouteGroup.
        Average talk time in seconds per 15 minute interval

        :param average_talk_time_seconds_per_interval: The average_talk_time_seconds_per_interval of this RouteGroup.
        :type: list[float]
        """
        
        self._average_talk_time_seconds_per_interval = average_talk_time_seconds_per_interval

    @property
    def average_after_call_work_seconds_per_interval(self):
        """
        Gets the average_after_call_work_seconds_per_interval of this RouteGroup.
        Average after call work in seconds per 15 minute interval

        :return: The average_after_call_work_seconds_per_interval of this RouteGroup.
        :rtype: list[float]
        """
        return self._average_after_call_work_seconds_per_interval

    @average_after_call_work_seconds_per_interval.setter
    def average_after_call_work_seconds_per_interval(self, average_after_call_work_seconds_per_interval):
        """
        Sets the average_after_call_work_seconds_per_interval of this RouteGroup.
        Average after call work in seconds per 15 minute interval

        :param average_after_call_work_seconds_per_interval: The average_after_call_work_seconds_per_interval of this RouteGroup.
        :type: list[float]
        """
        
        self._average_after_call_work_seconds_per_interval = average_after_call_work_seconds_per_interval

    @property
    def completed_per_interval(self):
        """
        Gets the completed_per_interval of this RouteGroup.
        Interactions completed per 15 minute interval

        :return: The completed_per_interval of this RouteGroup.
        :rtype: list[float]
        """
        return self._completed_per_interval

    @completed_per_interval.setter
    def completed_per_interval(self, completed_per_interval):
        """
        Sets the completed_per_interval of this RouteGroup.
        Interactions completed per 15 minute interval

        :param completed_per_interval: The completed_per_interval of this RouteGroup.
        :type: list[float]
        """
        
        self._completed_per_interval = completed_per_interval

    @property
    def abandoned_per_interval(self):
        """
        Gets the abandoned_per_interval of this RouteGroup.
        Interactions abandoned per 15 minute interval

        :return: The abandoned_per_interval of this RouteGroup.
        :rtype: list[float]
        """
        return self._abandoned_per_interval

    @abandoned_per_interval.setter
    def abandoned_per_interval(self, abandoned_per_interval):
        """
        Sets the abandoned_per_interval of this RouteGroup.
        Interactions abandoned per 15 minute interval

        :param abandoned_per_interval: The abandoned_per_interval of this RouteGroup.
        :type: list[float]
        """
        
        self._abandoned_per_interval = abandoned_per_interval

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

