# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class DownloadResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        DownloadResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'content_location_uri': 'str',
            'image_uri': 'str',
            'thumbnails': 'list[DocumentThumbnail]'
        }

        self.attribute_map = {
            'content_location_uri': 'contentLocationUri',
            'image_uri': 'imageUri',
            'thumbnails': 'thumbnails'
        }

        self._content_location_uri = None
        self._image_uri = None
        self._thumbnails = None

    @property
    def content_location_uri(self):
        """
        Gets the content_location_uri of this DownloadResponse.


        :return: The content_location_uri of this DownloadResponse.
        :rtype: str
        """
        return self._content_location_uri

    @content_location_uri.setter
    def content_location_uri(self, content_location_uri):
        """
        Sets the content_location_uri of this DownloadResponse.


        :param content_location_uri: The content_location_uri of this DownloadResponse.
        :type: str
        """
        
        self._content_location_uri = content_location_uri

    @property
    def image_uri(self):
        """
        Gets the image_uri of this DownloadResponse.


        :return: The image_uri of this DownloadResponse.
        :rtype: str
        """
        return self._image_uri

    @image_uri.setter
    def image_uri(self, image_uri):
        """
        Sets the image_uri of this DownloadResponse.


        :param image_uri: The image_uri of this DownloadResponse.
        :type: str
        """
        
        self._image_uri = image_uri

    @property
    def thumbnails(self):
        """
        Gets the thumbnails of this DownloadResponse.


        :return: The thumbnails of this DownloadResponse.
        :rtype: list[DocumentThumbnail]
        """
        return self._thumbnails

    @thumbnails.setter
    def thumbnails(self, thumbnails):
        """
        Sets the thumbnails of this DownloadResponse.


        :param thumbnails: The thumbnails of this DownloadResponse.
        :type: list[DocumentThumbnail]
        """
        
        self._thumbnails = thumbnails

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

